/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.DiscreteDecisionNode;
import COM.hugin.HAPI.DiscreteNode;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.NetworkModel;
import COM.hugin.HAPI.Table;
import COM.hugin.HGUI.BeliefBarD;
import COM.hugin.HGUI.BeliefBarDCNodePainter;
import COM.hugin.HGUI.BeliefBarDDNodePainter;
import COM.hugin.HGUI.BeliefBarNode;
import COM.hugin.HGUI.BeliefBarTree;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIFrame;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.NodeGroup;
import COM.hugin.HGUI.Preferences;
import java.awt.Color;
import javax.swing.tree.TreePath;

class BeliefBarDNode
extends BeliefBarNode {
    double maxValue = Double.MIN_VALUE;
    boolean isLIMIDs;
    public Color utilityColor;

    public DiscreteNode getNode() {
        return (DiscreteNode)this.node;
    }

    public DiscreteNode getOriginalNode() {
        return (DiscreteNode)this.originalNode;
    }

    public BeliefBarDNode(DiscreteNode discreteNode, DiscreteNode discreteNode2, String string, Preferences preferences) throws ExceptionHugin {
        String string2;
        Object object;
        this.preferences = preferences;
        this.color = preferences.barColors.get(0);
        this.utilityColor = preferences.barColors.get(5);
        this.domain = discreteNode.getHomeDomain();
        this.originalNode = discreteNode2;
        this.name = string == null ? HuginGUIUtils.getNodeTitle(discreteNode2) : string;
        this.node = discreteNode;
        NetworkModel networkModel = discreteNode2.getHome();
        String string3 = discreteNode2.getAttribute("HR_Grp");
        if (string3 != null && string3.length() > 0) {
            object = networkModel.getAttribute("HR_Groups_GroupColors");
            int n = Integer.parseInt(string3);
            string2 = ((String)object).substring(n * 2, n * 2 + 2);
            this.groupColor = NodeGroup.index2color(Integer.parseInt(string2));
        } else {
            this.groupColor = null;
        }
        object = HuginGUIFrame.getProjectFrame(networkModel);
        Node node = null;
        if (object != null) {
            node = ((HuginProjectFrame)object).networkPanel.getNode(discreteNode2.getName());
        }
        if (node != null) {
            this.groupColor = node.getGroupIndex() >= 0 ? node.fillColor : null;
        }
        this.isLIMIDs = ((HuginProjectFrame)object).networkPanel.isLIMIDs();
        string2 = networkModel.getAttribute("HR_Monitor_Chance_Utility");
        if (discreteNode instanceof DiscreteChanceNode && string2 != null && string2.length() > 0) {
            boolean bl = this.isLIMIDs = Integer.parseInt(string2) == 1 ? this.isLIMIDs : false;
        }
        if (this.isLIMIDs) {
            int n = discreteNode.getNumberOfStates();
            for (int i = 0; i < n; ++i) {
                double d = discreteNode.getExpectedUtility(i);
                this.add(new BeliefBarD(this, HuginGUIUtils.getNodeStateLabel(discreteNode, i), discreteNode.getBelief(i), d, i, true));
                this.maxValue = Math.max(this.maxValue, Math.abs(d));
            }
        } else {
            int n = discreteNode.getNumberOfStates();
            for (int i = 0; i < n; ++i) {
                this.add(new BeliefBarD(this, HuginGUIUtils.getNodeStateLabel(discreteNode, i), discreteNode.getBelief(i), 0.0, i, false));
            }
        }
        this.painter = discreteNode instanceof DiscreteDecisionNode ? new BeliefBarDDNodePainter(this) : new BeliefBarDCNodePainter(this);
    }

    boolean possibleEvidence() {
        int n = 0;
        try {
            DiscreteNode discreteNode = this.getNode();
            int n2 = discreteNode.getNumberOfStates();
            for (int i = 0; i < n2; ++i) {
                if (!(discreteNode.getEnteredFinding(i) > 0.0)) continue;
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n <= 1;
    }

    public void updateColors() {
        super.updateColors();
        this.utilityColor = this.preferences.barColors.get(5);
    }

    public void update() {
        try {
            this.maxValue = Double.MIN_VALUE;
            DiscreteNode discreteNode = this.getNode();
            int n = discreteNode.getNumberOfStates();
            for (int i = 0; i < n; ++i) {
                BeliefBarD beliefBarD = (BeliefBarD)this.getChildAt(i);
                beliefBarD.updateBelief(discreteNode.getBelief(beliefBarD.state));
                if (!this.isLIMIDs) continue;
                double d = discreteNode.getExpectedUtility(beliefBarD.state);
                this.maxValue = Math.max(this.maxValue, Math.abs(d));
                beliefBarD.updateUtility(d);
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    public void setSelectedNode(COM.hugin.HAPI.Node node, BeliefBarTree beliefBarTree) {
        if (this.node == node) {
            beliefBarTree.selected = this;
            beliefBarTree.setSelectionPath(new TreePath(this.painter.getOwner().getPath()));
            return;
        }
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            ((BeliefBarNode)this.getChildAt(i)).setSelectedNode(node, beliefBarTree);
        }
    }

    public void transferTableToClass() {
        try {
            DiscreteNode discreteNode = this.getNode();
            DiscreteNode discreteNode2 = this.getOriginalNode();
            if (!discreteNode.isAlive() || !discreteNode2.isAlive()) {
                return;
            }
            Table table = discreteNode2.getTable();
            Table table2 = discreteNode.getTable();
            if (table.getSize() == table2.getSize()) {
                table.update(table2);
                if (discreteNode instanceof DiscreteChanceNode) {
                    if (((DiscreteChanceNode)discreteNode).hasExperienceTable()) {
                        ((DiscreteChanceNode)discreteNode2).getExperienceTable().update(((DiscreteChanceNode)discreteNode).getExperienceTable());
                    }
                    if (((DiscreteChanceNode)discreteNode).hasFadingTable()) {
                        ((DiscreteChanceNode)discreteNode2).getFadingTable().update(((DiscreteChanceNode)discreteNode).getFadingTable());
                    }
                }
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    protected boolean containsEvidence() throws ExceptionHugin {
        return this.node.evidenceIsEntered();
    }

    protected boolean containsLikelihood() throws ExceptionHugin {
        return this.node.likelihoodIsEntered();
    }

    public String toString() {
        return HuginGUIConstants.get("str_name_") + this.name + "\n" + HuginGUIConstants.get("str_selected_") + this.painter.selected + "\n" + HuginGUIConstants.get("str_node_") + this.node + "\n" + HuginGUIConstants.get("str_domain_") + this.domain + "\n";
    }
}

