/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.Class;
import COM.hugin.HAPI.ContinuousChanceNode;
import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.DiscreteDecisionNode;
import COM.hugin.HAPI.DiscreteNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.FunctionNode;
import COM.hugin.HAPI.InstanceNode;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HAPI.UtilityNode;
import COM.hugin.HGUI.BeliefBarCCNode;
import COM.hugin.HGUI.BeliefBarCompNode;
import COM.hugin.HGUI.BeliefBarDNode;
import COM.hugin.HGUI.BeliefBarFunctionNode;
import COM.hugin.HGUI.BeliefBarNodePainter;
import COM.hugin.HGUI.BeliefBarRootNode;
import COM.hugin.HGUI.BeliefBarTree;
import COM.hugin.HGUI.BeliefBarUtilityNode;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.Preferences;
import java.awt.Color;
import java.awt.Graphics;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeliefBarNode
extends DefaultMutableTreeNode {
    String name;
    BeliefBarNodePainter painter;
    Color color;
    Color groupColor;
    BeliefBarNode owner;
    Domain domain;
    Preferences preferences;
    boolean expanded;
    private int cachedShowPrivate = 3;
    Node guiNode;
    COM.hugin.HAPI.Node node;
    COM.hugin.HAPI.Node originalNode;
    static final int BELIEF_BAR = 0;
    static final int FINDING_BAR = 1;
    static final int INCONSISTENT_BAR = 2;
    static final int LIKELIHOOD_BAR = 3;
    static final int LOCKED_EVIDENCE_BAR = 4;
    static final int UTILITY_BAR = 5;
    static final int FUNCTION_BAR = 6;

    public BeliefBarNodePainter getPainter() {
        return this.painter;
    }

    public int getWidth() {
        return this.painter.getWidth();
    }

    public int getWidth(Graphics graphics) {
        return this.painter.getWidth(graphics);
    }

    public void isExpanded(boolean bl) {
        this.expanded = bl;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void update() {
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            ((BeliefBarNode)this.getChildAt(i)).update();
        }
    }

    public COM.hugin.HAPI.Node getNode() {
        return this.node;
    }

    public String getName() throws ExceptionHugin {
        return this.name;
    }

    public COM.hugin.HAPI.Node getOriginalNode() {
        return this.originalNode;
    }

    public void transferTableToClass() {
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            ((BeliefBarNode)this.getChildAt(i)).transferTableToClass();
        }
    }

    public void updateColors() {
        this.color = this.preferences.barColors.get(0);
    }

    public void setSelectedNode(COM.hugin.HAPI.Node node, BeliefBarTree beliefBarTree) {
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            ((BeliefBarNode)this.getChildAt(i)).setSelectedNode(node, beliefBarTree);
        }
    }

    public void showPrivate(boolean bl) throws ExceptionHugin {
        this.getOriginalNode().setAttribute("HR_Node_showPrivate", bl ? "1" : "0");
        this.cachedShowPrivate = 3;
    }

    public boolean showPrivate() throws ExceptionHugin {
        if (this.cachedShowPrivate == 3) {
            String string = this.getOriginalNode().getAttribute("HR_Node_showPrivate");
            if (string == null || string.trim().length() == 0 || string.trim().equals("1")) {
                this.cachedShowPrivate = 1;
                return true;
            }
            this.cachedShowPrivate = 2;
            return false;
        }
        return this.cachedShowPrivate == 1;
    }

    public boolean isPrivate() throws ExceptionHugin {
        COM.hugin.HAPI.Node node = this.getOriginalNode();
        if (node == null) {
            return false;
        }
        Class clazz = node.getHomeClass();
        return !clazz.getOutputs().contains(node) && !clazz.getInputs().contains(node);
    }

    protected void getAllPaths(BeliefBarTree beliefBarTree, Collection<TreePath> collection) {
        try {
            if (this.children == null) {
                return;
            }
            if (((BeliefBarNode)this.children.get((int)0)).children == null) {
                collection.add(new TreePath(((DefaultTreeModel)beliefBarTree.getModel()).getPathToRoot(this)));
            } else {
                ListIterator listIterator = this.children.listIterator();
                while (listIterator.hasNext()) {
                    ((BeliefBarNode)listIterator.next()).getAllPaths(beliefBarTree, collection);
                }
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    protected void buildBeliefBarEntries(BeliefBarRootNode beliefBarRootNode, Domain domain, Class clazz, NodeList nodeList) throws ExceptionHugin, OutOfMemoryError {
        Cloneable cloneable;
        Iterator<Cloneable> iterator;
        String string = clazz != null ? clazz.getName() : "Domain";
        BeliefBarEntry beliefBarEntry = new BeliefBarEntry(string);
        Object object2 = domain.getNodes();
        int n = 0;
        if (clazz != null) {
            if (nodeList != null) {
                iterator = new NodeList();
                Iterator object3 = ((AbstractSequentialList)object2).iterator();
                block0: while (object3.hasNext()) {
                    cloneable = (COM.hugin.HAPI.Node)object3.next();
                    NodeList nodeList2 = ((COM.hugin.HAPI.Node)cloneable).getSource();
                    for (int i = 0; i < nodeList2.size(); ++i) {
                        if (i == nodeList.size()) {
                            ((LinkedList)((Object)iterator)).add(cloneable);
                            continue block0;
                        }
                        if (nodeList2.get(i) != nodeList.get(i)) continue block0;
                    }
                }
                n = nodeList.size();
                object2 = iterator;
            }
            iterator = ((AbstractSequentialList)object2).iterator();
            while (iterator.hasNext()) {
                COM.hugin.HAPI.Node node = (COM.hugin.HAPI.Node)iterator.next();
                node.setUserData(node.getSource());
                cloneable = node.getSource();
                for (int i = 0; i < n; ++i) {
                    ((LinkedList)cloneable).removeFirst();
                }
                beliefBarRootNode.addDomainNodeMapping((NodeList)cloneable, node);
                beliefBarEntry.add((NodeList)cloneable, node);
            }
            this.buildBoundInputEntries(beliefBarRootNode, beliefBarEntry, clazz, new NodeList(), nodeList != null ? nodeList : new NodeList());
        } else {
            iterator = new NodeList();
            Iterator iterator2 = ((AbstractSequentialList)object2).iterator();
            while (iterator2.hasNext()) {
                cloneable = (COM.hugin.HAPI.Node)iterator2.next();
                ((LinkedList)((Object)iterator)).add((COM.hugin.HAPI.Node)cloneable);
                beliefBarRootNode.addDomainNodeMapping((NodeList)((Object)iterator), (COM.hugin.HAPI.Node)cloneable);
                ((LinkedList)((Object)iterator)).remove(cloneable);
                beliefBarEntry.add(null, (COM.hugin.HAPI.Node)cloneable);
            }
        }
        beliefBarEntry.sort();
        for (BeliefBarEntry beliefBarEntry2 : beliefBarEntry.entries) {
            this.createBeliefBarNodes(beliefBarEntry2);
        }
    }

    private void buildBoundInputEntries(BeliefBarRootNode beliefBarRootNode, BeliefBarEntry beliefBarEntry, Class clazz, NodeList nodeList, NodeList nodeList2) throws ExceptionHugin {
        for (COM.hugin.HAPI.Node node : clazz.getNodes()) {
            if (!(node instanceof InstanceNode)) continue;
            InstanceNode instanceNode = (InstanceNode)node;
            nodeList.add(instanceNode);
            for (COM.hugin.HAPI.Node node2 : instanceNode.getInstanceClass().getInputs()) {
                COM.hugin.HAPI.Node node3;
                COM.hugin.HAPI.Node node4 = instanceNode.getInput(node2);
                if (node4 == null) continue;
                NodeList nodeList3 = (NodeList)nodeList.clone();
                nodeList3.removeLast();
                while ((node3 = node4.getMaster()) != null) {
                    nodeList3.add(node4.getInstance());
                    node4 = node3;
                }
                nodeList3.add(node4);
                node3 = beliefBarRootNode.getDomainNodeFor2(nodeList3);
                nodeList.add(node2);
                NodeList nodeList4 = (NodeList)nodeList.clone();
                for (COM.hugin.HAPI.Node node5 : nodeList2) {
                    if (nodeList4.getFirst() == node5) {
                        nodeList4.removeFirst();
                        continue;
                    }
                    nodeList4 = null;
                    break;
                }
                if (nodeList4 != null) {
                    beliefBarRootNode.addDomainNodeMapping(nodeList, node3);
                    beliefBarEntry.add((NodeList)nodeList4.clone(), node3);
                }
                nodeList.remove(node2);
            }
            this.buildBoundInputEntries(beliefBarRootNode, beliefBarEntry, instanceNode.getInstanceClass(), nodeList, nodeList2);
            nodeList.remove(instanceNode);
        }
    }

    void createBeliefBarNodes(BeliefBarEntry beliefBarEntry) throws ExceptionHugin {
        if (beliefBarEntry.node instanceof InstanceNode) {
            BeliefBarCompNode beliefBarCompNode = new BeliefBarCompNode((InstanceNode)beliefBarEntry.node, HuginGUIUtils.getNodeTitle(beliefBarEntry.node), this.domain, this.preferences, null);
            this.add(beliefBarCompNode);
            for (BeliefBarEntry beliefBarEntry2 : beliefBarEntry.entries) {
                beliefBarCompNode.createBeliefBarNodes(beliefBarEntry2);
            }
        } else if (beliefBarEntry.node instanceof DiscreteChanceNode || beliefBarEntry.node instanceof DiscreteDecisionNode) {
            this.add(new BeliefBarDNode((DiscreteNode)beliefBarEntry.domainNode, (DiscreteNode)beliefBarEntry.node, HuginGUIUtils.getNodeTitle(beliefBarEntry.node), this.preferences));
        } else if (beliefBarEntry.node instanceof UtilityNode) {
            this.add(new BeliefBarUtilityNode((UtilityNode)beliefBarEntry.domainNode, (UtilityNode)beliefBarEntry.node, HuginGUIUtils.getNodeTitle(beliefBarEntry.node), this.preferences));
        } else if (beliefBarEntry.node instanceof FunctionNode) {
            this.add(new BeliefBarFunctionNode((FunctionNode)beliefBarEntry.domainNode, (FunctionNode)beliefBarEntry.node, HuginGUIUtils.getNodeTitle(beliefBarEntry.node), this.preferences));
        } else if (beliefBarEntry.node instanceof ContinuousChanceNode) {
            this.add(new BeliefBarCCNode((ContinuousChanceNode)beliefBarEntry.domainNode, (ContinuousChanceNode)beliefBarEntry.node, HuginGUIUtils.getNodeTitle(beliefBarEntry.node), this.preferences));
        }
    }

    protected boolean containsEvidence() throws ExceptionHugin {
        return false;
    }

    protected boolean containsLikelihood() throws ExceptionHugin {
        return false;
    }

    @Override
    public String toString() {
        String string = HuginGUIConstants.get("str_name___ARG0", new String[]{this.name});
        return string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BeliefBarEntry
    implements Comparable<BeliefBarEntry> {
        LinkedList<BeliefBarEntry> entries = new LinkedList();
        COM.hugin.HAPI.Node node;
        COM.hugin.HAPI.Node domainNode;
        BeliefBarEntry comparer;
        boolean isRoot = false;

        public BeliefBarEntry(String string) {
            this.isRoot = true;
        }

        private BeliefBarEntry() {
        }

        private BeliefBarEntry(NodeList nodeList, COM.hugin.HAPI.Node node) throws ExceptionHugin {
            if (nodeList != null) {
                this.node = (COM.hugin.HAPI.Node)nodeList.getFirst();
                nodeList.removeFirst();
                if (nodeList.size() > 0) {
                    this.add(nodeList, node);
                } else {
                    this.domainNode = node;
                }
            } else {
                this.node = node;
                this.domainNode = node;
            }
        }

        public void add(NodeList nodeList, COM.hugin.HAPI.Node node) throws ExceptionHugin {
            if (nodeList != null && nodeList.size() > 1) {
                if (this.comparer == null) {
                    this.comparer = new BeliefBarEntry();
                }
                this.comparer.node = (COM.hugin.HAPI.Node)nodeList.getFirst();
                int n = this.entries.indexOf(this.comparer);
                if (n >= 0) {
                    nodeList.removeFirst();
                    this.entries.get(n).add(nodeList, node);
                    return;
                }
            }
            this.entries.add(new BeliefBarEntry(nodeList, node));
        }

        public void sort() {
            Collections.sort(this.entries);
            for (BeliefBarEntry beliefBarEntry : this.entries) {
                beliefBarEntry.sort();
            }
        }

        public String toString() {
            try {
                String string = this.node == null ? HuginGUIConstants.get("str_root") : this.node.getName() + "\n";
                for (BeliefBarEntry beliefBarEntry : this.entries) {
                    string = string + beliefBarEntry.toString("  ");
                }
                return string;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return HuginGUIConstants.get("str_error");
            }
        }

        public String toString(String string) {
            try {
                String string2 = string + this.node.getName() + "(" + this.entries.size() + ")\n";
                for (BeliefBarEntry beliefBarEntry : this.entries) {
                    string2 = string2 + beliefBarEntry.toString(string + "  ");
                }
                return string2;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return HuginGUIConstants.get("str_error");
            }
        }

        @Override
        public int compareTo(BeliefBarEntry beliefBarEntry) {
            try {
                String string = this.node.getAttribute("HR_Grp");
                String string2 = beliefBarEntry.node.getAttribute("HR_Grp");
                if (string == null) {
                    string = "-1";
                }
                if (string2 == null) {
                    string2 = "-1";
                }
                if (!string.equals(string2)) {
                    return string2.compareTo(string);
                }
                if (this.node.getCategory() == beliefBarEntry.node.getCategory()) {
                    String string3 = HuginGUIUtils.getNodeTitle(this.node);
                    String string4 = HuginGUIUtils.getNodeTitle(beliefBarEntry.node);
                    return string3.compareTo(string4);
                }
                return this.node.getCategory().compareTo(beliefBarEntry.node.getCategory());
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return 0;
            }
        }

        public boolean equals(Object object) {
            if (object instanceof BeliefBarEntry) {
                return this.node == ((BeliefBarEntry)object).node;
            }
            if (object instanceof COM.hugin.HAPI.Node) {
                return this.node == object;
            }
            return false;
        }
    }
}

