/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.Class;
import COM.hugin.HAPI.ContinuousChanceNode;
import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.DiscreteNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExceptionIO;
import COM.hugin.HAPI.ExceptionParse;
import COM.hugin.HAPI.ExceptionSizeTooLarge;
import COM.hugin.HAPI.IntervalDCNode;
import COM.hugin.HAPI.IntervalDDNode;
import COM.hugin.HAPI.JunctionTree;
import COM.hugin.HAPI.NetworkModel;
import COM.hugin.HAPI.Node;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HAPI.ParseListener;
import COM.hugin.HAPI.UtilityNode;
import COM.hugin.HGUI.BeliefBarCompNodePainter;
import COM.hugin.HGUI.BeliefBarNode;
import COM.hugin.HGUI.BeliefBarNodePainter;
import COM.hugin.HGUI.BeliefBarTree;
import COM.hugin.HGUI.CompilationAbortedException;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginFileLoader;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.NetworkPanel;
import COM.hugin.HGUI.Preferences;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

class BeliefBarRootNode
extends BeliefBarNode {
    BeliefBarTree theTree;
    NetworkModel homeClass;
    NetworkPanel network;
    HashMap<Node, Node> classNodeToDomainNode;
    HashMap<String, Node> classNodeNameToDomainNode;
    boolean minimized = false;
    NodeList traverseRootPath;

    public BeliefBarRootNode(NetworkPanel networkPanel, Preferences preferences, Domain domain, NodeList nodeList) throws ExceptionHugin {
        this.color = Color.white;
        this.homeClass = networkPanel.getHome();
        this.name = nodeList != null && nodeList.size() > 0 ? ((Node)nodeList.getLast()).getName() : (this.homeClass != null && this.homeClass instanceof Class ? ((Class)this.homeClass).getName() : "Domain");
        this.network = networkPanel;
        this.traverseRootPath = nodeList;
        this.domain = domain != null ? domain : (this.homeClass instanceof Domain ? (Domain)this.homeClass : HuginGUIUtils.createDomain((Class)this.homeClass));
        try {
            if (nodeList == null) {
                this.domain.openLogFile(networkPanel.projectFrame.getLogFile().getPath(), true);
            }
        }
        catch (ExceptionIO exceptionIO) {
            // empty catch block
        }
        this.preferences = preferences;
    }

    public boolean initialize() throws ExceptionHugin, CompilationAbortedException {
        boolean bl = this.traverseRootPath != null;
        boolean bl2 = this.domain.isTriangulated();
        if (bl || bl2 || this.prepareDomain(this.network, this.preferences, this.domain)) {
            if (!bl && !bl2) {
                this.optimizeDomain(this.network, this.preferences, this.domain);
            }
            if (bl2) {
                this.network.containsUncompiledChanges(false);
            }
            this.classNodeNameToDomainNode = new HashMap();
            this.classNodeToDomainNode = new HashMap();
            if (this.homeClass instanceof Domain) {
                this.buildBeliefBarEntries(this, this.domain, null, this.traverseRootPath);
            } else {
                this.buildBeliefBarEntries(this, this.domain, (Class)this.homeClass, this.traverseRootPath);
            }
            if (this.minimized) {
                this.network.updateMinimizedDomain(this.domain);
                this.network.projectFrame.stopBlinker();
            }
            if (this.network.containsCDVTLinks()) {
                for (Node node : this.domain.getNodes()) {
                    if (!(node instanceof ContinuousChanceNode)) continue;
                    ((ContinuousChanceNode)node).setAlpha(((ContinuousChanceNode)node).getAlpha(0), 0);
                }
            }
        } else {
            throw new CompilationAbortedException(HuginGUIConstants.get("str_compilation_process_aborted_by_user"));
        }
        this.painter = new BeliefBarCompNodePainter(this);
        BeliefBarNodePainter.space = this.painter.initialSpace + this.preferences.precision * this.painter.numberWidth;
        return true;
    }

    protected void optimizeDomain(NetworkPanel networkPanel, Preferences preferences, Domain domain) throws ExceptionHugin {
        String string;
        String string2;
        networkPanel.containsUncompiledChanges(false);
        String string3 = domain.getAttribute("HR_Compile_Approximate");
        if (string3 != null && string3.equals("1")) {
            string2 = domain.getAttribute("HR_Compile_ApproxEpsilon");
            double d = Double.parseDouble("0.00001");
            if (string2 != null) {
                d = Double.parseDouble(string2);
            }
            Hugin.mainFrame.statusBar.write(HuginGUIConstants.get("str_approximation_ARG0", new String[]{"" + HuginGUIUtils.printDouble(domain.approximate(d), 6)}));
        }
        if ((string2 = domain.getAttribute("HR_Compile_Compress")) != null && string2.equals("1") && !networkPanel.containsContinuousNodes() && !networkPanel.isLIMIDs()) {
            Hugin.mainFrame.statusBar.write(HuginGUIConstants.get("str_compression_rate_ARG0", new String[]{"" + HuginGUIUtils.printDouble(domain.compress(), 6)}));
        }
        if ((string = domain.getAttribute("HR_Compile_SaveToMemory")) != null && string.equals("1")) {
            try {
                domain.saveToMemory();
                Hugin.mainFrame.statusBar.write(HuginGUIConstants.get("str_saveToMemory_operation_succeed"));
            }
            catch (ExceptionHugin exceptionHugin) {
                Hugin.mainFrame.statusBar.write(HuginGUIConstants.get("str_saveToMemory_operation_failed\n" + exceptionHugin.getMessage()));
            }
        }
        try {
            HuginGUIUtils.configureDomain(domain);
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean prepareDomain(NetworkPanel networkPanel, Preferences preferences, Domain domain) throws ExceptionHugin, CompilationAbortedException {
        this.triangulateDomain(networkPanel, domain);
        if (!this.domain.isTriangulated()) return true;
        long l = 0L;
        long l2 = 0L;
        try {
            for (JunctionTree junctionTree : this.domain.getJunctionTrees()) {
                l += junctionTree.getTotalSize();
                l2 += junctionTree.getTotalCGSize();
            }
        }
        catch (ExceptionSizeTooLarge exceptionSizeTooLarge) {
            // empty catch block
        }
        long l3 = this.computeCombinations(this.domain);
        if (preferences.compilation_warning > 0 && ((l + l2) / 1000000L > (long)preferences.compilation_warning || l3 / 1000000L > (long)preferences.compilation_warning)) {
            String string = HuginGUIConstants.get("str_compilation_warning");
            String string2 = HuginGUIConstants.get("str_want_to_continue_compilation_ARG0_ARG1_ARG2", new String[]{"" + l, "" + l2, "" + l3});
            int n = JOptionPane.showConfirmDialog(Hugin.mainFrame, string2, string, 0, 3, null);
            if (n != 0) return false;
            HuginGUIUtils.configureDomain(this.domain);
            this.domain.generateTables();
            this.domain.compile();
            return true;
        } else {
            HuginGUIUtils.configureDomain(this.domain);
            this.domain.compile();
        }
        return true;
    }

    protected void triangulateDomain(NetworkPanel networkPanel, Domain domain) throws ExceptionHugin, CompilationAbortedException {
        String string = domain.getAttribute("HR_Compile_TriangMethod");
        int n = 0;
        if (string != null && string.length() > 0) {
            n = Integer.parseInt(string);
        }
        if (domain.isTriangulated()) {
            domain.uncompile();
        }
        switch (n) {
            case 0: {
                domain.triangulate();
                break;
            }
            case 1: {
                domain.triangulate(Domain.H_TM_CLIQUE_SIZE);
                break;
            }
            case 2: {
                domain.triangulate(Domain.H_TM_CLIQUE_WEIGHT);
                break;
            }
            case 3: {
                domain.triangulate(Domain.H_TM_FILL_IN_SIZE);
                break;
            }
            case 4: {
                domain.triangulate(Domain.H_TM_FILL_IN_WEIGHT);
                break;
            }
            case 5: {
                String string2 = domain.getAttribute("HR_Compile_MaxMinimalSeparators");
                int n2 = Integer.parseInt("100000");
                if (string2 != null) {
                    n2 = Integer.parseInt(string2);
                }
                domain.setMaxNumberOfSeparators(n2);
                domain.triangulate(Domain.H_TM_TOTAL_WEIGHT);
                break;
            }
            case 6: {
                HuginFileLoader huginFileLoader = new HuginFileLoader(13, networkPanel.guiFrame.getMostRecentCaseFile(), 0);
                if (huginFileLoader.showOpenDialog(networkPanel.guiFrame) == 0) {
                    File file = huginFileLoader.getSelectedFile();
                    networkPanel.guiFrame.setMostRecentCaseFile(file);
                    NodeList nodeList = null;
                    final String[] stringArray = new String[]{null, null};
                    try {
                        nodeList = domain.parseNodes(file.getAbsolutePath(), new ParseListener(){

                            public void parseError(int n, String string) {
                                stringArray[0] = "" + n;
                                stringArray[1] = string;
                            }
                        });
                    }
                    catch (ExceptionParse exceptionParse) {
                        Object object;
                        String[] stringArray2;
                        String string3 = "";
                        try {
                            stringArray2 = new FileReader(file);
                            object = new BufferedReader((Reader)stringArray2);
                            String[] stringArray3 = ((BufferedReader)object).readLine();
                            while (stringArray3 != null) {
                                string3 = string3 + " " + (String)stringArray3;
                                stringArray3 = ((BufferedReader)object).readLine();
                            }
                            stringArray2.close();
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            throw new CompilationAbortedException(fileNotFoundException.getMessage());
                        }
                        catch (IOException iOException) {
                            throw new CompilationAbortedException(iOException.getMessage());
                        }
                        stringArray2 = string3.split(" ");
                        object = new HashMap();
                        for (Node node : domain.getNodes()) {
                            String string4 = node.getName();
                            String string5 = string4.replace('.', '_');
                            if (((HashMap)object).put(string5, string4) == null) continue;
                            throw new CompilationAbortedException(HuginGUIConstants.get("str_err_elimination_order") + stringArray[0] + ": \n" + stringArray[1]);
                        }
                        nodeList = new NodeList();
                        for (String string5 : stringArray2) {
                            Node node;
                            if (string5.length() == 0) continue;
                            String string6 = (String)((HashMap)object).get(string5);
                            Node node2 = node = string6 != null ? domain.getNodeByName(string6) : null;
                            if (string6 == null || node == null) {
                                throw new CompilationAbortedException(HuginGUIConstants.get("str_err_elimination_order") + stringArray[0] + ": \n" + stringArray[1]);
                            }
                            nodeList.add(node);
                        }
                        JOptionPane.showMessageDialog(Hugin.mainFrame, HuginGUIConstants.get("Load_triangulation_old_version"), "Information", 2);
                    }
                    if (nodeList == null) break;
                    domain.uncompile();
                    domain.triangulate(nodeList);
                    break;
                }
                throw new CompilationAbortedException(HuginGUIConstants.get("Load_triangulation_aborted_by_user"));
            }
            case 7: {
                domain.triangulate(Domain.H_TM_BEST_GREEDY);
            }
        }
    }

    protected long computeCombinations(Domain domain) throws ExceptionHugin {
        long l = 0L;
        for (Node node : domain.getNodes()) {
            if (!(node instanceof DiscreteChanceNode) && !(node instanceof UtilityNode) || node.getModel() == null || !node.getModel().tableIsGenerated()) continue;
            long l2 = node.getModel().getNumberOfSamplesPerInterval();
            l += this.computeCombinations(node.getParents(), l2);
        }
        return l;
    }

    public long computeCombinations(NodeList nodeList, long l) throws ExceptionHugin {
        long l2 = 1L;
        for (Node node : nodeList) {
            if (node instanceof IntervalDCNode || node instanceof IntervalDDNode) {
                l2 *= l * (long)((DiscreteNode)node).getNumberOfStates();
                continue;
            }
            if (!(node instanceof DiscreteNode)) continue;
            l2 *= (long)((DiscreteNode)node).getNumberOfStates();
        }
        return l2;
    }

    public boolean treatAsLIMID() {
        return this.minimized;
    }

    protected void addDomainNodeMapping(NodeList nodeList, Node node) throws ExceptionHugin {
        this.classNodeNameToDomainNode.put(this.makeDottedName(nodeList), node);
        this.classNodeToDomainNode.put((Node)nodeList.getLast(), node);
    }

    protected Node getDomainNodeFor2(NodeList nodeList) throws ExceptionHugin {
        Node node = this.classNodeNameToDomainNode.get(this.makeDottedName(nodeList));
        if (node == null) {
            node = this.domain.getNodeByName(this.makeDottedName(nodeList));
        }
        return node;
    }

    public Node getDomainNodeFor(Node node) {
        Node node2 = this.classNodeToDomainNode.get(node);
        try {
            if (node2 == null) {
                node2 = this.domain.getNodeByName(node.getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return node2;
    }

    private String makeDottedName(NodeList nodeList) throws ExceptionHugin {
        ListIterator listIterator = nodeList.listIterator();
        String string = ((Node)listIterator.next()).getName();
        while (listIterator.hasNext()) {
            string = string + "." + ((Node)listIterator.next()).getName();
        }
        return string;
    }

    public void updateColors() {
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            ((BeliefBarNode)this.getChildAt(i)).updateColors();
        }
    }

    public void updateBeliefPrecision() {
        BeliefBarNodePainter.space = this.painter.initialSpace + this.preferences.precision * this.painter.numberWidth;
    }

    protected class CompilationDialog
    extends JDialog {
        JTextArea messages;
        JButton cancel;
        JButton ok;
        boolean stop;

        public CompilationDialog(long l, long l2, long l3) throws Exception {
            super(Hugin.mainFrame, HuginGUIConstants.get("str_compilation_warning"), true);
            this.stop = false;
            this.setContentPane(this.getContent());
        }

        public void enableOK() {
            this.ok.setEnabled(true);
            this.cancel.setEnabled(false);
        }

        private JPanel getContent() {
            JPanel jPanel = new JPanel(new BorderLayout(10, 10));
            this.messages = new JTextArea(4, 40);
            this.messages.setLineWrap(true);
            this.messages.setWrapStyleWord(true);
            this.messages.setEnabled(false);
            this.messages.setEditable(false);
            this.messages.setBackground(jPanel.getBackground());
            this.messages.setDisabledTextColor(Color.black);
            jPanel.add((Component)this.messages, "North");
            JPanel jPanel2 = new JPanel(new FlowLayout());
            jPanel2.add(this.ok);
            jPanel2.add(this.cancel);
            jPanel.add((Component)jPanel2, "South");
            return jPanel;
        }
    }
}

