/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.ContinuousChanceNode;
import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.DiscreteDecisionNode;
import COM.hugin.HAPI.DiscreteNode;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HGUI.CliqueEvent;
import COM.hugin.HGUI.CliqueLink;
import COM.hugin.HGUI.CliqueModel;
import COM.hugin.HGUI.CliqueSelectionListener;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.Preferences;
import COM.hugin.HGUI.zoom.ZoomableComponent;
import COM.hugin.HGUI.zoom.ZoomableScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Clique
extends JPanel
implements ZoomableComponent {
    private CliqueModel model;
    private int width = 60;
    private int height = 60;
    private Border selectedBorder;
    private Border notSelectedBorder;
    private LinkedList<CliqueSelectionListener> selectionListeners;
    private double scaleFactor = 1.0;
    private int evidenceMode = 0;
    private boolean isID = false;
    private boolean selected = false;
    boolean printable = false;
    private int maxWidth = 130;
    private int maxHeight = 80;
    private int minWidth = 60;
    private int scrollBarWidth = 16;
    JPanel nodeNames;
    CliqueStatusBar statusBar;
    ZoomableScrollPane scroll;
    NodeWrapper[] wrappers;

    public Clique(COM.hugin.HAPI.Clique clique, Clique clique2) throws ExceptionHugin {
        this.model = new CliqueModel(clique);
        if (clique2 != null) {
            clique2.add(this);
        }
        for (COM.hugin.HAPI.Clique clique3 : this.model.getNeighbours()) {
            if (this.isChild(clique3) || this.isParent(clique3)) continue;
            new Clique(clique3, this);
        }
        this.createInterior();
        this.selectedBorder = BorderFactory.createLineBorder(Color.black, 3);
        this.notSelectedBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createLineBorder(this.getBackground(), 2));
        this.setBorder(this.notSelectedBorder);
        this.addRecursiveMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Clique.this.setSelected(true);
                Clique.this.fireSelectionChanged(Clique.this.selected, mouseEvent.isShiftDown());
            }
        });
        this.selectionListeners = new LinkedList();
    }

    public void setID(boolean bl) {
        this.isID = bl;
        for (Clique clique : this.model.getChildren()) {
            clique.setID(bl);
        }
    }

    void add(Clique clique) {
        this.model.addChild(clique);
        clique.setParent(this);
    }

    public CliqueModel getModel() {
        return this.model;
    }

    public long getCliqueSize() throws ExceptionHugin {
        return this.model.getSize();
    }

    public LinkedList<Clique> getChildren() {
        return this.model.getChildren();
    }

    public void addRecursiveMouseListener(MouseListener mouseListener) {
        super.addMouseListener(mouseListener);
        this.addToChildren(mouseListener, this);
    }

    private void addToChildren(MouseListener mouseListener, Container container) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].addMouseListener(mouseListener);
            if (!(componentArray[i] instanceof Container)) continue;
            this.addToChildren(mouseListener, (Container)componentArray[i]);
        }
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
        this.setBorder(bl ? this.selectedBorder : this.notSelectedBorder);
    }

    public boolean isParent(COM.hugin.HAPI.Clique clique) {
        return this.model.isParent(clique);
    }

    public boolean isChild(COM.hugin.HAPI.Clique clique) {
        return this.model.isChild(clique);
    }

    protected COM.hugin.HAPI.Clique getAPIClique() {
        return this.model.getAPIClique();
    }

    protected void setParent(Clique clique) {
        this.model.setParent(clique);
        this.model.setParentLink(new CliqueLink(clique, this));
    }

    public void setEvidenceMode(int n) {
        this.evidenceMode = n;
        for (Clique clique : this.getChildren()) {
            clique.setEvidenceMode(n);
        }
    }

    public int getEvidenceMode() {
        return this.evidenceMode;
    }

    public double getConflict() throws ExceptionHugin {
        return this.model.getConflict();
    }

    public void getMaxCliqueWidth(LinkedList<Integer> linkedList, int n) {
        if (linkedList.size() > n) {
            linkedList.set(n, new Integer(linkedList.get(n) + 1));
        } else {
            linkedList.add(new Integer(1));
        }
        for (Clique clique : this.model.getChildren()) {
            clique.getMaxCliqueWidth(linkedList, n + 1);
        }
    }

    public void setPrintable() {
        this.printable = true;
        this.remove(this.statusBar);
        this.remove(this.scroll);
        this.add(this.nodeNames);
        this.setBackground(Color.white);
        this.setBorder(BorderFactory.createLineBorder(Color.black));
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.printable) {
            Dimension dimension = super.getPreferredSize();
            return dimension;
        }
        Dimension dimension = new Dimension(super.getPreferredSize().width, this.scroll.getPreferredSize().height + this.statusBar.getPreferredSize().height);
        boolean bl = false;
        boolean bl2 = false;
        int n = (int)(this.scaleFactor * (double)this.maxWidth);
        int n2 = (int)(this.scaleFactor * (double)this.minWidth);
        int n3 = (int)(this.scaleFactor * (double)this.maxHeight);
        if (dimension.width > n || dimension.height > n3 && dimension.width + this.scrollBarWidth > n) {
            bl = true;
        }
        if (dimension.height > n3 - (bl ? this.scrollBarWidth : 0)) {
            bl2 = true;
        }
        if (bl2) {
            dimension.width += this.scrollBarWidth;
        }
        dimension.width = bl ? n : dimension.width;
        dimension.width = Math.max(dimension.width, n2);
        dimension.height = n3;
        return dimension;
    }

    public CliqueLink getLink() {
        return this.model.getParentLink();
    }

    public NodeList getMembers() throws ExceptionHugin {
        return this.model.getNodes();
    }

    private void createInterior() throws ExceptionHugin {
        this.nodeNames = new JPanel(new GridLayout(this.model.getNumberOfNodes(), 1));
        this.wrappers = new NodeWrapper[this.model.getNumberOfNodes()];
        int n = 0;
        for (COM.hugin.HAPI.Node node : this.model.getNodes()) {
            int n2 = n++;
            NodeWrapper nodeWrapper = new NodeWrapper(node);
            this.wrappers[n2] = nodeWrapper;
            this.nodeNames.add(nodeWrapper);
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.nodeNames, "North");
        jPanel.setBackground(Color.white);
        this.scroll = new ZoomableScrollPane(jPanel);
        this.scroll.getHorizontalScrollBar().setUnitIncrement(15);
        this.scroll.getVerticalScrollBar().setUnitIncrement(15);
        this.statusBar = new CliqueStatusBar(this);
        this.setLayout(new BorderLayout());
        this.add(this.scroll);
        this.add((Component)this.statusBar, "South");
    }

    @Override
    public String toString() {
        String string = "";
        try {
            for (COM.hugin.HAPI.Node node : this.model.getNodes()) {
                string = string + node.getName() + " ";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
            ++n3;
            n4 += 4;
        }
        super.setBounds(n, n2, n3, n4);
        if (this.getChildren() != null && this.getChildren().size() > 0) {
            for (Clique clique : this.getChildren()) {
                CliqueLink cliqueLink = clique.getLink();
                int n5 = n + n3 / 2;
                int n6 = n2 + n4;
                int n7 = clique.getX() + clique.getWidth() / 2;
                int n8 = clique.getY();
                cliqueLink.setBounds(n5, n6, n7, n8);
            }
        }
    }

    @Override
    public void setLocation(int n, int n2) {
        super.setLocation(n, n2);
        if (this.getLink() != null) {
            this.getLink().setChildPoint(n + this.getPreferredSize().width / 2, n2);
        }
    }

    public void addSelectionListener(CliqueSelectionListener cliqueSelectionListener) {
        if (!this.selectionListeners.contains(cliqueSelectionListener)) {
            this.selectionListeners.add(cliqueSelectionListener);
        }
    }

    public void removeSelectionListener(CliqueSelectionListener cliqueSelectionListener) {
        this.selectionListeners.remove(cliqueSelectionListener);
    }

    private void fireSelectionChanged(boolean bl, boolean bl2) {
        CliqueEvent cliqueEvent = new CliqueEvent(this, bl ? (bl2 ? 1 : 0) : 2);
        for (CliqueSelectionListener cliqueSelectionListener : this.selectionListeners) {
            cliqueSelectionListener.selectionChanged(cliqueEvent);
        }
    }

    @Override
    public double getScaleFactor() {
        return this.scaleFactor;
    }

    @Override
    public void setScaleFactor(double d) {
        this.scaleFactor = d;
        this.invalidate();
        this.scroll.setScaleFactor(d);
        for (int i = 0; i < this.wrappers.length; ++i) {
            this.wrappers[i].setScaleFactor(d);
        }
        this.statusBar.setScaleFactor(d);
        for (Clique clique : this.model.getChildren()) {
            clique.setScaleFactor(d);
        }
    }

    private class NodeWrapper
    extends JPanel
    implements ZoomableComponent {
        COM.hugin.HAPI.Node node;
        double scaleFactor;
        Font defaultFont;
        JTextField text;
        NodeInfoPainter info;

        public NodeWrapper(COM.hugin.HAPI.Node node) throws ExceptionHugin {
            super(new BorderLayout());
            this.scaleFactor = 1.0;
            this.node = node;
            this.text = new JTextField(node.getName());
            this.text.setEditable(false);
            this.text.setBackground(Color.white);
            this.text.setBorder(null);
            this.text.setSelectionColor(this.getBackground());
            this.defaultFont = this.text.getFont();
            this.add(this.text);
            this.info = new NodeInfoPainter(node);
            this.add((Component)this.info, "West");
        }

        public double getScaleFactor() {
            return this.scaleFactor;
        }

        public void setScaleFactor(double d) {
            this.scaleFactor = d;
            this.invalidate();
            this.text.setFont(this.defaultFont.deriveFont(this.defaultFont.getSize2D() * (float)d));
            this.info.setScaleFactor(d);
            this.validate();
        }

        private class NodeInfoPainter
        extends JPanel
        implements ZoomableComponent {
            private Color grpColor = null;
            private double scaleFactor = 1.0;
            private int nodeWidth = 12;
            private int nodeHeight = 10;
            private int grpWidth = 8;
            private int grpHeight = 8;
            private int height = 12;
            private int separator = 2;
            private COM.hugin.HAPI.Node node;

            public NodeInfoPainter(COM.hugin.HAPI.Node node) throws ExceptionHugin {
                this.node = node;
                Node node2 = Hugin.mainFrame.getSelectedProjectFrame().getNetworkPanel().getNode(node.getName());
                if (node2 != null) {
                    this.grpColor = node2.getGroupIndex() >= 0 ? node2.fillColor : null;
                }
            }

            public double getScaleFactor() {
                return this.scaleFactor;
            }

            public void setScaleFactor(double d) {
                this.scaleFactor = d;
            }

            public void paintComponent(Graphics graphics) {
                Preferences preferences = Hugin.mainFrame.preferences;
                graphics.setColor(Color.white);
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                try {
                    if (this.node.evidenceIsEntered()) {
                        if (Hugin.mainFrame.getSelectedProjectFrame().evidenceIsLocked) {
                            graphics.setColor(preferences.barColors.get(4));
                        } else if (this.node.likelihoodIsEntered()) {
                            graphics.setColor(preferences.barColors.get(3));
                        } else if (Clique.this.getEvidenceMode() == 1) {
                            if (this.node instanceof DiscreteNode && ((DiscreteNode)this.node).getFindingClique() == Clique.this.getAPIClique()) {
                                graphics.setColor(preferences.barColors.get(1));
                            } else {
                                graphics.setColor(preferences.barColors.get(0));
                            }
                        } else {
                            graphics.setColor(preferences.barColors.get(1));
                        }
                    } else if (this.node.getHomeDomain().evidenceToPropagate()) {
                        graphics.setColor(preferences.barColors.get(2));
                    } else {
                        graphics.setColor(preferences.barColors.get(0));
                    }
                    if (this.node instanceof DiscreteChanceNode) {
                        graphics.fillOval((int)Math.round((double)this.separator * this.scaleFactor), (int)Math.round(this.scaleFactor * (double)(this.height - this.nodeHeight) / 2.0), (int)Math.round((double)this.nodeWidth * this.scaleFactor), (int)Math.round((double)this.nodeHeight * this.scaleFactor));
                        if (Math.round((double)this.nodeWidth * this.scaleFactor) > 3L) {
                            graphics.setColor(Color.black);
                            graphics.drawOval((int)Math.round((double)this.separator * this.scaleFactor), (int)Math.round(this.scaleFactor * (double)(this.height - this.nodeHeight) / 2.0), (int)Math.round((double)this.nodeWidth * this.scaleFactor), (int)Math.round((double)this.nodeHeight * this.scaleFactor));
                        }
                    }
                    if (this.node instanceof DiscreteDecisionNode) {
                        graphics.fillRect((int)Math.round((double)this.separator * this.scaleFactor), (int)Math.round(this.scaleFactor * (double)(this.height - this.nodeHeight) / 2.0), (int)Math.round((double)this.nodeWidth * this.scaleFactor), (int)Math.round((double)this.nodeHeight * this.scaleFactor));
                        if (Math.round((double)this.nodeWidth * this.scaleFactor) > 3L) {
                            graphics.setColor(Color.black);
                            graphics.drawRect((int)Math.round((double)this.separator * this.scaleFactor), (int)Math.round(this.scaleFactor * (double)(this.height - this.nodeHeight) / 2.0), (int)Math.round((double)this.nodeWidth * this.scaleFactor), (int)Math.round((double)this.nodeHeight * this.scaleFactor));
                        }
                    }
                    if (this.node instanceof ContinuousChanceNode) {
                        graphics.fillOval((int)Math.round((double)this.separator * this.scaleFactor), (int)Math.round(this.scaleFactor * (double)(this.height - this.nodeHeight) / 2.0), (int)Math.round((double)this.nodeWidth * this.scaleFactor), (int)Math.round((double)this.nodeHeight * this.scaleFactor));
                        if (Math.round((double)this.nodeWidth * this.scaleFactor) > 3L) {
                            graphics.setColor(Color.black);
                            graphics.drawOval((int)Math.round((double)this.separator * this.scaleFactor), (int)Math.round(this.scaleFactor * (double)(this.height - this.nodeHeight) / 2.0), (int)Math.round((double)this.nodeWidth * this.scaleFactor), (int)Math.round((double)this.nodeHeight * this.scaleFactor));
                            graphics.drawOval((int)Math.round((double)(3 * this.separator) * this.scaleFactor), (int)Math.round(this.scaleFactor * (double)((this.height - this.nodeHeight) / 2 + 2 * this.separator)), (int)Math.round((double)(this.nodeWidth - 4 * this.separator) * this.scaleFactor), (int)Math.round((double)(this.nodeHeight - 4 * this.separator) * this.scaleFactor));
                        }
                    }
                    if (this.grpColor != null) {
                        graphics.setColor(this.grpColor);
                        graphics.fillRect((int)Math.round(this.scaleFactor * (double)(2 * this.separator + this.nodeWidth)), (int)Math.round(this.scaleFactor * (double)(this.height - this.grpHeight) / 2.0), (int)Math.round(this.scaleFactor * (double)this.grpHeight), (int)Math.round(this.scaleFactor * (double)this.grpHeight));
                        if (Math.round((double)this.nodeWidth * this.scaleFactor) > 3L) {
                            graphics.setColor(Color.black);
                            graphics.drawRect((int)Math.round(this.scaleFactor * (double)(2 * this.separator + this.nodeWidth)), (int)Math.round(this.scaleFactor * (double)(this.height - this.grpHeight) / 2.0), (int)Math.round(this.scaleFactor * (double)this.grpHeight), (int)Math.round(this.scaleFactor * (double)this.grpHeight));
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public Dimension getPreferredSize() {
                return new Dimension((int)Math.rint((double)(this.nodeWidth + this.grpWidth + 3 * this.separator) * this.scaleFactor), (int)Math.rint((double)this.height * this.scaleFactor));
            }
        }
    }

    private class CliqueStatusBar
    extends JPanel
    implements ZoomableComponent {
        public static final int CONFLICT_MODE = 0;
        public static final int SIZE_MODE = 1;
        private Clique clique;
        private int mode;
        private JTextField text;
        private Font defaultFont;
        private double scaleFactor = 1.0;
        private int height = 20;
        private int margin = 4;

        public CliqueStatusBar(Clique clique2) {
            this.clique = clique2;
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createLoweredBevelBorder());
            this.text = new JTextField();
            this.text.setBorder(null);
            this.text.setEditable(false);
            this.defaultFont = this.text.getFont();
            this.setMode(0);
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        public String getToolTipText() {
            try {
                if (Clique.this.isID || this.clique.getModel().cgEvidenceIsPropagated()) {
                    return HuginGUIConstants.get("str_conflict_not_supported");
                }
                double d = this.clique.getConflict();
                boolean bl = Math.abs(d) < 0.001;
                return HuginGUIConstants.get("str_conflict_ARG0", new String[]{"" + HuginGUIUtils.printDouble(d, 3, bl)});
            }
            catch (Exception exception) {
                return HuginGUIConstants.get("str_conflict_not_supported");
            }
        }

        public Insets getInsets() {
            return new Insets(0, 0, 0, 0);
        }

        public void setMode(int n) {
            if (n == this.mode) {
                return;
            }
            this.mode = n;
            this.removeAll();
            switch (n) {
                case 0: {
                    this.removeAll();
                    break;
                }
                case 1: {
                    try {
                        this.text.setText(HuginGUIConstants.get("str_size_ARG0") + this.clique.getCliqueSize());
                        this.add(this.text);
                        break;
                    }
                    catch (Exception exception) {
                        new HuginGUIError(exception);
                    }
                }
            }
        }

        public void paintComponent(Graphics graphics) {
            try {
                switch (this.mode) {
                    case 0: {
                        this.paintBar(graphics);
                        break;
                    }
                    case 1: {
                        super.paintComponent(graphics);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void paintBar(Graphics graphics) throws ExceptionHugin {
            int n;
            if (Clique.this.isID || this.clique.getModel().cgEvidenceIsPropagated()) {
                graphics.setColor(UIManager.getDefaults().getColor("Panel.background"));
                graphics.fillRect(0, 0, Clique.this.width, this.height);
                return;
            }
            int n2 = 1 + (int)Clique.this.model.getMaxConflict();
            int n3 = this.getWidth();
            int n4 = this.getHeight();
            int n5 = n3 - (int)Math.rint((double)(2 * this.margin) * this.scaleFactor);
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(Color.black);
            if (Clique.this.model.getConflict() != 0.0) {
                int n6;
                n = Math.max(n3 / 2, n3 / 2 + (int)Math.rint((double)(n5 / 2) * Clique.this.model.getConflict() / (double)n2));
                for (int i = n6 = Math.min(n3 / 2, n3 / 2 + (int)Math.rint((double)(n5 / 2) * Clique.this.model.getConflict() / (double)n2)); i < n; ++i) {
                    int n7 = i < n3 / 2 ? (int)Math.rint(255 - 255 * Math.abs(i - n3 / 2) / (n5 / 2)) : 255;
                    int n8 = i > n3 / 2 ? (int)Math.rint(255 - 255 * (i - n3 / 2) / (n5 / 2)) : 255;
                    n7 = Math.min(254, Math.max(0, n7));
                    n8 = Math.min(254, Math.max(0, n8));
                    graphics.setColor(new Color(n7, n8, 0));
                    graphics.drawLine(i, 0, i, (int)Math.rint((double)n4 / 2.5));
                }
                graphics.setColor(Color.black);
            }
            graphics.drawLine(this.margin, (int)Math.rint((double)n4 / 2.5), n3 - this.margin, (int)Math.rint((double)n4 / 2.5));
            for (n = 0; n < 3; ++n) {
                graphics.drawLine(this.margin + (int)Math.rint((double)(n * (n3 - this.margin * 2)) / 2.0), 0, this.margin + (int)Math.rint((double)(n * (n3 - this.margin * 2)) / 2.0), (int)Math.rint(n4 / 2));
            }
            graphics.setFont(graphics.getFont().deriveFont((float)(this.scaleFactor * 9.0)));
            String string = "-" + n2;
            graphics.drawString(string, this.margin, n4 - 2);
            string = "0";
            n = SwingUtilities.computeStringWidth(graphics.getFontMetrics(), string);
            graphics.drawString(string, (n3 - n) / 2, n4 - 2);
            string = "" + n2;
            n = SwingUtilities.computeStringWidth(graphics.getFontMetrics(), string);
            graphics.drawString(string, n3 - this.margin - n, n4 - 2);
        }

        public double getScaleFactor() {
            return this.scaleFactor;
        }

        public void setScaleFactor(double d) {
            this.scaleFactor = d;
            this.invalidate();
            this.text.setFont(this.defaultFont.deriveFont(this.defaultFont.getSize2D() * (float)d));
            this.validate();
        }

        public Dimension getPreferredSize() {
            if (this.mode == 1) {
                return super.getPreferredSize();
            }
            return new Dimension(super.getPreferredSize().width, (int)Math.round((double)this.height * this.scaleFactor));
        }

        public void update() {
        }
    }
}

