/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.Node;
import COM.hugin.HGUI.BeliefBarPanel;
import COM.hugin.HGUI.ConflictResolutionHypothesis;
import COM.hugin.HGUI.DistributionPanel;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginAnalysisDialog;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.HuginTableModel;
import COM.hugin.HGUI.NumberField;
import COM.hugin.HGUI.TableSorter;
import COM.hugin.HGUI.VerticalFlowLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConflictDialog
extends HuginAnalysisDialog {
    JTextArea conflictText = null;
    JTextArea conflictResolutionsText = null;
    JTabbedPane tabs = null;
    ConflictResolutionsPanel resolutionsPanel = null;
    JList resolutionsList;
    Vector<ConflictResolutionHypothesis> resolutionsListData;
    Domain domain = this.beliefPanel.getDomain();
    private int conflictIndex = 0;
    private int infoVarsIndex = 1;
    private int partialIndex = 2;
    private int hypoDrivenIndex = 3;
    private HuginTableModel partialTableModel = null;
    JList partialEvidenceList;
    JTable partialTable;
    JPanel hypoDrivenPanel;
    JComboBox hypoVar;
    NumberField threshold;
    DiscreteChanceNode target;
    JRadioButton allStates;
    JRadioButton oneState;
    JComboBox theState;

    public ConflictDialog(HuginProjectFrame huginProjectFrame) {
        super(huginProjectFrame, HuginGUIConstants.get("MENU_NETWORK_Get_Conflict_Resolutions"), true);
        maxTitleLength = 19;
        this.minimum = new Dimension(600, 380);
        this.setResizable(true);
        this.helpPage = "help/conflictResolutionsHelp.html";
        try {
            this.setContentPane(this.createContent());
            this.groupDefiner = new HuginAnalysisDialog.GroupDefiner(this, this, huginProjectFrame.getNetworkPanel(), null);
            this.groupDefiner.pack();
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
            this.dispose();
        }
    }

    @Override
    protected JPanel createContent() throws ExceptionHugin {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tabs = new JTabbedPane();
        this.tabs.add((Component)this.createAnalysisTab(), HuginGUIConstants.get("CONFLICT_Resolution"));
        this.tabs.add((Component)this.createInfoVarsTab(), HuginGUIConstants.get("CONFLICT_HypothesisVariables"));
        this.tabs.add((Component)this.createPartialTab(), HuginGUIConstants.get("Partial_Conflicts"));
        this.tabs.add((Component)this.createHypoDrivenTab(), HuginGUIConstants.get("CONFLICT_Hypothesis_Driven"));
        this.tabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (ConflictDialog.this.tabs.getSelectedIndex() == ConflictDialog.this.infoVarsIndex) {
                    ConflictDialog.this.perform.setEnabled(false);
                } else {
                    ConflictDialog.this.perform.setEnabled(true);
                }
            }
        });
        jPanel.add(this.tabs);
        jPanel.add((Component)this.getButtonPanel(1), "South");
        this.pack();
        return jPanel;
    }

    private JPanel createAnalysisTab() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        try {
            double d = Math.log(this.beliefPanel.getDomain().getConflict());
            this.conflictText = new JTextArea("conf(e) = " + HuginGUIUtils.printDouble(d, 4));
            this.conflictText.setLineWrap(true);
            this.conflictText.setWrapStyleWord(true);
            this.conflictText.setEditable(false);
            this.conflictText.setBackground(jPanel2.getBackground());
            this.conflictResolutionsText = new JTextArea("");
            this.conflictResolutionsText.setLineWrap(true);
            this.conflictResolutionsText.setWrapStyleWord(true);
            this.conflictResolutionsText.setEditable(false);
            this.conflictResolutionsText.setBackground(jPanel2.getBackground());
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage());
        }
        jPanel2.add(this.conflictText);
        jPanel2.add(this.conflictResolutionsText);
        this.resolutionsListData = new Vector();
        this.resolutionsList = new JList<ConflictResolutionHypothesis>(this.resolutionsListData);
        this.resolutionsList.setSelectionMode(0);
        this.resolutionsList.setBorder(BorderFactory.createLoweredBevelBorder());
        this.resolutionsList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = ConflictDialog.this.resolutionsList.getSelectedIndex();
                if (n >= 0) {
                    ConflictResolutionHypothesis conflictResolutionHypothesis = ConflictDialog.this.resolutionsListData.get(n);
                    BeliefBarPanel beliefBarPanel = ConflictDialog.this.projectFrame.getBeliefBarPanel();
                    try {
                        conflictResolutionHypothesis.instantiate(true);
                        ConflictDialog.this.dispose();
                        ConflictDialog.this.resolutionsListData.clear();
                        ConflictDialog.this.resolutionsList.setListData(ConflictDialog.this.resolutionsListData);
                        double d = Math.log(beliefBarPanel.getDomain().getConflict());
                        String string = "conf(e) = " + HuginGUIUtils.printDouble(d, 4);
                        ConflictDialog.this.conflictText.setText(string);
                        ConflictDialog.this.conflictResolutionsText.setText("\n" + HuginGUIConstants.get("CONFLICT_No_Conflict"));
                    }
                    catch (ExceptionHugin exceptionHugin) {
                        // empty catch block
                    }
                    beliefBarPanel.collapseTree();
                    beliefBarPanel.setSelectedNode(conflictResolutionHypothesis.getNode());
                    beliefBarPanel.expandNode(conflictResolutionHypothesis.getNode());
                }
            }
        });
        this.resolutionsList.setEnabled(true);
        this.resolutionsPanel = new ConflictResolutionsPanel();
        this.resolutionsPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        JScrollPane jScrollPane = new JScrollPane(this.resolutionsPanel);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("CONFLICT_Possible_Conflict_Resolutions")));
        jPanel2.setPreferredSize(new Dimension(180, 180));
        JScrollPane jScrollPane2 = new JScrollPane(jPanel2);
        jScrollPane2.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("CONFLICT_LABEL")));
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane2, jScrollPane);
        jPanel.add(jSplitPane);
        return jPanel;
    }

    private JPanel createPartialTab() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JTextArea jTextArea = this.getTextArea(1, 20);
        jTextArea.append(HuginGUIConstants.get("CONFLICT_partial_conflict_description"));
        jPanel3.add(jTextArea);
        this.partialEvidenceList = new JList(new DefaultListModel());
        JPanel jPanel4 = this.getEvidenceSelectionPanel(this.partialEvidenceList);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        this.partialTableModel = new HuginTableModel(HuginGUIConstants.get("CONFLICT_LABEL"));
        TableSorter tableSorter = new TableSorter(this.partialTableModel);
        this.partialTable = new JTable(tableSorter);
        tableSorter.setTableHeader(this.partialTable.getTableHeader());
        this.partialTable.setPreferredScrollableViewportSize(new Dimension(500, 120));
        HuginAnalysisDialog.DoubleTableRenderer doubleTableRenderer = new HuginAnalysisDialog.DoubleTableRenderer(this.projectFrame.guiFrame.preferences.precision);
        this.partialTable.setDefaultRenderer(Double.class, doubleTableRenderer);
        JScrollPane jScrollPane = new JScrollPane(this.partialTable, 22, 31);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("Partial_conflicts") + ":"));
        jPanel5.add(jScrollPane);
        jPanel2.add((Component)new JScrollPane(jPanel3, 21, 31), "North");
        jPanel2.add(jPanel4);
        JSplitPane jSplitPane = new JSplitPane(0, jPanel2, jPanel5);
        jSplitPane.setResizeWeight(0.5);
        jSplitPane.setDividerLocation(170);
        jPanel.add(jSplitPane);
        return jPanel;
    }

    private JPanel createHypoDrivenTab() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.hypoDrivenPanel = this.getHypoDrivenPanel();
        JScrollPane jScrollPane = new JScrollPane(this.hypoDrivenPanel);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("CONFLICT_Hypothesis_Driven")));
        JPanel jPanel2 = this.getHypoVarPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("CONFLICT_hypothesis_variable")));
        JScrollPane jScrollPane2 = new JScrollPane(jPanel2);
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane2, jScrollPane);
        jSplitPane.setResizeWeight(0.5);
        jSplitPane.setDividerLocation(275);
        jPanel.add(jSplitPane);
        this.pack();
        return jPanel;
    }

    public double getThreshold() {
        return this.threshold.getNumber();
    }

    private JPanel getHypoVarPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JTextArea jTextArea = this.getTextArea(2, 20);
        jTextArea.append(HuginGUIConstants.get("CONFLICT_hypothesis_description"));
        JLabel jLabel = new JLabel(HuginGUIConstants.get("CONFLICT_select_variable") + " : ");
        JLabel jLabel2 = new JLabel(HuginGUIConstants.get("CONFLICT_select_threshold") + " : ");
        this.threshold = new NumberField(new Double(1.0E-4));
        this.threshold.setHorizontalAlignment(4);
        this.hypoVar = new JComboBox(new HuginAnalysisDialog.NodeListModel(this.domain, null));
        this.hypoVar.setSelectedIndex(-1);
        this.hypoVar.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                HuginAnalysisDialog.NodeWrapper nodeWrapper = (HuginAnalysisDialog.NodeWrapper)ConflictDialog.this.hypoVar.getSelectedItem();
                try {
                    ConflictDialog.this.target = (DiscreteChanceNode)nodeWrapper.node;
                    ConflictDialog.this.theState.removeAllItems();
                    int n = ConflictDialog.this.target.getNumberOfStates();
                    for (int i = 0; i < n; ++i) {
                        String string = HuginGUIUtils.getNodeStateLabel(ConflictDialog.this.target, i);
                        ConflictDialog.this.theState.addItem(string);
                    }
                    ConflictDialog.this.theState.setSelectedIndex(0);
                    ConflictDialog.this.oneState.setEnabled(true);
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        this.allStates = new JRadioButton(HuginGUIConstants.get("SE_all_states"));
        this.allStates.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConflictDialog.this.theState.setEnabled(false);
            }
        });
        this.oneState = new JRadioButton(HuginGUIConstants.get("SE_a_single_state") + ": ");
        this.oneState.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConflictDialog.this.theState.setEnabled(true);
            }
        });
        this.oneState.setEnabled(false);
        this.allStates.setSelected(true);
        buttonGroup.add(this.allStates);
        buttonGroup.add(this.oneState);
        this.theState = new JComboBox();
        this.theState.setEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        jPanel2.add((Component)jTextArea, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        jPanel2.add((Component)this.hypoVar, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        jPanel2.add((Component)this.threshold, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        jPanel2.add((Component)this.allStates, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        jPanel2.add((Component)this.oneState, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        jPanel2.add((Component)this.theState, gridBagConstraints);
        jPanel.add((Component)jPanel2, "North");
        return jPanel;
    }

    private JPanel getHypoDrivenPanel() {
        JPanel jPanel = new JPanel(new VerticalFlowLayout());
        jPanel.setSize(new Dimension(300, 100));
        jPanel.setBackground(Color.white);
        return jPanel;
    }

    private void conflictAction() throws ExceptionHugin {
        String string;
        String string2 = "";
        double d = Math.log(this.beliefPanel.getDomain().getConflict());
        String string3 = "conf(e) = " + HuginGUIUtils.printDouble(d, 4);
        this.conflictText.setText(string3);
        string2 = string2 + string3;
        double d2 = 0.0;
        int n = 0;
        this.resolutionsListData.clear();
        if (d > 0.0) {
            Vector<HuginAnalysisDialog.ListItem> vector = this.getInfoVars();
            for (ConflictResolutionHypothesis conflictResolutionHypothesis : this.beliefPanel.getConflictResolutions(d)) {
                if (!vector.contains(new HuginAnalysisDialog.ListItem(this, conflictResolutionHypothesis.getNode()))) continue;
                this.resolutionsListData.add(conflictResolutionHypothesis);
                d2 = Math.min(d2, conflictResolutionHypothesis.getResultingValue());
            }
            n = this.resolutionsListData.size();
            string = "\n" + n;
            string = n == 1 ? string + " " + HuginGUIConstants.get("CONFLICT_hypothesis") : string + " " + HuginGUIConstants.get("CONFLICT_hypotheses");
            string = string + "\n" + HuginGUIConstants.get("CONFLICT_may_resolve_conflict");
        } else {
            string = "\n" + HuginGUIConstants.get("CONFLICT_No_Conflict");
        }
        string2 = string2 + string;
        if (n > 0) {
            string = string + "\n\n" + HuginGUIConstants.get("CONFLICT_select");
        }
        this.conflictResolutionsText.setText(string);
        Collections.sort(this.resolutionsListData);
        for (ConflictResolutionHypothesis conflictResolutionHypothesis : this.resolutionsListData) {
            string2 = string2 + "\n" + conflictResolutionHypothesis;
        }
        this.resolutionsList.setListData(this.resolutionsListData);
        this.resolutionsPanel.setResult(this.resolutionsListData, d2);
        this.resolutionsPanel.revalidate();
        this.resolutionsPanel.repaint();
        Hugin.mainFrame.getStatusBar().fireLogMessageEntered(string2);
    }

    private void hypoDrivenAction() throws ExceptionHugin {
        this.hypoDrivenPanel.removeAll();
        this.hypoDrivenPanel.revalidate();
        this.hypoDrivenPanel.repaint();
        if (this.target != null) {
            double d = this.getThreshold();
            Vector<HuginAnalysisDialog.EvidenceListItem> vector = this.getEvidence();
            try {
                int n;
                int n2 = this.target.getNumberOfStates();
                double[] dArray = new double[n2];
                for (int i = 0; i < n2; ++i) {
                    dArray[i] = this.target.getBelief(i);
                }
                double[] dArray2 = new double[n2];
                this.domain.initialize();
                for (n = 0; n < n2; ++n) {
                    dArray2[n] = this.target.getBelief(n);
                }
                this.enterEvidence(vector);
                for (n = 0; n < vector.size(); ++n) {
                    HuginAnalysisDialog.EvidenceListItem evidenceListItem = vector.get(n);
                    evidenceListItem.retractEvidence();
                    double[] dArray3 = new double[n2];
                    HuginGUIUtils.configureDomain(this.domain);
                    this.domain.resetInferenceEngine();
                    this.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
                    for (int i = 0; i < n2; ++i) {
                        dArray3[i] = this.target.getBelief(i);
                    }
                    double d2 = this.costOfOmission(dArray, dArray3);
                    if (!(d < d2)) continue;
                    JLabel jLabel = new JLabel(HuginGUIConstants.get("CONFLICT_f_is_evidence_on") + " " + HuginGUIUtils.getNodeTitle(evidenceListItem.getNode()));
                    this.hypoDrivenPanel.add(jLabel);
                    jLabel = new JLabel(HuginGUIConstants.get("CONFLICT_Cost_of_omission") + " : c(P(X|e);P(X|e\\f)) = " + HuginGUIUtils.printDouble(d2, 4));
                    this.hypoDrivenPanel.add(jLabel);
                    this.hypoDrivenPanel.add(new JLabel(" * * * * * "));
                    for (int i = 0; i < n2; ++i) {
                        if (!this.allStates.isSelected() && (!this.oneState.isSelected() || this.theState.getSelectedIndex() != i)) continue;
                        String[] stringArray = new String[3];
                        double[] dArray4 = new double[]{dArray2[i], dArray3[i], dArray[i]};
                        stringArray[0] = "P(x)";
                        stringArray[1] = "P(x|e\\f)";
                        stringArray[2] = "P(x|e)";
                        String string = HuginGUIUtils.getNodeStateLabel(this.target, i);
                        jLabel = new JLabel("x = " + string);
                        this.hypoDrivenPanel.add(jLabel);
                        DistributionPanel distributionPanel = new DistributionPanel(stringArray, dArray4);
                        this.hypoDrivenPanel.add(distributionPanel);
                        if (i >= n2 - 1) continue;
                        this.hypoDrivenPanel.add(new JLabel(" * * * * * "));
                    }
                    evidenceListItem.enterEvidence();
                    this.hypoDrivenPanel.add(new JLabel(" * * * * * * * * * * * * * * * * * * * * * * * * * "));
                    this.hypoDrivenPanel.revalidate();
                    this.hypoDrivenPanel.repaint();
                }
            }
            catch (ExceptionHugin exceptionHugin) {
                new HuginGUIError(exceptionHugin.getMessage());
            }
            HuginGUIUtils.configureDomain(this.domain);
            this.domain.initialize();
            this.enterEvidence(vector);
            this.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
        }
    }

    private void partialAction(JList jList) throws ExceptionHugin {
        int n;
        Object object;
        Object object2;
        Vector<HuginAnalysisDialog.EvidenceListItem> vector = this.getEvidenceVector(jList);
        int n2 = vector.size() + 1;
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            nArray[i] = 0;
        }
        Vector<int[]> vector2 = new Vector<int[]>();
        this.generateSubsets(nArray, 0, vector, vector2, 0, vector.size());
        if (this.promptUser(vector2.size()) == 1) {
            return;
        }
        this.partialTableModel.resize(vector2.size(), n2);
        int n3 = 0;
        for (HuginAnalysisDialog.EvidenceListItem object3 : vector) {
            String string = HuginGUIUtils.getNodeTitle(object3.getNode());
            this.partialTableModel.setColumnName(n3, string);
            ++n3;
        }
        this.partialTableModel.setColumnName(n3, HuginGUIConstants.get("CONFLICT_LABEL"));
        ++n3;
        HuginGUIUtils.configureDomain(this.domain);
        this.domain.initialize();
        for (int i = 0; i < vector2.size(); ++i) {
            int n4;
            int[] nArray2 = vector2.get(i);
            n3 = 0;
            for (n4 = 0; n4 < vector.size(); ++n4) {
                if (nArray2[n4] > 0) {
                    this.partialTableModel.setValueAt(new Boolean(true), i, n3);
                } else {
                    this.partialTableModel.setValueAt(new Boolean(false), i, n3);
                }
                ++n3;
            }
            for (n4 = 0; n4 < vector.size(); ++n4) {
                if (nArray2[n4] <= 0) continue;
                object2 = vector.get(n4);
                ((HuginAnalysisDialog.EvidenceListItem)object2).enterEvidence();
            }
            this.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
            double d = Math.log(this.domain.getConflict());
            if (d == Double.POSITIVE_INFINITY) {
                this.partialTableModel.setValueAt(new Double(Double.POSITIVE_INFINITY), i, n3);
            } else {
                object = new Double(HuginGUIUtils.printDouble(d, this.projectFrame.guiFrame.preferences.precision));
                this.partialTableModel.setValueAt(object, i, n3);
            }
            ++n3;
            this.domain.initialize();
        }
        for (HuginAnalysisDialog.EvidenceListItem evidenceListItem : vector) {
            evidenceListItem.enterEvidence();
        }
        this.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
        this.partialTableModel.fireTableStructureChanged();
        TableModel tableModel = this.partialTable.getModel();
        int n5 = tableModel.getColumnCount();
        int n6 = tableModel.getRowCount();
        object2 = HuginGUIConstants.get("Partial_Conflicts") + "\n";
        object = new int[n5];
        String string = "";
        for (n = 0; n < n5; ++n) {
            object[n] = string.length();
            string = string + tableModel.getColumnName(n) + " ";
        }
        object2 = (String)object2 + string;
        string = "";
        for (n = 0; n < n6; ++n) {
            for (int i = 0; i < n5; ++i) {
                while (string.length() < object[i]) {
                    string = string + " ";
                }
                Object object3 = tableModel.getValueAt(n, i);
                string = string + "" + object3 + " ";
            }
            object2 = (String)object2 + "\n" + string;
            string = "";
        }
        Hugin.mainFrame.getStatusBar().fireLogMessageEntered((String)object2);
    }

    @Override
    protected JButton getPerformButton() {
        JButton jButton = new JButton(HuginGUIConstants.get("ANALYSIS_Calculate"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (ConflictDialog.this.tabs.getSelectedIndex() == ConflictDialog.this.conflictIndex) {
                        ConflictDialog.this.conflictAction();
                    }
                    if (ConflictDialog.this.tabs.getSelectedIndex() == ConflictDialog.this.hypoDrivenIndex) {
                        ConflictDialog.this.hypoDrivenAction();
                    }
                    if (ConflictDialog.this.tabs.getSelectedIndex() == ConflictDialog.this.partialIndex) {
                        ConflictDialog.this.partialAction(ConflictDialog.this.partialEvidenceList);
                    }
                }
                catch (Exception exception) {
                    new HuginGUIError(exception.getMessage());
                }
            }
        });
        return jButton;
    }

    private Vector<HuginAnalysisDialog.ListItem> getInfoVars() {
        Vector<HuginAnalysisDialog.ListItem> vector = new Vector<HuginAnalysisDialog.ListItem>();
        if (this.checks[this.checks.length - 1].isSelected()) {
            vector.addAll(this.customGroupData);
        }
        for (int i = 0; i < this.checks.length - 1; ++i) {
            if (!this.checks[i].isSelected()) continue;
            for (Node node : this.groups[i].getNodes()) {
                HuginAnalysisDialog.ListItem listItem = new HuginAnalysisDialog.ListItem(this, node);
                if (vector.contains(listItem)) continue;
                vector.add(listItem);
            }
        }
        return vector;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConflictResolutionsPanel
    extends JPanel {
        Vector<ConflictResolutionHypothesis> data = null;
        private static final int BARLENGTH = 200;
        double max = 0.0;

        ConflictResolutionsPanel() {
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    int n = mouseEvent.getY();
                    int n2 = ConflictResolutionsPanel.this.getHeight() - ConflictResolutionsPanel.this.getInsets().bottom - 25;
                    if (ConflictResolutionsPanel.this.data != null) {
                        for (int i = ConflictResolutionsPanel.this.data.size() - 1; i >= 0; --i) {
                            if (n < n2 + 3 && n > n2 - 12) {
                                ConflictResolutionHypothesis conflictResolutionHypothesis = ConflictDialog.this.resolutionsListData.get(i);
                                BeliefBarPanel beliefBarPanel = ConflictDialog.this.projectFrame.getBeliefBarPanel();
                                try {
                                    conflictResolutionHypothesis.instantiate(true);
                                    ConflictDialog.this.dispose();
                                    ConflictDialog.this.resolutionsListData.clear();
                                    ConflictDialog.this.resolutionsList.setListData(ConflictDialog.this.resolutionsListData);
                                    double d = Math.log(beliefBarPanel.getDomain().getConflict());
                                    String string = "conf(e) = " + HuginGUIUtils.printDouble(d, 4);
                                    ConflictDialog.this.conflictText.setText(string);
                                    ConflictDialog.this.conflictResolutionsText.setText("\n" + HuginGUIConstants.get("CONFLICT_No_Conflict"));
                                }
                                catch (ExceptionHugin exceptionHugin) {
                                    // empty catch block
                                }
                                beliefBarPanel.collapseTree();
                                beliefBarPanel.setSelectedNode(conflictResolutionHypothesis.getNode());
                                beliefBarPanel.expandNode(conflictResolutionHypothesis.getNode());
                                return;
                            }
                            n2 -= 20;
                        }
                    }
                }
            });
        }

        public void setResult(Vector<ConflictResolutionHypothesis> vector, double d) {
            this.data = vector;
            this.max = d;
        }

        @Override
        public Dimension getPreferredSize() {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            if (this.data == null) {
                return new Dimension(100, 100);
            }
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            try {
                for (int i = 0; i < this.data.size(); ++i) {
                    ConflictResolutionHypothesis conflictResolutionHypothesis = this.data.get(i);
                    n = Math.max(n, SwingUtilities.computeStringWidth(fontMetrics, HuginGUIUtils.getNodeTitle(conflictResolutionHypothesis.getNode()) + " = " + HuginGUIUtils.getNodeStateLabel(conflictResolutionHypothesis.getNode(), conflictResolutionHypothesis.getState())));
                    n2 = Math.max(n2, SwingUtilities.computeStringWidth(fontMetrics, "" + HuginGUIUtils.printDouble(conflictResolutionHypothesis.getResultingValue(), Hugin.mainFrame.preferences.precision)));
                }
                n3 = 25 + 20 * this.data.size();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return new Dimension(5 + n + 15 + 200 + 5 + n2, n3);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.data == null) {
                return;
            }
            try {
                Object object;
                int n;
                int n2 = 0;
                int n3 = this.getHeight() - this.getInsets().bottom - 25;
                graphics.setColor(Color.black);
                FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                String string = null;
                for (n = this.data.size() - 1; n >= 0; --n) {
                    object = this.data.get(n);
                    string = HuginGUIUtils.getNodeTitle(((ConflictResolutionHypothesis)object).getNode());
                    string = string + " = ";
                    string = string + HuginGUIUtils.getNodeStateLabel(((ConflictResolutionHypothesis)object).getNode(), ((ConflictResolutionHypothesis)object).getState());
                    graphics.drawString(string, 5, n3);
                    n2 = Math.max(n2, SwingUtilities.computeStringWidth(fontMetrics, string));
                    n3 -= 20;
                    this.max = Math.max(this.max, Math.abs(((ConflictResolutionHypothesis)object).getResultingValue()));
                }
                n = 1 + (int)this.max;
                if (this.data.size() > 0) {
                    graphics.drawLine(n2 + 5 + 200, n3, n2 + 5 + 200, this.getHeight() - this.getInsets().bottom - 15);
                    graphics.drawLine(n2, this.getHeight() - this.getInsets().bottom - 20, n2 + 200 + 10, this.getHeight() - this.getInsets().bottom - 20);
                    graphics.setColor(Color.gray);
                    for (int i = 0; i < 200; i += 50) {
                        graphics.drawLine(n2 + 5 + i, n3, n2 + 5 + i, this.getHeight() - this.getInsets().bottom - 15);
                    }
                    object = "-" + HuginGUIUtils.printDouble(n, Hugin.mainFrame.preferences.precision);
                    graphics.drawString((String)object, n2 + 5 - SwingUtilities.computeStringWidth(fontMetrics, (String)object) / 2, this.getHeight() - this.getInsets().bottom);
                    graphics.drawString("", n2 + 5 + 50 - SwingUtilities.computeStringWidth(fontMetrics, (String)object) / 2, this.getHeight() - this.getInsets().bottom);
                    graphics.drawString("", n2 + 5 + 150 - SwingUtilities.computeStringWidth(fontMetrics, "0") / 2, this.getHeight() - this.getInsets().bottom);
                    graphics.drawString("0", n2 + 5 + 200 - SwingUtilities.computeStringWidth(fontMetrics, "0") / 2, this.getHeight() - this.getInsets().bottom);
                }
                int n4 = 4;
                n3 = this.getHeight() - this.getInsets().bottom - 25;
                for (int i = this.data.size() - 1; i >= 0; --i) {
                    int n5;
                    ConflictResolutionHypothesis conflictResolutionHypothesis = this.data.get(i);
                    double d = conflictResolutionHypothesis.getResultingValue();
                    graphics.setColor(Color.black);
                    graphics.drawString("" + HuginGUIUtils.printDouble(d, Hugin.mainFrame.preferences.precision), n2 + 5 + 200 + 5, n3);
                    graphics.setColor(Color.green);
                    int n6 = (int)(200.0 * (Math.abs(d) / (double)n));
                    int n7 = n6 - (int)Math.rint(2 * n4);
                    int n8 = Math.max(n6 / 2, n6 / 2 + (int)Math.rint((double)(n7 / 2) * d / (double)n));
                    int n9 = Math.min(n6 / 2, n6 / 2 + (int)Math.rint((double)(n7 / 2) * d / (double)n));
                    for (int j = n5 = n2 + 5 + 1 + 200 - n6; j < n5 + n6; ++j) {
                        int n10 = (int)Math.max(0.0, Math.min(255.0, Math.rint(255 * (j - n2 + 5 + 1) / 200)));
                        int n11 = 255;
                        graphics.setColor(new Color(n10, 255, 0));
                        graphics.drawLine(j, n3 - 12, j, n3 + 3);
                        graphics.setColor(Color.black);
                    }
                    n3 -= 20;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

