/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.BooleanDCNode;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.IntervalDCNode;
import COM.hugin.HAPI.NumberedDCNode;
import COM.hugin.HGUI.DistributionPanel;
import COM.hugin.HGUI.HuginAnalysisDialog;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.TotalImpactDistribution;
import COM.hugin.HGUI.VerticalFlowLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class ConvolutionDialog
extends HuginAnalysisDialog {
    JPanel totalImpactPanel;
    TotalImpactDistribution totalImpactDist;
    Dimension minimum = new Dimension(700, 300);
    IntervalDCNode costNode;
    NumberedDCNode freqNode;
    NumberedDCNode xNode = null;
    BooleanDCNode oNode = null;
    IntervalDCNode iNode = null;
    JButton ok;
    JButton cancel;
    JButton perform;
    JButton fit;
    JButton help;

    public ConvolutionDialog(HuginProjectFrame huginProjectFrame, IntervalDCNode intervalDCNode, NumberedDCNode numberedDCNode) throws ExceptionHugin {
        super(huginProjectFrame, HuginGUIConstants.get("MENU_NETWORK_Convolution"), true);
        this.costNode = intervalDCNode;
        this.freqNode = numberedDCNode;
        this.totalImpactDist = new TotalImpactDistribution(this.costNode, this.freqNode);
        try {
            this.setContentPane(this.createContent());
        }
        catch (ExceptionHugin exceptionHugin) {
            exceptionHugin.printStackTrace();
            new HuginGUIError(exceptionHugin.getMessage());
            this.dispose();
        }
        this.setResizable(true);
        this.pack();
    }

    protected JPanel createContent() throws ExceptionHugin {
        JPanel jPanel = new JPanel(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.getCostPanel());
        JScrollPane jScrollPane2 = new JScrollPane(this.getFreqPanel());
        this.totalImpactPanel = this.getTotalImpactPanel();
        JScrollPane jScrollPane3 = new JScrollPane(this.totalImpactPanel);
        jScrollPane2.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("CONVOLUTION_freq_dist") + HuginGUIUtils.getNodeTitle(this.freqNode)));
        jScrollPane.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("CONVOLUTION_cost_dist") + HuginGUIUtils.getNodeTitle(this.costNode)));
        jScrollPane3.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("CONVOLUTION_total_impact_dist")));
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane, jScrollPane2);
        Dimension dimension = new Dimension(0, 0);
        jScrollPane.setMinimumSize(dimension);
        jScrollPane2.setMinimumSize(dimension);
        jScrollPane3.setMinimumSize(dimension);
        jSplitPane.setMinimumSize(dimension);
        JSplitPane jSplitPane2 = new JSplitPane(1, jSplitPane, jScrollPane3);
        jSplitPane2.setResizeWeight(0.5);
        jSplitPane2.setDividerLocation(350);
        jSplitPane.setResizeWeight(0.5);
        jPanel.add(jSplitPane2);
        jPanel.add((Component)this.getButtonPanel(), "South");
        this.pack();
        return jPanel;
    }

    private JPanel getCostPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel = new DistributionPanel(this.costNode);
        return jPanel;
    }

    private JPanel getFreqPanel() {
        return new DistributionPanel(this.freqNode);
    }

    private JPanel getIPanel() {
        return new DistributionPanel(this.iNode);
    }

    private JPanel getXPanel() {
        return new DistributionPanel(this.xNode);
    }

    private JPanel getOPanel() {
        return new DistributionPanel(this.oNode);
    }

    private JPanel getTotalImpactPanel() {
        JPanel jPanel = new JPanel(new VerticalFlowLayout());
        jPanel.setSize(new Dimension(350, 100));
        jPanel.setBackground(Color.white);
        return jPanel;
    }

    protected JButton getPerformButton() {
        return null;
    }

    protected JPanel getButtonPanel() {
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JPanel jPanel3 = new JPanel(new FlowLayout(2));
        this.ok = new JButton(HuginGUIConstants.get("OK_button"));
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ConvolutionDialog.this.totalImpactDist.delete();
                    ConvolutionDialog.this.dispose();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    new HuginGUIError(exception.getMessage());
                }
            }
        });
        this.perform = new JButton(HuginGUIConstants.get("CONVOLUTION_convolute"));
        this.perform.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ConvolutionDialog.this.updateTotalImpactPanel(false);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    new HuginGUIError(exception.getMessage());
                }
            }
        });
        this.cancel = new JButton(HuginGUIConstants.get("cancel_button"));
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ConvolutionDialog.this.totalImpactDist.delete();
                }
                catch (Exception exception) {
                    new HuginGUIError(exception.getMessage());
                }
                ConvolutionDialog.this.dispose();
            }
        });
        jPanel3.add(this.ok);
        jPanel3.add(this.perform);
        jPanel3.add(this.cancel);
        this.help = new JButton(HuginGUIConstants.get("help_button"));
        this.help.addActionListener(new HuginAnalysisDialog.HelpListener(this, HuginGUIConstants.get("CONVOLUTION_HELP_PAGE")));
        jPanel2.add(this.help);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        return jPanel;
    }

    private void updateTotalImpactPanel(boolean bl) throws ExceptionHugin {
        this.totalImpactPanel.removeAll();
        this.totalImpactPanel.revalidate();
        this.totalImpactPanel.repaint();
        try {
            this.totalImpactDist.calculate(bl);
            DistributionPanel distributionPanel = new DistributionPanel(this.totalImpactDist.getNode(), this.totalImpactDist.getValues());
            this.totalImpactPanel.add(distributionPanel);
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage() + "\n" + HuginGUIConstants.get("Are_the_nodes_well_formed") + "?");
        }
        this.totalImpactPanel.revalidate();
        this.totalImpactPanel.repaint();
    }
}

