/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.DiscreteDecisionNode;
import COM.hugin.HAPI.DiscreteNode;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HGUI.NodeMonitorModel;

public class DiscreteDecisionNodeMonitorModel
extends NodeMonitorModel {
    DiscreteNode node;
    private static final double deltaThreshold = 1.0E-10;

    public DiscreteDecisionNodeMonitorModel(DiscreteDecisionNode discreteDecisionNode) throws ExceptionHugin {
        this((DiscreteNode)discreteDecisionNode);
    }

    public DiscreteDecisionNodeMonitorModel(DiscreteNode discreteNode) throws ExceptionHugin {
        super(discreteNode);
        this.node = discreteNode;
        this.currentVal = new double[this.getBarCount()];
        this.oldVal = new double[this.getBarCount()];
        for (int i = 0; i < this.currentVal.length; ++i) {
            this.currentVal[i] = this.oldVal[i] = this.getValueAt(i);
        }
    }

    public void setNode(DiscreteNode discreteNode) throws ExceptionHugin {
        this.node = discreteNode;
        this.currentVal = new double[this.getBarCount()];
        this.oldVal = new double[this.getBarCount()];
        for (int i = 0; i < this.currentVal.length; ++i) {
            this.currentVal[i] = this.oldVal[i] = this.getValueAt(i);
        }
    }

    public int getBarCount() throws ExceptionHugin {
        return this.node.getNumberOfStates();
    }

    public double getFindingAt(int n) throws ExceptionHugin {
        return this.node.getEnteredFinding(n);
    }

    public double getValueAt(int n) throws ExceptionHugin {
        double d = this.node.getExpectedUtility(n);
        if (d != this.currentVal[n]) {
            this.oldVal[n] = this.currentVal[n];
            this.currentVal[n] = d;
        }
        return d;
    }

    public double getDeltaValueAt(int n) throws ExceptionHugin {
        double d = this.getValueAt(n);
        if (!this.node.getHomeDomain().evidenceIsPropagated()) {
            return d;
        }
        d = this.currentVal[n] - this.oldVal[n];
        if (Math.abs(d) < 1.0E-10) {
            return 0.0;
        }
        return d;
    }

    public double getPercentageDelta(int n) throws ExceptionHugin {
        double d = this.getValueAt(n);
        if (!this.node.getHomeDomain().evidenceIsPropagated()) {
            return d;
        }
        d = this.oldVal[n] == 0.0 ? (this.currentVal[n] < 0.0 ? Double.NEGATIVE_INFINITY : (d > 0.0 ? Double.POSITIVE_INFINITY : 0.0)) : (this.currentVal[n] - this.oldVal[n]) / this.oldVal[n];
        if (Math.abs(d) < 1.0E-10) {
            return 0.0;
        }
        return d;
    }
}

