/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.IntervalDCNode;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.InvalidDiscretizationException;
import COM.hugin.HGUI.PreProcess;
import COM.hugin.HGUI.PreProcessingException;
import COM.hugin.HGUI.Variable;

public class DiscretizeProcess
extends PreProcess {
    Interval[] intervals;

    public DiscretizeProcess(String string, Interval[] intervalArray) throws InvalidDiscretizationException {
        super(string);
        this.intervals = intervalArray;
        for (int i = 0; i < intervalArray.length - 1; ++i) {
            if (!(intervalArray[i].lower >= intervalArray[i].upper) && !(intervalArray[i].upper > intervalArray[i + 1].lower)) continue;
            throw new InvalidDiscretizationException(HuginGUIConstants.get("str_specified_interval_not_monotone"));
        }
        if (intervalArray[intervalArray.length - 1].lower >= intervalArray[intervalArray.length - 1].upper) {
            throw new InvalidDiscretizationException(HuginGUIConstants.get("str_specified_interval_not_monotone"));
        }
    }

    public DiscretizeProcess(String string) {
        super(string);
    }

    public String process(String string) throws PreProcessingException {
        if (Variable.isNull(string)) {
            return string;
        }
        try {
            double d = Double.parseDouble(string);
            for (int i = 0; i < this.intervals.length; ++i) {
                if (!this.intervals[i].contains(d)) continue;
                string = this.intervals[i].toString();
                return string;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new PreProcessingException(HuginGUIConstants.get("str_bad_value_in_discretizing_interval_ARG0_for_variable_ARG1", new String[]{"" + string, "" + this.name}));
        }
        throw new PreProcessingException(HuginGUIConstants.get("str_value_not_in_discretizing_intervals_ARG0_for_variable_ARG1", new String[]{"" + string, "" + this.name}));
    }

    protected IntervalDCNode createIntervalNode(Domain domain) throws ExceptionHugin {
        IntervalDCNode intervalDCNode = new IntervalDCNode(domain);
        intervalDCNode.setNumberOfStates(this.intervals.length);
        for (int i = 0; i < this.intervals.length; ++i) {
            intervalDCNode.setStateValue(i, this.intervals[i].lower);
            intervalDCNode.setStateLabel(i, this.intervals[i].toString());
        }
        intervalDCNode.setStateValue(this.intervals.length, this.intervals[this.intervals.length - 1].upper);
        return intervalDCNode;
    }

    protected void replaceIntervals(Interval[] intervalArray) {
        this.intervals = intervalArray;
    }

    protected Interval[] getIntervals() {
        return this.intervals;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DiscretizeProcess)) {
            return false;
        }
        return ((DiscretizeProcess)object).name.equals(this.name);
    }

    public String toString() {
        String string = HuginGUIConstants.get("str_discretize_pre_process_lb________lb");
        for (int i = 0; i < this.intervals.length; ++i) {
            string = string + this.intervals[i].lower + " -> " + this.intervals[i].upper + "\n";
        }
        return string;
    }

    public static class Interval {
        double lower;
        double upper;

        public Interval(double d, double d2) {
            this.lower = d;
            this.upper = d2;
        }

        public boolean contains(double d) {
            return d >= this.lower && d < this.upper;
        }

        public String toString() {
            return this.doubleToShortString(this.lower) + " - " + this.doubleToShortString(this.upper);
        }

        private String doubleToShortString(double d) {
            if (d == (double)((int)d)) {
                return "" + (int)d;
            }
            return "" + d;
        }
    }
}

