/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.AbsExpression;
import COM.hugin.HAPI.AddExpression;
import COM.hugin.HAPI.AndExpression;
import COM.hugin.HAPI.BetaDistribution;
import COM.hugin.HAPI.BinomialDistribution;
import COM.hugin.HAPI.BooleanDCNode;
import COM.hugin.HAPI.BooleanExpression;
import COM.hugin.HAPI.CeilExpression;
import COM.hugin.HAPI.CompositeExpression;
import COM.hugin.HAPI.CosExpression;
import COM.hugin.HAPI.CoshExpression;
import COM.hugin.HAPI.DistributionDistribution;
import COM.hugin.HAPI.DivideExpression;
import COM.hugin.HAPI.EqualsExpression;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExpExpression;
import COM.hugin.HAPI.ExponentialDistribution;
import COM.hugin.HAPI.Expression;
import COM.hugin.HAPI.ExpressionList;
import COM.hugin.HAPI.FloorExpression;
import COM.hugin.HAPI.GammaDistribution;
import COM.hugin.HAPI.GeometricDistribution;
import COM.hugin.HAPI.GreaterThanExpression;
import COM.hugin.HAPI.GreaterThanOrEqualsExpression;
import COM.hugin.HAPI.IfExpression;
import COM.hugin.HAPI.InstanceNode;
import COM.hugin.HAPI.LessThanExpression;
import COM.hugin.HAPI.LessThanOrEqualsExpression;
import COM.hugin.HAPI.Log10Expression;
import COM.hugin.HAPI.Log2Expression;
import COM.hugin.HAPI.LogExpression;
import COM.hugin.HAPI.LogNormalDistribution;
import COM.hugin.HAPI.MaxExpression;
import COM.hugin.HAPI.MinExpression;
import COM.hugin.HAPI.ModExpression;
import COM.hugin.HAPI.MultiplyExpression;
import COM.hugin.HAPI.NegateExpression;
import COM.hugin.HAPI.NegativeBinomialDistribution;
import COM.hugin.HAPI.NodeExpression;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HAPI.NoisyOrDistribution;
import COM.hugin.HAPI.NormalDistribution;
import COM.hugin.HAPI.NotEqualsExpression;
import COM.hugin.HAPI.NotExpression;
import COM.hugin.HAPI.OrExpression;
import COM.hugin.HAPI.PERTDistribution;
import COM.hugin.HAPI.ParseListener;
import COM.hugin.HAPI.PoissonDistribution;
import COM.hugin.HAPI.PowerExpression;
import COM.hugin.HAPI.SinExpression;
import COM.hugin.HAPI.SinhExpression;
import COM.hugin.HAPI.SqrtExpression;
import COM.hugin.HAPI.SubtractExpression;
import COM.hugin.HAPI.TanExpression;
import COM.hugin.HAPI.TanhExpression;
import COM.hugin.HAPI.TriangularDistribution;
import COM.hugin.HAPI.TruncateExpression;
import COM.hugin.HAPI.UniformDistribution;
import COM.hugin.HAPI.WeibullDistribution;
import COM.hugin.HGUI.DiscreteChanceNode;
import COM.hugin.HGUI.DiscreteDecisionNode;
import COM.hugin.HGUI.DiscreteNode;
import COM.hugin.HGUI.ExpressionTableModel;
import COM.hugin.HGUI.FunctionNode;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIFrame;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.ParentInserterField;
import COM.hugin.HGUI.TitledPanel;
import COM.hugin.HGUI.UtilityNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableModel;

public class ExpressionBuilderPanel
extends JPanel {
    private Node node;
    private Expression expression;
    private HuginGUIFrame guiFrame;
    private int nextMode;
    private Container cont;
    private TitledPanel mainPanel;
    private JPanel pane;
    private JPanel argumentsPanel;
    private JPanel buttonPanel;
    private JPanel specifyArguments;
    private SelectFunctionPane selectionPane;
    private JButton ok;
    private JButton cancel;
    private JButton back;
    private JButton apply;
    private Expression result;
    private Function function;
    private boolean isModal = true;
    private boolean isEditable = false;
    ExpressionParser expressionParser;
    private String currentStringExpression;
    private String title;
    private ChangeListener okListener;
    private ChangeListener backListener;
    private ChangeListener functionListener;
    private ChangeListener expressionListener;
    private ChangeListener applyListener;
    ExpressionBuilderPanel ebp;
    private Dimension mainDimension = new Dimension(500, 370);
    private Dimension funDimension = new Dimension(450, 100);
    private Dimension argDimension = new Dimension(450, 150);
    private Dimension argScrollDim = new Dimension(200, 100);
    private Dimension wrapPanelDim = new Dimension(450, 320);
    private Dimension exprPanelDimension = new Dimension(450, 50);
    private String[] userArguments;
    private boolean useExpression = true;
    protected static final String SYNTAX_ID = "HR_Syntax_Error:";

    public ExpressionBuilderPanel(HuginGUIFrame huginGUIFrame, Node node, Expression expression, int n, String string) {
        this.guiFrame = huginGUIFrame;
        this.node = node;
        this.expression = this.validateExpression(expression);
        this.ebp = this;
        this.setLayout(new GridLayout(1, 1));
        this.title = string;
        this.pane = new JPanel(new GridLayout(1, 1));
        this.userArguments = new String[4];
        try {
            int n2;
            if (node.getAPINode() instanceof COM.hugin.HAPI.DiscreteNode && (n2 = ((COM.hugin.HAPI.DiscreteNode)node.getAPINode()).getNumberOfStates()) > 4) {
                this.userArguments = new String[n2];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.argumentsPanel = new JPanel(new GridLayout(1, 1));
        this.createSelectionPane(n);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.selectionPane, "North");
        jPanel.add((Component)jPanel2, "North");
        jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.argumentsPanel, "North");
        jPanel.add((Component)jPanel2, "Center");
        this.pane.add(jPanel);
        this.createButtonPanel();
        jPanel = new JPanel(new BorderLayout());
        jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.pane, "North");
        jPanel.add((Component)jPanel2, "North");
        jPanel2 = new JPanel(new BorderLayout(5, 5));
        jPanel2.add((Component)this.buttonPanel, "South");
        jPanel.add((Component)jPanel2, "Center");
        this.mainPanel = new TitledPanel(string);
        this.mainPanel.setLayout(new GridLayout(1, 1));
        this.mainPanel.add(jPanel);
        this.add(this.mainPanel);
    }

    private void createButtonPanel() {
        JPanel jPanel = new JPanel(new GridLayout(1, 3));
        this.buttonPanel = new JPanel(new BorderLayout());
        this.ok = new JButton(HuginGUIConstants.get("EBW_BUTTON_Ok"));
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (ExpressionBuilderPanel.this.isEditable) {
                        ExpressionBuilderPanel.this.result = ExpressionBuilderPanel.this.function.getEditedExpression();
                    } else {
                        ExpressionBuilderPanel.this.result = ExpressionBuilderPanel.this.function.getExpression();
                    }
                }
                catch (ExceptionHugin exceptionHugin) {
                    new HuginGUIError(exceptionHugin.getMessage() + "\n" + ExpressionBuilderPanel.this.function.getExplanation());
                    ExpressionBuilderPanel.this.result = null;
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                    ExpressionBuilderPanel.this.result = null;
                }
                if (ExpressionBuilderPanel.this.function.getStringExpression().length() == 0) {
                    if (ExpressionBuilderPanel.this.okListener != null) {
                        ExpressionBuilderPanel.this.okListener.stateChanged(new ChangeEvent(new Object()));
                    }
                    return;
                }
                if (ExpressionBuilderPanel.this.result != null && ExpressionBuilderPanel.this.okListener != null) {
                    try {
                        ExpressionBuilderPanel.this.result.expressionToString();
                        ExpressionBuilderPanel.this.okListener.stateChanged(new ChangeEvent(new Object()));
                    }
                    catch (ExceptionHugin exceptionHugin) {
                        new HuginGUIError(ExpressionBuilderPanel.this.function.getExplanation());
                    }
                }
            }
        });
        this.apply = new JButton(HuginGUIConstants.get("EBW_BUTTON_Apply"));
        this.apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (ExpressionBuilderPanel.this.isEditable) {
                        ExpressionBuilderPanel.this.result = ExpressionBuilderPanel.this.function.getEditedExpression();
                    } else {
                        ExpressionBuilderPanel.this.result = ExpressionBuilderPanel.this.function.getExpression();
                    }
                    ExpressionBuilderPanel.this.result.expressionToString();
                }
                catch (Exception exception) {
                    ExpressionBuilderPanel.this.result = null;
                }
                if (ExpressionBuilderPanel.this.result == null) {
                    ExpressionBuilderPanel.this.result = ExpressionTableModel.createValidExpression(ExpressionBuilderPanel.this.function.getStringExpression(), ExpressionBuilderPanel.this.node.getClass().equals(UtilityNode.class));
                    ExpressionBuilderPanel.this.isModal = false;
                    ExpressionBuilderPanel.this.isModal = true;
                    ExpressionBuilderPanel.this.applyListener.stateChanged(new ChangeEvent(new Object()));
                }
                if (ExpressionBuilderPanel.this.result != null && ExpressionBuilderPanel.this.applyListener != null) {
                    ExpressionBuilderPanel.this.expression = ExpressionBuilderPanel.this.result;
                    ExpressionBuilderPanel.this.applyListener.stateChanged(new ChangeEvent(new Object()));
                }
            }
        });
        this.back = new JButton(HuginGUIConstants.get("EBW_BUTTON_Back"));
        this.back.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ExpressionBuilderPanel.this.backListener != null) {
                    ExpressionBuilderPanel.this.backListener.stateChanged(new ChangeEvent(new Object()));
                }
                ExpressionBuilderPanel.this.notifyExpressionListener();
            }
        });
        jPanel.add(this.back);
        jPanel.add(this.apply);
        jPanel.add(this.ok);
        this.buttonPanel.add((Component)jPanel, "East");
    }

    public boolean userInput() {
        if (this.userArguments != null) {
            for (String string : this.userArguments) {
                if (string.length() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public void clearUserInput() {
        if (this.userArguments != null) {
            for (int i = 0; i < this.userArguments.length; ++i) {
                this.userArguments[i] = "";
            }
        }
    }

    public void addOkListener(ChangeListener changeListener) {
        this.okListener = changeListener;
    }

    public void addBackListener(ChangeListener changeListener) {
        this.backListener = changeListener;
    }

    public void addFunctionListener(ChangeListener changeListener) {
        this.functionListener = changeListener;
    }

    public void addExpressionListener(ChangeListener changeListener) {
        this.expressionListener = changeListener;
    }

    public void addApplyListener(ChangeListener changeListener) {
        this.applyListener = changeListener;
    }

    public void notifyExpressionListener() {
        if (this.expressionListener != null) {
            this.expressionListener.stateChanged(new ChangeEvent(new Object()));
        }
    }

    private void setNextMode(int n) {
        this.nextMode = n;
    }

    public int getNextMode() {
        return this.nextMode;
    }

    public void setActiveFieldText(Expression expression) {
        if (expression != null) {
            try {
                if (ExpressionTableModel.isValidExpression(expression)) {
                    this.function.getActiveText().setText(HuginGUIUtils.convertOctals(expression.expressionToString()));
                } else {
                    this.function.getActiveText().setText(ExpressionTableModel.extractInvalidExpression(expression, this.node.getClass().equals(UtilityNode.class)));
                }
            }
            catch (ExceptionHugin exceptionHugin) {
                this.function.getActiveText().setText("");
            }
        }
        this.function.getFunctionPanel().validate();
    }

    public void setActiveFieldText(String string) {
        this.function.getActiveText().setText(string);
        this.function.getFunctionPanel().validate();
    }

    public void setActiveTextFocus(boolean bl) {
        ParentInserterField parentInserterField = this.function.getActiveText();
        if (parentInserterField != null) {
            parentInserterField.requestFocus(bl);
        }
    }

    public String getStringExpression(String string) {
        return this.function.getStringExpression(string);
    }

    public String getStringExpression() {
        return this.function.getStringExpression();
    }

    public Expression getExpression() {
        return this.result;
    }

    public Expression getCurrentExpression() {
        Expression expression = null;
        try {
            expression = this.isEditable ? this.function.getEditedExpression() : this.function.getExpression();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return expression;
    }

    private void setSelectedFunction(Expression expression) {
        this.expression = expression;
        FunctionCategory functionCategory = this.selectionPane.getSelectedFunctionCategory();
        this.selectionPane.setSelectedFunctionCategory(this.expression);
        if (functionCategory.equals(this.selectionPane.getSelectedFunctionCategory())) {
            this.selectionPane.setSelectedFunction(this.expression, functionCategory);
        }
        this.selectionPane.validate();
    }

    private void createSelectionPane(int n) {
        int n2 = n;
        this.selectionPane = new SelectFunctionPane();
        if (n2 == -1) {
            if (this.node.getClass().equals(DiscreteChanceNode.class)) {
                n2 = ((DiscreteChanceNode)this.node).getSubtype();
            }
            if (this.node.getClass().equals(DiscreteDecisionNode.class)) {
                n2 = ((DiscreteDecisionNode)this.node).getSubtype();
            }
            if (this.node.getClass().equals(UtilityNode.class) || this.node.getClass().equals(FunctionNode.class)) {
                n2 = 5;
            }
        }
        this.selectionPane.setMode(n2);
    }

    public void createFunction(Function function) {
        this.argumentsPanel.removeAll();
        Function function2 = this.function;
        this.function = function;
        if (this.specifyArguments == null) {
            this.specifyArguments = new JPanel(new GridLayout(1, 1));
        } else {
            this.specifyArguments.removeAll();
        }
        this.specifyArguments.add(this.function.getFunctionPanel());
        if (function2 != null && !this.useExpression) {
            this.function.fromFunction(function2);
            if (this.expression != null && function instanceof NoisyOrFunction && ((NoisyOrFunction)function).emptyFields()) {
                this.function.fromExpression(this.expression);
            }
        } else {
            if (function2 != null && this.function instanceof NoisyOrFunction) {
                this.function.fromFunction(function2);
            }
            this.function.fromExpression(this.expression);
        }
        this.argumentsPanel.add(this.specifyArguments);
        this.specifyArguments.setVisible(true);
        this.specifyArguments.repaint();
        this.specifyArguments.validate();
        this.useExpression = false;
    }

    private Expression validateExpression(Expression expression) {
        Expression expression2 = expression;
        if (expression2 != null) {
            try {
                if (ExpressionTableModel.isValidExpression(expression2)) {
                    ExpressionList expressionList;
                    CompositeExpression compositeExpression;
                    CompositeExpression compositeExpression2;
                    ExpressionList expressionList2;
                    ExpressionList expressionList3 = ((CompositeExpression)expression2).getOperands();
                    if (expression2.getOperator() == 95 && expressionList3.size() > 2) {
                        expressionList2 = new ExpressionList();
                        expressionList2.add(expressionList3.get(expressionList3.size() - 1));
                        compositeExpression2 = new OrExpression(expressionList2);
                        expressionList3.remove(expressionList3.size() - 1);
                        compositeExpression = new OrExpression(expressionList3);
                        expressionList = new ExpressionList();
                        expressionList.add(compositeExpression);
                        expressionList.add(compositeExpression2);
                        expression2 = new OrExpression(expressionList);
                    }
                    if (expression2.getOperator() == 94 && expressionList3.size() > 2) {
                        expressionList2 = new ExpressionList();
                        expressionList2.add(expressionList3.get(expressionList3.size() - 1));
                        compositeExpression2 = new AndExpression(expressionList2);
                        expressionList3.remove(expressionList3.size() - 1);
                        compositeExpression = new AndExpression(expressionList3);
                        expressionList = new ExpressionList();
                        expressionList.add(compositeExpression);
                        expressionList.add(compositeExpression2);
                        expression2 = new AndExpression(expressionList);
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("Exception in validateExpression " + exception.getMessage());
            }
        }
        return expression2;
    }

    public String wrapInHtml(String string, boolean bl) {
        return this.wrapInHtml(string, bl, this.getFont().getSize());
    }

    public String wrapInHtml(String string, boolean bl, int n) {
        String[] stringArray = string.split("\n");
        String string2 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            string2 = i != 0 ? string2 + "<br>" + string3 : (bl ? "<B>" + string3 + "</B>" : string3);
        }
        String string4 = "<html><style type=\"text/css\">.style1{font-size: \"" + n + "pt\";" + "}" + "</style>" + "<p class=\"style1\">" + string2 + "</p>" + "</html>";
        return string4;
    }

    static /* synthetic */ String[] access$1902(ExpressionBuilderPanel expressionBuilderPanel, String[] stringArray) {
        expressionBuilderPanel.userArguments = stringArray;
        return stringArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InvalidExpression {
        private String name = "";
        Vector<String> args = new Vector();

        public InvalidExpression(String string, Vector<String> vector) {
            this.name = string;
            this.args = vector;
        }

        public InvalidExpression(String string) {
            this.parseExpression(string);
        }

        public InvalidExpression(Expression expression, boolean bl) {
            String string = "";
            try {
                string = ExpressionTableModel.extractInvalidExpression(expression, bl);
                this.parseExpression(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String getName() {
            return this.name;
        }

        public Vector<String> getArguments() {
            return this.args;
        }

        private void parseExpression(String string) {
            Object object;
            String string2 = string.trim().toLowerCase();
            Vector<String> vector = new Vector<String>(ExpressionTableModel.getOperatorMap().values());
            for (int i = 0; i < vector.size(); ++i) {
                object = vector.get(i);
                if (!string2.startsWith(((String)object).trim().toLowerCase()) || !this.isWrapped(string2.replaceFirst(((String)object).trim(), ""))) continue;
                this.name = object;
                this.args = this.extractArguments(string, this.name);
            }
            if (this.name.length() == 0) {
                char[] cArray;
                HashMap<String, String> hashMap = ExpressionTableModel.getOperatorMap2();
                vector = new Vector<String>(hashMap.keySet());
                object = new Vector();
                int n = 0;
                int n2 = -1;
                String string3 = string.trim();
                if (this.isWrapped(string3) && string3.length() > 1) {
                    string3 = string3.substring(1, string3.length() - 1);
                }
                for (char c : cArray = string3.toCharArray()) {
                    ++n2;
                    if (c == '(') {
                        ++n;
                    }
                    if (c == ')') {
                        --n;
                    }
                    for (int i = 0; i < vector.size() && this.name.length() == 0; ++i) {
                        String string4;
                        String string5;
                        String string6 = vector.get(i);
                        String string7 = "" + c;
                        boolean bl = false;
                        if (!string6.startsWith(string7) || n != 0) continue;
                        try {
                            string5 = string7 + cArray[n2 + 1];
                            string4 = hashMap.get(string5);
                            if (string4 != null) {
                                string6 = string4;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.name = hashMap.get(string6);
                        string5 = this.unWrap(string3.substring(0, n2).trim());
                        string4 = this.unWrap(string3.substring(n2 + string6.length()).trim());
                        ((Vector)object).add(string5);
                        ((Vector)object).add(string4);
                        this.args = object;
                    }
                }
            }
            if (this.name.length() == 0 && !string.equals(HuginGUIConstants.get("str_undefined"))) {
                this.args.add(string);
            }
        }

        private Vector<String> extractArguments(String string, String string2) {
            Vector<String> vector = new Vector<String>();
            try {
                int n;
                String string3;
                String string4 = string.trim();
                String string5 = string2.trim();
                if (string4.toLowerCase().startsWith(string5.toLowerCase())) {
                    string3 = string4.substring(string5.length());
                    if (this.isWrapped(string3)) {
                        string3 = this.unWrap(string3);
                    }
                } else {
                    int n2 = string.indexOf("(");
                    n = string.lastIndexOf(")");
                    string3 = string.substring(n2 + 1, n);
                }
                char[] cArray = string3.toCharArray();
                n = 0;
                String string6 = "";
                for (char c : cArray) {
                    if (c == '(') {
                        ++n;
                    }
                    if (c == ')') {
                        --n;
                    }
                    if (c == ',' && n == 0) {
                        vector.add(string6.trim());
                        string6 = "";
                        continue;
                    }
                    string6 = string6 + c;
                }
                vector.add(string6.trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return vector;
        }

        protected boolean isWrapped(String string) {
            String string2 = string.toLowerCase().trim();
            char[] cArray = string2.toCharArray();
            boolean bl = true;
            int n = 0;
            for (int i = 0; i < cArray.length; ++i) {
                char c = cArray[i];
                if (c == '(') {
                    ++n;
                }
                if (c == ')') {
                    --n;
                }
                if (n == 0 && i != cArray.length - 1) {
                    return false;
                }
                if (n == 0 || i != cArray.length - 1) continue;
                return false;
            }
            return true;
        }

        protected String unWrap(String string) {
            if (this.isWrapped(string = string.trim()) && string.length() > 1) {
                return string.substring(1, string.length() - 1);
            }
            return string;
        }
    }

    private class ExpressionParser
    implements ParseListener {
        private ExpressionParser() {
        }

        public void parseError(int n, String string) {
        }
    }

    private class TempNode {
        COM.hugin.HAPI.Node apiNode;
        Node node;
        String name;
        String label;

        public TempNode(Node node) {
            this.node = node;
            try {
                this.name = node.getAPINode().getName();
                if (node.isOutputClone()) {
                    InstanceNode instanceNode = (InstanceNode)node.getAPINode().getInstance();
                    boolean bl = false;
                    String string = instanceNode.getLabel();
                    if (string == null || string.length() == 0) {
                        this.label = instanceNode.getName() + ".";
                    } else {
                        this.label = string + ".";
                        bl = true;
                    }
                    String string2 = node.getLabel();
                    if (string2 == null || string2.length() == 0) {
                        this.label = this.label + node.getName();
                    } else {
                        this.label = this.label + string2;
                        bl = true;
                    }
                    if (!bl) {
                        this.label = "";
                    }
                } else {
                    this.label = node.getAPINode().getLabel();
                }
                this.label = this.label.replace('\n', ' ');
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            String string = this.label.length() > 0 ? this.label + " (" + this.name + ")" : this.name;
            return string;
        }

        public boolean equals(Object object) {
            if (object.getClass() != TempNode.class) {
                return false;
            }
            return ((TempNode)object).name.equals(this.name);
        }
    }

    private class DistributionFunction
    extends Function {
        Vector<ParentInserterField> stateFunctions;
        Vector<JButton> stateButtons;
        ParentInserterField tempExpression;

        public DistributionFunction() {
            this.expressionType = 73;
            this.name = "Distribution";
            this.termType = -1;
            this.stateFunctions = new Vector();
            this.stateButtons = new Vector();
            this.createFunctionPanel();
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Distribution");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String string = this.name + " (";
            for (int i = 0; i < this.stateFunctions.size(); ++i) {
                ParentInserterField parentInserterField = this.stateFunctions.get(i);
                String string2 = parentInserterField.getText();
                if (string2.length() <= 0) {
                    string2 = "?";
                }
                string = i == 0 ? string + string2 : string + " ," + string2;
            }
            return string + ")";
        }

        public String getStringExpression(String string) {
            String string2 = this.name + " (";
            for (int i = 0; i < this.stateFunctions.size(); ++i) {
                ParentInserterField parentInserterField = this.stateFunctions.get(i);
                String string3 = "";
                string3 = parentInserterField.equals(this.activeTextField) ? string : parentInserterField.getText();
                if (string3.length() <= 0) {
                    string3 = "?";
                }
                string2 = i == 0 ? string2 + string3 : string2 + " ," + string3;
            }
            return string2 + ")";
        }

        public void clearFields(boolean bl) {
            for (ParentInserterField parentInserterField : this.stateFunctions) {
                parentInserterField.setText("");
            }
            if (bl) {
                ExpressionBuilderPanel.this.clearUserInput();
            }
        }

        public Expression getExpression() throws ExceptionHugin {
            DistributionDistribution distributionDistribution = null;
            ExpressionList expressionList = new ExpressionList();
            for (int i = 0; i < this.stateFunctions.size(); ++i) {
                expressionList.add(Expression.stringToExpression(this.stateFunctions.get(i).getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser));
            }
            distributionDistribution = new DistributionDistribution(expressionList);
            return distributionDistribution;
        }

        public void createFunctionPanel() {
            try {
                this.parents = ExpressionBuilderPanel.this.node.getAPINode().getParents();
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
            this.result = new JPanel(new BorderLayout());
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel(new BorderLayout());
            JLabel jLabel = new JLabel(new ImageIcon(ClassLoader.getSystemResource("icons/functionArguments.gif")));
            jPanel2.add((Component)jLabel, "North");
            TitledPanel titledPanel = new TitledPanel("Arguments(" + this.name + ")");
            titledPanel.setLayout(new BorderLayout());
            JPanel jPanel3 = new JPanel();
            int n = 0;
            try {
                n = ExpressionBuilderPanel.this.node instanceof DiscreteNode ? ((COM.hugin.HAPI.DiscreteNode)ExpressionBuilderPanel.this.node.getAPINode()).getNumberOfStates() : 1;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
            JPanel jPanel4 = new JPanel(new GridLayout(n, 1));
            JPanel jPanel5 = new JPanel(new GridLayout(n, 1));
            JPanel jPanel6 = new JPanel(new BorderLayout());
            JPanel jPanel7 = new JPanel(new BorderLayout());
            JScrollPane jScrollPane = new JScrollPane(jPanel7);
            jScrollPane.setPreferredSize(ExpressionBuilderPanel.this.argScrollDim);
            String string = HuginGUIConstants.get("str_error");
            for (int i = 0; i < n; ++i) {
                try {
                    string = ExpressionBuilderPanel.this.node instanceof DiscreteNode ? HuginGUIUtils.getNodeStateLabel(ExpressionBuilderPanel.this.node.getAPINode(), i) : HuginGUIConstants.get("str_utility");
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
                jPanel4.add(new JLabel(string));
                JPanel jPanel8 = new JPanel(new BorderLayout());
                this.tempExpression = new ParentInserterField(this.parents);
                this.tempExpression.getDocument().addDocumentListener(new Function.ExpressionDocumentListener());
                this.tempExpression.getDocument().putProperty("name", "text" + i);
                this.tempExpression.addFocusListener(new DistributionFocusAdapter(i));
                JButton jButton = new JButton(HuginGUIConstants.get("EBW_BUTTON_Fx"));
                jButton.addActionListener(new DistributionActionListener(i));
                jPanel8.add(this.tempExpression);
                jPanel8.add((Component)jButton, "East");
                this.stateButtons.add(jButton);
                this.stateFunctions.add(this.tempExpression);
                jPanel5.add(jPanel8);
            }
            jPanel6.add(jPanel5);
            jPanel6.add((Component)jPanel4, "West");
            jPanel7.add((Component)jPanel6, "North");
            titledPanel.add((Component)jScrollPane, "North");
            jPanel.add((Component)titledPanel, "Center");
            JPanel jPanel9 = new JPanel(new BorderLayout(5, 5));
            this.expressionField = new ParentInserterField(this.parents, 30);
            this.expressionField.setEnabled(false);
            this.expressionField.getDocument().addDocumentListener(new Function.Expression1DocumentListener());
            this.expressionField.getDocument().putProperty("name", "expressionField");
            this.expressionLabel = new JLabel("<html><B>" + HuginGUIConstants.get("EBW_LABEL_Local_Exp") + "</B></html>");
            JPanel jPanel10 = new JPanel(new BorderLayout(5, 5));
            this.editButton = new JButton(HuginGUIConstants.get("EBW_BUTTON_Edit"));
            this.editButton.addActionListener(new Function.EditListener());
            jPanel10.add((Component)this.expressionField, "Center");
            jPanel10.add((Component)this.editButton, "East");
            jPanel9.add((Component)this.expressionLabel, "West");
            jPanel9.add((Component)jPanel10, "South");
            jPanel.add((Component)jPanel9, "South");
            JPanel jPanel11 = new JPanel(new BorderLayout(5, 5));
            jPanel11.setPreferredSize(ExpressionBuilderPanel.this.wrapPanelDim);
            JPanel jPanel12 = new JPanel(new GridLayout(1, 1));
            String string2 = ExpressionBuilderPanel.this.wrapInHtml(this.getDescription(), true);
            JLabel jLabel2 = new JLabel(string2);
            jPanel12.add((Component)jLabel2, 0);
            jPanel11.add((Component)jPanel, "North");
            jPanel11.add((Component)jPanel12, "Center");
            this.result.add((Component)jPanel11, "Center");
        }

        public void setEditMode(boolean bl) {
            JComponent jComponent;
            int n;
            for (n = 0; n < this.stateFunctions.size(); ++n) {
                jComponent = this.stateFunctions.get(n);
                jComponent.setEnabled(bl);
            }
            for (n = 0; n < this.stateButtons.size(); ++n) {
                jComponent = this.stateButtons.get(n);
                ((AbstractButton)jComponent).setEnabled(bl);
            }
        }

        public void fromFunction(Function function) {
            ExpressionBuilderPanel.access$1902(ExpressionBuilderPanel.this, function.getAllArguments());
            function.clearFields(false);
            try {
                for (int i = 0; i < ExpressionBuilderPanel.this.userArguments.length; ++i) {
                    this.stateFunctions.get(i).setText(ExpressionBuilderPanel.this.userArguments[i]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String[] getAllArguments() {
            int n = this.stateFunctions.size();
            for (int i = 0; i < n; ++i) {
                ((ExpressionBuilderPanel)ExpressionBuilderPanel.this).userArguments[i] = this.stateFunctions.get(i).getText();
            }
            return ExpressionBuilderPanel.this.userArguments;
        }

        public void fromExpression(Expression expression) {
            if (expression == null) {
                return;
            }
            if (!ExpressionTableModel.isValidExpression(expression)) {
                try {
                    InvalidExpression invalidExpression = new InvalidExpression(expression, ExpressionBuilderPanel.this.node.getClass().equals(UtilityNode.class));
                    Vector<String> vector = invalidExpression.getArguments();
                    for (int i = 0; i < vector.size(); ++i) {
                        this.stateFunctions.get(i).setText(vector.get(i));
                    }
                }
                catch (Exception exception) {}
            } else {
                if (!expression.getClass().equals(DistributionDistribution.class)) {
                    return;
                }
                try {
                    ExpressionList expressionList = ((DistributionDistribution)expression).getOperands();
                    int n = 0;
                    ListIterator listIterator = expressionList.listIterator(0);
                    while (listIterator.hasNext() && n < this.stateFunctions.size()) {
                        Expression expression2 = (Expression)listIterator.next();
                        this.stateFunctions.get(n++).setText(HuginGUIUtils.convertOctals(expression2.expressionToString()));
                    }
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
        }

        private class DistributionFocusAdapter
        extends FocusAdapter {
            int index;

            public DistributionFocusAdapter(int n) {
                this.index = n;
            }

            public void focusGained(FocusEvent focusEvent) {
                DistributionFunction.this.activeTextField = DistributionFunction.this.stateFunctions.get(this.index);
            }
        }

        private class DistributionActionListener
        implements ActionListener {
            int index;

            public DistributionActionListener(int n) {
                this.index = n;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Expression expression = null;
                String string = DistributionFunction.this.stateFunctions.get(this.index).getText();
                ParentInserterField parentInserterField = DistributionFunction.this.stateFunctions.get(this.index);
                if (string.length() > 0) {
                    try {
                        expression = Expression.stringToExpression(string, ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
                    }
                    catch (Exception exception) {
                        expression = ExpressionTableModel.createValidExpression(string, ExpressionBuilderPanel.this.node.getClass().equals(UtilityNode.class));
                    }
                }
                ExpressionBuilderPanel.this.setNextMode(17);
                if (ExpressionBuilderPanel.this.functionListener != null) {
                    DistributionFunction.this.activeTextField = parentInserterField;
                    Object object = expression == null ? new Object() : expression;
                    ExpressionBuilderPanel.this.functionListener.stateChanged(new ChangeEvent(object));
                }
            }
        }
    }

    private class NodeStringPair {
        String value;
        Node node;

        public NodeStringPair(Node node, String string) {
            this.value = string;
            this.node = node;
        }

        public void setNode(Node node) {
            this.node = node;
        }

        public void setString(String string) {
            this.value = string;
        }

        public Node getNode() {
            return this.node;
        }

        public String getDouble() {
            return this.value;
        }

        public Object getObject(int n) {
            if (n == 0) {
                return this.node;
            }
            if (n == 1) {
                return this.value;
            }
            return null;
        }

        public void setObject(int n, Object object) {
            try {
                if (n == 0) {
                    this.node = (Node)object;
                }
                if (n == 1) {
                    this.value = object instanceof String ? (String)object : object.toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class NoisyOrFunction
    extends Function {
        JTable inhibitorProbs;
        JButton next;
        int booleanParents;
        final String ZERO = "0";

        public NoisyOrFunction() {
            this.ZERO = "0";
            this.expressionType = 74;
            this.name = "NoisyOR";
            this.termType = -1;
            this.booleanParents = 0;
            this.createFunctionPanel();
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Noisy_Or");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String string = this.name + " (";
            try {
                InhibitorModel inhibitorModel = (InhibitorModel)this.inhibitorProbs.getModel();
                for (int i = 0; i < inhibitorModel.getRowCount(); ++i) {
                    string = i == 0 ? string + ((Node)inhibitorModel.getValueAt(i, 0)).getAPINode().getName() : string + ", " + ((Node)inhibitorModel.getValueAt(i, 0)).getAPINode().getName();
                    string = string + ", " + inhibitorModel.getValueAt(i, 1).toString();
                }
                string = inhibitorModel.getRowCount() == 0 ? string + "true" : string + ", true";
                String string2 = this.text2.getText();
                if (string2.length() == 0) {
                    string2 = "?";
                }
                string = string + ", " + string2;
            }
            catch (ExceptionHugin exceptionHugin) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            return string + ")";
        }

        public String getStringExpression(String string) {
            String string2 = this.name + " (";
            try {
                InhibitorModel inhibitorModel = (InhibitorModel)this.inhibitorProbs.getModel();
                for (int i = 0; i < inhibitorModel.getRowCount(); ++i) {
                    string2 = i == 0 ? string2 + ((Node)inhibitorModel.getValueAt(i, 0)).getAPINode().getName() : string2 + ", " + ((Node)inhibitorModel.getValueAt(i, 0)).getAPINode().getName();
                    string2 = string2 + ", " + inhibitorModel.getValueAt(i, 1).toString();
                }
                string2 = inhibitorModel.getRowCount() == 0 ? string2 + "true" : string2 + ", true";
                String string3 = this.text2.getText();
                if (this.text2.equals(this.activeTextField)) {
                    string3 = string;
                } else if (string3.length() == 0) {
                    string3 = "?";
                }
                string2 = string2 + ", " + string3;
            }
            catch (ExceptionHugin exceptionHugin) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            return string2 + ")";
        }

        public void clearFields(boolean bl) {
            if (bl) {
                this.inhibitorProbs.setModel(new InhibitorModel(ExpressionBuilderPanel.this.node));
                if (this.booleanParents > 0) {
                    this.inhibitorProbs.setRowSelectionInterval(0, 0);
                }
                this.text2.setText("1");
                this.clearUserInput();
            }
        }

        public boolean emptyFields() {
            InhibitorModel inhibitorModel = (InhibitorModel)this.inhibitorProbs.getModel();
            for (int i = 0; i < inhibitorModel.getRowCount(); ++i) {
                String string = inhibitorModel.getValueAt(i, 1).toString();
                if (string.equals("0") && string == "0") continue;
                return false;
            }
            return true;
        }

        public Expression getExpression() throws ExceptionHugin {
            InhibitorModel inhibitorModel = (InhibitorModel)this.inhibitorProbs.getModel();
            ExpressionList expressionList = new ExpressionList();
            for (int i = 0; i < inhibitorModel.getRowCount(); ++i) {
                expressionList.add(new NodeExpression(((Node)inhibitorModel.getValueAt(i, 0)).getAPINode()));
                expressionList.add(Expression.stringToExpression(inhibitorModel.getValueAt(i, 1).toString(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser));
            }
            expressionList.add(new BooleanExpression(true));
            expressionList.add(Expression.stringToExpression(this.text2.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser));
            return new NoisyOrDistribution(expressionList);
        }

        public void createFunctionPanel() {
            try {
                this.parents = ExpressionBuilderPanel.this.node.getAPINode().getParents();
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
            this.expressionField = new ParentInserterField(this.parents, 30);
            this.result = new JPanel(new BorderLayout());
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel(new BorderLayout());
            JLabel jLabel = new JLabel(new ImageIcon(ClassLoader.getSystemResource("icons/functionArguments.gif")));
            jPanel2.add((Component)jLabel, "North");
            TitledPanel titledPanel = new TitledPanel("Arguments(" + this.name + ")");
            titledPanel.setLayout(new BorderLayout());
            JLabel jLabel2 = new JLabel("Inhibitor Probabilities");
            this.text1 = new ParentInserterField(this.parents, 25);
            this.inhibitorProbs = new JTable(new InhibitorModel(ExpressionBuilderPanel.this.node)){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    super.valueChanged(listSelectionEvent);
                    int n = this.getSelectedRow();
                    if (n > -1) {
                        NoisyOrFunction.this.text1.setText(this.getModel().getValueAt(n, 1).toString());
                    }
                }
            };
            this.inhibitorProbs.getColumnModel().getColumn(1).setPreferredWidth(30);
            this.inhibitorProbs.setShowGrid(false);
            this.inhibitorProbs.setSelectionMode(0);
            this.inhibitorProbs.setBackground(Color.white);
            this.inhibitorProbs.setTableHeader(null);
            JScrollPane jScrollPane = new JScrollPane(this.inhibitorProbs);
            jScrollPane.setPreferredSize(new Dimension(200, 50));
            jScrollPane.setBorder(BorderFactory.createEtchedBorder(1));
            jScrollPane.getViewport().setBackground(Color.white);
            LinkedList<Node> linkedList = ExpressionBuilderPanel.this.node.getParents();
            Object object = linkedList.listIterator(0);
            while (object.hasNext() && this.booleanParents < 2) {
                if (!object.next().getAPINode().getClass().equals(BooleanDCNode.class)) continue;
                ++this.booleanParents;
            }
            if (this.booleanParents > 0) {
                this.inhibitorProbs.setRowSelectionInterval(0, 0);
            }
            object = new JLabel("Current Inhibitor");
            ((JComponent)object).setEnabled(this.booleanParents > 0);
            JLabel jLabel3 = new JLabel("Default Inhibitor");
            JPanel jPanel3 = new JPanel(new BorderLayout());
            JPanel jPanel4 = new JPanel(new GridLayout(2, 1));
            jPanel4.add((Component)object);
            jPanel4.add(jLabel3);
            JPanel jPanel5 = new JPanel(new GridLayout(2, 1));
            this.text1.setEnabled(this.booleanParents > 0);
            this.text1.setText("0");
            this.text1.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent focusEvent) {
                    NoisyOrFunction.this.activeTextField = NoisyOrFunction.this.text1;
                }
            });
            this.text1.getDocument().addDocumentListener(new NoisyOrDocumentListener());
            this.text1.getDocument().putProperty("name", "text1");
            this.text2 = new ParentInserterField(this.parents, 25);
            this.text2.setText("1");
            this.text2.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent focusEvent) {
                    NoisyOrFunction.this.activeTextField = NoisyOrFunction.this.text2;
                }
            });
            this.text2.getDocument().addDocumentListener(new Function.ExpressionDocumentListener());
            this.text2.getDocument().putProperty("name", "text2");
            jPanel5.add(this.text1);
            jPanel5.add(this.text2);
            JPanel jPanel6 = new JPanel(new GridLayout(2, 1));
            JPanel jPanel7 = new JPanel(new GridLayout(1, 2));
            this.select1 = new JButton(HuginGUIConstants.get("EBW_BUTTON_Fx"));
            this.select1.setEnabled(this.booleanParents > 0);
            this.select1.addActionListener(new Function.SelectListener(16, this.text1));
            this.next = new JButton("Next");
            this.next.setEnabled(this.booleanParents > 1);
            this.next.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = NoisyOrFunction.this.inhibitorProbs.getSelectedRow() + 1;
                    if (n >= NoisyOrFunction.this.inhibitorProbs.getModel().getRowCount()) {
                        n = 0;
                    }
                    NoisyOrFunction.this.inhibitorProbs.setRowSelectionInterval(n, n);
                }
            });
            jPanel7.add(this.select1);
            jPanel7.add(this.next);
            JPanel jPanel8 = new JPanel(new BorderLayout());
            this.select2 = new JButton(HuginGUIConstants.get("EBW_BUTTON_Fx"));
            this.select2.addActionListener(new Function.SelectListener(16, this.text2));
            jPanel8.add((Component)this.select2, "West");
            jPanel6.add(jPanel7);
            jPanel6.add(jPanel8);
            jPanel3.add((Component)jPanel4, "West");
            jPanel3.add((Component)jPanel5, "Center");
            jPanel3.add((Component)jPanel6, "East");
            titledPanel.add((Component)jLabel2, "North");
            titledPanel.add((Component)jScrollPane, "Center");
            titledPanel.add((Component)jPanel3, "South");
            jPanel.add((Component)titledPanel, "Center");
            JPanel jPanel9 = new JPanel(new BorderLayout(5, 5));
            this.expressionField.setEnabled(false);
            this.expressionField.getDocument().addDocumentListener(new Function.Expression1DocumentListener());
            this.expressionField.getDocument().putProperty("name", "expressionField");
            this.expressionLabel = new JLabel("<html><B>" + HuginGUIConstants.get("EBW_LABEL_Local_Exp") + "</B></html>");
            JPanel jPanel10 = new JPanel(new BorderLayout(5, 5));
            this.editButton = new JButton(HuginGUIConstants.get("EBW_BUTTON_Edit"));
            this.editButton.addActionListener(new Function.EditListener());
            jPanel10.add((Component)this.expressionField, "Center");
            jPanel10.add((Component)this.editButton, "East");
            jPanel9.add((Component)this.expressionLabel, "West");
            jPanel9.add((Component)jPanel10, "South");
            jPanel.add((Component)jPanel9, "South");
            JPanel jPanel11 = new JPanel(new BorderLayout(5, 5));
            jPanel11.setPreferredSize(ExpressionBuilderPanel.this.wrapPanelDim);
            JPanel jPanel12 = new JPanel(new GridLayout(1, 1));
            String string = ExpressionBuilderPanel.this.wrapInHtml(this.getDescription(), true);
            JLabel jLabel4 = new JLabel(string);
            jPanel12.add((Component)jLabel4, 0);
            jPanel11.add((Component)jPanel, "North");
            jPanel11.add((Component)jPanel12, "Center");
            this.result.add((Component)jPanel11, "Center");
        }

        public void setEditMode(boolean bl) {
            if (bl) {
                this.text1.setEnabled(this.booleanParents > 0);
                this.select1.setEnabled(this.booleanParents > 0);
                this.next.setEnabled(this.booleanParents > 0);
            } else {
                this.text1.setEnabled(bl);
                this.select1.setEnabled(bl);
                this.next.setEnabled(bl);
            }
            this.text2.setEnabled(bl);
            this.select2.setEnabled(bl);
        }

        public void clearUserInput() {
        }

        public String[] getAllArguments() {
            return ExpressionBuilderPanel.this.userArguments;
        }

        public void fromFunction(Function function) {
            ExpressionBuilderPanel.access$1902(ExpressionBuilderPanel.this, function.getAllArguments());
            function.clearFields(false);
        }

        public void fromExpression(Expression expression) {
            if (expression == null) {
                return;
            }
            if (!expression.getClass().equals(NoisyOrDistribution.class)) {
                return;
            }
            try {
                int n;
                Expression expression2;
                ExpressionList expressionList = ((NoisyOrDistribution)expression).getOperands();
                int n2 = 0;
                InhibitorModel inhibitorModel = (InhibitorModel)this.inhibitorProbs.getModel();
                ListIterator listIterator = expressionList.listIterator(0);
                while (listIterator.hasNext() && n2 < inhibitorModel.getRowCount()) {
                    expression2 = (Expression)listIterator.next();
                    if (!expression2.getClass().equals(NodeExpression.class)) continue;
                    inhibitorModel.setValueAt(((ExpressionBuilderPanel)ExpressionBuilderPanel.this).guiFrame.getSelectedProjectFrame().networkPanel.getNode(((NodeExpression)expression2).getNode()), n2, 0);
                    if (listIterator.hasNext()) {
                        expression2 = (Expression)listIterator.next();
                        inhibitorModel.setValueAt(HuginGUIUtils.convertOctals(expression2.expressionToString()), n2, 1);
                    }
                    ++n2;
                }
                if (expressionList.size() > 0) {
                    expression2 = (Expression)expressionList.get(expressionList.size() - 1);
                    this.text2.setText(HuginGUIUtils.convertOctals(expression2.expressionToString()));
                }
                if ((n = inhibitorModel.getRowCount() - 1) >= 0) {
                    this.inhibitorProbs.setRowSelectionInterval(n, n);
                    this.text1.setText(inhibitorModel.getValueAt(n, 1).toString());
                }
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }

        private class InhibitorModel
        extends DefaultTableModel {
            Vector<NodeStringPair> rows = new Vector();

            public InhibitorModel(Node node) {
                LinkedList<Node> linkedList = node.getParents();
                ListIterator<Node> listIterator = linkedList.listIterator(0);
                while (listIterator.hasNext()) {
                    Node node2 = listIterator.next();
                    if (!node2.getAPINode().getClass().equals(BooleanDCNode.class)) continue;
                    NodeStringPair nodeStringPair = new NodeStringPair(node2, "0");
                    this.rows.add(nodeStringPair);
                }
            }

            public int getRowCount() {
                if (this.rows == null) {
                    return 0;
                }
                return this.rows.size();
            }

            public int getColumnCount() {
                return 2;
            }

            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            public Object getValueAt(int n, int n2) {
                if (this.rows == null) {
                    return null;
                }
                return this.rows.get(n).getObject(n2);
            }

            public void setValueAt(Object object, int n, int n2) {
                this.rows.get(n).setObject(n2, object);
            }
        }

        private class NoisyOrDocumentListener
        implements DocumentListener {
            private NoisyOrDocumentListener() {
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.updateExpressionField(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.updateExpressionField(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            private void updateExpressionField(DocumentEvent documentEvent) {
                try {
                    String string = NoisyOrFunction.this.text1.getText();
                    if (string.length() > 0) {
                        NoisyOrFunction.this.inhibitorProbs.setValueAt(string, NoisyOrFunction.this.inhibitorProbs.getSelectedRow(), 1);
                    } else {
                        NoisyOrFunction.this.inhibitorProbs.setValueAt("0", NoisyOrFunction.this.inhibitorProbs.getSelectedRow(), 1);
                    }
                    NoisyOrFunction.this.inhibitorProbs.repaint();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                NoisyOrFunction.this.expressionField.setText(ExpressionBuilderPanel.this.function.getStringExpression());
                NoisyOrFunction.this.expressionField.setToolTipText(NoisyOrFunction.this.expressionField.getText());
            }
        }
    }

    private class TruncateFunction
    extends Function {
        public TruncateFunction() {
            this.expressionType = 75;
            this.name = "truncate";
            this.termType = 7;
            this.optionalExists = true;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(3, this.text1));
            this.select2.addActionListener(new Function.SelectListener(3, this.text2));
            this.select3.addActionListener(new Function.SelectListener(12, this.text3));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Truncate");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            if (stringArray[2] == "?") {
                return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ")";
            }
            return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ", " + stringArray[2] + ")";
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            if (stringArray[2] == "?") {
                return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ")";
            }
            return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ", " + stringArray[2] + ")";
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            Expression expression3 = Expression.stringToExpression(this.text3.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            if (expression3 != null) {
                return new TruncateExpression(expression, expression2, expression3);
            }
            return new TruncateExpression(expression, expression2);
        }
    }

    private class PERTFunction
    extends Function {
        public PERTFunction() {
            this.optionalExists = true;
            this.expressionType = 68;
            this.name = "PERT";
            this.termType = 17;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(15, this.text1));
            this.select2.addActionListener(new Function.SelectListener(15, this.text2));
            this.select3.addActionListener(new Function.SelectListener(15, this.text3));
            this.select4.addActionListener(new Function.SelectListener(15, this.text4));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Pert");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            if (stringArray[3] != "?") {
                return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ", " + stringArray[2] + ", " + stringArray[3] + ")";
            }
            return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ", " + stringArray[2] + ")";
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            if (stringArray[3] != "?") {
                return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ", " + stringArray[2] + ", " + stringArray[3] + ")";
            }
            return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ", " + stringArray[2] + ")";
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            Expression expression3 = Expression.stringToExpression(this.text3.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            Expression expression4 = null;
            if (this.text4.getText().length() > 0) {
                expression4 = Expression.stringToExpression(this.text4.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            }
            if (expression4 != null) {
                return new PERTDistribution(expression, expression2, expression3, expression4);
            }
            return new PERTDistribution(expression, expression2, expression3);
        }
    }

    private class TriangularFunction
    extends Function {
        public TriangularFunction() {
            this.expressionType = 67;
            this.name = "Triangular";
            this.termType = 16;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(15, this.text1));
            this.select2.addActionListener(new Function.SelectListener(15, this.text2));
            this.select3.addActionListener(new Function.SelectListener(15, this.text3));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Triangular");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ", " + stringArray[2] + ")";
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ", " + stringArray[2] + ")";
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            Expression expression3 = Expression.stringToExpression(this.text3.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            return new TriangularDistribution(expression, expression2, expression3);
        }
    }

    private class UniformFunction
    extends Function {
        public UniformFunction() {
            this.expressionType = 66;
            this.name = "Uniform";
            this.termType = 15;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(15, this.text1));
            this.select2.addActionListener(new Function.SelectListener(15, this.text2));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Uniform");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ")";
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ")";
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            return new UniformDistribution(expression, expression2);
        }
    }

    private class WeibullFunction
    extends Function {
        public WeibullFunction() {
            this.optionalExists = true;
            this.expressionType = 65;
            this.name = "Weibull";
            this.termType = 13;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(15, this.text1));
            this.select2.addActionListener(new Function.SelectListener(15, this.text2));
            this.select3.addActionListener(new Function.SelectListener(15, this.text3));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Weibull");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            if (stringArray[2] != "?") {
                return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ", " + stringArray[2] + ")";
            }
            return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ")";
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            if (stringArray[2] != "?") {
                return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ", " + stringArray[2] + ")";
            }
            return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ")";
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            Expression expression3 = null;
            if (this.text3.getText().length() > 0) {
                expression3 = Expression.stringToExpression(this.text3.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            }
            if (expression3 != null) {
                return new WeibullDistribution(expression, expression2, expression3);
            }
            return new WeibullDistribution(expression, expression2);
        }

        protected boolean threeParameterSupport(Node node) {
            try {
                Expression.stringToExpression("Weibull(1,2,3)", node.getAPINode().getModel(), null);
            }
            catch (ExceptionHugin exceptionHugin) {
                return false;
            }
            return true;
        }
    }

    private class ExponentialFunction
    extends Function {
        public ExponentialFunction() {
            this.optionalExists = true;
            this.expressionType = 64;
            this.name = "Exponential";
            this.termType = 14;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(15, this.text1));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Exponential");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            if (stringArray[1] != "?") {
                return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ")";
            }
            return this.name + " (" + stringArray[0] + ")";
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            if (stringArray[1] != "?") {
                return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ")";
            }
            return this.name + " (" + stringArray[0] + ")";
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            Expression expression2 = null;
            if (this.text2.getText().length() > 0) {
                expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            }
            if (expression2 != null) {
                return new ExponentialDistribution(expression, expression2);
            }
            return new ExponentialDistribution(expression);
        }
    }

    private class GammaFunction
    extends Function {
        public GammaFunction() {
            this.optionalExists = true;
            this.expressionType = 63;
            this.name = "Gamma";
            this.termType = 20;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(15, this.text1));
            this.select2.addActionListener(new Function.SelectListener(15, this.text2));
            this.select3.addActionListener(new Function.SelectListener(15, this.text3));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Gamma");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            if (stringArray[2] != "?") {
                return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ", " + stringArray[2] + ")";
            }
            return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ")";
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            if (stringArray[2] != "?") {
                return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ", " + stringArray[2] + ")";
            }
            return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ")";
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            Expression expression3 = null;
            if (this.text3.getText().length() > 0) {
                expression3 = Expression.stringToExpression(this.text3.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            }
            if (expression3 != null) {
                return new GammaDistribution(expression, expression2, expression3);
            }
            return new GammaDistribution(expression, expression2);
        }
    }

    private class BetaFunction
    extends Function {
        public BetaFunction() {
            this.expressionType = 62;
            this.name = "Beta";
            this.termType = 12;
            this.optionalExists = true;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(15, this.text1));
            this.select2.addActionListener(new Function.SelectListener(15, this.text2));
            this.select3.addActionListener(new Function.SelectListener(15, this.text3));
            this.select4.addActionListener(new Function.SelectListener(15, this.text4));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Beta");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            if (stringArray[2] != "?") {
                if (stringArray[3] != "?") {
                    return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ", " + stringArray[2] + ", " + stringArray[3] + ")";
                }
                return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ", " + stringArray[2] + ")";
            }
            return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ")";
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            if (stringArray[2] != "?") {
                if (stringArray[3] != "?") {
                    return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ", " + stringArray[2] + ", " + stringArray[3] + ")";
                }
                return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ", " + stringArray[2] + ")";
            }
            return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ")";
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            Expression expression3 = null;
            Expression expression4 = null;
            if (this.text3.getText().length() > 0) {
                expression3 = Expression.stringToExpression(this.text3.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            }
            if (this.text4.getText().length() > 0) {
                expression4 = Expression.stringToExpression(this.text4.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            }
            if (expression3 != null && expression4 != null) {
                return new BetaDistribution(expression, expression2, expression3, expression4);
            }
            return new BetaDistribution(expression, expression2);
        }
    }

    private class LogNormalFunction
    extends Function {
        public LogNormalFunction() {
            this.optionalExists = true;
            this.expressionType = 61;
            this.name = "LogNormal";
            this.termType = 21;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(15, this.text1));
            this.select2.addActionListener(new Function.SelectListener(15, this.text2));
            this.select3.addActionListener(new Function.SelectListener(15, this.text3));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Log_Normal");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            if (stringArray[2] != "?") {
                return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ", " + stringArray[2] + ")";
            }
            return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ")";
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            if (stringArray[2] != "?") {
                return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ", " + stringArray[2] + ")";
            }
            return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ")";
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            Expression expression3 = null;
            if (this.text3.getText().length() > 0) {
                expression3 = Expression.stringToExpression(this.text3.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            }
            if (expression3 != null) {
                return new LogNormalDistribution(expression, expression2, expression3);
            }
            return new LogNormalDistribution(expression, expression2);
        }
    }

    private class NormalFunction
    extends Function {
        public NormalFunction() {
            this.expressionType = 60;
            this.name = "Normal";
            this.termType = 11;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(15, this.text1));
            this.select2.addActionListener(new Function.SelectListener(15, this.text2));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Normal");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ")";
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ")";
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            return new NormalDistribution(expression, expression2);
        }
    }

    private class PoissonFunction
    extends Function {
        public PoissonFunction() {
            this.expressionType = 70;
            this.name = "Poisson";
            this.termType = 10;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(14, this.text1));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Poisson");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            return this.name + " (" + stringArray[0] + ")";
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            return this.name + " (" + stringArray[0] + ")";
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            return new PoissonDistribution(expression);
        }
    }

    private class NegativeBinomialFunction
    extends Function {
        public NegativeBinomialFunction() {
            this.expressionType = 71;
            this.name = "NegativeBinomial";
            this.termType = 18;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(14, this.text1));
            this.select2.addActionListener(new Function.SelectListener(14, this.text2));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Negative_Binomial");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ")";
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ")";
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            return new NegativeBinomialDistribution(expression, expression2);
        }
    }

    private class GeometricFunction
    extends Function {
        public GeometricFunction() {
            this.expressionType = 72;
            this.name = "Geometric";
            this.termType = 19;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(14, this.text1));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Geometric");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            return this.name + " (" + stringArray[0] + ")";
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            return this.name + " (" + stringArray[0] + ")";
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            return new GeometricDistribution(expression);
        }
    }

    private class BinomialFunction
    extends Function {
        public BinomialFunction() {
            this.expressionType = 69;
            this.name = "Binomial";
            this.termType = 9;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(14, this.text1));
            this.select2.addActionListener(new Function.SelectListener(14, this.text2));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Binomial");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ")";
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ")";
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            return new BinomialDistribution(expression, expression2);
        }
    }

    private class IfFunction
    extends Function {
        final String ifStr = "if";

        public IfFunction() {
            this.ifStr = "if";
            this.expressionType = 93;
            this.name = "If-then-else";
            this.termType = 4;
            this.optionalExists = false;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(10, this.text1));
            this.select2.addActionListener(new Function.SelectListener(13, this.text2));
            this.select3.addActionListener(new Function.SelectListener(13, this.text3));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_If");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            return "if (" + stringArray[0] + ", " + stringArray[1] + ", " + stringArray[2] + ")";
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            return "if (" + stringArray[0] + ", " + stringArray[1] + ", " + stringArray[2] + ")";
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            Expression expression3 = Expression.stringToExpression(this.text3.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            return new IfExpression(expression, expression2, expression3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void fromExpression(Expression expression) {
            if (expression == null) {
                return;
            }
            if (!ExpressionTableModel.isValidExpression(expression)) {
                try {
                    InvalidExpression invalidExpression = new InvalidExpression(expression, ExpressionBuilderPanel.this.node.getClass().equals(UtilityNode.class));
                    Vector<String> vector = invalidExpression.getArguments();
                    if (vector.size() <= 0) return;
                    this.text1.setText(vector.get(0));
                    if (vector.size() < 2) {
                        return;
                    }
                    String string = vector.get(1);
                    this.text2.setText(string);
                    if (vector.size() < 3) {
                        return;
                    }
                    String string2 = vector.get(2);
                    this.text3.setText(string2);
                    if (vector.size() < 4) {
                        return;
                    }
                    String string3 = vector.get(3);
                    this.text4.setText(string3);
                    for (int i = 4; i < vector.size(); ++i) {
                        ((ExpressionBuilderPanel)ExpressionBuilderPanel.this).userArguments[i] = vector.get(i);
                    }
                    return;
                }
                catch (Exception exception) {
                    return;
                }
            }
            try {
                if (!expression.isCompositeExpression()) return;
                ExpressionList expressionList = ((CompositeExpression)expression).getOperands();
                ListIterator listIterator = expressionList.listIterator(0);
                if (listIterator.hasNext()) {
                    this.text1.setText(HuginGUIUtils.convertOctals(((Expression)listIterator.next()).expressionToString()));
                }
                if (!listIterator.hasNext()) {
                    return;
                }
                String string = HuginGUIUtils.convertOctals(((Expression)listIterator.next()).expressionToString());
                this.text2.setText(string);
                if (!listIterator.hasNext()) {
                    return;
                }
                String string4 = HuginGUIUtils.convertOctals(((Expression)listIterator.next()).expressionToString());
                this.text3.setText(string4);
                if (!listIterator.hasNext()) {
                    return;
                }
                String string5 = HuginGUIUtils.convertOctals(((Expression)listIterator.next()).expressionToString());
                this.text4.setText(string5);
                int n = 3;
                while (listIterator.hasNext() && n < ExpressionBuilderPanel.this.userArguments.length - 1) {
                    ((ExpressionBuilderPanel)ExpressionBuilderPanel.this).userArguments[++n] = HuginGUIUtils.convertOctals(((Expression)listIterator.next()).expressionToString());
                }
                return;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }
    }

    private class TanFunction
    extends Function {
        public TanFunction() {
            this.expressionType = 84;
            this.name = "tan";
            this.termType = 8;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(12, this.text1));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Tan");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            return this.name + " (" + stringArray[0] + ")";
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            return this.name + " (" + stringArray[0] + ")";
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            return new TanExpression(expression);
        }
    }

    private class CosFunction
    extends Function {
        public CosFunction() {
            this.expressionType = 83;
            this.name = "cos";
            this.termType = 8;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(12, this.text1));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Cos");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            return this.name + " (" + stringArray[0] + ")";
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            return this.name + " (" + stringArray[0] + ")";
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            return new CosExpression(expression);
        }
    }

    private class SinFunction
    extends Function {
        public SinFunction() {
            this.expressionType = 82;
            this.name = "sin";
            this.termType = 8;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(12, this.text1));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Sin");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            return this.name + " (" + stringArray[0] + ")";
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            return this.name + " (" + stringArray[0] + ")";
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            return new SinExpression(expression);
        }
    }

    private class TanhFunction
    extends Function {
        public TanhFunction() {
            this.expressionType = 87;
            this.name = "tanh";
            this.termType = 8;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(12, this.text1));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Tanh");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            return this.name + " (" + stringArray[0] + ")";
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            return this.name + " (" + stringArray[0] + ")";
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            return new TanhExpression(expression);
        }
    }

    private class CoshFunction
    extends Function {
        public CoshFunction() {
            this.expressionType = 86;
            this.name = "cosh";
            this.termType = 8;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(12, this.text1));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Cosh");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            return this.name + " (" + stringArray[0] + ")";
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            return this.name + " (" + stringArray[0] + ")";
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            return new CoshExpression(expression);
        }
    }

    private class SinhFunction
    extends Function {
        public SinhFunction() {
            this.expressionType = 85;
            this.name = "sinh";
            this.termType = 8;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(12, this.text1));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Sinh");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            return this.name + " (" + stringArray[0] + ")";
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            return this.name + " (" + stringArray[0] + ")";
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            return new SinhExpression(expression);
        }
    }

    private class Log10Function
    extends Function {
        public Log10Function() {
            this.expressionType = 80;
            this.name = "log10";
            this.termType = 8;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(12, this.text1));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Log10");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            return this.name + " (" + stringArray[0] + ")";
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            return this.name + " (" + stringArray[0] + ")";
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            return new Log10Expression(expression);
        }
    }

    private class Log2Function
    extends Function {
        public Log2Function() {
            this.expressionType = 79;
            this.name = "log2";
            this.termType = 8;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(12, this.text1));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Log2");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            return this.name + " (" + stringArray[0] + ")";
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            return this.name + " (" + stringArray[0] + ")";
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            return new Log2Expression(expression);
        }
    }

    private class SqrtFunction
    extends Function {
        public SqrtFunction() {
            this.expressionType = 88;
            this.name = "sqrt";
            this.termType = 8;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(12, this.text1));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Sqrt");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            return this.name + " (" + stringArray[0] + ")";
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            return this.name + " (" + stringArray[0] + ")";
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            return new SqrtExpression(expression);
        }
    }

    private class ExpFunction
    extends Function {
        public ExpFunction() {
            this.expressionType = 81;
            this.name = "exp";
            this.termType = 8;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(12, this.text1));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Exp");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            return this.name + " (" + stringArray[0] + ")";
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            return this.name + " (" + stringArray[0] + ")";
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            return new ExpExpression(expression);
        }
    }

    private class LogFunction
    extends Function {
        public LogFunction() {
            this.expressionType = 78;
            this.name = "log";
            this.termType = 8;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(12, this.text1));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Log");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            return this.name + " (" + stringArray[0] + ")";
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            return this.name + " (" + stringArray[0] + ")";
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            return new LogExpression(expression);
        }
    }

    private class CeilingFunction
    extends Function {
        final String ceil = "ceil";

        public CeilingFunction() {
            this.ceil = "ceil";
            this.expressionType = 91;
            this.name = "ceiling";
            this.termType = 8;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(12, this.text1));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Ciel");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            return "ceil (" + stringArray[0] + ")";
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            return "ceil (" + stringArray[0] + ")";
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            return new CeilExpression(expression);
        }
    }

    private class FloorFunction
    extends Function {
        public FloorFunction() {
            this.expressionType = 90;
            this.name = "floor";
            this.termType = 8;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(12, this.text1));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Floor");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            return this.name + " (" + stringArray[0] + ")";
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            return this.name + " (" + stringArray[0] + ")";
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            return new FloorExpression(expression);
        }
    }

    private class ModFunction
    extends Function {
        public ModFunction() {
            this.expressionType = 92;
            this.name = "mod";
            this.termType = 1;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(12, this.text1));
            this.select2.addActionListener(new Function.SelectListener(12, this.text2));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Mod");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ")";
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ")";
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            return new ModExpression(expression, expression2);
        }
    }

    private class AbsFunction
    extends Function {
        public AbsFunction() {
            this.expressionType = 89;
            this.name = "abs";
            this.termType = 8;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(12, this.text1));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Abs");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            return this.name + " (" + stringArray[0] + ")";
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            return this.name + " (" + stringArray[0] + ")";
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            return new AbsExpression(expression);
        }
    }

    private class NegateFunction
    extends Function {
        final String minus = "-";

        public NegateFunction() {
            this.minus = "-";
            this.expressionType = 102;
            this.name = "negate";
            this.termType = 8;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(12, this.text1));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Negation");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            return "-(" + stringArray[0] + ")";
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            return "-(" + stringArray[0] + ")";
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            return new NegateExpression(expression);
        }
    }

    private class MaxFunction
    extends Function {
        public MaxFunction() {
            this.expressionType = 77;
            this.name = "max";
            this.termType = 6;
            this.optionalExists = true;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(12, this.text1));
            this.select2.addActionListener(new Function.SelectListener(12, this.text2));
            this.select3.addActionListener(new Function.SelectListener(12, this.text3));
            this.select4.addActionListener(new Function.SelectListener(12, this.text4));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Max");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            if (stringArray[2] != "?") {
                if (stringArray[3] != "?") {
                    return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ", " + stringArray[2] + ", " + stringArray[3] + ")";
                }
                return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ", " + stringArray[2] + ")";
            }
            return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ")";
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            if (stringArray[3].length() > 0) {
                return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ", " + stringArray[2] + ", " + stringArray[3] + ")";
            }
            return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ", " + stringArray[2] + ")";
        }

        public Expression getExpression() throws ExceptionHugin {
            ExpressionList expressionList = new ExpressionList();
            expressionList.add(Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser));
            expressionList.add(Expression.stringToExpression(this.text2.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser));
            if (this.text3.getText().length() > 0) {
                expressionList.add(Expression.stringToExpression(this.text3.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser));
            }
            if (this.text4.getText().length() > 0) {
                expressionList.add(Expression.stringToExpression(this.text4.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser));
            }
            return new MaxExpression(expressionList);
        }
    }

    private class MinFunction
    extends Function {
        public MinFunction() {
            this.expressionType = 76;
            this.name = "min";
            this.termType = 6;
            this.optionalExists = true;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(12, this.text1));
            this.select2.addActionListener(new Function.SelectListener(12, this.text2));
            this.select3.addActionListener(new Function.SelectListener(12, this.text3));
            this.select4.addActionListener(new Function.SelectListener(12, this.text4));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Min");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            if (stringArray[2] != "?") {
                if (stringArray[3] != "?") {
                    return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ", " + stringArray[2] + ", " + stringArray[3] + ")";
                }
                return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ", " + stringArray[2] + ")";
            }
            return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ")";
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            if (stringArray[3].length() > 0) {
                return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ", " + stringArray[2] + ", " + stringArray[3] + ")";
            }
            return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ", " + stringArray[2] + ")";
        }

        public Expression getExpression() throws ExceptionHugin {
            ExpressionList expressionList = new ExpressionList();
            expressionList.add(Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser));
            expressionList.add(Expression.stringToExpression(this.text2.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser));
            if (this.text3.getText().length() > 0) {
                expressionList.add(Expression.stringToExpression(this.text3.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser));
            }
            if (this.text4.getText().length() > 0) {
                expressionList.add(Expression.stringToExpression(this.text4.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser));
            }
            return new MinExpression(expressionList);
        }
    }

    private class PowerFunction
    extends Function {
        final String power = "^";

        public PowerFunction() {
            this.power = "^";
            this.expressionType = 101;
            this.name = "power";
            this.termType = 5;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(12, this.text1));
            this.select2.addActionListener(new Function.SelectListener(12, this.text2));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Power");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            stringArray = this.wrapInParenthesis(stringArray);
            return stringArray[0] + " " + "^" + " " + stringArray[1];
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            stringArray = this.wrapInParenthesis(stringArray);
            return stringArray[0] + " " + "^" + " " + stringArray[1];
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            return new PowerExpression(expression, expression2);
        }
    }

    private class DivideFunction
    extends Function {
        public DivideFunction() {
            this.expressionType = 100;
            this.name = "/";
            this.termType = 1;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(12, this.text1));
            this.select2.addActionListener(new Function.SelectListener(12, this.text2));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Division");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            stringArray = this.wrapInParenthesis(stringArray);
            return stringArray[0] + " " + this.name + " " + stringArray[1];
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            stringArray = this.wrapInParenthesis(stringArray);
            return stringArray[0] + " " + this.name + " " + stringArray[1];
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            return new DivideExpression(expression, expression2);
        }
    }

    private class MultiplyFunction
    extends Function {
        public MultiplyFunction() {
            this.expressionType = 99;
            this.name = "*";
            this.termType = 1;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(12, this.text1));
            this.select2.addActionListener(new Function.SelectListener(12, this.text2));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Multiplication");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            stringArray = this.wrapInParenthesis(stringArray);
            return stringArray[0] + " " + this.name + " " + stringArray[1];
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            stringArray = this.wrapInParenthesis(stringArray);
            return stringArray[0] + " " + this.name + " " + stringArray[1];
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            return new MultiplyExpression(expression, expression2);
        }
    }

    private class SubtractFunction
    extends Function {
        public SubtractFunction() {
            this.expressionType = 98;
            this.name = "-";
            this.termType = 1;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(12, this.text1));
            this.select2.addActionListener(new Function.SelectListener(12, this.text2));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Subtraction");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            stringArray = this.wrapInParenthesis(stringArray);
            return stringArray[0] + " " + this.name + " " + stringArray[1];
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            stringArray = this.wrapInParenthesis(stringArray);
            return stringArray[0] + " " + this.name + " " + stringArray[1];
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            return new SubtractExpression(expression, expression2);
        }
    }

    private class AddFunction
    extends Function {
        public AddFunction() {
            this.expressionType = 97;
            this.name = "+";
            this.termType = 1;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(12, this.text1));
            this.select2.addActionListener(new Function.SelectListener(12, this.text2));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Add");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            stringArray = this.wrapInParenthesis(stringArray);
            return stringArray[0] + " " + this.name + " " + stringArray[1];
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            stringArray = this.wrapInParenthesis(stringArray);
            return stringArray[0] + " " + this.name + " " + stringArray[1];
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            return new AddExpression(expression, expression2);
        }
    }

    private class GreaterEqualFunction
    extends Function {
        public GreaterEqualFunction() {
            this.expressionType = 108;
            this.name = ">=";
            this.termType = 1;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(11, this.text1));
            this.select2.addActionListener(new Function.SelectListener(11, this.text2));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Greater_Equals");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            stringArray = this.wrapInParenthesis(stringArray);
            return stringArray[0] + " " + this.name + " " + stringArray[1];
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            stringArray = this.wrapInParenthesis(stringArray);
            return stringArray[0] + " " + this.name + " " + stringArray[1];
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            return new GreaterThanOrEqualsExpression(expression, expression2);
        }
    }

    private class LessEqualFunction
    extends Function {
        public LessEqualFunction() {
            this.expressionType = 107;
            this.name = "<=";
            this.termType = 1;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(11, this.text1));
            this.select2.addActionListener(new Function.SelectListener(11, this.text2));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Less_Equals");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            stringArray = this.wrapInParenthesis(stringArray);
            return stringArray[0] + " " + this.name + " " + stringArray[1];
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            stringArray = this.wrapInParenthesis(stringArray);
            return stringArray[0] + " " + this.name + " " + stringArray[1];
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            return new LessThanOrEqualsExpression(expression, expression2);
        }
    }

    private class NotEqualFunction
    extends Function {
        public NotEqualFunction() {
            this.expressionType = 106;
            this.name = "!=";
            this.termType = 1;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(11, this.text1));
            this.select2.addActionListener(new Function.SelectListener(11, this.text2));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Not_Equals");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            stringArray = this.wrapInParenthesis(stringArray);
            return stringArray[0] + " " + this.name + " " + stringArray[1];
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            stringArray = this.wrapInParenthesis(stringArray);
            return stringArray[0] + " " + this.name + " " + stringArray[1];
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            return new NotEqualsExpression(expression, expression2);
        }
    }

    private class GreaterFunction
    extends Function {
        public GreaterFunction() {
            this.expressionType = 105;
            this.name = ">";
            this.termType = 1;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(11, this.text1));
            this.select2.addActionListener(new Function.SelectListener(11, this.text2));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Greater_Than");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            stringArray = this.wrapInParenthesis(stringArray);
            return stringArray[0] + " " + this.name + " " + stringArray[1];
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            stringArray = this.wrapInParenthesis(stringArray);
            return stringArray[0] + " " + this.name + " " + stringArray[1];
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            return new GreaterThanExpression(expression, expression2);
        }
    }

    private class LessFunction
    extends Function {
        public LessFunction() {
            this.expressionType = 104;
            this.name = "<";
            this.termType = 1;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(11, this.text1));
            this.select2.addActionListener(new Function.SelectListener(11, this.text2));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Less_Than");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            stringArray = this.wrapInParenthesis(stringArray);
            return stringArray[0] + " " + this.name + " " + stringArray[1];
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            stringArray = this.wrapInParenthesis(stringArray);
            return stringArray[0] + " " + this.name + " " + stringArray[1];
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            return new LessThanExpression(expression, expression2);
        }
    }

    private class EqualFunction
    extends Function {
        public EqualFunction() {
            this.expressionType = 103;
            this.name = "==";
            this.termType = 1;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(11, this.text1));
            this.select2.addActionListener(new Function.SelectListener(11, this.text2));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Equals");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            stringArray = this.wrapInParenthesis(stringArray);
            return stringArray[0] + " " + this.name + " " + stringArray[1];
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            stringArray = this.wrapInParenthesis(stringArray);
            return stringArray[0] + " " + this.name + " " + stringArray[1];
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            return new EqualsExpression(expression, expression2);
        }
    }

    private class NotFunction
    extends Function {
        public NotFunction() {
            this.expressionType = 96;
            this.name = "not";
            this.termType = 0;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(10, this.text1));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Not");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            return this.name + " (" + stringArray[0] + ")";
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            return this.name + " (" + stringArray[0] + ")";
        }

        public Expression getExpression() throws ExceptionHugin {
            Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
            return new NotExpression(expression);
        }
    }

    private class AndFunction
    extends Function {
        public AndFunction() {
            this.expressionType = 94;
            this.name = "and";
            this.termType = 1;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(10, this.text1));
            this.select2.addActionListener(new Function.SelectListener(10, this.text2));
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_And");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ")";
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ")";
        }

        public Expression getExpression() throws ExceptionHugin {
            ExpressionList expressionList = new ExpressionList();
            expressionList.add(Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser));
            expressionList.add(Expression.stringToExpression(this.text2.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser));
            return new AndExpression(expressionList);
        }

        public void fromExpression(Expression expression) {
            if (expression == null) {
                return;
            }
            try {
                if (ExpressionTableModel.isValidExpression(expression)) {
                    ExpressionList expressionList = ((CompositeExpression)expression).getOperands();
                    if (expression.getOperator() == 94 && expressionList.size() > 2) {
                        ExpressionList expressionList2 = new ExpressionList();
                        expressionList2.add(expressionList.get(expressionList.size() - 1));
                        AndExpression andExpression = new AndExpression(expressionList2);
                        expressionList.remove(expressionList.size() - 1);
                        AndExpression andExpression2 = new AndExpression(expressionList);
                        ExpressionList expressionList3 = new ExpressionList();
                        expressionList3.add(andExpression2);
                        expressionList3.add(andExpression);
                        expression = new AndExpression(expressionList3);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            super.fromExpression(expression);
        }
    }

    private class OrFunction
    extends Function {
        public OrFunction() {
            this.expressionType = 95;
            this.name = "or";
            this.termType = 1;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.SelectListener(10, this.text1));
            this.select2.addActionListener(new Function.SelectListener(10, this.text2));
        }

        public int[] getArgumentPositions() {
            String[] stringArray = this.getArguments();
            int[] nArray = new int[]{this.name.length() + 2, stringArray[0].length() + 2};
            return nArray;
        }

        public String getStart() {
            return this.name + " (";
        }

        public String getDescription() {
            return HuginGUIConstants.get("EBW_DESCRIPTION_Or");
        }

        public String getStringExpression() {
            if (this.expressionField.isEnabled()) {
                return this.expressionField.getText();
            }
            String[] stringArray = this.getArguments();
            return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ")";
        }

        public String getStringExpression(String string) {
            String[] stringArray = this.getArguments(string);
            return this.name + " (" + stringArray[0] + ", " + stringArray[1] + ")";
        }

        public Expression getExpression() throws ExceptionHugin {
            ExpressionList expressionList = new ExpressionList();
            expressionList.add(Expression.stringToExpression(this.text1.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser));
            expressionList.add(Expression.stringToExpression(this.text2.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser));
            return new OrExpression(expressionList);
        }

        public void fromExpression(Expression expression) {
            if (expression == null) {
                return;
            }
            try {
                if (ExpressionTableModel.isValidExpression(expression)) {
                    ExpressionList expressionList = ((CompositeExpression)expression).getOperands();
                    if (expression.getOperator() == 95 && expressionList.size() > 2) {
                        ExpressionList expressionList2 = new ExpressionList();
                        expressionList2.add(expressionList.get(expressionList.size() - 1));
                        OrExpression orExpression = new OrExpression(expressionList2);
                        expressionList.remove(expressionList.size() - 1);
                        OrExpression orExpression2 = new OrExpression(expressionList);
                        ExpressionList expressionList3 = new ExpressionList();
                        expressionList3.add(orExpression2);
                        expressionList3.add(orExpression);
                        expression = new OrExpression(expressionList3);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            super.fromExpression(expression);
        }
    }

    private class Function {
        String name;
        static final String MISSING_ARG = "?";
        final String exprField = "expressionField";
        int expressionType;
        int termType = 0;
        int useNestType = 0;
        boolean optionalExists = false;
        ParentInserterField text1;
        ParentInserterField text2;
        ParentInserterField text3;
        ParentInserterField text4;
        ParentInserterField activeTextField;
        JButton select1;
        JButton select2;
        JButton select3;
        JButton select4;
        JButton editButton;
        JLabel expressionLabel;
        ParentInserterField expressionField;
        JPanel result;
        NodeList parents;
        JPanel terms;

        public Function(String string, int n) {
            this.name = string;
            this.expressionType = n;
        }

        public Function() {
        }

        public int getExpressionType() {
            return this.expressionType;
        }

        void createFunctionPanel() {
            try {
                this.parents = ExpressionBuilderPanel.this.node.getAPINode().getParents();
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
            this.result = new JPanel(new BorderLayout());
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel(new BorderLayout());
            JLabel jLabel = new JLabel(new ImageIcon(ClassLoader.getSystemResource("icons/functionArguments.gif")));
            jPanel2.add((Component)jLabel, "North");
            TitledPanel titledPanel = new TitledPanel("Arguments(" + this.name + ")");
            titledPanel.setLayout(new GridLayout(1, 1));
            JPanel jPanel3 = new JPanel(new BorderLayout());
            this.terms = new JPanel(new GridLayout(4, 1));
            JPanel jPanel4 = new JPanel(new GridLayout(4, 1));
            this.terms.add(new JLabel(this.getTerm(1)));
            JPanel jPanel5 = new JPanel(new BorderLayout(5, 5));
            this.activeTextField = this.text1 = new ParentInserterField(this.parents, 25);
            this.text1.setEnabled(this.enableTerm(1));
            this.text1.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent focusEvent) {
                    Function.this.activeTextField = Function.this.text1;
                }
            });
            this.text1.getDocument().addDocumentListener(new ExpressionDocumentListener());
            this.text1.getDocument().putProperty("name", "text1");
            this.select1 = new JButton(HuginGUIConstants.get("EBW_BUTTON_Fx"));
            this.select1.setEnabled(this.enableTerm(1));
            jPanel5.add((Component)this.text1, "Center");
            jPanel5.add((Component)this.select1, "East");
            jPanel4.add(jPanel5);
            this.text2 = new ParentInserterField(this.parents, 25);
            if (this.enableTerm(2)) {
                this.terms.add(new JLabel(this.getTerm(2)));
                JPanel jPanel6 = new JPanel(new BorderLayout(5, 5));
                this.text2.setEnabled(this.enableTerm(2));
                this.text2.addFocusListener(new FocusAdapter(){

                    public void focusGained(FocusEvent focusEvent) {
                        Function.this.activeTextField = Function.this.text2;
                    }
                });
                this.text2.getDocument().addDocumentListener(new ExpressionDocumentListener());
                this.text2.getDocument().putProperty("name", "text2");
                this.select2 = new JButton(HuginGUIConstants.get("EBW_BUTTON_Fx"));
                this.select2.setEnabled(this.enableTerm(2));
                jPanel6.add((Component)this.text2, "Center");
                jPanel6.add((Component)this.select2, "East");
                jPanel4.add(jPanel6);
            }
            this.text3 = new ParentInserterField(this.parents, 25);
            if (this.enableTerm(3)) {
                this.terms.add(new JLabel(this.getTerm(3)));
                JPanel jPanel7 = new JPanel(new BorderLayout(5, 5));
                this.text3.setEnabled(this.enableTerm(3));
                this.text3.addFocusListener(new FocusAdapter(){

                    public void focusGained(FocusEvent focusEvent) {
                        Function.this.activeTextField = Function.this.text3;
                    }
                });
                this.text3.getDocument().addDocumentListener(new ExpressionDocumentListener());
                this.text3.getDocument().putProperty("name", "text3");
                this.select3 = new JButton(HuginGUIConstants.get("EBW_BUTTON_Fx"));
                this.select3.setEnabled(this.enableTerm(3));
                jPanel7.add((Component)this.text3, "Center");
                jPanel7.add((Component)this.select3, "East");
                jPanel4.add(jPanel7);
            }
            this.text4 = new ParentInserterField(this.parents, 25);
            if (this.enableTerm(4)) {
                this.terms.add(new JLabel(this.getTerm(4)));
                JPanel jPanel8 = new JPanel(new BorderLayout(5, 5));
                this.text4.setEnabled(this.enableTerm(4));
                this.text4.addFocusListener(new FocusAdapter(){

                    public void focusGained(FocusEvent focusEvent) {
                        Function.this.activeTextField = Function.this.text4;
                    }
                });
                this.text4.getDocument().addDocumentListener(new ExpressionDocumentListener());
                this.text4.getDocument().putProperty("name", "text4");
                this.select4 = new JButton(HuginGUIConstants.get("EBW_BUTTON_Fx"));
                this.select4.setEnabled(this.enableTerm(4));
                jPanel8.add((Component)this.text4, "Center");
                jPanel8.add((Component)this.select4, "East");
                jPanel4.add(jPanel8);
            }
            JPanel jPanel9 = new JPanel(new BorderLayout(10, 10));
            jPanel9.add((Component)this.terms, "West");
            jPanel9.add((Component)jPanel4, "Center");
            JLabel jLabel2 = new JLabel("(*): Optional");
            jLabel2.setEnabled(this.optionalExists());
            jPanel3.add((Component)jPanel9, "Center");
            if (this.optionalExists) {
                jPanel3.add((Component)jLabel2, "South");
            }
            titledPanel.add(jPanel3);
            jPanel.add((Component)titledPanel, "Center");
            JPanel jPanel10 = new JPanel(new BorderLayout(5, 5));
            this.expressionField = new ParentInserterField(this.parents, 30);
            this.expressionField.setEnabled(false);
            this.expressionField.getDocument().addDocumentListener(new Expression1DocumentListener());
            this.expressionField.getDocument().putProperty("name", "expressionField");
            this.expressionLabel = new JLabel(ExpressionBuilderPanel.this.wrapInHtml(HuginGUIConstants.get("EBW_LABEL_Local_Exp"), true));
            JPanel jPanel11 = new JPanel(new BorderLayout(5, 5));
            this.editButton = new JButton(HuginGUIConstants.get("EBW_BUTTON_Edit"));
            this.editButton.addActionListener(new EditListener());
            jPanel11.add((Component)this.expressionField, "Center");
            jPanel11.add((Component)this.editButton, "East");
            jPanel10.add((Component)this.expressionLabel, "West");
            jPanel10.add((Component)jPanel11, "South");
            jPanel.add((Component)jPanel10, "South");
            JPanel jPanel12 = new JPanel(new BorderLayout(5, 5));
            jPanel12.setPreferredSize(ExpressionBuilderPanel.this.wrapPanelDim);
            JPanel jPanel13 = new JPanel(new GridLayout(1, 1));
            String string = ExpressionBuilderPanel.this.wrapInHtml(this.getDescription(), true);
            JLabel jLabel3 = new JLabel(string);
            jPanel13.add((Component)jLabel3, 0);
            jPanel12.add((Component)jPanel, "North");
            jPanel12.add((Component)jPanel13, "Center");
            this.result.add((Component)jPanel12, "Center");
        }

        public void clearFields(boolean bl) {
            this.text1.setText("");
            this.text2.setText("");
            this.text3.setText("");
            this.text4.setText("");
            if (bl) {
                ExpressionBuilderPanel.this.clearUserInput();
            }
        }

        public void setExpressionField() {
            this.expressionField.setText(this.getStringExpression());
            this.expressionField.setToolTipText(this.expressionField.getText());
        }

        public void setEditMode(boolean bl) {
            if (this.enableTerm(1)) {
                this.select1.setEnabled(bl);
                this.text1.setEnabled(bl);
            }
            if (this.enableTerm(2)) {
                this.select2.setEnabled(bl);
                this.text2.setEnabled(bl);
            }
            if (this.enableTerm(3)) {
                this.select3.setEnabled(bl);
                this.text3.setEnabled(bl);
            }
            if (this.enableTerm(4)) {
                this.select4.setEnabled(bl);
                this.text4.setEnabled(bl);
            }
        }

        public JPanel getFunctionPanel() {
            return this.result;
        }

        public String getDescription() {
            return "Description of this function, not available";
        }

        public ParentInserterField getActiveText() {
            return this.activeTextField;
        }

        public String getTerm(int n) {
            return HuginGUIConstants.EXPRESSION_BUILDER_terms[n - 1][this.termType];
        }

        public boolean enableTerm(int n) {
            return HuginGUIConstants.EXPRESSION_BUILDER_terms[n - 1][this.termType].length() > 0;
        }

        public boolean optionalExists() {
            return this.optionalExists;
        }

        public Expression getExpression() throws ExceptionHugin {
            return ExpressionBuilderPanel.this.expression;
        }

        public String getExplanation() {
            return "The parameters are not specified correctly";
        }

        public String toString() {
            return this.name;
        }

        public String[] getArguments() {
            String[] stringArray = new String[4];
            if (this.enableTerm(1)) {
                stringArray[0] = this.text1.getText().length() > 0 ? this.text1.getText() : MISSING_ARG;
            }
            if (this.enableTerm(2)) {
                stringArray[1] = this.text2.getText().length() > 0 ? this.text2.getText() : MISSING_ARG;
            }
            if (this.enableTerm(3)) {
                stringArray[2] = this.text3.getText().length() > 0 ? this.text3.getText() : MISSING_ARG;
            }
            if (this.enableTerm(4)) {
                stringArray[3] = this.text4.getText().length() > 0 ? this.text4.getText() : MISSING_ARG;
            }
            return stringArray;
        }

        public String[] getArguments(String string) {
            String[] stringArray = new String[4];
            if (this.enableTerm(1)) {
                stringArray[0] = this.text1.equals(this.activeTextField) ? string : (this.text1.getText().length() > 0 ? this.text1.getText() : MISSING_ARG);
            }
            if (this.enableTerm(2)) {
                stringArray[1] = this.text2.equals(this.activeTextField) ? string : (this.text2.getText().length() > 0 ? this.text2.getText() : MISSING_ARG);
            }
            if (this.enableTerm(3)) {
                stringArray[2] = this.text3.equals(this.activeTextField) ? string : (this.text3.getText().length() > 0 ? this.text3.getText() : MISSING_ARG);
            }
            if (this.enableTerm(4)) {
                stringArray[3] = this.text4.equals(this.activeTextField) ? string : (this.text4.getText().length() > 0 ? this.text4.getText() : MISSING_ARG);
            }
            return stringArray;
        }

        protected String[] wrapInParenthesis(String[] stringArray) {
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                stringArray2[i] = string == null || !this.needsWrapping(string) ? string : "(" + string + ")";
            }
            return stringArray2;
        }

        protected boolean needsWrapping(String string) {
            String string2 = string.toLowerCase().trim();
            HashMap<String, String> hashMap = ExpressionTableModel.getOperatorMap2();
            Vector<String> vector = new Vector<String>(hashMap.keySet());
            Vector<String> vector2 = new Vector<String>(ExpressionTableModel.getOperatorMap().values());
            for (String string3 : vector2) {
                if (!string2.startsWith(string3.trim().toLowerCase())) continue;
                return false;
            }
            boolean bl = false;
            boolean bl2 = true;
            char[] cArray = string2.toCharArray();
            int n = 0;
            for (int i = 0; i < cArray.length; ++i) {
                char c = cArray[i];
                for (String string4 : vector) {
                    if (!string4.startsWith("" + c)) continue;
                    bl = true;
                }
                if (c == '(') {
                    ++n;
                }
                if (c == ')') {
                    --n;
                }
                if (n != 0 || i == cArray.length - 1) continue;
                bl2 = false;
            }
            return bl && !bl2;
        }

        public String getStringExpression() {
            return "";
        }

        public String getStringExpression(String string) {
            return "";
        }

        public int[] getArgumentPositions() {
            return null;
        }

        public Expression getEditedExpression() throws ExceptionHugin {
            return Expression.stringToExpression(this.expressionField.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
        }

        public String[] getAllArguments() {
            ((ExpressionBuilderPanel)ExpressionBuilderPanel.this).userArguments[0] = this.text1 == null ? "" : this.text1.getText();
            ((ExpressionBuilderPanel)ExpressionBuilderPanel.this).userArguments[1] = this.text2 == null ? "" : this.text2.getText();
            ((ExpressionBuilderPanel)ExpressionBuilderPanel.this).userArguments[2] = this.text3 == null ? "" : this.text3.getText();
            ((ExpressionBuilderPanel)ExpressionBuilderPanel.this).userArguments[3] = this.text4 == null ? "" : this.text4.getText();
            return ExpressionBuilderPanel.this.userArguments;
        }

        public void fromFunction(Function function) {
            ExpressionBuilderPanel.access$1902(ExpressionBuilderPanel.this, function.getAllArguments());
            function.clearFields(false);
            if (ExpressionBuilderPanel.this.userArguments != null) {
                this.text1.setText(ExpressionBuilderPanel.this.userArguments[0]);
                this.text2.setText(ExpressionBuilderPanel.this.userArguments[1]);
                this.text3.setText(ExpressionBuilderPanel.this.userArguments[2]);
                this.text4.setText(ExpressionBuilderPanel.this.userArguments[3]);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void fromExpression(Expression expression) {
            if (expression == null) {
                return;
            }
            if (!ExpressionTableModel.isValidExpression(expression)) {
                try {
                    InvalidExpression invalidExpression = new InvalidExpression(expression, ExpressionBuilderPanel.this.node.getClass().equals(UtilityNode.class));
                    Vector<String> vector = invalidExpression.getArguments();
                    if (vector.size() <= 0) return;
                    this.text1.setText(vector.get(0));
                    ((ExpressionBuilderPanel)ExpressionBuilderPanel.this).userArguments[0] = this.text1.getText();
                    if (vector.size() < 2) {
                        return;
                    }
                    String string = vector.get(1);
                    this.text2.setText(string);
                    ((ExpressionBuilderPanel)ExpressionBuilderPanel.this).userArguments[1] = this.text2.getText();
                    if (vector.size() < 3) {
                        return;
                    }
                    String string2 = vector.get(2);
                    this.text3.setText(string2);
                    ((ExpressionBuilderPanel)ExpressionBuilderPanel.this).userArguments[2] = this.text3.getText();
                    if (vector.size() < 4) {
                        return;
                    }
                    String string3 = vector.get(3);
                    this.text4.setText(string3);
                    ((ExpressionBuilderPanel)ExpressionBuilderPanel.this).userArguments[3] = this.text4.getText();
                    for (int i = 4; i < vector.size(); ++i) {
                        ((ExpressionBuilderPanel)ExpressionBuilderPanel.this).userArguments[i] = vector.get(i);
                    }
                    return;
                }
                catch (Exception exception) {
                    return;
                }
            }
            try {
                String string;
                if (!expression.isCompositeExpression() || this.termType < 0) return;
                ExpressionList expressionList = ((CompositeExpression)expression).getOperands();
                this.clearFields(true);
                ListIterator listIterator = expressionList.listIterator(0);
                if (listIterator.hasNext()) {
                    string = HuginGUIUtils.convertOctals(((Expression)listIterator.next()).expressionToString());
                    this.text1.setText(string);
                    ((ExpressionBuilderPanel)ExpressionBuilderPanel.this).userArguments[0] = this.text1.getText();
                }
                if (!listIterator.hasNext()) {
                    return;
                }
                string = HuginGUIUtils.convertOctals(((Expression)listIterator.next()).expressionToString());
                this.text2.setText(string);
                ((ExpressionBuilderPanel)ExpressionBuilderPanel.this).userArguments[1] = this.text2.getText();
                if (!listIterator.hasNext()) {
                    return;
                }
                String string4 = HuginGUIUtils.convertOctals(((Expression)listIterator.next()).expressionToString());
                this.text3.setText(string4);
                ((ExpressionBuilderPanel)ExpressionBuilderPanel.this).userArguments[2] = this.text3.getText();
                if (!listIterator.hasNext()) {
                    return;
                }
                String string5 = HuginGUIUtils.convertOctals(((Expression)listIterator.next()).expressionToString());
                this.text4.setText(string5);
                ((ExpressionBuilderPanel)ExpressionBuilderPanel.this).userArguments[3] = this.text4.getText();
                int n = 3;
                while (listIterator.hasNext() && n < ExpressionBuilderPanel.this.userArguments.length - 1) {
                    ((ExpressionBuilderPanel)ExpressionBuilderPanel.this).userArguments[++n] = HuginGUIUtils.convertOctals(((Expression)listIterator.next()).expressionToString());
                }
                return;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }

        class SelectListener
        implements ActionListener {
            int mode;
            ParentInserterField textField;

            public SelectListener(int n, ParentInserterField parentInserterField) {
                this.mode = n;
                this.textField = parentInserterField;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Expression expression = null;
                String string = this.textField.getText();
                if (string.length() > 0) {
                    try {
                        expression = Expression.stringToExpression(string, ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
                    }
                    catch (Exception exception) {
                        expression = ExpressionTableModel.createValidExpression(string, ExpressionBuilderPanel.this.node.getClass().equals(UtilityNode.class));
                    }
                }
                ExpressionBuilderPanel.this.setNextMode(this.mode);
                if (ExpressionBuilderPanel.this.functionListener != null) {
                    Function.this.activeTextField = this.textField;
                    Object object = expression == null ? new Object() : expression;
                    ExpressionBuilderPanel.this.functionListener.stateChanged(new ChangeEvent(object));
                }
            }
        }

        public class Expression1DocumentListener
        implements DocumentListener {
            public void insertUpdate(DocumentEvent documentEvent) {
                ExpressionBuilderPanel.this.notifyExpressionListener();
                this.updateToolTip();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                ExpressionBuilderPanel.this.notifyExpressionListener();
                this.updateToolTip();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            private void updateToolTip() {
                Function.this.expressionField.setToolTipText(Function.this.expressionField.getText());
            }
        }

        public class ExpressionDocumentListener
        implements DocumentListener {
            public void insertUpdate(DocumentEvent documentEvent) {
                String string = (String)documentEvent.getDocument().getProperty("name");
                if (!string.equals("expressionField")) {
                    this.updateExpressionField(documentEvent);
                }
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                if (!Function.this.name.equals("expressionField")) {
                    this.updateExpressionField(documentEvent);
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            private void updateExpressionField(DocumentEvent documentEvent) {
                if (Function.this.expressionField.isEnabled()) {
                    Function.this.expressionField.setEnabled(false);
                    Function.this.expressionField.setText(ExpressionBuilderPanel.this.function.getStringExpression());
                    Function.this.expressionField.setEnabled(true);
                } else {
                    Function.this.expressionField.setText(ExpressionBuilderPanel.this.function.getStringExpression());
                }
            }
        }

        public class EditListener
        implements ActionListener {
            public void actionPerformed(ActionEvent actionEvent) {
                if (!Function.this.expressionField.isEnabled()) {
                    Function.this.editButton.setText(HuginGUIConstants.get("EBW_BUTTON_Build"));
                    Function.this.expressionField.setEnabled(true);
                    Function.this.activeTextField = Function.this.expressionField;
                    ExpressionBuilderPanel.this.isEditable = true;
                    Function.this.setEditMode(false);
                } else {
                    Function.this.editButton.setText(HuginGUIConstants.get("EBW_BUTTON_Edit"));
                    Function.this.expressionField.setEnabled(false);
                    ExpressionBuilderPanel.this.isEditable = false;
                    Function.this.setEditMode(true);
                    String string = Function.this.expressionField.getText();
                    if (string.trim() == "" || string.trim().length() == 0) {
                        Function.this.clearFields(true);
                    } else {
                        Expression expression = null;
                        try {
                            expression = Expression.stringToExpression(Function.this.expressionField.getText(), ExpressionBuilderPanel.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilderPanel.this.expressionParser);
                        }
                        catch (Exception exception) {
                            expression = ExpressionTableModel.createValidExpression(Function.this.expressionField.getText(), ExpressionBuilderPanel.this.node.getClass().equals(UtilityNode.class));
                        }
                        Function.this.clearFields(true);
                        ExpressionBuilderPanel.this.useExpression = true;
                        ExpressionBuilderPanel.this.setSelectedFunction(expression);
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FunctionCategory {
        public static final int BOOLEAN = 0;
        public static final int COMPARISON = 1;
        public static final int ARITHMETIC = 2;
        public static final int IF_THEN_ELSE = 3;
        public static final int DISCRETE_DISTRIBUTION = 4;
        public static final int CONTINUOUS_DISTRIBUTION = 5;
        public static final int BOOLEAN_DISTRIBUTION = 6;
        public static final int GENERIC_DISTRIBUTION = 7;
        public static final int OPERATORS = 8;
        Vector<Function> functions = new Vector();
        String name;

        public FunctionCategory(int n) {
            switch (n) {
                case 0: {
                    this.name = "Boolean Operators";
                    this.functions.add(new AndFunction());
                    this.functions.add(new OrFunction());
                    this.functions.add(new NotFunction());
                    break;
                }
                case 1: {
                    this.name = "Comparison Operators";
                    this.functions.add(new EqualFunction());
                    this.functions.add(new LessFunction());
                    this.functions.add(new GreaterFunction());
                    this.functions.add(new NotEqualFunction());
                    this.functions.add(new LessEqualFunction());
                    this.functions.add(new GreaterEqualFunction());
                    break;
                }
                case 2: {
                    this.name = "Arithmetic Operators";
                    this.functions.add(new AddFunction());
                    this.functions.add(new SubtractFunction());
                    this.functions.add(new MultiplyFunction());
                    this.functions.add(new DivideFunction());
                    this.functions.add(new PowerFunction());
                    this.functions.add(new MinFunction());
                    this.functions.add(new MaxFunction());
                    this.functions.add(new NegateFunction());
                    this.functions.add(new AbsFunction());
                    this.functions.add(new ModFunction());
                    this.functions.add(new FloorFunction());
                    this.functions.add(new CeilingFunction());
                    this.functions.add(new LogFunction());
                    this.functions.add(new ExpFunction());
                    this.functions.add(new SqrtFunction());
                    this.functions.add(new Log2Function());
                    this.functions.add(new Log10Function());
                    this.functions.add(new SinhFunction());
                    this.functions.add(new CoshFunction());
                    this.functions.add(new TanhFunction());
                    this.functions.add(new SinFunction());
                    this.functions.add(new CosFunction());
                    this.functions.add(new TanFunction());
                    break;
                }
                case 3: {
                    this.name = "If-then-else";
                    this.functions.add(new IfFunction());
                    break;
                }
                case 4: {
                    this.name = "Discrete Distributions";
                    this.functions.add(new BinomialFunction());
                    this.functions.add(new GeometricFunction());
                    this.functions.add(new NegativeBinomialFunction());
                    this.functions.add(new PoissonFunction());
                    break;
                }
                case 5: {
                    this.name = "Continuous Distributions";
                    this.functions.add(new NormalFunction());
                    this.functions.add(new LogNormalFunction());
                    this.functions.add(new BetaFunction());
                    this.functions.add(new GammaFunction());
                    this.functions.add(new PERTFunction());
                    this.functions.add(new ExponentialFunction());
                    this.functions.add(new WeibullFunction());
                    this.functions.add(new UniformFunction());
                    this.functions.add(new TriangularFunction());
                    break;
                }
                case 6: {
                    this.name = "Boolean Distributions";
                    this.functions.add(new NoisyOrFunction());
                    break;
                }
                case 7: {
                    this.name = "Distribution";
                    this.functions.add(new DistributionFunction());
                    break;
                }
                case 8: {
                    this.name = "Operators";
                    this.functions.add(new TruncateFunction());
                }
            }
        }

        public String toString() {
            return this.name;
        }

        public Vector<Function> getFunctions() {
            return this.functions;
        }
    }

    private class SelectFunctionPane
    extends JPanel {
        private JComboBox categoryCombo;
        private JComboBox nameCombo;
        private JLabel categoryLabel;
        private JLabel nameLabel;
        public static final int LABELLED_NODE = 0;
        public static final int BOOLEAN_NODE = 1;
        public static final int NUMBERED_NODE = 2;
        public static final int INTERVAL_NODE = 3;
        public static final int UTILITY_NODE = 5;
        public static final int BOOLEAN_NEST = 10;
        public static final int COMPARISON_NEST = 11;
        public static final int ARITHMETIC_NEST = 12;
        public static final int IF_THEN_ELSE_NEST = 13;
        public static final int DISCRETE_DISTRIBUTION_NEST = 14;
        public static final int CONTINUOUS_DISTRIBUTION_NEST = 15;
        public static final int BOOLEAN_DISTRIBUTION_NEST = 16;
        public static final int GENERIC_DISTRIBUTION_NEST = 17;

        public SelectFunctionPane() {
            this.setLayout(new GridLayout(1, 1));
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel(new BorderLayout());
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel3.add((Component)jPanel2, "West");
            this.categoryCombo = new JComboBox();
            this.nameCombo = new JComboBox();
            this.categoryLabel = new JLabel("<html><B>Function Category </B></html>");
            this.nameLabel = new JLabel("<html><B>Function Name </B></html>");
            this.categoryCombo.setBackground(Color.WHITE);
            this.categoryCombo.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    FunctionCategory functionCategory = null;
                    functionCategory = (FunctionCategory)SelectFunctionPane.this.categoryCombo.getSelectedItem();
                    if (functionCategory != null) {
                        Function function;
                        int n;
                        SelectFunctionPane.this.nameCombo.removeAllItems();
                        Vector<Function> vector = functionCategory.getFunctions();
                        Function function2 = null;
                        if (!ExpressionTableModel.isValidExpression(ExpressionBuilderPanel.this.expression)) {
                            function2 = SelectFunctionPane.this.getFunctionFromExpression(ExpressionBuilderPanel.this.expression, functionCategory);
                        } else {
                            for (n = 0; n < vector.size(); ++n) {
                                function = vector.elementAt(n);
                                if (ExpressionBuilderPanel.this.expression == null || ExpressionBuilderPanel.this.expression.getOperator() != function.getExpressionType()) continue;
                                function2 = function;
                            }
                        }
                        for (n = 0; n < vector.size(); ++n) {
                            function = vector.elementAt(n);
                            SelectFunctionPane.this.nameCombo.addItem(function);
                        }
                        if (function2 != null) {
                            SelectFunctionPane.this.nameCombo.setSelectedItem(function2);
                        } else {
                            SelectFunctionPane.this.nameCombo.setSelectedIndex(0);
                        }
                        Function function3 = (Function)SelectFunctionPane.this.nameCombo.getSelectedItem();
                        if (function3 != null) {
                            // empty if block
                        }
                    }
                }
            });
            this.nameCombo.setBackground(Color.WHITE);
            this.nameCombo.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    Function function = (Function)SelectFunctionPane.this.nameCombo.getSelectedItem();
                    if (function != null) {
                        SelectFunctionPane.this.nameComboSelectionChanged(function);
                    }
                }
            });
            JPanel jPanel4 = new JPanel(new BorderLayout());
            JLabel jLabel = new JLabel(new ImageIcon(ClassLoader.getSystemResource("icons/functionArguments.gif")));
            jPanel4.add((Component)jLabel, "North");
            jPanel.add((Component)jPanel4, "East");
            JPanel jPanel5 = new JPanel(new GridLayout(2, 1));
            jPanel5.add(this.categoryLabel);
            jPanel5.add(this.nameLabel);
            jPanel2.add((Component)jPanel5, "West");
            jPanel5 = new JPanel(new GridLayout(2, 1));
            jPanel5.add(this.categoryCombo);
            jPanel5.add(this.nameCombo);
            jPanel2.add((Component)jPanel5, "Center");
            JPanel jPanel6 = new JPanel(new BorderLayout());
            jPanel.add((Component)jPanel3, "Center");
            JPanel jPanel7 = new JPanel(new BorderLayout());
            jPanel7.add((Component)jPanel, "North");
            this.add(jPanel7);
        }

        private void setSelectedFunctionCategory(Expression expression) {
            if (expression == null) {
                return;
            }
            FunctionCategory functionCategory = null;
            InvalidExpression invalidExpression = null;
            if (!ExpressionTableModel.isValidExpression(expression)) {
                invalidExpression = new InvalidExpression(expression, ExpressionBuilderPanel.this.node.getClass().equals(UtilityNode.class));
            }
            for (int i = 0; i < this.categoryCombo.getItemCount(); ++i) {
                functionCategory = (FunctionCategory)this.categoryCombo.getItemAt(i);
                if (functionCategory == null) continue;
                Vector<Function> vector = functionCategory.getFunctions();
                Function function = null;
                if (invalidExpression != null) {
                    function = this.getFunctionFromInvalidExpression(invalidExpression, functionCategory);
                    if (function == null) continue;
                    this.categoryCombo.setSelectedIndex(i);
                    return;
                }
                for (int j = 0; j < vector.size(); ++j) {
                    Function function2 = vector.elementAt(j);
                    if (ExpressionBuilderPanel.this.expression == null || expression.getOperator() != function2.getExpressionType()) continue;
                    this.categoryCombo.setSelectedIndex(i);
                    return;
                }
            }
            this.categoryCombo.setSelectedIndex(1);
            this.categoryCombo.setSelectedIndex(0);
        }

        private FunctionCategory getSelectedFunctionCategory() {
            return (FunctionCategory)this.categoryCombo.getSelectedItem();
        }

        private void setSelectedFunction(Expression expression, FunctionCategory functionCategory) {
            int n;
            Vector<Function> vector = functionCategory.getFunctions();
            Function function = null;
            if (!ExpressionTableModel.isValidExpression(ExpressionBuilderPanel.this.expression)) {
                function = this.getFunctionFromExpression(ExpressionBuilderPanel.this.expression, functionCategory);
            } else {
                for (n = 0; n < vector.size(); ++n) {
                    Function function2 = vector.elementAt(n);
                    if (ExpressionBuilderPanel.this.expression == null || ExpressionBuilderPanel.this.expression.getOperator() != function2.getExpressionType()) continue;
                    function = function2;
                }
            }
            if (function != null) {
                n = 0;
                if (function.equals(this.nameCombo.getSelectedItem())) {
                    n = 1;
                }
                this.nameCombo.setSelectedItem(function);
                if (n != 0) {
                    this.nameComboSelectionChanged(function);
                }
            } else {
                this.nameCombo.setSelectedIndex(0);
            }
        }

        private Function getFunctionFromExpression(Expression expression, FunctionCategory functionCategory) {
            try {
                Vector<Function> vector = functionCategory.getFunctions();
                InvalidExpression invalidExpression = new InvalidExpression(expression, ExpressionBuilderPanel.this.node.getClass().equals(UtilityNode.class));
                String string = invalidExpression.getName();
                for (int i = 0; i < vector.size(); ++i) {
                    Function function = vector.elementAt(i);
                    if (string.toLowerCase().trim() == function.toString().toLowerCase().trim() || string.toLowerCase().trim().equals(function.toString().toLowerCase().trim())) {
                        return function;
                    }
                    if (!function.toString().toLowerCase().trim().startsWith(string.toLowerCase().trim())) continue;
                    return function;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        private Function getFunctionFromInvalidExpression(InvalidExpression invalidExpression, FunctionCategory functionCategory) {
            try {
                Vector<Function> vector = functionCategory.getFunctions();
                String string = invalidExpression.getName();
                for (int i = 0; i < vector.size(); ++i) {
                    Function function = vector.elementAt(i);
                    if (string.toLowerCase().trim() == function.toString().toLowerCase().trim() || string.toLowerCase().trim().equals(function.toString().toLowerCase().trim())) {
                        return function;
                    }
                    if (!function.toString().toLowerCase().trim().startsWith(string.toLowerCase().trim())) continue;
                    return function;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        private void nameComboSelectionChanged(Function function) {
            ExpressionBuilderPanel.this.createFunction(function);
            function.setExpressionField();
        }

        public Function getSelectedFunction() {
            return (Function)this.nameCombo.getSelectedItem();
        }

        public void setMode(int n) {
            Vector<FunctionCategory> vector = new Vector<FunctionCategory>();
            switch (n) {
                case 0: {
                    vector.add(new FunctionCategory(3));
                    vector.add(new FunctionCategory(7));
                    break;
                }
                case 1: {
                    vector.add(new FunctionCategory(0));
                    vector.add(new FunctionCategory(1));
                    vector.add(new FunctionCategory(3));
                    vector.add(new FunctionCategory(6));
                    vector.add(new FunctionCategory(7));
                    break;
                }
                case 2: {
                    vector.add(new FunctionCategory(4));
                    vector.add(new FunctionCategory(2));
                    vector.add(new FunctionCategory(3));
                    vector.add(new FunctionCategory(7));
                    break;
                }
                case 3: {
                    vector.add(new FunctionCategory(4));
                    vector.add(new FunctionCategory(5));
                    vector.add(new FunctionCategory(2));
                    vector.add(new FunctionCategory(3));
                    vector.add(new FunctionCategory(7));
                    vector.add(new FunctionCategory(8));
                    break;
                }
                case 5: {
                    vector.add(new FunctionCategory(2));
                    vector.add(new FunctionCategory(3));
                    break;
                }
                case 13: {
                    vector.add(new FunctionCategory(0));
                    vector.add(new FunctionCategory(1));
                    vector.add(new FunctionCategory(2));
                    vector.add(new FunctionCategory(3));
                    vector.add(new FunctionCategory(5));
                    vector.add(new FunctionCategory(4));
                    vector.add(new FunctionCategory(6));
                    vector.add(new FunctionCategory(7));
                    break;
                }
                case 10: {
                    vector.add(new FunctionCategory(0));
                    vector.add(new FunctionCategory(1));
                    vector.add(new FunctionCategory(3));
                    break;
                }
                case 11: {
                    vector.add(new FunctionCategory(2));
                    vector.add(new FunctionCategory(0));
                    vector.add(new FunctionCategory(1));
                    vector.add(new FunctionCategory(3));
                    break;
                }
                case 12: {
                    vector.add(new FunctionCategory(2));
                    vector.add(new FunctionCategory(3));
                    break;
                }
                case 16: {
                    vector.add(new FunctionCategory(2));
                    vector.add(new FunctionCategory(3));
                    break;
                }
                case 14: {
                    vector.add(new FunctionCategory(2));
                    vector.add(new FunctionCategory(3));
                    break;
                }
                case 15: {
                    vector.add(new FunctionCategory(2));
                    vector.add(new FunctionCategory(3));
                    break;
                }
                case 17: {
                    vector.add(new FunctionCategory(2));
                    vector.add(new FunctionCategory(3));
                }
            }
            this.categoryCombo.removeAllItems();
            for (int i = 0; i < vector.size(); ++i) {
                this.categoryCombo.addItem(vector.elementAt(i));
            }
            this.setSelectedFunctionCategory(ExpressionBuilderPanel.this.expression);
        }

        public Insets getInsets() {
            return new Insets(10, 10, 10, 10);
        }

        public String getName() {
            return "Select Function";
        }
    }
}

