/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExceptionSyntax;
import COM.hugin.HAPI.Expression;
import COM.hugin.HAPI.Model;
import COM.hugin.HAPI.Node;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HGUI.BarNodeTable;
import COM.hugin.HGUI.ExpressionTableColumnModel;
import COM.hugin.HGUI.ExpressionTableModel;
import COM.hugin.HGUI.HuginGUIConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ExpressionTable
extends BarNodeTable {
    int buildingRow = 0;
    int buildingColumn = 0;
    NodeList modelNodes = null;
    int numberOfSamplesPerInterval = -1;
    private int lastKeyCode = 0;
    private boolean lastKeyShiftDown = false;

    public ExpressionTable(Node node) throws ExceptionHugin {
        super(node);
        this.editor = new ExpressionTableEditor();
        this.setCellEditor(this.editor);
        this.setDefaultRenderer(Object.class, new ExpressionTableRenderer());
    }

    public ExpressionTable(Node node, NodeList nodeList) throws ExceptionHugin {
        super(node, nodeList, false);
    }

    protected void setNode(Node node) {
        this.node = node;
        ((ExpressionTableColumnModel)this.getColumnModel()).setNode(node);
        ExpressionTableModel expressionTableModel = new ExpressionTableModel();
        expressionTableModel.setNode(node);
        this.setModel(expressionTableModel);
    }

    public void setDisplayMode(int n) {
    }

    /*
     * Unable to fully structure code
     */
    public void processKeyEvent(KeyEvent var1_1) {
        if (this.editorComp == null) ** GOTO lbl-1000
        if (var1_1.getKeyCode() == 9) ** GOTO lbl-1000
        if (var1_1.getKeyCode() != 10) {
            this.editorComp.dispatchEvent(var1_1);
        } else lbl-1000:
        // 3 sources

        {
            super.processKeyEvent(var1_1);
        }
        var1_1.consume();
    }

    public void editingCanceled(ChangeEvent changeEvent) {
        super.editingCanceled(changeEvent);
    }

    public void editingStopped(ChangeEvent changeEvent) {
        super.editingStopped(changeEvent);
    }

    public void stopEditing() {
        this.getCellEditor().stopCellEditing();
        super.stopEditing();
    }

    public Expression getEditingExpression() throws ExceptionHugin {
        Expression expression = null;
        try {
            this.buildingRow = this.getSelectedRow();
            this.buildingColumn = this.getSelectedColumn();
            String string = this.buildingRow < 0 || this.buildingColumn < 0 ? (String)this.getValueAt(0, 0) : (String)this.getCellEditor().getCellEditorValue();
            expression = Expression.stringToExpression(string, this.node.getModel(), null);
        }
        catch (ExceptionSyntax exceptionSyntax) {
            // empty catch block
        }
        return expression;
    }

    public void setEditingExpression(Expression expression) throws ExceptionHugin {
        int n = this.getSelectedRow();
        int n2 = this.getSelectedColumn();
        if (n == -1) {
            int n3 = n = this.buildingRow < this.getRowCount() && this.buildingRow >= 0 ? this.buildingRow : 0;
        }
        if (n2 == -1) {
            n2 = this.buildingColumn < this.getColumnCount() && this.buildingRow >= 0 ? this.buildingColumn : 0;
        }
        this.setValueAt(expression.expressionToString(), n, n2);
    }

    protected TableColumnModel createDefaultColumnModel() {
        ExpressionTableColumnModel expressionTableColumnModel = new ExpressionTableColumnModel();
        return expressionTableColumnModel;
    }

    public void store() {
        super.store();
        try {
            this.modelNodes = this.node.getModel().getNodes();
            this.numberOfSamplesPerInterval = this.node.getModel().getNumberOfSamplesPerInterval();
            this.node.getModel().delete();
        }
        catch (Exception exception) {
            this.modelNodes = new NodeList();
            this.numberOfSamplesPerInterval = -1;
        }
    }

    public void restoreExpressions() throws ExpressionTableInvalidatedException {
        try {
            if (this.modelNodes == null) {
                this.modelNodes = new NodeList();
            }
            if (this.node.getModel() == null) {
                new Model(this.node, this.modelNodes);
                if (this.numberOfSamplesPerInterval != -1) {
                    this.node.getModel().setNumberOfSamplesPerInterval(this.numberOfSamplesPerInterval);
                }
            }
            super.restore();
        }
        catch (Exception exception) {
            throw new ExpressionTableInvalidatedException(HuginGUIConstants.get("str_invalid_model_nodes"));
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Component component = this.getEditorComponent();
        if (component != null && component instanceof EditorCell) {
            int n = component.getWidth();
            int n2 = this.getWidth();
            int n3 = Math.max(n, Math.min(n2, component.getPreferredSize().width));
            int n4 = component.getX();
            if (component.getX() + n3 > this.getWidth()) {
                n4 = this.getWidth() - n3;
            }
            component.setBounds(n4, 0, n3, this.getRowHeight());
            graphics.translate(component.getX(), component.getY());
            ((EditorCell)component).paintMe(graphics);
        }
    }

    private void setLastKeyShiftDown(boolean bl) {
        this.lastKeyShiftDown = bl;
    }

    private boolean getLastKeyShiftDown() {
        return this.lastKeyShiftDown;
    }

    private void setLastKeyCode(int n) {
        this.lastKeyCode = n;
    }

    private int getLastKeyCode() {
        return this.lastKeyCode;
    }

    protected void exportToDelimited(PrintWriter printWriter, String string) throws ExceptionHugin {
        printWriter.println(HuginGUIConstants.get("MISCELLANEOUS_expression"));
        ExpressionTableModel expressionTableModel = (ExpressionTableModel)this.getModel();
        for (int i = 0; i < expressionTableModel.getColumnCount(); ++i) {
            printWriter.print(expressionTableModel.getValueAt(0, i) + (i < expressionTableModel.getColumnCount() - 1 ? string : ""));
        }
        printWriter.println();
    }

    protected void exportToLatex(PrintWriter printWriter) throws ExceptionHugin {
        NodeList nodeList = this.node.getModel().getNodes();
        nodeList.remove(this.node);
        int n = this.printLatexHeader(nodeList, printWriter);
        ExpressionTableModel expressionTableModel = (ExpressionTableModel)this.getModel();
        printWriter.print(HuginGUIConstants.get("MISCELLANEOUS_expression"));
        for (int i = 0; i < expressionTableModel.getColumnCount(); ++i) {
            printWriter.print(" & " + this.getValueAt(0, i));
        }
        printWriter.println("\\\\\\hline");
    }

    private class ExpressionTableRenderer
    extends BarNodeTable.BarNodeTableCellRenderer {
        JTextField renderer;

        public ExpressionTableRenderer() {
            super(ExpressionTable.this, false);
            this.renderer = new JTextField();
            this.renderer.setBorder(null);
            this.renderer.setMargin(new Insets(0, 0, 0, 0));
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            TableModel tableModel = jTable.getModel();
            if (tableModel instanceof ExpressionTableModel && (!((ExpressionTableModel)tableModel).isValidExpression(n2) || ((ExpressionTableModel)tableModel).isExpressionUndefined(n2))) {
                this.renderer.setForeground(Color.red);
            } else {
                this.renderer.setForeground(UIManager.getDefaults().getColor("TextField.foreground"));
            }
            this.renderer.setText(object == null ? "" : object.toString());
            return this.renderer;
        }
    }

    private class ExpressionTableEditor
    extends BarNodeTable.BarNodeTableCellEditor {
        JTextField editor;
        Color syntaxErrorColor;

        public ExpressionTableEditor() {
            super(ExpressionTable.this, false);
            this.syntaxErrorColor = new Color(255, 90, 90);
            this.editor = new EditorCell(this);
            this.editor.setOpaque(false);
            this.editor.setBorder(BorderFactory.createLineBorder(ExpressionTable.this.getGridColor()));
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            TableModel tableModel = jTable.getModel();
            if (tableModel instanceof ExpressionTableModel && (!((ExpressionTableModel)tableModel).isValidExpression(n2) || ((ExpressionTableModel)tableModel).isExpressionUndefined(n2))) {
                this.editor.setSelectionColor(this.syntaxErrorColor);
            } else {
                this.editor.setSelectionColor(UIManager.getDefaults().getColor("TextField.selectionBackground"));
            }
            this.editor.setText(object == null ? "" : object.toString());
            this.editor.setCaretPosition(Math.max(this.editor.getText().length() - 1, 0));
            this.editor.getCaret().setVisible(true);
            this.editor.setSelectionStart(0);
            this.editor.setSelectionEnd(this.editor.getText().length());
            this.editor.getCaret().setSelectionVisible(true);
            return this.editor;
        }

        public Object getCellEditorValue() {
            return this.editor.getText();
        }
    }

    private class EditorCell
    extends JTextField {
        private ExpressionTableEditor editor;
        int width = 0;

        public EditorCell(ExpressionTableEditor expressionTableEditor) {
            this.editor = expressionTableEditor;
            this.setOpaque(true);
        }

        public void processMouseEvent(MouseEvent mouseEvent) {
            if (mouseEvent.getID() == 501) {
                this.setCaretPosition(this.viewToModel(new Point(mouseEvent.getX(), mouseEvent.getY())));
            }
        }

        public void processComponentKeyEvent(KeyEvent keyEvent) {
            ExpressionTable expressionTable = (ExpressionTable)keyEvent.getSource();
            if (keyEvent.getKeyCode() > 32) {
                expressionTable.setLastKeyCode(keyEvent.getKeyCode());
                expressionTable.setLastKeyShiftDown(keyEvent.isShiftDown());
            }
            if (keyEvent.getKeyCode() == 32) {
                boolean bl = false;
                if (expressionTable.getLastKeyCode() == 135 && expressionTable.getLastKeyShiftDown()) {
                    bl = true;
                }
                if (expressionTable.getLastKeyCode() == 130 && !expressionTable.getLastKeyShiftDown()) {
                    bl = true;
                }
                if (bl) {
                    expressionTable.setLastKeyCode(0);
                    expressionTable.setLastKeyShiftDown(false);
                    expressionTable.dispatchEvent(new KeyEvent(expressionTable, 400, keyEvent.getWhen(), 0, 0, '^'));
                }
            }
        }

        public void paint(Graphics graphics) {
        }

        public void paintComponent(Graphics graphics) {
        }

        public void paintMe(Graphics graphics) {
            graphics.setColor(UIManager.getDefaults().getColor("Table.focusCellBackground"));
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            super.paintComponent(graphics);
            super.paintBorder(graphics);
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (component == null) {
                return;
            }
            if (component != ExpressionTable.this) {
                this.editor.stopCellEditing();
            }
        }
    }

    protected class ExpressionTableInvalidatedException
    extends Exception {
        public ExpressionTableInvalidatedException(String string) {
            super(string);
        }
    }
}

