/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.ContinuousChanceNode;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.Node;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.NodeTableColumn;
import COM.hugin.HGUI.NodeTableColumnModel;
import java.util.ListIterator;

public class ExpressionTableColumnModel
extends NodeTableColumnModel {
    public void setNode(Node node) {
        try {
            if (node == null || node.getModel() == null) {
                return;
            }
            this.node = node;
            this.root = this.createRoot(node);
            this.columnCount = this.root != null ? this.root.index(0) : 0;
            this.transformArray = new int[this.columnCount];
            for (int i = 0; i < this.transformArray.length; ++i) {
                this.transformArray[i] = i;
            }
            this.visibleColumns = this.columnCount;
            this.position = 0;
            this.collapsedColumns.setPreferredWidth(NodeTableColumn.PREFERRED_EXPRESSION_WIDTH);
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    NodeTableColumn createRoot(Node node) throws ExceptionHugin {
        NodeList nodeList = node.getModel().getNodes();
        nodeList.remove(node);
        this.cellWidths = this.buildCellWidthArray(nodeList);
        this.visibleColumns = this.calculateVisibleColumns();
        if (this.visibleColumns == 0) {
            return null;
        }
        this.transformArray = this.collapsedColumns.getTransformArray(this, this.position, this.visibleColumns);
        ListIterator listIterator = nodeList.listIterator();
        while (listIterator.hasNext()) {
            Node node2 = (Node)listIterator.next();
            if (!(node2 instanceof ContinuousChanceNode)) continue;
            listIterator.remove();
        }
        this.root = new NodeTableColumn(node, 0, nodeList, this.collapsedColumns, 0, 0, this.position, this.getLastVisibleColumnIndex(), this.cellWidths);
        return this.root;
    }

    int calculateVisibleColumns() {
        if (this.cellWidths == null) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        int n3 = this.position;
        while (n3 < this.cellWidths[0] && n2 <= this.width) {
            if (this.collapsedColumns.isColumnCollapsed(n3)) {
                int n4 = this.collapsedColumns.getNextVisible(n3);
                if ((n2 += NodeTableColumn.COLLAPSED_WIDTH) <= this.width) {
                    ++n;
                }
                n3 = n4;
                continue;
            }
            ++n3;
            if ((n2 += NodeTableColumn.PREFERRED_EXPRESSION_WIDTH) > this.width) continue;
            ++n;
        }
        return n;
    }

    public int setAvailableWidth(int n) throws ExceptionHugin {
        int n2 = super.setAvailableWidth(n);
        return n2;
    }

    public int getPosition() {
        return this.position;
    }
}

