/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExceptionObjectNotAlive;
import COM.hugin.HAPI.Node;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HGUI.BeliefBarPanel;
import COM.hugin.HGUI.Clique;
import COM.hugin.HGUI.ConflictDialog;
import COM.hugin.HGUI.ConflictResolutionHypothesis;
import COM.hugin.HGUI.HelpPanel;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIEventHandler;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.HuginInsets;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.JunctionTree;
import COM.hugin.HGUI.JunctionTreeEvent;
import COM.hugin.HGUI.JunctionTreeListener;
import COM.hugin.HGUI.NetworkInformation;
import COM.hugin.HGUI.ScrollButtons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JunctionForest
extends JPanel {
    private LinkedList<JunctionTree> trees;
    private JTabbedPane tabs = null;
    private BeliefBarPanel beliefBars;
    private JunctionTreeListener jtListener;
    private static final String[] modes = new String[]{HuginGUIConstants.get("CONFLICT_Show_instantiated_nodes"), HuginGUIConstants.get("CONFLICT_Show_evidence_location")};
    protected static final int SHOW_INSTANTIATED_NODES = 0;
    protected static final int SHOW_EVIDENCE_LOCATION = 1;
    private boolean isID;
    private boolean isCG;
    JButton print;
    JButton zoomIn;
    JButton zoomOut;
    JButton setRoot;
    JButton getConflictResolutions;
    JButton propagate;
    JButton analyze;
    JButton help;
    int maxW = 500;
    int maxH = 500;
    JScrollPane jtScroller;

    public JunctionForest(BeliefBarPanel beliefBarPanel) throws ExceptionHugin {
        super(new BorderLayout());
        this.beliefBars = beliefBarPanel;
        this.isID = beliefBarPanel.project.getNetworkPanel().isLIMIDs();
        this.isCG = NetworkInformation.isContinuous(beliefBarPanel.project.getNetworkPanel().getHome());
        Domain domain = beliefBarPanel.getDomain();
        this.trees = new LinkedList();
        HuginGUIUtils.configureDomain(domain);
        if (!domain.isCompiled()) {
            domain.compile();
        }
        this.jtListener = new JunctionTreeListener(){

            public void stateChanged(JunctionTreeEvent junctionTreeEvent) {
                if (junctionTreeEvent.getID() == 0) {
                    NodeList nodeList = junctionTreeEvent.getNodes();
                    if (nodeList != null) {
                        JunctionForest.this.beliefBars.collapseTree();
                        for (Node node : nodeList) {
                            JunctionForest.this.beliefBars.expandNode(node, false);
                        }
                        try {
                            Object object = "";
                            long l = HuginGUIUtils.calculateNodesSize(nodeList);
                            object = nodeList.size() == 1 ? (String)object + HuginGUIConstants.get("str_the_selected_node_has_size_ARG0", new String[]{"" + l}) : (String)object + HuginGUIConstants.get("str_the_selected_ARG0_nodes_have_size_ARG1", new String[]{"" + nodeList.size(), "" + l});
                            JunctionForest.this.getSelectedTree().writeStatus((String)object);
                        }
                        catch (ExceptionHugin exceptionHugin) {
                            new HuginGUIError(exceptionHugin.getMessage());
                        }
                    }
                    JunctionForest.this.setRoot.setEnabled(!JunctionForest.this.isID && !JunctionForest.this.isCG && JunctionForest.this.getSelectedTree().getSelected().size() == 1 && JunctionForest.this.getSelectedTree().getNumberOfCliques() > 1);
                }
            }
        };
        int n = 1;
        this.isID = beliefBarPanel.project.getNetworkPanel().isLIMIDs();
        for (COM.hugin.HAPI.JunctionTree junctionTree : domain.getJunctionTrees()) {
            JunctionTree junctionTree2 = new JunctionTree(junctionTree, n++);
            junctionTree2.setID(this.isID || this.isCG);
            beliefBarPanel.setRootClique(junctionTree2.getAPIJunctionTree(), junctionTree2.getRoot().getAPIClique());
            this.add(junctionTree2);
        }
        this.add((Component)this.createToolbar(), "North");
        this.update();
    }

    public void reload() throws ExceptionHugin {
        Domain domain = this.beliefBars.getDomain();
        if (this.tabs != null) {
            this.tabs.removeAll();
            this.remove(this.tabs);
            this.tabs = null;
        } else {
            this.remove(this.jtScroller);
            this.remove(this.trees.get(0).getStatusBar());
        }
        this.trees.clear();
        int n = 1;
        this.isID = this.beliefBars.project.getNetworkPanel().isLIMIDs();
        for (COM.hugin.HAPI.JunctionTree junctionTree : domain.getJunctionTrees()) {
            JunctionTree junctionTree2 = new JunctionTree(junctionTree, n++);
            junctionTree2.setID(this.isID);
            this.add(junctionTree2);
        }
        this.beliefBars.setRootClique(this.getSelectedTree().getAPIJunctionTree(), this.getSelectedTree().getRoot().getAPIClique());
        this.update();
    }

    public JPanel createToolbar() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JToolBar jToolBar = new JToolBar();
        this.print = new JButton(new HuginGUIEventHandler.MENU_FILE_Print_JunctionTreeAction(this));
        this.print.setText("");
        this.zoomIn = new JButton(new ImageIcon(ClassLoader.getSystemResource("icons/magnify-plus.gif")));
        this.zoomIn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JunctionForest.this.getSelectedTree().setScaleFactor(JunctionForest.this.getSelectedTree().getScaleFactor() + 0.1);
                JunctionForest.this.zoomOut.setEnabled(JunctionForest.this.getSelectedTree().getScaleFactor() > 0.1);
                JunctionForest.this.zoomIn.setEnabled(JunctionForest.this.getSelectedTree().getScaleFactor() < 10.0);
            }
        });
        this.zoomOut = new JButton(new ImageIcon(ClassLoader.getSystemResource("icons/magnify-minus.gif")));
        this.zoomOut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JunctionForest.this.getSelectedTree().setScaleFactor(JunctionForest.this.getSelectedTree().getScaleFactor() - 0.1);
                JunctionForest.this.zoomOut.setEnabled(JunctionForest.this.getSelectedTree().getScaleFactor() > 0.1);
                JunctionForest.this.zoomIn.setEnabled(JunctionForest.this.getSelectedTree().getScaleFactor() < 10.0);
            }
        });
        this.setRoot = new JButton(new ImageIcon(ClassLoader.getSystemResource("icons/makeRoot.gif")));
        this.setRoot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Clique clique = JunctionForest.this.getSelectedTree().makeActiveCliqueRoot();
                    JunctionForest.this.beliefBars.setRootClique(JunctionForest.this.getSelectedTree().getModel().getAPIJunctionTree(), clique.getModel().getAPIClique());
                    JunctionForest.this.beliefBars.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
                    JunctionForest.this.update();
                    JunctionForest.this.setRoot.setEnabled(false);
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
        });
        this.setRoot.setEnabled(false);
        this.getConflictResolutions = new JButton(new ImageIcon(ClassLoader.getSystemResource("icons/getHypotheses.gif")));
        this.getConflictResolutions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object;
                    LinkedList<ConflictResolutionHypothesis> linkedList = JunctionForest.this.beliefBars.getConflictResolutions(JunctionForest.this.getSelectedTree().getConflict());
                    NodeList nodeList = JunctionForest.this.getSelectedTree().getNodes();
                    Object object2 = linkedList.listIterator();
                    while (object2.hasNext()) {
                        object = (ConflictResolutionHypothesis)object2.next();
                        if (nodeList.contains(((ConflictResolutionHypothesis)object).getNode())) continue;
                        object2.remove();
                    }
                    object2 = Hugin.mainFrame.getSelectedProjectFrame();
                    object = new ConflictDialog((HuginProjectFrame)object2);
                    ((Window)object).pack();
                    HuginGUIUtils.centerComponent((Component)object2, (Window)object);
                    ((Dialog)object).setVisible(true);
                    ((HuginProjectFrame)object2).getNetworkPanel().updateButtonAndMenuStates();
                    ((HuginProjectFrame)object2).getNetworkPanel().repaint();
                    JunctionForest.this.beliefBars.revalidate();
                    ((JunctionForest)JunctionForest.this).beliefBars.project.getNetworkPanel().revalidate();
                    JunctionForest.this.beliefBars.repaint();
                    ((JunctionForest)JunctionForest.this).beliefBars.project.getNetworkPanel().repaint();
                    JunctionForest.this.update();
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
        });
        this.getConflictResolutions.setEnabled(false);
        this.propagate = new JButton(new ImageIcon(ClassLoader.getSystemResource("icons/propsumnormal.gif")));
        this.propagate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Domain domain = JunctionForest.this.beliefBars.getDomain();
                try {
                    JunctionForest.this.beliefBars.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
                }
                catch (ExceptionObjectNotAlive exceptionObjectNotAlive) {
                    new HuginGUIError(exceptionObjectNotAlive);
                }
                catch (Exception exception) {
                    new HuginGUIError(exception.getMessage());
                }
            }
        });
        this.help = new JButton(new ImageIcon(ClassLoader.getSystemResource("icons/help.gif")));
        this.help.addActionListener(new HuginGUIUtils.HelpListener(new HelpPanel(Hugin.mainFrame), "help/jtHelp.html"));
        this.print.setMargin(new HuginInsets());
        this.zoomIn.setMargin(new HuginInsets());
        this.zoomOut.setMargin(new HuginInsets());
        this.setRoot.setMargin(new HuginInsets());
        this.getConflictResolutions.setMargin(new HuginInsets());
        this.propagate.setMargin(new HuginInsets());
        this.help.setMargin(new HuginInsets());
        this.print.setToolTipText(HuginGUIConstants.get("MENU_FILE_Print_JunctionTree"));
        this.zoomIn.setToolTipText(HuginGUIConstants.get("JT_ZOOMIN_TIP"));
        this.zoomOut.setToolTipText(HuginGUIConstants.get("JT_ZOOMOUT_TIP"));
        this.setRoot.setToolTipText(HuginGUIConstants.get("JT_SETROOT_TIP"));
        this.getConflictResolutions.setToolTipText(HuginGUIConstants.get("CONFLICT_RESOLUTIONS_TIP"));
        this.propagate.setToolTipText(HuginGUIConstants.get("JT_PROPAGATE_TIP"));
        this.help.setToolTipText(HuginGUIConstants.get("JT_HELP_TIP"));
        jToolBar.add(this.print);
        jToolBar.add(this.zoomIn);
        jToolBar.add(this.zoomOut);
        jToolBar.add(this.setRoot);
        jToolBar.add(this.getConflictResolutions);
        jToolBar.addSeparator();
        jToolBar.add(this.propagate);
        jToolBar.addSeparator();
        jToolBar.add(this.help);
        jToolBar.setFloatable(false);
        ScrollButtons scrollButtons = new ScrollButtons(jToolBar);
        JToolBar jToolBar2 = new JToolBar();
        JComboBox<String> jComboBox = new JComboBox<String>(modes);
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    JunctionForest.this.getSelectedTree().writeStatus(itemEvent.getItem().toString());
                    JunctionForest.this.getSelectedTree().setEvidenceMode(((JComboBox)itemEvent.getItemSelectable()).getSelectedIndex());
                }
            }
        });
        jToolBar2.add(jComboBox);
        jToolBar2.setFloatable(false);
        jPanel.add((Component)scrollButtons, "North");
        jPanel.add((Component)jToolBar2, "South");
        return jPanel;
    }

    public void activate() {
        ((Window)this.getTopLevelAncestor()).setVisible(true);
        ((Window)this.getTopLevelAncestor()).toFront();
    }

    public void dispose() {
        ((Window)this.getTopLevelAncestor()).dispose();
    }

    public void update() throws ExceptionHugin {
        try {
            this.getConflictResolutions.setEnabled(!this.beliefBars.getDomain().cgEvidenceIsPropagated() && !this.beliefBars.project.getNetworkPanel().isLIMIDs() && this.getSelectedTree().getConflict() > 0.0);
        }
        catch (ExceptionHugin exceptionHugin) {
            this.getConflictResolutions.setEnabled(false);
            throw exceptionHugin;
        }
        this.setSize(this.getSize().width + 2, this.getSize().height);
        this.setSize(this.getSize().width - 2, this.getSize().height);
        this.revalidate();
        this.repaint();
    }

    protected JunctionTree getSelectedTree() {
        if (this.tabs != null && this.tabs.getTabCount() > 1) {
            if (this.tabs.getSelectedIndex() == -1) {
                return this.trees.getFirst();
            }
            return this.trees.get(this.tabs.getSelectedIndex());
        }
        return this.trees.getFirst();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width = Math.min(dimension.width, this.maxW);
        dimension.height = Math.min(dimension.height, this.maxH);
        return dimension;
    }

    void add(JunctionTree junctionTree) throws ExceptionHugin {
        JPanel jPanel;
        junctionTree.addJunctionTreeListener(this.jtListener);
        this.trees.add(junctionTree);
        if (this.trees.size() == 1) {
            this.jtScroller = new JScrollPane(junctionTree);
            this.jtScroller.getHorizontalScrollBar().setUnitIncrement(15);
            this.jtScroller.getVerticalScrollBar().setUnitIncrement(15);
            this.add(this.jtScroller);
            this.add((Component)junctionTree.getStatusBar(), "South");
        }
        if (this.trees.size() == 2) {
            this.remove(this.jtScroller);
            if (this.tabs == null) {
                this.tabs = new JTabbedPane();
            }
            jPanel = new JPanel(new BorderLayout());
            jPanel.add(new JScrollPane(this.trees.getFirst()));
            jPanel.add((Component)this.trees.getFirst().getStatusBar(), "South");
            this.tabs.add("JT 1", jPanel);
            this.add(this.tabs);
            this.tabs.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    try {
                        JunctionForest.this.update();
                    }
                    catch (ExceptionHugin exceptionHugin) {
                        // empty catch block
                    }
                }
            });
        }
        if (this.trees.size() > 1) {
            jPanel = new JPanel(new BorderLayout());
            JScrollPane jScrollPane = new JScrollPane(junctionTree);
            jScrollPane.getHorizontalScrollBar().setUnitIncrement(15);
            jScrollPane.getVerticalScrollBar().setUnitIncrement(15);
            jPanel.add(jScrollPane);
            jPanel.add((Component)junctionTree.getStatusBar(), "South");
            this.tabs.add("JT " + this.trees.size(), jPanel);
        }
        this.beliefBars.setRootClique(junctionTree.getAPIJunctionTree(), junctionTree.getRoot().getAPIClique());
        this.beliefBars.getDomain().resetInferenceEngine();
        junctionTree.getRoot().getAPIClique().propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
    }

    void remove(JunctionTree junctionTree) throws ExceptionHugin {
        if (!this.trees.contains(junctionTree)) {
            return;
        }
        this.trees.remove(junctionTree);
        if (this.trees.size() == 0) {
            this.removeAll();
        }
        if (this.trees.size() == 1) {
            this.remove(this.jtScroller);
            this.tabs.removeAll();
            this.add(this.trees.getFirst());
        }
        if (this.trees.size() > 1) {
            this.tabs.remove(junctionTree);
        }
    }

    public HuginProjectFrame getAncestor() {
        return this.beliefBars.getProjectFrame();
    }
}

