/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.JunctionTree;
import COM.hugin.HAPI.Node;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HGUI.Clique;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JunctionTreeModel {
    private JunctionTree jTree;
    private Clique root;
    private LinkedList<Clique> cliques;
    private LinkedList<COM.hugin.HAPI.Clique> visited;

    public JunctionTreeModel(JunctionTree junctionTree) throws ExceptionHugin {
        this.jTree = junctionTree;
        this.setRoot(new Clique(junctionTree.getRoot(), null));
        this.cliques = this.getCliques(this.root, new LinkedList<Clique>());
    }

    public Clique getRoot() {
        return this.root;
    }

    public JunctionTree getAPIJunctionTree() {
        return this.jTree;
    }

    public boolean cgEvidenceIsPropagated() throws ExceptionHugin {
        return this.jTree.cgEvidenceIsPropagated();
    }

    public void setRoot(Clique clique) throws ExceptionHugin {
        this.root = new Clique(clique.getAPIClique(), null);
        this.cliques = this.getCliques(this.root, new LinkedList<Clique>());
    }

    public LinkedList<Clique> getCliques() {
        return new LinkedList<Clique>(this.cliques);
    }

    public int getNumberOfCliques() {
        return this.cliques.size();
    }

    public double getConflict() throws ExceptionHugin {
        if (this.jTree.equilibriumIs(Domain.H_EQUILIBRIUM_MAX)) {
            return 0.0;
        }
        return Math.log(this.jTree.getConflict());
    }

    private LinkedList<Clique> getCliques(Clique clique, LinkedList<Clique> linkedList) {
        linkedList.add(clique);
        LinkedList<Clique> linkedList2 = clique.getChildren();
        if (linkedList2 != null) {
            for (Clique clique2 : linkedList2) {
                this.getCliques(clique2, linkedList);
            }
        }
        return linkedList;
    }

    public void setID(boolean bl) throws ExceptionHugin {
        if (bl) {
            this.setRoot(new Clique(this.jTree.getRoot(), null));
        } else {
            this.setRoot(new Clique(this.getBestRoot(this.jTree), null));
        }
    }

    private COM.hugin.HAPI.Clique getBestRoot(JunctionTree junctionTree) throws ExceptionHugin {
        int n = Integer.MAX_VALUE;
        COM.hugin.HAPI.Clique clique = null;
        this.visited = new LinkedList();
        for (COM.hugin.HAPI.Clique clique2 : junctionTree.getCliques()) {
            this.visited.clear();
            int n2 = this.getDepth(clique2, 0);
            if (n2 >= n) continue;
            n = n2;
            clique = clique2;
        }
        return clique;
    }

    private String printClique(COM.hugin.HAPI.Clique clique) throws ExceptionHugin {
        String string = "";
        for (Node node : clique.getMembers()) {
            string = string + node.getName();
        }
        return string;
    }

    protected NodeList getNodes() throws ExceptionHugin {
        NodeList nodeList = new NodeList();
        for (Clique clique : this.getCliques()) {
            for (Node node : clique.getMembers()) {
                nodeList.add(node);
            }
        }
        return nodeList;
    }

    protected int getDepth() throws ExceptionHugin {
        if (this.visited == null) {
            this.visited = new LinkedList();
        } else {
            this.visited.clear();
        }
        return this.getDepth(this.getRoot().getAPIClique(), 0);
    }

    protected int getDepth(COM.hugin.HAPI.Clique clique, int n) throws ExceptionHugin {
        int n2 = n;
        this.visited.add(clique);
        for (COM.hugin.HAPI.Clique clique2 : clique.getNeighbors()) {
            if (this.visited.contains(clique2)) continue;
            n2 = Math.max(n2, this.getDepth(clique2, n + 1));
        }
        return n2;
    }
}

