/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;

public class NumberField
extends JTextField {
    private static final int NEGATIVE_INFINITY = 0;
    private static final int POSITIVE_INFINITY = 1;
    private static final int NOT_INFINITY = 2;

    public NumberField(int n) {
        super(n);
    }

    public NumberField() {
        super(8);
        this.addKeyListener(new EnsureNumberListener());
    }

    public NumberField(Double d) {
        super(8);
        this.setText(d.toString());
        this.addKeyListener(new EnsureNumberListener());
    }

    public double getNumber() {
        try {
            int n = this.isInfinity();
            switch (n) {
                case 0: {
                    return Double.NEGATIVE_INFINITY;
                }
                case 1: {
                    return Double.POSITIVE_INFINITY;
                }
            }
            return Double.parseDouble(this.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return 42.0;
        }
    }

    public boolean isNumber() {
        try {
            if (this.isInfinity() != 2) {
                return true;
            }
            Double.parseDouble(this.getText());
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    protected boolean canBeInfinity(String string) {
        String string2 = "inf".toLowerCase();
        string = string.toLowerCase();
        for (int i = 0; i < Math.min(string2.length(), string.length()); ++i) {
            if (string.charAt(i) == string2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private int isInfinity() {
        String string = this.getText().toLowerCase();
        boolean bl = false;
        boolean bl2 = false;
        if (string.length() == 0) {
            return 2;
        }
        if (string.charAt(0) == '-') {
            bl = true;
            string = string.substring(1);
        }
        if (string.length() == 0) {
            return 2;
        }
        if (string.charAt(0) == '+') {
            string = string.substring(1);
        }
        if (string.equals("inf".toLowerCase()) || string.equals("inf")) {
            return bl ? 0 : 1;
        }
        return 2;
    }

    private class EnsureNumberListener
    extends KeyAdapter {
        private EnsureNumberListener() {
        }

        public void keyTyped(KeyEvent keyEvent) {
            JTextField jTextField = (JTextField)keyEvent.getSource();
            String string = jTextField.getText();
            if (keyEvent.getKeyChar() == '\b' && jTextField.getCaretPosition() > 0) {
                return;
            }
            if (keyEvent.getKeyChar() == 'E' && jTextField.getCaretPosition() == string.length()) {
                if (string.indexOf("E") >= 0) {
                    keyEvent.consume();
                }
                return;
            }
            if (keyEvent.getKeyChar() == '-' && string.indexOf("E") == jTextField.getCaretPosition() - 1) {
                return;
            }
            string = string.substring(0, jTextField.getCaretPosition()) + keyEvent.getKeyChar() + string.substring(jTextField.getCaretPosition());
            try {
                char c = string.charAt(0);
                if (c == '+' || c == '-') {
                    string = string.substring(1);
                }
                if (string.length() == 0) {
                    return;
                }
                if (NumberField.this.canBeInfinity(string)) {
                    return;
                }
                c = string.charAt(0);
                if (c == '.' && string.length() == 1) {
                    return;
                }
                if (string.length() > 0) {
                    Double.parseDouble(string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                keyEvent.consume();
            }
        }
    }
}

