/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.CancelDialog;
import COM.hugin.HGUI.CancellableProcess;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.HuginPrintablePage;
import COM.hugin.HGUI.NodeProbabilitiesPage;
import COM.hugin.HGUI.NodeTablePage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.text.Caret;

public class PrintPreview
extends JDialog
implements CancellableProcess {
    HuginPrintablePage printable;
    PageFormat page;
    LinkedList<PagePreview> previews;
    PageSelectedListener selectionListener;
    public static final int NO_RESULT = -1;
    public static final int CLOSED = 0;
    public static final int PRINT = 1;
    private int result = -1;
    JPanel allPages;
    JPanel activePage;
    FullPagePreview fullPage;
    JScrollPane scrollPage;
    JScrollPane previewScroller;
    JButton next;
    JButton previous;
    JButton start;
    JButton end;
    JButton print;
    JButton close;
    PageNavigator pageID;
    private double scaleFactor = 0.2;
    boolean cancelled = false;
    private static final int PAGE_WIDTH = 120;
    public static int margin = 11;

    public PrintPreview(JDialog jDialog, PageFormat pageFormat, HuginPrintablePage huginPrintablePage) {
        super(jDialog, HuginGUIConstants.get("str_preview"), true);
        this.printable = huginPrintablePage;
        this.page = pageFormat;
        this.setContentPane(this.createContent());
        this.selectionListener = new PageSelectedListener(){

            public void pageSelected(int n) {
                PrintPreview.this.pageID.setActivePage(n);
            }
        };
        this.previews = null;
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                PrintPreview.this.createPreviews(PrintPreview.this.printable, PrintPreview.this.page);
                if (PrintPreview.this.previews == null) {
                    return;
                }
                PrintPreview.this.allPages.setLayout(new GridLayout(PrintPreview.this.previews.size(), 1));
                for (PagePreview pagePreview : PrintPreview.this.previews) {
                    PrintPreview.this.allPages.add(pagePreview);
                }
                if (PrintPreview.this.previews.size() > 0) {
                    PagePreview pagePreview = PrintPreview.this.previews.getFirst();
                    pagePreview.setSelected(true);
                    PrintPreview.this.fullPage = (FullPagePreview)pagePreview.getFullPage();
                    PrintPreview.this.activePage.add(PrintPreview.this.fullPage);
                }
                PrintPreview.this.pageID.update();
            }
        });
    }

    private void setResult(int n) {
        this.result = n;
        this.dispose();
    }

    public int getResult() {
        return this.result;
    }

    public int getPageCount() {
        return this.previews.size();
    }

    private JPanel createContent() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.allPages = new JPanel();
        this.previewScroller = new JScrollPane(this.allPages);
        this.previewScroller.setPreferredSize(new Dimension(160, 400));
        jPanel.add((Component)this.previewScroller, "West");
        this.activePage = new JPanel(new BorderLayout());
        this.scrollPage = new JScrollPane(this.activePage);
        this.scrollPage.setPreferredSize(new Dimension(400, 400));
        jPanel.add(this.scrollPage);
        jPanel.add((Component)this.createToolbar(), "North");
        return jPanel;
    }

    private JPanel createToolbar() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        this.start = new JButton("<<");
        this.start.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrintPreview.this.pageID.moveToFirst();
            }
        });
        this.previous = new JButton("<");
        this.previous.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrintPreview.this.pageID.decrementPage();
            }
        });
        this.next = new JButton(">");
        this.next.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrintPreview.this.pageID.incrementPage();
            }
        });
        this.end = new JButton(">>");
        this.end.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrintPreview.this.pageID.moveToLast();
            }
        });
        this.pageID = new PageNavigator();
        jPanel2.add(this.start);
        jPanel2.add(this.previous);
        jPanel2.add(this.pageID);
        jPanel2.add(this.next);
        jPanel2.add(this.end);
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        this.close = new JButton(HuginGUIConstants.get("str_close"));
        this.close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrintPreview.this.setResult(0);
            }
        });
        this.print = new JButton(new ImageIcon(ClassLoader.getSystemResource("icons/printnodetable.gif")));
        this.print.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrintPreview.this.setResult(1);
            }
        });
        jPanel3.add(this.close);
        jPanel3.add(this.print);
        jPanel.add(jPanel2);
        jPanel.add((Component)jPanel3, "West");
        return jPanel;
    }

    private void createPreviews(HuginPrintablePage huginPrintablePage, PageFormat pageFormat) {
        CancelDialog cancelDialog = new CancelDialog(this, HuginGUIConstants.get("str_preparing_previews"), HuginGUIConstants.get("str_preparing_previews_lb_please_wait_"), this);
        cancelDialog.setSize(new Dimension(300, 200));
        HuginGUIUtils.centerComponent(this, (Window)cancelDialog);
        cancelDialog.begin();
        if (this.previews == null) {
            this.dispose();
        }
        ((JPanel)this.getContentPane()).revalidate();
        this.repaint();
    }

    public void cancel() {
        this.cancelled = true;
    }

    public void process() {
        LinkedList<PagePreview> linkedList = new LinkedList<PagePreview>();
        int n = 0;
        int n2 = 0;
        BufferedImage bufferedImage = new BufferedImage((int)this.page.getWidth(), (int)this.page.getHeight(), 1);
        while (!this.cancelled && n2 == 0) {
            Graphics graphics = ((Image)bufferedImage).getGraphics();
            if (this.printable instanceof NodeTablePage) {
                graphics.setClip(0, 0, 0, 0);
                this.printable.print(graphics, this.page, n);
                graphics.translate(-((int)this.page.getImageableX()), -((int)this.page.getImageableY() + 10));
            } else if (this.printable instanceof NodeProbabilitiesPage) {
                graphics.setClip(0, 0, 0, 0);
                this.printable.print(graphics, this.page, n);
            }
            graphics.setClip(0, 0, (int)this.page.getWidth(), (int)this.page.getHeight());
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, (int)this.page.getWidth(), (int)this.page.getHeight());
            graphics.setColor(Color.black);
            n2 = this.printable.print(graphics, this.page, n);
            if (n2 == 0) {
                PagePreview pagePreview = new PagePreview(bufferedImage, this.printable, this.page, n, this);
                pagePreview.addPageSelectedListener(this.selectionListener);
                linkedList.add(pagePreview);
            }
            ++n;
        }
        this.previews = linkedList;
        if (this.cancelled) {
            this.previews = null;
        }
    }

    private class FullPagePreview
    extends JPanel {
        HuginPrintablePage page;
        Image image;
        Dimension size = new Dimension(0, 0);
        PageFormat format;
        int pageNumber;
        Dimension oldSize;
        Point dragPoint;
        Image cursorImage;
        Cursor dragCursor;

        public FullPagePreview(HuginPrintablePage huginPrintablePage, PageFormat pageFormat, int n) {
            this.page = huginPrintablePage;
            this.format = pageFormat;
            this.pageNumber = n;
            this.dragPoint = null;
            this.size = new Dimension(2 * margin + (int)pageFormat.getWidth(), 2 * margin + (int)pageFormat.getHeight());
            this.cursorImage = HuginGUIConstants.MOVE_CURSOR_IMAGE;
            Point point = HuginGUIConstants.SELECT_CURSOR_HOTSPOT;
            this.dragCursor = Toolkit.getDefaultToolkit().createCustomCursor(this.cursorImage, point, "MOVE Cursor");
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    mouseEvent = SwingUtilities.convertMouseEvent(FullPagePreview.this, mouseEvent, PrintPreview.this.scrollPage);
                    FullPagePreview.this.dragPoint = new Point(mouseEvent.getX(), mouseEvent.getY());
                    FullPagePreview.this.setCursor(FullPagePreview.this.dragCursor);
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    FullPagePreview.this.dragPoint = null;
                    FullPagePreview.this.setCursor(null);
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                public void mouseDragged(MouseEvent mouseEvent) {
                    mouseEvent = SwingUtilities.convertMouseEvent(FullPagePreview.this, mouseEvent, PrintPreview.this.scrollPage);
                    JViewport jViewport = PrintPreview.this.scrollPage.getViewport();
                    Point point = jViewport.getViewPosition();
                    Point point2 = (Point)point.clone();
                    point.x -= mouseEvent.getX() - FullPagePreview.this.dragPoint.x;
                    point.y -= mouseEvent.getY() - FullPagePreview.this.dragPoint.y;
                    Dimension dimension = jViewport.getExtentSize();
                    Dimension dimension2 = jViewport.getView().getSize();
                    point.x = Math.min(Math.max(0, point.x), dimension2.width - dimension.width);
                    point.y = Math.min(Math.max(0, point.y), dimension2.height - dimension.height);
                    if (point.x != point2.x) {
                        FullPagePreview.this.dragPoint.x = mouseEvent.getX();
                    }
                    if (point.y != point2.y) {
                        FullPagePreview.this.dragPoint.y = mouseEvent.getY();
                    }
                    jViewport.setViewPosition(point);
                }
            });
        }

        public Dimension getPreferredSize() {
            return this.size;
        }

        public void paintComponent(Graphics graphics) {
            if (this.image == null) {
                this.image = this.createImage(this.size.width, this.size.height);
                Graphics graphics2 = this.image.getGraphics();
                graphics2.setColor(Color.white);
                graphics2.fillRect(0, 0, this.size.width, this.size.height);
                graphics2.setColor(Color.black);
                graphics2.drawRect(margin, margin, this.size.width - 2 * margin, this.size.height - 2 * margin);
                this.page.reset();
                if (this.page instanceof NodeTablePage) {
                    graphics2.setClip(0, 0, 0, 0);
                    this.page.print(graphics2, this.format, this.pageNumber);
                    graphics2.translate(-((int)this.format.getImageableX()), -((int)this.format.getImageableY() + 10));
                } else if (this.page instanceof NodeProbabilitiesPage) {
                    graphics2.setClip(0, 0, 0, 0);
                    this.page.print(graphics2, this.format, this.pageNumber);
                }
                graphics2.setClip(0, 0, this.size.width, this.size.height);
                this.page.print(graphics2, this.format, this.pageNumber);
            }
            graphics.drawImage(this.image, 0, 0, this);
        }
    }

    private static interface PageSelectedListener {
        public void pageSelected(int var1);
    }

    private class PagePreview
    extends JPanel {
        Image image;
        double scaleFactor = 1.0;
        int width;
        int height;
        HuginPrintablePage page;
        int pageNumber;
        PageFormat format;
        boolean selected = false;
        LinkedList<PageSelectedListener> listeners = new LinkedList();

        public PagePreview(Image image, HuginPrintablePage huginPrintablePage, PageFormat pageFormat, int n, Component component) {
            this.pageNumber = n;
            this.page = huginPrintablePage;
            this.format = pageFormat;
            this.width = 120;
            this.height = image.getHeight(this) * 120 / image.getWidth(this);
            this.image = component.createImage(this.getPageWidth(), this.getPageHeight());
            this.image.getGraphics().drawImage(image.getScaledInstance(this.getPageWidth(), this.getPageHeight(), 4), 0, 0, this);
            this.setOpaque(true);
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    PagePreview.this.selected = true;
                    PagePreview.this.firePageSelected(PagePreview.this.pageNumber);
                    PagePreview.this.invalidate();
                }
            });
        }

        public Dimension getPreferredSize() {
            return new Dimension((int)Math.round((double)this.width * this.scaleFactor + (double)(2 * margin)), (int)Math.round((double)this.height * this.scaleFactor + (double)(2 * margin)));
        }

        public void setSelected(boolean bl) {
            if (this.selected == bl) {
                return;
            }
            this.selected = bl;
            this.invalidate();
        }

        public JPanel getFullPage() {
            return new FullPagePreview(this.page, this.format, this.pageNumber);
        }

        public int getPageWidth() {
            return (int)Math.round((double)this.width * this.scaleFactor);
        }

        public int getPageHeight() {
            return (int)Math.round((double)this.height * this.scaleFactor);
        }

        public void paintComponent(Graphics graphics) {
            graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(Color.gray);
            graphics.fillRect((int)(1.5 * (double)margin), (int)(1.5 * (double)margin), this.getPageWidth(), this.getPageHeight());
            graphics.setColor(Color.black);
            graphics.drawRect(margin - 1, margin - 1, this.getPageWidth() + 1, this.getPageHeight() + 1);
            graphics.drawImage(this.image, margin, margin, this);
            if (this.selected) {
                graphics.setColor(Color.red);
                graphics.drawRect(1, 1, this.getPageWidth() + 2 * (margin - 1), this.getPageHeight() + 2 * (margin - 1));
            }
        }

        public void addPageSelectedListener(PageSelectedListener pageSelectedListener) {
            if (!this.listeners.contains(pageSelectedListener)) {
                this.listeners.add(pageSelectedListener);
            }
        }

        public void removePageSelectedListener(PageSelectedListener pageSelectedListener) {
            this.listeners.remove(pageSelectedListener);
        }

        protected void firePageSelected(int n) {
            for (PageSelectedListener pageSelectedListener : this.listeners) {
                pageSelectedListener.pageSelected(n);
            }
        }
    }

    private class PageNavigator
    extends JTextField {
        private int currentPage;
        private int totalPages;

        public PageNavigator() {
            super(5);
            this.addMouseListener(new MouseAdapter(){
                boolean justEntered = true;

                public void mouseExited(MouseEvent mouseEvent) {
                    this.justEntered = true;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (this.justEntered) {
                        Caret caret = PageNavigator.this.getCaret();
                        caret.setSelectionVisible(true);
                        caret.setDot(0);
                        caret.moveDot(PageNavigator.this.getText().length());
                        this.justEntered = false;
                    }
                }
            });
            this.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 38 && PageNavigator.this.currentPage > 0) {
                        PageNavigator.this.decrementPage();
                        return;
                    }
                    if (keyEvent.getKeyCode() == 40 && PageNavigator.this.currentPage < PrintPreview.this.getPageCount() - 1) {
                        PageNavigator.this.incrementPage();
                        return;
                    }
                    if (keyEvent.getKeyChar() == '\n') {
                        try {
                            String string = PageNavigator.this.getText().trim();
                            int n = string.indexOf(" ");
                            int n2 = Integer.parseInt(n > 0 ? string.substring(0, string.indexOf(" ")) : string);
                            if (n2 > 0 && n2 <= PrintPreview.this.getPageCount()) {
                                PageNavigator.this.setActivePage(n2 - 1);
                                return;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        new HuginGUIError(HuginGUIConstants.get("str_no_page_named_") + PageNavigator.this.getText());
                    }
                }
            });
            this.currentPage = 0;
        }

        public void setActivePage(int n) {
            this.currentPage = n;
            this.update();
        }

        public void incrementPage() {
            ++this.currentPage;
            this.update();
        }

        public void decrementPage() {
            --this.currentPage;
            this.update();
        }

        public void moveToFirst() {
            this.currentPage = 0;
            this.update();
        }

        public void moveToLast() {
            this.currentPage = PrintPreview.this.getPageCount() - 1;
            this.update();
        }

        public void update() {
            if (PrintPreview.this.getPageCount() == 0) {
                this.setText("0 of 0");
                PrintPreview.this.start.setEnabled(false);
                PrintPreview.this.previous.setEnabled(false);
                PrintPreview.this.next.setEnabled(false);
                PrintPreview.this.end.setEnabled(false);
                return;
            }
            this.setText(this.currentPage + 1 + " of " + PrintPreview.this.getPageCount());
            PrintPreview.this.start.setEnabled(this.currentPage > 0);
            PrintPreview.this.previous.setEnabled(this.currentPage > 0);
            PrintPreview.this.next.setEnabled(this.currentPage < PrintPreview.this.getPageCount() - 1);
            PrintPreview.this.end.setEnabled(this.currentPage < PrintPreview.this.getPageCount() - 1);
            int n = 0;
            for (PagePreview pagePreview : PrintPreview.this.previews) {
                if (n != this.currentPage) {
                    pagePreview.setSelected(false);
                } else {
                    JViewport jViewport = PrintPreview.this.previewScroller.getViewport();
                    jViewport.setViewPosition(new Point(0, Math.max(0, pagePreview.getY() + (pagePreview.getSize().height - jViewport.getExtentSize().height) / 2)));
                    pagePreview.setSelected(true);
                    PrintPreview.this.activePage.removeAll();
                    PrintPreview.this.fullPage = (FullPagePreview)pagePreview.getFullPage();
                    PrintPreview.this.activePage.add(PrintPreview.this.fullPage);
                    PrintPreview.this.scrollPage.getViewport().setViewPosition(new Point(0, 0));
                }
                ++n;
            }
            PrintPreview.this.allPages.revalidate();
            PrintPreview.this.allPages.repaint();
            PrintPreview.this.activePage.revalidate();
            PrintPreview.this.activePage.repaint();
        }
    }
}

