/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.ContinuousChanceNode;
import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.DiscreteNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExceptionInconsistencyOrUnderflow;
import COM.hugin.HAPI.Node;
import COM.hugin.HGUI.CounterField;
import COM.hugin.HGUI.DistributionPanel;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginAnalysisDialog;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.HuginTableModel;
import COM.hugin.HGUI.NumberField;
import COM.hugin.HGUI.NumberOutOfRangeException;
import COM.hugin.HGUI.TableSorter;
import COM.hugin.HGUI.VerticalFlowLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SEDialog
extends HuginAnalysisDialog {
    DiscreteChanceNode target = null;
    String targetTitle = null;
    Domain domain = null;
    private HuginTableModel likelihoodTableModel = null;
    private HuginTableModel bayesTableModel = null;
    private JTextArea seTextArea = null;
    private JTextArea likelihoodTextArea = null;
    private JTextArea bayesTextArea = null;
    private JTabbedPane tabs = null;
    JComboBox bayesState;
    JComboBox bayesVarAlt;
    JComboBox bayesStateAlt;
    CounterField bayesMaxSubsetSize;
    JPanel whatIfPanel;
    Vector<HuginAnalysisDialog.EvidenceListItem> originalEvidence;
    JList minMaxEvidenceList;
    JList bayesEvidenceList;
    JList likelihoodEvidenceList;
    private int minMaxAnalysisIndex = 0;
    private int likelihoodIndex = 1;
    private int bayesIndex = 2;
    private int whatIfIndex = 3;
    private int findingsIndex = 4;
    private int infoVarsIndex = 5;
    JComboBox variable;
    JPanel findingsPanel;
    NumberField omissionThreshold;
    NumberField sufficiencyThreshold;
    NumberField importanceThreshold;
    JRadioButton allStates;
    JRadioButton oneState;
    JComboBox theState;
    JPanel minMaxPanel;

    public SEDialog(HuginProjectFrame huginProjectFrame, DiscreteChanceNode discreteChanceNode) {
        super(huginProjectFrame, HuginGUIConstants.get("SE"), true);
        this.minimum = new Dimension(600, 420);
        this.target = discreteChanceNode;
        this.setResizable(true);
        this.helpPage = HuginGUIConstants.get("SE_help_page");
        try {
            this.targetTitle = HuginGUIUtils.getNodeTitle(discreteChanceNode);
            this.domain = discreteChanceNode.getHomeDomain();
            this.originalEvidence = this.getEvidence();
            this.setContentPane(this.createContent());
            this.groupDefiner = new HuginAnalysisDialog.GroupDefiner(this, this, huginProjectFrame.getNetworkPanel(), this.target);
            this.groupDefiner.pack();
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage());
            this.dispose();
        }
    }

    @Override
    protected JPanel createContent() throws ExceptionHugin {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tabs = new JTabbedPane();
        this.tabs.add((Component)this.createMinMaxAnalysisTab(), HuginGUIConstants.get("SE_minmax"));
        this.tabs.add((Component)this.createLikelihoodTab(), HuginGUIConstants.get("SE_impact"));
        this.tabs.add((Component)this.createBayesTab(), HuginGUIConstants.get("SE_discrimination"));
        this.tabs.add((Component)this.createWhatIfTab(), HuginGUIConstants.get("SE_whatif"));
        this.tabs.add((Component)this.createFindingsTab(), HuginGUIConstants.get("SE_findings"));
        this.tabs.add((Component)this.createInfoVarsTab(), HuginGUIConstants.get("SE_information_variables"));
        this.tabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (SEDialog.this.tabs.getSelectedIndex() == SEDialog.this.infoVarsIndex || SEDialog.this.tabs.getSelectedIndex() == SEDialog.this.whatIfIndex) {
                    SEDialog.this.perform.setEnabled(false);
                } else {
                    SEDialog.this.perform.setEnabled(true);
                }
            }
        });
        jPanel.add(this.tabs);
        jPanel.add((Component)this.getButtonPanel(1), "South");
        this.pack();
        return jPanel;
    }

    private JPanel createMinMaxAnalysisTab() {
        Object object;
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = null;
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(new DistributionPanel(this.target));
        jScrollPane.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("SE_hypothesis_distribution") + " : " + this.targetTitle));
        String string = "";
        try {
            if (this.domain.isCompressed()) {
                string = HuginGUIConstants.get("SE_domain_is_compressed");
            } else {
                double d = this.target.getEntropy();
                object = this.targetTitle.substring(0, Math.min(maxTitleLength, this.targetTitle.length()));
                string = string + "H(" + (String)object + ") = " + HuginGUIUtils.printDouble(d, this.projectFrame.guiFrame.preferences.precision);
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage());
        }
        jLabel = new JLabel(string);
        jPanel2.add((Component)jLabel, "South");
        jPanel2.add(jScrollPane);
        this.minMaxEvidenceList = new JList(new DefaultListModel());
        JPanel jPanel3 = this.getEvidenceSelectionPanel(this.minMaxEvidenceList);
        JSplitPane jSplitPane = new JSplitPane(1, jPanel2, jPanel3);
        this.minMaxPanel = this.getMinMaxPanel();
        object = new JScrollPane(this.minMaxPanel);
        ((JComponent)object).setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("SE_results")));
        JSplitPane jSplitPane2 = new JSplitPane(0, jSplitPane, (Component)object);
        jSplitPane2.setResizeWeight(0.5);
        jSplitPane2.setDividerLocation(170);
        jPanel.add(jSplitPane2);
        return jPanel;
    }

    private JPanel createLikelihoodTab() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JTextArea jTextArea = this.getTextArea(2, 20);
        jTextArea.append(HuginGUIConstants.get("SE_impact_description"));
        jPanel3.add(jTextArea);
        DistributionPanel distributionPanel = new DistributionPanel(this.target);
        JScrollPane jScrollPane = new JScrollPane(distributionPanel);
        distributionPanel.setUpdate(false);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("SE_hypothesis_distribution") + " : " + this.targetTitle));
        this.likelihoodEvidenceList = new JList(new DefaultListModel());
        JPanel jPanel4 = this.getEvidenceSelectionPanel(this.likelihoodEvidenceList);
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, jPanel4);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        this.likelihoodTableModel = new HuginTableModel(this.target);
        TableSorter tableSorter = new TableSorter(this.likelihoodTableModel);
        JTable jTable = new JTable(tableSorter);
        tableSorter.setTableHeader(jTable.getTableHeader());
        jTable.setPreferredScrollableViewportSize(new Dimension(500, 120));
        HuginAnalysisDialog.DoubleTableRenderer doubleTableRenderer = new HuginAnalysisDialog.DoubleTableRenderer(this.projectFrame.guiFrame.preferences.precision);
        jTable.setDefaultRenderer(Double.class, doubleTableRenderer);
        JScrollPane jScrollPane2 = new JScrollPane(jTable, 22, 31);
        jScrollPane2.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("SE_impact_subsets")));
        jPanel5.add(jScrollPane2);
        jPanel2.add((Component)new JScrollPane(jPanel3, 21, 31), "North");
        jPanel2.add(jSplitPane);
        JSplitPane jSplitPane2 = new JSplitPane(0, jPanel2, jPanel5);
        jSplitPane2.setResizeWeight(0.5);
        jSplitPane2.setDividerLocation(170);
        jPanel.add(jSplitPane2);
        return jPanel;
    }

    private JPanel createBayesTab() {
        Object object;
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JTextArea jTextArea = this.getTextArea(2, 20);
        jTextArea.append(HuginGUIConstants.get("SE_discrimination_description"));
        jPanel3.add(jTextArea);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        this.bayesState = new JComboBox();
        try {
            for (int i = 0; i < this.target.getNumberOfStates(); ++i) {
                object = HuginGUIUtils.getNodeStateLabel(this.target, i);
                this.bayesState.addItem(object);
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception.getMessage());
        }
        this.bayesState.setSelectedIndex(-1);
        this.bayesStateAlt = new JComboBox();
        this.bayesVarAlt = new JComboBox(new HuginAnalysisDialog.NodeListModel(this.domain, null));
        this.bayesVarAlt.setSelectedIndex(-1);
        this.bayesVarAlt.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                HuginAnalysisDialog.NodeWrapper nodeWrapper = (HuginAnalysisDialog.NodeWrapper)SEDialog.this.bayesVarAlt.getSelectedItem();
                try {
                    DiscreteChanceNode discreteChanceNode = (DiscreteChanceNode)nodeWrapper.node;
                    SEDialog.this.bayesStateAlt.removeAllItems();
                    for (int i = 0; i < discreteChanceNode.getNumberOfStates(); ++i) {
                        String string = HuginGUIUtils.getNodeStateLabel(discreteChanceNode, i);
                        SEDialog.this.bayesStateAlt.addItem(string);
                    }
                    SEDialog.this.bayesStateAlt.setSelectedIndex(-1);
                }
                catch (Exception exception) {
                    new HuginGUIError(exception.getMessage());
                }
            }
        });
        String string = this.targetTitle.substring(0, Math.min(maxTitleLength, this.targetTitle.length()));
        object = new JLabel("-" + HuginGUIConstants.get("state_of") + " " + string + " : ");
        JLabel jLabel = new JLabel("-" + HuginGUIConstants.get("variable") + " : ");
        JLabel jLabel2 = new JLabel("-" + HuginGUIConstants.get("state") + "  : ");
        JLabel jLabel3 = new JLabel(HuginGUIConstants.get("SE_alternative_hypothesis"));
        this.bayesMaxSubsetSize = new CounterField(HuginGUIConstants.get("SE_Max_size_of_subset"), 1, this.getEvidenceNodes().size(), 1, 6);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel5.add((Component)object, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        jPanel5.add((Component)this.bayesState, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        jPanel5.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        jPanel5.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        jPanel5.add((Component)this.bayesVarAlt, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        jPanel5.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        jPanel5.add((Component)this.bayesStateAlt, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        jPanel5.add((Component)new JLabel(HuginGUIConstants.get("SE_Max_size_of_subset")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        jPanel5.add((Component)this.bayesMaxSubsetSize, gridBagConstraints);
        jPanel4.add((Component)jPanel5, "North");
        JScrollPane jScrollPane = new JScrollPane(jPanel4);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("SE_select_hypotheses")));
        jScrollPane.setPreferredSize(new Dimension(300, jScrollPane.getSize().height));
        this.bayesEvidenceList = new JList(new DefaultListModel());
        JPanel jPanel6 = this.getEvidenceSelectionPanel(this.bayesEvidenceList);
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, jPanel6);
        JPanel jPanel7 = new JPanel(new BorderLayout());
        this.bayesTableModel = new HuginTableModel("B");
        TableSorter tableSorter = new TableSorter(this.bayesTableModel);
        JTable jTable = new JTable(tableSorter);
        tableSorter.setTableHeader(jTable.getTableHeader());
        jTable.setPreferredScrollableViewportSize(new Dimension(500, 120));
        HuginAnalysisDialog.DoubleTableRenderer doubleTableRenderer = new HuginAnalysisDialog.DoubleTableRenderer(this.projectFrame.guiFrame.preferences.precision);
        jTable.setDefaultRenderer(Double.class, doubleTableRenderer);
        JScrollPane jScrollPane2 = new JScrollPane(jTable, 22, 31);
        jScrollPane2.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("SE_bayes_factor")));
        jPanel7.add(jScrollPane2);
        jPanel2.add((Component)new JScrollPane(jPanel3, 21, 31), "North");
        jPanel2.add(jSplitPane);
        JSplitPane jSplitPane2 = new JSplitPane(0, jPanel2, jScrollPane2);
        jSplitPane2.setResizeWeight(0.5);
        jSplitPane2.setDividerLocation(170);
        jPanel.add(jSplitPane2);
        return jPanel;
    }

    private JPanel createWhatIfTab() throws ExceptionHugin {
        JPanel jPanel = new JPanel(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(new DistributionPanel(this.target));
        this.whatIfPanel = this.getWhatIfPanel();
        JScrollPane jScrollPane2 = new JScrollPane(this.whatIfPanel);
        jScrollPane2.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("SE_whatif_distributions")));
        jScrollPane.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("SE_hypothesis_distribution") + " : " + this.targetTitle));
        JPanel jPanel2 = this.getEvidenceVarPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("SE_evidence_variable")));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add(jScrollPane);
        jPanel3.add((Component)new JScrollPane(jPanel2, 21, 31), "South");
        JSplitPane jSplitPane = new JSplitPane(1, jPanel3, jScrollPane2);
        jSplitPane.setResizeWeight(0.5);
        jSplitPane.setDividerLocation(275);
        jPanel.add(jSplitPane);
        this.pack();
        return jPanel;
    }

    private JPanel getWhatIfPanel() {
        JPanel jPanel = new JPanel(new VerticalFlowLayout(0));
        jPanel.setSize(new Dimension(300, 100));
        jPanel.setBackground(Color.white);
        return jPanel;
    }

    private JPanel getEvidenceVarPanel() throws ExceptionHugin {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JTextArea jTextArea = this.getTextArea(1, 10);
        jTextArea.append(HuginGUIConstants.get("SE_select_variable"));
        DefaultComboBoxModel<HuginAnalysisDialog.EvidenceListItem> defaultComboBoxModel = new DefaultComboBoxModel<HuginAnalysisDialog.EvidenceListItem>();
        Vector<HuginAnalysisDialog.EvidenceListItem> vector = this.getEvidence();
        for (int i = 0; i < vector.size(); ++i) {
            HuginAnalysisDialog.EvidenceListItem evidenceListItem = vector.get(i);
            if (evidenceListItem.isDiscrete()) {
                defaultComboBoxModel.addElement(evidenceListItem);
            }
            if (!evidenceListItem.isContinuous()) continue;
            defaultComboBoxModel.addElement(evidenceListItem);
        }
        this.variable = new JComboBox(defaultComboBoxModel);
        jPanel2.add(jTextArea);
        jPanel.add(jPanel2);
        jPanel3.add((Component)this.variable, "West");
        jPanel.add((Component)jPanel3, "South");
        if (this.variable.getItemCount() == 0) {
            return jPanel;
        }
        this.variable.setSelectedIndex(-1);
        this.variable.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    try {
                        Node node;
                        HuginAnalysisDialog.EvidenceListItem evidenceListItem;
                        HuginGUIUtils.configureDomain(SEDialog.this.domain);
                        SEDialog.this.whatIfPanel.removeAll();
                        SEDialog.this.whatIfPanel.revalidate();
                        SEDialog.this.whatIfPanel.repaint();
                        HuginAnalysisDialog.EvidenceListItem evidenceListItem2 = (HuginAnalysisDialog.EvidenceListItem)SEDialog.this.variable.getSelectedItem();
                        Node node2 = evidenceListItem2.getNode();
                        if (evidenceListItem2.isDiscrete()) {
                            int n;
                            evidenceListItem = (HuginAnalysisDialog.DiscreteEvidenceListItem)evidenceListItem2;
                            node = (DiscreteChanceNode)node2;
                            for (n = 0; n < ((DiscreteNode)node).getNumberOfStates(); ++n) {
                                SEDialog.this.domain.resetInferenceEngine();
                                ((DiscreteNode)node).retractFindings();
                                ((DiscreteNode)node).selectState(n);
                                JPanel jPanel = new JPanel(new BorderLayout());
                                String string = HuginGUIUtils.getNodeStateLabel(node, n);
                                try {
                                    SEDialog.this.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
                                    double[] dArray = new double[SEDialog.this.target.getNumberOfStates()];
                                    for (int i = 0; i < SEDialog.this.target.getNumberOfStates(); ++i) {
                                        dArray[i] = SEDialog.this.target.getBelief(i);
                                    }
                                    SEDialog.this.whatIfPanel.add(new JLabel(HuginGUIConstants.get("State") + " : " + string));
                                    SEDialog.this.whatIfPanel.add((Component)new DistributionPanel(SEDialog.this.target, dArray), "South");
                                }
                                catch (ExceptionInconsistencyOrUnderflow exceptionInconsistencyOrUnderflow) {
                                    SEDialog.this.whatIfPanel.add(new JLabel(HuginGUIConstants.get("State") + " : " + string));
                                    SEDialog.this.whatIfPanel.add((Component)new JLabel(HuginGUIConstants.get("SE_inconsistent_evidence")), "South");
                                }
                                SEDialog.this.whatIfPanel.revalidate();
                                SEDialog.this.whatIfPanel.repaint();
                            }
                            ((DiscreteNode)node).retractFindings();
                            for (n = 0; n < ((DiscreteNode)node).getNumberOfStates(); ++n) {
                                ((DiscreteNode)node).enterFinding(n, ((HuginAnalysisDialog.DiscreteEvidenceListItem)evidenceListItem).findings[n]);
                            }
                        }
                        if (node2 instanceof ContinuousChanceNode) {
                            evidenceListItem = (HuginAnalysisDialog.ContinuousEvidenceListItem)evidenceListItem2;
                            node = (ContinuousChanceNode)node2;
                            try {
                                ((ContinuousChanceNode)node).retractFindings();
                                SEDialog.this.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
                                double d = ((ContinuousChanceNode)node).getMean();
                                double d2 = Math.sqrt(((ContinuousChanceNode)node).getVariance());
                                double[] dArray = new double[]{d - 2.0 * d2, d - 3.0 * d2 / 2.0, d - d2, d - d2 / 2.0, d, d + d2 / 2.0, d + d2, d + 3.0 * d2 / 2.0, d + 2.0 * d2};
                                for (int i = 0; i < dArray.length; ++i) {
                                    SEDialog.this.domain.resetInferenceEngine();
                                    ((ContinuousChanceNode)node).retractFindings();
                                    ((ContinuousChanceNode)node).enterValue(dArray[i]);
                                    JPanel jPanel = new JPanel(new BorderLayout());
                                    String string = "" + HuginGUIUtils.printDouble(dArray[i], SEDialog.this.projectFrame.guiFrame.preferences.precision);
                                    try {
                                        SEDialog.this.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
                                        double[] dArray2 = new double[SEDialog.this.target.getNumberOfStates()];
                                        for (int j = 0; j < SEDialog.this.target.getNumberOfStates(); ++j) {
                                            dArray2[j] = SEDialog.this.target.getBelief(j);
                                        }
                                        SEDialog.this.whatIfPanel.add(new JLabel(HuginGUIConstants.get("Value") + " : " + string));
                                        SEDialog.this.whatIfPanel.add((Component)new DistributionPanel(SEDialog.this.target, dArray2), "South");
                                    }
                                    catch (ExceptionInconsistencyOrUnderflow exceptionInconsistencyOrUnderflow) {
                                        SEDialog.this.whatIfPanel.add(new JLabel(HuginGUIConstants.get("Value") + " : " + string));
                                        SEDialog.this.whatIfPanel.add((Component)new JLabel(HuginGUIConstants.get("SE_inconsistent_evidence")), "South");
                                    }
                                    SEDialog.this.whatIfPanel.revalidate();
                                    SEDialog.this.whatIfPanel.repaint();
                                }
                                ((HuginAnalysisDialog.ContinuousEvidenceListItem)evidenceListItem).enterEvidence();
                            }
                            catch (ExceptionHugin exceptionHugin) {
                                new HuginGUIError(exceptionHugin.getMessage());
                            }
                        }
                        SEDialog.this.domain.resetInferenceEngine();
                        SEDialog.this.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
                    }
                    catch (ExceptionHugin exceptionHugin) {
                        new HuginGUIError(exceptionHugin.getMessage());
                    }
                }
            }
        });
        return jPanel;
    }

    private JPanel createFindingsTab() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = this.getFindingsSettingPanel();
        JScrollPane jScrollPane = new JScrollPane(jPanel2);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("SE_findings_impact_on_h") + " = " + this.targetTitle));
        this.findingsPanel = this.getFindingsPanel();
        JScrollPane jScrollPane2 = new JScrollPane(this.findingsPanel);
        jScrollPane2.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("SE_findings_impact_distibutions")));
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, jScrollPane2);
        jSplitPane.setResizeWeight(0.0);
        jSplitPane.setDividerLocation(275);
        jPanel.add(jSplitPane);
        this.pack();
        return jPanel;
    }

    public double getOmissionThreshold() {
        return this.omissionThreshold.getNumber();
    }

    public double getSufficiencyThreshold() {
        return this.sufficiencyThreshold.getNumber();
    }

    public double getImportanceThreshold() {
        return this.importanceThreshold.getNumber();
    }

    private JPanel getFindingsSettingPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JTextArea jTextArea = this.getTextArea(2, 20);
        jTextArea.append(HuginGUIConstants.get("SE_findings_impact_analysis"));
        JLabel jLabel = new JLabel(HuginGUIConstants.get("SE_cost_of_omission") + " : ");
        JLabel jLabel2 = new JLabel(HuginGUIConstants.get("SE_sufficiency") + ": ");
        JLabel jLabel3 = new JLabel(HuginGUIConstants.get("SE_importance") + " : ");
        this.omissionThreshold = new NumberField(new Double(1.0E-4));
        this.omissionThreshold.setHorizontalAlignment(4);
        this.sufficiencyThreshold = new NumberField(new Double(0.02));
        this.sufficiencyThreshold.setHorizontalAlignment(4);
        this.importanceThreshold = new NumberField(new Double(0.1));
        this.importanceThreshold.setHorizontalAlignment(4);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.allStates = new JRadioButton(HuginGUIConstants.get("SE_all_states"));
        this.allStates.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SEDialog.this.theState.setEnabled(false);
            }
        });
        this.oneState = new JRadioButton(HuginGUIConstants.get("SE_a_single_state") + ": ");
        this.oneState.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SEDialog.this.theState.setEnabled(true);
            }
        });
        this.allStates.setSelected(true);
        buttonGroup.add(this.allStates);
        buttonGroup.add(this.oneState);
        this.theState = new JComboBox();
        this.theState.setEnabled(false);
        try {
            for (int i = 0; i < this.target.getNumberOfStates(); ++i) {
                String string = HuginGUIUtils.getNodeStateLabel(this.target, i);
                this.theState.addItem(string);
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            // empty catch block
        }
        this.theState.setSelectedIndex(0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        jPanel2.add((Component)jTextArea, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        jPanel2.add((Component)new JLabel(HuginGUIConstants.get("SE_thresholds")), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        jPanel2.add((Component)this.omissionThreshold, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        jPanel2.add((Component)this.sufficiencyThreshold, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        jPanel2.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        jPanel2.add((Component)this.importanceThreshold, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        jPanel2.add((Component)this.allStates, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 1;
        jPanel2.add((Component)this.oneState, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        jPanel2.add((Component)this.theState, gridBagConstraints);
        jPanel.add((Component)jPanel2, "North");
        return jPanel;
    }

    private JPanel getFindingsPanel() {
        JPanel jPanel = new JPanel(new VerticalFlowLayout());
        jPanel.setSize(new Dimension(300, 100));
        jPanel.setBackground(Color.white);
        return jPanel;
    }

    private JPanel getMinMaxPanel() {
        JPanel jPanel = new JPanel(new VerticalFlowLayout());
        jPanel.setSize(new Dimension(300, 100));
        jPanel.setBackground(Color.white);
        return jPanel;
    }

    @Override
    protected JButton getPerformButton() {
        JButton jButton = new JButton(HuginGUIConstants.get("ANALYSIS_Calculate"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (SEDialog.this.tabs.getSelectedIndex() == SEDialog.this.minMaxAnalysisIndex) {
                        SEDialog.this.minMaxAnalysisAction(SEDialog.this.minMaxEvidenceList);
                    }
                    if (SEDialog.this.tabs.getSelectedIndex() == SEDialog.this.likelihoodIndex) {
                        SEDialog.this.likelihoodAction(SEDialog.this.likelihoodEvidenceList);
                    }
                    if (SEDialog.this.tabs.getSelectedIndex() == SEDialog.this.bayesIndex) {
                        SEDialog.this.bayesAction(SEDialog.this.bayesEvidenceList);
                    }
                    if (SEDialog.this.tabs.getSelectedIndex() == SEDialog.this.whatIfIndex) {
                        SEDialog.this.whatIfAction();
                    }
                    if (SEDialog.this.tabs.getSelectedIndex() == SEDialog.this.findingsIndex) {
                        SEDialog.this.findingsAction();
                    }
                }
                catch (ExceptionHugin exceptionHugin) {
                    new HuginGUIError(exceptionHugin.getMessage());
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
        });
        return jButton;
    }

    private void minMaxAnalysisAction(JList jList) throws ExceptionHugin {
        int n = this.target.getNumberOfStates();
        this.minMaxPanel.removeAll();
        this.minMaxPanel.revalidate();
        this.minMaxPanel.repaint();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray3[i] = this.target.getBelief(i);
        }
        this.minMaxPanel.add(new JLabel(HuginGUIConstants.get("Evidence_on") + " : " + this.getSelectedEvidence(jList) + "\n"));
        this.minMaxPanel.add(new JLabel(HuginGUIConstants.get("SE_selected_information_variables") + " : "));
        Vector<HuginAnalysisDialog.ListItem> vector = this.getInfoVars();
        if (vector.size() == 0) {
            this.minMaxPanel.add(new JLabel(HuginGUIConstants.get("SE_no_selection")));
        } else {
            for (HuginAnalysisDialog.ListItem listItem : vector) {
                this.minMaxPanel.add(new JLabel(HuginGUIUtils.getNodeTitle(listItem.getNode()) + " "));
            }
            this.minMaxPanel.add(new JLabel("\n"));
        }
        this.minMaxPanel.add(new JLabel("--------------------------------------------------\n"));
        for (HuginAnalysisDialog.ListItem listItem : this.getInfoVars()) {
            int n2;
            int n3;
            int n4;
            DiscreteChanceNode discreteChanceNode = (DiscreteChanceNode)listItem.getNode();
            String string = HuginGUIUtils.getNodeTitle(discreteChanceNode);
            this.domain.initialize();
            this.enterSelectedEvidence(jList);
            double[] dArray4 = new double[discreteChanceNode.getNumberOfStates()];
            for (n4 = 0; n4 < discreteChanceNode.getNumberOfStates(); ++n4) {
                dArray4[n4] = discreteChanceNode.getEnteredFinding(n4);
            }
            for (n4 = 0; n4 < n; ++n4) {
                dArray[n4] = 1.0;
                dArray2[n4] = 0.0;
            }
            String string2 = " " + HuginGUIConstants.get("Belief_ranges_etc");
            this.minMaxPanel.add(new JLabel(string2));
            for (n3 = 0; n3 < discreteChanceNode.getNumberOfStates(); ++n3) {
                this.domain.resetInferenceEngine();
                discreteChanceNode.retractFindings();
                discreteChanceNode.selectState(n3);
                try {
                    this.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
                    for (n2 = 0; n2 < n; ++n2) {
                        if (dArray[n2] > this.target.getBelief(n2)) {
                            dArray[n2] = this.target.getBelief(n2);
                        }
                        if (!(dArray2[n2] < this.target.getBelief(n2))) continue;
                        dArray2[n2] = this.target.getBelief(n2);
                    }
                    continue;
                }
                catch (ExceptionInconsistencyOrUnderflow exceptionInconsistencyOrUnderflow) {
                    // empty catch block
                }
            }
            discreteChanceNode.retractFindings();
            for (n3 = 0; n3 < discreteChanceNode.getNumberOfStates(); ++n3) {
                discreteChanceNode.enterFinding(n3, dArray4[n3]);
            }
            this.domain.resetInferenceEngine();
            this.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
            String[] stringArray = new String[]{"min P(h|e\\f,g)", "P(h|e)", "max P(h|e\\f,g)"};
            for (n2 = 0; n2 < n; ++n2) {
                String string3 = HuginGUIUtils.getNodeStateLabel(this.target, n2);
                if (string3.length() > 14) {
                    string3 = string3.substring(0, 14);
                }
                double[] dArray5 = new double[]{dArray[n2], this.target.getBelief(n2), dArray2[n2]};
                this.minMaxPanel.add(new JLabel(HuginGUIConstants.get("SE_Sensitivity_of_ARGV0_to_findings_at_ARGV1", new String[]{this.targetTitle + " = " + string3, string}) + ": \n\n"));
                this.minMaxPanel.add(new DistributionPanel(stringArray, dArray5));
            }
            String string4 = "";
            if (this.domain.isCompressed()) {
                string4 = string4 + HuginGUIConstants.get("SE_domain_is_compressed");
            } else {
                this.domain.initialize();
                this.enterSelectedEvidence(jList);
                this.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
                double d = discreteChanceNode.getMutualInformation(this.target);
                String string5 = this.targetTitle.substring(0, Math.min(maxTitleLength, this.targetTitle.length()));
                string4 = string4 + "\n " + HuginGUIConstants.get("Mutual_information") + " : I( " + string5 + ", " + HuginGUIUtils.getNodeTitle(discreteChanceNode) + " | " + HuginGUIConstants.get("Selected_Evidence") + " ) = " + HuginGUIUtils.printDouble(d, this.projectFrame.guiFrame.preferences.precision);
            }
            this.minMaxPanel.add(new JLabel(string4));
            this.minMaxPanel.add(new JLabel(" * * * * * * * * * * * * * * * * * * * * * * * * * "));
            this.minMaxPanel.revalidate();
            this.minMaxPanel.repaint();
        }
        this.enterEvidence(this.originalEvidence);
        this.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
    }

    private void likelihoodAction(JList jList) throws ExceptionHugin {
        Object object;
        int n;
        int n2;
        Vector<HuginAnalysisDialog.EvidenceListItem> vector = this.getEvidenceVector(jList);
        int n3 = this.target.getNumberOfStates() + vector.size();
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            nArray[i] = 0;
        }
        if (this.promptUser((int)Math.pow(2.0, vector.size())) == 1) {
            return;
        }
        Vector<int[]> vector2 = new Vector<int[]>();
        this.generateSubsets(nArray, 0, vector, vector2, 0, vector.size());
        this.likelihoodTableModel.resize(vector2.size(), n3);
        String string = "";
        for (n2 = 0; n2 < vector.size(); ++n2) {
            string = string + "\t";
        }
        string = string + HuginGUIConstants.get("Normalized_Likelihoods") + "\n";
        n2 = 0;
        for (n = 0; n < vector.size(); ++n) {
            object = vector.get(n);
            String string2 = HuginGUIUtils.getNodeTitle(((HuginAnalysisDialog.ListItem)object).getNode());
            this.likelihoodTableModel.setColumnName(n2, string2);
            ++n2;
        }
        for (n = 0; n < this.target.getNumberOfStates(); ++n) {
            object = HuginGUIUtils.getNodeStateLabel(this.target, n);
            this.likelihoodTableModel.setColumnName(n2, (String)object);
            ++n2;
        }
        for (n = 0; n < vector2.size(); ++n) {
            int n4;
            for (n4 = 0; n4 < vector.size(); ++n4) {
                this.likelihoodTableModel.setValueAt(new Boolean(false), n, n4);
            }
            for (n4 = 0; n4 < this.target.getNumberOfStates(); ++n4) {
                this.likelihoodTableModel.setValueAt(new Double(0.0), n, n4 + vector.size());
            }
        }
        try {
            HuginWorker huginWorker = new HuginWorker((Vector)vector2, (Vector)vector){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object;
                    try {
                        int n;
                        object = new double[SEDialog.this.target.getNumberOfStates()];
                        double[] dArray = new double[SEDialog.this.target.getNumberOfStates()];
                        Domain domain = SEDialog.this.domain;
                        synchronized (domain) {
                            SEDialog.this.domain.initialize();
                        }
                        for (n = 0; n < SEDialog.this.target.getNumberOfStates(); ++n) {
                            object[n] = SEDialog.this.target.getBelief(n);
                        }
                        for (n = 0; n < this.subsets.size() && !this.stop; ++n) {
                            int n2;
                            String string = HuginGUIConstants.get("SE_Completed_ARGV0_out_of_ARGV1_propagations", new String[]{"" + n, "" + this.subsets.size()});
                            this.dialog.setProgress(n);
                            this.dialog.writeMessage(string);
                            String string2 = "";
                            int[] nArray = (int[])this.subsets.get(n);
                            int n3 = 0;
                            for (n2 = 0; n2 < this.evidence.size(); ++n2) {
                                if (nArray[n2] > 0) {
                                    SEDialog.this.likelihoodTableModel.setValueAt(new Boolean(true), n, n3);
                                } else {
                                    SEDialog.this.likelihoodTableModel.setValueAt(new Boolean(false), n, n3);
                                }
                                ++n3;
                            }
                            for (n2 = 0; n2 < this.evidence.size(); ++n2) {
                                if (nArray[n2] <= 0) continue;
                                HuginAnalysisDialog.EvidenceListItem evidenceListItem = (HuginAnalysisDialog.EvidenceListItem)this.evidence.get(n2);
                                evidenceListItem.enterEvidence();
                            }
                            SEDialog.this.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
                            for (n2 = 0; n2 < SEDialog.this.target.getNumberOfStates(); ++n2) {
                                dArray[n2] = SEDialog.this.target.getBelief(n2);
                            }
                            for (n2 = 0; n2 < SEDialog.this.target.getNumberOfStates(); ++n2) {
                                double d = object[n2];
                                double d2 = dArray[n2];
                                double d3 = 0.0;
                                if (d != 0.0) {
                                    d3 = d2 / d;
                                }
                                Double d4 = new Double(HuginGUIUtils.printDouble(d3, Math.min(SEDialog.this.projectFrame.guiFrame.preferences.precision, 6)));
                                SEDialog.this.likelihoodTableModel.setValueAt(d4, n, n3);
                                ++n3;
                            }
                            Domain domain2 = SEDialog.this.domain;
                            synchronized (domain2) {
                                SEDialog.this.domain.initialize();
                                continue;
                            }
                        }
                    }
                    catch (ExceptionHugin exceptionHugin) {
                        new HuginGUIError(exceptionHugin.getMessage());
                    }
                    if (!this.stop) {
                        this.dialog.setProgress(this.subsets.size());
                        object = HuginGUIConstants.get("Completed_all_propagations");
                        SEDialog.this.likelihoodTableModel.fireTableStructureChanged();
                    } else {
                        object = HuginGUIConstants.get("Cancelled_propagations");
                        SEDialog.this.likelihoodTableModel.resize(0, 0);
                    }
                    Hugin.mainFrame.repaint();
                    this.dialog.writeMessage((String)object);
                    this.dialog.enableOK();
                }
            };
            ProgressDialog progressDialog = new ProgressDialog(huginWorker);
            huginWorker.setDialog(progressDialog);
            progressDialog.pack();
            HuginGUIUtils.centerComponent(this, (Window)progressDialog);
            progressDialog.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new HuginGUIError(exception.getMessage());
        }
        for (int i = 0; i < vector.size(); ++i) {
            HuginAnalysisDialog.EvidenceListItem evidenceListItem = vector.get(i);
            evidenceListItem.enterEvidence();
        }
        this.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
        this.likelihoodTableModel.fireTableStructureChanged();
        Hugin.mainFrame.repaint();
    }

    private void bayesAction(JList jList) throws ExceptionHugin {
        if (this.bayesState.getSelectedIndex() >= 0 && this.bayesVarAlt.getSelectedIndex() >= 0 && this.bayesStateAlt.getSelectedIndex() >= 0) {
            Object object;
            Vector<HuginAnalysisDialog.EvidenceListItem> vector = this.getEvidenceVector(jList);
            int n = vector.size() + 1;
            int[] nArray = new int[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                nArray[i] = 0;
            }
            Vector<int[]> vector2 = new Vector<int[]>();
            int n2 = 1;
            try {
                n2 = this.bayesMaxSubsetSize.getValue();
            }
            catch (NumberOutOfRangeException numberOutOfRangeException) {
                // empty catch block
            }
            this.generateSubsets(nArray, 0, vector, vector2, 0, n2);
            if (this.promptUser(vector2.size()) == 1) {
                return;
            }
            this.bayesTableModel.resize(vector2.size(), n);
            int n3 = 0;
            for (int i = 0; i < vector.size(); ++i) {
                object = vector.get(i);
                String string = HuginGUIUtils.getNodeTitle(((HuginAnalysisDialog.ListItem)object).getNode());
                this.bayesTableModel.setColumnName(n3, string);
                ++n3;
            }
            this.bayesTableModel.setColumnName(n3, "B");
            ++n3;
            try {
                HuginWorker huginWorker = new HuginWorker((Vector)vector2, (Vector)vector){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        HuginAnalysisDialog.NodeWrapper nodeWrapper = (HuginAnalysisDialog.NodeWrapper)SEDialog.this.bayesVarAlt.getSelectedItem();
                        DiscreteChanceNode discreteChanceNode = (DiscreteChanceNode)nodeWrapper.node;
                        int n = SEDialog.this.bayesState.getSelectedIndex();
                        int n2 = SEDialog.this.bayesStateAlt.getSelectedIndex();
                        double d = 0.0;
                        double d2 = 0.0;
                        double d3 = 0.0;
                        try {
                            SEDialog.this.domain.initialize();
                            d = SEDialog.this.target.getBelief(n);
                            d2 = discreteChanceNode.getBelief(n2);
                        }
                        catch (ExceptionHugin exceptionHugin) {
                            new HuginGUIError(exceptionHugin.getMessage());
                        }
                        if (d2 == 0.0 || d == 0.0) {
                            new HuginGUIError(HuginGUIConstants.get("SE_prior_error"));
                            SEDialog.this.bayesTableModel.resize(0, 0);
                            SEDialog.this.bayesTableModel.fireTableStructureChanged();
                        } else {
                            String string;
                            try {
                                for (int i = 0; i < this.subsets.size() && !this.stop; ++i) {
                                    Object object;
                                    int n3;
                                    String string2 = HuginGUIConstants.get("SE_Completed_ARGV0_out_of_ARGV1_propagations", new String[]{"" + i, "" + this.subsets.size()});
                                    this.dialog.setProgress(i);
                                    this.dialog.writeMessage(string2);
                                    String string3 = "";
                                    int[] nArray = (int[])this.subsets.get(i);
                                    int n4 = 0;
                                    for (n3 = 0; n3 < this.evidence.size(); ++n3) {
                                        if (nArray[n3] > 0) {
                                            SEDialog.this.bayesTableModel.setValueAt(new Boolean(true), i, n4);
                                        } else {
                                            SEDialog.this.bayesTableModel.setValueAt(new Boolean(false), i, n4);
                                        }
                                        ++n4;
                                    }
                                    for (n3 = 0; n3 < this.evidence.size(); ++n3) {
                                        if (nArray[n3] <= 0) continue;
                                        HuginAnalysisDialog.EvidenceListItem evidenceListItem = (HuginAnalysisDialog.EvidenceListItem)this.evidence.get(n3);
                                        evidenceListItem.enterEvidence();
                                    }
                                    SEDialog.this.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
                                    double d4 = SEDialog.this.target.getBelief(n);
                                    d3 = discreteChanceNode.getBelief(n2);
                                    double d5 = 0.0;
                                    double d6 = 0.0;
                                    double d7 = 0.0;
                                    if (d2 != 0.0) {
                                        d5 = d / d2;
                                    }
                                    if (d3 != 0.0) {
                                        d6 = d4 / d3;
                                    }
                                    if (d3 == 0.0) {
                                        d7 = Double.POSITIVE_INFINITY;
                                    } else if (d5 != 0.0) {
                                        d7 = d6 / d5;
                                    }
                                    if (d7 == Double.POSITIVE_INFINITY) {
                                        SEDialog.this.bayesTableModel.setValueAt(new Double(Double.POSITIVE_INFINITY), i, n4);
                                    } else {
                                        object = new Double(HuginGUIUtils.printDouble(d7, SEDialog.this.projectFrame.guiFrame.preferences.precision));
                                        SEDialog.this.bayesTableModel.setValueAt(object, i, n4);
                                    }
                                    ++n4;
                                    object = SEDialog.this.domain;
                                    synchronized (object) {
                                        SEDialog.this.domain.initialize();
                                        continue;
                                    }
                                }
                            }
                            catch (ExceptionHugin exceptionHugin) {
                                new HuginGUIError(exceptionHugin.getMessage());
                            }
                            if (!this.stop) {
                                this.dialog.setProgress(this.subsets.size());
                                string = HuginGUIConstants.get("Completed_all_propagations");
                                SEDialog.this.bayesTableModel.fireTableStructureChanged();
                            } else {
                                string = HuginGUIConstants.get("Cancelled_propagations");
                                SEDialog.this.bayesTableModel.resize(0, 0);
                            }
                            Hugin.mainFrame.repaint();
                            this.dialog.writeMessage(string);
                            this.dialog.enableOK();
                        }
                    }
                };
                object = new ProgressDialog(huginWorker);
                huginWorker.setDialog((ProgressDialog)object);
                ((Window)object).pack();
                HuginGUIUtils.centerComponent(this, (Window)object);
                ((Dialog)object).setVisible(true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                new HuginGUIError(exception.getMessage());
            }
            for (int i = 0; i < vector.size(); ++i) {
                object = vector.get(i);
                ((HuginAnalysisDialog.EvidenceListItem)object).enterEvidence();
            }
            this.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
            this.bayesTableModel.fireTableStructureChanged();
            Hugin.mainFrame.repaint();
        } else {
            new HuginGUIError(HuginGUIConstants.get("SE_discrimination_error"));
        }
    }

    private void whatIfAction() throws ExceptionHugin {
    }

    private void findingsAction() throws ExceptionHugin {
        this.findingsPanel.removeAll();
        this.findingsPanel.revalidate();
        this.findingsPanel.repaint();
        if (this.target != null) {
            Object object;
            int n;
            Vector<HuginAnalysisDialog.EvidenceListItem> vector = new Vector<HuginAnalysisDialog.EvidenceListItem>();
            double d = this.getOmissionThreshold();
            double d2 = this.getSufficiencyThreshold();
            double d3 = this.getImportanceThreshold();
            int n2 = this.theState.getSelectedIndex();
            Vector<HuginAnalysisDialog.EvidenceListItem> vector2 = this.getEvidence();
            double[] dArray = new double[this.target.getNumberOfStates()];
            for (int i = 0; i < this.target.getNumberOfStates(); ++i) {
                dArray[i] = this.target.getBelief(i);
            }
            double[] dArray2 = new double[this.target.getNumberOfStates()];
            this.domain.initialize();
            for (int i = 0; i < this.target.getNumberOfStates(); ++i) {
                dArray2[i] = this.target.getBelief(i);
            }
            double[] dArray3 = new double[this.target.getNumberOfStates()];
            this.enterEvidence(vector2);
            for (n = 0; n < vector2.size(); ++n) {
                object = vector2.get(n);
                ((HuginAnalysisDialog.EvidenceListItem)object).retractEvidence();
                this.domain.resetInferenceEngine();
                this.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
                for (int i = 0; i < this.target.getNumberOfStates(); ++i) {
                    dArray3[i] = this.target.getBelief(i);
                }
                double d4 = this.costOfOmission(dArray, dArray3);
                if (d < d4) {
                    vector.add((HuginAnalysisDialog.EvidenceListItem)object);
                    this.findingsPanel.add(new JLabel(HuginGUIConstants.get("f_is_evidence_on") + " " + HuginGUIUtils.getNodeTitle(((HuginAnalysisDialog.ListItem)object).getNode())));
                    this.findingsPanel.add(new JLabel(HuginGUIConstants.get("Cost_of_omission") + " : c(P(H|e); P(H|e\\f)) = " + HuginGUIUtils.printDouble(d4, 4)));
                    this.findingsPanel.add(new JLabel(" * * * * * "));
                    for (int i = 0; i < this.target.getNumberOfStates(); ++i) {
                        if (!this.allStates.isSelected() && (!this.oneState.isSelected() || n2 != i)) continue;
                        String[] stringArray = new String[3];
                        double[] dArray4 = new double[]{dArray2[i], dArray3[i], dArray[i]};
                        stringArray[0] = "P(h)";
                        stringArray[1] = "P(h|e\\f)";
                        stringArray[2] = "P(h|e)";
                        String string = HuginGUIUtils.getNodeStateLabel(this.target, i);
                        this.findingsPanel.add(new JLabel("h = " + string));
                        this.findingsPanel.add(new DistributionPanel(stringArray, dArray4));
                        if (this.isSufficient(dArray[i], dArray3[i], d2)) {
                            this.findingsPanel.add(new JLabel(HuginGUIConstants.get("f_is_redundant_etc")));
                        }
                        if (this.isImportant(dArray[i], dArray3[i], d3)) {
                            this.findingsPanel.add(new JLabel(HuginGUIConstants.get("f_is_important_for_h")));
                        }
                        double d5 = this.d(dArray[i], dArray3[i]);
                        this.findingsPanel.add(new JLabel(HuginGUIConstants.get("Distance") + " : d(P(h|e); P(h|e\\f)) = " + HuginGUIUtils.printDouble(d5, 4)));
                        if (!this.allStates.isSelected() || i >= this.target.getNumberOfStates() - 1) continue;
                        this.findingsPanel.add(new JLabel(" * * * * * "));
                    }
                    this.findingsPanel.add(new JLabel(" * * * * * * * * * * * * * * * * * * * * * * * * * "));
                    this.findingsPanel.revalidate();
                    this.findingsPanel.repaint();
                }
                ((HuginAnalysisDialog.EvidenceListItem)object).enterEvidence();
            }
            this.domain.initialize();
            this.enterEvidence(vector);
            this.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
            for (n = 0; n < this.target.getNumberOfStates(); ++n) {
                dArray3[n] = this.target.getBelief(n);
            }
            for (n = 0; n < this.target.getNumberOfStates(); ++n) {
                if (!this.allStates.isSelected() && (!this.oneState.isSelected() || n != n2)) continue;
                object = HuginGUIUtils.getNodeStateLabel(this.target, n);
                if (this.isSufficient(dArray[n], dArray3[n], d2)) {
                    this.findingsPanel.add(new JLabel(HuginGUIConstants.get("SE_The_set_of_findings_considered_above_is_sufficient_for_ARGV0", new String[]{object})));
                    continue;
                }
                this.findingsPanel.add(new JLabel(HuginGUIConstants.get("SE_The_set_of_findings_considered_above_is_insufficient_for_ARGV0", new String[]{object})));
            }
            this.findingsPanel.revalidate();
            this.findingsPanel.repaint();
            this.domain.initialize();
            this.enterEvidence(vector2);
            this.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
        }
    }

    private Vector<HuginAnalysisDialog.ListItem> getInfoVars() {
        Vector<HuginAnalysisDialog.ListItem> vector = new Vector<HuginAnalysisDialog.ListItem>();
        if (this.checks[this.checks.length - 1].isSelected()) {
            vector.addAll(this.customGroupData);
        }
        for (int i = 0; i < this.checks.length - 1; ++i) {
            if (!this.checks[i].isSelected()) continue;
            for (Node node : this.groups[i].getNodes()) {
                HuginAnalysisDialog.ListItem listItem;
                if (node == this.target || vector.contains(listItem = new HuginAnalysisDialog.ListItem(this, node))) continue;
                vector.add(listItem);
            }
        }
        return vector;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HuginWorker
    extends Thread {
        ProgressDialog dialog;
        boolean stop = false;
        Vector<HuginAnalysisDialog.EvidenceListItem> evidence;
        Vector<int[]> subsets;

        public HuginWorker(Vector<int[]> vector, Vector<HuginAnalysisDialog.EvidenceListItem> vector2) throws Exception {
            this.evidence = vector2;
            this.subsets = vector;
        }

        public void setDialog(ProgressDialog progressDialog) {
            this.dialog = progressDialog;
        }

        public void cancel() {
            this.stop = true;
            this.dialog.writeMessage(HuginGUIConstants.get("Please_wait_for_current_propagation_to_complete"));
        }

        public int getSize() {
            return this.subsets.size();
        }

        @Override
        public void run() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ProgressDialog
    extends JDialog {
        JProgressBar progress;
        JTextArea messages;
        JButton cancel;
        JButton ok;
        HuginWorker worker;
        boolean stop;

        public ProgressDialog(Vector<int[]> vector, Vector<HuginAnalysisDialog.EvidenceListItem> vector2) throws Exception {
            super(SEDialog.this, HuginGUIConstants.get("Progress") + " ... ", true);
            this.stop = false;
            this.setContentPane(this.getContent());
            this.progress.setMaximum(vector.size());
            this.worker = new HuginWorker(vector, vector2);
            this.worker.setDialog(this);
            this.worker.start();
        }

        public ProgressDialog(HuginWorker huginWorker) throws Exception {
            super(SEDialog.this, HuginGUIConstants.get("Progress") + " ... ", true);
            this.stop = false;
            this.setContentPane(this.getContent());
            this.progress.setMaximum(huginWorker.getSize());
            this.worker = huginWorker;
            this.worker.start();
        }

        public void writeMessage(String string) {
            this.messages.setText(string);
        }

        public void setProgress(int n) {
            this.progress.setValue(n);
        }

        public void enableOK() {
            this.ok.setEnabled(true);
            this.cancel.setEnabled(false);
        }

        private JPanel getContent() {
            JPanel jPanel = new JPanel(new BorderLayout(10, 10));
            this.messages = new JTextArea(4, 40);
            this.messages.setLineWrap(true);
            this.messages.setWrapStyleWord(true);
            this.messages.setEnabled(false);
            this.messages.setEditable(false);
            this.messages.setBackground(jPanel.getBackground());
            this.messages.setDisabledTextColor(Color.black);
            jPanel.add((Component)this.messages, "North");
            this.progress = new JProgressBar();
            this.progress.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                }
            });
            jPanel.add(this.progress);
            this.ok = new JButton(HuginGUIConstants.get("OK_button"));
            this.ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ProgressDialog.this.dispose();
                }
            });
            this.ok.setEnabled(false);
            this.cancel = new JButton(HuginGUIConstants.get("cancel_button"));
            this.cancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (ProgressDialog.this.worker != null) {
                        ProgressDialog.this.worker.cancel();
                    }
                    ProgressDialog.this.dispose();
                }
            });
            JPanel jPanel2 = new JPanel(new FlowLayout());
            jPanel2.add(this.ok);
            jPanel2.add(this.cancel);
            jPanel.add((Component)jPanel2, "South");
            return jPanel;
        }
    }
}

