/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.ContinuousChanceNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.Node;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginFileLoader;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIFrame;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.PastingTextField;
import COM.hugin.HGUI.TitledPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.Serializable;
import java.util.AbstractSequentialList;
import java.util.LinkedList;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SimulateCasesPane
extends JDialog {
    JButton simulate;
    JButton cancel;
    JRadioButton mar;
    JRadioButton mcar;
    JRadioButton oldDataFormat;
    JLabel numberOfCases;
    JLabel missingValues;
    JLabel numberVariables;
    NumberField numCases;
    NumberField percentMissing;
    NumberField numVariables;
    Domain domain;
    HuginGUIFrame guiFrame;

    public SimulateCasesPane(Domain domain, HuginGUIFrame huginGUIFrame) {
        super(huginGUIFrame, HuginGUIConstants.get("SIMULATECASES"), true);
        Object object;
        Object object2;
        Serializable serializable;
        ButtonGroup buttonGroup = new ButtonGroup();
        this.guiFrame = huginGUIFrame;
        this.domain = domain;
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(3, 1));
        JPanel jPanel3 = new JPanel(new GridLayout(3, 1));
        this.numberOfCases = new JLabel(HuginGUIConstants.get("SIMULATECASES_Number_of_cases"));
        this.numCases = new NumberField(10000000L);
        this.numCases.setText("10000");
        jPanel2.add(this.numberOfCases);
        jPanel3.add(this.numCases);
        this.missingValues = new JLabel(HuginGUIConstants.get("SIMULATECASES_Percent_missing"));
        this.percentMissing = new NumberField(100L);
        this.percentMissing.setText("5");
        jPanel2.add(this.missingValues);
        jPanel3.add(this.percentMissing);
        boolean bl = true;
        try {
            serializable = this.domain.getNodes();
            this.numberVariables = new JLabel(HuginGUIConstants.get("SIMULATECASES_Rule_size"));
            this.numberVariables.setEnabled(false);
            this.numVariables = new NumberField((long)(((LinkedList)serializable).size() - 1));
            this.numVariables.setEnabled(false);
            int n = ((LinkedList)serializable).size() / 10;
            this.numVariables.setText("" + n);
            jPanel2.add(this.numberVariables);
            jPanel3.add(this.numVariables);
            object2 = ((AbstractSequentialList)((Object)serializable)).iterator();
            while (object2.hasNext()) {
                object = (Node)object2.next();
                if (!(object instanceof ContinuousChanceNode)) continue;
                bl = false;
                break;
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        this.mar = new JRadioButton(HuginGUIConstants.get("SIMULATECASES_MAR"));
        this.mar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SimulateCasesPane.this.numberVariables.setEnabled(true);
                SimulateCasesPane.this.numVariables.setEnabled(true);
            }
        });
        this.mar.setEnabled(bl);
        this.mcar = new JRadioButton(HuginGUIConstants.get("SIMULATECASES_MCAR"));
        this.mcar.setSelected(true);
        this.mcar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SimulateCasesPane.this.numberVariables.setEnabled(false);
                SimulateCasesPane.this.numVariables.setEnabled(false);
            }
        });
        buttonGroup.add(this.mcar);
        buttonGroup.add(this.mar);
        serializable = new TitledPanel(HuginGUIConstants.get("SIMULATECASES_Rule_size"));
        ((Container)serializable).setLayout(new GridLayout(2, 1));
        ((Container)serializable).add(this.mar);
        ((Container)serializable).add(this.mcar);
        this.oldDataFormat = new JRadioButton(HuginGUIConstants.get("SIMULATECASES_Old_format"));
        this.oldDataFormat.setSelected(false);
        JRadioButton jRadioButton = new JRadioButton(HuginGUIConstants.get("SIMULATECASES_New_format"));
        jRadioButton.setSelected(true);
        object2 = new ButtonGroup();
        ((ButtonGroup)object2).add(this.oldDataFormat);
        ((ButtonGroup)object2).add(jRadioButton);
        object = new TitledPanel(HuginGUIConstants.get("SIMULATECASES_File_format"));
        ((Container)object).setLayout(new BoxLayout((Container)object, 1));
        ((Container)object).add(jRadioButton);
        ((Container)object).add(this.oldDataFormat);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(2, 1));
        jPanel4.add((Component)serializable);
        jPanel4.add((Component)object);
        jPanel.add(jPanel2);
        jPanel.add((Component)jPanel3, "East");
        jPanel.add((Component)jPanel4, "South");
        JPanel jPanel5 = new JPanel(new GridLayout(1, 2, 10, 10));
        this.simulate = new JButton(HuginGUIConstants.get("SIMULATECASES_Simulate"));
        this.simulate.addActionListener(new SimulateListener());
        this.cancel = new JButton(HuginGUIConstants.get("cancel_button"));
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SimulateCasesPane.this.dispose();
            }
        });
        jPanel5.add(this.simulate);
        jPanel5.add(this.cancel);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout(5, 5));
        container.add((Component)jPanel5, "South");
        container.add((Component)jPanel, "Center");
        if (System.getProperty("os.name").equals("Linux")) {
            this.setSize((int)this.getPreferredSize().getWidth() + 10, (int)this.getPreferredSize().getHeight() + 30);
        }
        this.getRootPane().setDefaultButton(this.simulate);
        this.setResizable(false);
    }

    private class SimulateListener
    implements ActionListener {
        private SimulateListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HuginFileLoader huginFileLoader = new HuginFileLoader(1, Hugin.mainFrame.getMostRecentDataFile(), 3);
            int n = huginFileLoader.showSaveDialog(new JFrame());
            if (n == 0) {
                File file = huginFileLoader.getSelectedFile();
                int n2 = file.getName().indexOf(".");
                if (n2 < 0 || n2 > 10000) {
                    file = new File(file.getParent(), file.getName() + ".dat");
                }
                if (SimulateCasesPane.this.mar.isSelected()) {
                    HuginGUIUtils.simulateMAR(SimulateCasesPane.this.domain, file, (int)SimulateCasesPane.this.numCases.getNumber(), (int)SimulateCasesPane.this.percentMissing.getNumber(), (int)SimulateCasesPane.this.numVariables.getNumber(), SimulateCasesPane.this.oldDataFormat.isSelected());
                } else {
                    HuginGUIUtils.simulateMCAR(SimulateCasesPane.this.domain, file, (int)SimulateCasesPane.this.numCases.getNumber(), (int)SimulateCasesPane.this.percentMissing.getNumber(), SimulateCasesPane.this.oldDataFormat.isSelected());
                }
                Hugin.mainFrame.setMostRecentDataFile(file);
                SimulateCasesPane.this.dispose();
            }
        }
    }

    private class NumberField
    extends PastingTextField {
        long maxValue;
        long oldValue;

        public NumberField(long l) {
            super(10);
            this.maxValue = l;
            this.setHorizontalAlignment(4);
            this.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent keyEvent) {
                    try {
                        if (NumberField.this.getText().length() == 0) {
                            SimulateCasesPane.this.simulate.setEnabled(false);
                            return;
                        }
                        SimulateCasesPane.this.simulate.setEnabled(true);
                        long l = Long.parseLong(NumberField.this.getText());
                        if (l > NumberField.this.maxValue) {
                            NumberField.this.setText("" + NumberField.this.oldValue);
                        } else {
                            NumberField.this.oldValue = l;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        NumberField.this.setText("" + NumberField.this.oldValue);
                    }
                }
            });
        }

        public long getNumber() {
            return Long.parseLong(this.getText());
        }
    }
}

