/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.NetworkPanel;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.NodeTable;
import COM.hugin.HGUI.NodeTableFrame;
import COM.hugin.HGUI.TableHolder;
import COM.hugin.HGUI.TableWrapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabbedTablePanel
extends JPanel
implements TableHolder {
    private NodeTableFrame selected = null;
    private LinkedList<NodeTableFrame> tables;
    private LinkedList<NodeTableFrame> visibleTables;
    private JTabbedPane tablePane;
    private JPanel menuPanel = null;
    private NodeTableFrame.TableUpdateListener updater;
    private NoFocusButton closeButton;
    private LinkedList<TablePanelListener> tablePanelListeners;

    public TabbedTablePanel() {
        this.setLayout(new BorderLayout());
        this.tablePane = new JTabbedPane();
        this.tablePane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                TabbedTablePanel.this.applyChange();
            }
        });
        this.add(this.tablePane);
        this.tables = new LinkedList();
        this.visibleTables = new LinkedList();
        this.updater = new NodeTableFrame.TableUpdateListener(){

            public void tableUpdated(NodeTableFrame nodeTableFrame) {
                int n = TabbedTablePanel.this.tablePane.indexOfComponent(nodeTableFrame.getTable());
                if (n >= 0) {
                    TabbedTablePanel.this.tablePane.setTitleAt(n, nodeTableFrame.getTitle());
                }
            }
        };
        this.closeButton = new NoFocusButton(UIManager.getIcon("InternalFrame.closeIcon"));
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Hugin.mainFrame.preferences.node_table_connection_mode == 0) {
                    Node node = TabbedTablePanel.this.getSelectedTable().getNode();
                    NetworkPanel networkPanel = node.panel;
                    networkPanel.deselectNode(node);
                    networkPanel.updateButtonAndMenuStates();
                } else {
                    TabbedTablePanel.this.hideTable(TabbedTablePanel.this.getSelectedTable());
                }
            }
        });
        this.tablePanelListeners = new LinkedList();
    }

    @Override
    public NodeTableFrame getSelectedTable() {
        return this.selected;
    }

    @Override
    public void addTable(NodeTableFrame nodeTableFrame) {
        this.addTable(true, nodeTableFrame);
    }

    @Override
    public void addTable(boolean bl, NodeTableFrame nodeTableFrame) {
        if (this.tables.contains(nodeTableFrame)) {
            if (bl && !this.visibleTables.contains(nodeTableFrame)) {
                this.showTable(nodeTableFrame);
            }
            return;
        }
        this.tables.add(nodeTableFrame);
        nodeTableFrame.addTableUpdateListener(this.updater);
        if (bl) {
            this.showTable(nodeTableFrame);
        }
    }

    @Override
    public void showTable(NodeTableFrame nodeTableFrame) {
        this.showTable(nodeTableFrame, false);
    }

    @Override
    public void showTable(NodeTableFrame nodeTableFrame, boolean bl) {
        try {
            Component component = this.tablePane.getSelectedComponent();
            if (bl && component != null && component.equals(nodeTableFrame.getTable())) {
                this.hideTable(nodeTableFrame);
                return;
            }
            if (!this.visibleTables.contains(nodeTableFrame)) {
                TableScroller tableScroller = new TableScroller(nodeTableFrame.getTable());
                this.visibleTables.add(nodeTableFrame);
                this.tablePane.add((Component)tableScroller, nodeTableFrame.getTitle());
            }
            this.tablePane.setSelectedComponent(nodeTableFrame.getTable());
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    @Override
    public void hideTable(NodeTableFrame nodeTableFrame) {
        if (this.visibleTables.contains(nodeTableFrame)) {
            this.tablePane.remove(nodeTableFrame.getTable());
            this.visibleTables.remove(nodeTableFrame);
            this.applyChange();
        }
    }

    @Override
    public void clear() {
        this.tablePane.removeAll();
        this.visibleTables.clear();
    }

    @Override
    public void disposeTable(NodeTableFrame nodeTableFrame) {
        this.hideTable(nodeTableFrame);
        this.remove(nodeTableFrame);
        nodeTableFrame.dispose();
        this.tables.remove(nodeTableFrame);
    }

    @Override
    public void updateTable(NodeTableFrame nodeTableFrame, NodeTableFrame nodeTableFrame2) {
    }

    @Override
    public void updateHiddenTable(NodeTableFrame nodeTableFrame, NodeTableFrame nodeTableFrame2) {
    }

    @Override
    public LinkedList<NodeTableFrame> getVisibleTables() {
        return new LinkedList<NodeTableFrame>(this.visibleTables);
    }

    @Override
    public LinkedList<NodeTableFrame> getHiddenTables() {
        return new LinkedList<NodeTableFrame>(this.tables);
    }

    @Override
    public void arrangeTables() {
    }

    @Override
    public void checkScrolling() {
    }

    @Override
    public void setMaxTableWidth(int n, boolean bl) {
    }

    private NodeTableFrame getFrameFor(NodeTable nodeTable) {
        for (NodeTableFrame nodeTableFrame : this.visibleTables) {
            if (nodeTable != nodeTableFrame.getTable()) continue;
            return nodeTableFrame;
        }
        return null;
    }

    @Override
    public void update(LinkedList<NodeTableFrame> linkedList, LinkedList<NodeTableFrame> linkedList2) {
        while (this.visibleTables.size() > 0) {
            this.hideTable(this.visibleTables.get(0));
        }
        for (NodeTableFrame nodeTableFrame : linkedList) {
            this.showTable(nodeTableFrame);
        }
        for (NodeTableFrame nodeTableFrame : linkedList2) {
            this.addTable(false, nodeTableFrame);
        }
    }

    @Override
    public boolean isTableVisible(NodeTableFrame nodeTableFrame) {
        return this.visibleTables.contains(nodeTableFrame);
    }

    public void addTablePanelListener(TablePanelListener tablePanelListener) {
        if (tablePanelListener != null && !this.tablePanelListeners.contains(tablePanelListener)) {
            this.tablePanelListeners.add(tablePanelListener);
        }
    }

    public void removeTablePanelListener(TablePanelListener tablePanelListener) {
        this.tablePanelListeners.remove(tablePanelListener);
    }

    public void fireTablePanelChanged() {
        for (TablePanelListener tablePanelListener : this.tablePanelListeners) {
            tablePanelListener.tablePanelChanged();
        }
    }

    private void applyChange() {
        try {
            this.selected = null;
            if (this.tablePane.getSelectedComponent() != null) {
                this.selected = this.getFrameFor(((TableScroller)this.tablePane.getSelectedComponent()).getTable());
            }
            if (this.menuPanel != null) {
                this.remove(this.menuPanel);
            }
            if (this.selected == null) {
                return;
            }
            JMenuBar jMenuBar = this.selected.getMenu();
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add(jMenuBar);
            jPanel.add((Component)this.closeButton, "East");
            this.add((Component)jPanel, "North");
            this.menuPanel = jPanel;
            this.revalidate();
            this.repaint();
            this.fireTablePanelChanged();
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    private class TableScroller
    extends JPanel {
        private NodeTable table;

        public TableScroller(NodeTable nodeTable) {
            this.setLayout(new GridLayout(1, 1));
            this.table = nodeTable;
            this.add(new TableWrapper(this.table, this.table, this.table.getGUINode().getVisualCPT()));
        }

        public NodeTable getTable() {
            return this.table;
        }

        public boolean equals(Object object) {
            return object instanceof TableScroller && ((TableScroller)object).getTable().equals(this.table) || object.equals(this.table);
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, n2, n3, n4);
        }
    }

    public static interface TablePanelListener {
        public void tablePanelChanged();
    }

    private class NoFocusButton
    extends JButton {
        public NoFocusButton(Icon icon) {
            super(icon);
            this.setFocusPainted(false);
            this.setMargin(new Insets(0, 0, 0, 0));
        }

        public boolean isFocusable() {
            return false;
        }

        public void requestFocus() {
        }

        public boolean isOpaque() {
            return true;
        }
    }
}

