/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.NodeTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class TablePrecisionDialog
extends JDialog {
    private NodeTable table;
    private JButton cancel;
    private JButton apply;
    private JButton applyToAll;
    private JButton ok;
    private JSpinner precision;
    private JCheckBox unlimited;
    private JCheckBox forceDecimals;

    public TablePrecisionDialog(NodeTable nodeTable) {
        super(Hugin.mainFrame, HuginGUIConstants.get("TABLE_PRECISION"), true);
        this.table = nodeTable;
        this.setContentPane(this.createContent());
    }

    private JPanel createContent() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 10));
        jPanel2.add((Component)new JLabel(HuginGUIConstants.get("TABLE_PRECISION_Label")), "North");
        JPanel jPanel3 = new JPanel(new GridLayout(3, 1));
        int n = this.table.getPrecision();
        boolean bl = n < 0;
        boolean bl2 = this.table.getForceDecimals();
        this.precision = new JSpinner(new SpinnerNumberModel(bl ? Integer.parseInt("6") : this.table.getPrecision(), 0, 30, 1));
        this.precision.setEnabled(!bl);
        this.unlimited = new JCheckBox(HuginGUIConstants.get("TABLE_PRECISION_Unlimited"));
        this.unlimited.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TablePrecisionDialog.this.precision.setEnabled(!TablePrecisionDialog.this.unlimited.isSelected());
            }
        });
        this.unlimited.setSelected(bl);
        this.forceDecimals = new JCheckBox(HuginGUIConstants.get("TABLE_PRECISION_Force_decimals"));
        this.forceDecimals.setSelected(bl2);
        jPanel3.add(this.precision);
        jPanel3.add(this.unlimited);
        jPanel3.add(this.forceDecimals);
        jPanel2.add((Component)jPanel3, "East");
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel4 = new JPanel(new FlowLayout());
        this.cancel = new JButton(HuginGUIConstants.get("cancel_button"));
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TablePrecisionDialog.this.dispose();
            }
        });
        this.apply = new JButton(HuginGUIConstants.get("apply_button"));
        this.apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TablePrecisionDialog.this.apply();
            }
        });
        this.applyToAll = new JButton(HuginGUIConstants.get("applyToAll_button"));
        this.applyToAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TablePrecisionDialog.this.applyToAll();
            }
        });
        this.ok = new JButton(HuginGUIConstants.get("OK_button"));
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TablePrecisionDialog.this.apply();
                TablePrecisionDialog.this.dispose();
            }
        });
        jPanel4.add(this.cancel);
        jPanel4.add(this.apply);
        jPanel4.add(this.applyToAll);
        jPanel4.add(this.ok);
        jPanel.add((Component)jPanel4, "South");
        return jPanel;
    }

    private void apply() {
        try {
            this.table.setForceDecimals(this.forceDecimals.isSelected());
            if (this.unlimited.isSelected()) {
                this.table.setPrecision(-1);
            } else {
                this.table.setPrecision((Integer)this.precision.getValue());
            }
        }
        catch (Exception exception) {
            new HuginGUIError(HuginGUIConstants.get("str_unable_to_set_precision_") + exception.getMessage());
        }
    }

    private void applyToAll() {
        try {
            this.table.setForceDecimalsForAll(this.forceDecimals.isSelected());
            if (this.unlimited.isSelected()) {
                this.table.setPrecisionForAll(-1);
            } else {
                this.table.setPrecisionForAll((Integer)this.precision.getValue());
            }
        }
        catch (Exception exception) {
            new HuginGUIError(HuginGUIConstants.get("str_unable_to_set_precision_") + exception.getMessage());
        }
    }
}

