/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.DiscreteDecisionNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.Node;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HGUI.BeliefBarPanel;
import COM.hugin.HGUI.HuginAnalysisDialog;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.VOIDialog;
import COM.hugin.HGUI.VOIResultPanel;
import COM.hugin.HGUI.VOIScore;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Collections;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VOIDecisionDialog
extends VOIDialog {
    Domain domain = null;
    DiscreteDecisionNode target;

    public VOIDecisionDialog(HuginProjectFrame huginProjectFrame, DiscreteDecisionNode discreteDecisionNode) {
        super(huginProjectFrame, HuginGUIConstants.get("VOI"), true);
        this.helpPage = HuginGUIConstants.get("VOI_help_page");
        this.target = discreteDecisionNode;
        this.setResizable(true);
        try {
            this.domain = discreteDecisionNode.getHomeDomain();
            this.setContentPane(this.createContent());
            huginProjectFrame.getBeliefBarPanel().backupPolicies();
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
            this.dispose();
        }
        this.setDefaultCloseOperation(2);
        final HuginProjectFrame huginProjectFrame2 = huginProjectFrame;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                for (WindowListener windowListener : VOIDecisionDialog.this.getWindowListeners()) {
                    VOIDecisionDialog.this.removeWindowListener(windowListener);
                }
                try {
                    VOIDecisionDialog.this.beliefPanel.restorePolicies();
                    VOIDecisionDialog.this.beliefPanel.clearPolicyBackup();
                    huginProjectFrame2.getBeliefBarPanel().propagateIfNecessary();
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
        });
        this.groupDefiner = new HuginAnalysisDialog.GroupDefiner(this, this, huginProjectFrame.getNetworkPanel(), this.target);
        this.groupDefiner.pack();
    }

    @Override
    protected JPanel createContent() throws ExceptionHugin {
        return this.createContent(HuginGUIConstants.get("VOI_Analysis"), HuginGUIConstants.get("VOI_Info_Vars"));
    }

    private double getVOI(DiscreteDecisionNode discreteDecisionNode, DiscreteChanceNode discreteChanceNode) throws ExceptionHugin {
        return this.getEUO(discreteDecisionNode, discreteChanceNode) - this.getMaxEU(discreteDecisionNode);
    }

    private double getEUO(DiscreteDecisionNode discreteDecisionNode, DiscreteChanceNode discreteChanceNode) throws ExceptionHugin {
        int n;
        int n2 = discreteDecisionNode.getNumberOfStates();
        int n3 = discreteChanceNode.getNumberOfStates();
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        double d = 0.0;
        for (n = 0; n < n3; ++n) {
            dArray[n] = discreteChanceNode.getBelief(n);
            dArray2[n] = discreteChanceNode.getEnteredFinding(n);
        }
        HuginGUIUtils.configureDomain(this.domain);
        for (n = 0; n < n3; ++n) {
            if (!(dArray[n] > 0.0)) continue;
            discreteChanceNode.selectState(n);
            try {
                this.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
                this.projectFrame.getBeliefBarPanel().updatePolicies();
            }
            catch (ExceptionHugin exceptionHugin) {
                exceptionHugin.printStackTrace();
            }
            d += dArray[n] * this.getMaxEU(discreteDecisionNode);
            discreteChanceNode.retractFindings();
            this.domain.resetInferenceEngine();
        }
        for (n = 0; n < n3; ++n) {
            discreteChanceNode.enterFinding(n, dArray2[n]);
        }
        this.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
        this.projectFrame.getBeliefBarPanel().updatePolicies();
        return d;
    }

    private double getMaxEU(DiscreteDecisionNode discreteDecisionNode) throws ExceptionHugin {
        double d = 0.0;
        boolean bl = false;
        for (int i = 0; i < discreteDecisionNode.getNumberOfStates(); ++i) {
            if (!(discreteDecisionNode.getExpectedUtility(i) > d) && bl || !(discreteDecisionNode.getBelief(i) > 0.0)) continue;
            bl = true;
            d = discreteDecisionNode.getExpectedUtility(i);
        }
        return d;
    }

    private double getMaxEU(double[] dArray) {
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            if (!(dArray[i] > d)) continue;
            d = dArray[i];
        }
        return d;
    }

    private double[] getEU(DiscreteDecisionNode discreteDecisionNode) throws ExceptionHugin {
        int n = discreteDecisionNode.getNumberOfStates();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = discreteDecisionNode.getExpectedUtility(i);
        }
        return dArray;
    }

    @Override
    protected JPanel createAnalysisTab() {
        Object object;
        Object object2;
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1));
        JTextArea jTextArea = null;
        try {
            object = object2 = HuginGUIUtils.getNodeTitle(this.target);
            jTextArea = new JTextArea((String)object + "\n");
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setEditable(false);
            jTextArea.setBackground(jPanel2.getBackground());
            double d = this.getMaxEU(this.target);
            String string = "MEU(" + (String)object2 + ") = " + HuginGUIUtils.printDouble(d, this.projectFrame.guiFrame.preferences.precision);
            this.targetEntropy = new JTextArea(string);
            this.targetEntropy.setLineWrap(true);
            this.targetEntropy.setWrapStyleWord(true);
            this.targetEntropy.setEditable(false);
            this.targetEntropy.setBackground(jPanel2.getBackground());
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage());
        }
        jPanel2.add(jTextArea);
        jPanel2.add(this.targetEntropy);
        object2 = new JPanel(new BorderLayout());
        ((Container)object2).add((Component)jPanel2, "North");
        this.voiListData = new Vector();
        this.voiResult = new VOIResultPanel(this.target, this.projectFrame);
        this.voiResult.setBorder(BorderFactory.createLoweredBevelBorder());
        object = new JScrollPane(this.voiResult);
        ((JComponent)object).setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("VOI")));
        JScrollPane jScrollPane = new JScrollPane((Component)object2);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("VOI_DecisionVariable")));
        jScrollPane.setPreferredSize(new Dimension(180, 180));
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, (Component)object);
        jPanel.add(jSplitPane);
        return jPanel;
    }

    @Override
    protected JButton getPerformButton() {
        JButton jButton = new JButton(HuginGUIConstants.get("ANALYSIS_Calculate"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    VOIDecisionDialog.this.voiListData.clear();
                    BeliefBarPanel beliefBarPanel = VOIDecisionDialog.this.projectFrame.getBeliefBarPanel();
                    double d = 0.0;
                    boolean bl = true;
                    for (HuginAnalysisDialog.ListItem listItem : VOIDecisionDialog.this.getInfoVars()) {
                        DiscreteChanceNode discreteChanceNode = (DiscreteChanceNode)listItem.getNode();
                        try {
                            double d2 = VOIDecisionDialog.this.getVOI(VOIDecisionDialog.this.target, discreteChanceNode);
                            if (Math.abs(d2) < Math.pow(10.0, -6.0) || d2 < 0.0) {
                                d2 = 0.0;
                            }
                            if (d2 > d || bl) {
                                d = d2;
                            }
                            bl = false;
                            VOIScore vOIScore = new VOIScore(discreteChanceNode, VOIDecisionDialog.this.target, d2);
                            VOIDecisionDialog.this.voiListData.add(vOIScore);
                        }
                        catch (Exception exception) {}
                    }
                    Collections.sort(VOIDecisionDialog.this.voiListData);
                    VOIDecisionDialog.this.voiResult.setResult(VOIDecisionDialog.this.voiListData, d, Math.abs(VOIDecisionDialog.this.getMaxEU(VOIDecisionDialog.this.target)));
                    VOIDecisionDialog.this.voiResult.revalidate();
                    VOIDecisionDialog.this.voiResult.repaint();
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
        });
        return jButton;
    }

    private Vector<HuginAnalysisDialog.ListItem> getInfoVars() {
        Vector<HuginAnalysisDialog.ListItem> vector = new Vector<HuginAnalysisDialog.ListItem>();
        if (this.checks[this.checks.length - 1].isSelected()) {
            vector.addAll(this.customGroupData);
        }
        for (int i = 0; i < this.checks.length - 1; ++i) {
            if (!this.checks[i].isSelected()) continue;
            for (Node node : this.groups[i].getNodes()) {
                HuginAnalysisDialog.ListItem listItem;
                boolean bl = false;
                try {
                    bl = node.evidenceIsEntered();
                }
                catch (ExceptionHugin exceptionHugin) {
                    // empty catch block
                }
                if (node == this.target || bl || !(node instanceof DiscreteChanceNode) || vector.contains(listItem = new HuginAnalysisDialog.ListItem(this, node))) continue;
                vector.add(listItem);
            }
        }
        return vector;
    }

    protected NodeList getObserved(DiscreteDecisionNode discreteDecisionNode) throws ExceptionHugin {
        NodeList nodeList = new NodeList();
        for (Node node : discreteDecisionNode.getHomeDomain().getDecisionOrder()) {
            DiscreteDecisionNode discreteDecisionNode2 = (DiscreteDecisionNode)node;
            NodeList nodeList2 = discreteDecisionNode2.getParents();
            nodeList.removeAll(nodeList2);
            nodeList.addAll(nodeList2);
            if (discreteDecisionNode2 != discreteDecisionNode) continue;
            break;
        }
        return nodeList;
    }

    protected NodeList getIllegalObservations(DiscreteDecisionNode discreteDecisionNode) throws ExceptionHugin {
        NodeList nodeList = new NodeList();
        ListIterator listIterator = discreteDecisionNode.getHomeDomain().getNodes().listIterator();
        while (listIterator.hasNext()) {
            DiscreteDecisionNode discreteDecisionNode2;
            Node node = (Node)listIterator.next();
            if (!(node instanceof DiscreteDecisionNode) || (discreteDecisionNode2 = (DiscreteDecisionNode)node).getPropagatedState() >= 0) continue;
            NodeList nodeList2 = discreteDecisionNode2.getDescendants();
            nodeList.removeAll(nodeList2);
            nodeList.addAll(nodeList2);
        }
        return nodeList;
    }

    @Override
    protected Vector<HuginAnalysisDialog.ListItem> customGroupNodes(Node node) {
        Vector<HuginAnalysisDialog.ListItem> vector = new Vector<HuginAnalysisDialog.ListItem>();
        try {
            NodeList nodeList = this.getObserved((DiscreteDecisionNode)node);
            NodeList nodeList2 = this.getIllegalObservations((DiscreteDecisionNode)node);
            BeliefBarPanel beliefBarPanel = this.projectFrame.getBeliefBarPanel();
            for (Node node2 : beliefBarPanel.getDomain().getNodes()) {
                if (!(node2 instanceof DiscreteChanceNode) || node2 == node || nodeList2.contains(node2) || nodeList.contains(node2)) continue;
                vector.add(new HuginAnalysisDialog.ListItem(this, (DiscreteChanceNode)node2));
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage());
        }
        return vector;
    }
}

