/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.Attribute;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExceptionUsage;
import COM.hugin.HAPI.NetworkModel;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HGUI.DataDependencesPanel;
import COM.hugin.HGUI.DependenceLink;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginKeyListener;
import COM.hugin.HGUI.Link;
import COM.hugin.HGUI.LinkConstraint;
import COM.hugin.HGUI.NetworkPanel;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.StructuralConstraintsPanel;
import COM.hugin.HGUI.WizardConstants;
import COM.hugin.HGUI.WizardPanel;
import COM.hugin.HGUI.ZoomingPane;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class WizardNetworkPanel
extends NetworkPanel
implements MouseListener,
MouseMotionListener {
    protected Domain domain = null;
    private StructuralConstraintsPanel constraintsWizardPanel = null;
    private DataDependencesPanel dependencesWizardPanel = null;
    private WizardPanel wizardPanel;
    protected static final int SELECT_MODE = 0;
    protected static final int ARROW_CONSTRAINT_MODE = 1;
    protected static final int NO_ARROW_CONSTRAINT_MODE = 2;
    protected static final int LINK_CONSTRAINT_MODE = 3;
    protected static final int NO_LINK_CONSTRAINT_MODE = 4;
    private int mode = 0;
    private LinkedList<LinkConstraint> constraintLinks = new LinkedList();
    private LinkedList<DependenceLink> dependenceLinks = new LinkedList();
    private double threshold = 0.0;
    private Cursor arrowCursor;
    private Cursor noArrowCursor;
    private Cursor linkCursor;
    private Cursor noLinkCursor;

    protected NetworkModel getHome() {
        return this.domain;
    }

    protected int getMode() {
        return this.mode;
    }

    public WizardNetworkPanel(StructuralConstraintsPanel structuralConstraintsPanel, Domain domain) {
        this.wizardPanel = structuralConstraintsPanel;
        this.constraintsWizardPanel = structuralConstraintsPanel;
        this.addKeyListener(new HuginKeyListener(this));
        this.init(domain);
    }

    protected void setStructuralConstraintsPanel(StructuralConstraintsPanel structuralConstraintsPanel) {
        this.constraintsWizardPanel = structuralConstraintsPanel;
        this.wizardPanel = structuralConstraintsPanel;
        this.dependencesWizardPanel = null;
        structuralConstraintsPanel.setSelectMode();
        this.setMode(0);
    }

    protected void removeLinks() {
        try {
            ListIterator listIterator = this.linkList.listIterator();
            while (listIterator.hasNext()) {
                Link link = (Link)listIterator.next();
                if (link instanceof LinkConstraint) {
                    link.setVisible(true);
                    continue;
                }
                if (!(link instanceof DependenceLink)) {
                    link.child.getAPINode().removeParent(link.parent.getAPINode());
                }
                listIterator.remove();
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        this.dependenceLinks.clear();
    }

    protected void setDataDependencesPanel(DataDependencesPanel dataDependencesPanel) {
        this.dependencesWizardPanel = dataDependencesPanel;
        this.wizardPanel = dataDependencesPanel;
        this.constraintsWizardPanel = null;
        this.setMode(0);
    }

    private void init(Domain domain) {
        this.createCursors();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setBackground(Color.white);
        this.loadNet(domain);
    }

    protected void readLinks() {
        try {
            for (COM.hugin.HAPI.Node node : this.domain.getNodes()) {
                for (COM.hugin.HAPI.Node node2 : node.getChildren()) {
                    Link link = new Link(this.getNode(node), this.getNode(node2), this.scaleFactor);
                    double d = link.parent.getAPINode().getDataIndependency(link.child.getAPINode());
                    if (d == -1.0) {
                        d = 1.0;
                    }
                    link.setStrength(d);
                    this.linkList.add(link);
                }
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
    }

    protected void createCursors() {
        super.createCursors();
        try {
            Toolkit toolkit = this.getToolkit();
            Point point = WizardConstants.TOOL_CURSORS_HOTSPOT;
            Image image = WizardConstants.ARROW_CONSTRAINT_CURSOR_IMAGE;
            this.arrowCursor = toolkit.createCustomCursor(image, point, "ARROW Cursor");
            image = WizardConstants.NO_ARROW_CONSTRAINT_CURSOR_IMAGE;
            this.noArrowCursor = toolkit.createCustomCursor(image, point, "NO-ARROW Cursor");
            image = WizardConstants.LINK_CONSTRAINT_CURSOR_IMAGE;
            this.linkCursor = toolkit.createCustomCursor(image, point, "LINK Cursor");
            image = WizardConstants.NO_LINK_CONSTRAINT_CURSOR_IMAGE;
            this.noLinkCursor = toolkit.createCustomCursor(image, point, "NO-LINK Cursor");
            image = WizardConstants.LINK_CONSTRAINT_CURSOR_IMAGE;
        }
        catch (Exception exception) {
            new HuginGUIError("WizardNetworkPanel.createCursors", HuginGUIConstants.get("str_failed_to_create_cursor"));
        }
    }

    protected void loadNet(Domain domain) {
        this.home = domain;
        this.domain = domain;
        try {
            this.readDomainAttributes();
            NodeList nodeList = domain.getNodes();
            if (((COM.hugin.HAPI.Node)nodeList.getFirst()).getPosition().getX() == 0.0) {
                this.layoutNodes();
            }
            for (COM.hugin.HAPI.Node node : nodeList) {
                Node node2 = this.createNodeFromAPINode(node);
                if (node2 != null) {
                    this.nodeList.add(node2);
                    continue;
                }
                new HuginGUIError("WizardNetworkPanel.loadNet", HuginGUIConstants.get("str_unkown_node_class"));
            }
            for (COM.hugin.HAPI.Node node : nodeList) {
                for (COM.hugin.HAPI.Node node3 : node.getChildren()) {
                    this.linkList.add(new Link(this.getNode(node), this.getNode(node3), this.scaleFactor));
                }
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
            this.snapToGrid = true;
            this.showGrid = false;
        }
        this.readNodeAttributes();
        this.setGraphicsSize();
    }

    protected void rereadNodePositions() throws ExceptionHugin {
        for (Node node : this.nodeList) {
            node.rereadPosition();
        }
        this.relocateLinks();
        this.repaintRectangle(this.getViewRect());
    }

    protected void readNodeAttributes() {
        super.readNodeAttributes();
        try {
            for (Node node : this.nodeList) {
                for (Attribute attribute : node.getAPINode().getAttributes()) {
                    String string;
                    if (attribute.getKey().indexOf("HR_Constraint_") != 0 || (string = attribute.getKey().substring(14)).equals(node.getName())) continue;
                    COM.hugin.HAPI.Node node2 = this.getHome().getNodeByName(string);
                    String string2 = attribute.getValue();
                    LinkConstraint linkConstraint = null;
                    Node node3 = this.getNode(string);
                    int n = 1;
                    NetworkModel.Constraint constraint = Domain.H_CONSTRAINT_FORWARD_EDGE_REQUIRED;
                    if (string2.equalsIgnoreCase("arrow")) {
                        n = 1;
                        constraint = Domain.H_CONSTRAINT_FORWARD_EDGE_REQUIRED;
                    } else if (string2.equalsIgnoreCase("noarrow")) {
                        n = 2;
                        constraint = Domain.H_CONSTRAINT_FORWARD_EDGE_FORBIDDEN;
                    } else if (string2.equalsIgnoreCase("link")) {
                        n = 3;
                        constraint = Domain.H_CONSTRAINT_EDGE_REQUIRED;
                    } else if (string2.equalsIgnoreCase("nolink")) {
                        n = 4;
                        constraint = Domain.H_CONSTRAINT_EDGE_FORBIDDEN;
                    }
                    if (this.linkList.contains(linkConstraint = new LinkConstraint(n, node, node3, this.scaleFactor))) continue;
                    node.getAPINode().setEdgeConstraint(node2, constraint);
                    this.linkList.add(linkConstraint);
                    this.constraintLinks.add(linkConstraint);
                }
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    protected void setMode(int n) {
        this.setMode(n, null);
    }

    private void setMode(int n, Point point) {
        this.mode = n;
        switch (n) {
            case 0: {
                if (point != null) {
                    Node node = this.whichNode(point);
                    if (node != null) {
                        this.setCursor(this.selectCursor);
                        break;
                    }
                    Link link = this.whichLink(point);
                    if (link != null) {
                        this.setCursor(link.isSelectable() ? this.selectCursor : this.defaultCursor);
                        break;
                    }
                    this.setCursor(this.defaultCursor);
                    break;
                }
                this.setCursor(this.defaultCursor);
                break;
            }
            case 1: {
                this.setCursor(this.arrowCursor);
                break;
            }
            case 2: {
                this.setCursor(this.noArrowCursor);
                break;
            }
            case 3: {
                this.setCursor(this.linkCursor);
                break;
            }
            case 4: {
                this.setCursor(this.noLinkCursor);
                break;
            }
            default: {
                new HuginGUIError("NetworkPanel.setMode", HuginGUIConstants.get("str_unknown_mode"));
            }
        }
    }

    protected Rectangle getViewRect() {
        if (this.constraintsWizardPanel != null) {
            return this.constraintsWizardPanel.getNetworkScroller().getViewport().getViewRect();
        }
        return this.dependencesWizardPanel.getNetworkScroller().getViewport().getViewRect();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!SwingUtilities.isRightMouseButton(mouseEvent) || mouseEvent.isAltDown()) {
            this.leftMousePressed(mouseEvent);
        } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.rightMousePressed(mouseEvent);
        }
    }

    private void leftMousePressed(MouseEvent mouseEvent) {
        Rectangle rectangle = null;
        if (this.getMode() == 0) {
            rectangle = this.controlSelections(mouseEvent);
        } else {
            this.initLink(mouseEvent);
        }
        if (rectangle != null) {
            this.repaintRectangle(rectangle);
        }
    }

    private void rightMousePressed(MouseEvent mouseEvent) {
        Node node = this.whichNode(mouseEvent.getPoint());
        if (node != null) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            String string = "links from " + node.getName() + " to selected set of nodes";
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.setAction(new ConstraintAction(string, new ImageIcon(ClassLoader.getSystemResource("icons/arrow_constraint.gif")), 1, node, true));
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem(string);
            jMenuItem.setAction(new ConstraintAction(string, new ImageIcon(ClassLoader.getSystemResource("icons/no_arrow_constraint.gif")), 2, node, true));
            jPopupMenu.add(jMenuItem);
            string = "links to " + node.getName() + " from select set of nodes";
            jMenuItem = new JMenuItem(string);
            jMenuItem.setAction(new ConstraintAction(string, new ImageIcon(ClassLoader.getSystemResource("icons/arrow_constraint.gif")), 1, node));
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem(string);
            jMenuItem.setAction(new ConstraintAction(string, new ImageIcon(ClassLoader.getSystemResource("icons/no_arrow_constraint.gif")), 2, node));
            jPopupMenu.add(jMenuItem);
            string = "links between " + node.getName() + " and selected set of nodes";
            jMenuItem = new JMenuItem(string);
            jMenuItem.setAction(new ConstraintAction(string, new ImageIcon(ClassLoader.getSystemResource("icons/link_constraint.gif")), 3, node));
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem(string);
            jMenuItem.setAction(new ConstraintAction(string, new ImageIcon(ClassLoader.getSystemResource("icons/no_link_constraint.gif")), 4, node));
            jPopupMenu.add(jMenuItem);
            jPopupMenu.pack();
            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    protected Rectangle controlSelections(MouseEvent mouseEvent) {
        Link link;
        Node node = this.whichNode(mouseEvent.getPoint());
        Rectangle rectangle = new Rectangle(mouseEvent.getPoint());
        if (this.selectedLinks.size() == 1) {
            link = (Link)this.selectedLinks.getFirst();
            link.deselect();
            rectangle.add(link.getBoundingBox());
            this.selectedLinks.clear();
        }
        if (node != null) {
            boolean bl = node.isSelected();
            try {
                if (!bl) {
                    if (!mouseEvent.isShiftDown() && this.selectedNodes.size() > 0) {
                        rectangle.add(this.deselectNodes(null));
                    }
                    this.selectedNodes.add(node);
                    rectangle.add(node.boundingBox);
                    this.wizardPanel.writeStatus(node.name);
                } else if (mouseEvent.isShiftDown()) {
                    this.selectedNodes.remove(node);
                    rectangle.add(node.boundingBox);
                    this.wizardPanel.clearStatus();
                }
                this.setCursor(this.moveCursor);
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        } else {
            link = this.whichLink(mouseEvent.getPoint());
            if (!(this.selectedNodes.size() <= 0 || mouseEvent.isShiftDown() && link == null)) {
                rectangle.add(this.deselectNodes(null));
                this.wizardPanel.clearStatus();
            }
            if (link != null && !link.atCollapsedNode()) {
                link.select();
                this.selectedLinks.add(link);
                rectangle.add(link.getBoundingBox());
                if (this.dependencesWizardPanel != null) {
                    this.dependencesWizardPanel.writePValue(link.getStrength());
                }
            } else {
                this.wizardPanel.clearStatus();
            }
        }
        if (this.selectedLinks.size() == 0 && node == null && this.dependencesWizardPanel != null) {
            this.dependencesWizardPanel.reportModelSize();
        }
        this.mousePressedAt.setLocation(mouseEvent.getPoint());
        if (rectangle.width == 0) {
            return null;
        }
        return rectangle;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        boolean bl = false;
        if (this.getMode() == 0) {
            this.dragNodesOrRegion(mouseEvent.getPoint(), mouseEvent.isShiftDown());
            bl = true;
        } else {
            bl = this.dragLink(mouseEvent.getPoint());
        }
        if (bl) {
            this.repaintRectangle(this.computeChangedDragRectangle(), mouseEvent.getPoint());
        }
    }

    private Rectangle computeChangedDragRectangle() {
        if (this.getMode() == 0) {
            if (this.selectRegion != null) {
                return this.selectRegion.getBoundingBox().union(this.selectRegion.previous);
            }
            return this.newGhostGraphBoundingBox().union(this.prevGhostGraphBoundingBox);
        }
        return this.prevGhostLinkBoundingBox.union(this.newGhostLinkBoundingBox());
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Rectangle rectangle = null;
        rectangle = this.getMode() == 0 ? this.selectOrRelocateObjects(mouseEvent.getPoint()) : this.createConstraint(mouseEvent.getPoint());
        if (rectangle != null) {
            this.repaintRectangle(rectangle);
        }
        if (this.constraintsWizardPanel != null) {
            this.constraintsWizardPanel.getDeleteButton().setEnabled(this.selectedLinks.size() != 0);
        }
        for (LinkConstraint link : this.constraintLinks) {
            link.computePoints();
        }
        for (DependenceLink dependenceLink : this.dependenceLinks) {
            dependenceLink.computePoints();
        }
        for (Link link : this.linkList) {
            link.computePoints();
        }
    }

    private Rectangle createConstraint(Point point) {
        Cloneable cloneable;
        if (this.sourceNode == null || this.ghostLinks.size() < 1) {
            this.wizardPanel.clearStatus();
            return null;
        }
        Link link = (Link)this.ghostLinks.getFirst();
        this.ghostLinks.clear();
        Node node = this.whichNode(point);
        if (node == null || node == this.sourceNode) {
            this.wizardPanel.clearStatus();
            return link.getBoundingBox();
        }
        LinkConstraint linkConstraint = new LinkConstraint(this.getMode(), this.sourceNode, node, this.scaleFactor);
        LinkConstraint linkConstraint2 = this.getLinkConstraint(this.sourceNode, node);
        if (linkConstraint2 != null) {
            linkConstraint2.kill();
            this.linkList.remove(linkConstraint2);
        }
        try {
            cloneable = this.sourceNode.getAPINode();
            COM.hugin.HAPI.Node node2 = node.getAPINode();
            switch (this.mode) {
                case 1: {
                    ((COM.hugin.HAPI.Node)cloneable).setEdgeConstraint(node2, Domain.H_CONSTRAINT_FORWARD_EDGE_REQUIRED);
                    break;
                }
                case 2: {
                    ((COM.hugin.HAPI.Node)cloneable).setEdgeConstraint(node2, Domain.H_CONSTRAINT_FORWARD_EDGE_FORBIDDEN);
                    break;
                }
                case 3: {
                    ((COM.hugin.HAPI.Node)cloneable).setEdgeConstraint(node2, Domain.H_CONSTRAINT_EDGE_REQUIRED);
                    break;
                }
                case 4: {
                    ((COM.hugin.HAPI.Node)cloneable).setEdgeConstraint(node2, Domain.H_CONSTRAINT_EDGE_FORBIDDEN);
                }
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
            return link.getBoundingBox();
        }
        cloneable = new Rectangle(linkConstraint.getBoundingBox());
        ((Rectangle)cloneable).add(this.sourceNode.boundingBox);
        ((Rectangle)cloneable).add(node.boundingBox);
        this.wizardPanel.writeStatus(HuginGUIConstants.get("str_created_constraint_") + linkConstraint.getDescription());
        this.linkList.add(linkConstraint);
        this.constraintLinks.add(linkConstraint);
        return cloneable;
    }

    protected void createDependenceLinks() {
        Node[] nodeArray = this.nodeList.toArray(new Node[this.nodeList.size()]);
        try {
            for (int i = 0; i < nodeArray.length; ++i) {
                Node node = nodeArray[i];
                for (int j = i + 1; j < nodeArray.length; ++j) {
                    double d;
                    Node node2 = nodeArray[j];
                    if (node.equals(node2)) continue;
                    DependenceLink dependenceLink = new DependenceLink(node, node2, this.scaleFactor);
                    try {
                        d = node.getAPINode().getDataIndependency(node2.getAPINode());
                    }
                    catch (ExceptionUsage exceptionUsage) {
                        d = 1.0;
                    }
                    if (d == -1.0) {
                        d = 1.0;
                    }
                    dependenceLink.setStrength(d);
                    dependenceLink.setVisible(false);
                    this.linkList.add(dependenceLink);
                    this.dependenceLinks.add(dependenceLink);
                }
            }
            this.threshold = this.domain.getSignificanceLevel();
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    protected double getMinIndependence() {
        double d = 1.0;
        try {
            COM.hugin.HAPI.Node[] nodeArray = this.domain.getNodes().toArray(new COM.hugin.HAPI.Node[0]);
            for (int i = 0; i < nodeArray.length; ++i) {
                COM.hugin.HAPI.Node node = nodeArray[i];
                for (int j = i + 1; j < nodeArray.length; ++j) {
                    COM.hugin.HAPI.Node node2 = nodeArray[j];
                    try {
                        double d2;
                        double d3 = node.getDataIndependency(node2);
                        if (!(d2 < d) || !(d3 > 0.0)) continue;
                        d = d3;
                        continue;
                    }
                    catch (ExceptionUsage exceptionUsage) {
                        // empty catch block
                    }
                }
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
        return d;
    }

    protected double getSignificanceLevel() {
        try {
            return this.domain.getSignificanceLevel();
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
            return -1.0;
        }
    }

    protected void setThreshold(double d, boolean bl) {
        for (Link link : this.linkList) {
            boolean bl2;
            if ((!bl || link instanceof LinkConstraint || link instanceof DependenceLink) && (bl || !(link instanceof DependenceLink))) continue;
            boolean bl3 = bl2 = link.getStrength() < d;
            if (link.isVisible() == bl2) continue;
            link.setVisible(bl2);
            this.repaint(link.getBoundingBox());
        }
        this.threshold = d;
    }

    private LinkConstraint getLinkConstraint(Node node, Node node2) {
        for (Link link : this.linkList) {
            LinkConstraint linkConstraint = (LinkConstraint)link;
            if ((!linkConstraint.parent.equals(node) || !linkConstraint.child.equals(node2)) && (!linkConstraint.parent.equals(node2) || !linkConstraint.child.equals(node))) continue;
            return linkConstraint;
        }
        return null;
    }

    protected void deleteSelectedObjects() {
        if (this.selectedLinks.size() != 0) {
            this.deleteSelectedLinks();
            this.wizardPanel.writeStatus(HuginGUIConstants.get("str_deleted_constraint"));
        }
    }

    protected void showResultingLinks(boolean bl) {
        for (Link link : this.linkList) {
            if (link instanceof LinkConstraint || link instanceof DependenceLink || !(link.getStrength() < this.threshold)) continue;
            link.setVisible(bl);
        }
        this.repaint();
    }

    protected void showMarginalLinks(boolean bl) {
        try {
            for (DependenceLink dependenceLink : this.dependenceLinks) {
                if (!(dependenceLink.getStrength() < this.threshold)) continue;
                dependenceLink.setVisible(bl);
            }
            this.repaint();
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    protected void showLinkConstraints(boolean bl) {
        for (LinkConstraint linkConstraint : this.constraintLinks) {
            if (linkConstraint.getType() != 1 && linkConstraint.getType() != 3) continue;
            linkConstraint.setVisible(bl);
            linkConstraint.select();
        }
        this.repaint();
    }

    protected void showNoLinkConstraints(boolean bl) {
        for (LinkConstraint linkConstraint : this.constraintLinks) {
            if (linkConstraint.getType() != 2 && linkConstraint.getType() != 4) continue;
            linkConstraint.setVisible(bl);
        }
        this.repaint();
    }

    protected boolean containsLinkConstraints() {
        return this.containsConstraints(true);
    }

    protected boolean containsNoLinkConstraints() {
        return this.containsConstraints(false);
    }

    private boolean containsConstraints(boolean bl) {
        for (LinkConstraint linkConstraint : this.constraintLinks) {
            if ((!bl || linkConstraint.getType() != 1 && linkConstraint.getType() != 3) && (bl || linkConstraint.getType() != 2 && linkConstraint.getType() != 4)) continue;
            return true;
        }
        return false;
    }

    protected void clearConstraints() throws ExceptionHugin {
        for (LinkConstraint linkConstraint : this.constraintLinks) {
            this.linkList.remove(linkConstraint);
            linkConstraint.parent.getAPINode().setAttribute("HR_Constraint_" + linkConstraint.child.getName(), null);
            linkConstraint.kill();
        }
        this.constraintLinks.clear();
    }

    protected void clearDependences() throws ExceptionHugin {
        for (DependenceLink dependenceLink : this.dependenceLinks) {
            this.linkList.remove(dependenceLink);
        }
        this.dependenceLinks.clear();
    }

    protected void receiveKeyEvent(KeyEvent keyEvent) {
        double d;
        int n = keyEvent.getKeyCode();
        if ((n == 40 || n == 98) && keyEvent.isControlDown()) {
            d = this.zoom(0.9);
            if (d > 0.0) {
                this.wizardPanel.writeStatus(HuginGUIConstants.get("str_scale_factor_set_to_") + (int)(100.0 * d) + "%");
            } else {
                this.wizardPanel.writeStatus("Unable to scale network (1 <= scale factor <= 10000)");
            }
        }
        if ((n == 38 || n == 104) && keyEvent.isControlDown()) {
            d = this.zoom(1.1111111111111112);
            if (d > 0.0) {
                this.wizardPanel.writeStatus(HuginGUIConstants.get("str_scale_factor_set_to_") + (int)(100.0 * d) + "%");
            } else {
                this.wizardPanel.writeStatus("Unable to scale network (1 <= scale factor <= 10000)");
            }
        }
        switch (n) {
            case 65: {
                if (!keyEvent.isControlDown()) break;
                this.selectAllNodes();
                this.wizardPanel.writeStatus(HuginGUIConstants.get("str_all_") + this.selectedNodes.size() + HuginGUIConstants.get("str__nodes_selected"));
                break;
            }
            case 127: {
                this.deleteSelectedObjects();
                break;
            }
            case 36: {
                double d2 = 0.0;
                if (keyEvent.isControlDown()) {
                    d2 = 1.0;
                    this.setScaleFactor(1.0);
                }
                if (keyEvent.isShiftDown()) {
                    d2 = ZoomingPane.computeFitFactor(this);
                    this.setScaleFactor(d2);
                }
                if (!(d2 > 0.0)) break;
                this.wizardPanel.writeStatus(HuginGUIConstants.get("str_scale_factor_set_to_") + (int)Math.rint(100.0 * d2) + "%");
                break;
            }
            case 46: {
                if (!keyEvent.isControlDown()) break;
                this.showGrid(!this.showGrid());
                String string = this.showGrid() ? HuginGUIConstants.get("str_on") : HuginGUIConstants.get("str_off");
                this.wizardPanel.writeStatus(HuginGUIConstants.get("str_grid_") + string);
                break;
            }
            case 44: {
                if (keyEvent.isControlDown()) {
                    this.snapToGrid(!this.snapToGrid());
                    String string = this.snapToGrid() ? HuginGUIConstants.get("str_on") : HuginGUIConstants.get("str_off");
                    this.wizardPanel.writeStatus(HuginGUIConstants.get("str_snap_to_grid_") + string);
                }
                if (keyEvent.isShiftDown() && this.snapSelectedNodesToGrid()) {
                    this.wizardPanel.writeStatus(HuginGUIConstants.get("str_selected_nodes_snapped_to_grid"));
                }
                if (!keyEvent.isAltDown() || !this.snapMonitorsToNodes()) break;
                this.wizardPanel.writeStatus(HuginGUIConstants.get("str_monitors_snapped_to_nodes"));
                break;
            }
            case 35: {
                if (!keyEvent.isShiftDown()) break;
                this.setScaleFactor((double)ZoomingPane.computeSelectedFitZoom(this) / 100.0);
                this.scrollToSelected();
                this.wizardPanel.writeStatus(HuginGUIConstants.get("str_zoomed_to_selected_nodes"));
            }
        }
    }

    protected void setScaleFactor(double d, boolean bl) {
        double d2 = d / this.scaleFactor;
        boolean bl2 = false;
        Rectangle rectangle = this.showGrid ? new Rectangle(0, 0, this.getWidth(), this.getHeight()) : this.computeBoundingBox();
        for (Cloneable cloneable : this.nodeList) {
            try {
                ((Node)cloneable).scale(d2, bl);
            }
            catch (Exception exception) {
                if (!bl2) {
                    new HuginGUIError(exception);
                }
                bl2 = true;
            }
        }
        for (Cloneable cloneable : this.linkList) {
            ((Link)cloneable).scale(d2);
        }
        this.gridWidth *= d2;
        this.gridHeight *= d2;
        this.scaleFactor = d;
        try {
            this.getHome().setAttribute("HR_Zoom_ZoomFactor", String.valueOf((int)(100.0 * this.scaleFactor)));
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        if (!this.showGrid) {
            rectangle.add(this.computeBoundingBox());
        }
        this.repaintRectangle(rectangle);
        this.containsUnsavedChanges(true);
    }

    protected void writeConstraintsToDomain() throws ExceptionHugin {
        for (Link link : this.linkList) {
            String string;
            if (!(link instanceof LinkConstraint)) continue;
            switch (((LinkConstraint)link).getType()) {
                case 1: {
                    string = HuginGUIConstants.get("str_arrow");
                    break;
                }
                case 2: {
                    string = HuginGUIConstants.get("str_noarrow");
                    break;
                }
                case 3: {
                    string = HuginGUIConstants.get("str_link");
                    break;
                }
                case 4: {
                    string = HuginGUIConstants.get("str_nolink");
                    break;
                }
                default: {
                    string = HuginGUIConstants.get("str_invalid");
                }
            }
            link.parent.getAPINode().setAttribute("HR_Constraint_" + link.child.getName(), string);
        }
        this.getHome().setAttribute("HR_Has_Constraints", "yes");
    }

    private class ConstraintAction
    extends AbstractAction {
        Node node;
        int mode;
        boolean from;

        ConstraintAction(String string, ImageIcon imageIcon, int n, Node node, boolean bl) {
            super(string, imageIcon);
            this.node = null;
            this.mode = 0;
            this.from = false;
            this.mode = n;
            this.node = node;
            this.from = bl;
        }

        ConstraintAction(String string, ImageIcon imageIcon, int n, Node node) {
            super(string, imageIcon);
            this.node = null;
            this.mode = 0;
            this.from = false;
            this.mode = n;
            this.node = node;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            Object object2;
            Rectangle rectangle = new Rectangle();
            ListIterator listIterator = WizardNetworkPanel.this.selectedNodes.listIterator();
            while (listIterator.hasNext()) {
                Node node;
                Node node2;
                if (this.from) {
                    node2 = this.node;
                    node = (Node)listIterator.next();
                } else {
                    node2 = (Node)listIterator.next();
                    node = this.node;
                }
                if (node == node2) continue;
                object2 = new LinkConstraint(this.mode, node2, node, WizardNetworkPanel.this.scaleFactor);
                object = WizardNetworkPanel.this.getLinkConstraint(node2, node);
                if (object != null) {
                    ((LinkConstraint)object).kill();
                    WizardNetworkPanel.this.linkList.remove(object);
                }
                try {
                    COM.hugin.HAPI.Node node3 = node2.getAPINode();
                    COM.hugin.HAPI.Node node4 = node.getAPINode();
                    switch (this.mode) {
                        case 1: {
                            node3.setEdgeConstraint(node4, Domain.H_CONSTRAINT_FORWARD_EDGE_REQUIRED);
                            break;
                        }
                        case 2: {
                            node3.setEdgeConstraint(node4, Domain.H_CONSTRAINT_FORWARD_EDGE_FORBIDDEN);
                            break;
                        }
                        case 3: {
                            node3.setEdgeConstraint(node4, Domain.H_CONSTRAINT_EDGE_REQUIRED);
                            break;
                        }
                        case 4: {
                            node3.setEdgeConstraint(node4, Domain.H_CONSTRAINT_EDGE_FORBIDDEN);
                        }
                    }
                }
                catch (ExceptionHugin exceptionHugin) {
                    new HuginGUIError(exceptionHugin.getMessage());
                }
                rectangle.add(((LinkConstraint)object2).getBoundingBox());
                rectangle.add(node2.boundingBox);
                rectangle.add(node.boundingBox);
                WizardNetworkPanel.this.linkList.add(object2);
                WizardNetworkPanel.this.constraintLinks.add(object2);
            }
            WizardNetworkPanel.this.repaintRectangle(rectangle);
            object2 = new String[]{this.node.getName()};
            object = "";
            object = HuginGUIConstants.get("str_Created_constraints_between_argv_and_selected_nodes", (String[])object2);
            WizardNetworkPanel.this.wizardPanel.writeStatus((String)object);
        }
    }
}

