/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public abstract class WizardPanel
extends JPanel {
    JButton[] buttons;
    Component interior;
    Component belowImage;
    Component status;
    static Dimension size;
    String title;
    JTextArea messageBox;
    JPanel statusPanel;
    protected WizardPanel previous;

    public WizardPanel() {
        this.buttons = null;
        this.status = null;
        this.interior = null;
        this.title = "Default";
        this.createMessageBox();
        this.setLayout(new BorderLayout(10, 10));
        this.addComponents();
    }

    public WizardPanel(Image image) {
        this.buttons = null;
        this.interior = null;
        this.title = "Default";
        this.createMessageBox();
        this.setLayout(new BorderLayout(10, 10));
        this.status = new JLabel(new ImageIcon(image));
        this.addComponents();
    }

    public WizardPanel(Component component, Image image) {
        this.buttons = null;
        this.title = "Default";
        this.createMessageBox();
        this.setLayout(new BorderLayout(10, 10));
        this.status = new JLabel(new ImageIcon(image));
        this.interior = component;
        this.addComponents();
    }

    public WizardPanel(Component component, JButton[] jButtonArray, Image image) {
        this.title = "Default";
        this.createMessageBox();
        this.setLayout(new BorderLayout(10, 10));
        this.status = new JLabel(new ImageIcon(image));
        this.interior = component;
        this.buttons = jButtonArray;
        this.addComponents();
    }

    public WizardPanel(Component component) {
        this.buttons = null;
        this.status = null;
        this.title = "Default";
        this.createMessageBox();
        this.setLayout(new BorderLayout(10, 10));
        this.interior = component;
        this.addComponents();
    }

    public WizardPanel(Component component, JButton[] jButtonArray) {
        this.status = null;
        this.title = "Default";
        this.createMessageBox();
        this.setLayout(new BorderLayout(10, 10));
        this.interior = component;
        this.buttons = jButtonArray;
        this.addComponents();
    }

    public WizardPanel(String string) {
        this.buttons = null;
        this.status = null;
        this.interior = null;
        this.title = string;
        this.createMessageBox();
        this.setLayout(new BorderLayout(10, 10));
        this.addComponents();
    }

    public WizardPanel(String string, Image image) {
        this.buttons = null;
        this.interior = null;
        this.createMessageBox();
        this.setLayout(new BorderLayout(10, 10));
        this.status = new JLabel(new ImageIcon(image));
        this.title = string;
        this.addComponents();
    }

    public WizardPanel(String string, Component component, Image image) {
        this.buttons = null;
        this.createMessageBox();
        this.setLayout(new BorderLayout(10, 10));
        this.status = new JLabel(new ImageIcon(image));
        this.title = string;
        this.interior = component;
        this.addComponents();
    }

    public WizardPanel(String string, Component component, JButton[] jButtonArray, Image image) {
        this.createMessageBox();
        this.setLayout(new BorderLayout(10, 10));
        this.status = new JLabel(new ImageIcon(image));
        this.title = string;
        this.interior = component;
        this.buttons = jButtonArray;
        this.addComponents();
    }

    public WizardPanel(String string, Component component) {
        this.buttons = null;
        this.status = null;
        this.createMessageBox();
        this.setLayout(new BorderLayout(10, 10));
        this.title = string;
        this.interior = component;
        this.addComponents();
    }

    public WizardPanel(String string, Component component, JButton[] jButtonArray) {
        this.status = null;
        this.createMessageBox();
        this.setLayout(new BorderLayout(10, 10));
        this.title = string;
        this.interior = component;
        this.buttons = jButtonArray;
        this.addComponents();
    }

    public WizardPanel(String string, JButton[] jButtonArray) {
        this.status = null;
        this.createMessageBox();
        this.setLayout(new BorderLayout(10, 10));
        this.title = string;
        this.interior = null;
        this.buttons = jButtonArray;
        this.addComponents();
    }

    public Dimension getPreferredSize() {
        if (size == null) {
            return super.getPreferredSize();
        }
        return size;
    }

    public static void setWizardSize(Dimension dimension) {
        size = dimension;
    }

    private void createMessageBox() {
        this.messageBox = new JTextArea();
        this.messageBox.setLineWrap(true);
        this.messageBox.setWrapStyleWord(true);
        this.messageBox.setEditable(false);
        this.messageBox.setBackground(this.getBackground());
        this.messageBox.setEnabled(false);
        this.messageBox.setDisabledTextColor(Color.black);
        this.belowImage = this.messageBox;
    }

    public void setImage(Image image) {
        this.status = new JLabel(new ImageIcon(image));
    }

    public void setStatus(Component component) {
        this.status = component;
        this.statusPanel.add(component, "North");
        this.invalidate();
    }

    public void setButtons(JButton[] jButtonArray) {
        this.buttons = jButtonArray;
    }

    public JButton[] getButtons() {
        return this.buttons;
    }

    public void setInterior(Component component) {
        this.interior = component;
    }

    public Component getInterior() {
        return this.interior;
    }

    public void setBelowImage(Component component) {
        this.belowImage = component;
    }

    public void writeStatus(String string) {
        this.messageBox.setText(string);
    }

    public void clearStatus() {
        this.messageBox.setText("");
    }

    public String readStatus() {
        return this.messageBox.getText();
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTitle() {
        return this.title;
    }

    public Insets getInsets() {
        return new Insets(10, 10, 10, 10);
    }

    void addComponents() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(this.title);
        Font font = jLabel.getFont();
        jLabel.setFont(font.deriveFont(1, (int)((float)font.getSize() * 1.3f)));
        jPanel.add((Component)jLabel, "North");
        if (this.interior != null) {
            jPanel.add(this.interior);
        }
        this.add(jPanel);
        this.statusPanel = new JPanel(new BorderLayout());
        if (this.status != null) {
            this.statusPanel.add(this.status, "North");
        }
        if (this.belowImage != null) {
            this.statusPanel.add(this.belowImage, "South");
        }
        this.add((Component)this.statusPanel, "West");
        if (this.buttons != null) {
            JPanel jPanel2 = new JPanel(new BorderLayout());
            JPanel jPanel3 = new JPanel();
            jPanel3.setBorder(BorderFactory.createEtchedBorder(1));
            jPanel3.setPreferredSize(new Dimension(WizardPanel.size.width - 20, 2));
            jPanel2.add((Component)jPanel3, "North");
            JPanel jPanel4 = new JPanel(new FlowLayout(2, 10, 5));
            for (int i = 1; i < this.buttons.length; ++i) {
                jPanel4.add(this.buttons[i]);
            }
            JPanel jPanel5 = new JPanel(new FlowLayout(0, 10, 5));
            jPanel5.add(this.buttons[0]);
            JPanel jPanel6 = new JPanel(new BorderLayout());
            jPanel6.add((Component)jPanel5, "West");
            jPanel6.add((Component)jPanel4, "East");
            jPanel2.add(jPanel6);
            this.add((Component)jPanel2, "South");
        }
    }

    void reLayout() {
        this.removeAll();
        this.addComponents();
    }

    public void back() {
        this.previous.reInitialize();
    }

    protected void reInitialize() {
    }

    protected WizardPanel getPrevious() {
        return this.previous;
    }

    protected void setPrevious(WizardPanel wizardPanel) {
        this.previous = wizardPanel;
    }

    protected void receiveKeyEvent(KeyEvent keyEvent) {
    }
}

