/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.BooleanDCNode;
import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.IntervalDCNode;
import COM.hugin.HAPI.Node;
import COM.hugin.HAPI.NumberedDCNode;
import COM.hugin.HAPI.Table;
import COM.hugin.HGUI.DistributionPanel;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginAnalysisDialog;
import COM.hugin.HGUI.HuginFileLoader;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.NumberField;
import COM.hugin.HGUI.TotalImpactDistribution;
import COM.hugin.HGUI.Variable;
import COM.hugin.HGUI.VerticalFlowLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XOIModelDialog
extends HuginAnalysisDialog {
    JPanel totalImpactPanel;
    JPanel lossPanel;
    JScrollPane lossScroll;
    TotalImpactDistribution totalImpactDist;
    DiscreteChanceNode xNode = null;
    BooleanDCNode oNode = null;
    IntervalDCNode iNode = null;
    JButton ok;
    JButton cancel;
    JButton help;
    JButton sample;
    JButton fit;
    JButton export;
    JButton convolute;
    JButton fit_C;
    JButton export_C;
    JButton import_C;
    JRadioButton uniformRBMCMC;
    JRadioButton xoiRBMCMC;
    JRadioButton uniformRBC;
    JRadioButton xoiRBC;
    boolean enableSelection = false;
    JLabel statesLabelMCMC = null;
    JSpinner numIntervalsMCMC = null;
    JSpinner numSamples = null;
    private static final int NUM_INTS_INITIAL_MCMC = 12;
    private static final int NUM_SAMPLES_INITIAL = 100000;
    Vector<Double> sampledValues = null;
    NumberField minValue;
    NumberField maxValue;
    private static final int NUM_INTS_INITIAL_C = 12;
    private static final int NUM_STATES_INITIAL = 10000;
    JLabel statesLabelC = null;
    JSpinner numStates = null;
    JSpinner numIntervalsC = null;
    Domain domain;
    IntervalDCNode totalImpact;
    Table totalImpactTable;
    double threshold = 1.0E-10;
    JPanel exposurePanel;
    JPanel impactPanel;
    JScrollPane exposureScroll;
    JScrollPane impactScroll;
    JComboBox exposureVar;
    private JTabbedPane tabs = null;
    private int mcmcIndex = 0;
    private int convIndex = 1;

    protected XOIModelDialog(HuginProjectFrame huginProjectFrame, DiscreteChanceNode discreteChanceNode, BooleanDCNode booleanDCNode, IntervalDCNode intervalDCNode) throws ExceptionHugin {
        super(huginProjectFrame, HuginGUIConstants.get("MENU_NETWORK_XOIModel"), true);
        this.xNode = discreteChanceNode;
        this.oNode = booleanDCNode;
        this.iNode = intervalDCNode;
        this.domain = new Domain();
        this.totalImpact = new IntervalDCNode(this.domain);
        this.setResizable(true);
        this.minimum = new Dimension(750, 400);
    }

    public XOIModelDialog(HuginProjectFrame huginProjectFrame, NumberedDCNode numberedDCNode, BooleanDCNode booleanDCNode, IntervalDCNode intervalDCNode) throws ExceptionHugin {
        this(huginProjectFrame, (DiscreteChanceNode)numberedDCNode, booleanDCNode, intervalDCNode);
        this.totalImpactDist = new TotalImpactDistribution(numberedDCNode, this.oNode, this.iNode);
        try {
            this.setContentPane(this.createContent());
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage());
            this.dispose();
        }
    }

    public XOIModelDialog(HuginProjectFrame huginProjectFrame, IntervalDCNode intervalDCNode, BooleanDCNode booleanDCNode, IntervalDCNode intervalDCNode2) throws ExceptionHugin {
        this(huginProjectFrame, (DiscreteChanceNode)intervalDCNode, booleanDCNode, intervalDCNode2);
        this.enableSelection = true;
        try {
            this.setContentPane(this.createContent());
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage());
            this.dispose();
        }
    }

    @Override
    protected JPanel createContent() throws ExceptionHugin {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3 = new JPanel(new BorderLayout());
        this.exposurePanel = new JPanel(new BorderLayout());
        this.impactPanel = new JPanel(new BorderLayout());
        this.exposurePanel.add(this.getExposurePanel());
        this.impactPanel.add(this.getImpactPanel());
        this.exposureScroll = new JScrollPane(this.exposurePanel);
        JScrollPane jScrollPane = new JScrollPane(this.getOccurrencePanel());
        this.impactScroll = new JScrollPane(this.impactPanel);
        this.exposureScroll.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("CONVOLUTION_exposure_dist") + HuginGUIUtils.getNodeTitle(this.xNode)));
        this.impactScroll.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("CONVOLUTION_impact_dist") + HuginGUIUtils.getNodeTitle(this.iNode)));
        jScrollPane.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("CONVOLUTION_occurrence_dist") + HuginGUIUtils.getNodeTitle(this.oNode)));
        JSplitPane jSplitPane = new JSplitPane(0, this.exposureScroll, this.impactScroll);
        jSplitPane.setResizeWeight(0.5);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add(jSplitPane);
        if (this.enableSelection) {
            jPanel2 = this.getExposureVarPanel();
            jPanel2.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("Exposure_Variable")));
            jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)jPanel2, "North");
            jPanel.add(jScrollPane);
            jPanel4.add((Component)jPanel, "South");
        } else {
            jPanel4.add((Component)jScrollPane, "South");
        }
        this.lossPanel = new JPanel();
        this.lossScroll = new JScrollPane(this.lossPanel);
        this.lossScroll.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("No_distribution_computed")));
        jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add(this.getConfigPanel());
        jPanel = new JPanel(new BorderLayout());
        jPanel.add(this.lossScroll);
        jPanel.add((Component)jPanel2, "South");
        JSplitPane jSplitPane2 = new JSplitPane(1, jPanel4, jPanel);
        jSplitPane2.setResizeWeight(0.5);
        jSplitPane2.setDividerLocation(350);
        jPanel3.add(jSplitPane2);
        jPanel3.add((Component)this.getButtonPanel(), "South");
        this.pack();
        return jPanel3;
    }

    private JPanel getExposureVarPanel() throws ExceptionHugin {
        JPanel jPanel = new JPanel(new BorderLayout());
        DefaultComboBoxModel<HuginAnalysisDialog.DiscreteEvidenceListItem> defaultComboBoxModel = new DefaultComboBoxModel<HuginAnalysisDialog.DiscreteEvidenceListItem>();
        defaultComboBoxModel.addElement(new HuginAnalysisDialog.DiscreteEvidenceListItem((HuginAnalysisDialog)this, this.xNode));
        defaultComboBoxModel.addElement(new HuginAnalysisDialog.DiscreteEvidenceListItem((HuginAnalysisDialog)this, this.iNode));
        this.exposureVar = new JComboBox(defaultComboBoxModel);
        jPanel.add(this.exposureVar);
        this.exposureVar.setSelectedIndex(0);
        this.exposureVar.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    try {
                        HuginAnalysisDialog.EvidenceListItem evidenceListItem = (HuginAnalysisDialog.EvidenceListItem)XOIModelDialog.this.exposureVar.getSelectedItem();
                        DiscreteChanceNode discreteChanceNode = (DiscreteChanceNode)evidenceListItem.getNode();
                        XOIModelDialog.this.iNode = (IntervalDCNode)XOIModelDialog.this.xNode;
                        XOIModelDialog.this.xNode = discreteChanceNode;
                        XOIModelDialog.this.impactPanel.removeAll();
                        XOIModelDialog.this.impactPanel.revalidate();
                        XOIModelDialog.this.impactPanel.repaint();
                        XOIModelDialog.this.impactPanel.add(XOIModelDialog.this.getImpactPanel());
                        XOIModelDialog.this.impactPanel.revalidate();
                        XOIModelDialog.this.impactPanel.repaint();
                        XOIModelDialog.this.exposurePanel.removeAll();
                        XOIModelDialog.this.exposurePanel.revalidate();
                        XOIModelDialog.this.exposurePanel.repaint();
                        XOIModelDialog.this.exposurePanel.add(XOIModelDialog.this.getExposurePanel());
                        XOIModelDialog.this.exposurePanel.revalidate();
                        XOIModelDialog.this.exposurePanel.repaint();
                        XOIModelDialog.this.exposureScroll.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("CONVOLUTION_exposure_dist") + HuginGUIUtils.getNodeTitle(XOIModelDialog.this.xNode)));
                        XOIModelDialog.this.impactScroll.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("CONVOLUTION_impact_dist") + HuginGUIUtils.getNodeTitle(XOIModelDialog.this.iNode)));
                    }
                    catch (ExceptionHugin exceptionHugin) {
                        new HuginGUIError(exceptionHugin.getMessage());
                    }
                }
            }
        });
        return jPanel;
    }

    private int getNumberOfSamples() {
        return (Integer)this.numSamples.getValue();
    }

    private int getInitialNumberOfStates() {
        return (Integer)this.numStates.getValue();
    }

    private double getMinValue() {
        return this.minValue.getNumber();
    }

    private double getMaxValue() {
        return this.maxValue.getNumber();
    }

    private int getNumberOfStatesMCMC() {
        return (Integer)this.numIntervalsMCMC.getValue();
    }

    private int getNumberOfStatesC() {
        return (Integer)this.numIntervalsC.getValue();
    }

    private JPanel getConfigPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tabs = new JTabbedPane();
        this.tabs.add((Component)this.getMCMCConfigPanel(), HuginGUIConstants.get("MCMC"));
        this.tabs.add((Component)this.getConvConfigPanel(), HuginGUIConstants.get("Convolution"));
        this.tabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Object var2_2 = null;
            }
        });
        jPanel.add(this.tabs);
        return jPanel;
    }

    private double getMean(Node node) throws ExceptionHugin {
        if (node instanceof IntervalDCNode) {
            return this.getMean((IntervalDCNode)node);
        }
        if (node instanceof NumberedDCNode) {
            return this.getMean((NumberedDCNode)node);
        }
        return -1.0;
    }

    private double getMean(NumberedDCNode numberedDCNode) throws ExceptionHugin {
        double d = 0.0;
        int n = numberedDCNode.getNumberOfStates();
        for (int i = 0; i < n; ++i) {
            d += numberedDCNode.getStateValue(i) * numberedDCNode.getBelief(i);
        }
        return d;
    }

    private double getMean(IntervalDCNode intervalDCNode) throws ExceptionHugin {
        double d = 0.0;
        int n = intervalDCNode.getNumberOfStates();
        for (int i = 0; i < n; ++i) {
            d += (intervalDCNode.getStateValue(i + 1) - intervalDCNode.getStateValue(i)) / 2.0 * intervalDCNode.getBelief(i);
        }
        return d;
    }

    private double getVariance(Node node, double d) throws ExceptionHugin {
        if (node instanceof IntervalDCNode) {
            return this.getVariance((IntervalDCNode)node, d);
        }
        if (node instanceof NumberedDCNode) {
            return this.getVariance((NumberedDCNode)node, d);
        }
        return -1.0;
    }

    private double getVariance(NumberedDCNode numberedDCNode, double d) throws ExceptionHugin {
        double d2 = 0.0;
        int n = numberedDCNode.getNumberOfStates();
        for (int i = 0; i < n; ++i) {
            d2 += numberedDCNode.getBelief(i) * Math.pow(numberedDCNode.getStateValue(i) - d, 2.0);
        }
        return d2;
    }

    private double getVariance(IntervalDCNode intervalDCNode, double d) throws ExceptionHugin {
        double d2 = 0.0;
        double d3 = 0.0;
        int n = intervalDCNode.getNumberOfStates();
        for (int i = 0; i < n; ++i) {
            d3 = intervalDCNode.getStateValue(i + 1) - intervalDCNode.getStateValue(i) + intervalDCNode.getStateValue(i);
            d2 += intervalDCNode.getBelief(i) * Math.pow(d3 - d, 2.0);
        }
        return d2;
    }

    private JPanel getConvConfigPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(HuginGUIConstants.get("Bins") + " : ");
        this.numStates = new JSpinner(new SpinnerNumberModel(10000, 2, 1000000, 100));
        this.numStates.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
            }
        });
        JLabel jLabel2 = new JLabel(HuginGUIConstants.get("Min_loss") + " : ");
        JLabel jLabel3 = new JLabel(HuginGUIConstants.get("Max_loss") + " : ");
        this.minValue = new NumberField(new Double(0.0));
        this.minValue.setHorizontalAlignment(4);
        double d = 1000.0;
        try {
            double d2 = this.oNode.getBelief(1);
            double d3 = 1.0;
            double d4 = 1.0;
            double d5 = this.getMean(this.iNode);
            double d6 = this.getVariance(this.iNode, d5);
            if (this.xNode instanceof IntervalDCNode) {
                d3 = ((IntervalDCNode)this.xNode).getStateValue(this.xNode.getNumberOfStates());
            } else if (this.xNode instanceof NumberedDCNode) {
                d3 = ((NumberedDCNode)this.xNode).getStateValue(this.xNode.getNumberOfStates() - 1);
            }
            d4 = this.iNode.getStateValue(this.iNode.getNumberOfStates());
            if (d4 == Domain.INFINITY()) {
                d4 = 1.1 * this.iNode.getStateValue(this.iNode.getNumberOfStates() - 1);
            }
            d = d3 * d4;
        }
        catch (ExceptionHugin exceptionHugin) {
            // empty catch block
        }
        this.maxValue = new NumberField();
        this.maxValue.setText("" + HuginGUIUtils.printDouble(d, 2));
        this.maxValue.setHorizontalAlignment(4);
        JPanel jPanel3 = new JPanel(new FlowLayout());
        JPanel jPanel4 = new JPanel(new FlowLayout());
        jPanel3.add(jLabel2);
        jPanel3.add(this.minValue);
        JPanel jPanel5 = new JPanel(new FlowLayout());
        jPanel5.add(jLabel);
        jPanel5.add(this.numStates);
        jPanel5.add(jLabel3);
        jPanel5.add(this.maxValue);
        this.statesLabelC = new JLabel(HuginGUIConstants.get("States") + " : ");
        this.numIntervalsC = new JSpinner(new SpinnerNumberModel(12, 2, 1000, 1));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.xoiRBC = new JRadioButton(HuginGUIConstants.get("Percentile_Discretization"));
        this.xoiRBC.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XOIModelDialog.this.numIntervalsC.setEnabled(false);
                XOIModelDialog.this.statesLabelC.setEnabled(false);
            }
        });
        this.uniformRBC = new JRadioButton(HuginGUIConstants.get("Uniform_Discretization"));
        this.uniformRBC.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XOIModelDialog.this.numIntervalsC.setEnabled(true);
                XOIModelDialog.this.statesLabelC.setEnabled(true);
            }
        });
        this.xoiRBC.setSelected(true);
        this.uniformRBC.setSelected(false);
        this.numIntervalsC.setEnabled(false);
        this.statesLabelC.setEnabled(false);
        buttonGroup.add(this.xoiRBC);
        buttonGroup.add(this.uniformRBC);
        JPanel jPanel6 = new JPanel(new FlowLayout());
        jPanel6.add(this.statesLabelC);
        jPanel6.add(this.numIntervalsC);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        jPanel2.add((Component)jPanel5, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        jPanel2.add((Component)this.uniformRBC, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        jPanel2.add((Component)jPanel6, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        jPanel2.add((Component)this.xoiRBC, gridBagConstraints);
        jPanel.add(jPanel2);
        jPanel.add((Component)this.getConvConfigButtonPanel(), "South");
        return jPanel;
    }

    private JPanel getMCMCConfigPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(HuginGUIConstants.get("Number_of_samples") + " : ");
        this.numSamples = new JSpinner(new SpinnerNumberModel(100000, 10000, 10000000, 10000));
        this.numSamples.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
            }
        });
        this.statesLabelMCMC = new JLabel(HuginGUIConstants.get("States") + " : ");
        this.numIntervalsMCMC = new JSpinner(new SpinnerNumberModel(12, 2, 1000, 1));
        this.numIntervalsMCMC.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        this.xoiRBMCMC = new JRadioButton(HuginGUIConstants.get("Percentile_Discretization"));
        this.xoiRBMCMC.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XOIModelDialog.this.numIntervalsMCMC.setEnabled(false);
                XOIModelDialog.this.statesLabelMCMC.setEnabled(false);
            }
        });
        this.uniformRBMCMC = new JRadioButton(HuginGUIConstants.get("Uniform_Discretization"));
        this.uniformRBMCMC.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XOIModelDialog.this.numIntervalsMCMC.setEnabled(true);
                XOIModelDialog.this.statesLabelMCMC.setEnabled(true);
            }
        });
        this.xoiRBMCMC.setSelected(true);
        this.uniformRBMCMC.setSelected(false);
        this.numIntervalsMCMC.setEnabled(false);
        this.statesLabelMCMC.setEnabled(false);
        buttonGroup.add(this.xoiRBMCMC);
        buttonGroup.add(this.uniformRBMCMC);
        JPanel jPanel3 = new JPanel(new FlowLayout());
        jPanel3.add(this.statesLabelMCMC);
        jPanel3.add(this.numIntervalsMCMC);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        jPanel2.add((Component)this.numSamples, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel2.add((Component)this.uniformRBMCMC, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        jPanel2.add((Component)this.xoiRBMCMC, gridBagConstraints);
        jPanel.add(jPanel2);
        jPanel.add((Component)this.getMCMCConfigButtonPanel(), "South");
        return jPanel;
    }

    private JPanel getImpactPanel() {
        return new DistributionPanel(this.iNode);
    }

    private JPanel getExposurePanel() {
        return new DistributionPanel(this.xNode);
    }

    private JPanel getOccurrencePanel() {
        return new DistributionPanel(this.oNode);
    }

    private JPanel getTotalImpactPanel() {
        JPanel jPanel = new JPanel(new VerticalFlowLayout());
        jPanel.setSize(new Dimension(350, 100));
        jPanel.setBackground(Color.white);
        try {
            this.totalImpactDist.calculate(false);
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage());
        }
        DistributionPanel distributionPanel = new DistributionPanel(this.totalImpactDist.getNode(), this.totalImpactDist.getValues());
        distributionPanel.setPrecision(4);
        jPanel.add(distributionPanel);
        return jPanel;
    }

    @Override
    protected JButton getPerformButton() {
        return null;
    }

    protected JPanel getButtonPanel() {
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JPanel jPanel3 = new JPanel(new FlowLayout(2));
        this.ok = new JButton(HuginGUIConstants.get("OK_button"));
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (XOIModelDialog.this.domain != null) {
                        XOIModelDialog.this.domain.delete();
                    }
                    if (XOIModelDialog.this.totalImpactDist != null) {
                        XOIModelDialog.this.totalImpactDist.delete();
                    }
                    XOIModelDialog.this.dispose();
                }
                catch (Exception exception) {
                    new HuginGUIError(exception.getMessage());
                }
            }
        });
        this.cancel = new JButton(HuginGUIConstants.get("cancel_button"));
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (XOIModelDialog.this.domain != null) {
                        XOIModelDialog.this.domain.delete();
                    }
                    if (XOIModelDialog.this.totalImpactDist != null) {
                        XOIModelDialog.this.totalImpactDist.delete();
                    }
                }
                catch (Exception exception) {
                    new HuginGUIError(exception.getMessage());
                }
                XOIModelDialog.this.dispose();
            }
        });
        jPanel3.add(this.ok);
        jPanel3.add(this.cancel);
        this.help = new JButton(HuginGUIConstants.get("help_button"));
        this.help.addActionListener(new HuginAnalysisDialog.HelpListener(this, HuginGUIConstants.get("XOI_HELP_PAGE")));
        jPanel2.add(this.help);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        return jPanel;
    }

    private void moveTo(double d) {
        double d2 = this.lossPanel.getPreferredSize().getHeight();
        int n = (int)(d2 * d - this.lossScroll.getSize().getHeight() / 2.0);
        JViewport jViewport = this.lossScroll.getViewport();
        jViewport.setViewPosition(new Point(0, n));
    }

    private void moveToMax(double[] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        int n = 1;
        try {
            n = dArray.length;
            for (int i = 0; i < n; ++i) {
                if (!(dArray[i] > d2)) continue;
                d = i;
                d2 = dArray[i];
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new HuginGUIError(exception.getMessage());
        }
        this.moveTo(d / (double)n);
    }

    private void convolutionAction(ActionEvent actionEvent) throws ExceptionHugin {
        int n;
        boolean bl = this.iNode.getStateValue(0) < 0.0;
        int n2 = this.getInitialNumberOfStates();
        double d = (this.getMaxValue() - this.getMinValue()) / (double)n2;
        if (bl) {
            this.totalImpact.setNumberOfStates(n2 + 2);
            this.totalImpact.setStateValue(0, -Domain.INFINITY());
            this.totalImpact.setStateValue(1, this.getMinValue());
        } else {
            this.totalImpact.setNumberOfStates(n2 + 1);
            this.totalImpact.setStateValue(0, 0.0);
            if (this.getMinValue() != 0.0) {
                this.totalImpact.setStateValue(1, this.getMinValue());
            }
        }
        int n3 = 1;
        int n4 = n2;
        if (bl) {
            ++n3;
            ++n4;
        }
        if (this.getMinValue() != 0.0) {
            ++n3;
        }
        for (n = n3; n < n4; ++n) {
            this.totalImpact.setStateValue(n, (double)n * d + this.getMinValue());
        }
        this.totalImpact.setStateValue(n4, this.getMaxValue());
        this.totalImpact.setStateValue(n4 + 1, Domain.INFINITY());
        int n5 = this.totalImpact.getNumberOfStates();
        for (n = 0; n < n5; ++n) {
            this.totalImpact.setStateLabel(n, HuginGUIUtils.printInterval(this.totalImpact.getStateValue(n), this.totalImpact.getStateValue(n + 1), 2));
        }
        this.totalImpact.setAttribute("HR_Node_states", "labels");
        Object var8_8 = null;
        if (this.xNode instanceof IntervalDCNode) {
            this.totalImpactTable = this.totalImpact.getTotalImpact((IntervalDCNode)this.xNode, this.oNode, this.iNode);
        } else if (this.xNode instanceof NumberedDCNode) {
            this.totalImpactTable = this.totalImpact.getTotalImpact((NumberedDCNode)this.xNode, this.oNode, this.iNode);
        }
        this.showTotalImpactTable(this.totalImpact, this.totalImpactTable);
    }

    private boolean enableXOI() {
        boolean bl = false;
        try {
            int n = this.totalImpactTable.getSize();
            if (n < 2) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (!(this.totalImpactTable.getDataItem(i) > 0.1)) continue;
                return false;
            }
            bl = this.totalImpactTable.getDataItem(n - 1) < 0.001;
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage());
        }
        return bl;
    }

    private void showTotalImpactTable(IntervalDCNode intervalDCNode, Table table) throws ExceptionHugin {
        double[] dArray = new double[table.getSize()];
        for (int i = 0; i < table.getSize(); ++i) {
            dArray[i] = table.getDataItem(i);
        }
        DistributionPanel distributionPanel = new DistributionPanel(intervalDCNode, dArray, true);
        distributionPanel.setPrecision(4);
        this.lossPanel.removeAll();
        this.lossPanel.add(distributionPanel);
        this.lossPanel.revalidate();
        this.lossPanel.repaint();
        this.fit_C.setEnabled(true);
        this.export_C.setEnabled(true);
        this.xoiRBC.setEnabled(this.enableXOI());
        this.moveToMax(dArray);
    }

    private JPanel getConvConfigButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout());
        this.convolute = new JButton(HuginGUIConstants.get("CONVOLUTION_convolute"));
        this.convolute.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    XOIModelDialog.this.convolutionAction(actionEvent);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    new HuginGUIError(exception.getMessage());
                }
                XOIModelDialog.this.lossScroll.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("Convoluted_Loss_Distribution")));
            }
        });
        this.fit_C = new JButton(HuginGUIConstants.get("CONVOLUTION_fit"));
        this.fit_C.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (XOIModelDialog.this.xoiRBC.isEnabled() || XOIModelDialog.this.uniformRBC.isEnabled() && XOIModelDialog.this.uniformRBC.isSelected()) {
                    try {
                        Domain domain = new Domain();
                        IntervalDCNode intervalDCNode = new IntervalDCNode(domain);
                        if (XOIModelDialog.this.xoiRBC.isSelected()) {
                            XOIModelDialog.this.xoiDiscretization(intervalDCNode, XOIModelDialog.this.totalImpact, XOIModelDialog.this.totalImpactTable);
                        } else if (XOIModelDialog.this.uniformRBC.isSelected()) {
                            XOIModelDialog.this.uniformDiscretization(intervalDCNode, XOIModelDialog.this.totalImpact, XOIModelDialog.this.totalImpactTable);
                        }
                        XOIModelDialog.this.showTotalImpactTable(intervalDCNode, intervalDCNode.getTable());
                        XOIModelDialog.this.lossScroll.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("Convoluted_Loss_Distribution")));
                        domain.delete();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        new HuginGUIError(exception.getMessage());
                    }
                }
            }
        });
        this.export_C = new JButton(HuginGUIConstants.get("CONVOLUTION_export"));
        this.export_C.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    HuginFileLoader huginFileLoader = new HuginFileLoader(11, Hugin.mainFrame.getMostRecentCaseFile(), 5);
                    if (huginFileLoader.showSaveDialog(Hugin.mainFrame) == 0) {
                        File file = huginFileLoader.getSelectedFile();
                        Hugin.mainFrame.setMostRecentCaseFile(file);
                        PrintStream printStream = new PrintStream(new FileOutputStream(file));
                        int n = XOIModelDialog.this.totalImpactTable.getSize();
                        for (int i = 0; i < n; ++i) {
                            printStream.println(XOIModelDialog.this.totalImpact.getStateLabel(i) + " " + HuginGUIUtils.printDouble(XOIModelDialog.this.totalImpactTable.getDataItem(i), XOIModelDialog.this.projectFrame.guiFrame.preferences.precision));
                        }
                        printStream.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    new HuginGUIError(exception.getMessage());
                }
            }
        });
        this.import_C = new JButton(HuginGUIConstants.get("Import"));
        this.import_C.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    HuginFileLoader huginFileLoader = new HuginFileLoader(11, Hugin.mainFrame.getMostRecentCaseFile(), 0);
                    if (huginFileLoader.showDialog(Hugin.mainFrame) == 0) {
                        Object object;
                        File file = huginFileLoader.getSelectedFile();
                        Hugin.mainFrame.setMostRecentCaseFile(file);
                        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                        int n = 0;
                        String string = bufferedReader.readLine();
                        Vector<Double> vector = new Vector<Double>();
                        Vector<Double> vector2 = new Vector<Double>();
                        Vector<Double> vector3 = new Vector<Double>();
                        while (string != null) {
                            if (string != "" && string != "\n" && ((String[])(object = string.trim().split(" "))).length == 4) {
                                vector.add(new Double(Variable.atof(object[0])));
                                if (object[2].equals("inf")) {
                                    vector2.add(new Double(Domain.INFINITY()));
                                } else {
                                    vector2.add(new Double(Variable.atof(object[2])));
                                }
                                vector3.add(new Double(Variable.atof(object[3])));
                                ++n;
                            }
                            string = bufferedReader.readLine();
                        }
                        System.err.println(n);
                        System.err.println(XOIModelDialog.this.totalImpact.getName());
                        if (n == 0) {
                            throw new ExceptionHugin(HuginGUIConstants.get("str_error_no_lines_read"));
                        }
                        XOIModelDialog.this.totalImpact.setNumberOfStates(n);
                        object = XOIModelDialog.this.totalImpact.getTable();
                        for (int i = 0; i < n; ++i) {
                            XOIModelDialog.this.totalImpact.setStateValue(i, (Double)vector.get(i));
                            XOIModelDialog.this.totalImpact.setStateValue(i + 1, (Double)vector2.get(i));
                            ((Table)object).setDataItem(i, (Double)vector3.get(i));
                        }
                        XOIModelDialog.this.totalImpactTable = object;
                        XOIModelDialog.this.showTotalImpactTable(XOIModelDialog.this.totalImpact, XOIModelDialog.this.totalImpactTable);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    new HuginGUIError(exception.getMessage());
                }
            }
        });
        this.convolute.setEnabled(true);
        this.fit_C.setEnabled(false);
        this.export_C.setEnabled(false);
        this.import_C.setEnabled(true);
        jPanel.add(this.convolute);
        jPanel.add(this.export_C);
        jPanel.add(this.import_C);
        jPanel.add(this.fit_C);
        return jPanel;
    }

    private JPanel getMCMCConfigButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout());
        this.sample = new JButton(HuginGUIConstants.get("CONVOLUTION_sample"));
        this.sample.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    XOIModelDialog.this.fit.setEnabled(true);
                    XOIModelDialog.this.export.setEnabled(true);
                    XOIModelDialog.this.sampledValues = new Vector();
                    double[] dArray = XOIModelDialog.this.xNode.getHomeDomain().getConvolution(XOIModelDialog.this.xNode, XOIModelDialog.this.oNode, XOIModelDialog.this.iNode, XOIModelDialog.this.getNumberOfSamples());
                    for (int i = 0; i < dArray.length; ++i) {
                        XOIModelDialog.this.sampledValues.add(new Double(dArray[i]));
                    }
                    dArray = null;
                    Collections.sort(XOIModelDialog.this.sampledValues);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    new HuginGUIError(exception.getMessage());
                }
            }
        });
        this.export = new JButton(HuginGUIConstants.get("CONVOLUTION_export"));
        this.export.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    HuginFileLoader huginFileLoader = new HuginFileLoader(11, Hugin.mainFrame.getMostRecentCaseFile(), 5);
                    if (huginFileLoader.showSaveDialog(Hugin.mainFrame) == 0) {
                        File file = huginFileLoader.getSelectedFile();
                        Hugin.mainFrame.setMostRecentCaseFile(file);
                        PrintStream printStream = new PrintStream(new FileOutputStream(file));
                        for (int i = 0; i < XOIModelDialog.this.sampledValues.size(); ++i) {
                            printStream.println(XOIModelDialog.this.sampledValues.get(i));
                        }
                        printStream.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    new HuginGUIError(exception.getMessage());
                }
            }
        });
        this.fit = new JButton(HuginGUIConstants.get("CONVOLUTION_fit"));
        this.fit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n;
                    int n2;
                    Domain domain = new Domain();
                    IntervalDCNode intervalDCNode = new IntervalDCNode(domain);
                    if (XOIModelDialog.this.xoiRBMCMC.isSelected()) {
                        XOIModelDialog.this.xoiDiscretization(intervalDCNode);
                    } else if (XOIModelDialog.this.uniformRBMCMC.isSelected()) {
                        XOIModelDialog.this.uniformDiscretization(intervalDCNode);
                    }
                    Table table = intervalDCNode.getTable();
                    int n3 = intervalDCNode.getNumberOfStates();
                    for (n2 = 0; n2 < n3; ++n2) {
                        table.setDataItem(n2, 0.0);
                    }
                    block3: for (n2 = 0; n2 < XOIModelDialog.this.sampledValues.size(); ++n2) {
                        for (n = 0; n < n3; ++n) {
                            double d = XOIModelDialog.this.sampledValues.get(n2);
                            if (!(intervalDCNode.getStateValue(n) <= d) || !(d < intervalDCNode.getStateValue(n + 1))) continue;
                            table.setDataItem(n, table.getDataItem(n) + 1.0);
                            continue block3;
                        }
                    }
                    HuginGUIUtils.configureDomain(domain);
                    domain.compile();
                    double[] dArray = new double[n3];
                    for (n = 0; n < n3; ++n) {
                        dArray[n] = intervalDCNode.getBelief(n);
                    }
                    DistributionPanel distributionPanel = new DistributionPanel(intervalDCNode, dArray, XOIModelDialog.this.xoiRBMCMC.isSelected());
                    distributionPanel.setPrecision(4);
                    XOIModelDialog.this.lossPanel.removeAll();
                    XOIModelDialog.this.lossPanel.revalidate();
                    XOIModelDialog.this.lossPanel.repaint();
                    XOIModelDialog.this.lossPanel.add(distributionPanel);
                    XOIModelDialog.this.lossPanel.revalidate();
                    XOIModelDialog.this.lossPanel.repaint();
                    domain.delete();
                    XOIModelDialog.this.lossScroll.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("CONVOLUTION_loss_dist")));
                    XOIModelDialog.this.moveToMax(dArray);
                }
                catch (Exception exception) {
                    new HuginGUIError(exception.getMessage());
                }
            }
        });
        this.fit.setEnabled(false);
        this.export.setEnabled(false);
        jPanel.add(this.sample);
        jPanel.add(this.export);
        jPanel.add(this.fit);
        return jPanel;
    }

    private void xoiDiscretization(IntervalDCNode intervalDCNode) throws ExceptionHugin {
        int n;
        int n2;
        intervalDCNode.setNumberOfStates(12);
        double d = this.sampledValues.get(0);
        double d2 = this.sampledValues.get(this.sampledValues.size() - 1);
        intervalDCNode.setStateValue(0, d);
        intervalDCNode.setStateValue(intervalDCNode.getNumberOfStates(), d2);
        double[] dArray = new double[]{0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 0.99, 0.999};
        for (n2 = 0; n2 < dArray.length; ++n2) {
            n = (int)(dArray[n2] * (double)this.sampledValues.size());
            double d3 = this.sampledValues.get(n);
            double d4 = this.sampledValues.get(n + 1);
            intervalDCNode.setStateValue(n2 + 1, d3 + (d4 - d3) / 2.0);
        }
        n = intervalDCNode.getNumberOfStates();
        for (n2 = 0; n2 < n; ++n2) {
            intervalDCNode.setStateLabel(n2, HuginGUIUtils.printInterval(intervalDCNode.getStateValue(n2), intervalDCNode.getStateValue(n2 + 1), 2));
        }
        intervalDCNode.setAttribute("HR_Node_states", "labels");
    }

    private void xoiDiscretization2(IntervalDCNode intervalDCNode, IntervalDCNode intervalDCNode2) throws ExceptionHugin {
        int n;
        int n2;
        intervalDCNode.setNumberOfStates(12);
        double d = 0.0;
        double d2 = intervalDCNode2.getStateValue(intervalDCNode2.getNumberOfStates() - 1);
        intervalDCNode.setStateValue(0, d);
        intervalDCNode.setStateValue(intervalDCNode.getNumberOfStates() - 1, d2);
        intervalDCNode.setStateValue(intervalDCNode.getNumberOfStates(), Domain.INFINITY());
        double[] dArray = new double[]{0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 0.99, 0.999};
        for (n2 = 0; n2 < dArray.length; ++n2) {
            n = (int)(dArray[n2] * (double)this.sampledValues.size());
            double d3 = this.sampledValues.get(n);
            double d4 = this.sampledValues.get(n + 1);
            intervalDCNode.setStateValue(n2 + 1, d3 + (d4 - d3) / 2.0);
        }
        n = intervalDCNode.getNumberOfStates();
        for (n2 = 0; n2 < n; ++n2) {
            intervalDCNode.setStateLabel(n2, HuginGUIUtils.printInterval(intervalDCNode.getStateValue(n2), intervalDCNode.getStateValue(n2 + 1), 2));
        }
        intervalDCNode.setAttribute("HR_Node_states", "labels");
    }

    private void uniformDiscretization(IntervalDCNode intervalDCNode) throws ExceptionHugin {
        int n;
        intervalDCNode.setNumberOfStates(this.getNumberOfStatesMCMC());
        double d = this.sampledValues.get(0);
        double d2 = this.sampledValues.get(this.sampledValues.size() - 1);
        intervalDCNode.setStateValue(intervalDCNode.getNumberOfStates(), d2);
        double d3 = (d2 - d) / (double)intervalDCNode.getNumberOfStates();
        int n2 = intervalDCNode.getNumberOfStates();
        for (n = 0; n < n2; ++n) {
            intervalDCNode.setStateValue(n, d + (double)n * d3);
        }
        n2 = intervalDCNode.getNumberOfStates();
        for (n = 0; n < n2; ++n) {
            intervalDCNode.setStateLabel(n, HuginGUIUtils.printInterval(intervalDCNode.getStateValue(n), intervalDCNode.getStateValue(n + 1), 2));
        }
        intervalDCNode.setAttribute("HR_Node_states", "labels");
    }

    private void xoiDiscretization(IntervalDCNode intervalDCNode, IntervalDCNode intervalDCNode2, Table table) throws ExceptionHugin {
        int n;
        int n2 = intervalDCNode2.getNumberOfStates();
        double d = 0.0;
        double d2 = intervalDCNode2.getStateValue(n2 - 1);
        int n3 = 12;
        double[] dArray = new double[n3 + 1];
        double[] dArray2 = new double[n3 + 1];
        boolean bl = false;
        double d3 = 0.0;
        for (n = 0; n < n2 - 1; ++n) {
            d3 += table.getDataItem(n);
        }
        dArray[0] = intervalDCNode2.getStateValue(0);
        n = 0;
        int n4 = 12;
        double[] dArray3 = new double[]{0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.09, 0.009, 0.001};
        intervalDCNode.setNumberOfStates(n4);
        intervalDCNode.setStateValue(0, d);
        intervalDCNode.setStateValue(n4, Domain.INFINITY());
        Table table2 = intervalDCNode.getTable();
        int n5 = 0;
        boolean bl2 = false;
        double d4 = 0.0;
        double d5 = 0.0;
        Vector<Number> vector = new Vector<Number>();
        vector.add(0, new Integer(n5));
        vector.add(1, new Double(d4));
        for (n = 0; n < n4; ++n) {
            this.sumFromBelow(n, dArray3[n], table, intervalDCNode2, dArray2, dArray, vector);
        }
        vector.add(0, new Integer(table.getSize() - 1));
        vector.add(1, new Double(0.0));
        for (n = n4 - 1; n >= 9; --n) {
            this.sumFromAbove(n, dArray3[n], table, intervalDCNode2, dArray2, dArray, vector);
        }
        dArray[n4 - 1] = Domain.INFINITY();
        for (int i = 0; i < n4; ++i) {
            intervalDCNode.setStateValue(i + 1, dArray[i]);
            table2.setDataItem(i, dArray2[i]);
            intervalDCNode.setStateLabel(i, HuginGUIUtils.printInterval(intervalDCNode.getStateValue(i), intervalDCNode.getStateValue(i + 1), 2));
        }
        intervalDCNode.setAttribute("HR_Node_states", "labels");
    }

    protected int sumFromBelow(int n, double d, Table table, IntervalDCNode intervalDCNode, double[] dArray, double[] dArray2, Vector<Number> vector) throws ExceptionHugin {
        int n2;
        double d2 = (Double)vector.get(1);
        double d3 = 0.0;
        for (n2 = ((Integer)vector.get(0)).intValue(); n2 < table.getSize(); ++n2) {
            if (d2 == 0.0) {
                d2 = table.getDataItem(n2);
            }
            if (!(d3 + d2 < d)) break;
            d3 += d2;
            d2 = 0.0;
        }
        if (n2 >= table.getSize()) {
            dArray[n] = d3 + d2;
        } else if (Math.abs(d3 + d2 - d) < this.threshold) {
            dArray2[n] = intervalDCNode.getStateValue(n2 + 1);
            dArray[n] = d3 + d2;
            ++n2;
            d2 = 0.0;
        } else {
            double d4 = d - d3;
            double d5 = d4 / d2;
            double d6 = intervalDCNode.getStateValue(n2 + 1) - intervalDCNode.getStateValue(n2);
            dArray2[n] = d5 * d6 + intervalDCNode.getStateValue(n2);
            double d7 = d5 * d2;
            dArray[n] = d3 + d7;
            d2 -= d7;
        }
        vector.add(0, new Integer(n2));
        vector.add(1, new Double(d2));
        return n2;
    }

    protected void sumFromAbove(int n, double d, Table table, IntervalDCNode intervalDCNode, double[] dArray, double[] dArray2, Vector<Number> vector) throws ExceptionHugin {
        int n2;
        double d2 = (Double)vector.get(1);
        double d3 = 0.0;
        for (n2 = ((Integer)vector.get(0)).intValue(); n2 > 0; --n2) {
            if (d2 == 0.0) {
                d2 = table.getDataItem(n2);
            }
            if (!(d3 + d2 < d)) break;
            d3 += d2;
            d2 = 0.0;
        }
        if (n2 <= 0) {
            dArray[n] = d3 + d2;
        } else if (Math.abs(d3 + d2 - d) < this.threshold) {
            dArray2[n - 1] = intervalDCNode.getStateValue(n2 + 1);
            dArray[n] = d3 + d2;
            --n2;
            d2 = 0.0;
        } else {
            double d4 = d - d3;
            double d5 = d4 / d2;
            double d6 = intervalDCNode.getStateValue(n2) - intervalDCNode.getStateValue(n2 - 1);
            dArray2[n - 1] = intervalDCNode.getStateValue(n2 + 1) - d5 * d6;
            double d7 = d5 * d2;
            dArray[n] = d3 + d7;
            d2 -= d7;
        }
        vector.add(0, new Integer(n2));
        vector.add(1, new Double(d2));
    }

    private void uniformDiscretization(IntervalDCNode intervalDCNode, IntervalDCNode intervalDCNode2, Table table) throws ExceptionHugin {
        int n;
        int n2 = intervalDCNode2.getNumberOfStates() - 1;
        int n3 = this.getNumberOfStatesC();
        int n4 = n2 / n3;
        double d = 0.0;
        double d2 = intervalDCNode2.getStateValue(intervalDCNode2.getNumberOfStates() - 1);
        intervalDCNode.setNumberOfStates(n3 + 1);
        intervalDCNode.setStateValue(0, d);
        intervalDCNode.setStateValue(intervalDCNode.getNumberOfStates() - 1, d2);
        intervalDCNode.setStateValue(intervalDCNode.getNumberOfStates(), Domain.INFINITY());
        Table table2 = intervalDCNode.getTable();
        int n5 = 0;
        for (int i = 0; i < n3; ++i) {
            double d3 = 0.0;
            for (n = 0; n < n4; ++n) {
                d3 += table.getDataItem(n5++);
            }
            table2.setDataItem(i, d3);
            intervalDCNode.setStateValue(i + 1, intervalDCNode2.getStateValue(n5));
        }
        double d4 = 0.0;
        while (n5 < intervalDCNode2.getNumberOfStates()) {
            d4 += table.getDataItem(n5);
            ++n5;
        }
        table2.setDataItem(intervalDCNode.getNumberOfStates() - 1, d4);
        n = intervalDCNode.getNumberOfStates();
        for (int i = 0; i < n; ++i) {
            intervalDCNode.setStateLabel(i, HuginGUIUtils.printInterval(intervalDCNode.getStateValue(i), intervalDCNode.getStateValue(i + 1), 2));
        }
        intervalDCNode.setAttribute("HR_Node_states", "labels");
    }

    private void updateTotalImpactPanel(boolean bl) throws ExceptionHugin {
        this.totalImpactPanel.removeAll();
        this.totalImpactPanel.revalidate();
        this.totalImpactPanel.repaint();
        this.totalImpactDist.calculate(bl);
        DistributionPanel distributionPanel = new DistributionPanel(this.totalImpactDist.getNode(), this.totalImpactDist.getValues());
        this.totalImpactPanel.add(distributionPanel);
        this.totalImpactPanel.revalidate();
        this.totalImpactPanel.repaint();
    }
}

