/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI.zoom;

import COM.hugin.HGUI.zoom.ZoomableComponent;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class ZoomableButton
extends JButton
implements ZoomableComponent {
    double scaleFactor = 1.0;
    Image image = ((ImageIcon)this.getIcon()).getImage();
    Image disabled;
    Insets insets;

    public ZoomableButton(ImageIcon imageIcon) {
        super(imageIcon);
        ImageIcon imageIcon2 = new ImageIcon(GrayFilter.createDisabledImage(imageIcon.getImage()));
        this.disabled = new ImageIcon(GrayFilter.createDisabledImage(imageIcon.getImage())).getImage();
        this.insets = super.getInsets();
    }

    public void setScaleFactor(double d) {
        this.scaleFactor = d;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public void paintComponent(Graphics graphics) {
        graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
        int n = this.image.getWidth(this);
        int n2 = this.image.getHeight(this);
        int n3 = (this.getWidth() - (int)((double)n * this.scaleFactor)) / 2;
        int n4 = (this.getHeight() - (int)((double)n2 * this.scaleFactor)) / 2;
        Image image = this.isEnabled() ? this.image : this.disabled;
        graphics.drawImage(image, n3, n4, n3 + (int)((double)n * this.scaleFactor), n4 + (int)((double)n2 * this.scaleFactor), 0, 0, n, n2, this.getBackground(), this);
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        Dimension dimension = new Dimension(this.image.getWidth(this) + insets.left + insets.right, this.image.getHeight(this) + insets.top + insets.bottom);
        dimension.width = (int)((double)dimension.width * this.scaleFactor);
        dimension.height = (int)((double)dimension.height * this.scaleFactor);
        return dimension;
    }
}

