/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI.zoom;

import COM.hugin.HGUI.zoom.ZoomableComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import javax.swing.JButton;
import javax.swing.JScrollBar;
import javax.swing.UIManager;

public class ZoomableScrollBar
extends JScrollBar
implements ZoomableComponent {
    double scaleFactor = 1.0;
    int initialHeight = 16;
    int initialWidth = 16;
    ZoomableScrollButton back;
    ZoomableScrollButton forward;
    Color foreground;
    Color shadow;
    Color highlight;
    boolean dragging = false;
    double knobFraction;
    int knobX;
    int knobY;

    public ZoomableScrollBar() {
    }

    public ZoomableScrollBar(int n) {
        this.orientation = n;
        this.removeAll();
        this.setLayout(new BorderLayout(0, 0));
        this.back = new ZoomableScrollButton(0);
        this.forward = new ZoomableScrollButton(1);
        if (this.orientation == 0) {
            this.add((Component)this.back, "West");
            this.add((Component)this.forward, "East");
        }
        if (this.orientation == 1) {
            this.add((Component)this.back, "North");
            this.add((Component)this.forward, "South");
        }
        this.addComponentListener(new ResizedListener());
        EventListener[] eventListenerArray = this.getListeners(MouseMotionListener.class);
        this.removeMouseMotionListener((MouseMotionListener)eventListenerArray[0]);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                if (ZoomableScrollBar.this.inKnob(mouseEvent.getX(), mouseEvent.getY()) || ZoomableScrollBar.this.dragging) {
                    double d;
                    int n;
                    ZoomableScrollBar.this.dragging = true;
                    if (ZoomableScrollBar.this.orientation == 0) {
                        n = mouseEvent.getX() - ZoomableScrollBar.this.back.getWidth();
                        d = (double)n / (double)ZoomableScrollBar.this.getBarWidth();
                    } else {
                        n = mouseEvent.getY() - ZoomableScrollBar.this.back.getHeight();
                        d = (double)n / (double)ZoomableScrollBar.this.getBarHeight();
                    }
                    n = (int)((double)ZoomableScrollBar.this.getMinimum() + d * (double)(ZoomableScrollBar.this.getMaximum() - ZoomableScrollBar.this.getMinimum()) - (double)(ZoomableScrollBar.this.getVisibleAmount() / 2));
                    ZoomableScrollBar.this.setValue(n);
                    ZoomableScrollBar.this.repaint();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                ZoomableScrollBar.this.dragging = false;
            }

            public void mousePressed(MouseEvent mouseEvent) {
                ZoomableScrollBar.this.dragging = ZoomableScrollBar.this.inKnob(mouseEvent.getX(), mouseEvent.getY());
            }
        });
        this.foreground = UIManager.getDefaults().getColor("ScrollBar.thumb");
        this.shadow = UIManager.getDefaults().getColor("ScrollBar.thumbDarkShadow");
        this.highlight = UIManager.getDefaults().getColor("ScrollBar.highlight");
        this.setScaleFactor(1.0);
    }

    private boolean inKnob(int n, int n2) {
        if (this.orientation == 1) {
            if (n < 0 || n > this.getWidth()) {
                return false;
            }
            if (n2 > this.knobY && (double)n2 < (double)this.knobY + (double)this.getBarHeight() / this.knobFraction) {
                return true;
            }
        }
        if (this.orientation == 0) {
            if (n2 < 0 || n2 > this.getHeight()) {
                return false;
            }
            if (n > this.knobX && (double)n < (double)this.knobX + (double)this.getBarWidth() / this.knobFraction) {
                return true;
            }
        }
        return false;
    }

    public void setValue(int n) {
        super.setValue(n);
    }

    public void setScaleFactor(double d) {
        this.scaleFactor = d;
        this.knobFraction = (double)(this.model.getMaximum() - this.model.getMinimum()) / (double)this.model.getExtent();
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public int getWidth() {
        if (this.orientation == 1) {
            return (int)((double)this.initialWidth * this.scaleFactor);
        }
        return super.getWidth();
    }

    private int getBarWidth() {
        if (this.orientation == 1) {
            return this.getWidth();
        }
        return this.getWidth() - (this.forward.getWidth() + this.back.getWidth());
    }

    public int getHeight() {
        if (this.orientation == 0) {
            return (int)((double)this.initialHeight * this.scaleFactor);
        }
        return super.getHeight();
    }

    private int getBarHeight() {
        if (this.orientation == 0) {
            return this.getHeight();
        }
        return this.getHeight() - (this.forward.getHeight() + this.back.getHeight());
    }

    public Dimension getPreferredSize() {
        return new Dimension((int)((double)this.initialWidth * this.scaleFactor), (int)((double)this.initialHeight * this.scaleFactor));
    }

    public void paintImmediately(int n, int n2, int n3, int n4) {
        super.paintImmediately(0, 0, this.getWidth(), this.getHeight());
    }

    public void paintComponent(Graphics graphics) {
        int n = this.model.getMaximum() - this.model.getMinimum();
        int n2 = 0;
        int n3 = 0;
        this.knobFraction = (double)(this.model.getMaximum() - this.model.getMinimum()) / (double)this.model.getExtent();
        if (this.orientation == 0) {
            n2 = (int)((double)this.getBarWidth() / this.knobFraction);
            n3 = this.getBarHeight();
            this.knobX = this.back.getWidth() + (int)((double)(this.model.getValue() * this.getBarWidth()) / (double)n);
        }
        if (this.orientation == 1) {
            n2 = this.getBarWidth();
            n3 = (int)((double)this.getBarHeight() / this.knobFraction);
            this.knobY = this.back.getHeight() + (int)((double)this.model.getValue() * (double)this.getBarHeight() / (double)n);
        }
        graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
        this.drawBorder(graphics, 0, 0, this.getWidth(), this.getHeight() - 1, true);
        graphics.setColor(this.foreground);
        graphics.fillRect(this.knobX, this.knobY, n2, n3);
        this.drawBorder(graphics, this.knobX, this.knobY, n2, n3, false);
        this.drawKnob(graphics, this.knobX, this.knobY, n2, n3);
    }

    private void drawBorder(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        int n5 = Math.min(3, Math.max((int)Math.rint(2.4 * this.scaleFactor), 1));
        Color color = !bl ? this.highlight : this.shadow;
        Color color2 = bl ? this.highlight : this.shadow;
        for (int i = 0; i < n5; ++i) {
            graphics.setColor(color2);
            graphics.drawLine(n + n3 - i, n2 + i, n + n3 - i, n2 + n4 - i);
            graphics.drawLine(n + i, n2 + n4 - i, n + n3 - i, n2 + n4 - i);
            graphics.setColor(color);
            graphics.drawLine(n + i, n2 + i, n + n3 - i, n2 + i);
            graphics.drawLine(n + i, n2 + i, n + i, n2 + n4 - i);
        }
    }

    private void drawKnob(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = (int)(4.0 * this.scaleFactor);
        if (n4 > n5 && n3 > n5) {
            this.drawBorder(graphics, n + (n3 - n5) / 2, n2 + (n4 - n5) / 2, n5, n5, true);
        }
    }

    private class ResizedListener
    extends ComponentAdapter {
        private ResizedListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
        }
    }

    private class ZoomableScrollButton
    extends JButton {
        public static final int BACK = 0;
        public static final int FORWARD = 1;
        private int direction;
        private int[] point1 = new int[]{-4, 4, 0};
        private int[] point2 = new int[]{-3, -3, 3};

        public ZoomableScrollButton(int n) {
            this.direction = n;
            switch (n) {
                case 0: {
                    this.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            ZoomableScrollBar.this.setValue(ZoomableScrollBar.this.getValue() - ZoomableScrollBar.this.getUnitIncrement());
                            ZoomableScrollBar.this.repaint();
                        }
                    });
                    break;
                }
                case 1: {
                    this.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            ZoomableScrollBar.this.setValue(ZoomableScrollBar.this.getValue() + ZoomableScrollBar.this.getUnitIncrement());
                            ZoomableScrollBar.this.repaint();
                        }
                    });
                }
            }
        }

        public Dimension getPreferredSize() {
            int n = (int)((double)ZoomableScrollBar.this.initialWidth * ZoomableScrollBar.this.scaleFactor);
            int n2 = (int)((double)ZoomableScrollBar.this.initialHeight * ZoomableScrollBar.this.scaleFactor);
            if (ZoomableScrollBar.this.orientation == 0 && n * 2 > ZoomableScrollBar.this.getWidth()) {
                n = ZoomableScrollBar.this.getWidth() / 2;
            }
            if (ZoomableScrollBar.this.orientation == 1 && n2 * 2 > ZoomableScrollBar.this.getHeight()) {
                n2 = ZoomableScrollBar.this.getHeight() / 2;
            }
            return new Dimension(n, n2);
        }

        public void paintComponent(Graphics graphics) {
            graphics.setColor(Color.black);
            int[] nArray = new int[3];
            int[] nArray2 = new int[3];
            double d = ZoomableScrollBar.this.initialWidth / 3;
            double d2 = ZoomableScrollBar.this.initialHeight / 3;
            int n = this.getWidth() / 2;
            int n2 = this.getHeight() / 2;
            if (this.direction == 1 && ZoomableScrollBar.this.orientation == 0) {
                nArray[0] = (int)((double)n + (double)this.point2[0] * ZoomableScrollBar.this.scaleFactor);
                nArray[1] = (int)((double)n + (double)this.point2[1] * ZoomableScrollBar.this.scaleFactor);
                nArray[2] = (int)((double)n + (double)this.point2[2] * ZoomableScrollBar.this.scaleFactor);
                nArray2[0] = (int)((double)n2 + (double)this.point1[0] * ZoomableScrollBar.this.scaleFactor);
                nArray2[1] = (int)((double)n2 + (double)this.point1[1] * ZoomableScrollBar.this.scaleFactor);
                nArray2[2] = (int)((double)n2 + (double)this.point1[2] * ZoomableScrollBar.this.scaleFactor);
            }
            if (this.direction == 0 && ZoomableScrollBar.this.orientation == 0) {
                nArray[0] = (int)((double)n - (double)this.point2[0] * ZoomableScrollBar.this.scaleFactor);
                nArray[1] = (int)((double)n - (double)this.point2[1] * ZoomableScrollBar.this.scaleFactor);
                nArray[2] = (int)((double)n - (double)this.point2[2] * ZoomableScrollBar.this.scaleFactor);
                nArray2[0] = (int)((double)n2 + (double)this.point1[0] * ZoomableScrollBar.this.scaleFactor);
                nArray2[1] = (int)((double)n2 + (double)this.point1[1] * ZoomableScrollBar.this.scaleFactor);
                nArray2[2] = (int)((double)n2 + (double)this.point1[2] * ZoomableScrollBar.this.scaleFactor);
            }
            if (this.direction == 1 && ZoomableScrollBar.this.orientation == 1) {
                nArray[0] = (int)((double)n + (double)this.point1[0] * ZoomableScrollBar.this.scaleFactor);
                nArray[1] = (int)((double)n + (double)this.point1[1] * ZoomableScrollBar.this.scaleFactor);
                nArray[2] = (int)((double)n + (double)this.point1[2] * ZoomableScrollBar.this.scaleFactor);
                nArray2[0] = (int)((double)n2 + (double)this.point2[0] * ZoomableScrollBar.this.scaleFactor);
                nArray2[1] = (int)((double)n2 + (double)this.point2[1] * ZoomableScrollBar.this.scaleFactor);
                nArray2[2] = (int)((double)n2 + (double)this.point2[2] * ZoomableScrollBar.this.scaleFactor);
            }
            if (this.direction == 0 && ZoomableScrollBar.this.orientation == 1) {
                nArray[0] = (int)((double)n + (double)this.point1[0] * ZoomableScrollBar.this.scaleFactor);
                nArray[1] = (int)((double)n + (double)this.point1[1] * ZoomableScrollBar.this.scaleFactor);
                nArray[2] = (int)((double)n + (double)this.point1[2] * ZoomableScrollBar.this.scaleFactor);
                nArray2[0] = (int)((double)n2 - (double)this.point2[0] * ZoomableScrollBar.this.scaleFactor);
                nArray2[1] = (int)((double)n2 - (double)this.point2[1] * ZoomableScrollBar.this.scaleFactor);
                nArray2[2] = (int)((double)n2 - (double)this.point2[2] * ZoomableScrollBar.this.scaleFactor);
            }
            Polygon polygon = new Polygon(nArray, nArray2, 3);
            graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
            graphics.fillPolygon(polygon);
        }
    }
}

