/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI.zoom;

import COM.hugin.HGUI.zoom.ZoomableComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class ZoomableSlider
extends JSlider
implements ZoomableComponent {
    double scaleFactor = 1.0;
    int trackWidth;
    int pointerWidth;
    int pointerHeight;
    int trackMargin;
    int endTrackMargin;
    int tickWidth;
    int tickMargin;
    int scaledEndTrackMargin;
    int scaledTrackMargin;
    int scaledTrackWidth;
    int scaledPointerWidth;
    int scaledPointerHeight;
    int scaledEndMargin;
    int scaledTickWidth;
    int scaledTickMargin;
    Color foreground;
    Color background;
    Color shadow;
    Color highlight;
    Border track;
    Border pointerBorder;
    boolean dragging = false;

    public ZoomableSlider() {
        this.setDefaults();
    }

    public ZoomableSlider(BoundedRangeModel boundedRangeModel) {
        super(boundedRangeModel);
        this.setDefaults();
    }

    public ZoomableSlider(int n) {
        super(n);
        this.setDefaults();
    }

    public ZoomableSlider(int n, int n2) {
        super(n, n2);
        this.setDefaults();
    }

    public ZoomableSlider(int n, int n2, int n3) {
        super(n, n2, n3);
        this.setDefaults();
    }

    public ZoomableSlider(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.setDefaults();
    }

    private void setDefaults() {
        this.trackWidth = UIManager.getDefaults().getInt("Slider.trackWidth");
        this.pointerWidth = 14;
        this.pointerHeight = 10;
        this.trackMargin = (this.pointerWidth - this.trackWidth) / 2;
        this.endTrackMargin = this.pointerHeight / 2;
        this.tickWidth = this.pointerWidth / 2;
        this.tickMargin = 2;
        this.foreground = UIManager.getDefaults().getColor("Slider.foreground");
        this.background = UIManager.getDefaults().getColor("Slider.background");
        this.shadow = UIManager.getDefaults().getColor("Slider.shadow");
        this.highlight = UIManager.getDefaults().getColor("Slider.highlight");
        this.track = BorderFactory.createEtchedBorder();
        this.pointerBorder = BorderFactory.createRaisedBevelBorder();
        this.setScaleFactor(this.scaleFactor);
        EventListener[] eventListenerArray = this.getListeners(MouseMotionListener.class);
        this.removeMouseMotionListener((MouseMotionListener)eventListenerArray[0]);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                if (ZoomableSlider.this.inKnob(mouseEvent.getX(), mouseEvent.getY()) || ZoomableSlider.this.dragging) {
                    ZoomableSlider.this.dragging = true;
                    if (ZoomableSlider.this.orientation == 0) {
                        int n = (int)(((double)mouseEvent.getX() - (double)ZoomableSlider.this.scaledEndMargin) / (double)(ZoomableSlider.this.getWidth() - ZoomableSlider.this.scaledEndMargin * 2) * (double)(ZoomableSlider.this.getMaximum() - ZoomableSlider.this.getMinimum()) + (double)ZoomableSlider.this.getMinimum());
                        ZoomableSlider.this.setValue(n);
                    } else {
                        int n = (int)(((double)mouseEvent.getY() - (double)ZoomableSlider.this.scaledEndMargin) / (double)(ZoomableSlider.this.getHeight() - ZoomableSlider.this.scaledEndMargin * 2) * (double)(ZoomableSlider.this.getMaximum() - ZoomableSlider.this.getMinimum()) + (double)ZoomableSlider.this.getMinimum());
                        ZoomableSlider.this.setValue(ZoomableSlider.this.getMaximum() - n);
                    }
                    ZoomableSlider.this.repaint();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                ZoomableSlider.this.dragging = false;
            }

            public void mousePressed(MouseEvent mouseEvent) {
                ZoomableSlider.this.dragging = ZoomableSlider.this.inKnob(mouseEvent.getX(), mouseEvent.getY());
            }
        });
    }

    private boolean inKnob(int n, int n2) {
        int n3;
        n2 = this.getHeight() - n2;
        n = this.getWidth() - n;
        if (this.orientation == 1) {
            if (n < 0 || n > this.getWidth()) {
                return false;
            }
            n3 = (int)((double)this.getHeight() * (double)(this.getValue() - this.getMinimum()) / (double)(this.getMaximum() - this.getMinimum()));
            if (n2 > n3 - this.scaledPointerHeight && n2 < n3 + this.scaledPointerHeight) {
                return true;
            }
        }
        if (this.orientation == 0) {
            if (n2 < 0 || n2 > this.getHeight()) {
                return false;
            }
            n3 = this.getWidth() - (int)((double)this.getWidth() * (double)(this.getValue() - this.getMinimum()) / (double)(this.getMaximum() - this.getMinimum()));
            if (n > n3 - this.scaledPointerHeight && n < n3 + this.scaledPointerHeight) {
                return true;
            }
        }
        return false;
    }

    public void setScaleFactor(double d) {
        this.scaleFactor = d;
        this.scaledEndTrackMargin = (int)((double)this.endTrackMargin * d);
        this.scaledTrackMargin = (int)((double)this.trackMargin * d);
        this.scaledTrackWidth = (int)((double)this.trackWidth * d);
        this.scaledPointerWidth = (int)((double)this.pointerWidth * d);
        this.scaledPointerHeight = (int)((double)this.pointerHeight * d);
        this.scaledEndMargin = this.scaledEndTrackMargin;
        this.scaledTickMargin = (int)((double)this.tickMargin * d);
        this.scaledTickWidth = (int)((double)this.tickWidth * d);
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public int getWidth() {
        if (this.orientation == 0) {
            return super.getPreferredSize().width;
        }
        return (int)((double)(this.pointerWidth + (this.getPaintTicks() ? this.tickWidth + this.tickMargin : 0)) * this.scaleFactor);
    }

    public int getHeight() {
        if (this.orientation == 1) {
            return super.getPreferredSize().height;
        }
        return (int)((double)(this.pointerWidth + (this.getPaintTicks() ? this.tickWidth + this.tickMargin : 0)) * this.scaleFactor);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public void paintImmediately(int n, int n2, int n3, int n4) {
        super.paintImmediately(0, 0, this.getWidth(), this.getHeight());
    }

    public void paintComponent(Graphics graphics) {
        if (this.orientation == 0) {
            this.paintHorizontalSlider(graphics);
        }
        if (this.orientation == 1) {
            this.paintVerticalSlider(graphics);
        }
    }

    private void paintHorizontalSlider(Graphics graphics) {
        int n = this.getHeight();
        int n2 = this.getWidth() - this.scaledEndMargin * 2;
        graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
        double d = (double)this.getValue() / (double)(this.getMaximum() - this.getMinimum());
        int n3 = (int)((double)n2 * d);
        this.track.paintBorder(this, graphics, this.scaledEndTrackMargin, n - this.scaledTrackMargin - this.scaledTrackWidth, this.getWidth() - this.scaledEndTrackMargin * 2, this.scaledTrackWidth);
        graphics.setColor(this.foreground);
        graphics.fillRect(this.scaledEndMargin + (n3 -= this.scaledPointerHeight / 2), n - this.scaledPointerWidth, this.scaledPointerHeight, this.scaledPointerWidth);
        this.pointerBorder.paintBorder(this, graphics, this.scaledEndMargin + n3, n - this.scaledPointerWidth, this.scaledPointerHeight, this.scaledPointerWidth);
        if (this.getPaintTicks()) {
            graphics.setColor(this.shadow);
            for (int i = 0; i < 2; ++i) {
                int n4;
                int n5 = i == 0 ? this.getMajorTickSpacing() : this.getMinorTickSpacing();
                int n6 = n4 = i == 0 ? this.scaledTickWidth : this.scaledTickWidth / 2;
                for (int j = this.getMinimum(); n5 > 0 && j <= this.getMaximum(); j += n5) {
                    d = (double)j / (double)(this.getMaximum() - this.getMinimum());
                    n3 = (int)((double)n2 * d);
                    graphics.drawLine(n3 += this.scaledEndMargin, 0, n3, n4);
                }
            }
        }
    }

    private void paintVerticalSlider(Graphics graphics) {
        int n = 0;
        int n2 = this.getHeight() - this.scaledEndMargin * 2;
        graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
        double d = (double)this.getValue() / (double)(this.getMaximum() - this.getMinimum());
        int n3 = n2 - (int)((double)n2 * d);
        this.track.paintBorder(this, graphics, this.scaledTrackMargin, this.scaledEndTrackMargin, this.scaledTrackWidth, this.getHeight() - this.scaledEndTrackMargin * 2);
        graphics.setColor(this.foreground);
        graphics.fillRect(n, this.scaledEndMargin + (n3 -= this.scaledPointerHeight / 2), this.scaledPointerWidth, this.scaledPointerHeight);
        this.pointerBorder.paintBorder(this, graphics, n, this.scaledEndMargin + n3, this.scaledPointerWidth, this.scaledPointerHeight);
        if (this.getPaintTicks()) {
            graphics.setColor(this.shadow);
            for (int i = 0; i < 2; ++i) {
                int n4;
                int n5 = i == 0 ? this.getMajorTickSpacing() : this.getMinorTickSpacing();
                int n6 = n4 = i == 0 ? 0 : this.scaledTickWidth / 2;
                for (int j = this.getMinimum(); n5 > 0 && j <= this.getMaximum(); j += n5) {
                    d = (double)j / (double)(this.getMaximum() - this.getMinimum());
                    n3 = n2 - (int)((double)n2 * d);
                    graphics.drawLine(n + this.scaledPointerWidth + this.scaledTickMargin + n4, n3 += this.scaledEndMargin, n + this.scaledPointerWidth + this.scaledTickMargin + this.scaledTickWidth, n3);
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.setPreferredSize(new Dimension(400, 400));
        jPanel.setBorder(BorderFactory.createEtchedBorder(1));
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add(jPanel);
        ZoomableSlider zoomableSlider = new ZoomableSlider(1);
        zoomableSlider.setMajorTickSpacing(20);
        zoomableSlider.setMinorTickSpacing(4);
        zoomableSlider.setPaintTicks(true);
        jFrame.getContentPane().add((Component)zoomableSlider, "West");
        ZoomableSlider zoomableSlider2 = new ZoomableSlider(0);
        zoomableSlider2.setMajorTickSpacing(20);
        zoomableSlider2.setMinorTickSpacing(4);
        zoomableSlider2.setPaintTicks(true);
        jFrame.getContentPane().add((Component)zoomableSlider2, "South");
        jFrame.setSize(200, 200);
        jFrame.setLocation(200, 200);
        jFrame.setVisible(true);
    }
}

