/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.REPORTDESIGNER;

import COM.hugin.MODEL.DiscreteNode;
import COM.hugin.MODEL.Network;
import COM.hugin.MODEL.Node;
import COM.hugin.REPORT.AutoField;
import COM.hugin.REPORT.DynamicLine;
import COM.hugin.REPORT.Report;
import COM.hugin.REPORT.ReportElement;
import COM.hugin.REPORT.Section;
import COM.hugin.REPORT.SpringUtilities;
import COM.hugin.REPORT.Table;
import COM.hugin.REPORT.TextLabel;
import COM.hugin.REPORT.UserInput;
import COM.hugin.REPORTDESIGNER.DesignerTools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportDesigner
extends JFrame {
    private static final String STR_COURIER = "Courier";
    private static final String STR_HELVETICA = "Helvetica";
    private static final String STR_TIMES_NEW = "Times New";
    private static final String STR_BIG = "Big";
    private static final String STR_MEDIUM = "Medium";
    private static final String STR_SMALL = "Small";
    private static final String STR_LEFT = "Left";
    private static final String STR_CENTER = "Center";
    private static final String STR_RIGHT = "Right";
    private static final int TOOL_SELECTION = 0;
    private static final int TOOL_DELETE = 1;
    private static final int TOOL_MOVE = 2;
    private static final int TOOL_TEXTLABEL = 3;
    private static final int TOOL_USERINPUT = 4;
    private static final int TOOL_AUTO = 5;
    private static final int TOOL_TABLE = 6;
    private static final int TOOL_SECTION = 7;
    private static final Dimension BUTTONSIZE = new Dimension(32, 32);
    private AbstractButton selectTool;
    private AbstractButton deleteTool;
    private AbstractButton moveTool;
    private AbstractButton textLabelTool;
    private AbstractButton userInputTool;
    private AbstractButton autoFieldTool;
    private AbstractButton tableTool;
    private AbstractButton sectionTool;
    private JFrame reportDesignerFrame;
    private JFrame owner;
    private Runnable callBack;
    private Network net;
    private int activeTool;
    private JPanel contentPane;
    private JPanel reportPanel;
    private JPanel reportSelectorPanel;
    private JPanel toolsPanel;
    private JPanel statusPanel;
    private JLabel statusText;
    private JScrollPane reportScroller;
    private Vector<Report> reports;
    private Report report;
    private boolean disposed = false;
    private Properties curProperties = null;
    private Point propertiesPosition = null;
    private JComponent selectedComponent = null;
    private Color selectedComponentOldBackColor = null;
    private Color moveComponentOldBackColor = null;
    private JComponent glassPane;
    private ReportElement moveElement = null;
    private ImageIcon selectToolIcon = DesignerTools.createImageIcon("COM/hugin/REPORTDESIGNER/images/selectTool.gif");
    private ImageIcon deleteToolIcon = DesignerTools.createImageIcon("COM/hugin/REPORTDESIGNER/images/deleteTool.gif");
    private ImageIcon moveToolIcon = DesignerTools.createImageIcon("COM/hugin/REPORTDESIGNER/images/moveTool.gif");
    private ImageIcon tableToolIcon = DesignerTools.createImageIcon("COM/hugin/REPORTDESIGNER/images/tableTool.gif");
    private ImageIcon textLabelToolIcon = DesignerTools.createImageIcon("COM/hugin/REPORTDESIGNER/images/textLabelTool.gif");
    private ImageIcon userInputToolIcon = DesignerTools.createImageIcon("COM/hugin/REPORTDESIGNER/images/userInputTool.gif");
    private ImageIcon autoToolIcon = DesignerTools.createImageIcon("COM/hugin/REPORTDESIGNER/images/autoTool.gif");
    private ImageIcon sectionToolIcon = DesignerTools.createImageIcon("COM/hugin/REPORTDESIGNER/images/sectionTool.gif");
    private ImageIcon upSmall = DesignerTools.createImageIcon("COM/hugin/REPORTDESIGNER/images/upSmall.gif");
    private ImageIcon downSmall = DesignerTools.createImageIcon("COM/hugin/REPORTDESIGNER/images/downSmall.gif");
    private ImageIcon delSmall = DesignerTools.createImageIcon("COM/hugin/REPORTDESIGNER/images/delSmall.gif");

    public ReportDesigner(JFrame jFrame, Runnable runnable, Network network, Vector<Report> vector) {
        this.reportDesignerFrame = this;
        this.owner = jFrame;
        this.callBack = runnable;
        if (this.owner != null) {
            this.owner.setEnabled(false);
        }
        this.net = network;
        this.reports = vector;
        this.setDefaultCloseOperation(2);
        this.setSize(800, 600);
        this.setPreferredSize(this.getSize());
        this.initialize(this.reports.firstElement());
    }

    private void initialize(Report report) {
        this.report = report;
        if (this.contentPane != null) {
            this.contentPane.removeAll();
        }
        this.contentPane = new JPanel(new BorderLayout());
        this.setContentPane(this.contentPane);
        this.createReportSelectorPanel();
        this.contentPane.add((Component)this.reportSelectorPanel, "North");
        this.createReportPanel(this.report);
        this.contentPane.add((Component)this.reportPanel, STR_CENTER);
        this.createStatusPanel();
        this.contentPane.add((Component)this.statusPanel, "South");
        this.createToolsPanel();
        this.contentPane.add((Component)this.toolsPanel, "West");
        this.createGlassPane();
        this.selectTool.doClick();
    }

    private void createReportSelectorPanel() {
        Serializable serializable;
        this.reportSelectorPanel = new JPanel();
        this.reportSelectorPanel.setBackground(Color.WHITE);
        String[] stringArray = new String[this.reports.size() + 1];
        int n = 0;
        for (int i = 0; i < this.reports.size(); ++i) {
            stringArray[i] = this.reports.elementAt(i).getName();
            if (this.report != this.reports.elementAt(i)) continue;
            n = i;
        }
        stringArray[stringArray.length - 1] = "<Create new>";
        final JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setSelectedIndex(n);
        jComboBox.setLightWeightPopupEnabled(false);
        try {
            serializable = Class.forName("javax.swing.PopupFactory");
            Field field = ((Class)serializable).getDeclaredField("forceHeavyWeightPopupKey");
            field.setAccessible(true);
            jComboBox.putClientProperty(field.get(null), Boolean.TRUE);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportDesigner.this.disposeCurProperties();
                ReportDesigner.this.selectTool.doClick();
                int n = jComboBox.getSelectedIndex();
                System.out.println("Selected index " + n);
                if (n < ReportDesigner.this.reports.size()) {
                    ReportDesigner.this.initialize((Report)ReportDesigner.this.reports.elementAt(n));
                } else {
                    Report report = new Report("new report");
                    ReportDesigner.this.setReportName(report, "new report");
                    ReportDesigner.this.reports.add(report);
                    ReportDesigner.this.initialize((Report)ReportDesigner.this.reports.lastElement());
                }
            }
        });
        this.reportSelectorPanel.add(jComboBox);
        serializable = new JButton("Delete");
        ((AbstractButton)serializable).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportDesigner.this.reports.remove(ReportDesigner.this.report);
                if (ReportDesigner.this.reports.size() == 0) {
                    ReportDesigner.this.reports.add(new Report("new report"));
                }
                ReportDesigner.this.initialize((Report)ReportDesigner.this.reports.firstElement());
            }
        });
        this.reportSelectorPanel.add((Component)serializable);
    }

    private void setReportName(Report report, String string) {
        if (string.length() == 0) {
            string = "unnamed";
        }
        boolean bl = true;
        int n = 1;
        String string2 = string;
        while (bl) {
            bl = false;
            for (Report report2 : this.reports) {
                if (report2 == report) continue;
                bl = bl || report2.getName().equals(string2);
            }
            if (!bl) continue;
            string2 = string + n++;
        }
        report.setName(string2);
    }

    private void createReportPanel(Report report) {
        this.reportPanel = new JPanel(new GridLayout(1, 1));
        this.reportScroller = new JScrollPane(report, 22, 31);
        this.reportScroller.getViewport().setBackground(Color.LIGHT_GRAY);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(Color.LIGHT_GRAY);
        jPanel.add((Component)this.reportScroller, "West");
        jPanel.add((Component)this.reportScroller.getVerticalScrollBar(), "East");
        this.reportScroller.setBorder(null);
        this.reportPanel.add(jPanel);
    }

    private void createStatusPanel() {
        this.statusPanel = new JPanel();
        this.statusPanel.setBackground(Color.WHITE);
        this.statusText = new JLabel("");
        this.statusPanel.add(this.statusText);
    }

    private void writeStatus(String string) {
        this.statusText.setText(string);
        this.statusPanel.validate();
    }

    private void createGlassPane() {
        this.glassPane = new JComponent(){

            protected void paintComponent(Graphics graphics) {
            }
        };
        this.setGlassPane(this.glassPane);
        this.glassPane.setVisible(true);
        this.glassPane.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ReportDesigner.this.redispatchMouseEvent(mouseEvent);
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                ReportDesigner.this.redispatchMouseEvent(mouseEvent);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                ReportDesigner.this.redispatchMouseEvent(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                ReportDesigner.this.redispatchMouseEvent(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                ReportDesigner.this.redispatchMouseEvent(mouseEvent);
            }
        });
        this.glassPane.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                ReportDesigner.this.redispatchMouseEvent(mouseEvent);
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                ReportDesigner.this.redispatchMouseEvent(mouseEvent);
            }
        });
    }

    private void createToolsPanel() {
        ButtonGroup buttonGroup = new ButtonGroup();
        this.toolsPanel = new JPanel(new SpringLayout());
        this.selectTool = new JToggleButton(this.selectToolIcon);
        this.initializeToolButton(this.selectTool);
        this.selectTool.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportDesigner.this.activeTool = 0;
                ReportDesigner.this.writeStatus("Edit item");
            }
        });
        this.toolsPanel.add(this.selectTool);
        buttonGroup.add(this.selectTool);
        this.moveTool = new JToggleButton(this.moveToolIcon);
        this.initializeToolButton(this.moveTool);
        this.moveTool.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportDesigner.this.activeTool = 2;
                ReportDesigner.this.writeStatus("Move items");
                ReportDesigner.this.disposeCurProperties();
            }
        });
        this.toolsPanel.add(this.moveTool);
        buttonGroup.add(this.moveTool);
        this.deleteTool = new JToggleButton(this.deleteToolIcon);
        this.initializeToolButton(this.deleteTool);
        this.deleteTool.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportDesigner.this.activeTool = 1;
                ReportDesigner.this.writeStatus("Delete items");
                ReportDesigner.this.disposeCurProperties();
            }
        });
        this.toolsPanel.add(this.deleteTool);
        buttonGroup.add(this.deleteTool);
        this.textLabelTool = new JToggleButton(this.textLabelToolIcon);
        this.initializeToolButton(this.textLabelTool);
        this.textLabelTool.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportDesigner.this.activeTool = 3;
                ReportDesigner.this.writeStatus("Add text label");
                ReportDesigner.this.disposeCurProperties();
            }
        });
        this.toolsPanel.add(this.textLabelTool);
        buttonGroup.add(this.textLabelTool);
        this.userInputTool = new JToggleButton(this.userInputToolIcon);
        this.initializeToolButton(this.userInputTool);
        this.userInputTool.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportDesigner.this.activeTool = 4;
                ReportDesigner.this.writeStatus("Add label that present text which the user must enter");
                ReportDesigner.this.disposeCurProperties();
            }
        });
        this.toolsPanel.add(this.userInputTool);
        buttonGroup.add(this.userInputTool);
        this.autoFieldTool = new JToggleButton(this.autoToolIcon);
        this.initializeToolButton(this.autoFieldTool);
        this.autoFieldTool.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportDesigner.this.activeTool = 5;
                ReportDesigner.this.writeStatus("Add label that contains autogenerated content (such as date, PDF file name etc.)");
                ReportDesigner.this.disposeCurProperties();
            }
        });
        this.toolsPanel.add(this.autoFieldTool);
        buttonGroup.add(this.autoFieldTool);
        this.tableTool = new JToggleButton(this.tableToolIcon);
        this.initializeToolButton(this.tableTool);
        this.tableTool.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportDesigner.this.activeTool = 6;
                ReportDesigner.this.writeStatus("Add table");
                ReportDesigner.this.disposeCurProperties();
            }
        });
        this.toolsPanel.add(this.tableTool);
        buttonGroup.add(this.tableTool);
        this.sectionTool = new JToggleButton(this.sectionToolIcon);
        this.initializeToolButton(this.sectionTool);
        this.sectionTool.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportDesigner.this.activeTool = 7;
                ReportDesigner.this.writeStatus("Add section that presents results based on user provided data");
                ReportDesigner.this.disposeCurProperties();
            }
        });
        this.toolsPanel.add(this.sectionTool);
        buttonGroup.add(this.sectionTool);
        this.toolsPanel.setBackground(Color.WHITE);
        SpringUtilities.makeCompactGrid(this.toolsPanel, 8, 1, 1, 1, 1, 1);
    }

    @Override
    public synchronized void dispose() {
        if (!this.disposed) {
            if (this.callBack != null) {
                this.callBack.run();
            }
            if (this.owner != null) {
                this.setVisible(false);
                this.owner.setEnabled(true);
                this.owner.toFront();
            }
            this.disposed = true;
            super.dispose();
        }
    }

    private void initializeToolButton(AbstractButton abstractButton) {
        abstractButton.setMaximumSize(BUTTONSIZE);
        abstractButton.setPreferredSize(BUTTONSIZE);
    }

    private boolean isContainedIn(ReportElement reportElement, ReportElement reportElement2) {
        boolean bl = false;
        for (ReportElement reportElement3 = reportElement2; reportElement3 != null; reportElement3 = reportElement3.getReportParent()) {
            if (reportElement != reportElement3) continue;
            bl = true;
        }
        return bl;
    }

    private boolean switchPlaces(ReportElement reportElement, ReportElement reportElement2, boolean bl) {
        if (reportElement == null || reportElement2 == null) {
            return false;
        }
        if (this.isContainedIn(reportElement, reportElement2) || this.isContainedIn(reportElement2, reportElement)) {
            return false;
        }
        ReportElement reportElement3 = reportElement.getReportParent();
        ReportElement reportElement4 = reportElement2.getReportParent();
        for (Section section : this.report.getSections()) {
            if (section.getDescription() == reportElement) {
                reportElement3 = section;
            }
            if (section.getDescription() != reportElement2) continue;
            reportElement4 = section;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        int n2 = 0;
        if (this.report.getFooter() == reportElement) {
            reportElement3 = this.report;
        }
        if (this.report.getHeader() == reportElement) {
            reportElement3 = this.report;
            bl2 = true;
        }
        if (this.report.getFooter() == reportElement2) {
            reportElement4 = this.report;
        }
        if (this.report.getHeader() == reportElement2) {
            reportElement4 = this.report;
            bl3 = true;
        }
        if (reportElement3 instanceof Table) {
            n = ((Table)reportElement3).getIndex(reportElement);
        }
        if (reportElement4 instanceof Table) {
            n2 = ((Table)reportElement4).getIndex(reportElement2);
        }
        if (reportElement3 != null && reportElement4 != null) {
            if (reportElement instanceof Table && reportElement2 instanceof Table || (reportElement instanceof Table.EmptyCell || reportElement instanceof TextLabel) && reportElement4 instanceof Table || (reportElement2 instanceof Table.EmptyCell || reportElement2 instanceof TextLabel) && reportElement3 instanceof Table) {
                if (bl) {
                    return true;
                }
                if (reportElement3 instanceof Report && bl2) {
                    this.report.setHeader(reportElement2);
                } else if (reportElement3 instanceof Report && !bl2) {
                    this.report.setFooter(reportElement2);
                } else if (reportElement3 instanceof Section) {
                    ((Section)reportElement3).setDescription(reportElement2);
                } else if (reportElement3 instanceof Table) {
                    ((Table)reportElement3).setReportElement(reportElement2, n);
                } else {
                    System.out.println("Error moving");
                }
                if (reportElement4 instanceof Report && bl3) {
                    this.report.setHeader(reportElement);
                } else if (reportElement4 instanceof Report && !bl3) {
                    this.report.setFooter(reportElement);
                } else if (reportElement4 instanceof Section) {
                    ((Section)reportElement4).setDescription(reportElement);
                } else if (reportElement4 instanceof Table) {
                    ((Table)reportElement4).setReportElement(reportElement, n2);
                } else {
                    System.out.println("Error moving");
                }
                return true;
            }
            if (reportElement instanceof Section && reportElement2 instanceof Section) {
                if (bl) {
                    return true;
                }
                ArrayList<Section> arrayList = this.report.getSections();
                int n3 = arrayList.indexOf(reportElement2);
                this.report.removeSection((Section)reportElement2);
                int n4 = arrayList.indexOf(reportElement);
                this.report.removeSection((Section)reportElement);
                this.report.addSection((Section)reportElement2, n4);
                this.report.addSection((Section)reportElement, n3);
                return true;
            }
        }
        return false;
    }

    private void redispatchMouseEvent(MouseEvent mouseEvent) {
        block53: {
            JComponent jComponent;
            Point point;
            block52: {
                Container container = this.getContentPane();
                Point point2 = SwingUtilities.convertPoint(this.glassPane, mouseEvent.getPoint(), container);
                point = mouseEvent.getPoint();
                SwingUtilities.convertPointToScreen(point, this.glassPane);
                Component component = SwingUtilities.getDeepestComponentAt(container, point2.x, point2.y);
                jComponent = this.getReportComponent(component);
                if (component == null || jComponent != null) break block52;
                if (this.selectedComponent != null) {
                    this.selectedComponent.setBackground(this.selectedComponentOldBackColor);
                    this.selectedComponent = null;
                    this.report.repaint();
                }
                Point point3 = SwingUtilities.convertPoint(this.glassPane, mouseEvent.getPoint(), component);
                component.dispatchEvent(new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point3.x, point3.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
                break block53;
            }
            if (jComponent == null) break block53;
            ReportElement reportElement = jComponent instanceof ReportElement ? (ReportElement)jComponent : null;
            block0 : switch (mouseEvent.getID()) {
                case 506: {
                    if (this.activeTool == 2) {
                        if (this.selectedComponent != null) {
                            this.selectedComponent.setBackground(this.selectedComponentOldBackColor);
                        }
                        if (!this.switchPlaces(this.moveElement, reportElement, true)) break;
                        this.selectedComponent = jComponent;
                        this.selectedComponentOldBackColor = jComponent.getBackground();
                        this.selectedComponent.setBackground(Color.GRAY);
                        this.moveElement.setBackground(Color.GRAY);
                        this.report.repaint();
                        break;
                    }
                }
                case 503: {
                    if (this.selectedComponent != null) {
                        this.selectedComponent.setBackground(this.selectedComponentOldBackColor);
                    }
                    this.selectedComponent = jComponent;
                    this.selectedComponentOldBackColor = jComponent.getBackground();
                    this.selectedComponent.setBackground(Color.GRAY);
                    this.report.repaint();
                    break;
                }
                case 501: {
                    switch (this.activeTool) {
                        case 2: {
                            if (!(reportElement instanceof Section) && !(reportElement instanceof Table.EmptyCell) && !(reportElement instanceof Table) && !(reportElement instanceof TextLabel)) break;
                            this.moveElement = reportElement;
                            this.moveComponentOldBackColor = this.selectedComponentOldBackColor;
                        }
                    }
                    break;
                }
                case 502: {
                    switch (this.activeTool) {
                        case 2: {
                            if (this.moveElement != null && reportElement != null) {
                                this.switchPlaces(this.moveElement, reportElement, false);
                                this.selectedComponent.setBackground(this.selectedComponentOldBackColor);
                                this.moveElement.setBackground(this.moveComponentOldBackColor);
                                this.redoLayout();
                            }
                            this.moveElement = null;
                        }
                    }
                    break;
                }
                case 500: {
                    switch (this.activeTool) {
                        case 0: {
                            if (jComponent instanceof Report) {
                                this.showProperties((Report)jComponent);
                                break block0;
                            }
                            if (jComponent instanceof Table) {
                                this.showProperties((Table)jComponent);
                                break block0;
                            }
                            if (jComponent instanceof UserInput) {
                                this.showProperties((UserInput)jComponent);
                                break block0;
                            }
                            if (jComponent instanceof AutoField) {
                                this.showProperties((AutoField)jComponent);
                                break block0;
                            }
                            if (jComponent instanceof TextLabel) {
                                this.showProperties((TextLabel)jComponent);
                                break block0;
                            }
                            if (jComponent instanceof Section) {
                                this.showProperties((Section)jComponent);
                                break block0;
                            }
                            if (jComponent instanceof DynamicLine) {
                                this.showProperties((DynamicLine)jComponent);
                                break block0;
                            }
                            this.disposeCurProperties();
                            break block0;
                        }
                        case 1: {
                            if (reportElement instanceof TextLabel || reportElement instanceof Section || reportElement instanceof Table) {
                                this.deleteChild(reportElement.getReportParent(), reportElement);
                                break block0;
                            }
                            break block53;
                        }
                        case 3: {
                            if (reportElement instanceof Table.EmptyCell) {
                                Table.EmptyCell emptyCell = (Table.EmptyCell)reportElement;
                                Table table = (Table)emptyCell.getReportParent();
                                int n = table.getContents().indexOf(emptyCell);
                                if (n >= 0) {
                                    TextLabel textLabel = new TextLabel("Text label", 2, 12);
                                    table.setReportElement(textLabel, n);
                                    this.showProperties(textLabel);
                                }
                                this.redoLayout();
                                break block0;
                            }
                            break block53;
                        }
                        case 4: {
                            if (reportElement instanceof Table.EmptyCell) {
                                Table.EmptyCell emptyCell = (Table.EmptyCell)reportElement;
                                Table table = (Table)emptyCell.getReportParent();
                                int n = table.getContents().indexOf(emptyCell);
                                if (n >= 0) {
                                    UserInput userInput = new UserInput("INPUT", 2, 12);
                                    table.setReportElement(userInput, n);
                                    this.showProperties(userInput);
                                }
                                this.redoLayout();
                                break block0;
                            }
                            break block53;
                        }
                        case 5: {
                            if (reportElement instanceof Table.EmptyCell) {
                                Table.EmptyCell emptyCell = (Table.EmptyCell)reportElement;
                                Table table = (Table)emptyCell.getReportParent();
                                int n = table.getContents().indexOf(emptyCell);
                                if (n >= 0) {
                                    AutoField autoField = new AutoField(0, 2, 12);
                                    table.setReportElement(autoField, n);
                                    this.showProperties(autoField);
                                }
                                this.redoLayout();
                                break block0;
                            }
                            break block53;
                        }
                        case 6: {
                            Section section;
                            if (reportElement instanceof Table.EmptyCell) {
                                Table.EmptyCell emptyCell = (Table.EmptyCell)reportElement;
                                Table table = (Table)emptyCell.getReportParent();
                                int n = table.getContents().indexOf(emptyCell);
                                if (n >= 0) {
                                    Table table2 = new Table(1, 1);
                                    table.setReportElement(table2, n);
                                    this.showProperties(table2);
                                }
                                this.redoLayout();
                            } else if (reportElement instanceof Report) {
                                Report report = (Report)reportElement;
                                if (this.pointNearestTopOfComponent(report, point)) {
                                    if (report.getHeader() == null) {
                                        Table table = new Table(1, 1);
                                        report.setHeader(table);
                                        this.showProperties(table);
                                    }
                                } else if (report.getFooter() == null) {
                                    Table table = new Table(1, 1);
                                    report.setFooter(table);
                                    this.showProperties(table);
                                }
                            } else if (reportElement instanceof Section && (section = (Section)reportElement).getDescription() == null) {
                                Table table = new Table(1, 1);
                                section.setDescription(table);
                                this.showProperties(table);
                            }
                            this.redoLayout();
                            break block0;
                        }
                        case 7: {
                            if (reportElement instanceof Report) {
                                Report report = (Report)reportElement;
                                Section section = new Section();
                                section.setLine(new DynamicLine());
                                report.addSection(section);
                                this.showProperties(section);
                            }
                            this.redoLayout();
                        }
                    }
                }
            }
        }
    }

    private boolean pointNearestTopOfComponent(JComponent jComponent, Point point) {
        Dimension dimension = jComponent.getSize();
        Point point2 = jComponent.getLocationOnScreen();
        return Math.abs(point2.y - point.y) < Math.abs(point2.y + dimension.height - point.y);
    }

    private void deleteChild(ReportElement reportElement, ReportElement reportElement2) {
        if (reportElement == null || reportElement2 == null) {
            return;
        }
        if (reportElement instanceof Table) {
            Table table = (Table)reportElement;
            table.removeReportElement(reportElement2);
        } else if (reportElement instanceof Report && reportElement2 instanceof Section) {
            Report report = (Report)reportElement;
            report.removeSection((Section)reportElement2);
        } else if (reportElement instanceof Report && reportElement2 instanceof Table) {
            Report report = (Report)reportElement;
            if (report.getHeader() == reportElement2) {
                report.setHeader(null);
            } else if (report.getFooter() == reportElement2) {
                report.setFooter(null);
            }
        } else if (reportElement instanceof Section) {
            Section section = (Section)reportElement;
            if (section.getDescription() == reportElement2) {
                section.setDescription(null);
            } else if (section.getLine() == reportElement2) {
                section.setLine(null);
            }
        }
        this.redoLayout();
    }

    private JComponent getReportComponent(Component component) {
        if (!(component instanceof Container)) {
            return null;
        }
        LinkedList<Container> linkedList = new LinkedList<Container>();
        LinkedList<Container> linkedList2 = new LinkedList<Container>();
        linkedList.add((Container)component);
        while (linkedList.size() > 0) {
            linkedList2.addAll(linkedList);
            linkedList.clear();
            for (Container container : linkedList2) {
                Container container2 = container.getParent();
                if (container2 != null) {
                    linkedList.add(container2);
                }
                if (!(container instanceof Report) && !(container instanceof ReportElement)) continue;
                return (JComponent)container;
            }
            linkedList2.clear();
        }
        return null;
    }

    private void disposeCurProperties() {
        if (this.curProperties != null) {
            this.curProperties.dispose();
        }
    }

    private void showProperties(Report report) {
        this.selectTool.doClick();
        this.disposeCurProperties();
        this.curProperties = new ReportProperties(report);
        this.curProperties.setVisible(true);
    }

    private void showProperties(Table table) {
        this.selectTool.doClick();
        this.disposeCurProperties();
        this.curProperties = new TableProperties(table);
        this.curProperties.setVisible(true);
    }

    private void showProperties(TextLabel textLabel) {
        this.selectTool.doClick();
        this.disposeCurProperties();
        this.curProperties = new TextLabelProperties(textLabel);
        this.curProperties.setVisible(true);
    }

    public void showProperties(Section section) {
        this.selectTool.doClick();
        this.disposeCurProperties();
        this.curProperties = new SectionProperties(section);
        this.curProperties.setVisible(true);
    }

    public void showProperties(DynamicLine dynamicLine) {
        this.selectTool.doClick();
        this.disposeCurProperties();
        this.curProperties = new DynamicLineProperties(dynamicLine);
        this.curProperties.setVisible(true);
    }

    public void showProperties(UserInput userInput) {
        this.selectTool.doClick();
        this.disposeCurProperties();
        this.curProperties = new UserInputProperties(userInput);
        this.curProperties.setVisible(true);
    }

    public void showProperties(AutoField autoField) {
        this.selectTool.doClick();
        this.disposeCurProperties();
        this.curProperties = new AutoFieldProperties(autoField);
        this.curProperties.setVisible(true);
    }

    private void redoLayout() {
        this.reportScroller.validate();
        this.reportScroller.repaint();
    }

    private class ReportProperties
    extends Properties {
        private Report report;
        private JRadioButton deleteHeader;
        private JRadioButton createHeader;
        private JRadioButton createFooter;
        private JRadioButton deleteFooter;
        private JTextField name;
        private JComboBox pageSize;

        public ReportProperties(Report report) {
            super("Report Properties");
            this.report = report;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            this.propertiesPanel.add(new JLabel("Name"));
            this.name = new JTextField(this.report.getName(), 20);
            this.propertiesPanel.add(Box.createHorizontalStrut(50));
            this.gridbag.setConstraints(this.name, gridBagConstraints);
            this.propertiesPanel.add(this.name);
            String[] stringArray = new String[]{"A4", "A4 landscape", "A3", "A3 landscape", "A2", "A2 landscape"};
            this.pageSize = new JComboBox<String>(stringArray);
            this.pageSize.setSelectedIndex(this.report.getPageSize());
            this.propertiesPanel.add(new JLabel("Page size"));
            this.propertiesPanel.add(Box.createHorizontalStrut(50));
            this.gridbag.setConstraints(this.pageSize, gridBagConstraints);
            this.propertiesPanel.add(this.pageSize);
            this.propertiesPanel.add(new JLabel("Header"));
            this.propertiesPanel.add(Box.createHorizontalStrut(50));
            ButtonGroup buttonGroup = new ButtonGroup();
            this.createHeader = new JRadioButton("On");
            buttonGroup.add(this.createHeader);
            this.propertiesPanel.add(this.createHeader);
            this.propertiesPanel.add(Box.createHorizontalStrut(5));
            this.deleteHeader = new JRadioButton("Off");
            buttonGroup.add(this.deleteHeader);
            this.gridbag.setConstraints(this.deleteHeader, gridBagConstraints);
            this.propertiesPanel.add(this.deleteHeader);
            if (this.report.getHeader() == null) {
                this.deleteHeader.setSelected(true);
            } else {
                this.createHeader.setSelected(true);
            }
            this.propertiesPanel.add(new JLabel("Footer"));
            this.propertiesPanel.add(Box.createHorizontalStrut(50));
            ButtonGroup buttonGroup2 = new ButtonGroup();
            this.createFooter = new JRadioButton("On");
            buttonGroup2.add(this.createFooter);
            this.propertiesPanel.add(this.createFooter);
            this.propertiesPanel.add(Box.createHorizontalStrut(5));
            this.deleteFooter = new JRadioButton("Off");
            buttonGroup2.add(this.deleteFooter);
            if (this.report.getFooter() == null) {
                this.deleteFooter.setSelected(true);
            } else {
                this.createFooter.setSelected(true);
            }
            this.gridbag.setConstraints(this.deleteFooter, gridBagConstraints);
            this.propertiesPanel.add(this.deleteFooter);
            this.propertiesPanel.add(Box.createVerticalStrut(10));
            this.pack();
        }

        public void apply() {
            Object object;
            if (this.deleteHeader.isSelected()) {
                this.report.setHeader(null);
            } else if (this.createHeader.isSelected() && this.report.getHeader() == null) {
                object = new Table(1, 1);
                ((Table)object).setReportElement(new TextLabel("this is the page header!", 2, 12), 0);
                this.report.setHeader((ReportElement)object);
            }
            if (this.deleteFooter.isSelected()) {
                this.report.setFooter(null);
            } else if (this.createFooter.isSelected() && this.report.getFooter() == null) {
                object = new Table(1, 1);
                ((Table)object).setReportElement(new TextLabel("this is the page footer!", 2, 12), 0);
                this.report.setFooter((ReportElement)object);
            }
            this.report.setPageSize(this.pageSize.getSelectedIndex());
            object = this.name.getText();
            if (!((String)object).equals(this.report.getName())) {
                ReportDesigner.this.setReportName(this.report, (String)object);
                this.name.setText(this.report.getName());
                ReportDesigner.this.initialize(this.report);
            } else {
                ReportDesigner.this.redoLayout();
            }
        }
    }

    private class SectionProperties
    extends Properties {
        private Section section;
        private JRadioButton createDescription;
        private JRadioButton deleteDescription;

        public SectionProperties(Section section) {
            super("Section Properties");
            this.section = section;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            this.propertiesPanel.add(new JLabel("Description Area"));
            this.propertiesPanel.add(Box.createHorizontalStrut(50));
            ButtonGroup buttonGroup = new ButtonGroup();
            this.createDescription = new JRadioButton("On");
            buttonGroup.add(this.createDescription);
            this.propertiesPanel.add(this.createDescription);
            this.propertiesPanel.add(Box.createHorizontalStrut(5));
            this.deleteDescription = new JRadioButton("Off");
            buttonGroup.add(this.deleteDescription);
            this.gridbag.setConstraints(this.deleteDescription, gridBagConstraints);
            this.propertiesPanel.add(this.deleteDescription);
            if (this.section.getDescription() == null) {
                this.deleteDescription.setSelected(true);
            } else {
                this.createDescription.setSelected(true);
            }
            this.pack();
        }

        public void apply() {
            if (this.deleteDescription.isSelected()) {
                if (this.section.getDescription() != null) {
                    this.section.setDescription(null);
                }
            } else if (this.createDescription.isSelected() && this.section.getDescription() == null) {
                Table table = new Table(1, 1);
                table.setReportElement(new TextLabel("This is the section description!", 2, 12), 0);
                this.section.setDescription(table);
            }
            ReportDesigner.this.redoLayout();
        }
    }

    private class TableProperties
    extends Properties {
        private Table table;
        private JSpinner rows;
        private JSpinner cols;

        public TableProperties(Table table) {
            super("Table Properties");
            this.table = table;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            this.propertiesPanel.add(new JLabel("Rows"));
            this.propertiesPanel.add(Box.createHorizontalStrut(50));
            this.rows = new JSpinner(new SpinnerNumberModel(1, 1, 99, 1));
            this.rows.setValue(new Integer(this.table.getNumberOfRows()));
            this.gridbag.setConstraints(this.rows, gridBagConstraints);
            this.propertiesPanel.add(this.rows);
            this.propertiesPanel.add(new JLabel("Columns"));
            this.propertiesPanel.add(Box.createHorizontalStrut(50));
            this.cols = new JSpinner(new SpinnerNumberModel(1, 1, 99, 1));
            this.cols.setValue(new Integer(this.table.getNumberOfColumns()));
            this.gridbag.setConstraints(this.cols, gridBagConstraints);
            this.propertiesPanel.add(this.cols);
            this.propertiesPanel.add(Box.createVerticalStrut(10));
            this.pack();
        }

        public void apply() {
            int n = (Integer)this.rows.getValue();
            int n2 = (Integer)this.cols.getValue();
            if (this.table.getNumberOfRows() != n || this.table.getNumberOfColumns() != n2) {
                this.table.setRowsColumns(n, n2);
                ReportDesigner.this.redoLayout();
            }
        }
    }

    private class DynamicLineProperties
    extends Properties {
        private DynamicLine line;
        private Vector<Float> columnWidths;
        private Vector<DynamicLine.Field> columnFields;
        private Vector<String> columnHeaders;
        private RuleEditor ruleEditor;
        private boolean configuring;
        private JRadioButton headerHide;
        private JRadioButton headerOnce;
        private JRadioButton headerEveryPage;
        int scrollValue;
        private JComboBox sorting;
        private JComboBox sortNode;
        private JComboBox sortState;
        private JTextField sortColumn;
        private JComboBox sortAscending;
        private JSpinner maxLines;
        private JComboBox fontSize;
        private JComboBox font;

        public DynamicLineProperties(DynamicLine dynamicLine) {
            super("Lines Properties");
            this.columnWidths = new Vector();
            this.columnFields = new Vector();
            this.columnHeaders = new Vector();
            this.configuring = true;
            this.scrollValue = 0;
            this.line = dynamicLine;
            for (int i = 0; i < this.line.getNumberOfColumns(); ++i) {
                this.columnWidths.add(new Float(this.line.getColWidth(i)));
                this.columnFields.add(this.line.getField(i));
                this.columnHeaders.add(this.line.getHeaderString(i));
            }
            this.ruleEditor = new RuleEditor(this.line.getRule());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            this.propertiesPanel.add(new JLabel("Header:"));
            ButtonGroup buttonGroup = new ButtonGroup();
            this.headerHide = new JRadioButton("Hide");
            this.headerOnce = new JRadioButton("Show once");
            this.headerEveryPage = new JRadioButton("Show on every page");
            buttonGroup.add(this.headerHide);
            buttonGroup.add(this.headerOnce);
            buttonGroup.add(this.headerEveryPage);
            switch (this.line.getHeaderSettings()) {
                case 0: {
                    this.headerHide.setSelected(true);
                    break;
                }
                case 1: {
                    this.headerOnce.setSelected(true);
                    break;
                }
                case 2: {
                    this.headerEveryPage.setSelected(true);
                }
            }
            this.propertiesPanel.add(this.headerHide);
            this.propertiesPanel.add(this.headerOnce);
            this.gridbag.setConstraints(this.headerEveryPage, gridBagConstraints);
            this.propertiesPanel.add(this.headerEveryPage);
            this.propertiesPanel.add(new JLabel("Font name"));
            this.font = new JComboBox<String>(new String[]{ReportDesigner.STR_COURIER, ReportDesigner.STR_HELVETICA, ReportDesigner.STR_TIMES_NEW});
            switch (this.line.getLineFont()) {
                case 0: {
                    this.font.setSelectedItem(ReportDesigner.STR_COURIER);
                    break;
                }
                case 1: {
                    this.font.setSelectedItem(ReportDesigner.STR_HELVETICA);
                    break;
                }
                case 2: {
                    this.font.setSelectedItem(ReportDesigner.STR_TIMES_NEW);
                }
            }
            this.gridbag.setConstraints(this.font, gridBagConstraints);
            this.propertiesPanel.add(this.font);
            this.propertiesPanel.add(new JLabel("Font size"));
            this.fontSize = new JComboBox<String>(new String[]{ReportDesigner.STR_BIG, ReportDesigner.STR_MEDIUM, ReportDesigner.STR_SMALL});
            switch (this.line.getLineFontSize()) {
                case 14: {
                    this.fontSize.setSelectedItem(ReportDesigner.STR_BIG);
                    break;
                }
                case 12: {
                    this.fontSize.setSelectedItem(ReportDesigner.STR_MEDIUM);
                    break;
                }
                case 10: {
                    this.fontSize.setSelectedItem(ReportDesigner.STR_SMALL);
                }
            }
            this.gridbag.setConstraints(this.fontSize, gridBagConstraints);
            this.propertiesPanel.add(this.fontSize);
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.maxLines = new JSpinner(new SpinnerNumberModel(this.line.getMaxLines(), 0, Integer.MAX_VALUE, 1));
            this.propertiesPanel.add(new JLabel("Show n first lines (0=no limit)"));
            this.gridbag.setConstraints(this.maxLines, gridBagConstraints);
            this.propertiesPanel.add(this.maxLines);
            final JPanel jPanel = new JPanel(gridBagLayout);
            final JLabel jLabel = new JLabel("Select node:");
            final JLabel jLabel2 = new JLabel("State:");
            final JLabel jLabel3 = new JLabel("Select order");
            final JLabel jLabel4 = new JLabel("Column name");
            this.sorting = new JComboBox<String>(new String[]{"No sorting of lines", "Data values in column", "Node state belief"});
            DiscreteNode discreteNode = null;
            Vector<DiscreteNode> vector = new Vector<DiscreteNode>();
            for (Node serializable2 : ReportDesigner.this.net.getNodes()) {
                if (!(serializable2 instanceof DiscreteNode)) continue;
                if (this.line.sortingHasBeenSpecified() && this.line.sortBeliefNodeName != null && serializable2.getName().equals(this.line.sortBeliefNodeName)) {
                    discreteNode = (DiscreteNode)serializable2;
                }
                vector.add((DiscreteNode)serializable2);
            }
            this.sortNode = new JComboBox(vector);
            this.sortState = new JComboBox();
            this.sortNode.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DiscreteNode discreteNode = (DiscreteNode)DynamicLineProperties.this.sortNode.getSelectedItem();
                    DynamicLineProperties.this.sortState.removeAllItems();
                    String[] stringArray = new String[discreteNode.getNumberOfStates()];
                    for (int i = 0; i < discreteNode.getNumberOfStates(); ++i) {
                        DynamicLineProperties.this.sortState.addItem(discreteNode.getStateLabel(i));
                    }
                }
            });
            if (discreteNode != null) {
                this.sortNode.setSelectedItem(discreteNode);
                this.sortState.setSelectedIndex(this.line.sortBeliefState);
            } else {
                this.sortNode.setSelectedIndex(0);
            }
            Object object = "";
            if (this.line.sortingHasBeenSpecified() && this.line.sortColumn != null) {
                object = this.line.sortColumn;
            }
            this.sortColumn = new JTextField((String)object, 20);
            this.sortAscending = new JComboBox<String>(new String[]{"Ascending order", "Descending order"});
            if (this.line.sortingHasBeenSpecified()) {
                this.sortAscending.setSelectedIndex(this.line.sortAscending ? 0 : 1);
            }
            jPanel.add(new JLabel("Sort lines:"));
            gridBagLayout.setConstraints(this.sorting, gridBagConstraints);
            jPanel.add(this.sorting);
            jPanel.add(jLabel);
            gridBagLayout.setConstraints(this.sortNode, gridBagConstraints);
            jPanel.add(this.sortNode);
            jPanel.add(jLabel2);
            gridBagLayout.setConstraints(this.sortState, gridBagConstraints);
            jPanel.add(this.sortState);
            jPanel.add(jLabel4);
            gridBagLayout.setConstraints(this.sortColumn, gridBagConstraints);
            jPanel.add(this.sortColumn);
            jPanel.add(jLabel3);
            gridBagLayout.setConstraints(this.sortAscending, gridBagConstraints);
            jPanel.add(this.sortAscending);
            this.sorting.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DynamicLineProperties.this.sortNode.setVisible(false);
                    DynamicLineProperties.this.sortState.setVisible(false);
                    DynamicLineProperties.this.sortColumn.setVisible(false);
                    DynamicLineProperties.this.sortAscending.setVisible(false);
                    jLabel.setVisible(false);
                    jLabel2.setVisible(false);
                    jLabel3.setVisible(false);
                    jLabel4.setVisible(false);
                    if (DynamicLineProperties.this.sorting.getSelectedIndex() == 1) {
                        DynamicLineProperties.this.sortColumn.setVisible(true);
                        DynamicLineProperties.this.sortAscending.setVisible(true);
                        jLabel3.setVisible(true);
                        jLabel4.setVisible(true);
                    } else if (DynamicLineProperties.this.sorting.getSelectedIndex() == 2) {
                        DynamicLineProperties.this.sortNode.setVisible(true);
                        DynamicLineProperties.this.sortState.setVisible(true);
                        DynamicLineProperties.this.sortAscending.setVisible(true);
                        jLabel.setVisible(true);
                        jLabel2.setVisible(true);
                        jLabel3.setVisible(true);
                    }
                    jPanel.validate();
                    DynamicLineProperties.this.pack();
                }
            });
            this.sorting.setSelectedIndex(0);
            if (this.line.sortingHasBeenSpecified()) {
                if (this.line.sortBeliefNodeName != null) {
                    this.sorting.setSelectedIndex(2);
                } else if (this.line.sortColumn != null) {
                    this.sorting.setSelectedIndex(1);
                }
            }
            this.gridbag.setConstraints(jPanel, gridBagConstraints);
            this.propertiesPanel.add(jPanel);
            GridBagLayout gridBagLayout2 = this.gridbag;
            this.gridbag = new GridBagLayout();
            JPanel jPanel2 = this.propertiesPanel;
            this.propertiesPanel = new JPanel(this.gridbag);
            gridBagLayout2.setConstraints(this.propertiesPanel, gridBagConstraints);
            jPanel2.add(this.propertiesPanel);
            this.configure();
        }

        public void apply() {
            this.line.setRule(this.ruleEditor.toInclusionRule(this.line));
            this.line.setNumberOfColumns(this.columnFields.size());
            for (int i = 0; i < this.columnFields.size(); ++i) {
                this.line.setField(i, this.columnFields.get(i));
                this.line.setHeaderString(i, this.columnHeaders.get(i));
                this.line.setColWidth(i, this.columnWidths.get(i).floatValue());
            }
            if (this.headerHide.isSelected()) {
                this.line.setHeaderSettings(0);
            } else if (this.headerOnce.isSelected()) {
                this.line.setHeaderSettings(1);
            } else if (this.headerEveryPage.isSelected()) {
                this.line.setHeaderSettings(2);
            }
            if (this.sorting.getSelectedIndex() == 0) {
                this.line.setSortBeliefNode(null, -1, true);
                this.line.setSortColumn(null, true);
            } else if (this.sorting.getSelectedIndex() == 1) {
                this.line.setSortColumn(this.sortColumn.getText(), this.sortAscending.getSelectedIndex() == 0);
            } else if (this.sorting.getSelectedIndex() == 2) {
                this.line.setSortBeliefNode(((DiscreteNode)this.sortNode.getSelectedItem()).getName(), this.sortState.getSelectedIndex(), this.sortAscending.getSelectedIndex() == 0);
            }
            this.line.setMaxLines((Integer)this.maxLines.getValue());
            this.line.setLineFont(this.font.getSelectedItem().equals(ReportDesigner.STR_COURIER) ? 0 : (this.font.getSelectedItem().equals(ReportDesigner.STR_HELVETICA) ? 1 : 2), this.fontSize.getSelectedItem().equals(ReportDesigner.STR_BIG) ? 14 : (this.fontSize.getSelectedItem().equals(ReportDesigner.STR_MEDIUM) ? 12 : 10));
            ReportDesigner.this.redoLayout();
        }

        private void configure() {
            JComponent jComponent;
            Serializable serializable2;
            final int n = this.scrollValue;
            this.propertiesPanel.removeAll();
            GridBagLayout gridBagLayout = new GridBagLayout();
            JPanel jPanel = new JPanel(gridBagLayout);
            JScrollPane jScrollPane = new JScrollPane(jPanel, 22, 30);
            final JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
            AdjustmentListener adjustmentListener = new AdjustmentListener(){

                public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                    DynamicLineProperties.this.scrollValue = adjustmentEvent.getValue();
                }
            };
            jScrollBar.addAdjustmentListener(adjustmentListener);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    jScrollBar.setValue(n);
                }
            });
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 17;
            jScrollPane.setPreferredSize(new Dimension(600, 400));
            jScrollPane.setMinimumSize(new Dimension(600, 400));
            jScrollPane.setMaximumSize(new Dimension(600, 400));
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.gridwidth = 0;
            this.gridbag.setConstraints(jScrollPane, gridBagConstraints);
            this.propertiesPanel.add(jScrollPane);
            final String[] stringArray = new String[]{"SingleStateBelief", "HighestBeliefState", "DataValue", "UserValue", "CaseState"};
            Vector<DiscreteNode> vector = new Vector<DiscreteNode>();
            for (Serializable serializable2 : ReportDesigner.this.net.getNodes()) {
                if (!(serializable2 instanceof DiscreteNode)) continue;
                vector.add((DiscreteNode)serializable2);
            }
            Color color = Color.WHITE;
            serializable2 = Color.LIGHT_GRAY;
            Color color2 = color;
            for (int i = 0; i < this.columnFields.size(); ++i) {
                color2 = color2 == color ? serializable2 : color;
                jComponent = new JPanel();
                GridBagLayout gridBagLayout2 = new GridBagLayout();
                jComponent.setLayout(gridBagLayout2);
                jComponent.setBackground(color2);
                final int n2 = i;
                JPanel jPanel2 = new JPanel();
                jPanel2.setOpaque(false);
                JButton jButton = new JButton(ReportDesigner.this.upSmall);
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (n2 > 0) {
                            DynamicLineProperties.this.columnFields.add(n2 - 1, DynamicLineProperties.this.columnFields.remove(n2));
                            DynamicLineProperties.this.columnHeaders.add(n2 - 1, DynamicLineProperties.this.columnHeaders.remove(n2));
                            DynamicLineProperties.this.columnWidths.add(n2 - 1, DynamicLineProperties.this.columnWidths.remove(n2));
                            DynamicLineProperties.this.configuring = true;
                            DynamicLineProperties.this.configure();
                            DynamicLineProperties.this.configuring = false;
                        }
                    }
                });
                JButton jButton2 = new JButton(ReportDesigner.this.downSmall);
                jButton2.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (n2 < DynamicLineProperties.this.columnFields.size() - 1) {
                            DynamicLineProperties.this.columnFields.add(n2 + 1, DynamicLineProperties.this.columnFields.remove(n2));
                            DynamicLineProperties.this.columnHeaders.add(n2 + 1, DynamicLineProperties.this.columnHeaders.remove(n2));
                            DynamicLineProperties.this.columnWidths.add(n2 + 1, DynamicLineProperties.this.columnWidths.remove(n2));
                            DynamicLineProperties.this.configuring = true;
                            DynamicLineProperties.this.configure();
                            DynamicLineProperties.this.configuring = false;
                        }
                    }
                });
                JButton jButton3 = new JButton(ReportDesigner.this.delSmall);
                jButton3.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        DynamicLineProperties.this.columnFields.remove(n2);
                        DynamicLineProperties.this.columnHeaders.remove(n2);
                        DynamicLineProperties.this.columnWidths.remove(n2);
                        DynamicLineProperties.this.configuring = true;
                        DynamicLineProperties.this.configure();
                        DynamicLineProperties.this.configuring = false;
                    }
                });
                jPanel2.add(jButton);
                jPanel2.add(jButton2);
                jPanel2.add(jButton3);
                JLabel jLabel = new JLabel("Name");
                jPanel2.add(jLabel);
                final JTextField jTextField = new JTextField(this.columnHeaders.get(n2), 10);
                jPanel2.add(jTextField);
                JLabel jLabel2 = new JLabel("Relative Width");
                final JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(this.columnWidths.get(n2).doubleValue(), 0.1, 100.0, 0.1));
                jSpinner.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent changeEvent) {
                        DynamicLineProperties.this.columnWidths.remove(n2);
                        DynamicLineProperties.this.columnWidths.add(n2, new Float("" + jSpinner.getValue()));
                    }
                });
                jPanel2.add(jLabel2);
                jPanel2.add(jSpinner);
                gridBagLayout2.setConstraints(jPanel2, gridBagConstraints3);
                jComponent.add(jPanel2);
                JPanel jPanel3 = new JPanel();
                jPanel3.setOpaque(false);
                JLabel jLabel3 = new JLabel("Type");
                jPanel3.add(jLabel3);
                final JLabel jLabel4 = new JLabel("Node");
                final JLabel jLabel5 = new JLabel("Input identifier");
                final JTextField jTextField2 = new JTextField(10);
                final JLabel jLabel6 = new JLabel("State");
                final JLabel jLabel7 = new JLabel("Data column identifier");
                final JTextField jTextField3 = new JTextField(10);
                final JComboBox jComboBox = new JComboBox(vector);
                final JComboBox jComboBox2 = new JComboBox();
                jPanel3.add(jLabel5);
                jPanel3.add(jTextField2);
                jPanel3.add(jLabel7);
                jPanel3.add(jTextField3);
                jPanel3.add(jLabel4);
                jPanel3.add(jComboBox);
                jPanel3.add(jLabel6);
                jPanel3.add(jComboBox2);
                String string = null;
                String string2 = null;
                String string3 = null;
                DynamicLine.Field field = this.columnFields.get(n2);
                if (field instanceof DynamicLine.HighestBeliefState) {
                    string = ((DynamicLine.HighestBeliefState)field).nodeName;
                } else if (field instanceof DynamicLine.CaseState) {
                    string = ((DynamicLine.CaseState)field).nodeName;
                } else if (field instanceof DynamicLine.SingleStateBeliefField) {
                    string = ((DynamicLine.SingleStateBeliefField)field).nodeName;
                } else if (field instanceof DynamicLine.DataFileValue) {
                    string2 = ((DynamicLine.DataFileValue)field).dataColumnName;
                } else if (field instanceof DynamicLine.UserInputValue) {
                    string3 = ((DynamicLine.UserInputValue)field).userFieldName;
                }
                if (string2 != null) {
                    jTextField3.setText(string2);
                }
                if (string3 != null) {
                    jTextField2.setText(string3);
                }
                if (string != null) {
                    jComboBox.setSelectedItem(ReportDesigner.this.net.getNodeByName(string));
                }
                final JComboBox<String> jComboBox3 = new JComboBox<String>(stringArray);
                final Runnable runnable = new Runnable(){

                    public void run() {
                        DynamicLineProperties.this.configuring = false;
                        DynamicLineProperties.this.columnHeaders.remove(n2);
                        DynamicLineProperties.this.columnHeaders.add(n2, jTextField.getText());
                        if (jComboBox3.getSelectedItem().equals(stringArray[0])) {
                            String string = ((Node)jComboBox.getSelectedItem()).getName();
                            int n = jComboBox2.getSelectedIndex();
                            DynamicLine.SingleStateBeliefField singleStateBeliefField = DynamicLineProperties.this.line.createSingleStateBeliefField(string, n);
                            DynamicLineProperties.this.columnFields.remove(n2);
                            DynamicLineProperties.this.columnFields.add(n2, singleStateBeliefField);
                        } else if (jComboBox3.getSelectedItem().equals(stringArray[1])) {
                            String string = ((Node)jComboBox.getSelectedItem()).getName();
                            DynamicLine.HighestBeliefState highestBeliefState = DynamicLineProperties.this.line.createHighestBeliefState(string);
                            DynamicLineProperties.this.columnFields.remove(n2);
                            DynamicLineProperties.this.columnFields.add(n2, highestBeliefState);
                        } else if (jComboBox3.getSelectedItem().equals(stringArray[2])) {
                            String string = jTextField3.getText();
                            DynamicLine.DataFileValue dataFileValue = DynamicLineProperties.this.line.createDataFileValue(string);
                            DynamicLineProperties.this.columnFields.remove(n2);
                            DynamicLineProperties.this.columnFields.add(n2, dataFileValue);
                        } else if (jComboBox3.getSelectedItem().equals(stringArray[3])) {
                            String string = jTextField2.getText();
                            DynamicLine.UserInputValue userInputValue = DynamicLineProperties.this.line.createUserInputValue(string);
                            DynamicLineProperties.this.columnFields.remove(n2);
                            DynamicLineProperties.this.columnFields.add(n2, userInputValue);
                        } else if (jComboBox3.getSelectedItem().equals(stringArray[4])) {
                            String string = ((Node)jComboBox.getSelectedItem()).getName();
                            DynamicLine.CaseState caseState = DynamicLineProperties.this.line.createCaseState(string);
                            DynamicLineProperties.this.columnFields.remove(n2);
                            DynamicLineProperties.this.columnFields.add(n2, caseState);
                        }
                    }
                };
                jComboBox.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        jComboBox2.removeAllItems();
                        DiscreteNode discreteNode = (DiscreteNode)jComboBox.getSelectedItem();
                        if (discreteNode != null) {
                            String[] stringArray = new String[discreteNode.getNumberOfStates()];
                            for (int i = 0; i < discreteNode.getNumberOfStates(); ++i) {
                                jComboBox2.addItem(discreteNode.getStateLabel(i));
                            }
                            DynamicLine.Field field = (DynamicLine.Field)DynamicLineProperties.this.columnFields.get(n2);
                            if (field instanceof DynamicLine.SingleStateBeliefField && ((DynamicLine.SingleStateBeliefField)field).nodeName.equals(discreteNode.getName())) {
                                jComboBox2.setSelectedIndex(((DynamicLine.SingleStateBeliefField)field).state);
                            }
                        }
                        if (!DynamicLineProperties.this.configuring) {
                            DynamicLineProperties.this.configuring = true;
                            SwingUtilities.invokeLater(runnable);
                        }
                    }
                });
                jComboBox2.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (!DynamicLineProperties.this.configuring) {
                            DynamicLineProperties.this.configuring = true;
                            SwingUtilities.invokeLater(runnable);
                        }
                    }
                });
                jComboBox3.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        jLabel4.setVisible(false);
                        jLabel5.setVisible(false);
                        jTextField2.setVisible(false);
                        jLabel6.setVisible(false);
                        jLabel7.setVisible(false);
                        jTextField3.setVisible(false);
                        jComboBox.setVisible(false);
                        jComboBox2.setVisible(false);
                        if (jComboBox3.getSelectedItem().equals(stringArray[0])) {
                            jLabel4.setVisible(true);
                            jComboBox.setVisible(true);
                            jComboBox.setSelectedIndex(jComboBox.getSelectedIndex());
                            jLabel6.setVisible(true);
                            jComboBox2.setVisible(true);
                        } else if (jComboBox3.getSelectedItem().equals(stringArray[1])) {
                            jLabel4.setVisible(true);
                            jComboBox.setVisible(true);
                            jComboBox.setSelectedIndex(jComboBox.getSelectedIndex());
                        } else if (jComboBox3.getSelectedItem().equals(stringArray[2])) {
                            jLabel7.setVisible(true);
                            jTextField3.setVisible(true);
                        } else if (jComboBox3.getSelectedItem().equals(stringArray[3])) {
                            jLabel5.setVisible(true);
                            jTextField2.setVisible(true);
                        } else if (jComboBox3.getSelectedItem().equals(stringArray[4])) {
                            jComboBox.setVisible(true);
                            jComboBox.setSelectedIndex(jComboBox.getSelectedIndex());
                        }
                        if (!DynamicLineProperties.this.configuring) {
                            DynamicLineProperties.this.configuring = true;
                            SwingUtilities.invokeLater(runnable);
                        }
                        DynamicLineProperties.this.validate();
                        DynamicLineProperties.this.pack();
                    }
                });
                if (field instanceof DynamicLine.HighestBeliefState) {
                    jComboBox3.setSelectedIndex(1);
                } else if (field instanceof DynamicLine.SingleStateBeliefField) {
                    jComboBox3.setSelectedIndex(0);
                } else if (field instanceof DynamicLine.DataFileValue) {
                    jComboBox3.setSelectedIndex(2);
                } else if (field instanceof DynamicLine.UserInputValue) {
                    jComboBox3.setSelectedIndex(3);
                } else if (field instanceof DynamicLine.CaseState) {
                    jComboBox3.setSelectedIndex(4);
                }
                DocumentListener documentListener = new DocumentListener(){

                    public void myAction() {
                        SwingUtilities.invokeLater(runnable);
                    }

                    public void changedUpdate(DocumentEvent documentEvent) {
                        this.myAction();
                    }

                    public void insertUpdate(DocumentEvent documentEvent) {
                        this.myAction();
                    }

                    public void removeUpdate(DocumentEvent documentEvent) {
                        this.myAction();
                    }
                };
                jTextField.getDocument().addDocumentListener(documentListener);
                jTextField2.getDocument().addDocumentListener(documentListener);
                jTextField3.getDocument().addDocumentListener(documentListener);
                jComponent.add(jComboBox3);
                gridBagLayout2.setConstraints(jPanel3, gridBagConstraints2);
                jComponent.add(jPanel3);
                Component component = Box.createHorizontalStrut(10);
                gridBagLayout2.setConstraints(component, gridBagConstraints);
                jComponent.add(component);
                this.configuring = false;
                gridBagLayout.setConstraints(jComponent, gridBagConstraints3);
                jPanel.add(jComponent);
            }
            JButton jButton = new JButton("Add a Column");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DynamicLineProperties.this.columnFields.add(DynamicLineProperties.this.line.createUserInputValue("VALUE"));
                    DynamicLineProperties.this.columnHeaders.add("New Column");
                    DynamicLineProperties.this.columnWidths.add(new Float(1.0f));
                    DynamicLineProperties.this.configuring = true;
                    DynamicLineProperties.this.scrollValue = 10000;
                    DynamicLineProperties.this.configure();
                    DynamicLineProperties.this.configuring = false;
                }
            });
            gridBagLayout.setConstraints(jButton, gridBagConstraints3);
            jPanel.add(jButton);
            jComponent = new JScrollPane(this.ruleEditor);
            jComponent.setPreferredSize(new Dimension(600, 200));
            jComponent.setMinimumSize(new Dimension(600, 200));
            jComponent.setMaximumSize(new Dimension(600, 200));
            this.gridbag.setConstraints(jComponent, gridBagConstraints3);
            this.propertiesPanel.add(jComponent);
            this.pack();
            jComponent.repaint();
        }
    }

    private class AutoFieldProperties
    extends Properties {
        private AutoField autoField;
        private int autoFieldType;
        private JComboBox selectType;
        private JComboBox font;
        private JComboBox fontSize;

        public AutoFieldProperties(AutoField autoField) {
            super("Auto Generated Label Properties");
            this.autoField = autoField;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            this.propertiesPanel.add(new JLabel("Type"));
            this.propertiesPanel.add(Box.createHorizontalStrut(50));
            this.selectType = new JComboBox<String>(AutoField.FIELD_TYPE_DESCRIPTIONS);
            this.selectType.setSelectedIndex(this.autoField.getFieldType());
            this.gridbag.setConstraints(this.selectType, gridBagConstraints);
            this.propertiesPanel.add(this.selectType);
            this.propertiesPanel.add(new JLabel("Font name"));
            this.font = new JComboBox<String>(new String[]{ReportDesigner.STR_COURIER, ReportDesigner.STR_HELVETICA, ReportDesigner.STR_TIMES_NEW});
            switch (this.autoField.getTextLabelFont()) {
                case 0: {
                    this.font.setSelectedItem(ReportDesigner.STR_COURIER);
                    break;
                }
                case 1: {
                    this.font.setSelectedItem(ReportDesigner.STR_HELVETICA);
                    break;
                }
                case 2: {
                    this.font.setSelectedItem(ReportDesigner.STR_TIMES_NEW);
                }
            }
            this.gridbag.setConstraints(this.font, gridBagConstraints);
            this.propertiesPanel.add(this.font);
            this.propertiesPanel.add(new JLabel("Font size"));
            this.fontSize = new JComboBox<String>(new String[]{ReportDesigner.STR_BIG, ReportDesigner.STR_MEDIUM, ReportDesigner.STR_SMALL});
            switch (this.autoField.getTextLabelSize()) {
                case 14: {
                    this.fontSize.setSelectedItem(ReportDesigner.STR_BIG);
                    break;
                }
                case 12: {
                    this.fontSize.setSelectedItem(ReportDesigner.STR_MEDIUM);
                    break;
                }
                case 10: {
                    this.fontSize.setSelectedItem(ReportDesigner.STR_SMALL);
                }
            }
            this.gridbag.setConstraints(this.fontSize, gridBagConstraints);
            this.propertiesPanel.add(this.fontSize);
            this.pack();
        }

        public void apply() {
            this.autoField.setProperties(this.selectType.getSelectedIndex(), this.font.getSelectedItem().equals(ReportDesigner.STR_COURIER) ? 0 : (this.font.getSelectedItem().equals(ReportDesigner.STR_HELVETICA) ? 1 : 2), this.fontSize.getSelectedItem().equals(ReportDesigner.STR_BIG) ? 14 : (this.fontSize.getSelectedItem().equals(ReportDesigner.STR_MEDIUM) ? 12 : 10));
            ReportDesigner.this.redoLayout();
        }
    }

    private class UserInputProperties
    extends Properties {
        private UserInput userInput;
        private JTextField userInfoName;
        private JComboBox font;
        private JComboBox fontSize;

        public UserInputProperties(UserInput userInput) {
            super("User Input Properties");
            this.userInput = userInput;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            this.propertiesPanel.add(new JLabel("Input identifier"));
            this.propertiesPanel.add(Box.createHorizontalStrut(50));
            this.userInfoName = new JTextField(this.userInput.getFieldName(), 10);
            this.gridbag.setConstraints(this.userInfoName, gridBagConstraints);
            this.propertiesPanel.add(this.userInfoName);
            this.propertiesPanel.add(new JLabel("Font name"));
            this.font = new JComboBox<String>(new String[]{ReportDesigner.STR_COURIER, ReportDesigner.STR_HELVETICA, ReportDesigner.STR_TIMES_NEW});
            switch (this.userInput.getTextLabelFont()) {
                case 0: {
                    this.font.setSelectedItem(ReportDesigner.STR_COURIER);
                    break;
                }
                case 1: {
                    this.font.setSelectedItem(ReportDesigner.STR_HELVETICA);
                    break;
                }
                case 2: {
                    this.font.setSelectedItem(ReportDesigner.STR_TIMES_NEW);
                }
            }
            this.gridbag.setConstraints(this.font, gridBagConstraints);
            this.propertiesPanel.add(this.font);
            this.propertiesPanel.add(new JLabel("Font size"));
            this.fontSize = new JComboBox<String>(new String[]{ReportDesigner.STR_BIG, ReportDesigner.STR_MEDIUM, ReportDesigner.STR_SMALL});
            switch (this.userInput.getTextLabelSize()) {
                case 14: {
                    this.fontSize.setSelectedItem(ReportDesigner.STR_BIG);
                    break;
                }
                case 12: {
                    this.fontSize.setSelectedItem(ReportDesigner.STR_MEDIUM);
                    break;
                }
                case 10: {
                    this.fontSize.setSelectedItem(ReportDesigner.STR_SMALL);
                }
            }
            this.gridbag.setConstraints(this.fontSize, gridBagConstraints);
            this.propertiesPanel.add(this.fontSize);
            this.pack();
        }

        public void apply() {
            this.userInput.setProperties(this.userInfoName.getText(), this.font.getSelectedItem().equals(ReportDesigner.STR_COURIER) ? 0 : (this.font.getSelectedItem().equals(ReportDesigner.STR_HELVETICA) ? 1 : 2), this.fontSize.getSelectedItem().equals(ReportDesigner.STR_BIG) ? 14 : (this.fontSize.getSelectedItem().equals(ReportDesigner.STR_MEDIUM) ? 12 : 10));
            ReportDesigner.this.redoLayout();
        }
    }

    private class RuleEditor
    extends JPanel {
        public static final int RULE_AND = 0;
        public static final int RULE_OR = 1;
        public static final int RULE_TRUE = 2;
        public static final int RULE_PROB = 3;
        public static final int RULE_COMPARE = 4;
        public static final int RULE_NEGATE = 5;
        public static final int RULE_GREATER = 6;
        public static final int RULE_LESS = 7;
        public static final int RULE_UNKNOWN = 8;
        private RuleNode root;
        private Vector<RuleNode.RuleTitle> titles;

        public RuleEditor(DynamicLine.InclusionRule inclusionRule) {
            super(new GridLayout(1, 1));
            this.root = null;
            this.titles = new Vector();
            this.root = this.createFromRule(null, inclusionRule);
            this.update();
        }

        public DynamicLine.InclusionRule toInclusionRule(DynamicLine dynamicLine) {
            return this.root.toInclusionRule(dynamicLine);
        }

        private void update() {
            this.removeAll();
            this.titles.clear();
            this.root = this.root.getRoot();
            this.add(this.root.render(null));
            this.revalidate();
            this.repaint();
            System.out.println("UPDATED!");
        }

        public void paint(Graphics graphics) {
            this.paintComponent(graphics);
            this.paintBorder(graphics);
            this.paintChildren(graphics);
            graphics.setColor(Color.BLACK);
            for (RuleNode.RuleTitle ruleTitle : this.titles) {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                if (ruleTitle.parentTitle != null) {
                    for (Container container = ruleTitle.parentTitle; container != this; container = container.getParent()) {
                        n += ((Component)container).getX();
                        n2 += ((Component)container).getY();
                    }
                    for (Container container = ruleTitle; container != this; container = container.getParent()) {
                        n3 += ((Component)container).getX();
                        n4 += ((Component)container).getY();
                    }
                    Point point = new Point(n3, n4);
                    Point point2 = new Point(n, n2);
                    graphics.drawLine(point.x + ruleTitle.getWidth() / 2, point.y, point2.x + ruleTitle.parentTitle.getWidth() / 2, point2.y + ruleTitle.parentTitle.getHeight());
                    System.out.println(ruleTitle.parentTitle.getText() + " => " + ruleTitle.getText());
                    continue;
                }
                System.out.println(ruleTitle.getText());
            }
        }

        public RuleNode createFromRule(RuleNode ruleNode, DynamicLine.InclusionRule inclusionRule) {
            if (inclusionRule instanceof DynamicLine.EverythingRule) {
                return new RuleNode(ruleNode, (DynamicLine.EverythingRule)inclusionRule);
            }
            if (inclusionRule instanceof DynamicLine.BeliefRule) {
                return new RuleNode(ruleNode, (DynamicLine.BeliefRule)inclusionRule);
            }
            if (inclusionRule instanceof DynamicLine.DataFileValueEquals) {
                return new RuleNode(ruleNode, (DynamicLine.DataFileValueEquals)inclusionRule);
            }
            if (inclusionRule instanceof DynamicLine.AndRule) {
                return new RuleNode(ruleNode, (DynamicLine.AndRule)inclusionRule);
            }
            if (inclusionRule instanceof DynamicLine.OrRule) {
                return new RuleNode(ruleNode, (DynamicLine.OrRule)inclusionRule);
            }
            if (inclusionRule instanceof DynamicLine.NegateRule) {
                return new RuleNode(ruleNode, (DynamicLine.NegateRule)inclusionRule);
            }
            if (inclusionRule instanceof DynamicLine.DataFileValueGreaterThan) {
                return new RuleNode(ruleNode, (DynamicLine.DataFileValueGreaterThan)inclusionRule);
            }
            if (inclusionRule instanceof DynamicLine.DataFileValueLessThan) {
                return new RuleNode(ruleNode, (DynamicLine.DataFileValueLessThan)inclusionRule);
            }
            return null;
        }

        public void replaceChild(RuleNode ruleNode, RuleNode ruleNode2, RuleNode ruleNode3) {
            if (ruleNode != null && ruleNode.first == ruleNode2) {
                ruleNode.first = ruleNode3;
                if (ruleNode3 != null) {
                    ruleNode3.parent = ruleNode;
                }
            }
            if (ruleNode != null && ruleNode.second == ruleNode2) {
                ruleNode.second = ruleNode3;
                if (ruleNode3 != null) {
                    ruleNode3.parent = ruleNode;
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class RuleNode
        implements Comparable<RuleNode> {
            public RuleNode first = null;
            public RuleNode second = null;
            public RuleNode parent = null;
            public String nodeName = "";
            public String colName = "";
            public String valEquals = "";
            public int stateNum = 0;
            public double belief = 0.0;
            public int ruleType;

            public JPanel render(RuleTitle ruleTitle) {
                LineBorder lineBorder = new LineBorder(Color.BLACK, 1, false);
                final RuleNode ruleNode = this;
                JPanel jPanel = new JPanel(new BorderLayout());
                JPanel jPanel2 = new JPanel(new FlowLayout(1));
                jPanel.add((Component)jPanel2, "North");
                final JPopupMenu jPopupMenu = new JPopupMenu();
                jPopupMenu.add("--- Modify this rule ---");
                JMenuItem jMenuItem = new JMenuItem("Delete!");
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (RuleNode.this.parent != null && RuleNode.this.ruleType == 5) {
                            RuleEditor.this.replaceChild(RuleNode.this.parent, ruleNode, RuleNode.this.first);
                            RuleEditor.this.root = RuleNode.this.parent;
                            RuleEditor.this.update();
                        } else if (RuleNode.this.parent != null) {
                            RuleEditor.this.replaceChild(RuleNode.this.parent, ruleNode, null);
                            RuleEditor.this.root = RuleNode.this.parent;
                            RuleEditor.this.update();
                        } else if (RuleNode.this.parent == null && RuleNode.this.ruleType == 5 && RuleNode.this.first != null) {
                            RuleEditor.this.root = RuleNode.this.first;
                            RuleNode.this.first.parent = null;
                            RuleEditor.this.update();
                        }
                    }
                });
                if (this.getRoot() != this || this.ruleType == 5 && this.first != null) {
                    jPopupMenu.add(jMenuItem);
                }
                JMenuItem jMenuItem2 = new JMenuItem("Switch to AND");
                jMenuItem2.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        RuleNode ruleNode2 = new RuleNode(RuleNode.this.parent, 0, RuleNode.this.first, RuleNode.this.second);
                        RuleEditor.this.replaceChild(RuleNode.this.parent, ruleNode, ruleNode2);
                        RuleEditor.this.replaceChild(ruleNode2, RuleNode.this.first, RuleNode.this.first);
                        RuleEditor.this.replaceChild(ruleNode2, RuleNode.this.second, RuleNode.this.second);
                        RuleEditor.this.root = ruleNode2;
                        RuleEditor.this.update();
                    }
                });
                jPopupMenu.add(jMenuItem2);
                JMenuItem jMenuItem3 = new JMenuItem("Switch to OR");
                jMenuItem3.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        RuleNode ruleNode2 = new RuleNode(RuleNode.this.parent, 1, RuleNode.this.first, RuleNode.this.second);
                        RuleEditor.this.replaceChild(RuleNode.this.parent, ruleNode, ruleNode2);
                        RuleEditor.this.replaceChild(ruleNode2, RuleNode.this.first, RuleNode.this.first);
                        RuleEditor.this.replaceChild(ruleNode2, RuleNode.this.second, RuleNode.this.second);
                        RuleEditor.this.root = ruleNode2;
                        RuleEditor.this.update();
                    }
                });
                jPopupMenu.add(jMenuItem3);
                JMenuItem jMenuItem4 = new JMenuItem("Switch to PROBABILITY");
                jMenuItem4.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        RuleNode ruleNode2 = new RuleNode(RuleNode.this.parent, 3);
                        RuleEditor.this.replaceChild(RuleNode.this.parent, ruleNode, ruleNode2);
                        RuleEditor.this.root = ruleNode2;
                        RuleEditor.this.update();
                    }
                });
                jPopupMenu.add(jMenuItem4);
                JMenuItem jMenuItem5 = new JMenuItem("Switch to COMPARE");
                jMenuItem5.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        RuleNode ruleNode2 = new RuleNode(RuleNode.this.parent, 4);
                        RuleEditor.this.replaceChild(RuleNode.this.parent, ruleNode, ruleNode2);
                        RuleEditor.this.root = ruleNode2;
                        RuleEditor.this.update();
                    }
                });
                jPopupMenu.add(jMenuItem5);
                JMenuItem jMenuItem6 = new JMenuItem("Switch to GREATER THAN");
                jMenuItem6.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        RuleNode ruleNode2 = new RuleNode(RuleNode.this.parent, 6);
                        RuleEditor.this.replaceChild(RuleNode.this.parent, ruleNode, ruleNode2);
                        RuleEditor.this.root = ruleNode2;
                        RuleEditor.this.update();
                    }
                });
                jPopupMenu.add(jMenuItem6);
                JMenuItem jMenuItem7 = new JMenuItem("Switch to LESS THAN");
                jMenuItem7.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        RuleNode ruleNode2 = new RuleNode(RuleNode.this.parent, 7);
                        RuleEditor.this.replaceChild(RuleNode.this.parent, ruleNode, ruleNode2);
                        RuleEditor.this.root = ruleNode2;
                        RuleEditor.this.update();
                    }
                });
                jPopupMenu.add(jMenuItem7);
                JMenuItem jMenuItem8 = new JMenuItem("Switch to TRUE");
                jMenuItem8.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        RuleNode ruleNode2 = new RuleNode(RuleNode.this.parent, 2);
                        RuleEditor.this.replaceChild(RuleNode.this.parent, ruleNode, ruleNode2);
                        RuleEditor.this.root = ruleNode2;
                        RuleEditor.this.update();
                    }
                });
                jPopupMenu.add(jMenuItem8);
                jPopupMenu.add("--- Enclose this rule ---");
                JMenuItem jMenuItem9 = new JMenuItem("enclose in AND");
                jMenuItem9.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        RuleNode ruleNode2 = new RuleNode(RuleNode.this.parent, 0, ruleNode);
                        RuleEditor.this.replaceChild(RuleNode.this.parent, ruleNode, ruleNode2);
                        RuleNode.this.parent = ruleNode2;
                        RuleEditor.this.update();
                    }
                });
                jPopupMenu.add(jMenuItem9);
                JMenuItem jMenuItem10 = new JMenuItem("enclose in OR");
                jMenuItem10.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        RuleNode ruleNode2 = new RuleNode(RuleNode.this.parent, 1, ruleNode);
                        RuleEditor.this.replaceChild(RuleNode.this.parent, ruleNode, ruleNode2);
                        RuleNode.this.parent = ruleNode2;
                        RuleEditor.this.update();
                    }
                });
                jPopupMenu.add(jMenuItem10);
                JMenuItem jMenuItem11 = new JMenuItem("enclose in NEGATE");
                jMenuItem11.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        RuleNode ruleNode2 = new RuleNode(RuleNode.this.parent, 5, ruleNode);
                        RuleEditor.this.replaceChild(RuleNode.this.parent, ruleNode, ruleNode2);
                        RuleNode.this.parent = ruleNode2;
                        RuleEditor.this.update();
                    }
                });
                jPopupMenu.add(jMenuItem11);
                switch (this.ruleType) {
                    case 0: 
                    case 1: {
                        JMenuItem jMenuItem12;
                        JMenuItem jMenuItem13;
                        JMenuItem jMenuItem14;
                        JMenuItem jMenuItem15;
                        JMenuItem jMenuItem16;
                        JMenuItem jMenuItem17;
                        JMenuItem jMenuItem18;
                        JPanel jPanel3;
                        jPopupMenu.add("--- Add rules ---");
                        RuleTitle ruleTitle3 = null;
                        if (this.ruleType == 0) {
                            ruleTitle3 = new RuleTitle("AND", ruleTitle);
                        }
                        if (this.ruleType == 1) {
                            ruleTitle3 = new RuleTitle("OR", ruleTitle);
                        }
                        ruleTitle3.setBorder(lineBorder);
                        jPanel2.add(ruleTitle3);
                        JPanel jPanel4 = new JPanel(new FlowLayout());
                        if (this.first != null) {
                            jPanel4.add(this.first.render(ruleTitle3));
                        } else {
                            jPanel3 = new JPanel();
                            RuleTitle ruleTitle2 = new RuleTitle("<null>", ruleTitle3);
                            ruleTitle2.setBorder(lineBorder);
                            jPanel3.add(ruleTitle2);
                            jPanel4.add(jPanel3);
                            jMenuItem18 = new JMenuItem("<- AND");
                            jMenuItem18.addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent actionEvent) {
                                    RuleNode.this.first = new RuleNode(ruleNode, 0);
                                    RuleEditor.this.update();
                                }
                            });
                            jPopupMenu.add(jMenuItem18);
                            jMenuItem17 = new JMenuItem("<- OR");
                            jMenuItem17.addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent actionEvent) {
                                    RuleNode.this.first = new RuleNode(ruleNode, 1);
                                    RuleEditor.this.update();
                                }
                            });
                            jPopupMenu.add(jMenuItem17);
                            jMenuItem16 = new JMenuItem("<- PROBABILITY");
                            jMenuItem16.addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent actionEvent) {
                                    RuleNode.this.first = new RuleNode(ruleNode, 3);
                                    RuleEditor.this.update();
                                }
                            });
                            jPopupMenu.add(jMenuItem16);
                            jMenuItem15 = new JMenuItem("<- COMPARE");
                            jMenuItem15.addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent actionEvent) {
                                    RuleNode.this.first = new RuleNode(ruleNode, 4);
                                    RuleEditor.this.update();
                                }
                            });
                            jPopupMenu.add(jMenuItem15);
                            jMenuItem14 = new JMenuItem("<- GREATER THAN");
                            jMenuItem14.addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent actionEvent) {
                                    RuleNode.this.first = new RuleNode(ruleNode, 6);
                                    RuleEditor.this.update();
                                }
                            });
                            jPopupMenu.add(jMenuItem14);
                            jMenuItem13 = new JMenuItem("<- LESS THAN");
                            jMenuItem13.addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent actionEvent) {
                                    RuleNode.this.first = new RuleNode(ruleNode, 7);
                                    RuleEditor.this.update();
                                }
                            });
                            jPopupMenu.add(jMenuItem13);
                            jMenuItem12 = new JMenuItem("<- TRUE");
                            jMenuItem12.addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent actionEvent) {
                                    RuleNode.this.first = new RuleNode(ruleNode, 2);
                                    RuleEditor.this.update();
                                }
                            });
                            jPopupMenu.add(jMenuItem12);
                        }
                        if (this.second != null) {
                            jPanel4.add(this.second.render(ruleTitle3));
                        } else {
                            jPanel3 = new JPanel();
                            RuleTitle serializable2 = new RuleTitle("<null>", ruleTitle3);
                            serializable2.setBorder(lineBorder);
                            jPanel3.add(serializable2);
                            jPanel4.add(jPanel3);
                            jMenuItem18 = new JMenuItem("AND ->");
                            jMenuItem18.addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent actionEvent) {
                                    RuleNode.this.second = new RuleNode(ruleNode, 0);
                                    RuleEditor.this.update();
                                }
                            });
                            jPopupMenu.add(jMenuItem18);
                            jMenuItem17 = new JMenuItem("OR ->");
                            jMenuItem17.addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent actionEvent) {
                                    RuleNode.this.second = new RuleNode(ruleNode, 1);
                                    RuleEditor.this.update();
                                }
                            });
                            jPopupMenu.add(jMenuItem17);
                            jMenuItem16 = new JMenuItem("PROBABILITY ->");
                            jMenuItem16.addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent actionEvent) {
                                    RuleNode.this.second = new RuleNode(ruleNode, 3);
                                    RuleEditor.this.update();
                                }
                            });
                            jPopupMenu.add(jMenuItem16);
                            jMenuItem15 = new JMenuItem("COMPARE ->");
                            jMenuItem15.addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent actionEvent) {
                                    RuleNode.this.second = new RuleNode(ruleNode, 4);
                                    RuleEditor.this.update();
                                }
                            });
                            jPopupMenu.add(jMenuItem15);
                            jMenuItem14 = new JMenuItem("GREATER THAN ->");
                            jMenuItem14.addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent actionEvent) {
                                    RuleNode.this.second = new RuleNode(ruleNode, 6);
                                    RuleEditor.this.update();
                                }
                            });
                            jPopupMenu.add(jMenuItem14);
                            jMenuItem13 = new JMenuItem("LESS THAN ->");
                            jMenuItem13.addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent actionEvent) {
                                    RuleNode.this.second = new RuleNode(ruleNode, 7);
                                    RuleEditor.this.update();
                                }
                            });
                            jPopupMenu.add(jMenuItem13);
                            jMenuItem12 = new JMenuItem("TRUE ->");
                            jMenuItem12.addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent actionEvent) {
                                    RuleNode.this.second = new RuleNode(ruleNode, 2);
                                    RuleEditor.this.update();
                                }
                            });
                            jPopupMenu.add(jMenuItem12);
                        }
                        jPanel.add((Component)jPanel4, ReportDesigner.STR_CENTER);
                        break;
                    }
                    case 2: {
                        RuleTitle ruleTitle4 = new RuleTitle("TRUE", ruleTitle);
                        ruleTitle4.setBorder(lineBorder);
                        jPanel2.add(ruleTitle4);
                        break;
                    }
                    case 3: {
                        RuleTitle ruleTitle5 = new RuleTitle("P(", ruleTitle);
                        jPanel2.add(ruleTitle5);
                        jPanel2.setBorder(lineBorder);
                        Vector<String> vector = new Vector<String>();
                        for (Node documentListener : ReportDesigner.this.net.getNodes()) {
                            if (!(documentListener instanceof DiscreteNode)) continue;
                            vector.add(documentListener.getName());
                        }
                        final JComboBox jComboBox = new JComboBox();
                        jComboBox.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                RuleNode.this.stateNum = jComboBox.getSelectedIndex();
                            }
                        });
                        final JComboBox documentListener = new JComboBox(vector);
                        documentListener.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                RuleNode.this.nodeName = (String)documentListener.getSelectedItem();
                                DiscreteNode discreteNode = (DiscreteNode)ReportDesigner.this.net.getNodeByName(RuleNode.this.nodeName);
                                int n = RuleNode.this.stateNum;
                                jComboBox.removeAllItems();
                                for (int i = 0; i < discreteNode.getNumberOfStates(); ++i) {
                                    jComboBox.addItem(discreteNode.getStateLabel(i));
                                }
                                jComboBox.setSelectedIndex(n < jComboBox.getItemCount() ? n : 0);
                            }
                        });
                        documentListener.setSelectedItem(this.nodeName);
                        documentListener.setSelectedIndex(documentListener.getSelectedIndex());
                        jPanel2.add(documentListener);
                        jPanel2.add(new JLabel("="));
                        jPanel2.add(jComboBox);
                        final JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(this.belief, 0.0, 1.0, 0.01));
                        jSpinner.setPreferredSize(new Dimension(50, jSpinner.getPreferredSize().height));
                        jSpinner.addChangeListener(new ChangeListener(){

                            public void stateChanged(ChangeEvent changeEvent) {
                                RuleNode.this.belief = (double)((int)((Double)jSpinner.getValue() * 100.0)) / 100.0;
                            }
                        });
                        jPanel2.add(new JLabel(") > "));
                        jPanel2.add(jSpinner);
                        break;
                    }
                    case 4: {
                        jPanel2.setLayout(new GridLayout(5, 1));
                        RuleTitle ruleTitle6 = new RuleTitle("COMPARE", ruleTitle);
                        jPanel2.setBorder(lineBorder);
                        jPanel2.add(ruleTitle6);
                        jPanel2.add(new JLabel("value in column"));
                        final JTextField jTextField = new JTextField(this.colName, 10);
                        jPanel2.add(jTextField);
                        jPanel2.add(new JLabel("=="));
                        final JTextField jTextField2 = new JTextField(this.valEquals, 10);
                        jPanel2.add(jTextField2);
                        DocumentListener documentListener = new DocumentListener(){

                            public void myAction() {
                                RuleNode.this.colName = jTextField.getText();
                                RuleNode.this.valEquals = jTextField2.getText();
                            }

                            public void changedUpdate(DocumentEvent documentEvent) {
                                this.myAction();
                            }

                            public void insertUpdate(DocumentEvent documentEvent) {
                                this.myAction();
                            }

                            public void removeUpdate(DocumentEvent documentEvent) {
                                this.myAction();
                            }
                        };
                        jTextField.getDocument().addDocumentListener(documentListener);
                        jTextField2.getDocument().addDocumentListener(documentListener);
                        break;
                    }
                    case 6: {
                        jPanel2.setLayout(new GridLayout(5, 1));
                        RuleTitle ruleTitle7 = new RuleTitle("GREATER THAN", ruleTitle);
                        jPanel2.setBorder(lineBorder);
                        jPanel2.add(ruleTitle7);
                        jPanel2.add(new JLabel("value in column"));
                        final JTextField jTextField = new JTextField(this.colName, 10);
                        jPanel2.add(jTextField);
                        jPanel2.add(new JLabel(">"));
                        final JTextField jTextField3 = new JTextField(this.valEquals, 10);
                        jPanel2.add(jTextField3);
                        DocumentListener documentListener = new DocumentListener(){

                            public void myAction() {
                                RuleNode.this.colName = jTextField.getText();
                                RuleNode.this.valEquals = jTextField3.getText();
                            }

                            public void changedUpdate(DocumentEvent documentEvent) {
                                this.myAction();
                            }

                            public void insertUpdate(DocumentEvent documentEvent) {
                                this.myAction();
                            }

                            public void removeUpdate(DocumentEvent documentEvent) {
                                this.myAction();
                            }
                        };
                        jTextField.getDocument().addDocumentListener(documentListener);
                        jTextField3.getDocument().addDocumentListener(documentListener);
                        break;
                    }
                    case 7: {
                        jPanel2.setLayout(new GridLayout(5, 1));
                        RuleTitle ruleTitle8 = new RuleTitle("LESS THAN", ruleTitle);
                        jPanel2.setBorder(lineBorder);
                        jPanel2.add(ruleTitle8);
                        jPanel2.add(new JLabel("value in column"));
                        final JTextField jTextField = new JTextField(this.colName, 10);
                        jPanel2.add(jTextField);
                        jPanel2.add(new JLabel("<"));
                        final JTextField jTextField4 = new JTextField(this.valEquals, 10);
                        jPanel2.add(jTextField4);
                        DocumentListener documentListener = new DocumentListener(){

                            public void myAction() {
                                RuleNode.this.colName = jTextField.getText();
                                RuleNode.this.valEquals = jTextField4.getText();
                            }

                            public void changedUpdate(DocumentEvent documentEvent) {
                                this.myAction();
                            }

                            public void insertUpdate(DocumentEvent documentEvent) {
                                this.myAction();
                            }

                            public void removeUpdate(DocumentEvent documentEvent) {
                                this.myAction();
                            }
                        };
                        jTextField.getDocument().addDocumentListener(documentListener);
                        jTextField4.getDocument().addDocumentListener(documentListener);
                        break;
                    }
                    case 5: {
                        RuleTitle ruleTitle9 = new RuleTitle("NEGATE", ruleTitle);
                        ruleTitle9.setBorder(lineBorder);
                        jPanel2.add(ruleTitle9);
                        if (this.first != null) {
                            jPanel.add((Component)this.first.render(ruleTitle9), ReportDesigner.STR_CENTER);
                            break;
                        }
                        JPanel jPanel5 = new JPanel();
                        RuleTitle ruleTitle10 = new RuleTitle("<null>", ruleTitle9);
                        ruleTitle10.setBorder(lineBorder);
                        jPanel5.add(ruleTitle10);
                        jPanel.add((Component)jPanel5, ReportDesigner.STR_CENTER);
                        break;
                    }
                    default: {
                        jPanel2.add(new RuleTitle("Unknown type!", ruleTitle));
                    }
                }
                jPanel.setComponentPopupMenu(jPopupMenu);
                jPanel.addMouseListener(new MouseAdapter(){

                    public void mousePressed(MouseEvent mouseEvent) {
                        this.maybeShowPopup(mouseEvent);
                    }

                    public void mouseReleased(MouseEvent mouseEvent) {
                        this.maybeShowPopup(mouseEvent);
                    }

                    private void maybeShowPopup(MouseEvent mouseEvent) {
                        System.out.println("popup listener");
                        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                });
                return jPanel;
            }

            public RuleNode(RuleNode ruleNode, int n) {
                this.parent = ruleNode;
                this.ruleType = n;
            }

            public RuleNode(RuleNode ruleNode, int n, RuleNode ruleNode2) {
                this.parent = ruleNode;
                this.ruleType = n;
                this.first = ruleNode2;
            }

            public RuleNode(RuleNode ruleNode, int n, RuleNode ruleNode2, RuleNode ruleNode3) {
                this.parent = ruleNode;
                this.ruleType = n;
                this.first = ruleNode2;
                this.second = ruleNode3;
            }

            public RuleNode(RuleNode ruleNode, DynamicLine.EverythingRule everythingRule) {
                this.parent = ruleNode;
                this.ruleType = 2;
            }

            public RuleNode(RuleNode ruleNode, DynamicLine.BeliefRule beliefRule) {
                this.parent = ruleNode;
                this.ruleType = 3;
                this.nodeName = beliefRule.nodeName;
                this.stateNum = beliefRule.stateNumber;
                this.belief = beliefRule.beliefThreshold;
            }

            public RuleNode(RuleNode ruleNode, DynamicLine.DataFileValueEquals dataFileValueEquals) {
                this.parent = ruleNode;
                this.ruleType = 4;
                this.colName = dataFileValueEquals.dataColumnName;
                this.valEquals = dataFileValueEquals.equals;
            }

            public RuleNode(RuleNode ruleNode, DynamicLine.DataFileValueGreaterThan dataFileValueGreaterThan) {
                this.parent = ruleNode;
                this.ruleType = 6;
                this.colName = dataFileValueGreaterThan.dataColumnName;
                this.valEquals = dataFileValueGreaterThan.value;
            }

            public RuleNode(RuleNode ruleNode, DynamicLine.DataFileValueLessThan dataFileValueLessThan) {
                this.parent = ruleNode;
                this.ruleType = 7;
                this.colName = dataFileValueLessThan.dataColumnName;
                this.valEquals = dataFileValueLessThan.value;
            }

            public RuleNode(RuleNode ruleNode, DynamicLine.AndRule andRule) {
                this.parent = ruleNode;
                this.ruleType = 0;
                this.first = RuleEditor.this.createFromRule(this, andRule.first);
                this.second = RuleEditor.this.createFromRule(this, andRule.second);
            }

            public RuleNode(RuleNode ruleNode, DynamicLine.OrRule orRule) {
                this.parent = ruleNode;
                this.ruleType = 1;
                this.first = RuleEditor.this.createFromRule(this, orRule.first);
                this.second = RuleEditor.this.createFromRule(this, orRule.second);
            }

            public RuleNode(RuleNode ruleNode, DynamicLine.NegateRule negateRule) {
                this.parent = ruleNode;
                this.ruleType = 5;
                this.first = RuleEditor.this.createFromRule(this, negateRule.rule);
            }

            public DynamicLine.InclusionRule toInclusionRule(DynamicLine dynamicLine) {
                switch (this.ruleType) {
                    case 0: {
                        return dynamicLine.createAndRule(this.first != null ? this.first.toInclusionRule(dynamicLine) : dynamicLine.createEverythingRule(), this.second != null ? this.second.toInclusionRule(dynamicLine) : dynamicLine.createEverythingRule());
                    }
                    case 1: {
                        return dynamicLine.createOrRule(this.first != null ? this.first.toInclusionRule(dynamicLine) : dynamicLine.createEverythingRule(), this.second != null ? this.second.toInclusionRule(dynamicLine) : dynamicLine.createEverythingRule());
                    }
                    case 2: {
                        return dynamicLine.createEverythingRule();
                    }
                    case 3: {
                        return dynamicLine.createBeliefRule(this.nodeName, this.stateNum, this.belief);
                    }
                    case 4: {
                        return dynamicLine.createDataFileValueEquals(this.colName, this.valEquals);
                    }
                    case 6: {
                        return dynamicLine.createDataFileValueGreaterThan(this.colName, this.valEquals);
                    }
                    case 7: {
                        return dynamicLine.createDataFileValueLessThan(this.colName, this.valEquals);
                    }
                    case 5: {
                        return dynamicLine.createNegateRule(this.first != null ? this.first.toInclusionRule(dynamicLine) : dynamicLine.createEverythingRule());
                    }
                }
                return dynamicLine.createEverythingRule();
            }

            @Override
            public int compareTo(RuleNode ruleNode) {
                if (this == ruleNode) {
                    return 0;
                }
                if (this.hasDescendant(ruleNode)) {
                    return -1;
                }
                return 1;
            }

            private RuleNode getRoot() {
                if (this.parent == null) {
                    return this;
                }
                return this.parent.getRoot();
            }

            private boolean hasDescendant(RuleNode ruleNode) {
                if (this.ruleType == 1 || this.ruleType == 0) {
                    return this.first == null ? false : (this.first.hasDescendant(ruleNode) || this.second == null ? false : this.second.hasDescendant(ruleNode));
                }
                if (this.ruleType == 5) {
                    return this.first == null ? false : this.first.hasDescendant(ruleNode);
                }
                return false;
            }

            private boolean hasAncestor(RuleNode ruleNode) {
                return this.parent == null ? false : this.parent.hasAncestor(ruleNode);
            }

            private class RuleTitle
            extends JLabel {
                RuleTitle parentTitle;

                public RuleTitle(String string, RuleTitle ruleTitle) {
                    super(string);
                    this.parentTitle = ruleTitle;
                    RuleEditor.this.titles.add(this);
                }
            }
        }
    }

    private class TextLabelProperties
    extends Properties {
        private TextLabel textLabel;
        private JTextArea text;
        private JComboBox font;
        private JComboBox fontSize;
        private JComboBox alignment;

        public TextLabelProperties(TextLabel textLabel) {
            super("Text Label Properties");
            this.textLabel = textLabel;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            this.propertiesPanel.add(new JLabel("Text"));
            this.propertiesPanel.add(Box.createHorizontalStrut(50));
            this.text = new JTextArea(this.textLabel.getTextLabelText(), 10, 80);
            this.text.setLineWrap(true);
            JScrollPane jScrollPane = new JScrollPane(this.text);
            jScrollPane.setPreferredSize(new Dimension(300, 100));
            jScrollPane.setMinimumSize(new Dimension(300, 100));
            this.gridbag.setConstraints(jScrollPane, gridBagConstraints);
            this.propertiesPanel.add(jScrollPane);
            this.propertiesPanel.add(new JLabel("Font name"));
            this.font = new JComboBox<String>(new String[]{ReportDesigner.STR_COURIER, ReportDesigner.STR_HELVETICA, ReportDesigner.STR_TIMES_NEW});
            switch (this.textLabel.getTextLabelFont()) {
                case 0: {
                    this.font.setSelectedItem(ReportDesigner.STR_COURIER);
                    break;
                }
                case 1: {
                    this.font.setSelectedItem(ReportDesigner.STR_HELVETICA);
                    break;
                }
                case 2: {
                    this.font.setSelectedItem(ReportDesigner.STR_TIMES_NEW);
                }
            }
            this.gridbag.setConstraints(this.font, gridBagConstraints);
            this.propertiesPanel.add(this.font);
            this.propertiesPanel.add(new JLabel("Font size"));
            this.fontSize = new JComboBox<String>(new String[]{ReportDesigner.STR_BIG, ReportDesigner.STR_MEDIUM, ReportDesigner.STR_SMALL});
            switch (this.textLabel.getTextLabelSize()) {
                case 14: {
                    this.fontSize.setSelectedItem(ReportDesigner.STR_BIG);
                    break;
                }
                case 12: {
                    this.fontSize.setSelectedItem(ReportDesigner.STR_MEDIUM);
                    break;
                }
                case 10: {
                    this.fontSize.setSelectedItem(ReportDesigner.STR_SMALL);
                }
            }
            this.gridbag.setConstraints(this.fontSize, gridBagConstraints);
            this.propertiesPanel.add(this.fontSize);
            this.propertiesPanel.add(new JLabel("Alignment"));
            this.alignment = new JComboBox<String>(new String[]{ReportDesigner.STR_LEFT, ReportDesigner.STR_CENTER, ReportDesigner.STR_RIGHT});
            switch (this.textLabel.getAlignment()) {
                case 0: {
                    this.alignment.setSelectedItem(ReportDesigner.STR_LEFT);
                    break;
                }
                case 1: {
                    this.alignment.setSelectedItem(ReportDesigner.STR_CENTER);
                    break;
                }
                case 2: {
                    this.alignment.setSelectedItem(ReportDesigner.STR_RIGHT);
                }
            }
            this.gridbag.setConstraints(this.alignment, gridBagConstraints);
            this.propertiesPanel.add(this.alignment);
            this.pack();
        }

        public void apply() {
            this.textLabel.setProperties(this.text.getText(), this.font.getSelectedItem().equals(ReportDesigner.STR_COURIER) ? 0 : (this.font.getSelectedItem().equals(ReportDesigner.STR_HELVETICA) ? 1 : 2), this.fontSize.getSelectedItem().equals(ReportDesigner.STR_BIG) ? 14 : (this.fontSize.getSelectedItem().equals(ReportDesigner.STR_MEDIUM) ? 12 : 10));
            this.textLabel.setAlignment(this.alignment.getSelectedItem().equals(ReportDesigner.STR_LEFT) ? 0 : (this.alignment.getSelectedItem().equals(ReportDesigner.STR_CENTER) ? 1 : 2));
            ReportDesigner.this.redoLayout();
        }
    }

    private abstract class Properties
    extends JDialog {
        public JPanel propertiesPanel;
        public GridBagLayout gridbag;
        private boolean active;

        public Properties(String string) {
            super(ReportDesigner.this.reportDesignerFrame, string, false);
            this.active = true;
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(new FlowLayout(2));
            JButton jButton = new JButton("Apply");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Properties.this.apply();
                }
            });
            jPanel.add(jButton);
            JButton jButton2 = new JButton("Close");
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Properties.this.dispose();
                }
            });
            jPanel.add(jButton2);
            this.add((Component)jPanel, "South");
            this.propertiesPanel = new JPanel(){

                public Insets getInsets() {
                    return new Insets(5, 5, 5, 5);
                }
            };
            this.gridbag = new GridBagLayout();
            this.propertiesPanel.setLayout(this.gridbag);
            this.add((Component)this.propertiesPanel, ReportDesigner.STR_CENTER);
            this.setDefaultCloseOperation(2);
            if (ReportDesigner.this.propertiesPosition == null) {
                Point point = ReportDesigner.this.reportScroller.getLocationOnScreen();
                ReportDesigner.this.propertiesPosition = new Point(point.x + ((ReportDesigner)ReportDesigner.this).report.getVisibleRect().width, point.y);
            }
            this.setLocation(ReportDesigner.this.propertiesPosition);
        }

        public void dispose() {
            if (this.active) {
                ReportDesigner.this.propertiesPosition = this.getLocation();
                super.dispose();
                this.active = false;
            }
        }

        public abstract void apply();
    }
}

