

import be.ac.ulg.montefiore.run.jahmm.*;
import be.ac.ulg.montefiore.run.jahmm.learn.BaumWelchScaledLearner;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.*;

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 *
 * @author Vojta
 */
public class NewMain {

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) throws FileNotFoundException, IOException {
        ReadFasta read = new ReadFasta(new File("C://TP-Fasta.txt"));
        BaumWelchScaledLearner bw  = new  BaumWelchScaledLearner();
        List<List<ObservationDiscrete>> obs = read.readFile();
        Hmm learnedhmm = bw.learn(InitHmm(),obs);
        List<ObservationDiscrete> obs1 = obs.get(1);
        ViterbiCalculator vita = new ViterbiCalculator(obs1,learnedhmm);
        int[] sequence = vita.stateSequence();
        FileWriter wr = new FileWriter("C://old//pymol.txt");
        printPymolSegment(sequence,wr);
    }

     public static Hmm InitHmm(){
        ArrayList<OpdfDiscrete<AAcid>>  opdfs = new ArrayList(2);
        OpdfDiscrete<AAcid> opdf = null;
       double[] emit1 = {0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.01};
        opdf = new OpdfDiscrete(AAcid.C.getDeclaringClass(),emit1);
        opdfs.add(opdf.clone());
        double[] emit2 = {0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.04,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01,0.01};
        opdf = new OpdfDiscrete(AAcid.C.getDeclaringClass(),emit2);
        opdfs.add(opdf.clone());
        double[][] a =  {{3,1},{1,3}};
        double[] pi = {0.5,0.5};
        Hmm ihmm = new Hmm(pi,a,opdfs);
        return ihmm;
    }

     public static void printPymolSegment(int[] segmentation, FileWriter writer){
        try{
            int pos = 0;
            boolean color = true;
            for(int i = 0; i < segmentation.length - 1;i++){
                if(segmentation[i] != segmentation[i + 1]){
                    if(color){
                        writer.write("color red, resi " + pos+ "-" + i + "\n");
                        color = false;
                    }  else {
                        writer.write("color blue, resi " + pos + "-" + i + "\n");
                        color = true;
                    }
                    pos = i;
                }

            }
            writer.flush();
            writer.close();
        }  catch(IOException e){
            e.printStackTrace();
        }
    }
}
