/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HAPI;

import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExceptionUsage;
import COM.hugin.HAPI.Expression;
import COM.hugin.HAPI.ExpressionList;
import COM.hugin.HAPI.Native.HAPI;
import java.util.ListIterator;

public abstract class CompositeExpression
extends Expression {
    protected ExpressionList operands;

    protected CompositeExpression(Expression expression, int n) throws ExceptionHugin {
        if (expression == null) {
            throw new ExceptionUsage("Argument is 'null'");
        }
        this.operands = new ExpressionList();
        this.operands.add(expression);
    }

    protected CompositeExpression(Expression expression, Expression expression2, int n) throws ExceptionHugin {
        if (expression == null || expression2 == null) {
            throw new ExceptionUsage("Argument is 'null'");
        }
        this.operands = new ExpressionList();
        this.operands.add(expression);
        this.operands.add(expression2);
    }

    protected CompositeExpression(Expression expression, Expression expression2, Expression expression3, int n) throws ExceptionHugin {
        if (expression == null || expression2 == null || expression3 == null) {
            throw new ExceptionUsage("Argument is 'null'");
        }
        this.operands = new ExpressionList();
        this.operands.add(expression);
        this.operands.add(expression2);
        this.operands.add(expression3);
    }

    protected CompositeExpression(Expression expression, Expression expression2, Expression expression3, Expression expression4, int n) throws ExceptionHugin {
        if (expression == null || expression2 == null || expression3 == null || expression4 == null) {
            throw new ExceptionUsage("Argument is 'null'");
        }
        this.operands = new ExpressionList();
        this.operands.add(expression);
        this.operands.add(expression2);
        this.operands.add(expression3);
        this.operands.add(expression4);
    }

    protected CompositeExpression(ExpressionList expressionList, int n) throws ExceptionHugin {
        if (expressionList == null) {
            throw new ExceptionUsage("Argument is 'null'");
        }
        ListIterator listIterator = expressionList.listIterator();
        while (listIterator.hasNext()) {
            Expression expression = (Expression)listIterator.next();
            if (expression != null) continue;
            throw new ExceptionUsage("Argument is 'null'");
        }
        this.operands = (ExpressionList)expressionList.clone();
    }

    public ExpressionList getOperands() {
        return (ExpressionList)this.operands.clone();
    }

    public boolean isCompositeExpression() {
        return true;
    }

    protected int toNative() throws ExceptionHugin {
        int n = HAPI.nativeHAPI.hNewList(this.operands.size() + 1);
        if (n == 0) {
            ExceptionHugin.throwException();
        }
        assert (n != 0);
        try {
            int n2 = 0;
            HAPI.nativeHAPI.hListSetItem(n, n2, 0);
            ListIterator listIterator = this.operands.listIterator();
            while (listIterator.hasNext()) {
                Expression expression = (Expression)listIterator.next();
                assert (expression != null);
                HAPI.nativeHAPI.hListSetItem(n, n2++, expression.toNative());
                HAPI.nativeHAPI.hListSetItem(n, n2, 0);
            }
            int n3 = HAPI.nativeHAPI.hMakeCompositeExpression(this.getOperator(), n);
            if (n3 == 0) {
                ExceptionHugin.throwException();
            }
            assert (n3 != 0);
            int n4 = n3;
            return n4;
        }
        catch (ExceptionHugin exceptionHugin) {
            int n5;
            int n6 = 0;
            while ((n5 = HAPI.nativeHAPI.hListGetItem(n, n6)) != 0) {
                HAPI.nativeHAPI.hExpressionDelete(n5);
                ++n6;
            }
            throw exceptionHugin;
        }
        finally {
            HAPI.nativeHAPI.hListDelete(n);
        }
    }
}

