/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HAPI;

import COM.hugin.HAPI.Attribute;
import COM.hugin.HAPI.ExceptionArgumentNotAlive;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExceptionObjectNotAlive;
import COM.hugin.HAPI.ExceptionUsage;
import COM.hugin.HAPI.Native.HAPI;
import COM.hugin.HAPI.Node;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HAPI.ParseListener;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NetworkModel {
    protected int modelPeer = 0;
    private Object userData = null;
    private String logFile = null;
    public static final Category H_CATEGORY_INSTANCE = new Category(6);
    public static final Category H_CATEGORY_CHANCE = new Category(7);
    public static final Category H_CATEGORY_DECISION = new Category(8);
    public static final Category H_CATEGORY_UTILITY = new Category(9);
    public static final Category H_CATEGORY_FUNCTION = new Category(5);
    public static final Kind H_KIND_DISCRETE = new Kind(0);
    public static final Kind H_KIND_CONTINUOUS = new Kind(1);
    public static final Kind H_KIND_OTHER = new Kind(-1);
    public static final Constraint H_CONSTRAINT_NONE = new Constraint(100);
    public static final Constraint H_CONSTRAINT_EDGE_REQUIRED = new Constraint(101);
    public static final Constraint H_CONSTRAINT_FORWARD_EDGE_REQUIRED = new Constraint(102);
    public static final Constraint H_CONSTRAINT_BACKWARD_EDGE_REQUIRED = new Constraint(103);
    public static final Constraint H_CONSTRAINT_EDGE_FORBIDDEN = new Constraint(104);
    public static final Constraint H_CONSTRAINT_FORWARD_EDGE_FORBIDDEN = new Constraint(105);
    public static final Constraint H_CONSTRAINT_BACKWARD_EDGE_FORBIDDEN = new Constraint(106);

    protected Object clone() throws CloneNotSupportedException {
        NetworkModel networkModel = (NetworkModel)super.clone();
        networkModel.userData = null;
        networkModel.logFile = null;
        return networkModel;
    }

    public abstract void delete() throws ExceptionHugin;

    public String getAttribute(String string) throws ExceptionHugin {
        String string2 = HAPI.nativeHAPI.hDomainGetAttribute(this.thisPeer(), string);
        if (string2 == null) {
            ExceptionHugin.throwException();
        }
        return string2;
    }

    public LinkedList<Attribute> getAttributes() throws ExceptionHugin {
        return Attribute.createAttributeList(HAPI.nativeHAPI.hDomainGetFirstAttribute(this.thisPeer()));
    }

    public void generateTables() throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainGenerateTables(this.thisPeer()));
    }

    public String getFileName() throws ExceptionHugin {
        String string = HAPI.nativeHAPI.hDomainGetFileName(this.thisPeer());
        if (string == null) {
            ExceptionHugin.throwException();
        }
        return string;
    }

    public NodeList getNodes() throws ExceptionHugin {
        NodeList nodeList = new NodeList();
        int n = HAPI.nativeHAPI.hDomainGetFirstNode(this.thisPeer());
        while (n != 0) {
            nodeList.add(Node.convert(n));
            n = HAPI.nativeHAPI.hNodeGetNext(n);
        }
        ExceptionHugin.throwException();
        return nodeList;
    }

    public Node getNodeByName(String string) throws ExceptionHugin {
        return Node.convert(HAPI.nativeHAPI.hDomainGetNodeByName(this.thisPeer(), string));
    }

    public Point2D getNodeSize() throws ExceptionHugin {
        int n = this.thisPeer();
        int n2 = HAPI.nativeHAPI.hDomainGetNodeWidth(n);
        ExceptionHugin.throwException();
        int n3 = HAPI.nativeHAPI.hDomainGetNodeHeight(n);
        ExceptionHugin.throwException();
        return new Point2D.Double(n2, n3);
    }

    public void setAttribute(String string, String string2) throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainSetAttribute(this.thisPeer(), string, string2));
    }

    public synchronized void openLogFile(String string, boolean bl) throws ExceptionHugin {
        String string2 = string;
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainSetLogFile(this.thisPeer(), string, bl));
        this.logFile = string2;
    }

    public void openLogFile(String string) throws ExceptionHugin {
        this.openLogFile(string, false);
    }

    public synchronized void closeLogFile() throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainSetLogFile(this.thisPeer(), null, true));
        this.logFile = null;
    }

    public synchronized String getLogFile() throws ExceptionObjectNotAlive {
        if (!this.isAlive()) {
            throw new ExceptionObjectNotAlive();
        }
        return this.logFile;
    }

    public void setNodeSize(Point2D point2D) throws ExceptionHugin {
        if (point2D == null) {
            throw new ExceptionUsage("Argument is 'null'");
        }
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainSetNodeSize(this.thisPeer(), (int)point2D.getX(), (int)point2D.getY()));
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object object) {
        this.userData = object;
    }

    public void saveAsNet(String string) throws ExceptionHugin {
        ExceptionHugin.throwException(HAPI.nativeHAPI.hDomainSaveAsNet(this.thisPeer(), string));
    }

    public NodeList parseNodes(String string, ParseListener parseListener) throws ExceptionHugin {
        return new NodeList(HAPI.nativeHAPI.hDomainParseNodes(this.thisPeer(), string, parseListener));
    }

    protected static int convertNodeList(NodeList nodeList) throws ExceptionHugin {
        if (nodeList == null) {
            throw new ExceptionUsage("Argument is 'null'");
        }
        int n = HAPI.nativeHAPI.hNewList(nodeList.size() + 1);
        if (n == 0) {
            ExceptionHugin.throwException();
        }
        assert (n != 0);
        int n2 = 0;
        ListIterator listIterator = nodeList.listIterator();
        while (listIterator.hasNext()) {
            Node node = (Node)listIterator.next();
            if (!node.isAlive()) {
                HAPI.nativeHAPI.hListDelete(n);
                throw new ExceptionArgumentNotAlive();
            }
            HAPI.nativeHAPI.hListSetItem(n, n2++, node.nodePeer);
        }
        HAPI.nativeHAPI.hListSetItem(n, n2, 0);
        return n;
    }

    public static double INFINITY() {
        return HAPI.nativeHAPI.hINFINITY();
    }

    public boolean isAlive() {
        return this.modelPeer != 0;
    }

    protected final int thisPeer() throws ExceptionObjectNotAlive {
        if (this.modelPeer == 0) {
            throw new ExceptionObjectNotAlive();
        }
        return this.modelPeer;
    }

    public int getNumberOfChanceNodes() throws ExceptionObjectNotAlive {
        return HAPI.nativeHAPI.hDomainGetNumberOfChanceNodes(this.thisPeer());
    }

    public int getNumberOfDecisionNodes() throws ExceptionObjectNotAlive {
        return HAPI.nativeHAPI.hDomainGetNumberOfDecisionNodes(this.thisPeer());
    }

    public int getNumberOfUtilityNodes() throws ExceptionObjectNotAlive {
        return HAPI.nativeHAPI.hDomainGetNumberOfUtilityNodes(this.thisPeer());
    }

    public int getNumberOfInstanceNodes() throws ExceptionObjectNotAlive {
        return HAPI.nativeHAPI.hDomainGetNumberOfInstanceNodes(this.thisPeer());
    }

    public static void setRunning() {
        HAPI.nativeHAPI.hSetUpAndRunning();
    }

    public static String removeEscapeSequences(String string) throws ExceptionHugin {
        String string2 = HAPI.nativeHAPI.hRemoveEscapeSequences(string);
        if (string2 == null) {
            ExceptionHugin.throwException();
        }
        return string2;
    }

    public static String getOrganization() {
        return HAPI.nativeHAPI.hGetOrganization();
    }

    public static String getUserName() {
        return HAPI.nativeHAPI.hGetUserName();
    }

    public static String getPackageName() {
        return HAPI.nativeHAPI.hGetPackageName();
    }

    public static String getNativeID() {
        return HAPI.nativeHAPI.hGetAPIID();
    }

    public static String getJavaID() {
        return "HUGIN 7.3";
    }

    public static class Constraint
    implements Comparable {
        protected final int value;

        protected Constraint(int n) {
            this.value = n;
        }

        public int compareTo(Object object) {
            return this.value - ((Constraint)object).value;
        }
    }

    public static class Kind
    implements Comparable {
        protected final int value;

        protected Kind(int n) {
            this.value = n;
        }

        public int compareTo(Object object) {
            return this.value - ((Kind)object).value;
        }
    }

    public static class Category
    implements Comparable {
        protected final int value;

        protected Category(int n) {
            this.value = n;
        }

        public int compareTo(Object object) {
            return this.value - ((Category)object).value;
        }
    }
}

