/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.Class;
import COM.hugin.HAPI.ContinuousChanceNode;
import COM.hugin.HAPI.DiscreteNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.NetworkModel;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HGUI.HStroke;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.Link;
import COM.hugin.HGUI.NetworkPanel;
import COM.hugin.HGUI.Node;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JViewport;

public class AnalyzeNetworkPanel
extends NetworkPanel {
    private double threshold = 0.0;

    public AnalyzeNetworkPanel(Domain domain, HuginProjectFrame huginProjectFrame, MouseListener mouseListener, MouseMotionListener mouseMotionListener) {
        this.setBackground(Color.white);
        this.loadNet(domain);
        this.showGrid(false);
        this.addMouseListener(mouseListener);
        this.addMouseMotionListener(mouseMotionListener);
        this.projectFrame = huginProjectFrame;
    }

    protected Rectangle getViewRect() {
        Rectangle rectangle = null;
        try {
            rectangle = ((JViewport)this.getParent()).getViewRect();
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        return rectangle;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        try {
            for (Node node : this.nodeList) {
                int n = (int)Math.round(12.0 * node.getScaleFactor());
                COM.hugin.HAPI.Node node2 = node.getAPINode();
                if (!(node2 instanceof DiscreteNode) && !(node2 instanceof ContinuousChanceNode) || !node2.evidenceIsEntered()) continue;
                Stroke stroke = ((Graphics2D)graphics).getStroke();
                Color color = graphics.getColor();
                ((Graphics2D)graphics).setStroke(HStroke.BASIC_STROKE);
                graphics.setColor(Color.white);
                graphics.fillRect(node.getX() + node.getWidth() - n, node.getY() + node.getHeight() - n, n, n);
                graphics.setColor(Color.black);
                graphics.drawRect(node.getX() + node.getWidth() - n, node.getY() + node.getHeight() - n, n, n);
                ((Graphics2D)graphics).setStroke(stroke);
                graphics.setColor(Hugin.mainFrame.preferences.barColors.get(1));
                graphics.setFont(graphics.getFont().deriveFont(1, (float)(12.0 * this.getScaleFactor())));
                graphics.drawString("e", node.getX() + node.getWidth() - n + (int)Math.round(4.0 * this.getScaleFactor()), node.getY() + node.getHeight() - n + (int)Math.round(11.0 * this.getScaleFactor()));
                graphics.setColor(color);
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
    }

    protected void loadNet(NetworkModel networkModel, boolean bl) {
        this.home = networkModel;
        try {
            this.readDomainAttributes();
            NodeList nodeList = networkModel.getNodes();
            for (COM.hugin.HAPI.Node node : nodeList) {
                if (AnalyzeNetworkPanel.isOutputClone(node)) continue;
                Node node2 = this.createNodeFromAPINode(node);
                if (node2 != null) {
                    this.nodeList.add(node2);
                    if (networkModel instanceof Class) {
                        node2.setInterfaceType();
                    }
                    this.isEmpty(false);
                    continue;
                }
                new HuginGUIError("NetworkPanel.loadNet", "Unknown node class!");
            }
            for (COM.hugin.HAPI.Node node : nodeList) {
                for (COM.hugin.HAPI.Node node3 : node.getChildren()) {
                    this.linkList.add(new Link(this.getNode(node), this.getNode(node3), this.scaleFactor));
                }
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
            this.snapToGrid = true;
            this.showGrid = false;
        }
        this.readNodeAttributes();
        this.updateButtonAndMenuStates();
        this.setGraphicsSize();
    }

    protected double getMinMutualInformation() {
        double d = 1.0;
        for (Link link : this.linkList) {
            double d2 = link.getStrength();
            if (d2 == Double.MIN_VALUE) continue;
            d = Math.min(d, d2);
        }
        return d;
    }

    protected double getMaxMutualInformation() {
        double d = 1.0;
        for (Link link : this.linkList) {
            d = Math.max(d, link.getStrength());
        }
        return d;
    }

    protected void setThreshold(double d) {
        for (Link link : this.linkList) {
            boolean bl;
            boolean bl2 = bl = link.getStrength() >= d;
            if (link.isVisible() == bl) continue;
            link.setVisible(bl);
            this.repaint(link.getBoundingBox());
        }
        this.threshold = d;
    }
}

