/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.Node;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HGUI.GenericTable;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.Inverter;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class BarNodeTable
extends GenericTable {
    TableCellEditor editor;
    BarNodeTableCellRenderer renderer;
    Color barColor = new Color(0, 0, 150);
    private int displayMode = 0;
    private boolean normalize;
    private EditBarListener editBarListener = null;
    public static final int STANDARD = 0;
    public static final int NORMAL_BARS = 1;
    public static final int NORMALIZED_BARS = 2;
    public static final int BARS_NO_TEXT = 3;
    public static final int PROBABILITY_WHEEL = 4;
    protected static final int decimalsInBarMode = 4;

    public BarNodeTable(Node node) throws ExceptionHugin {
        super(node);
        this.renderer = new BarNodeTableCellRenderer(false);
        this.editor = new BarNodeTableCellEditor(false);
        this.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                BarNodeTable.this.repaint();
            }
        });
        this.setDefaultRenderer(Object.class, this.renderer);
        this.setDefaultRenderer(Double.class, this.renderer);
        this.setCellEditor(this.editor);
        this.normalize = true;
        this.renderer.normalize(this.normalize);
        ((BarNodeTableCellEditor)this.editor).normalize(this.normalize);
    }

    public BarNodeTable(Node node, NodeList nodeList) throws ExceptionHugin {
        super(node, nodeList);
        this.normalize = true;
    }

    public BarNodeTable(Node node, NodeList nodeList, boolean bl) throws ExceptionHugin {
        super(node, nodeList, bl);
        this.normalize = true;
    }

    public BarNodeTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
        this.normalize = true;
    }

    public void setDisplayMode(int n) throws ExceptionHugin {
        int n2 = this.displayMode;
        this.displayMode = n;
        switch (this.displayMode) {
            case 0: {
                this.renderer.useBars(false);
                ((BarNodeTableCellEditor)this.editor).useBars(false);
                if (this.editBarListener == null) break;
                this.removeMouseMotionListener(this.editBarListener);
                break;
            }
            case 1: {
                if (this.autoNormalize()) {
                    this.normalize();
                }
                if (this.editBarListener == null) {
                    this.editBarListener = new EditBarListener();
                }
                if (n2 == 0) {
                    this.addMouseMotionListener(this.editBarListener);
                }
                this.renderer.useBars(true);
                ((BarNodeTableCellEditor)this.editor).useBars(true);
                this.renderer.showText(true);
                ((BarNodeTableCellEditor)this.editor).showText(true);
                break;
            }
            case 3: {
                if (this.autoNormalize()) {
                    this.normalize();
                }
                if (this.editBarListener == null) {
                    this.editBarListener = new EditBarListener();
                }
                if (n2 == 0) {
                    this.addMouseMotionListener(this.editBarListener);
                }
                this.renderer.useBars(true);
                ((BarNodeTableCellEditor)this.editor).useBars(true);
                this.renderer.showText(false);
                ((BarNodeTableCellEditor)this.editor).showText(false);
            }
        }
    }

    private double calculateMaxValue(int n) {
        try {
            int n2 = this.getRowCount();
            double[] dArray = new double[n2];
            this.node.getTable().getData(dArray, n * n2, n2);
            double d = 0.0;
            for (int i = 0; i < n2; ++i) {
                d += dArray[i];
            }
            return d;
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
            return 1.0;
        }
    }

    public boolean canCopy() {
        return this.displayMode == 0 && super.canCopy();
    }

    public boolean canPaste() {
        return this.displayMode == 0 && super.canPaste();
    }

    protected void changeNode(Node node) throws ExceptionHugin {
        super.changeNode(node);
        if (this.normalize && this.displayMode != 0) {
            this.normalize();
        }
    }

    public void autoNormalize(boolean bl) throws ExceptionHugin {
        this.normalize = bl;
        this.normalize();
        ((BarNodeTableCellEditor)this.editor).normalize(bl);
        this.renderer.normalize(bl);
    }

    public boolean autoNormalize() {
        return this.normalize;
    }

    public int getDisplayMode() {
        return this.displayMode;
    }

    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (keyStroke.getModifiers() == 2 && (this.getSelectedColumns().length > 1 || this.getSelectedRows().length > 1)) {
            return false;
        }
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    public TableCellEditor getCellEditor() {
        return this.editor;
    }

    public TableCellEditor getCellEditor(int n, int n2) {
        return this.editor;
    }

    public void repaintColumn(int n) {
        int n2 = 0;
        TableColumnModel tableColumnModel = this.getColumnModel();
        for (int i = 0; i < n; ++i) {
            n2 += tableColumnModel.getColumn(i).getWidth();
        }
        this.repaint(n2, 0, n2 + tableColumnModel.getColumn(n).getWidth(), this.getHeight());
    }

    protected String convertDouble(double d) {
        return HuginGUIUtils.printDouble(d, this.getPrecision(), !this.getForceDecimals(), this.getForceDecimals());
    }

    protected String convertEditableDouble(double d) {
        return HuginGUIUtils.printDouble(d, 140, !this.getForceDecimals(), this.getForceDecimals());
    }

    protected static String fitString(Graphics graphics, int n, String string) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string2 = "...";
        if (fontMetrics.stringWidth(string) <= n) {
            return string;
        }
        while (fontMetrics.stringWidth(string + string2) > n && string.length() > 0) {
            string = string.substring(0, string.length() - 1);
        }
        return string + string2;
    }

    private class EditBarListener
    extends MouseMotionAdapter {
        private EditBarListener() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n = BarNodeTable.this.getEditingRow();
            int n2 = BarNodeTable.this.getEditingColumn();
            int n3 = BarNodeTable.this.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
            int n4 = BarNodeTable.this.columnAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
            if (n3 != n || n4 != n2) {
                BarNodeTable.this.editCellAt(n3, n4);
            }
        }
    }

    protected class BarNodeTableCellEditor
    extends DefaultCellEditor {
        JTextField field;
        boolean useBars;
        boolean normalize;
        boolean showText;
        EditableBarNodeTableCell barField;

        public BarNodeTableCellEditor(boolean bl) {
            super(new JTextField());
            this.useBars = bl;
            this.normalize = false;
            this.field = new JTextField(){
                private String text;
                private boolean first;

                public void setText(String string) {
                    this.text = string;
                    this.first = true;
                    super.setText(string);
                }

                public void paintComponent(Graphics graphics) {
                    if (this.first) {
                        this.first = false;
                        super.setText(this.text);
                        this.setCaretPosition(BarNodeTableCellEditor.this.field.getText().length() - 1);
                        this.getCaret().setVisible(true);
                        this.setSelectionStart(0);
                        this.setSelectionEnd(BarNodeTableCellEditor.this.field.getText().length());
                        this.getCaret().setSelectionVisible(true);
                    }
                    super.paintComponent(graphics);
                    Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                    if (component != BarNodeTable.this && component != this) {
                        BarNodeTableCellEditor.this.stopCellEditing();
                    }
                }

                public void paste() {
                    try {
                        if (BarNodeTable.this.bufferContainsMultipleCells()) {
                            BarNodeTable.this.pasteSelection();
                        } else {
                            super.paste();
                        }
                    }
                    catch (Exception exception) {
                        super.paste();
                    }
                }
            };
            this.field.setBorder(BorderFactory.createEtchedBorder(1));
            this.field.setMargin(new Insets(0, 0, 0, 0));
            this.barField = new EditableBarNodeTableCell();
        }

        public void useBars(boolean bl) {
            this.useBars = bl;
        }

        public void normalize(boolean bl) {
            this.normalize = bl;
        }

        public void showText(boolean bl) {
            this.showText = bl;
        }

        public Object getCellEditorValue() {
            return this.useBars ? new Double(this.barField.value) : this.field.getText();
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (!this.useBars) {
                this.field.setText(object == null ? "" : BarNodeTable.this.convertEditableDouble(Double.parseDouble(object.toString())));
                this.field.setCaretPosition(this.field.getText().length() - 1);
                this.field.getCaret().setVisible(true);
                this.field.setSelectionStart(0);
                this.field.setSelectionEnd(this.field.getText().length());
                this.field.getCaret().setSelectionVisible(true);
                return this.field;
            }
            try {
                if (object instanceof Double) {
                    object = HuginGUIUtils.printDouble((Double)object, BarNodeTable.this.getPrecision(), !BarNodeTable.this.getForceDecimals(), BarNodeTable.this.getForceDecimals(), true);
                }
                this.barField.setNodeColumn(n2 + ((GenericTable)jTable).getViewPosition());
                this.barField.setPosition(n, n2);
                this.barField.setBorder(null);
                this.barField.setValue(object == null ? 0.0 : Double.parseDouble(object.toString()));
            }
            catch (Exception exception) {
                this.barField.setValue(0.0);
            }
            return this.barField;
        }

        private class EditableBarNodeTableCell
        extends JPanel {
            double value = 0.0;
            double maxValue;
            double sum = 0.0;
            int column = -1;
            int row = -1;
            int nodeColumn = -1;
            Insets insets = new Insets(1, 1, 1, 1);

            public EditableBarNodeTableCell() {
                this.addMouseListener(new MouseAdapter(){

                    public void mousePressed(MouseEvent mouseEvent) {
                        EditableBarNodeTableCell.this.updateCells(mouseEvent.getX());
                    }
                });
                this.addMouseMotionListener(new MouseMotionAdapter(){

                    public void mouseDragged(MouseEvent mouseEvent) {
                        EditableBarNodeTableCell.this.updateCells(mouseEvent.getX());
                    }
                });
            }

            public void setValue(double d) {
                this.value = d;
            }

            public void setPosition(int n, int n2) {
                this.sum = 0.0;
                try {
                    for (int i = 0; i < BarNodeTable.this.getRowCount(); ++i) {
                        this.sum += Double.parseDouble(BarNodeTable.this.getValueAt(i, n2).toString());
                    }
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
                this.maxValue = BarNodeTable.this.calculateMaxValue(this.nodeColumn);
                if (this.maxValue == 0.0) {
                    this.maxValue = 1.0;
                }
                this.column = n2;
                this.row = n;
            }

            public Insets getInsets() {
                return this.insets;
            }

            public void setNodeColumn(int n) {
                this.nodeColumn = n;
            }

            private void updateCells(int n) {
                if (n < 0 || n > this.getWidth()) {
                    return;
                }
                if (BarNodeTableCellEditor.this.normalize) {
                    double d = 1.0 - this.value;
                    double d2 = (double)n / (double)this.getWidth();
                    double d3 = 1.0 - d2;
                    this.setValue(d2);
                    double d4 = 0.0;
                    try {
                        BarNodeTable.this.setValueAt(new Double(d2), this.row, this.column);
                        for (int i = 0; i < BarNodeTable.this.getRowCount(); ++i) {
                            double d5;
                            if (i == this.row) continue;
                            if (d != 0.0) {
                                d5 = Double.parseDouble(BarNodeTable.this.getValueAt(i, this.column).toString());
                                d5 = d3 * (d5 / d);
                            } else {
                                d5 = d3 / (double)(BarNodeTable.this.getRowCount() - 1);
                            }
                            BarNodeTable.this.setValueAt(new Double(d5), i, this.column);
                        }
                    }
                    catch (Exception exception) {
                        new HuginGUIError(exception);
                    }
                } else {
                    this.setValue(this.maxValue * (double)n / (double)this.getWidth());
                }
                BarNodeTable.this.repaintColumn(this.column);
            }

            public void paintComponent(Graphics graphics) {
                double d = this.value;
                graphics.setColor(Color.white);
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                if (BarNodeTableCellEditor.this.normalize && this.sum > 0.0) {
                    d = this.value / this.sum;
                }
                BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
                Graphics graphics2 = bufferedImage.getGraphics();
                graphics2.setColor(Color.white);
                graphics2.fillRect(0, 0, this.getWidth(), this.getHeight());
                graphics2.setColor(Color.black);
                if (BarNodeTableCellEditor.this.showText) {
                    graphics2.drawString(BarNodeTable.fitString(graphics, this.getWidth() - (this.getInsets().left + this.getInsets().right), HuginGUIUtils.printDouble(d, BarNodeTable.this.getPrecision(), !BarNodeTable.this.getForceDecimals(), BarNodeTable.this.getForceDecimals(), true)), this.getInsets().left, this.getHeight() - 2);
                }
                if (!BarNodeTableCellEditor.this.normalize) {
                    d = this.value / BarNodeTable.this.calculateMaxValue(this.nodeColumn);
                }
                graphics2.setColor(BarNodeTable.this.barColor);
                Inverter.fillInverted(bufferedImage, new Rectangle(1, 1, (int)(d * (double)(this.getWidth() - 2)), this.getHeight() - 2), BarNodeTable.this.barColor, Color.white);
                graphics.drawImage(bufferedImage, 0, 0, this);
            }
        }
    }

    protected class BarNodeTableCellRenderer
    extends DefaultTableCellRenderer {
        boolean useBars;
        boolean showText;
        boolean normalize;
        BarNodeTableCell barField;

        public BarNodeTableCellRenderer(boolean bl) {
            this.useBars = bl;
            this.showText = true;
            this.normalize = false;
            this.barField = new BarNodeTableCell();
        }

        public void useBars(boolean bl) {
            this.useBars = bl;
        }

        public void showText(boolean bl) {
            this.showText = bl;
        }

        public void normalize(boolean bl) {
            this.normalize = bl;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (component != BarNodeTable.this) {
                bl = false;
            }
            bl2 = false;
            if (!this.useBars) {
                if (object instanceof Double) {
                    if (jTable instanceof GenericTable) {
                        try {
                            object = HuginGUIUtils.printDouble((Double)object, BarNodeTable.this.getPrecision(), !BarNodeTable.this.getForceDecimals(), BarNodeTable.this.getForceDecimals(), true);
                        }
                        catch (Exception exception) {
                            object = BarNodeTable.this.convertDouble((Double)object);
                        }
                    } else {
                        object = BarNodeTable.this.convertDouble((Double)object);
                    }
                }
                Component component2 = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                return component2;
            }
            try {
                if (object instanceof Double) {
                    object = HuginGUIUtils.printDouble((Double)object, BarNodeTable.this.getPrecision(), !BarNodeTable.this.getForceDecimals(), BarNodeTable.this.getForceDecimals(), true);
                }
                this.barField.setEnabled(!object.equals("..."));
                this.barField.setCollapsed(object.equals("..."));
                this.barField.setValue(object == null ? 0.0 : Double.parseDouble(object.toString()));
                this.barField.setColumn(n2);
                this.barField.setNodeColumn(n2 + ((GenericTable)jTable).getViewPosition());
                this.barField.setSelected(false);
            }
            catch (Exception exception) {
                this.barField.setValue(0.0);
            }
            return this.barField;
        }

        private class BarNodeTableCell
        extends JPanel {
            double value = 0.0;
            int column = 0;
            int nodeColumn;
            Insets insets = new Insets(1, 1, 1, 1);
            Color background;
            Color selectBackground = UIManager.getDefaults().getColor("TextField.selectionBackground");
            Color disabledBackground = UIManager.getDefaults().getColor("ToggleButton.disabledBackground");
            boolean selected = false;
            boolean collapsed = false;

            public Insets getInsets() {
                return this.insets;
            }

            public void setValue(double d) {
                this.value = d;
            }

            public void setColumn(int n) {
                this.column = n;
            }

            public void setNodeColumn(int n) {
                this.nodeColumn = n;
            }

            public void setCollapsed(boolean bl) {
                this.collapsed = bl;
            }

            public void setSelected(boolean bl) {
                this.selected = bl;
                this.background = bl ? this.selectBackground : BarNodeTable.this.getBackground();
            }

            public void setEnabled(boolean bl) {
                this.background = bl ? (this.selected ? this.selectBackground : BarNodeTable.this.getBackground()) : this.disabledBackground;
            }

            public void paintComponent(Graphics graphics) {
                BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
                Graphics graphics2 = bufferedImage.getGraphics();
                graphics2.setColor(this.background);
                graphics2.fillRect(0, 0, this.getWidth(), this.getHeight());
                Rectangle rectangle = graphics.getClipBounds();
                Rectangle2D rectangle2D = rectangle.createIntersection(new Rectangle2D.Float(this.insets.left, this.insets.top, this.getWidth() - (this.insets.left + this.insets.right), this.getHeight() - (this.insets.top + this.insets.bottom)));
                graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                double d = this.value;
                double d2 = 0.0;
                String string = "...";
                if (this.isEnabled() && !this.collapsed) {
                    string = HuginGUIUtils.printDouble(d, BarNodeTable.this.getPrecision(), BarNodeTable.this.getPrecision() > 0, BarNodeTable.this.getForceDecimals(), true);
                }
                if (!BarNodeTableCellRenderer.this.normalize) {
                    d = this.value / BarNodeTable.this.calculateMaxValue(this.nodeColumn);
                }
                graphics2.setColor(Color.black);
                if (BarNodeTableCellRenderer.this.showText || !this.isEnabled()) {
                    graphics2.drawString(BarNodeTable.fitString(graphics, this.getWidth() - (this.insets.left + this.insets.right), string), this.insets.left, this.getHeight() - 2);
                }
                Inverter.fillInverted(bufferedImage, new Rectangle(this.insets.left, this.insets.top, (int)(d * (double)(this.getWidth() - (this.insets.left + this.insets.right))), this.getHeight() - (this.insets.top + this.insets.bottom)), BarNodeTable.this.barColor, Color.white);
                graphics.drawImage(bufferedImage, 0, 0, this);
            }
        }
    }
}

