/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.ContinuousChanceNode;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.NetworkModel;
import COM.hugin.HGUI.BeliefBarCC;
import COM.hugin.HGUI.BeliefBarCCNodePainter;
import COM.hugin.HGUI.BeliefBarNode;
import COM.hugin.HGUI.BeliefBarTree;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIFrame;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.NodeGroup;
import COM.hugin.HGUI.Preferences;
import javax.swing.tree.TreePath;

class BeliefBarCCNode
extends BeliefBarNode {
    public ContinuousChanceNode getNode() {
        return (ContinuousChanceNode)this.node;
    }

    public ContinuousChanceNode getOriginalNode() {
        return (ContinuousChanceNode)this.originalNode;
    }

    public BeliefBarCCNode(ContinuousChanceNode continuousChanceNode, ContinuousChanceNode continuousChanceNode2, Preferences preferences) throws ExceptionHugin {
        Object object;
        int n;
        this.preferences = preferences;
        this.color = preferences.barColors.get(0);
        this.domain = continuousChanceNode.getHomeDomain();
        this.originalNode = continuousChanceNode2;
        this.name = continuousChanceNode2.getLabel();
        if (this.name.length() == 0) {
            this.name = continuousChanceNode2.getName();
        }
        if ((n = this.name.lastIndexOf(".")) >= 0 && n < 10000) {
            this.name = this.name.substring(n + 1);
        }
        this.node = continuousChanceNode;
        NetworkModel networkModel = continuousChanceNode2.getHome();
        String string = continuousChanceNode2.getAttribute("HR_Grp");
        if (string != null && string.length() > 0) {
            object = networkModel.getAttribute("HR_Groups_GroupColors");
            int n2 = Integer.parseInt(string);
            String string2 = ((String)object).substring(n2 * 2, n2 * 2 + 2);
            this.groupColor = NodeGroup.index2color(Integer.parseInt(string2));
        } else {
            this.groupColor = null;
        }
        object = HuginGUIFrame.getProjectFrame(networkModel);
        Node node = null;
        if (object != null) {
            node = ((HuginProjectFrame)object).networkPanel.getNode(continuousChanceNode2.getName());
        }
        if (node != null) {
            this.groupColor = node.getGroupIndex() >= 0 ? node.fillColor : null;
        }
        boolean bl = continuousChanceNode.evidenceIsEntered();
        this.add(new BeliefBarCC(this, HuginGUIConstants.get("MISCELLANEOUS_Mean"), bl ? continuousChanceNode.getEnteredValue() : continuousChanceNode.getMean()));
        this.add(new BeliefBarCC(this, HuginGUIConstants.get("MISCELLANEOUS_Variance"), bl ? 0.0 : continuousChanceNode.getVariance()));
        this.painter = new BeliefBarCCNodePainter(this);
    }

    public BeliefBarCCNode(ContinuousChanceNode continuousChanceNode, ContinuousChanceNode continuousChanceNode2, String string, Preferences preferences) throws ExceptionHugin {
        this(continuousChanceNode, continuousChanceNode2, preferences);
        this.name = string;
    }

    public void setSelectedNode(COM.hugin.HAPI.Node node, BeliefBarTree beliefBarTree) {
        if (this.node == node) {
            this.painter.setSelected(true);
            beliefBarTree.selected = this;
            beliefBarTree.setSelectionPath(new TreePath(this.painter.getOwner().getPath()));
        }
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            ((BeliefBarNode)this.getChildAt(i)).setSelectedNode(node, beliefBarTree);
        }
    }

    public void update() {
        try {
            ContinuousChanceNode continuousChanceNode = this.getNode();
            boolean bl = continuousChanceNode.evidenceIsEntered();
            BeliefBarCC beliefBarCC = (BeliefBarCC)this.getChildAt(0);
            beliefBarCC.update(bl ? continuousChanceNode.getEnteredValue() : continuousChanceNode.getMean());
            beliefBarCC = (BeliefBarCC)this.getChildAt(1);
            beliefBarCC.update(bl ? 0.0 : continuousChanceNode.getVariance());
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    protected boolean containsEvidence() throws ExceptionHugin {
        return this.node.evidenceIsEntered();
    }

    protected boolean containsLikelihood() throws ExceptionHugin {
        return this.node.likelihoodIsEntered();
    }
}

