/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.CliqueList;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HGUI.Clique;
import COM.hugin.HGUI.CliqueLink;
import COM.hugin.HGUI.HuginGUIUtils;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CliqueModel {
    private COM.hugin.HAPI.Clique clique;
    Clique parent;
    CliqueLink parentLink = null;
    LinkedList<Clique> children;

    public CliqueModel(COM.hugin.HAPI.Clique clique) {
        this.clique = clique;
        this.children = new LinkedList();
    }

    public NodeList getNodes() throws ExceptionHugin {
        return this.clique.getMembers();
    }

    public int getNumberOfNodes() throws ExceptionHugin {
        return this.clique.getMembers().size();
    }

    public CliqueList getNeighbours() throws ExceptionHugin {
        return this.clique.getNeighbors();
    }

    public long getSize() throws ExceptionHugin {
        return HuginGUIUtils.calculateCliqueSize(this.getAPIClique());
    }

    public boolean cgEvidenceIsPropagated() throws ExceptionHugin {
        return this.clique.getJunctionTree().cgEvidenceIsPropagated();
    }

    public double getConflict() throws ExceptionHugin {
        if (this.clique.getJunctionTree().equilibriumIs(Domain.H_EQUILIBRIUM_MAX)) {
            return 0.0;
        }
        return Math.log(this.clique.getConflict());
    }

    public double getMaxConflict() throws ExceptionHugin {
        if (this.clique.getJunctionTree().equilibriumIs(Domain.H_EQUILIBRIUM_MAX)) {
            return 0.0;
        }
        double d = Math.abs(Math.log(this.clique.getJunctionTree().getConflict()));
        for (COM.hugin.HAPI.Clique clique : this.clique.getJunctionTree().getCliques()) {
            d = Math.max(d, Math.abs(Math.log(clique.getConflict())));
        }
        return d;
    }

    public void setParent(Clique clique) {
        this.parent = clique;
    }

    public void setParentLink(CliqueLink cliqueLink) {
        this.parentLink = cliqueLink;
    }

    public CliqueLink getParentLink() {
        return this.parentLink;
    }

    public void addChild(Clique clique) {
        if (this.children == null) {
            this.children = new LinkedList();
        }
        if (!this.children.contains(clique)) {
            this.children.add(clique);
        }
    }

    public boolean isParent(COM.hugin.HAPI.Clique clique) {
        return this.parent == null ? false : this.parent.getAPIClique() == clique;
    }

    public boolean isChild(COM.hugin.HAPI.Clique clique) {
        if (this.children != null) {
            for (Clique clique2 : this.children) {
                if (clique2.getAPIClique() != clique) continue;
                return true;
            }
        }
        return false;
    }

    public LinkedList<Clique> getChildren() {
        return this.children;
    }

    protected COM.hugin.HAPI.Clique getAPIClique() {
        return this.clique;
    }
}

