/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class ColorPanel
extends JPanel {
    ColorButton[] colors = new ColorButton[64];
    public HashMap<Integer, Color> colorIDs;
    public HashMap<Color, Integer> IDcolors;
    int width = 15;
    int height = 17;
    Integer selected;
    int[] rr = new int[]{255, 192, 128, 0};
    int[] gg = new int[]{255, 192, 128, 0};
    int[] bb = new int[]{255, 192, 128, 0};

    public ColorPanel() {
        this.colorIDs = new HashMap();
        this.IDcolors = new HashMap();
        ColorListener colorListener = new ColorListener();
        this.selected = new Integer(0);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    int n = i * 16 + j * 4 + k;
                    Color color = new Color(this.rr[j], this.gg[k], this.bb[i]);
                    Integer n2 = new Integer(n);
                    this.colorIDs.put(n2, color);
                    this.IDcolors.put(color, n2);
                    this.colors[n] = new ColorButton(new ColorIcon(color));
                    this.colors[n].setMinimumSize(new Dimension(this.width, this.height));
                    this.colors[n].setPreferredSize(new Dimension(this.width, this.height));
                    this.colors[n].setMaximumSize(new Dimension(this.width, this.height));
                    this.colors[n].setActionCommand("" + n);
                    this.colors[n].addActionListener(colorListener);
                }
            }
        }
        this.buildChooser();
    }

    public void buildChooser() {
        this.setLayout(new GridLayout(4, 16));
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    this.add(this.colors[i + j * 16 + k * 4]);
                }
            }
        }
    }

    public void setColor(int n) {
        if (this.selected != null) {
            this.colors[this.selected].setSelected(false);
        }
        this.selected = new Integer(n);
        this.colors[this.selected].setSelected(true);
    }

    public void setColor(Color color) {
        Integer n = this.IDcolors.get(color);
        if (this.selected != null) {
            this.colors[this.selected].setSelected(false);
        }
        this.selected = n;
        if (this.selected != null) {
            this.colors[this.selected].setSelected(true);
        }
    }

    public int getColorIndex() {
        if (this.selected == null) {
            return -1;
        }
        return this.selected;
    }

    public Color getColor() {
        if (this.selected == null) {
            return null;
        }
        return this.colors[this.selected].getColor();
    }

    private class ColorButton
    extends JToggleButton {
        private ColorIcon icon;

        public ColorButton(ColorIcon colorIcon) {
            super(colorIcon);
            this.icon = colorIcon;
        }

        public Color getColor() {
            return this.icon.getColor();
        }
    }

    private class ColorListener
    implements ActionListener {
        private ColorListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ColorPanel.this.selected != null) {
                ColorPanel.this.colors[ColorPanel.this.selected].setSelected(false);
            }
            ColorPanel.this.selected = new Integer(actionEvent.getActionCommand());
            if (ColorPanel.this.selected != null) {
                ColorPanel.this.colors[ColorPanel.this.selected].setSelected(true);
            }
        }
    }

    private class ColorIcon
    implements Icon {
        Color color;

        public ColorIcon(Color color) {
            this.color = color;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(this.color);
            graphics.fillRect(n + 1, n2 + 1, ColorPanel.this.width - 6, ColorPanel.this.height - 6);
            if (((ColorButton)component).isSelected()) {
                graphics.setColor(Color.black);
                graphics.drawRect(n, n2 + 1, ColorPanel.this.width - 5, ColorPanel.this.height - 5);
            }
        }

        public Color getColor() {
            return this.color;
        }

        public int getIconWidth() {
            return ColorPanel.this.width - 3;
        }

        public int getIconHeight() {
            return ColorPanel.this.height - 3;
        }
    }
}

