/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.ContinuousChanceNode;
import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.DiscreteDecisionNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExceptionUsage;
import COM.hugin.HAPI.LabelledDCNode;
import COM.hugin.HAPI.Node;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HAPI.Table;
import COM.hugin.HAPI.UtilityNode;
import COM.hugin.HGUI.HuginAnalysisDialog;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIFrame;
import COM.hugin.HGUI.HuginInsets;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.IntervalChart;
import COM.hugin.HGUI.NetworkPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CorrelationDialog
extends HuginAnalysisDialog {
    private HuginGUIFrame guiFrame;
    private HuginProjectFrame projectFrame;
    private Domain domain;
    private JDialog dialogWindow = this;
    private JComboBox X;
    private JComboBox Y;
    private boolean normalizeChart = false;
    private JPanel plotArea;
    private JRadioButton conditional;
    private JRadioButton likelihood;
    private JRadioButton joint;
    private JSpinner numSamples;
    private JLabel samplesLabel;
    private final int NUM_SAMPLES_INITIAL = 25;
    private JCheckBox checkNormalizeChart = null;
    private JButton zoomIn;
    private JButton zoomOut;
    private IntervalChart plotChart = null;

    public CorrelationDialog(HuginProjectFrame huginProjectFrame, HuginGUIFrame huginGUIFrame) {
        super(huginProjectFrame, HuginGUIConstants.get("Correlation_Analysis"), true);
        this.helpPage = "help/correlationDialogHelp.html";
        this.projectFrame = huginProjectFrame;
        this.guiFrame = huginGUIFrame;
        if (!this.domainOK()) {
            return;
        }
        this.setContentPane(this.createContent());
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new CloseListener(this.domain, huginProjectFrame.networkPanel));
        this.setResizable(true);
    }

    private boolean domainOK() {
        try {
            if (!this.projectFrame.runMode || this.projectFrame.getBeliefBarPanel().getDomain() == null || !this.projectFrame.getBeliefBarPanel().getDomain().isCompiled()) {
                JOptionPane.showMessageDialog(this.projectFrame, HuginGUIConstants.get("AW_Dialog_domain_error"));
                return false;
            }
            this.domain = this.projectFrame.getBeliefBarPanel().getDomain();
            if (this.projectFrame.getBeliefBarPanel().getDomain().isCompressed()) {
                JOptionPane.showMessageDialog(this.projectFrame, HuginGUIConstants.get("AW_Dialog_domain_compressed_error"));
                return false;
            }
            NodeList nodeList = this.domain.getNodes();
            boolean bl = false;
            for (Node node : nodeList) {
                if (!(node instanceof DiscreteChanceNode)) continue;
                bl = true;
                break;
            }
            if (bl && this.projectFrame.getClassInfo().isClass()) {
                for (Node node : nodeList) {
                    if (!(node instanceof ContinuousChanceNode) && !(node instanceof DiscreteDecisionNode) && !(node instanceof UtilityNode)) continue;
                    bl = false;
                    break;
                }
            }
            if (!bl) {
                JOptionPane.showMessageDialog(this.projectFrame, HuginGUIConstants.get("AW_Dialog_domain_no_dcc_nodes"));
                return false;
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
        return true;
    }

    protected JButton getPerformButton() {
        JButton jButton = new JButton(HuginGUIConstants.get("ANALYSIS_Calculate"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HuginAnalysisDialog.NodeWrapper nodeWrapper = (HuginAnalysisDialog.NodeWrapper)CorrelationDialog.this.X.getSelectedItem();
                HuginAnalysisDialog.NodeWrapper nodeWrapper2 = (HuginAnalysisDialog.NodeWrapper)CorrelationDialog.this.Y.getSelectedItem();
                if (nodeWrapper != null && nodeWrapper2 != null) {
                    DiscreteChanceNode discreteChanceNode = (DiscreteChanceNode)nodeWrapper.node;
                    DiscreteChanceNode discreteChanceNode2 = (DiscreteChanceNode)nodeWrapper2.node;
                    try {
                        Domain domain = (Domain)discreteChanceNode.getHome();
                        NodeList nodeList = new NodeList();
                        nodeList.add(discreteChanceNode);
                        nodeList.add(discreteChanceNode2);
                        if (CorrelationDialog.this.conditional.isSelected()) {
                            Table table = discreteChanceNode.getLinkStrength(discreteChanceNode2);
                            CorrelationDialog.this.updateResults(discreteChanceNode, discreteChanceNode2, table);
                            table.delete();
                        } else if (CorrelationDialog.this.joint.isSelected()) {
                            Table table = domain.getMarginal(nodeList);
                            CorrelationDialog.this.updateResults(discreteChanceNode, discreteChanceNode2, table);
                            table.delete();
                        } else if (CorrelationDialog.this.likelihood.isSelected()) {
                            int n;
                            int n2 = CorrelationDialog.this.getNumberOfSamples();
                            Domain domain2 = new Domain();
                            LabelledDCNode labelledDCNode = new LabelledDCNode(domain2);
                            LabelledDCNode labelledDCNode2 = new LabelledDCNode(domain2);
                            labelledDCNode.setNumberOfStates(discreteChanceNode.getNumberOfStates());
                            labelledDCNode2.setNumberOfStates(discreteChanceNode2.getNumberOfStates());
                            Table table = discreteChanceNode2.getLinkStrength(discreteChanceNode);
                            labelledDCNode2.addParent(labelledDCNode);
                            Table table2 = labelledDCNode.getTable();
                            for (n = 0; n < labelledDCNode.getNumberOfStates(); ++n) {
                                table2.setDataItem(n, discreteChanceNode.getBelief(n));
                            }
                            table2 = labelledDCNode2.getTable();
                            for (n = 0; n < table2.getSize(); ++n) {
                                table2.setDataItem(n, table.getDataItem(n));
                            }
                            domain2.seedRandom((int)System.currentTimeMillis());
                            domain2.setNumberOfCases(n2);
                            for (n = 0; n < n2; ++n) {
                                domain2.simulate();
                                labelledDCNode.setCaseState(n, labelledDCNode.getSampledState());
                                labelledDCNode2.setCaseState(n, labelledDCNode2.getSampledState());
                            }
                            labelledDCNode2.removeParent(labelledDCNode);
                            domain2.learnStructure();
                            if (labelledDCNode2.getParents().size() > 0) {
                                labelledDCNode2.removeParent(labelledDCNode);
                            } else if (labelledDCNode.getParents().size() > 0) {
                                labelledDCNode.removeParent(labelledDCNode2);
                            }
                            NodeList nodeList2 = new NodeList();
                            nodeList2.add(labelledDCNode);
                            nodeList2.add(labelledDCNode2);
                            Table table3 = domain2.countCases(nodeList2);
                            NodeList nodeList3 = new NodeList();
                            nodeList3.add(discreteChanceNode);
                            nodeList3.add(discreteChanceNode2);
                            Table table4 = domain.getMarginal(nodeList3);
                            for (int i = 0; i < table4.getSize(); ++i) {
                                table4.setDataItem(i, table3.getDataItem(i));
                            }
                            CorrelationDialog.this.updateResults(discreteChanceNode, discreteChanceNode2, table4);
                            table4.delete();
                            domain2.delete();
                        }
                    }
                    catch (ExceptionUsage exceptionUsage) {
                        new HuginGUIError(HuginGUIConstants.get("str_Correlation_Error"));
                    }
                    catch (ExceptionHugin exceptionHugin) {
                        new HuginGUIError(exceptionHugin.getMessage());
                    }
                }
            }
        });
        return jButton;
    }

    private void updateResults(DiscreteChanceNode discreteChanceNode, DiscreteChanceNode discreteChanceNode2, Table table) throws ExceptionHugin {
        float[][] fArray = new float[discreteChanceNode.getNumberOfStates()][discreteChanceNode2.getNumberOfStates()];
        NodeList nodeList = new NodeList();
        nodeList.add(discreteChanceNode);
        nodeList.add(discreteChanceNode2);
        table.reorderNodes(nodeList);
        int[] nArray = new int[nodeList.size()];
        for (int i = 0; i < table.getSize(); ++i) {
            table.getConfiguration(nArray, i);
            fArray[nArray[0]][nArray[1]] = (float)table.getDataItem(i);
        }
        this.plotArea.removeAll();
        this.plotChart = new IntervalChart(discreteChanceNode2, discreteChanceNode, fArray);
        if (!this.normalizeChart) {
            this.plotChart.setForcedMaxValue(1.0f);
        }
        this.plotArea.add(this.plotChart);
        this.dialogWindow.validate();
        this.dialogWindow.repaint();
    }

    private int getNumberOfSamples() {
        return (Integer)this.numSamples.getValue();
    }

    protected JPanel createContent() {
        maxTitleLength = 350;
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.X = new JComboBox(new HuginAnalysisDialog.NodeListModel(this.domain, null));
        this.X.setAlignmentX(1.0f);
        this.X.setBackground(Color.WHITE);
        this.X.setPreferredSize(new Dimension(250, this.X.getPreferredSize().height));
        this.X.setSelectedIndex(-1);
        this.Y = new JComboBox(new HuginAnalysisDialog.NodeListModel(this.domain, null));
        this.Y.setAlignmentX(1.0f);
        this.Y.setBackground(Color.WHITE);
        this.Y.setPreferredSize(new Dimension(250, this.Y.getPreferredSize().height));
        this.Y.setSelectedIndex(-1);
        this.X.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                HuginAnalysisDialog.NodeWrapper nodeWrapper = (HuginAnalysisDialog.NodeWrapper)CorrelationDialog.this.X.getSelectedItem();
                if (nodeWrapper != null) {
                    try {
                        DiscreteChanceNode discreteChanceNode = (DiscreteChanceNode)nodeWrapper.node;
                        if ((HuginAnalysisDialog.NodeWrapper)CorrelationDialog.this.Y.getSelectedItem() != null && discreteChanceNode == ((HuginAnalysisDialog.NodeWrapper)((CorrelationDialog)CorrelationDialog.this).Y.getSelectedItem()).node) {
                            CorrelationDialog.this.X.setSelectedIndex(-1);
                        }
                        if ((HuginAnalysisDialog.NodeWrapper)CorrelationDialog.this.Y.getSelectedItem() != null) {
                            HuginAnalysisDialog.NodeWrapper nodeWrapper2 = (HuginAnalysisDialog.NodeWrapper)CorrelationDialog.this.Y.getSelectedItem();
                            DiscreteChanceNode discreteChanceNode2 = (DiscreteChanceNode)nodeWrapper2.node;
                            CorrelationDialog.this.numSamples.setValue(discreteChanceNode.getNumberOfStates() * discreteChanceNode2.getNumberOfStates() * 10);
                        }
                    }
                    catch (Exception exception) {
                        new HuginGUIError(exception.getMessage());
                    }
                }
                if ((HuginAnalysisDialog.NodeWrapper)CorrelationDialog.this.Y.getSelectedItem() != null && (HuginAnalysisDialog.NodeWrapper)CorrelationDialog.this.X.getSelectedItem() != null) {
                    CorrelationDialog.this.perform.setEnabled(true);
                } else {
                    CorrelationDialog.this.perform.setEnabled(false);
                }
            }
        });
        this.Y.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                HuginAnalysisDialog.NodeWrapper nodeWrapper = (HuginAnalysisDialog.NodeWrapper)CorrelationDialog.this.Y.getSelectedItem();
                if (nodeWrapper != null) {
                    try {
                        DiscreteChanceNode discreteChanceNode = (DiscreteChanceNode)nodeWrapper.node;
                        if ((HuginAnalysisDialog.NodeWrapper)CorrelationDialog.this.X.getSelectedItem() != null && discreteChanceNode == ((HuginAnalysisDialog.NodeWrapper)((CorrelationDialog)CorrelationDialog.this).X.getSelectedItem()).node) {
                            CorrelationDialog.this.Y.setSelectedIndex(-1);
                        }
                        if ((HuginAnalysisDialog.NodeWrapper)CorrelationDialog.this.X.getSelectedItem() != null) {
                            HuginAnalysisDialog.NodeWrapper nodeWrapper2 = (HuginAnalysisDialog.NodeWrapper)CorrelationDialog.this.X.getSelectedItem();
                            DiscreteChanceNode discreteChanceNode2 = (DiscreteChanceNode)nodeWrapper2.node;
                            CorrelationDialog.this.numSamples.setValue(discreteChanceNode2.getNumberOfStates() * discreteChanceNode.getNumberOfStates() * 10);
                        }
                    }
                    catch (Exception exception) {
                        new HuginGUIError(exception.getMessage());
                    }
                }
                if ((HuginAnalysisDialog.NodeWrapper)CorrelationDialog.this.Y.getSelectedItem() != null && (HuginAnalysisDialog.NodeWrapper)CorrelationDialog.this.X.getSelectedItem() != null) {
                    CorrelationDialog.this.perform.setEnabled(true);
                } else {
                    CorrelationDialog.this.perform.setEnabled(false);
                }
            }
        });
        JLabel jLabel = new JLabel("X : ");
        JLabel jLabel2 = new JLabel("Y : ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        jPanel2.add((Component)this.X, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        jPanel2.add((Component)this.Y, gridBagConstraints);
        this.checkNormalizeChart = new JCheckBox(HuginGUIConstants.get("str_normalize_chart"), false);
        this.checkNormalizeChart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CorrelationDialog.this.normalizeChart = !CorrelationDialog.this.normalizeChart;
                CorrelationDialog.this.plotChart = null;
                CorrelationDialog.this.plotArea.removeAll();
                CorrelationDialog.this.dialogWindow.validate();
                CorrelationDialog.this.dialogWindow.repaint();
            }
        });
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        jPanel2.add((Component)this.checkNormalizeChart, gridBagConstraints);
        this.zoomIn = new JButton(new ImageIcon(ClassLoader.getSystemResource("icons/magnify-plus.gif")));
        this.zoomIn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (CorrelationDialog.this.plotChart != null) {
                    Dimension dimension = new Dimension(((CorrelationDialog)CorrelationDialog.this).plotChart.getSize().width * 2, ((CorrelationDialog)CorrelationDialog.this).plotChart.getSize().height * 2);
                    CorrelationDialog.this.plotChart.setMinimumSize(dimension);
                    CorrelationDialog.this.plotChart.setMaximumSize(dimension);
                    CorrelationDialog.this.plotChart.setPreferredSize(dimension);
                    CorrelationDialog.this.plotChart.setSize(dimension);
                    CorrelationDialog.this.dialogWindow.validate();
                    CorrelationDialog.this.dialogWindow.repaint();
                }
            }
        });
        this.zoomIn.setMargin(new HuginInsets());
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        jPanel2.add((Component)this.zoomIn, gridBagConstraints);
        this.zoomOut = new JButton(new ImageIcon(ClassLoader.getSystemResource("icons/magnify-minus.gif")));
        this.zoomOut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (CorrelationDialog.this.plotChart != null) {
                    Dimension dimension = new Dimension(((CorrelationDialog)CorrelationDialog.this).plotChart.getSize().width / 2, ((CorrelationDialog)CorrelationDialog.this).plotChart.getSize().height / 2);
                    CorrelationDialog.this.plotChart.setMinimumSize(dimension);
                    CorrelationDialog.this.plotChart.setMaximumSize(dimension);
                    CorrelationDialog.this.plotChart.setPreferredSize(dimension);
                    CorrelationDialog.this.plotChart.setSize(dimension);
                    CorrelationDialog.this.dialogWindow.validate();
                    CorrelationDialog.this.dialogWindow.repaint();
                }
            }
        });
        this.zoomOut.setMargin(new HuginInsets());
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        jPanel2.add((Component)this.zoomOut, gridBagConstraints);
        jPanel.add((Component)jPanel2, "West");
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("SE_select_hypotheses")));
        jScrollPane.setPreferredSize(new Dimension(300, jScrollPane.getSize().height));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JLabel jLabel3 = new JLabel(HuginGUIConstants.get("Select_correlation_measure") + " : ");
        this.samplesLabel = new JLabel(HuginGUIConstants.get("Number_of_samples"));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.conditional = new JRadioButton("P(X|Y,e)");
        this.conditional.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CorrelationDialog.this.numSamples.setEnabled(false);
                CorrelationDialog.this.samplesLabel.setEnabled(false);
                CorrelationDialog.this.checkNormalizeChart.setEnabled(true);
            }
        });
        this.joint = new JRadioButton("P(X,Y|e)");
        this.joint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CorrelationDialog.this.numSamples.setEnabled(false);
                CorrelationDialog.this.samplesLabel.setEnabled(false);
                CorrelationDialog.this.checkNormalizeChart.setEnabled(true);
            }
        });
        this.likelihood = new JRadioButton("Likelihood chi^2");
        this.likelihood.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CorrelationDialog.this.numSamples.setEnabled(true);
                CorrelationDialog.this.samplesLabel.setEnabled(true);
                CorrelationDialog.this.checkNormalizeChart.setEnabled(false);
            }
        });
        this.conditional.setSelected(true);
        buttonGroup.add(this.conditional);
        buttonGroup.add(this.joint);
        buttonGroup.add(this.likelihood);
        this.numSamples = new JSpinner(new SpinnerNumberModel(25, 1, 1000000, 100));
        this.numSamples.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
            }
        });
        this.numSamples.setEnabled(false);
        this.samplesLabel.setEnabled(false);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 0.5;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 2;
        jPanel4.add((Component)jLabel3, gridBagConstraints2);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        jPanel4.add((Component)this.conditional, gridBagConstraints2);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        jPanel4.add((Component)this.joint, gridBagConstraints2);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 3;
        jPanel4.add((Component)this.likelihood, gridBagConstraints2);
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 4;
        jPanel4.add((Component)this.samplesLabel, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 4;
        jPanel4.add((Component)this.numSamples, gridBagConstraints2);
        jPanel3.add((Component)jPanel4, "North");
        this.plotArea = new JPanel(new BorderLayout());
        JScrollPane jScrollPane2 = new JScrollPane(this.plotArea, 22, 32);
        jScrollPane2.setVerticalScrollBarPolicy(22);
        jScrollPane2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(HuginGUIConstants.get("SE_results")), BorderFactory.createEmptyBorder(5, 5, 5, 5)), jScrollPane2.getBorder()));
        jScrollPane2.setMinimumSize(new Dimension(10, 10));
        JSplitPane jSplitPane = new JSplitPane(1, jPanel3, jScrollPane2);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add(jSplitPane);
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.add((Component)jPanel, "North");
        jPanel6.add((Component)jPanel5, "Center");
        jPanel6.add((Component)this.getButtonPanel(1), "South");
        this.pack();
        this.perform.setEnabled(false);
        return jPanel6;
    }

    private class CloseListener
    implements WindowListener {
        private Domain domain;
        private NetworkPanel networkPanel;

        public CloseListener(Domain domain, NetworkPanel networkPanel) {
            this.domain = domain;
            this.networkPanel = networkPanel;
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }
    }
}

