/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.DataSource;
import COM.hugin.HGUI.DataSourceException;
import COM.hugin.HGUI.DataStream;
import COM.hugin.HGUI.DiscretizeProcess;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.InvalidDiscretizationException;
import COM.hugin.HGUI.PreProcess;
import COM.hugin.HGUI.ReplaceProcess;
import COM.hugin.HGUI.Variable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;

public class DataAnalyserModel {
    DataStream stream;
    private DataHolder[] variables;
    private boolean cancelled = false;
    public static final int MODEL_CHANGE_DATA = 0;
    public static final int MODEL_CHANGE_APPLY = 1;

    public DataAnalyserModel(DataStream dataStream) {
        this.stream = dataStream;
    }

    public void initialize() throws DataSourceException, Exception {
        DataSource dataSource = null;
        try {
            int n;
            dataSource = this.stream.getSource();
            Variable[] variableArray = this.stream.getCaseTemplate().getVariables();
            String[] stringArray = this.stream.getFieldNames();
            int n2 = 0;
            this.variables = new DataHolder[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                while (variableArray[n2].isExcluded()) {
                    ++n2;
                }
                this.variables[n] = new DataHolder(stringArray[n], variableArray[n2].getNodeName(), this.stream.getProcessesForVariable(stringArray[n]));
                ++n2;
            }
            stringArray = dataSource.readLine();
            while (stringArray != null && !this.cancelled) {
                while (stringArray != null && stringArray.length == 0) {
                    stringArray = dataSource.readLine();
                }
                if (stringArray != null) {
                    n2 = 0;
                    for (n = 0; n < this.variables.length; ++n) {
                        while (variableArray[n2].isExcluded()) {
                            ++n2;
                        }
                        String string = stringArray[n2];
                        for (PreProcess preProcess : this.stream.getProcessesForVariable(variableArray[n2].getName())) {
                            if (!(preProcess instanceof ReplaceProcess)) continue;
                            try {
                                string = preProcess.process(string);
                            }
                            catch (Exception exception) {
                                System.out.println("DataAnalyserModel.java initialization stuff going on. " + exception.getMessage());
                            }
                        }
                        this.variables[n].insert(string);
                        ++n2;
                    }
                }
                stringArray = dataSource.readLine();
            }
            for (n = 0; n < this.variables.length; ++n) {
                this.variables[n].finalize();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new HuginGUIError(HuginGUIConstants.get("str_data_source_corrupt_start_over"));
            throw exception;
        }
        finally {
            if (dataSource != null) {
                dataSource.reset();
            }
        }
    }

    public DataHolder[] getVariables() {
        return this.variables;
    }

    public boolean isEmpty() {
        return this.variables == null || this.variables.length == 0;
    }

    public static interface ModelChangedListener {
        public void modelChanged(int var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DataHolder {
        private String name;
        private String nodeName;
        private HashMap<String, Integer> data;
        private String[] nullValues = HuginGUIConstants.NULL_VALUES;
        private String[] names;
        private int[] counts;
        private int missingDataCount = 0;
        boolean containsError = false;
        boolean numerical = false;
        boolean interval = false;
        private LinkedList<ModelChangedListener> modelChangedListeners;
        private double[] intervals;
        private double[] liveIntervals;
        private boolean applyIntervals = false;

        public DataHolder(String string, String string2, Vector<PreProcess> vector) {
            this.name = string;
            this.nodeName = string2;
            this.data = new HashMap();
            this.modelChangedListeners = new LinkedList();
            for (int i = 0; i < vector.size(); ++i) {
                if (!(vector.get(i) instanceof DiscretizeProcess)) continue;
                DiscretizeProcess.Interval[] intervalArray = ((DiscretizeProcess)vector.get(i)).getIntervals();
                double[] dArray = new double[intervalArray.length + 1];
                for (int j = 0; j < intervalArray.length; ++j) {
                    dArray[j] = intervalArray[j].lower;
                }
                dArray[dArray.length - 1] = intervalArray[intervalArray.length - 1].upper;
                this.setIntervals(dArray, true);
                this.setIntervals(dArray, false);
                this.applyIntervals(true);
            }
        }

        private boolean hasValidRange(double[] dArray) {
            if (dArray != null && dArray.length > 0) {
                return dArray[0] != dArray[dArray.length - 1] && dArray[0] <= Double.parseDouble(this.getMinimum()) && dArray[dArray.length - 1] >= Double.parseDouble(this.getMaximum());
            }
            return false;
        }

        public void setIntervals(double[] dArray, boolean bl) {
            if (bl) {
                this.liveIntervals = dArray;
            } else {
                this.intervals = dArray;
            }
            this.fireModelChanged(0);
        }

        public double[] getIntervals(boolean bl) {
            if (bl) {
                if (!this.hasValidRange(this.liveIntervals)) {
                    this.liveIntervals = null;
                }
                return this.liveIntervals;
            }
            if (!this.hasValidRange(this.intervals)) {
                this.liveIntervals = null;
                this.intervals = null;
            }
            return this.intervals;
        }

        public void applyIntervals(boolean bl) {
            if (bl != this.applyIntervals) {
                if (bl) {
                    this.intervals = new double[this.liveIntervals.length];
                    for (int i = 0; i < this.intervals.length; ++i) {
                        this.intervals[i] = this.liveIntervals[i];
                    }
                }
                this.applyIntervals = bl;
                this.containsError = false;
                this.fireModelChanged(1);
            }
        }

        public boolean applyIntervals() {
            return this.applyIntervals;
        }

        public DiscretizeProcess getDiscretizeProcess() throws InvalidDiscretizationException {
            if (this.intervals == null || !this.applyIntervals) {
                return null;
            }
            DiscretizeProcess.Interval[] intervalArray = new DiscretizeProcess.Interval[this.intervals.length - 1];
            double d = this.intervals[0] - Math.min(0.1, (this.intervals[this.intervals.length - 1] - this.intervals[0]) / 1000.0);
            double d2 = this.intervals[this.intervals.length - 1] + Math.min(0.1, (this.intervals[this.intervals.length - 1] - this.intervals[0]) / 1000.0);
            for (int i = 1; i < intervalArray.length - 1; ++i) {
                intervalArray[i] = new DiscretizeProcess.Interval(this.intervals[i], this.intervals[i + 1]);
            }
            intervalArray[0] = new DiscretizeProcess.Interval(d, this.intervals[1]);
            intervalArray[intervalArray.length - 1] = new DiscretizeProcess.Interval(this.intervals[this.intervals.length - 2], d2);
            return new DiscretizeProcess(this.nodeName, intervalArray);
        }

        public void insert(String string) {
            if (string == null) {
                return;
            }
            string = string.trim();
            String string2 = string.toLowerCase();
            for (int i = 0; i < this.nullValues.length; ++i) {
                if (!string2.equals(this.nullValues[i])) continue;
                ++this.missingDataCount;
                return;
            }
            if (this.data.containsKey(string)) {
                this.data.put(string, new Integer(this.data.get(string) + 1));
            } else {
                this.data.put(string, new Integer(1));
            }
        }

        public void finalize() {
            Object[] objectArray = this.data.entrySet().toArray();
            this.names = new String[objectArray.length];
            for (int i = 0; i < this.names.length; ++i) {
                this.names[i] = (String)((Map.Entry)objectArray[i]).getKey();
            }
            this.numerical = HuginGUIUtils.valuesAreNumerical(this.names);
            this.interval = HuginGUIUtils.valuesAreInterval(this.names) != HuginGUIUtils.INTERVAL_TYPE_NOT;
            try {
                if (this.numerical) {
                    objectArray = this.convertToNumerical(this.data);
                }
                if (this.interval) {
                    objectArray = this.convertToInterval(this.data);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                new HuginGUIError(this.numerical ? HuginGUIConstants.get("str_unable_to_convert_values_to_numerical_lb_ARG0_remain_labels", new String[]{exception.getMessage()}) : HuginGUIConstants.get("str_interval", new String[]{exception.getMessage()}));
            }
            Arrays.sort(objectArray, new Comparator<Object>(){

                @Override
                public int compare(Object object, Object object2) {
                    Map.Entry entry = (Map.Entry)object;
                    Map.Entry entry2 = (Map.Entry)object2;
                    if (DataHolder.this.numerical) {
                        double d;
                        double d2 = (Double)entry.getKey();
                        return d2 == (d = ((Double)entry2.getKey()).doubleValue()) ? 0 : (d2 < d ? -1 : 1);
                    }
                    if (DataHolder.this.interval) {
                        HuginGUIUtils.Interval interval = (HuginGUIUtils.Interval)entry.getKey();
                        HuginGUIUtils.Interval interval2 = (HuginGUIUtils.Interval)entry2.getKey();
                        return interval.lower == interval2.lower ? (interval.upper == interval2.upper ? 0 : (interval.upper < interval2.upper ? -1 : 1)) : (interval.lower < interval2.lower ? -1 : 1);
                    }
                    return ((String)entry.getKey()).compareTo((String)entry2.getKey());
                }
            });
            this.names = new String[objectArray.length];
            this.counts = new int[objectArray.length];
            for (int i = 0; i < this.names.length; ++i) {
                Map.Entry entry = (Map.Entry)objectArray[i];
                this.names[i] = entry.getKey().toString();
                this.counts[i] = (Integer)entry.getValue();
            }
        }

        public String[] getNames() {
            return this.names;
        }

        public String getMinimum() {
            return this.names[0];
        }

        public String getMaximum() {
            return this.names[this.names.length - 1];
        }

        public int[] getCounts() {
            return this.counts;
        }

        public double getMissingDataPercentage() {
            double d = 0.0;
            for (int i = 0; i < this.counts.length; ++i) {
                d += (double)this.counts[i];
            }
            return (double)this.missingDataCount / ((double)this.missingDataCount + d);
        }

        public String toString() {
            return this.name;
        }

        public boolean containsDiscretizingError() {
            return this.containsError;
        }

        public void containsDiscretizingError(boolean bl) {
            this.containsError = bl;
        }

        public String getName() {
            return this.nodeName;
        }

        public boolean isNumerical() {
            return this.numerical;
        }

        public void makeEquiDistant() {
            if (this.liveIntervals == null) {
                return;
            }
            double d = Double.parseDouble(this.getMinimum());
            double d2 = Double.parseDouble(this.getMaximum());
            double d3 = (d2 - d) / (double)(this.liveIntervals.length - 1);
            for (int i = 1; i < this.liveIntervals.length - 1; ++i) {
                this.liveIntervals[i] = d + (double)i * d3;
            }
            this.fireModelChanged(0);
        }

        public void makeEqualDistributed() {
            int n;
            double d = 0.75;
            if (this.liveIntervals == null) {
                return;
            }
            int n2 = 0;
            for (n = 0; n < this.counts.length; ++n) {
                n2 += this.counts[n];
            }
            n = this.liveIntervals.length - 1;
            if (n >= this.counts.length) {
                n = this.counts.length - 1;
            }
            if (n < 2) {
                n = 2;
            }
            while (true) {
                int n3;
                int n4 = n2 / n;
                double d2 = 0.0;
                int[] nArray = null;
                int[] nArray2 = null;
                for (int i = 1; i <= n4; ++i) {
                    int n5;
                    double d3 = 1.0;
                    int[] nArray3 = null;
                    int[] nArray4 = null;
                    nArray3 = new int[n];
                    nArray4 = new int[n];
                    for (n5 = 0; n5 < n; ++n5) {
                        int n6 = nArray4[n5] = n5 == 0 ? 0 : nArray4[n5 - 1] + 1;
                        if (nArray4[n5] != this.counts.length) {
                            nArray3[n5] = this.counts[nArray4[n5]];
                            while (nArray4[n5] < this.counts.length - 1 && nArray3[n5] < i) {
                                nArray4[n5] = nArray4[n5] + 1;
                                nArray3[n5] = nArray3[n5] + this.counts[nArray4[n5]];
                            }
                            continue;
                        }
                        nArray4[n5] = nArray4[n5] - 1;
                    }
                    d3 = 1.0;
                    for (n5 = 0; n5 < n; ++n5) {
                        d3 *= (double)nArray3[n5] / ((double)n2 / (double)n);
                    }
                    if (!(d3 > d2)) continue;
                    d2 = d3;
                    nArray = nArray3;
                    nArray2 = nArray4;
                }
                boolean bl = d2 > d;
                for (n3 = 0; n3 < n; ++n3) {
                    if (nArray[n3] != false) continue;
                    bl = false;
                }
                if (bl || n == 2) {
                    this.liveIntervals = new double[n + 1];
                    for (n3 = 0; n3 < n; ++n3) {
                        this.liveIntervals[n3 + 1] = nArray2[n3] < this.counts.length - 1 ? Double.parseDouble(this.names[nArray2[n3]]) + (Double.parseDouble(this.names[nArray2[n3] + 1]) - Double.parseDouble(this.names[nArray2[n3]])) / 2.0 : Double.parseDouble(this.names[nArray2[n3]]);
                    }
                    break;
                }
                --n;
            }
            this.liveIntervals[0] = Double.parseDouble(this.names[0]);
            this.liveIntervals[this.liveIntervals.length - 1] = Double.parseDouble(this.names[this.names.length - 1]);
            this.fireModelChanged(0);
        }

        private Object[] convertToNumerical(HashMap<String, Integer> hashMap) throws Exception {
            HashMap<Double, Integer> hashMap2 = new HashMap<Double, Integer>();
            for (Map.Entry<String, Integer> entry : hashMap.entrySet()) {
                Double d = new Double(entry.getKey());
                Integer n = entry.getValue();
                if (hashMap2.containsKey(d)) {
                    n = new Integer(n + (Integer)hashMap2.get(d));
                }
                hashMap2.put(d, n);
            }
            return hashMap2.entrySet().toArray();
        }

        private Object[] convertToInterval(HashMap<String, Integer> hashMap) throws Exception {
            HashMap<HuginGUIUtils.Interval, Integer> hashMap2 = new HashMap<HuginGUIUtils.Interval, Integer>();
            for (Map.Entry<String, Integer> entry : hashMap.entrySet()) {
                HuginGUIUtils.Interval interval = HuginGUIUtils.getInterval(entry.getKey());
                Integer n = entry.getValue();
                if (hashMap2.containsKey(interval)) {
                    n = new Integer(n + (Integer)hashMap2.get(interval));
                }
                hashMap2.put(interval, n);
            }
            return hashMap2.entrySet().toArray();
        }

        public void addModelChangedListener(ModelChangedListener modelChangedListener) {
            if (!this.modelChangedListeners.contains(modelChangedListener)) {
                this.modelChangedListeners.add(modelChangedListener);
            }
        }

        public void removeModelChangedListener(ModelChangedListener modelChangedListener) {
            this.modelChangedListeners.remove(modelChangedListener);
        }

        protected void fireModelChanged(int n) {
            for (ModelChangedListener modelChangedListener : this.modelChangedListeners) {
                modelChangedListener.modelChanged(n);
            }
        }
    }
}

