/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.BooleanDCNode;
import COM.hugin.HAPI.Class;
import COM.hugin.HAPI.ContinuousChanceNode;
import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.DiscreteDecisionNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExceptionParse;
import COM.hugin.HAPI.IntervalDCNode;
import COM.hugin.HAPI.LabelledDCNode;
import COM.hugin.HAPI.NetworkModel;
import COM.hugin.HAPI.Node;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HAPI.NumberedDCNode;
import COM.hugin.HAPI.UtilityNode;
import COM.hugin.HGUI.CaseBank;
import COM.hugin.HGUI.DataViewer;
import COM.hugin.HGUI.HelpPanel;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.NetworkPanel;
import COM.hugin.HGUI.StreamData;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public abstract class DataAnalyzerDialog
extends JDialog {
    JDialog wizardWindow = this;
    HuginProjectFrame projectFrame;
    Domain domain;
    NetworkModel homeModel = null;
    DataViewer viewer;
    JLabel dataFileLabel;
    JLabel databaseNumberOfCasesLabel;
    JLabel databaseFileLabel;
    JButton clearData;
    JButton clearButton;
    JTabbedPane tabbedPane;
    CaseBank caseBank;
    JScrollPane viewDataPane;
    JLabel dataNumberOfCasesLabel;
    StreamData streamData;
    private boolean hasContinuous = false;
    protected HelpPanel helpPanel;
    protected String[] helpPages;

    public DataAnalyzerDialog(HuginProjectFrame huginProjectFrame, String string) {
        super(Hugin.mainFrame, string, true);
        this.projectFrame = huginProjectFrame;
        try {
            this.domain = huginProjectFrame.getDomain();
            NetworkModel networkModel = this.homeModel = huginProjectFrame.networkPanel.getHomeClass() != null ? huginProjectFrame.networkPanel.getHomeClass() : this.domain;
            if (this.domain != this.homeModel) {
                for (Node node : this.homeModel.getNodes()) {
                    Node node2 = this.domain.getNodeByName(node.getName());
                    if (node2 == null) continue;
                    node2.setGUINode(node.getGUINode());
                }
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage());
        }
        this.helpPanel = new HelpPanel(this);
    }

    protected abstract JButton getCloseButton();

    protected JPanel getBottomPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2));
        JButton jButton = this.getCloseButton();
        jPanel.add(jButton);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JButton jButton2 = new JButton(HuginGUIConstants.get("str_help"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = DataAnalyzerDialog.this.tabbedPane.getSelectedIndex();
                if (n >= 0 && n < DataAnalyzerDialog.this.helpPages.length) {
                    DataAnalyzerDialog.this.helpPanel.setHelpPage(DataAnalyzerDialog.this.helpPages[n]);
                    if (!DataAnalyzerDialog.this.helpPanel.isVisible()) {
                        int n2 = DataAnalyzerDialog.this.wizardWindow.getX() - DataAnalyzerDialog.this.helpPanel.getWidth();
                        if (n2 < 5 && (n2 = DataAnalyzerDialog.this.wizardWindow.getX() + DataAnalyzerDialog.this.getWidth()) + DataAnalyzerDialog.this.helpPanel.getWidth() > Toolkit.getDefaultToolkit().getScreenSize().width - 5) {
                            n2 = 5;
                        }
                        DataAnalyzerDialog.this.helpPanel.setLocation(n2, DataAnalyzerDialog.this.wizardWindow.getY());
                        DataAnalyzerDialog.this.helpPanel.setVisible(true);
                    }
                }
            }
        });
        jPanel2.add(jButton2);
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2));
        jPanel3.add(jPanel2);
        jPanel3.add(jPanel);
        return jPanel3;
    }

    private void addInfo(String string, String string2) {
        if (string.length() > 0 && string2.length() > 0) {
            this.dataFileLabel.setText(string);
            this.dataNumberOfCasesLabel.setText(string2);
        } else {
            this.dataFileLabel.setText(HuginGUIConstants.get("AW_Data_file") + "---");
            this.dataNumberOfCasesLabel.setText(HuginGUIConstants.get("AW_Data_number_of_cases") + "0");
        }
    }

    protected void configureDomain() {
        try {
            NodeList nodeList = this.domain.getNodes();
            boolean bl = false;
            for (Node node : nodeList) {
                if (node instanceof DiscreteChanceNode) {
                    bl = true;
                }
                if (!(node instanceof ContinuousChanceNode)) continue;
                this.hasContinuous = true;
            }
            if (bl && this.projectFrame.getClassInfo().isClass()) {
                for (Node node : nodeList) {
                    if (!(node instanceof DiscreteDecisionNode) && !(node instanceof UtilityNode)) continue;
                    bl = false;
                    break;
                }
            }
            if (!bl) {
                JOptionPane.showMessageDialog(this.projectFrame, HuginGUIConstants.get("AW_Dialog_domain_no_dcc_nodes"));
                return;
            }
            this.caseBank = new CaseBank(this.domain);
            this.caseBank.newCase();
            this.caseBank.copyCasesFromDomain();
            this.domain.setNumberOfCases(0);
            this.caseBank.enterCase(0);
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage());
        }
    }

    protected void clearData() {
        try {
            this.domain.setNumberOfCases(0);
            this.addInfo("", "");
            this.clearData.setEnabled(false);
            this.viewDataPane.setViewportView(null);
            this.removeViewer();
            this.updatePanes();
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage());
        }
    }

    public void showData(String string, StreamData streamData) {
        try {
            if (this.containsInconsistent()) {
                this.clearData();
                return;
            }
            this.clearData.setEnabled(true);
            this.updatePanes();
            this.addInfo(HuginGUIConstants.get("AW_Data_file") + string, HuginGUIConstants.get("AW_Data_number_of_cases") + this.domain.getNumberOfCases());
            if (this.domain.getNumberOfCases() > 0) {
                ViewCaseModel viewCaseModel = new ViewCaseModel(this.domain);
                JTable jTable = new JTable(viewCaseModel){

                    public boolean isCellEditable(int n, int n2) {
                        return false;
                    }
                };
                jTable.getTableHeader().setDefaultRenderer(new ToolTipHeader());
                jTable.setAutoResizeMode(0);
                this.initColumnSizes(jTable);
                this.viewDataPane.setViewportView(jTable);
            }
        }
        catch (ExceptionParse exceptionParse) {
        }
        catch (ExceptionHugin exceptionHugin) {
            // empty catch block
        }
    }

    protected void initColumnSizes(JTable jTable) {
        jTable.doLayout();
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        TableModel tableModel = jTable.getModel();
        TableColumn tableColumn = null;
        Component component = null;
        int n = 0;
        int n2 = 0;
        TableCellRenderer tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            tableColumn = jTable.getColumnModel().getColumn(i);
            component = tableCellRenderer.getTableCellRendererComponent(null, tableColumn.getHeaderValue(), false, false, 0, 0);
            n = component.getPreferredSize().width;
            n2 = 0;
            for (int j = 0; j < jTable.getRowCount(); ++j) {
                component = jTable.getDefaultRenderer(tableModel.getColumnClass(i)).getTableCellRendererComponent(jTable, jTable.getValueAt(0, i), false, false, 0, i);
                n2 = Math.max(n2, component.getPreferredSize().width + 15);
            }
            tableColumn.setPreferredWidth(Math.max(n, n2));
        }
    }

    private void removeViewer() {
        if (this.viewer != null) {
            this.viewer.dispose();
            this.viewer = null;
        }
    }

    protected void updatePanes() {
    }

    protected boolean containsInconsistent() throws ExceptionHugin {
        Vector<Long> vector = new Vector<Long>();
        int n = this.domain.getNumberOfCases();
        for (int i = 0; i < n; ++i) {
            try {
                this.domain.enterCase(i);
                this.domain.propagate(Domain.H_EQUILIBRIUM_SUM, Domain.H_EVIDENCE_MODE_NORMAL);
                continue;
            }
            catch (ExceptionHugin exceptionHugin) {
                vector.add(new Long(i));
            }
        }
        this.domain.retractFindings();
        if (vector.size() > 0) {
            String string = HuginGUIConstants.get("str_inconsistency_detected_impossible_cases");
            for (Long serializable2 : vector) {
                string = string + "\n#" + serializable2;
            }
            JPanel jPanel = new JPanel();
            JTextArea jTextArea = new JTextArea(string);
            JScrollPane jScrollPane = new JScrollPane(jTextArea, 20, 31);
            jScrollPane.setPreferredSize(new Dimension((int)jTextArea.getPreferredSize().getWidth() + 20, 150));
            jPanel.add(jScrollPane);
            JOptionPane.showMessageDialog(this, jPanel);
            return true;
        }
        return false;
    }

    protected class CloseListener
    implements WindowListener {
        private Domain domain;
        private NetworkPanel networkPanel;

        public CloseListener(Domain domain, NetworkPanel networkPanel) {
            this.domain = domain;
            this.networkPanel = networkPanel;
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
            try {
                if (DataAnalyzerDialog.this.homeModel instanceof Class) {
                    this.domain.delete();
                } else {
                    this.domain.uncompile();
                }
            }
            catch (ExceptionHugin exceptionHugin) {
                new HuginGUIError(exceptionHugin);
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }
    }

    private class ToolTipHeader
    implements TableCellRenderer {
        private ToolTipHeader() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = new JLabel(" " + object.toString() + " ");
            jLabel.setToolTipText(object.toString());
            jLabel.setHorizontalAlignment(0);
            jLabel.setBorder(BorderFactory.createRaisedBevelBorder());
            return jLabel;
        }
    }

    private class ViewerCloseListener
    implements ChangeListener {
        private ViewerCloseListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
        }
    }

    protected class ViewCaseModel
    extends DefaultTableModel {
        Domain domain;
        Node[] nodes;
        int numRows;

        public ViewCaseModel(Domain domain) throws ExceptionHugin {
            this.domain = domain;
            this.numRows = domain.getNumberOfCases();
            this.nodes = domain.getNodes().toArray(new Node[0]);
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return "" + n;
            }
            --n2;
            try {
                if (this.nodes[n2] instanceof DiscreteChanceNode) {
                    if (((DiscreteChanceNode)this.nodes[n2]).caseIsSet(n)) {
                        DiscreteChanceNode discreteChanceNode = (DiscreteChanceNode)this.nodes[n2];
                        boolean bl = false;
                        String string = discreteChanceNode.getAttribute("HR_Node_states");
                        if (string != null && string.toLowerCase().trim().equals("labels") || discreteChanceNode instanceof BooleanDCNode || discreteChanceNode instanceof LabelledDCNode) {
                            bl = true;
                        }
                        if (bl) {
                            return ((DiscreteChanceNode)this.nodes[n2]).getStateLabel(((DiscreteChanceNode)this.nodes[n2]).getCaseState(n));
                        }
                        if (discreteChanceNode instanceof IntervalDCNode) {
                            return "" + HuginGUIUtils.printInf(((IntervalDCNode)this.nodes[n2]).getStateValue(((IntervalDCNode)this.nodes[n2]).getCaseState(n))) + " - " + HuginGUIUtils.printInf(((IntervalDCNode)this.nodes[n2]).getStateValue(((IntervalDCNode)this.nodes[n2]).getCaseState(n) + 1));
                        }
                        return HuginGUIUtils.printInf(((NumberedDCNode)this.nodes[n2]).getStateValue(((DiscreteChanceNode)this.nodes[n2]).getCaseState(n)));
                    }
                    return HuginGUIConstants.get("str_NA");
                }
                if (this.nodes[n2] instanceof ContinuousChanceNode) {
                    if (((ContinuousChanceNode)this.nodes[n2]).caseIsSet(n)) {
                        return new Double(((ContinuousChanceNode)this.nodes[n2]).getCaseValue(n)).toString();
                    }
                    return HuginGUIConstants.get("str_NA");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return "-";
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return HuginGUIConstants.get("AW_Accuracy_case_no");
            }
            --n;
            String string = HuginGUIConstants.get("str_error_detected");
            try {
                String string2;
                string = string2 = HuginGUIUtils.getNodeTitle(this.nodes[n], (short)0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return string;
        }

        public String[] getColumnNames() {
            String[] stringArray = new String[this.getColumnCount()];
            for (int i = 0; i < this.getColumnCount(); ++i) {
                stringArray[i] = this.getColumnName(i);
            }
            return stringArray;
        }

        public int getColumnCount() {
            return this.nodes.length + 1;
        }

        public int getRowCount() {
            return this.numRows;
        }
    }

    protected class DomainCasesListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            DataAnalyzerDialog.this.streamData = (StreamData)changeEvent.getSource();
            String string = DataAnalyzerDialog.this.streamData.getSourceName();
            DataAnalyzerDialog.this.showData(string, DataAnalyzerDialog.this.streamData);
        }
    }
}

