/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.DataAnalyserModel;
import COM.hugin.HGUI.Plot;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DataInspector
extends JDialog {
    private String[] graphStyles = new String[]{"Distribution of observations", "Class distribution"};
    private DataAnalyserModel dataModel = null;
    private DataAnalyserModel.DataHolder variable = null;
    private JComboBox target = null;
    private JComboBox graphStyle = null;
    private JButton computeGraph = null;
    private JPanel plotContainer = null;
    private Plot plot = null;

    public DataInspector(JDialog jDialog) {
        super(jDialog, "Mr. Data Inspector!", false);
        this.setPreferredSize(new Dimension(400, 500));
        this.setSize(this.getPreferredSize());
    }

    public void setDataAndVariable(DataAnalyserModel dataAnalyserModel, DataAnalyserModel.DataHolder dataHolder) {
        this.dataModel = dataAnalyserModel;
        this.variable = dataHolder;
        this.getContentPane().removeAll();
        this.getContentPane().add(this.createMainPanel());
        this.validate();
    }

    private JPanel createMainPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.plotContainer = new JPanel(new GridLayout(1, 1));
        jPanel.add((Component)this.plotContainer, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        jPanel2.add(new JLabel("Select target class:"));
        this.target = new JComboBox<DataAnalyserModel.DataHolder>(this.dataModel.getVariables());
        jPanel2.add(this.target);
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel(new FlowLayout(1));
        this.graphStyle = new JComboBox<String>(this.graphStyles);
        jPanel3.add(this.graphStyle);
        this.computeGraph = new JButton("Compute Graph");
        this.computeGraph.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataInspector.this.computeGraph();
            }
        });
        jPanel3.add(this.computeGraph);
        jPanel.add((Component)jPanel3, "South");
        return jPanel;
    }

    private void computeGraph() {
        if (this.graphStyle.getSelectedItem().equals(this.graphStyles[0])) {
            String string = ((DataAnalyserModel.DataHolder)this.target.getSelectedItem()).getName();
            String string2 = this.variable.getName();
            System.out.println(string + " " + string2);
        } else if (this.graphStyle.getSelectedItem().equals(this.graphStyles[1])) {
            // empty if block
        }
        this.plotContainer.removeAll();
        double d = -0.5;
        double d2 = 0.5;
        double d3 = 0.0;
        double d4 = 5.0;
        double d5 = -0.5;
        double d6 = 0.5;
        ArrayList<Plot.Label> arrayList = Plot.constructNumberedLabels(0, d, d2, 5);
        ArrayList<Plot.Label> arrayList2 = Plot.constructNumberedLabels(1, d3, d4, 5);
        ArrayList<Plot.Label> arrayList3 = Plot.constructNumberedLabels(2, d5, d6, 5);
        String string = "X-Axis";
        String string3 = "Y-Axis";
        String string4 = "Z-Axis";
        double[][] dArrayArray = new double[][]{{2.0, 3.0, 1.0}, {1.0, 4.0, 3.0}, {1.0, 3.0, 2.0}};
        ArrayList<Plot.Triangle> arrayList4 = Plot.constructSurface(dArrayArray, d3, d4);
        Plot plot = new Plot(arrayList4, string, string3, string4, arrayList, arrayList2, arrayList3, d, d2, d3, d4, d5, d6);
        plot.showPoint(0.0, 4.0, 0.0, "Point (0, 4, 0)");
        this.plotContainer.add((Component)plot, "Center");
        this.validate();
    }
}

