/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.Case;
import COM.hugin.HGUI.DataSourceException;
import COM.hugin.HGUI.DataStream;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.PreProcessingException;
import COM.hugin.HGUI.Variable;
import COM.hugin.HGUI.WizardError;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class DataStreamViewer
extends JDialog {
    JTable table;
    CaseModel caseModel;
    DataStream stream;
    JPanel viewingPanel;
    int fromIndex;
    int size;
    boolean custom;
    ChangeListener closeListener;
    JButton reset;
    JButton next;
    JLabel to;
    JLabel from;
    JScrollPane scrollTable;

    public DataStreamViewer(JDialog jDialog, DataStream dataStream, int n) throws DataSourceException, PreProcessingException {
        super(jDialog, "View Data", false);
        this.stream = dataStream;
        this.size = n;
        this.fromIndex = 0;
        this.custom = false;
        this.closeListener = null;
        this.addWindowListener(new CloseWindowListener());
        this.getContentPane().add(this.createInterior());
        this.getRootPane().setDefaultButton(this.next);
        this.setLocation(jDialog.getX() + 100, jDialog.getY() + 100);
    }

    public DataStreamViewer(JDialog jDialog, DataStream dataStream, int n, boolean bl) throws DataSourceException, PreProcessingException {
        super(jDialog, "View Data", false);
        this.stream = dataStream;
        this.size = n;
        this.fromIndex = 0;
        this.custom = bl;
        this.closeListener = null;
        this.addWindowListener(new CloseWindowListener());
        this.getContentPane().add(this.createInterior());
        this.getRootPane().setDefaultButton(this.next);
        HuginGUIUtils.placeNextTo(jDialog, this);
    }

    private JPanel createInterior() throws DataSourceException, PreProcessingException {
        JPanel jPanel;
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.caseModel = new CaseModel(this.stream, this.size);
        this.table = new JTable(this.caseModel);
        this.table.getTableHeader().setDefaultRenderer(new ToolTipHeader());
        if (this.table.getPreferredSize().width > 300) {
            jPanel = new JPanel(new BorderLayout(0, 0)){

                public Dimension getPreferredSize() {
                    return DataStreamViewer.this.table.getPreferredSize();
                }
            };
            jPanel.add((Component)this.table, "West");
            this.scrollTable = new JScrollPane(jPanel);
        } else {
            this.scrollTable = new JScrollPane(this.table);
        }
        this.scrollTable.setColumnHeaderView(this.table.getTableHeader());
        this.scrollTable.setPreferredSize(new Dimension(300, 400));
        this.viewingPanel = new JPanel(new FlowLayout());
        this.viewingPanel.add(new JLabel("Viewing from case "));
        this.from = new JLabel("" + this.fromIndex);
        this.viewingPanel.add(this.from);
        this.viewingPanel.add(new JLabel(" to case "));
        this.to = new JLabel("" + (this.fromIndex + this.caseModel.getRowCount()));
        this.viewingPanel.add(this.to);
        jPanel = new JPanel(new FlowLayout());
        this.reset = new JButton("Reset");
        this.reset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DataStreamViewer.this.caseModel.reset();
                }
                catch (Exception exception) {
                    WizardError.showError(HuginGUIConstants.get("str_error"), HuginGUIConstants.get("str_unable_to_reset_ARG0", new String[]{exception.getMessage()}), DataStreamViewer.this);
                }
            }
        });
        this.next = new JButton("More Data");
        this.next.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataStreamViewer.this.caseModel.moreData();
            }
        });
        this.next.setEnabled(this.caseModel.getRowCount() == this.size);
        JButton jButton = new JButton("Close");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (!DataStreamViewer.this.custom) {
                        DataStreamViewer.this.stream.reset();
                    }
                }
                catch (Exception exception) {
                    WizardError.showError(HuginGUIConstants.get("str_error"), exception.getMessage(), DataStreamViewer.this);
                }
                if (DataStreamViewer.this.closeListener != null) {
                    DataStreamViewer.this.closeListener.stateChanged(new ChangeEvent(new Object()));
                }
                DataStreamViewer.this.dispose();
            }
        });
        if (!this.custom) {
            jPanel.add(this.reset);
            jPanel.add(this.next);
        }
        jPanel.add(jButton);
        jPanel2.add((Component)this.viewingPanel, "North");
        jPanel2.add(this.scrollTable);
        jPanel2.add((Component)jPanel, "South");
        return jPanel2;
    }

    protected void setStream(DataStream dataStream) throws DataSourceException, PreProcessingException {
        this.stream = dataStream;
        this.caseModel = new CaseModel(dataStream, this.size);
        this.table.setModel(this.caseModel);
        if (this.table.getPreferredSize().width > 300) {
            JPanel jPanel = new JPanel(){

                public Dimension getPreferredSize() {
                    return DataStreamViewer.this.table.getPreferredSize();
                }
            };
            jPanel.add(this.table);
            this.scrollTable.setViewportView(jPanel);
        } else {
            this.scrollTable.setViewportView(this.table);
        }
        this.scrollTable.setColumnHeaderView(this.table.getTableHeader());
    }

    public void setCustom(boolean bl) {
        this.custom = bl;
    }

    public boolean isCustom() {
        return this.custom;
    }

    public JTable getTable() {
        return this.table;
    }

    public JScrollPane getScrollPane() {
        return this.scrollTable;
    }

    public void addCloseListener(ChangeListener changeListener) {
        this.closeListener = changeListener;
    }

    private class CloseWindowListener
    implements WindowListener {
        private CloseWindowListener() {
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            try {
                DataStreamViewer.this.stream.reset();
            }
            catch (Exception exception) {
                WizardError.showError(HuginGUIConstants.get("str_error"), exception.getMessage(), DataStreamViewer.this);
            }
            if (DataStreamViewer.this.closeListener != null) {
                DataStreamViewer.this.closeListener.stateChanged(new ChangeEvent(new Object()));
            }
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }
    }

    private class ToolTipHeader
    implements TableCellRenderer {
        private ToolTipHeader() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JTextField jTextField = new JTextField(object.toString());
            jTextField.setToolTipText(object.toString());
            jTextField.setEditable(false);
            jTextField.setHorizontalAlignment(0);
            jTextField.setBorder(BorderFactory.createRaisedBevelBorder());
            return jTextField;
        }
    }

    private class CaseModel
    extends DefaultTableModel {
        DataStream stream;
        int desiredSize;
        int realSize = -1;
        Vector<String> data;
        String[] names;

        public CaseModel(DataStream dataStream, int n) throws DataSourceException, PreProcessingException {
            this.stream = dataStream;
            this.desiredSize = n;
            this.names = dataStream.getFieldNames();
            if (this.names.length == 0) {
                DataStreamViewer.this.next.setEnabled(false);
            }
            int n2 = 0;
            int n3 = 0;
            Variable[] variableArray = dataStream.getCaseTemplate().getVariables();
            while (n2 < this.names.length) {
                if (!variableArray[n3].isExcluded()) {
                    this.names[n2] = variableArray[n3].getNameOrLabel();
                    ++n2;
                }
                ++n3;
            }
            this.data = new Vector(this.names.length * this.desiredSize);
            Case case_ = dataStream.readCase();
            if (case_ == null) {
                throw new DataSourceException(HuginGUIConstants.get("str_empty_data_file"));
            }
            Variable[] variableArray2 = case_.getVariables();
            int n4 = 0;
            while (n4 < n && case_ != null) {
                for (int i = 0; i < variableArray2.length; ++i) {
                    if (variableArray2[i].isExcluded()) continue;
                    this.data.add(variableArray2[i].getState());
                }
                case_ = dataStream.readCase();
                if (case_ != null) {
                    variableArray2 = case_.getVariables();
                }
                this.realSize = n4++;
            }
            ++this.realSize;
        }

        public int getColumnCount() {
            return DataStreamViewer.this.custom ? this.names.length + 1 : this.names.length;
        }

        public int getRowCount() {
            int n = this.realSize;
            if (n < 0) {
                n = this.desiredSize;
            }
            return n;
        }

        public String getColumnName(int n) {
            if (DataStreamViewer.this.custom) {
                if (n == 0) {
                    return HuginGUIConstants.get("AW_Accuracy_case_no");
                }
                --n;
            }
            return this.names[n];
        }

        public Object getValueAt(int n, int n2) {
            int n3 = this.getColumnCount();
            if (DataStreamViewer.this.custom) {
                n3 = this.getColumnCount() - 1;
                if (n2 == 0) {
                    return "" + n;
                }
                --n2;
            }
            return this.data.get(n * n3 + n2);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void reset() throws DataSourceException {
            this.stream.reset();
            DataStreamViewer.this.fromIndex = -this.getRowCount();
            DataStreamViewer.this.next.setEnabled(this.names.length > 0);
            this.moreData();
        }

        public void moreData() {
            try {
                Case case_ = this.stream.readCase();
                Variable[] variableArray = case_.getVariables();
                int n = this.getRowCount();
                DataStreamViewer.this.fromIndex += n;
                int n2 = 0;
                while (n2 < this.desiredSize && case_ != null) {
                    int n3 = 0;
                    for (int i = 0; i < variableArray.length; ++i) {
                        if (variableArray[i].isExcluded()) continue;
                        this.data.setElementAt(variableArray[i].getState(), n2 * this.names.length + n3);
                        ++n3;
                    }
                    case_ = this.stream.readCase();
                    if (case_ != null) {
                        variableArray = case_.getVariables();
                    }
                    this.realSize = n2++;
                }
                ++this.realSize;
                if (this.desiredSize > this.realSize) {
                    DataStreamViewer.this.next.setEnabled(false);
                    this.fireTableRowsDeleted(this.realSize, n);
                }
                if (n < this.realSize) {
                    this.fireTableRowsInserted(n, this.realSize);
                }
                DataStreamViewer.this.from.setText("" + DataStreamViewer.this.fromIndex);
                DataStreamViewer.this.to.setText("" + (DataStreamViewer.this.fromIndex + DataStreamViewer.this.caseModel.getRowCount()));
                this.fireTableRowsUpdated(0, this.getRowCount() - 1);
            }
            catch (Exception exception) {
                WizardError.showError(HuginGUIConstants.get("str_error"), HuginGUIConstants.get("str_unable_to_reset_ARG0", new String[]{exception.getMessage()}), DataStreamViewer.this);
            }
            DataStreamViewer.this.scrollTable.getVerticalScrollBar().setValue(0);
        }
    }
}

