/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.DataSourceException;
import COM.hugin.HGUI.DataStream;
import COM.hugin.HGUI.FileLauncher;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginFileLoader;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.PreProcessingException;
import COM.hugin.HGUI.StreamData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class DataViewer
extends JDialog {
    JTable table;
    DefaultTableModel caseModel;
    StreamData streamData;
    JPanel viewingPanel;
    int fromIndex;
    int size;
    Point location = null;
    Dimension dimension;
    ChangeListener closeListener;
    JButton saveCSVButton;
    JLabel to;
    JLabel from;
    JScrollPane scrollTable;

    public DataViewer(JDialog jDialog, StreamData streamData) throws DataSourceException, PreProcessingException {
        super(jDialog, "View Data", false);
        this.streamData = streamData;
        this.size = streamData.getSize();
        this.fromIndex = 0;
        this.closeListener = null;
        this.addWindowListener(new CloseWindowListener());
        this.getContentPane().add(this.createInterior());
        if (this.location == null) {
            HuginGUIUtils.placeNextTo(jDialog, this);
        } else {
            this.setLocation(this.location);
        }
    }

    public DataViewer(JDialog jDialog, StreamData streamData, Point point, Dimension dimension) throws DataSourceException, PreProcessingException {
        super(jDialog, "View Data", false);
        this.streamData = streamData;
        this.fromIndex = 0;
        this.size = streamData.getSize();
        this.location = point;
        this.dimension = dimension;
        this.closeListener = null;
        this.addWindowListener(new CloseWindowListener());
        this.getContentPane().add(this.createInterior());
        if (point == null) {
            HuginGUIUtils.placeNextTo(jDialog, this);
        } else {
            this.setLocation(point);
        }
    }

    private JPanel createInterior() throws DataSourceException, PreProcessingException {
        JPanel jPanel;
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.caseModel = new CaseModel(this.streamData);
        this.table = new JTable(this.caseModel);
        this.initColumnSizes(this.table);
        this.table.getTableHeader().setDefaultRenderer(new ToolTipHeader());
        int n = 300;
        if (this.dimension != null) {
            n = this.dimension.width;
        }
        if (this.table.getPreferredSize().width > n) {
            jPanel = new JPanel(new BorderLayout(0, 0)){

                public Dimension getPreferredSize() {
                    return DataViewer.this.table.getPreferredSize();
                }
            };
            jPanel.add((Component)this.table, "West");
            this.scrollTable = new JScrollPane(jPanel);
        } else {
            this.scrollTable = new JScrollPane(this.table);
        }
        this.scrollTable.setColumnHeaderView(this.table.getTableHeader());
        if (this.dimension == null) {
            this.scrollTable.setPreferredSize(new Dimension(300, 400));
        } else {
            this.setPreferredSize(this.dimension);
        }
        this.viewingPanel = new JPanel(new FlowLayout());
        this.viewingPanel.add(new JLabel("Viewing from case "));
        this.from = new JLabel("" + this.fromIndex);
        this.viewingPanel.add(this.from);
        this.viewingPanel.add(new JLabel(" to case "));
        this.to = new JLabel("" + (this.fromIndex + this.caseModel.getRowCount()));
        this.viewingPanel.add(this.to);
        jPanel = new JPanel(new FlowLayout());
        JButton jButton = new JButton("Close");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DataViewer.this.closeListener != null) {
                    DataViewer.this.closeListener.stateChanged(new ChangeEvent(new Object()));
                }
                DataViewer.this.dispose();
            }
        });
        this.saveCSVButton = new JButton(HuginGUIConstants.get("AW_export_csv"));
        this.saveCSVButton.addActionListener(new SaveCSVListener(this.table));
        jPanel.add(jButton);
        jPanel.add(this.saveCSVButton);
        jPanel2.add((Component)this.viewingPanel, "North");
        jPanel2.add(this.scrollTable);
        jPanel2.add((Component)jPanel, "South");
        return jPanel2;
    }

    protected void setStream(StreamData streamData) throws DataSourceException, PreProcessingException {
        this.caseModel = new CaseModel(streamData);
        this.table.setModel(this.caseModel);
        if (this.table.getPreferredSize().width > 300) {
            JPanel jPanel = new JPanel(){

                public Dimension getPreferredSize() {
                    return DataViewer.this.table.getPreferredSize();
                }
            };
            jPanel.add(this.table);
            this.scrollTable.setViewportView(jPanel);
        } else {
            this.scrollTable.setViewportView(this.table);
        }
        this.scrollTable.setColumnHeaderView(this.table.getTableHeader());
    }

    public JTable getTable() {
        return this.table;
    }

    public JScrollPane getScrollPane() {
        return this.scrollTable;
    }

    public void addCloseListener(ChangeListener changeListener) {
        this.closeListener = changeListener;
    }

    private void initColumnSizes(JTable jTable) {
        jTable.doLayout();
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        TableModel tableModel = jTable.getModel();
        TableColumn tableColumn = null;
        Component component = null;
        int n = 0;
        int n2 = 0;
        TableCellRenderer tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            tableColumn = jTable.getColumnModel().getColumn(i);
            component = tableCellRenderer.getTableCellRendererComponent(null, tableColumn.getHeaderValue(), false, false, 0, 0);
            n = component.getPreferredSize().width;
            n2 = 0;
            for (int j = 0; j < jTable.getRowCount(); ++j) {
                component = jTable.getDefaultRenderer(tableModel.getColumnClass(i)).getTableCellRendererComponent(jTable, jTable.getValueAt(0, i), false, false, 0, i);
                n2 = Math.max(n2, component.getPreferredSize().width + 15);
            }
            tableColumn.setPreferredWidth(Math.max(n, n2));
        }
    }

    class SaveCSVListener
    implements ActionListener {
        private JTable table;

        public SaveCSVListener(JTable jTable) {
            this.table = jTable;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block12: {
                if (this.table != null) {
                    int n = this.table.getColumnCount();
                    int n2 = this.table.getRowCount();
                    try {
                        int n3;
                        HuginFileLoader huginFileLoader = new HuginFileLoader(11, Hugin.mainFrame.getMostRecentDataFile(), 5);
                        if (huginFileLoader.showSaveDialog(Hugin.mainFrame) != 0) break block12;
                        File file = huginFileLoader.getSelectedFile();
                        PrintStream printStream = new PrintStream(file);
                        String string = ";";
                        for (n3 = 0; n3 < n; ++n3) {
                            if (n3 > 0) {
                                printStream.print(" " + string + " ");
                            }
                            String string2 = "" + this.table.getColumnName(n3);
                            if ((string2 = string2.replaceAll("\n", " ")).indexOf(",") > 0 || string2.indexOf(".") > 0 || string2.indexOf(";") > 0 || string2.indexOf("\"") > 0) {
                                string2 = "\"" + string2 + "\"";
                            }
                            printStream.print(string2);
                        }
                        printStream.print("\r\n");
                        for (n3 = 0; n3 < n2; ++n3) {
                            for (int i = 0; i < n; ++i) {
                                String string3;
                                block13: {
                                    if (i > 0) {
                                        printStream.print(" " + string + " ");
                                    }
                                    string3 = "" + this.table.getValueAt(n3, i);
                                    try {
                                        Double.parseDouble(string3);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        string3 = string3.replaceAll("\n", " ");
                                        if (string3.indexOf(",") <= 0 && string3.indexOf(".") <= 0 && string3.indexOf(";") <= 0 && string3.indexOf("\"") <= 0) break block13;
                                        string3 = "\"" + string3 + "\"";
                                    }
                                }
                                printStream.print(string3);
                            }
                            printStream.print("\r\n");
                        }
                        printStream.close();
                        new FileLauncher((Dialog)DataViewer.this, Hugin.mainFrame, file);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        new HuginGUIError(fileNotFoundException.getMessage());
                    }
                    catch (Exception exception) {
                        new HuginGUIError(exception);
                    }
                }
            }
        }
    }

    private class CloseWindowListener
    implements WindowListener {
        private CloseWindowListener() {
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            if (DataViewer.this.closeListener != null) {
                DataViewer.this.closeListener.stateChanged(new ChangeEvent(new Object()));
            }
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }
    }

    private class ToolTipHeader
    implements TableCellRenderer {
        private ToolTipHeader() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JTextField jTextField = new JTextField(object.toString());
            jTextField.setToolTipText(object.toString());
            jTextField.setEditable(false);
            jTextField.setHorizontalAlignment(0);
            jTextField.setBorder(BorderFactory.createRaisedBevelBorder());
            return jTextField;
        }
    }

    private class CaseModel
    extends DefaultTableModel {
        DataStream stream;
        int desiredSize;
        int realSize = -1;
        Vector<StreamData.ColumnData> data;
        String[] names;

        public CaseModel(StreamData streamData, boolean bl) {
            if (bl) {
                streamData.createCaseNumbers();
            } else {
                streamData.removeCaseNumbers();
            }
            this.names = streamData.getFieldNames();
            this.data = streamData.getData();
            this.realSize = streamData.getSize();
        }

        public CaseModel(StreamData streamData) {
            streamData.createCaseNumbers();
            this.names = streamData.getFieldNames();
            this.data = streamData.getData();
            this.realSize = streamData.getSize();
        }

        public int getColumnCount() {
            return this.names.length;
        }

        public int getRowCount() {
            int n = this.realSize;
            if (n < 0) {
                n = this.desiredSize;
            }
            return n;
        }

        public String getColumnName(int n) {
            return this.names[n];
        }

        public Object getValueAt(int n, int n2) {
            Object object = this.data.get(n2).getValueFromCase(n);
            if (object != null && object instanceof String && ((String)object).length() == 0) {
                object = null;
            }
            if (object == null) {
                object = HuginGUIConstants.get("str_NA");
            }
            return object;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

