/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.BooleanDDNode;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.IntervalDDNode;
import COM.hugin.HAPI.LabelledDDNode;
import COM.hugin.HAPI.NumberedDDNode;
import COM.hugin.HGUI.DiscreteNode;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.NetworkPanel;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.PolygonNode;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;

public class DiscreteDecisionNode
extends PolygonNode
implements DiscreteNode {
    protected static final int LABELLED = 0;
    protected static final int BOOLEAN = 1;
    protected static final int NUMBERED = 2;
    protected static final int INTERVAL = 3;
    private int subtype;

    public DiscreteDecisionNode(NetworkPanel networkPanel, Point point, String string) throws ExceptionHugin {
        super(networkPanel, point);
        this.name = string;
        this.label = "";
        this.initialize(0);
    }

    public DiscreteDecisionNode(NetworkPanel networkPanel, Point point, String string, String string2, int n) throws ExceptionHugin {
        super(networkPanel, point, string, string2);
        this.initialize(n);
    }

    public DiscreteDecisionNode(Node node) {
        super(node);
        this.type = 4;
        this.subtype = ((DiscreteDecisionNode)node).subtype;
        this.setPoints();
    }

    public DiscreteDecisionNode(NetworkPanel networkPanel, String string, String string2) {
        super(networkPanel, string, string2);
        this.colorAttribute = "HR_Color_Decision";
        this.type = 4;
        this.subtype = 0;
        this.setPoints();
        this.shape = new Polygon(this.xpoints, this.ypoints, 4);
    }

    public DiscreteDecisionNode(NetworkPanel networkPanel, COM.hugin.HAPI.DiscreteDecisionNode discreteDecisionNode) {
        super(networkPanel, discreteDecisionNode);
        this.colorAttribute = "HR_Color_Decision";
        this.type = 4;
        this.subtype = discreteDecisionNode instanceof LabelledDDNode ? 0 : (discreteDecisionNode instanceof BooleanDDNode ? 1 : (discreteDecisionNode instanceof NumberedDDNode ? 2 : (discreteDecisionNode instanceof IntervalDDNode ? 3 : 0)));
        this.setPoints();
        this.shape = new Polygon(this.xpoints, this.ypoints, 4);
        this.updateColor();
    }

    private void initialize(int n) throws ExceptionHugin {
        this.colorAttribute = "HR_Color_Decision";
        switch (n) {
            case 0: {
                String string = HuginGUIConstants.get("NODE_PROPERTIES_action");
                this.setAPINode(new LabelledDDNode(this.home));
                ((COM.hugin.HAPI.DiscreteDecisionNode)this.getAPINode()).setNumberOfStates(2);
                ((COM.hugin.HAPI.DiscreteDecisionNode)this.getAPINode()).setStateLabel(0, string + 1);
                ((COM.hugin.HAPI.DiscreteDecisionNode)this.getAPINode()).setStateLabel(1, string + 2);
                break;
            }
            case 1: {
                this.setAPINode(new BooleanDDNode(this.home));
                break;
            }
            case 2: {
                this.setAPINode(new NumberedDDNode(this.home));
                ((NumberedDDNode)this.getAPINode()).setNumberOfStates(2);
                ((NumberedDDNode)this.getAPINode()).setStateValue(0, 1.0);
                ((NumberedDDNode)this.getAPINode()).setStateValue(1, 2.0);
                ((NumberedDDNode)this.getAPINode()).setStateLabel(0, "1");
                ((NumberedDDNode)this.getAPINode()).setStateLabel(1, "2");
                break;
            }
            case 3: {
                double d = 0.0;
                double d2 = 1.0;
                double d3 = 1.0;
                double d4 = 2.0;
                String string = HuginGUIUtils.printInterval(d, d3);
                String string2 = HuginGUIUtils.printInterval(d2, d4);
                this.setAPINode(new IntervalDDNode(this.home));
                ((IntervalDDNode)this.getAPINode()).setNumberOfStates(2);
                ((IntervalDDNode)this.getAPINode()).setStateValue(0, d);
                ((IntervalDDNode)this.getAPINode()).setStateValue(1, d2);
                ((IntervalDDNode)this.getAPINode()).setStateValue(2, d4);
                ((IntervalDDNode)this.getAPINode()).setStateLabel(0, string);
                ((IntervalDDNode)this.getAPINode()).setStateLabel(1, string2);
            }
        }
        this.storePosition();
        this.getAPINode().setName(this.name);
        this.getAPINode().setLabel(this.label);
        this.updateColor();
        this.type = 4;
        this.subtype = n;
        this.setPoints();
        this.shape = new Polygon(this.xpoints, this.ypoints, 4);
    }

    protected void setPoints() {
        this.xpoints = new int[4];
        this.ypoints = new int[4];
        this.xpoints[0] = this.xpoints[3] = (int)(this.center.x - this.width / 2.0);
        this.xpoints[1] = this.xpoints[2] = (int)(this.center.x + this.width / 2.0);
        this.ypoints[0] = this.ypoints[1] = (int)(this.center.y - this.height / 2.0);
        this.ypoints[2] = this.ypoints[3] = (int)(this.center.y + this.height / 2.0);
        this.west.setLocation(this.xpoints[0], (int)this.center.y);
        this.south.setLocation((int)this.center.x, this.ypoints[2]);
        this.east.setLocation(this.xpoints[1], (int)this.center.y);
        this.north.setLocation((int)this.center.x, this.ypoints[0]);
        this.setBorderPoints();
    }

    private void setBorderPoints() {
        this.xBorderPoints = new int[4];
        this.yBorderPoints = new int[4];
        int n = (int)Math.rint(this.scaleFactor * 8.0) / 2;
        this.xBorderPoints[0] = this.xBorderPoints[3] = (int)(this.center.x - this.width / 2.0) + n;
        this.xBorderPoints[1] = this.xBorderPoints[2] = (int)(this.center.x + this.width / 2.0) - n;
        this.yBorderPoints[0] = this.yBorderPoints[1] = (int)(this.center.y - this.height / 2.0) + n;
        this.yBorderPoints[2] = this.yBorderPoints[3] = (int)(this.center.y + this.height / 2.0) - n;
    }

    protected void shrink(int[] nArray, int[] nArray2) {
        nArray[0] = nArray[0] + 1;
        nArray[1] = nArray[1] - 1;
        nArray[2] = nArray[2] - 1;
        nArray[3] = nArray[3] + 1;
        nArray2[0] = nArray2[0] + 1;
        nArray2[1] = nArray2[1] + 1;
        nArray2[2] = nArray2[2] - 1;
        nArray2[3] = nArray2[3] - 1;
    }

    protected void drawDashedBorder(Graphics graphics, Point point) {
        int n;
        int n2;
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        for (n2 = 0; n2 < 4; ++n2) {
            nArray[n2] = this.xpoints[n2] + point.x;
            nArray2[n2] = this.ypoints[n2] + point.y;
        }
        n2 = 6;
        for (n = nArray[0]; n < nArray[1]; n += n2 + 6) {
            if (n + n2 > nArray[1]) {
                n2 = nArray[1] - n;
            }
            graphics.drawLine(n, nArray2[0], n + n2, nArray2[0]);
            graphics.drawLine(n, nArray2[3], n + n2, nArray2[3]);
        }
        n2 = 6;
        for (n = nArray2[1]; n < nArray2[2]; n += n2 + 6) {
            if (n + n2 > nArray2[2]) {
                n2 = nArray2[2] - n;
            }
            graphics.drawLine(nArray[0], n, nArray[0], n + n2);
            graphics.drawLine(nArray[1], n, nArray[1], n + n2);
        }
    }

    public void setSubtype(int n) {
        if (this.subtype != n) {
            this.panel.containsUnsavedChanges(true);
            this.subtype = n;
        }
    }

    public int getSubtype() {
        return this.subtype;
    }

    public void incrementNumberOfStates() {
        try {
            int n = this.getNumberOfStates();
            switch (this.subtype) {
                case 0: {
                    LabelledDDNode labelledDDNode = (LabelledDDNode)this.getAPINode();
                    String string = HuginGUIConstants.get("NODE_PROPERTIES_action") + (n + 1);
                    labelledDDNode.setNumberOfStates(n + 1);
                    labelledDDNode.setStateLabel(n, string);
                    break;
                }
                case 1: {
                    new HuginGUIError("DiscreteDecisionNode.incrementNumberOfStates", HuginGUIConstants.get("str_attempt_to_decision_number_states_bool_node"));
                    return;
                }
                case 2: {
                    NumberedDDNode numberedDDNode = (NumberedDDNode)this.getAPINode();
                    double d = numberedDDNode.getStateValue(n - 1);
                    double d2 = n > 1 ? numberedDDNode.getStateValue(n - 2) : d;
                    double d3 = d2 != d ? 2.0 * d - d2 : d + 1.0;
                    numberedDDNode.setNumberOfStates(n + 1);
                    numberedDDNode.setStateValue(n, d3);
                    break;
                }
                case 3: {
                    IntervalDDNode intervalDDNode = (IntervalDDNode)this.getAPINode();
                    double d = intervalDDNode.getStateValue(n - 1);
                    double d4 = intervalDDNode.getStateValue(n);
                    intervalDDNode.setNumberOfStates(n + 1);
                    intervalDDNode.setStateValue(n, d4);
                    intervalDDNode.setStateValue(n + 1, 2.0 * d4 - d);
                }
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage() + " : " + HuginGUIConstants.get("Most_likely_cause") + " : " + HuginGUIConstants.get("Node_Table_too_large"));
        }
    }

    public void decrementNumberOfStates() {
        try {
            int n = this.getNumberOfStates();
            if (this.subtype == 3) {
                IntervalDDNode intervalDDNode = (IntervalDDNode)this.getAPINode();
                double d = intervalDDNode.getStateValue(n - 1);
                intervalDDNode.setStateValue(n, d);
            }
            ((COM.hugin.HAPI.DiscreteNode)this.getAPINode()).setNumberOfStates(n - 1);
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage());
        }
    }

    public int getNumberOfStates() {
        try {
            return ((COM.hugin.HAPI.DiscreteNode)this.getAPINode()).getNumberOfStates();
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
            return 0;
        }
    }

    public String[] getStates() {
        try {
            COM.hugin.HAPI.DiscreteNode discreteNode = (COM.hugin.HAPI.DiscreteNode)this.getAPINode();
            int n = discreteNode.getNumberOfStates();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = discreteNode.getStateLabel(i);
            }
            return stringArray;
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
            return null;
        }
    }
}

