/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.DataAnalyser;
import COM.hugin.HGUI.DataAnalyserModel;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DiscretizeDialog
extends JDialog {
    private static final int NUM_INTS_INITIAL = 5;
    private boolean liveUpdate = true;
    private DataAnalyserModel.DataHolder holder;
    private DataAnalyserModel.DataHolder[] dataHolders;
    JButton equalDist;
    JButton equiDist;
    IntervalSlider slider;
    DataAnalyser.DistributionDisplay display;
    JLabel maxValue;
    JLabel minValue;
    JSpinner numIntervals;
    JCheckBox liveUpdateCheck;
    JScrollPane displayScroller;
    private boolean setDataHolders = false;

    public DiscretizeDialog(JDialog jDialog) {
        super(jDialog, HuginGUIConstants.get("str_discretize_variable"), false);
        this.setContentPane(this.createContents());
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (!DiscretizeDialog.this.liveUpdate && ((JSlider)changeEvent.getSource()).getValueIsAdjusting()) {
                    return;
                }
                try {
                    if (DiscretizeDialog.this.holder == null) {
                        int n = 0;
                        for (DataAnalyserModel.DataHolder dataHolder : DiscretizeDialog.this.dataHolders) {
                            dataHolder.setIntervals(DiscretizeDialog.this.slider.getIntervals(), true);
                            ++n;
                        }
                        DiscretizeDialog.this.display.reset();
                    } else {
                        DiscretizeDialog.this.holder.setIntervals(DiscretizeDialog.this.slider.getIntervals(), true);
                    }
                    DiscretizeDialog.this.display.revalidate();
                    DiscretizeDialog.this.display.repaint();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    new HuginGUIError(exception.getMessage());
                }
            }
        });
    }

    private JPanel createContents() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.slider = new IntervalSlider(5);
        this.maxValue = new JLabel("");
        this.minValue = new JLabel("");
        jPanel2.add((Component)this.minValue, "North");
        jPanel2.add(this.slider);
        jPanel2.add((Component)this.maxValue, "South");
        jPanel.add((Component)jPanel2, "West");
        JPanel jPanel3 = new JPanel(new GridLayout(2, 1));
        this.numIntervals = new JSpinner(new SpinnerNumberModel(5, 2, 100, 1));
        this.numIntervals.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (DiscretizeDialog.this.holder != null) {
                    int n;
                    int n2;
                    int n3 = (Integer)DiscretizeDialog.this.numIntervals.getValue();
                    if (n3 > (n2 = DiscretizeDialog.this.slider.getNumberOfIntervals())) {
                        for (n = n2; n < n3; ++n) {
                            DiscretizeDialog.this.slider.addBreak();
                        }
                    } else {
                        for (n = n3; n < n2; ++n) {
                            DiscretizeDialog.this.slider.removeBreak();
                        }
                    }
                    DiscretizeDialog.this.slider.revalidate();
                    DiscretizeDialog.this.slider.repaint();
                    try {
                        if (DiscretizeDialog.this.holder != null) {
                            DiscretizeDialog.this.holder.setIntervals(DiscretizeDialog.this.slider.getIntervals(), true);
                            DiscretizeDialog.this.display.revalidate();
                            DiscretizeDialog.this.display.repaint();
                        }
                    }
                    catch (Exception exception) {
                        new HuginGUIError(exception);
                    }
                } else if (!DiscretizeDialog.this.setDataHolders) {
                    int n = 0;
                    for (DataAnalyserModel.DataHolder dataHolder : DiscretizeDialog.this.dataHolders) {
                        int n4;
                        if (dataHolder.getIntervals(true) != null) {
                            double[] dArray = dataHolder.getIntervals(true);
                            DiscretizeDialog.this.slider.setRange(dArray[0], dArray[dArray.length - 1]);
                        } else if (dataHolder.getIntervals(false) != null) {
                            double[] dArray = dataHolder.getIntervals(false);
                            DiscretizeDialog.this.slider.setRange(dArray[0], dArray[dArray.length - 1]);
                        } else {
                            DiscretizeDialog.this.slider.setRange(Double.parseDouble(dataHolder.getMinimum()), Double.parseDouble(dataHolder.getMaximum()));
                        }
                        int n5 = (Integer)DiscretizeDialog.this.numIntervals.getValue();
                        int n6 = DiscretizeDialog.this.slider.getNumberOfIntervals();
                        if (n5 > n6) {
                            for (n4 = n6; n4 < n5; ++n4) {
                                DiscretizeDialog.this.slider.addBreak();
                            }
                        } else {
                            for (n4 = n5; n4 < n6; ++n4) {
                                DiscretizeDialog.this.slider.removeBreak();
                            }
                        }
                        DiscretizeDialog.this.slider.revalidate();
                        DiscretizeDialog.this.slider.repaint();
                        try {
                            dataHolder.setIntervals(DiscretizeDialog.this.slider.getIntervals(), true);
                            ++n;
                        }
                        catch (Exception exception) {
                            new HuginGUIError(exception);
                        }
                    }
                }
                DiscretizeDialog.this.equiDist.setEnabled(true);
                DiscretizeDialog.this.equalDist.setEnabled(true);
            }
        });
        JLabel jLabel = new JLabel(HuginGUIConstants.get("str_number_of_intervals_"));
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        jPanel4.add(jLabel);
        jPanel4.add(this.numIntervals);
        jPanel3.add(jPanel4);
        this.liveUpdateCheck = new JCheckBox(HuginGUIConstants.get("str_live_update"));
        this.liveUpdateCheck.setSelected(this.liveUpdate);
        this.liveUpdateCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiscretizeDialog.this.liveUpdate = DiscretizeDialog.this.liveUpdateCheck.isSelected();
            }
        });
        jPanel3.add(this.liveUpdateCheck);
        jPanel.add((Component)jPanel3, "North");
        this.display = new DataAnalyser.DistributionDisplay();
        this.displayScroller = new JScrollPane(this.display);
        jPanel.add(this.displayScroller);
        JPanel jPanel5 = new JPanel(new FlowLayout());
        this.equiDist = new JButton(new ImageIcon(ClassLoader.getSystemResource("icons/equi_dist.png")));
        this.equiDist.setToolTipText(HuginGUIConstants.get("str_equi_distance"));
        this.equiDist.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DiscretizeDialog.this.holder != null) {
                    DiscretizeDialog.this.holder.makeEquiDistant();
                    DiscretizeDialog.this.slider.setIntervals(DiscretizeDialog.this.holder.getIntervals(true));
                } else {
                    int n = Integer.parseInt("" + DiscretizeDialog.this.numIntervals.getValue());
                    DiscretizeDialog.this.numIntervals.setValue(0);
                    DiscretizeDialog.this.numIntervals.setValue(new Integer(n));
                    for (DataAnalyserModel.DataHolder dataHolder : DiscretizeDialog.this.dataHolders) {
                        try {
                            dataHolder.makeEquiDistant();
                            DiscretizeDialog.this.slider.setIntervals(dataHolder.getIntervals(true));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                }
                DiscretizeDialog.this.slider.repaint();
            }
        });
        this.equalDist = new JButton(new ImageIcon(ClassLoader.getSystemResource("icons/equal_distributed.png")));
        this.equalDist.setToolTipText(HuginGUIConstants.get("str_equal_distribution"));
        this.equalDist.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DiscretizeDialog.this.holder != null) {
                    DiscretizeDialog.this.holder.makeEqualDistributed();
                    DiscretizeDialog.this.slider.setIntervals(DiscretizeDialog.this.holder.getIntervals(true));
                    DiscretizeDialog.this.numIntervals.setValue(DiscretizeDialog.this.holder.getIntervals(true).length - 1);
                } else {
                    int n = Integer.parseInt("" + DiscretizeDialog.this.numIntervals.getValue());
                    DiscretizeDialog.this.numIntervals.setValue(0);
                    DiscretizeDialog.this.numIntervals.setValue(new Integer(n));
                    for (DataAnalyserModel.DataHolder dataHolder : DiscretizeDialog.this.dataHolders) {
                        try {
                            dataHolder.makeEqualDistributed();
                            DiscretizeDialog.this.slider.setIntervals(dataHolder.getIntervals(true));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                }
                DiscretizeDialog.this.slider.repaint();
            }
        });
        jPanel5.add(this.equiDist);
        jPanel5.add(this.equalDist);
        jPanel.add((Component)jPanel5, "South");
        return jPanel;
    }

    public void setDataHolder(DataAnalyserModel.DataHolder dataHolder) throws Exception {
        if (!this.liveUpdateCheck.isVisible()) {
            this.liveUpdateCheck.setVisible(true);
        }
        if (!this.displayScroller.isVisible()) {
            this.displayScroller.setVisible(true);
        }
        this.holder = dataHolder;
        this.display.setDataHolder(dataHolder, true);
        String[] stringArray = dataHolder.getNames();
        this.maxValue.setText(stringArray[stringArray.length - 1]);
        this.minValue.setText(stringArray[0]);
        this.slider.setRange(Double.parseDouble(dataHolder.getMinimum()), Double.parseDouble(dataHolder.getMaximum()));
        if (dataHolder.getIntervals(true) != null) {
            double[] dArray = dataHolder.getIntervals(true);
            this.slider.setIntervals(dataHolder.getIntervals(true));
            this.numIntervals.setValue(new Integer(this.slider.getIntervals().length - 1));
        } else if (dataHolder.getIntervals(false) != null) {
            double[] dArray = dataHolder.getIntervals(false);
            this.slider.setIntervals(dataHolder.getIntervals(false));
            this.numIntervals.setValue(new Integer(this.slider.getIntervals().length - 1));
        } else {
            this.slider.reset(5);
            dataHolder.setIntervals(this.slider.getIntervals(), true);
            this.numIntervals.setValue(new Integer(5));
        }
        this.display.setIntervals(this.slider.getIntervals());
        this.setSliderVisible(true);
        ((JPanel)this.getContentPane()).revalidate();
        this.repaint();
    }

    public void setDataHolders(DataAnalyserModel.DataHolder[] dataHolderArray) throws Exception {
        this.setDataHolders = true;
        this.displayScroller.setVisible(false);
        this.liveUpdateCheck.setVisible(false);
        this.holder = null;
        this.dataHolders = dataHolderArray;
        this.display.reset();
        this.numIntervals.setValue(0);
        this.equiDist.setEnabled(false);
        this.equalDist.setEnabled(false);
        this.numIntervals.setValue(new Integer(5));
        this.setSliderVisible(false);
        ((JPanel)this.getContentPane()).revalidate();
        this.repaint();
        this.setDataHolders = false;
    }

    private void setSliderVisible(boolean bl) {
        this.slider.setVisible(bl);
        this.maxValue.setVisible(bl);
        this.minValue.setVisible(bl);
    }

    private class IntervalSlider
    extends JSlider {
        int activeIndex;
        LinkedList<DoubleModel> models;
        double min;
        double max;
        boolean inPaint;

        public IntervalSlider(int n) {
            int n2;
            super(1);
            this.inPaint = false;
            this.models = new LinkedList();
            this.setOpaque(false);
            this.setPaintTicks(true);
            this.setMajorTickSpacing(10);
            this.setInverted(true);
            for (n2 = 0; n2 < n - 1; ++n2) {
                this.addBreak();
            }
            n2 = 100 / n;
            int n3 = 0;
            for (DoubleModel doubleModel : this.models) {
                doubleModel.setValue(n3 += n2);
            }
        }

        public void reset(int n) {
            int n2;
            this.models.clear();
            for (n2 = 0; n2 < n - 1; ++n2) {
                this.addBreak();
            }
            n2 = 100 / n;
            int n3 = 0;
            for (DoubleModel doubleModel : this.models) {
                doubleModel.setValue(n3 += n2);
            }
        }

        public void setRange(double d, double d2) {
            this.min = d;
            this.max = d2;
        }

        public void setIntervals(double[] dArray) {
            this.models.clear();
            this.setRange(dArray[0], dArray[dArray.length - 1]);
            for (int i = 1; i < dArray.length - 1; ++i) {
                this.models.add(new DoubleModel(dArray[i], dArray[0], dArray[dArray.length - 1]));
            }
            if (this.models.size() == 0) {
                this.setModel(new DoubleModel(dArray[0], dArray[0], dArray[1]));
            } else {
                this.setModel(this.models.getLast());
            }
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        public double[] getIntervals() {
            double[] dArray = new double[this.models.size() + 2];
            dArray[0] = this.min;
            dArray[dArray.length - 1] = this.max;
            int n = 1;
            for (DoubleModel doubleModel : this.models) {
                dArray[n++] = doubleModel.getDValue();
            }
            Arrays.sort(dArray);
            return dArray;
        }

        public void addBreak() {
            try {
                DoubleModel doubleModel = new DoubleModel(this.getMin(), this.getMin(), this.getMax());
                this.models.add(doubleModel);
                this.setModel(doubleModel);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void removeBreak() {
            if (this.models.size() > 1) {
                this.models.removeLast();
                this.setModel(this.models.getLast());
            }
        }

        public int getNumberOfIntervals() {
            return this.models.size() + 1;
        }

        public void processMouseEvent(MouseEvent mouseEvent) {
            int n = this.getHeight() - (this.getInsets().top + this.getInsets().bottom);
            int n2 = mouseEvent.getY() - this.getInsets().top;
            int n3 = this.getModel().getMinimum();
            int n4 = this.getModel().getMaximum();
            int n5 = n3 + (n4 - n3) * n2 / n;
            DoubleModel doubleModel = this.models.getLast();
            ListIterator<DoubleModel> listIterator = this.models.listIterator(this.models.size() - 1);
            while (listIterator.hasPrevious()) {
                DoubleModel doubleModel2 = listIterator.previous();
                if (Math.abs(doubleModel.getValue() - n5) <= Math.abs(doubleModel2.getValue() - n5)) continue;
                doubleModel = doubleModel2;
            }
            if (doubleModel != this.models.getLast()) {
                this.models.remove(doubleModel);
                this.models.add(doubleModel);
                this.setModel(doubleModel);
            }
            super.processMouseEvent(mouseEvent);
        }

        public void repaint() {
            if (!this.inPaint) {
                super.repaint();
            }
        }

        public void paint(Graphics graphics) {
            graphics.setClip(0, 0, this.getWidth(), this.getHeight());
            this.inPaint = true;
            this.setOpaque(true);
            super.paint(graphics);
            int n = 0;
            this.setPaintTrack(false);
            this.setOpaque(false);
            for (DoubleModel doubleModel : this.models) {
                this.setModel(doubleModel);
                ++n;
                super.paint(graphics);
            }
            this.setPaintTrack(true);
            this.inPaint = false;
        }

        private class DoubleModel
        extends DefaultBoundedRangeModel {
            double dValue;
            double dMin;
            double dMax;

            public DoubleModel(double d, double d2, double d3) {
                super((int)Math.round(100.0 * (d - d2) / (d3 - d2)), 0, 0, 100);
                this.dValue = d;
                this.dMin = d2;
                this.dMax = d3;
            }

            public void setValue(int n) {
                this.dValue = this.dMin + (this.dMax - this.dMin) * (double)n / 100.0;
                super.setValue(n);
            }

            public double getDValue() {
                return this.dValue;
            }
        }
    }
}

