/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.AbsExpression;
import COM.hugin.HAPI.AddExpression;
import COM.hugin.HAPI.AndExpression;
import COM.hugin.HAPI.BetaDistribution;
import COM.hugin.HAPI.BinomialDistribution;
import COM.hugin.HAPI.BooleanDCNode;
import COM.hugin.HAPI.BooleanExpression;
import COM.hugin.HAPI.CeilExpression;
import COM.hugin.HAPI.CompositeExpression;
import COM.hugin.HAPI.CosExpression;
import COM.hugin.HAPI.CoshExpression;
import COM.hugin.HAPI.DistributionDistribution;
import COM.hugin.HAPI.DivideExpression;
import COM.hugin.HAPI.EqualsExpression;
import COM.hugin.HAPI.ExceptionComputationFailed;
import COM.hugin.HAPI.ExceptionDivisionByZero;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExceptionInappropriateArguments;
import COM.hugin.HAPI.ExceptionInsufficientStateRange;
import COM.hugin.HAPI.ExceptionInvalidExpression;
import COM.hugin.HAPI.ExceptionInvalidStateValues;
import COM.hugin.HAPI.ExceptionSyntax;
import COM.hugin.HAPI.ExceptionUsage;
import COM.hugin.HAPI.ExpExpression;
import COM.hugin.HAPI.ExponentialDistribution;
import COM.hugin.HAPI.Expression;
import COM.hugin.HAPI.ExpressionList;
import COM.hugin.HAPI.FloorExpression;
import COM.hugin.HAPI.GammaDistribution;
import COM.hugin.HAPI.GeometricDistribution;
import COM.hugin.HAPI.GreaterThanExpression;
import COM.hugin.HAPI.GreaterThanOrEqualsExpression;
import COM.hugin.HAPI.IfExpression;
import COM.hugin.HAPI.InstanceNode;
import COM.hugin.HAPI.LessThanExpression;
import COM.hugin.HAPI.LessThanOrEqualsExpression;
import COM.hugin.HAPI.Log10Expression;
import COM.hugin.HAPI.Log2Expression;
import COM.hugin.HAPI.LogExpression;
import COM.hugin.HAPI.LogNormalDistribution;
import COM.hugin.HAPI.MaxExpression;
import COM.hugin.HAPI.MinExpression;
import COM.hugin.HAPI.ModExpression;
import COM.hugin.HAPI.Model;
import COM.hugin.HAPI.MultiplyExpression;
import COM.hugin.HAPI.NegateExpression;
import COM.hugin.HAPI.NegativeBinomialDistribution;
import COM.hugin.HAPI.NodeExpression;
import COM.hugin.HAPI.NoisyOrDistribution;
import COM.hugin.HAPI.NormalDistribution;
import COM.hugin.HAPI.NotEqualsExpression;
import COM.hugin.HAPI.NotExpression;
import COM.hugin.HAPI.OrExpression;
import COM.hugin.HAPI.PERTDistribution;
import COM.hugin.HAPI.ParseListener;
import COM.hugin.HAPI.PoissonDistribution;
import COM.hugin.HAPI.PowerExpression;
import COM.hugin.HAPI.SinExpression;
import COM.hugin.HAPI.SinhExpression;
import COM.hugin.HAPI.SqrtExpression;
import COM.hugin.HAPI.SubtractExpression;
import COM.hugin.HAPI.TanExpression;
import COM.hugin.HAPI.TanhExpression;
import COM.hugin.HAPI.TriangularDistribution;
import COM.hugin.HAPI.UniformDistribution;
import COM.hugin.HAPI.WeibullDistribution;
import COM.hugin.HGUI.DiscreteChanceNode;
import COM.hugin.HGUI.DiscreteNode;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIFrame;
import COM.hugin.HGUI.NetworkPanel;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.PastingTextField;
import COM.hugin.HGUI.TitledPanel;
import COM.hugin.HGUI.UtilityNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.AbstractSequentialList;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class ExpressionBuilder
extends JDialog {
    private HuginGUIFrame guiFrame;
    private Node node;
    private Expression expression;
    private Container cont;
    private JTabbedPane pane;
    private SelectFunctionPane selectionPane;
    private JButton ok;
    private JButton cancel;
    private Expression result;
    private Function function;
    private boolean creatingFunction = false;
    private boolean isModal = true;
    int offset = 0;
    int offsetBy = 25;
    ExpressionParser expressionParser;

    public ExpressionBuilder(HuginGUIFrame huginGUIFrame, Node node) {
        super(huginGUIFrame, "Expression Builder", true);
        this.guiFrame = huginGUIFrame;
        this.node = node;
        try {
            Model model = node.getAPINode().getModel();
            if (model != null && model.getSize() > 0) {
                this.expression = model.getExpression(0);
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        this.expressionParser = new ExpressionParser();
    }

    public ExpressionBuilder(HuginGUIFrame huginGUIFrame, Node node, Expression expression) {
        super(huginGUIFrame, "Expression Builder", true);
        this.guiFrame = huginGUIFrame;
        this.node = node;
        this.expression = expression;
        this.setTitle("Expression Builder");
    }

    private ExpressionBuilder(HuginGUIFrame huginGUIFrame, Node node, Expression expression, int n) {
        super(huginGUIFrame, "Expression Builder", true);
        this.guiFrame = huginGUIFrame;
        this.node = node;
        this.expression = expression;
        this.offset = n;
        this.setTitle("Expression Builder");
    }

    public Expression buildExpression() {
        if (this.node instanceof DiscreteNode) {
            return this.buildExpression(((DiscreteNode)((Object)this.node)).getSubtype());
        }
        if (this.node instanceof UtilityNode) {
            return this.buildExpression(5);
        }
        return null;
    }

    private Expression buildExpression(int n) {
        this.pane = new JTabbedPane();
        this.ok = new JButton(HuginGUIConstants.get("OK_button"));
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!ExpressionBuilder.this.creatingFunction) {
                    ExpressionBuilder.this.createFunction(ExpressionBuilder.this.selectionPane.getSelectedFunction());
                } else {
                    ExpressionBuilder.this.result = ExpressionBuilder.this.function.getExpression();
                    if (ExpressionBuilder.this.result == null) {
                        ExpressionBuilder.this.isModal = false;
                        new HuginGUIError(ExpressionBuilder.this.function.getExplanation());
                        ExpressionBuilder.this.isModal = true;
                    } else {
                        ExpressionBuilder.this.dispose();
                    }
                }
            }
        });
        this.ok.setEnabled(false);
        this.cancel = new JButton(HuginGUIConstants.get("cancel_button"));
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExpressionBuilder.this.dispose();
            }
        });
        JPanel jPanel = new JPanel(new GridLayout(1, 3));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel.add(this.ok);
        jPanel.add(this.cancel);
        jPanel2.add((Component)jPanel, "East");
        this.selectionPane = new SelectFunctionPane();
        this.selectionPane.setMode(n);
        this.pane.add(this.selectionPane);
        this.cont = this.getContentPane();
        this.cont.setLayout(new BorderLayout());
        this.cont.add((Component)this.pane, "Center");
        this.cont.add((Component)jPanel2, "South");
        this.pack();
        this.getRootPane().setDefaultButton(this.ok);
        if (this.offsetBy * this.offset > this.guiFrame.getWidth() - 300 || this.offsetBy * this.offset > this.guiFrame.getHeight() - 300) {
            this.offset = 0;
        }
        this.setLocation(this.guiFrame.getX() + 100 + this.offsetBy * this.offset, this.guiFrame.getY() + 100 + this.offsetBy * this.offset);
        this.setVisible(true);
        return this.result;
    }

    public void createFunction(Function function) {
        this.creatingFunction = true;
        this.function = function;
        this.pane.removeAll();
        JPanel jPanel = new JPanel(new BorderLayout()){

            public Insets getInsets() {
                return new Insets(10, 10, 10, 10);
            }
        };
        jPanel.add(function.getFunctionPanel());
        function.fromExpression(this.expression);
        this.pane.add("Specify Arguments", jPanel);
        this.setTitle(function.toString());
        this.pack();
    }

    public boolean isModal() {
        return this.isModal;
    }

    private class ExpressionParser
    implements ParseListener {
        private ExpressionParser() {
        }

        public void parseError(int n, String string) {
        }
    }

    private class TempNode {
        COM.hugin.HAPI.Node apiNode;
        Node node;
        String name;
        String label;

        public TempNode(Node node) {
            this.node = node;
            try {
                this.name = node.getAPINode().getName();
                if (node.isOutputClone()) {
                    InstanceNode instanceNode = (InstanceNode)node.getAPINode().getInstance();
                    boolean bl = false;
                    String string = instanceNode.getLabel();
                    if (string == null || string.length() == 0) {
                        this.label = instanceNode.getName() + ".";
                    } else {
                        this.label = string + ".";
                        bl = true;
                    }
                    String string2 = node.getLabel();
                    if (string2 == null || string2.length() == 0) {
                        this.label = this.label + node.getName();
                    } else {
                        this.label = this.label + string2;
                        bl = true;
                    }
                    if (!bl) {
                        this.label = "";
                    }
                } else {
                    this.label = node.getAPINode().getLabel();
                }
                this.label = this.label.replace('\n', ' ');
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            String string = this.label.length() > 0 ? this.label + " (" + this.name + ")" : this.name;
            return string;
        }

        public boolean equals(Object object) {
            if (!(object instanceof TempNode)) {
                return false;
            }
            return ((TempNode)object).name.equals(this.name);
        }
    }

    private class DistributionFunction
    extends Function {
        Vector<PastingTextField> stateFunctions;

        public DistributionFunction() {
            this.expressionType = 73;
            this.name = "Distribution";
            this.termType = -1;
            this.stateFunctions = new Vector();
            this.createFunctionPanel();
        }

        public Expression getExpression() {
            DistributionDistribution distributionDistribution = null;
            ExpressionList expressionList = new ExpressionList();
            try {
                for (int i = 0; i < this.stateFunctions.size(); ++i) {
                    expressionList.add(Expression.stringToExpression(this.stateFunctions.get(i).getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser));
                }
                distributionDistribution = new DistributionDistribution(expressionList);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
            return distributionDistribution;
        }

        public void createFunctionPanel() {
            this.result = new JPanel(new BorderLayout(10, 10));
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel(new BorderLayout());
            JLabel jLabel = new JLabel(new ImageIcon(ClassLoader.getSystemResource("icons/functionArguments.gif")));
            jPanel2.add((Component)jLabel, "North");
            TitledPanel titledPanel = new TitledPanel("Arguments(" + this.name + ")");
            titledPanel.setLayout(new BorderLayout());
            JPanel jPanel3 = new JPanel();
            int n = 0;
            try {
                n = ExpressionBuilder.this.node instanceof DiscreteChanceNode ? ((COM.hugin.HAPI.DiscreteChanceNode)ExpressionBuilder.this.node.getAPINode()).getNumberOfStates() : 1;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
            JPanel jPanel4 = new JPanel(new GridLayout(n, 1));
            JPanel jPanel5 = new JPanel(new GridLayout(n, 1));
            JPanel jPanel6 = new JPanel(new BorderLayout());
            JPanel jPanel7 = new JPanel(new BorderLayout());
            JScrollPane jScrollPane = new JScrollPane(jPanel7);
            jScrollPane.setPreferredSize(new Dimension(270, 200));
            String string = HuginGUIConstants.get("str_error");
            for (int i = 0; i < n; ++i) {
                try {
                    string = ExpressionBuilder.this.node instanceof DiscreteChanceNode ? ((COM.hugin.HAPI.DiscreteChanceNode)ExpressionBuilder.this.node.getAPINode()).getStateLabel(i) : HuginGUIConstants.get("str_utility");
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
                jPanel4.add(new JLabel(string));
                JPanel jPanel8 = new JPanel(new BorderLayout());
                PastingTextField pastingTextField = new PastingTextField();
                JButton jButton = new JButton("Select...");
                jButton.addActionListener(new DistributionActionListener(i));
                jPanel8.add(pastingTextField);
                jPanel8.add((Component)jButton, "East");
                this.stateFunctions.add(pastingTextField);
                jPanel5.add(jPanel8);
            }
            jPanel6.add(jPanel5);
            jPanel6.add((Component)jPanel4, "West");
            jPanel7.add((Component)jPanel6, "North");
            titledPanel.add((Component)jScrollPane, "North");
            jPanel.add((Component)jPanel2, "West");
            jPanel.add((Component)titledPanel, "Center");
            this.result.add((Component)jPanel, "Center");
        }

        public void fromExpression(Expression expression) {
            if (expression == null || !(expression instanceof DistributionDistribution)) {
                return;
            }
            try {
                ExpressionList expressionList = ((DistributionDistribution)expression).getOperands();
                int n = 0;
                ListIterator listIterator = expressionList.listIterator();
                while (listIterator.hasNext() && n < this.stateFunctions.size()) {
                    Expression expression2 = (Expression)listIterator.next();
                    this.stateFunctions.get(n++).setText(expression2.expressionToString());
                }
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }

        private class DistributionActionListener
        implements ActionListener {
            int index;

            public DistributionActionListener(int n) {
                this.index = n;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Expression expression = null;
                String string = DistributionFunction.this.stateFunctions.get(this.index).getText();
                if (string.length() > 0) {
                    try {
                        expression = Expression.stringToExpression(string, ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ExpressionBuilder expressionBuilder = new ExpressionBuilder(ExpressionBuilder.this.guiFrame, ExpressionBuilder.this.node, expression, ExpressionBuilder.this.offset++);
                Expression expression2 = expressionBuilder.buildExpression(17);
                try {
                    if (expression2 != null) {
                        DistributionFunction.this.stateFunctions.get(this.index).setText(expression2.expressionToString());
                    }
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
        }
    }

    private class NoisyOrFunction
    extends Function {
        JTable inhibitorProbs;

        public NoisyOrFunction() {
            this.expressionType = 74;
            this.name = "Noisy Or";
            this.termType = -1;
            this.createFunctionPanel();
        }

        public Expression getExpression() {
            try {
                InhibitorModel inhibitorModel = (InhibitorModel)this.inhibitorProbs.getModel();
                ExpressionList expressionList = new ExpressionList();
                for (int i = 0; i < inhibitorModel.getRowCount(); ++i) {
                    expressionList.add(new NodeExpression(((Node)inhibitorModel.getValueAt(i, 0)).getAPINode()));
                    expressionList.add(Expression.stringToExpression(inhibitorModel.getValueAt(i, 1).toString(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser));
                }
                expressionList.add(new BooleanExpression(true));
                expressionList.add(Expression.stringToExpression(this.text2.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser));
                return new NoisyOrDistribution(expressionList);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }

        public void createFunctionPanel() {
            this.result = new JPanel(new BorderLayout(10, 10));
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel(new BorderLayout());
            JLabel jLabel = new JLabel(new ImageIcon(ClassLoader.getSystemResource("icons/functionArguments.gif")));
            jPanel2.add((Component)jLabel, "North");
            TitledPanel titledPanel = new TitledPanel("Arguments(" + this.name + ")");
            titledPanel.setLayout(new BorderLayout());
            JLabel jLabel2 = new JLabel("Inhibitor Probabilities");
            this.text1 = new PastingTextField(10);
            this.inhibitorProbs = new JTable(new InhibitorModel(ExpressionBuilder.this.node)){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    super.valueChanged(listSelectionEvent);
                    int n = this.getSelectedRow();
                    if (n > -1) {
                        NoisyOrFunction.this.text1.setText(this.getModel().getValueAt(n, 1).toString());
                    }
                }
            };
            this.inhibitorProbs.getColumnModel().getColumn(1).setPreferredWidth(30);
            this.inhibitorProbs.setShowGrid(false);
            this.inhibitorProbs.setSelectionMode(0);
            this.inhibitorProbs.setBackground(Color.white);
            this.inhibitorProbs.setTableHeader(null);
            JScrollPane jScrollPane = new JScrollPane(this.inhibitorProbs);
            jScrollPane.setPreferredSize(new Dimension(200, 100));
            jScrollPane.setBorder(BorderFactory.createEtchedBorder(1));
            jScrollPane.getViewport().setBackground(Color.white);
            int n = 0;
            LinkedList<Node> linkedList = ExpressionBuilder.this.node.getParents();
            Object object = linkedList.listIterator();
            while (object.hasNext() && n < 2) {
                if (!(((Node)object.next()).getAPINode() instanceof BooleanDCNode)) continue;
                ++n;
            }
            if (n > 0) {
                this.inhibitorProbs.setRowSelectionInterval(0, 0);
            }
            object = new JLabel("Current Inhibitor");
            ((JComponent)object).setEnabled(n > 0);
            JLabel jLabel3 = new JLabel("Default Inhibitor");
            JPanel jPanel3 = new JPanel(new BorderLayout());
            JPanel jPanel4 = new JPanel(new GridLayout(2, 1));
            jPanel4.add((Component)object);
            jPanel4.add(jLabel3);
            JPanel jPanel5 = new JPanel(new GridLayout(2, 1));
            this.text1.setEnabled(n > 0);
            this.text1.setText("0");
            this.text1.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent caretEvent) {
                    try {
                        String string = NoisyOrFunction.this.text1.getText();
                        if (string.length() > 0) {
                            NoisyOrFunction.this.inhibitorProbs.setValueAt(string, NoisyOrFunction.this.inhibitorProbs.getSelectedRow(), 1);
                            NoisyOrFunction.this.inhibitorProbs.repaint();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            this.text2 = new PastingTextField(10);
            this.text2.setText("1");
            jPanel5.add(this.text1);
            jPanel5.add(this.text2);
            JPanel jPanel6 = new JPanel(new GridLayout(2, 1));
            JPanel jPanel7 = new JPanel(new GridLayout(1, 2));
            this.select1 = new JButton("Select...");
            this.select1.setEnabled(n > 0);
            this.select1.addActionListener(new Function.Select1Listener(16));
            JButton jButton = new JButton("Next");
            jButton.setEnabled(n > 1);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = NoisyOrFunction.this.inhibitorProbs.getSelectedRow() + 1;
                    if (n >= NoisyOrFunction.this.inhibitorProbs.getModel().getRowCount()) {
                        n = 0;
                    }
                    NoisyOrFunction.this.inhibitorProbs.setRowSelectionInterval(n, n);
                }
            });
            jPanel7.add(this.select1);
            jPanel7.add(jButton);
            JPanel jPanel8 = new JPanel(new BorderLayout());
            this.select2 = new JButton("Select...");
            this.select2.addActionListener(new Function.Select2Listener(16));
            jPanel8.add((Component)this.select2, "West");
            jPanel6.add(jPanel7);
            jPanel6.add(jPanel8);
            jPanel3.add((Component)jPanel4, "West");
            jPanel3.add((Component)jPanel5, "Center");
            jPanel3.add((Component)jPanel6, "East");
            titledPanel.add((Component)jLabel2, "North");
            titledPanel.add((Component)jScrollPane, "Center");
            titledPanel.add((Component)jPanel3, "South");
            jPanel.add((Component)jPanel2, "West");
            jPanel.add((Component)titledPanel, "Center");
            this.result.add((Component)jPanel, "Center");
        }

        public void fromExpression(Expression expression) {
            if (expression == null) {
                return;
            }
            if (!(expression instanceof NoisyOrDistribution)) {
                return;
            }
            try {
                ExpressionList expressionList = ((NoisyOrDistribution)expression).getOperands();
                int n = 0;
                InhibitorModel inhibitorModel = (InhibitorModel)this.inhibitorProbs.getModel();
                Object object = expressionList.listIterator();
                while (object.hasNext() && n < inhibitorModel.getRowCount()) {
                    Expression expression2 = (Expression)object.next();
                    if (!(expression2 instanceof NodeExpression)) continue;
                    inhibitorModel.setValueAt(ExpressionBuilder.this.guiFrame.getSelectedProjectFrame().getNetworkPanel().getNode(((NodeExpression)expression2).getNode()), n, 0);
                    if (object.hasNext()) {
                        inhibitorModel.setValueAt(((Expression)object.next()).expressionToString(), n, 1);
                    }
                    ++n;
                }
                if (expressionList.size() > 0) {
                    object = (Expression)expressionList.get(expressionList.size() - 1);
                    this.text2.setText(((Expression)object).expressionToString());
                }
                int n2 = inhibitorModel.getRowCount() - 1;
                this.inhibitorProbs.setRowSelectionInterval(n2, n2);
                this.text1.setText(inhibitorModel.getValueAt(n2, 1).toString());
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }

        private class InhibitorModel
        extends DefaultTableModel {
            Vector<Vector<Object>> rows = new Vector();

            public InhibitorModel(Node node) {
                LinkedList<Node> linkedList = node.getParents();
                for (Node node2 : linkedList) {
                    Vector<Comparable<Node>> vector = new Vector<Comparable<Node>>();
                    if (!(node2.getAPINode() instanceof BooleanDCNode)) continue;
                    vector.add(node2);
                    vector.add(new Double(0.0));
                    this.rows.add(vector);
                }
            }

            public int getRowCount() {
                if (this.rows == null) {
                    return 0;
                }
                return this.rows.size();
            }

            public int getColumnCount() {
                return 2;
            }

            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            public Object getValueAt(int n, int n2) {
                if (this.rows == null) {
                    return null;
                }
                return this.rows.get(n).get(n2);
            }

            public void setValueAt(Object object, int n, int n2) {
                this.rows.get(n).set(n2, object);
            }
        }
    }

    private class PERTFunction
    extends Function {
        public PERTFunction() {
            this.expressionType = 68;
            this.name = "PERT";
            this.termType = 17;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(15));
            this.select2.addActionListener(new Function.Select2Listener(15));
            this.select3.addActionListener(new Function.Select3Listener(15));
            this.select4.addActionListener(new Function.Select4Listener(15));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                Expression expression3 = Expression.stringToExpression(this.text3.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                Expression expression4 = null;
                if (this.text4.getText().length() > 0) {
                    expression4 = Expression.stringToExpression(this.text4.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                }
                if (expression4 != null) {
                    return new PERTDistribution(expression, expression2, expression3, expression4);
                }
                return new PERTDistribution(expression, expression2, expression3);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class TriangularFunction
    extends Function {
        public TriangularFunction() {
            this.expressionType = 67;
            this.name = "Triangular";
            this.termType = 16;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(15));
            this.select2.addActionListener(new Function.Select2Listener(15));
            this.select3.addActionListener(new Function.Select3Listener(15));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                Expression expression3 = Expression.stringToExpression(this.text3.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                return new TriangularDistribution(expression, expression2, expression3);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class UniformFunction
    extends Function {
        public UniformFunction() {
            this.expressionType = 66;
            this.name = "Uniform";
            this.termType = 15;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(15));
            this.select2.addActionListener(new Function.Select2Listener(15));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                return new UniformDistribution(expression, expression2);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class WeibullFunction
    extends Function {
        public WeibullFunction() {
            this.expressionType = 65;
            this.name = "Weibull";
            this.termType = 13;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(15));
            this.select2.addActionListener(new Function.Select2Listener(15));
            this.select3.addActionListener(new Function.Select3Listener(15));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                Expression expression3 = null;
                if (this.text3.getText().length() > 0) {
                    expression3 = Expression.stringToExpression(this.text3.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                }
                if (expression3 != null) {
                    return new WeibullDistribution(expression, expression2, expression3);
                }
                return new WeibullDistribution(expression, expression2);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }

        protected boolean threeParameterSupport(Node node) {
            try {
                Expression.stringToExpression("Weibull(1,2,3)", node.getAPINode().getModel(), null);
            }
            catch (ExceptionHugin exceptionHugin) {
                return false;
            }
            return true;
        }
    }

    private class ExponentialFunction
    extends Function {
        public ExponentialFunction() {
            this.expressionType = 64;
            this.name = "Exponential";
            this.termType = 14;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(15));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                Expression expression2 = null;
                if (this.text2.getText().length() > 0) {
                    expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                }
                if (expression2 != null) {
                    return new ExponentialDistribution(expression, expression2);
                }
                return new ExponentialDistribution(expression);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class GammaFunction
    extends Function {
        public GammaFunction() {
            this.expressionType = 63;
            this.name = "Gamma";
            this.termType = 20;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(15));
            this.select2.addActionListener(new Function.Select2Listener(15));
            this.select3.addActionListener(new Function.Select3Listener(15));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                Expression expression3 = null;
                if (this.text3.getText().length() > 0) {
                    expression3 = Expression.stringToExpression(this.text3.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                }
                if (expression3 != null) {
                    return new GammaDistribution(expression, expression2, expression3);
                }
                return new GammaDistribution(expression, expression2);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class BetaFunction
    extends Function {
        public BetaFunction() {
            this.expressionType = 62;
            this.name = "Beta";
            this.termType = 12;
            this.optionalExists = true;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(15));
            this.select2.addActionListener(new Function.Select2Listener(15));
            this.select3.addActionListener(new Function.Select3Listener(15));
            this.select4.addActionListener(new Function.Select4Listener(15));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                Expression expression3 = null;
                Expression expression4 = null;
                if (this.text3.getText().length() > 0) {
                    expression3 = Expression.stringToExpression(this.text3.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                }
                if (this.text4.getText().length() > 0) {
                    expression4 = Expression.stringToExpression(this.text4.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                }
                if (expression3 != null && expression4 != null) {
                    return new BetaDistribution(expression, expression2, expression3, expression4);
                }
                return new BetaDistribution(expression, expression2);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class LogNormalFunction
    extends Function {
        public LogNormalFunction() {
            this.expressionType = 61;
            this.name = "LogNormal";
            this.termType = 21;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(15));
            this.select2.addActionListener(new Function.Select2Listener(15));
            this.select3.addActionListener(new Function.Select3Listener(15));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                Expression expression3 = null;
                if (this.text3.getText().length() > 0) {
                    expression3 = Expression.stringToExpression(this.text3.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                }
                if (expression3 != null) {
                    return new LogNormalDistribution(expression, expression2, expression3);
                }
                return new LogNormalDistribution(expression, expression2);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class NormalFunction
    extends Function {
        public NormalFunction() {
            this.expressionType = 60;
            this.name = "Normal";
            this.termType = 11;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(15));
            this.select2.addActionListener(new Function.Select2Listener(15));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                return new NormalDistribution(expression, expression2);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class PoissonFunction
    extends Function {
        public PoissonFunction() {
            this.expressionType = 70;
            this.name = "Poisson";
            this.termType = 10;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(14));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                return new PoissonDistribution(expression);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class NegativeBinomialFunction
    extends Function {
        public NegativeBinomialFunction() {
            this.expressionType = 71;
            this.name = "NegativeBinomial";
            this.termType = 18;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(14));
            this.select2.addActionListener(new Function.Select2Listener(14));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                return new NegativeBinomialDistribution(expression, expression2);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class GeometricFunction
    extends Function {
        public GeometricFunction() {
            this.expressionType = 72;
            this.name = "Geometric";
            this.termType = 19;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(14));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                return new GeometricDistribution(expression);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class BinomialFunction
    extends Function {
        public BinomialFunction() {
            this.expressionType = 69;
            this.name = "Binomial";
            this.termType = 9;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(14));
            this.select2.addActionListener(new Function.Select2Listener(14));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                return new BinomialDistribution(expression, expression2);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class IfFunction
    extends Function {
        public IfFunction() {
            this.expressionType = 93;
            this.name = "If-then-else";
            this.termType = 4;
            this.optionalExists = false;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(10));
            this.select2.addActionListener(new Function.Select2Listener(13));
            this.select3.addActionListener(new Function.Select3Listener(13));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                Expression expression3 = Expression.stringToExpression(this.text3.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                return new IfExpression(expression, expression2, expression3);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }

        public void fromExpression(Expression expression) {
            if (expression == null) {
                return;
            }
            try {
                if (expression.isCompositeExpression()) {
                    ExpressionList expressionList = ((CompositeExpression)expression).getOperands();
                    ListIterator listIterator = expressionList.listIterator();
                    this.text1.setText(((Expression)listIterator.next()).expressionToString());
                    if (!listIterator.hasNext()) {
                        return;
                    }
                    String string = ((Expression)listIterator.next()).expressionToString();
                    this.text2.setText(string);
                    if (!listIterator.hasNext()) {
                        return;
                    }
                    String string2 = ((Expression)listIterator.next()).expressionToString();
                    this.text3.setText(string2);
                }
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }
    }

    private class TanFunction
    extends Function {
        public TanFunction() {
            this.expressionType = 84;
            this.name = "tan";
            this.termType = 8;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(12));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                return new TanExpression(expression);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class CosFunction
    extends Function {
        public CosFunction() {
            this.expressionType = 83;
            this.name = "cos";
            this.termType = 8;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(12));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                return new CosExpression(expression);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class SinFunction
    extends Function {
        public SinFunction() {
            this.expressionType = 82;
            this.name = "sin";
            this.termType = 8;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(12));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                return new SinExpression(expression);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class TanhFunction
    extends Function {
        public TanhFunction() {
            this.expressionType = 87;
            this.name = "tanh";
            this.termType = 8;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(12));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                return new TanhExpression(expression);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class CoshFunction
    extends Function {
        public CoshFunction() {
            this.expressionType = 86;
            this.name = "cosh";
            this.termType = 8;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(12));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                return new CoshExpression(expression);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class SinhFunction
    extends Function {
        public SinhFunction() {
            this.expressionType = 85;
            this.name = "sinh";
            this.termType = 8;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(12));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                return new SinhExpression(expression);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class Log10Function
    extends Function {
        public Log10Function() {
            this.expressionType = 80;
            this.name = "log10";
            this.termType = 8;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(12));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                return new Log10Expression(expression);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class Log2Function
    extends Function {
        public Log2Function() {
            this.expressionType = 79;
            this.name = "log2";
            this.termType = 8;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(12));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                return new Log2Expression(expression);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class SqrtFunction
    extends Function {
        public SqrtFunction() {
            this.expressionType = 88;
            this.name = "sqrt";
            this.termType = 8;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(12));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                return new SqrtExpression(expression);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class ExpFunction
    extends Function {
        public ExpFunction() {
            this.expressionType = 81;
            this.name = "exp";
            this.termType = 8;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(12));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                return new ExpExpression(expression);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class LogFunction
    extends Function {
        public LogFunction() {
            this.expressionType = 78;
            this.name = "log";
            this.termType = 8;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(12));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                return new LogExpression(expression);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class CeilingFunction
    extends Function {
        public CeilingFunction() {
            this.expressionType = 91;
            this.name = "ceiling";
            this.termType = 8;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(12));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                return new CeilExpression(expression);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class FloorFunction
    extends Function {
        public FloorFunction() {
            this.expressionType = 90;
            this.name = "floor";
            this.termType = 8;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(12));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                return new FloorExpression(expression);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class ModFunction
    extends Function {
        public ModFunction() {
            this.expressionType = 92;
            this.name = "mod";
            this.termType = 1;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(12));
            this.select2.addActionListener(new Function.Select2Listener(12));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                return new ModExpression(expression, expression2);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class AbsFunction
    extends Function {
        public AbsFunction() {
            this.expressionType = 89;
            this.name = "abs";
            this.termType = 8;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(12));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                return new AbsExpression(expression);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class NegateFunction
    extends Function {
        public NegateFunction() {
            this.expressionType = 102;
            this.name = "negate";
            this.termType = 8;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(12));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                return new NegateExpression(expression);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class MaxFunction
    extends Function {
        public MaxFunction() {
            this.expressionType = 77;
            this.name = "max";
            this.termType = 6;
            this.optionalExists = true;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(12));
            this.select2.addActionListener(new Function.Select2Listener(12));
            this.select3.addActionListener(new Function.Select3Listener(12));
            this.select4.addActionListener(new Function.Select4Listener(12));
        }

        public Expression getExpression() {
            try {
                ExpressionList expressionList = new ExpressionList();
                expressionList.add(Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser));
                expressionList.add(Expression.stringToExpression(this.text2.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser));
                if (this.text3.getText().length() > 0) {
                    expressionList.add(Expression.stringToExpression(this.text3.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser));
                }
                if (this.text4.getText().length() > 0) {
                    expressionList.add(Expression.stringToExpression(this.text4.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser));
                }
                return new MaxExpression(expressionList);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class MinFunction
    extends Function {
        public MinFunction() {
            this.expressionType = 76;
            this.name = "min";
            this.termType = 6;
            this.optionalExists = true;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(12));
            this.select2.addActionListener(new Function.Select2Listener(12));
            this.select3.addActionListener(new Function.Select3Listener(12));
            this.select4.addActionListener(new Function.Select4Listener(12));
        }

        public Expression getExpression() {
            try {
                ExpressionList expressionList = new ExpressionList();
                expressionList.add(Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser));
                expressionList.add(Expression.stringToExpression(this.text2.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser));
                if (this.text3.getText().length() > 0) {
                    expressionList.add(Expression.stringToExpression(this.text3.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser));
                }
                if (this.text4.getText().length() > 0) {
                    expressionList.add(Expression.stringToExpression(this.text4.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser));
                }
                return new MinExpression(expressionList);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class PowerFunction
    extends Function {
        public PowerFunction() {
            this.expressionType = 101;
            this.name = "power";
            this.termType = 5;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(12));
            this.select2.addActionListener(new Function.Select2Listener(12));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                return new PowerExpression(expression, expression2);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class DivideFunction
    extends Function {
        public DivideFunction() {
            this.expressionType = 100;
            this.name = "/";
            this.termType = 1;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(12));
            this.select2.addActionListener(new Function.Select2Listener(12));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                return new DivideExpression(expression, expression2);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class MultiplyFunction
    extends Function {
        public MultiplyFunction() {
            this.expressionType = 99;
            this.name = "*";
            this.termType = 1;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(12));
            this.select2.addActionListener(new Function.Select2Listener(12));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                return new MultiplyExpression(expression, expression2);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class SubtractFunction
    extends Function {
        public SubtractFunction() {
            this.expressionType = 98;
            this.name = "-";
            this.termType = 1;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(12));
            this.select2.addActionListener(new Function.Select2Listener(12));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                return new SubtractExpression(expression, expression2);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class AddFunction
    extends Function {
        public AddFunction() {
            this.expressionType = 97;
            this.name = "+";
            this.termType = 1;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(12));
            this.select2.addActionListener(new Function.Select2Listener(12));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                return new AddExpression(expression, expression2);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class GreaterEqualFunction
    extends Function {
        public GreaterEqualFunction() {
            this.expressionType = 108;
            this.name = ">=";
            this.termType = 1;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(11));
            this.select2.addActionListener(new Function.Select2Listener(11));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                return new GreaterThanOrEqualsExpression(expression, expression2);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class LessEqualFunction
    extends Function {
        public LessEqualFunction() {
            this.expressionType = 107;
            this.name = "<=";
            this.termType = 1;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(11));
            this.select2.addActionListener(new Function.Select2Listener(11));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                return new LessThanOrEqualsExpression(expression, expression2);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class NotEqualFunction
    extends Function {
        public NotEqualFunction() {
            this.expressionType = 106;
            this.name = "!=";
            this.termType = 1;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(11));
            this.select2.addActionListener(new Function.Select2Listener(11));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                return new NotEqualsExpression(expression, expression2);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class GreaterFunction
    extends Function {
        public GreaterFunction() {
            this.expressionType = 105;
            this.name = ">";
            this.termType = 1;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(11));
            this.select2.addActionListener(new Function.Select2Listener(11));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                return new GreaterThanExpression(expression, expression2);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class LessFunction
    extends Function {
        public LessFunction() {
            this.expressionType = 104;
            this.name = "<";
            this.termType = 1;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(11));
            this.select2.addActionListener(new Function.Select2Listener(11));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                return new LessThanExpression(expression, expression2);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class EqualFunction
    extends Function {
        public EqualFunction() {
            this.expressionType = 103;
            this.name = "==";
            this.termType = 1;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(11));
            this.select2.addActionListener(new Function.Select2Listener(11));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                Expression expression2 = Expression.stringToExpression(this.text2.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                return new EqualsExpression(expression, expression2);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class NotFunction
    extends Function {
        public NotFunction() {
            this.expressionType = 96;
            this.name = "not";
            this.termType = 0;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(10));
            this.select2.addActionListener(new Function.Select2Listener(10));
        }

        public Expression getExpression() {
            try {
                Expression expression = Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                return new NotExpression(expression);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class AndFunction
    extends Function {
        public AndFunction() {
            this.expressionType = 94;
            this.name = "and";
            this.termType = 1;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(10));
            this.select2.addActionListener(new Function.Select2Listener(10));
        }

        public Expression getExpression() {
            try {
                ExpressionList expressionList = new ExpressionList();
                expressionList.add(Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser));
                expressionList.add(Expression.stringToExpression(this.text2.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser));
                return new AndExpression(expressionList);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class OrFunction
    extends Function {
        public OrFunction() {
            this.expressionType = 95;
            this.name = "or";
            this.termType = 1;
            this.createFunctionPanel();
            this.select1.addActionListener(new Function.Select1Listener(10));
            this.select2.addActionListener(new Function.Select2Listener(10));
        }

        public Expression getExpression() {
            try {
                ExpressionList expressionList = new ExpressionList();
                expressionList.add(Expression.stringToExpression(this.text1.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser));
                expressionList.add(Expression.stringToExpression(this.text2.getText(), ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser));
                return new OrExpression(expressionList);
            }
            catch (ExceptionUsage exceptionUsage) {
                new HuginGUIError(exceptionUsage.getMessage());
                return null;
            }
            catch (ExceptionSyntax exceptionSyntax) {
                new HuginGUIError(exceptionSyntax.getMessage());
                return null;
            }
            catch (ExceptionInvalidExpression exceptionInvalidExpression) {
                new HuginGUIError(exceptionInvalidExpression.getMessage());
                return null;
            }
            catch (ExceptionInappropriateArguments exceptionInappropriateArguments) {
                new HuginGUIError(exceptionInappropriateArguments.getMessage());
                return null;
            }
            catch (ExceptionInsufficientStateRange exceptionInsufficientStateRange) {
                new HuginGUIError(exceptionInsufficientStateRange.getMessage());
                return null;
            }
            catch (ExceptionDivisionByZero exceptionDivisionByZero) {
                new HuginGUIError(exceptionDivisionByZero.getMessage());
                return null;
            }
            catch (ExceptionInvalidStateValues exceptionInvalidStateValues) {
                new HuginGUIError(exceptionInvalidStateValues.getMessage());
                return null;
            }
            catch (ExceptionComputationFailed exceptionComputationFailed) {
                new HuginGUIError(exceptionComputationFailed.getMessage());
                return null;
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
                return null;
            }
        }
    }

    private class Function {
        String name;
        int expressionType;
        int termType = 0;
        int useNestType = 0;
        Expression expression;
        boolean optionalExists = false;
        PastingTextField text1;
        PastingTextField text2;
        PastingTextField text3;
        PastingTextField text4;
        PastingTextField activeTextField;
        JButton select1;
        JButton select2;
        JButton select3;
        JButton select4;
        JButton insert;
        JList parentList;
        JPanel result;
        JPanel terms;

        public Function(String string, int n) {
            this.name = string;
            this.expressionType = n;
        }

        public Function() {
        }

        void createFunctionPanel() {
            Object object;
            Object object2;
            JComponent jComponent;
            Serializable serializable;
            this.result = new JPanel(new BorderLayout(10, 10));
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel(new BorderLayout());
            JLabel jLabel = new JLabel(new ImageIcon(ClassLoader.getSystemResource("icons/functionArguments.gif")));
            jPanel2.add((Component)jLabel, "North");
            TitledPanel titledPanel = new TitledPanel("Arguments(" + this.name + ")");
            titledPanel.setLayout(new BorderLayout(5, 5));
            this.terms = new JPanel(new GridLayout(4, 1));
            JPanel jPanel3 = new JPanel(new GridLayout(4, 1));
            this.terms.add(new JLabel(this.getTerm(1)));
            JPanel jPanel4 = new JPanel(new BorderLayout(5, 5));
            this.activeTextField = this.text1 = new PastingTextField(10);
            this.text1.setEnabled(this.enableTerm(1));
            this.text1.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent focusEvent) {
                    Function.this.activeTextField = Function.this.text1;
                }
            });
            this.select1 = new JButton("Select...");
            this.select1.setEnabled(this.enableTerm(1));
            jPanel4.add((Component)this.text1, "Center");
            jPanel4.add((Component)this.select1, "East");
            jPanel3.add(jPanel4);
            this.terms.add(new JLabel(this.getTerm(2)));
            JPanel jPanel5 = new JPanel(new BorderLayout(5, 5));
            this.text2 = new PastingTextField(10);
            this.text2.setEnabled(this.enableTerm(2));
            this.text2.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent focusEvent) {
                    Function.this.activeTextField = Function.this.text2;
                }
            });
            this.select2 = new JButton("Select...");
            this.select2.setEnabled(this.enableTerm(2));
            jPanel5.add((Component)this.text2, "Center");
            jPanel5.add((Component)this.select2, "East");
            jPanel3.add(jPanel5);
            this.terms.add(new JLabel(this.getTerm(3)));
            JPanel jPanel6 = new JPanel(new BorderLayout(5, 5));
            this.text3 = new PastingTextField(10);
            this.text3.setEnabled(this.enableTerm(3));
            this.text3.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent focusEvent) {
                    Function.this.activeTextField = Function.this.text3;
                }
            });
            this.select3 = new JButton("Select...");
            this.select3.setEnabled(this.enableTerm(3));
            jPanel6.add((Component)this.text3, "Center");
            jPanel6.add((Component)this.select3, "East");
            jPanel3.add(jPanel6);
            this.terms.add(new JLabel(this.getTerm(4)));
            JPanel jPanel7 = new JPanel(new BorderLayout(5, 5));
            this.text4 = new PastingTextField(10);
            this.text4.setEnabled(this.enableTerm(4));
            this.text4.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent focusEvent) {
                    Function.this.activeTextField = Function.this.text4;
                }
            });
            this.select4 = new JButton("Select...");
            this.select4.setEnabled(this.enableTerm(4));
            jPanel7.add((Component)this.text4, "Center");
            jPanel7.add((Component)this.select4, "East");
            jPanel3.add(jPanel7);
            JPanel jPanel8 = new JPanel(new BorderLayout(10, 10));
            jPanel8.add((Component)this.terms, "West");
            jPanel8.add((Component)jPanel3, "Center");
            JLabel jLabel2 = new JLabel("(*): Optional");
            jLabel2.setEnabled(this.optionalExists());
            titledPanel.add((Component)jPanel8, "Center");
            titledPanel.add((Component)jLabel2, "South");
            jPanel.add((Component)jPanel2, "West");
            jPanel.add((Component)titledPanel, "Center");
            JPanel jPanel9 = new JPanel(new BorderLayout());
            Vector<TempNode> vector = new Vector<TempNode>();
            try {
                serializable = ExpressionBuilder.this.node.getAPINode().getTable().getNodes();
                if (ExpressionBuilder.this.node.getAPINode() instanceof COM.hugin.HAPI.DiscreteChanceNode) {
                    ((LinkedList)serializable).remove(ExpressionBuilder.this.node.getAPINode());
                }
                jComponent = Hugin.mainFrame.getSelectedProjectFrame().getNetworkPanel();
                object2 = ((AbstractSequentialList)((Object)serializable)).iterator();
                while (object2.hasNext()) {
                    object = (COM.hugin.HAPI.Node)object2.next();
                    vector.add(new TempNode(((NetworkPanel)jComponent).getNode((COM.hugin.HAPI.Node)object)));
                }
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
            this.parentList = new JList(vector);
            this.parentList.setSelectionMode(0);
            this.parentList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    Function.this.insert.setEnabled(true);
                }
            });
            serializable = new JScrollPane(this.parentList);
            this.insert = new JButton("Insert");
            this.insert.setEnabled(this.parentList.getModel().getSize() > 0 && this.parentList.getSelectedIndex() > -1);
            this.insert.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = Function.this.activeTextField.getCaretPosition();
                    if (n < 0) {
                        n = 0;
                    }
                    String string = Function.this.activeTextField.getText();
                    String string2 = "";
                    String string3 = "";
                    if (string.length() > 0) {
                        string2 = string.substring(0, n);
                        if (string.length() > n) {
                            string3 = string.substring(n);
                        }
                    }
                    Function.this.activeTextField.setText(string2 + ((TempNode)Function.this.parentList.getSelectedValue()).getName() + string3);
                }
            });
            jComponent = new JPanel(new BorderLayout());
            object2 = new JLabel(new ImageIcon(ClassLoader.getSystemResource("icons/parents.gif")));
            jComponent.add((Component)object2, "North");
            object = new TitledPanel("Parents");
            ((Container)object).setLayout(new BorderLayout(10, 10));
            ((JComponent)serializable).setBorder(BorderFactory.createEtchedBorder(1));
            ((JComponent)serializable).setPreferredSize(new Dimension(200, 70));
            JPanel jPanel10 = new JPanel(new BorderLayout());
            jPanel10.add((Component)this.insert, "North");
            ((Container)object).add((Component)serializable, "Center");
            ((Container)object).add((Component)jPanel10, "East");
            jPanel9.add((Component)jComponent, "West");
            jPanel9.add((Component)object, "Center");
            this.result.add((Component)jPanel, "Center");
            this.result.add((Component)jPanel9, "South");
        }

        public JPanel getFunctionPanel() {
            return this.result;
        }

        public String getTerm(int n) {
            return HuginGUIConstants.EXPRESSION_BUILDER_terms[n - 1][this.termType];
        }

        public boolean enableTerm(int n) {
            return HuginGUIConstants.EXPRESSION_BUILDER_terms[n - 1][this.termType].length() > 0;
        }

        public boolean optionalExists() {
            return this.optionalExists;
        }

        public Expression getExpression() {
            return this.expression;
        }

        public String getExplanation() {
            return "The parameters are not specified correctly";
        }

        public String toString() {
            return this.name;
        }

        public void fromExpression(Expression expression) {
            if (expression == null) {
                return;
            }
            try {
                if (expression.isCompositeExpression() && this.termType >= 0) {
                    ExpressionList expressionList = ((CompositeExpression)expression).getOperands();
                    ListIterator listIterator = expressionList.listIterator();
                    if (this.enableTerm(1)) {
                        this.text1.setText(((Expression)listIterator.next()).expressionToString());
                    }
                    if (!listIterator.hasNext()) {
                        return;
                    }
                    if (this.enableTerm(2)) {
                        this.text2.setText(((Expression)listIterator.next()).expressionToString());
                    }
                    if (!listIterator.hasNext()) {
                        return;
                    }
                    if (this.enableTerm(3)) {
                        this.text3.setText(((Expression)listIterator.next()).expressionToString());
                    }
                    if (!listIterator.hasNext()) {
                        return;
                    }
                    if (this.enableTerm(4)) {
                        this.text4.setText(((Expression)listIterator.next()).expressionToString());
                    }
                }
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }

        class Select4Listener
        implements ActionListener {
            int mode;

            public Select4Listener(int n) {
                this.mode = n;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Expression expression = null;
                String string = Function.this.text4.getText();
                if (string.length() > 0) {
                    try {
                        expression = Expression.stringToExpression(string, ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ExpressionBuilder expressionBuilder = new ExpressionBuilder(ExpressionBuilder.this.guiFrame, ExpressionBuilder.this.node, expression, ExpressionBuilder.this.offset++);
                Expression expression2 = expressionBuilder.buildExpression(this.mode);
                try {
                    if (expression2 != null) {
                        Function.this.text4.setText(expression2.expressionToString());
                    }
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
        }

        class Select3Listener
        implements ActionListener {
            int mode;

            public Select3Listener(int n) {
                this.mode = n;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Expression expression = null;
                String string = Function.this.text3.getText();
                if (string.length() > 0) {
                    try {
                        expression = Expression.stringToExpression(string, ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ExpressionBuilder expressionBuilder = new ExpressionBuilder(ExpressionBuilder.this.guiFrame, ExpressionBuilder.this.node, expression, ExpressionBuilder.this.offset++);
                Expression expression2 = expressionBuilder.buildExpression(this.mode);
                try {
                    if (expression2 != null) {
                        Function.this.text3.setText(expression2.expressionToString());
                    }
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
        }

        class Select2Listener
        implements ActionListener {
            int mode;

            public Select2Listener(int n) {
                this.mode = n;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Expression expression = null;
                String string = Function.this.text2.getText();
                if (string.length() > 0) {
                    try {
                        expression = Expression.stringToExpression(string, ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ExpressionBuilder expressionBuilder = new ExpressionBuilder(ExpressionBuilder.this.guiFrame, ExpressionBuilder.this.node, expression, ExpressionBuilder.this.offset++);
                Expression expression2 = expressionBuilder.buildExpression(this.mode);
                try {
                    if (expression2 != null) {
                        Function.this.text2.setText(expression2.expressionToString());
                    }
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
        }

        class Select1Listener
        implements ActionListener {
            int mode;

            public Select1Listener(int n) {
                this.mode = n;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Expression expression = null;
                String string = Function.this.text1.getText();
                if (string.length() > 0) {
                    try {
                        expression = Expression.stringToExpression(string, ExpressionBuilder.this.node.getAPINode().getModel(), (ParseListener)ExpressionBuilder.this.expressionParser);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ExpressionBuilder expressionBuilder = new ExpressionBuilder(ExpressionBuilder.this.guiFrame, ExpressionBuilder.this.node, expression, ExpressionBuilder.this.offset + 1);
                Expression expression2 = expressionBuilder.buildExpression(this.mode);
                try {
                    if (expression2 != null) {
                        Function.this.text1.setText(expression2.expressionToString());
                    }
                }
                catch (Exception exception) {
                    new HuginGUIError(exception.getMessage());
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FunctionCategory {
        public static final int BOOLEAN = 0;
        public static final int COMPARISON = 1;
        public static final int ARITHMETIC = 2;
        public static final int IF_THEN_ELSE = 3;
        public static final int DISCRETE_DISTRIBUTION = 4;
        public static final int CONTINUOUS_DISTRIBUTION = 5;
        public static final int BOOLEAN_DISTRIBUTION = 6;
        public static final int GENERIC_DISTRIBUTION = 7;
        Vector<Function> functions = new Vector();
        String name;

        public FunctionCategory(int n) {
            switch (n) {
                case 0: {
                    this.name = "Boolean Operators";
                    this.functions.add(new AndFunction());
                    this.functions.add(new OrFunction());
                    this.functions.add(new NotFunction());
                    break;
                }
                case 1: {
                    this.name = "Comparison Operators";
                    this.functions.add(new EqualFunction());
                    this.functions.add(new LessFunction());
                    this.functions.add(new GreaterFunction());
                    this.functions.add(new NotEqualFunction());
                    this.functions.add(new LessEqualFunction());
                    this.functions.add(new GreaterEqualFunction());
                    break;
                }
                case 2: {
                    this.name = "Arithmetic Operators";
                    this.functions.add(new AddFunction());
                    this.functions.add(new SubtractFunction());
                    this.functions.add(new MultiplyFunction());
                    this.functions.add(new DivideFunction());
                    this.functions.add(new PowerFunction());
                    this.functions.add(new MinFunction());
                    this.functions.add(new MaxFunction());
                    this.functions.add(new NegateFunction());
                    this.functions.add(new AbsFunction());
                    this.functions.add(new ModFunction());
                    this.functions.add(new FloorFunction());
                    this.functions.add(new CeilingFunction());
                    this.functions.add(new LogFunction());
                    this.functions.add(new ExpFunction());
                    this.functions.add(new SqrtFunction());
                    this.functions.add(new Log2Function());
                    this.functions.add(new Log10Function());
                    this.functions.add(new SinhFunction());
                    this.functions.add(new CoshFunction());
                    this.functions.add(new TanhFunction());
                    this.functions.add(new SinFunction());
                    this.functions.add(new CosFunction());
                    this.functions.add(new TanFunction());
                    break;
                }
                case 3: {
                    this.name = "If-then-else";
                    this.functions.add(new IfFunction());
                    break;
                }
                case 4: {
                    this.name = "Discrete Distributions";
                    this.functions.add(new BinomialFunction());
                    this.functions.add(new GeometricFunction());
                    this.functions.add(new NegativeBinomialFunction());
                    this.functions.add(new PoissonFunction());
                    break;
                }
                case 5: {
                    this.name = "Continuous Distributions";
                    this.functions.add(new NormalFunction());
                    this.functions.add(new LogNormalFunction());
                    this.functions.add(new BetaFunction());
                    this.functions.add(new GammaFunction());
                    this.functions.add(new PERTFunction());
                    this.functions.add(new ExponentialFunction());
                    this.functions.add(new WeibullFunction());
                    this.functions.add(new UniformFunction());
                    this.functions.add(new TriangularFunction());
                    break;
                }
                case 6: {
                    this.name = "Boolean Distributions";
                    this.functions.add(new NoisyOrFunction());
                    break;
                }
                case 7: {
                    this.name = "Distribution";
                    this.functions.add(new DistributionFunction());
                }
            }
        }

        public String toString() {
            return this.name;
        }

        public Vector<Function> getFunctions() {
            return this.functions;
        }
    }

    private class SelectFunctionPane
    extends JPanel {
        JList categoryItems;
        JList functionItems;
        public static final int LABELLED_NODE = 0;
        public static final int BOOLEAN_NODE = 1;
        public static final int NUMBERED_NODE = 2;
        public static final int INTERVAL_NODE = 3;
        public static final int UTILITY_NODE = 5;
        public static final int BOOLEAN_NEST = 10;
        public static final int COMPARISON_NEST = 11;
        public static final int ARITHMETIC_NEST = 12;
        public static final int IF_THEN_ELSE_NEST = 13;
        public static final int DISCRETE_DISTRIBUTION_NEST = 14;
        public static final int CONTINUOUS_DISTRIBUTION_NEST = 15;
        public static final int BOOLEAN_DISTRIBUTION_NEST = 16;
        public static final int GENERIC_DISTRIBUTION_NEST = 17;
        JScrollPane functionScroller;
        JScrollPane categoryScroller;

        public SelectFunctionPane() {
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel(new BorderLayout());
            TitledPanel titledPanel = new TitledPanel("Function Category");
            this.categoryItems = new JList();
            this.categoryItems.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (SelectFunctionPane.this.functionItems.getSelectedIndex() >= 0) {
                        ExpressionBuilder.this.ok.setEnabled(true);
                    } else {
                        ExpressionBuilder.this.ok.setEnabled(false);
                    }
                    FunctionCategory functionCategory = (FunctionCategory)SelectFunctionPane.this.categoryItems.getSelectedValue();
                    if (functionCategory != null) {
                        SelectFunctionPane.this.functionItems.setListData(functionCategory.getFunctions());
                        SelectFunctionPane.this.functionScroller.getVerticalScrollBar().setUnitIncrement(SelectFunctionPane.this.functionItems.getCellBounds((int)0, (int)0).height);
                        SelectFunctionPane.this.functionItems.setSelectedIndex(0);
                    } else {
                        SelectFunctionPane.this.functionItems.setListData(new Vector());
                    }
                }
            });
            this.categoryItems.setSelectionMode(0);
            this.categoryItems.setBorder(BorderFactory.createEtchedBorder(1));
            this.categoryScroller = new JScrollPane(this.categoryItems);
            this.categoryScroller.setPreferredSize(new Dimension(150, 200));
            titledPanel.add(this.categoryScroller);
            JPanel jPanel3 = new JPanel(new BorderLayout());
            JLabel jLabel = new JLabel(new ImageIcon(ClassLoader.getSystemResource("icons/functionCategory.gif")));
            jPanel3.add((Component)jLabel, "North");
            jPanel.add((Component)jPanel3, "West");
            jPanel.add((Component)titledPanel, "Center");
            TitledPanel titledPanel2 = new TitledPanel("Function Name");
            this.functionItems = new JList();
            this.functionItems.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (SelectFunctionPane.this.functionItems.getSelectedIndex() >= 0) {
                        ExpressionBuilder.this.ok.setEnabled(true);
                    } else {
                        ExpressionBuilder.this.ok.setEnabled(false);
                    }
                }
            });
            this.functionItems.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() % 2 == 0) {
                        int n = SelectFunctionPane.this.functionItems.locationToIndex(new Point(mouseEvent.getX(), mouseEvent.getY()));
                        Function function = (Function)SelectFunctionPane.this.functionItems.getModel().getElementAt(n);
                        if (function != null) {
                            ExpressionBuilder.this.createFunction(function);
                        }
                    }
                }
            });
            this.functionItems.setSelectionMode(0);
            this.functionItems.setBorder(BorderFactory.createEtchedBorder(1));
            this.functionScroller = new JScrollPane(this.functionItems);
            this.functionScroller.setPreferredSize(new Dimension(150, 200));
            titledPanel2.add(this.functionScroller);
            JPanel jPanel4 = new JPanel(new BorderLayout());
            JLabel jLabel2 = new JLabel(new ImageIcon(ClassLoader.getSystemResource("icons/functionName.gif")));
            jPanel4.add((Component)jLabel2, "North");
            jPanel2.add((Component)jPanel4, "West");
            jPanel2.add((Component)titledPanel2, "Center");
            this.setLayout(new GridLayout(1, 2));
            this.add(jPanel);
            this.add(jPanel2);
        }

        public Function getSelectedFunction() {
            return (Function)this.functionItems.getSelectedValue();
        }

        public void setMode(int n) {
            Vector<FunctionCategory> vector = new Vector<FunctionCategory>();
            switch (n) {
                case 0: {
                    vector.add(new FunctionCategory(3));
                    vector.add(new FunctionCategory(7));
                    break;
                }
                case 1: {
                    vector.add(new FunctionCategory(0));
                    vector.add(new FunctionCategory(1));
                    vector.add(new FunctionCategory(3));
                    vector.add(new FunctionCategory(6));
                    vector.add(new FunctionCategory(7));
                    break;
                }
                case 2: {
                    vector.add(new FunctionCategory(4));
                    vector.add(new FunctionCategory(2));
                    vector.add(new FunctionCategory(3));
                    vector.add(new FunctionCategory(7));
                    break;
                }
                case 3: {
                    vector.add(new FunctionCategory(4));
                    vector.add(new FunctionCategory(5));
                    vector.add(new FunctionCategory(2));
                    vector.add(new FunctionCategory(3));
                    vector.add(new FunctionCategory(7));
                    break;
                }
                case 5: {
                    vector.add(new FunctionCategory(2));
                    vector.add(new FunctionCategory(3));
                    break;
                }
                case 13: {
                    vector.add(new FunctionCategory(0));
                    vector.add(new FunctionCategory(1));
                    vector.add(new FunctionCategory(3));
                    vector.add(new FunctionCategory(6));
                    vector.add(new FunctionCategory(7));
                    break;
                }
                case 10: {
                    vector.add(new FunctionCategory(0));
                    vector.add(new FunctionCategory(1));
                    vector.add(new FunctionCategory(3));
                    break;
                }
                case 11: {
                    vector.add(new FunctionCategory(2));
                    vector.add(new FunctionCategory(0));
                    vector.add(new FunctionCategory(1));
                    vector.add(new FunctionCategory(3));
                    break;
                }
                case 12: {
                    vector.add(new FunctionCategory(2));
                    vector.add(new FunctionCategory(3));
                    break;
                }
                case 16: {
                    vector.add(new FunctionCategory(2));
                    vector.add(new FunctionCategory(3));
                    break;
                }
                case 14: {
                    vector.add(new FunctionCategory(2));
                    vector.add(new FunctionCategory(3));
                    break;
                }
                case 15: {
                    vector.add(new FunctionCategory(2));
                    vector.add(new FunctionCategory(3));
                    break;
                }
                case 17: {
                    vector.add(new FunctionCategory(2));
                    vector.add(new FunctionCategory(3));
                }
            }
            this.categoryItems.setListData(vector);
            this.categoryScroller.getVerticalScrollBar().setUnitIncrement(this.categoryItems.getCellBounds((int)0, (int)0).height);
            this.categoryItems.setSelectedIndex(0);
            this.functionItems.setSelectedIndex(0);
        }

        public Insets getInsets() {
            return new Insets(10, 10, 10, 10);
        }

        public String getName() {
            return "Select Function";
        }
    }
}

