/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HelpPanel
extends JDialog {
    JEditorPane main;
    JEditorPane index;
    String pageName;

    public HelpPanel(JDialog jDialog) {
        super(jDialog, "Help", true);
        this.getContentPane().add(this.createHelpPanel());
        this.pack();
    }

    public HelpPanel(JFrame jFrame) {
        super(jFrame, "Help", true);
        this.getContentPane().add(this.createHelpPanel());
        this.pack();
    }

    private JPanel createHelpPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JSplitPane jSplitPane = new JSplitPane();
        LinkListener linkListener = new LinkListener();
        this.main = new JEditorPane();
        this.main.setEditable(false);
        this.main.addHyperlinkListener(linkListener);
        JScrollPane jScrollPane = new JScrollPane(this.main);
        jScrollPane.setPreferredSize(new Dimension(450, 390));
        this.index = new JEditorPane();
        this.index.setEditable(false);
        this.index.addHyperlinkListener(linkListener);
        this.index.setContentType("text/html");
        JScrollPane jScrollPane2 = new JScrollPane(this.index);
        jScrollPane2.setPreferredSize(new Dimension(150, 390));
        JButton jButton = new JButton("Close");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HelpPanel.this.dispose();
            }
        });
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel2.add(jButton);
        jSplitPane.setLeftComponent(jScrollPane2);
        jSplitPane.setRightComponent(jScrollPane);
        jPanel.add(jSplitPane);
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    protected void setHelpPage(String string) {
        Object object;
        String string2 = null;
        if (string.indexOf("#") != -1) {
            object = string.split("#");
            string = object[0];
            string2 = "#" + object[1];
        }
        this.pageName = string;
        this.main.invalidate();
        try {
            URL uRL = ClassLoader.getSystemResource(string);
            object = this.parseHelpPage(uRL);
            if (string2 != null) {
                this.main.setPage(uRL + string2);
            } else {
                this.main.setPage(uRL);
            }
            this.index.setText(this.getIndexPage((LinkedList<Anchor>)object));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.validate();
    }

    private LinkedList<Anchor> parseHelpPage(URL uRL) {
        LinkedList<Anchor> linkedList = new LinkedList<Anchor>();
        try {
            String string = "";
            InputStream inputStream = uRL.openStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                string = string + string2;
                string2 = bufferedReader.readLine();
            }
            String string3 = string.toLowerCase();
            int n = string3.indexOf("<title>");
            int n2 = string3.indexOf("</title>");
            if (n >= 0) {
                linkedList.add(new Anchor(ClassLoader.getSystemResource(this.pageName).toString(), string.substring(n + 7, n2)));
            }
            n = string3.indexOf("<a name=\"");
            while (n >= 0) {
                n2 = string3.indexOf("\"", n + 9);
                String string4 = string.substring(n + 9, n2);
                n = n2 + 2;
                n2 = string3.indexOf("</a>", n);
                String string5 = string.substring(n, n2);
                linkedList.add(new Anchor(string4, string5));
                n = string3.indexOf("<a name=\"", n2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return linkedList;
    }

    private String getIndexPage(LinkedList<Anchor> linkedList) {
        String string = "";
        ListIterator listIterator = linkedList.listIterator();
        Anchor anchor = (Anchor)listIterator.next();
        String string2 = anchor.getName();
        string = string + "<HTML><BODY>\n";
        string = string + "<H3><A href=\"" + string2 + "\">" + anchor.getTitle() + "</A></H3>\n";
        while (listIterator.hasNext()) {
            anchor = (Anchor)listIterator.next();
            string = string + "- <A href=\"" + string2 + "#" + anchor.getName() + "\">" + "<FONT size=\"2\">" + anchor.getTitle() + "</FONT></A><br>\n";
        }
        string = string + "</HTML></BODY>\n";
        return string;
    }

    private class LinkListener
    implements HyperlinkListener {
        private LinkListener() {
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    HelpPanel.this.main.setPage(hyperlinkEvent.getURL());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private class Anchor {
        String name;
        String title;

        public Anchor(String string, String string2) {
            this.name = string;
            this.title = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

