/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.ExceptionDemo;
import COM.hugin.HGUI.BugReport;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIFrame;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.PastingTextArea;
import COM.hugin.HGUI.TitledPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class HuginGUIError
extends JDialog {
    private static List<Exception> blockedCascadingExceptions = Collections.synchronizedList(new ArrayList());
    private static List<Exception> pendingExceptions = Collections.synchronizedList(new ArrayList());
    private static List<Exception> relatedExceptions = Collections.synchronizedList(new ArrayList());
    PastingTextArea errorMessage;
    JCheckBox alwaysShow;
    JButton ok;
    JButton report;
    JButton saveNetwork;
    HuginGUIFrame frame;
    boolean internalError;
    Exception exception;
    String message;

    public HuginGUIError(String string) {
        super(Hugin.mainFrame, HuginGUIConstants.get("MISCELLANEOUS_Error"), true);
        this.init(string, Hugin.mainFrame, false, false);
    }

    public HuginGUIError(String string, boolean bl) {
        this.setModal(true);
        this.init(string, null, false, false);
    }

    public HuginGUIError(String string, String string2) {
        super(Hugin.mainFrame, HuginGUIConstants.get("MISCELLANEOUS_Error"), true);
        this.init(HuginGUIConstants.get("str_in_method_") + string + ": " + string2, Hugin.mainFrame, false, true);
    }

    public HuginGUIError(String string, boolean bl, boolean bl2) {
        super(Hugin.mainFrame, HuginGUIConstants.get("MISCELLANEOUS_Error"), true);
        this.init(string, Hugin.mainFrame, bl, bl2);
    }

    public HuginGUIError(Exception exception) {
        if (Hugin.mainFrame != null) {
            if (!this.isCascadingAndMustBeBlocked(exception)) {
                pendingExceptions.add(exception);
                Runnable runnable = new Runnable(){

                    public void run() {
                        HuginGUIError.this.showGUIError();
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        } else {
            new HuginGUIError(exception, true);
        }
        exception.printStackTrace();
    }

    private synchronized void showGUIError() {
        if (pendingExceptions.size() > 0) {
            relatedExceptions.addAll(pendingExceptions);
            pendingExceptions.clear();
            new HuginGUIError(relatedExceptions.get(0), true, true);
        }
    }

    private String getRelatedExceptions(Exception exception) {
        if (relatedExceptions.size() <= 1) {
            return "";
        }
        String string = "============================================================\n========= SET OF EXCEPTIONS THAT MIGHT BE RELATED ==========\n= (Following was thrown after first exception and before all pending events was processed by the EDT) =\n============================================================\n";
        for (Exception exception2 : relatedExceptions) {
            if (exception == exception2) continue;
            string = string + "\n" + this.getStackTraceUntill(exception2, null);
        }
        relatedExceptions.clear();
        return string;
    }

    private synchronized boolean isCascadingAndMustBeBlocked(Exception exception) {
        String string = this.getStackTraceUntill(exception, "paint");
        for (Exception exception2 : blockedCascadingExceptions) {
            if (!string.equals(this.getStackTraceUntill(exception2, "paint"))) continue;
            return true;
        }
        for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
            if (!stackTraceElement.getMethodName().equals("paint")) continue;
            blockedCascadingExceptions.add(exception);
            return false;
        }
        return false;
    }

    private String getStackTraceUntill(Exception exception, String string) {
        String string2 = exception.toString() + "\n";
        for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
            if (string != null && stackTraceElement.getMethodName().equals(string)) {
                return string2;
            }
            string2 = string2 + "        " + stackTraceElement.toString() + "\n";
        }
        return string2;
    }

    public HuginGUIError(Exception exception, boolean bl, boolean bl2) {
        super(Hugin.mainFrame, HuginGUIConstants.get("MISCELLANEOUS_Error"), true);
        exception.printStackTrace();
        if (exception instanceof ExceptionDemo) {
            this.init(exception.getMessage(), Hugin.mainFrame, false, false);
            return;
        }
        this.init(exception, Hugin.mainFrame);
    }

    public HuginGUIError(Exception exception, boolean bl) {
        this.setModal(true);
        this.setTitle(HuginGUIConstants.get("MISCELLANEOUS_Error"));
        this.internalError = true;
        if (exception instanceof ExceptionDemo) {
            this.init(exception.getMessage(), null, false, false);
            return;
        }
        this.message = exception.toString();
        this.message = this.message + "\n\n";
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            this.message = this.message + stackTraceElementArray[i].toString() + "\n";
        }
        this.init(this.message, null, true, true);
    }

    private void init(Exception exception, HuginGUIFrame huginGUIFrame) {
        HuginGUIUtils.resumeEventQueue();
        this.resetClipboard();
        this.frame = huginGUIFrame;
        this.internalError = !(exception instanceof ExceptionDemo);
        this.exception = exception;
        this.message = exception.getMessage() != null ? exception.getMessage() : "Null";
        if (huginGUIFrame.desktop.getSelectedFrame() != null) {
            ((HuginProjectFrame)huginGUIFrame.desktop.getSelectedFrame()).errorList.add(this);
        }
        HuginGUIUtils.beep(this.message);
        if (!huginGUIFrame.preferences.display_errors) {
            return;
        }
        this.createFrame();
        if (this.internalError) {
            this.errorMessage.setText(HuginGUIConstants.get("MISCELLANEOUS_InternalError_message"));
        } else {
            this.errorMessage.setText(this.message);
        }
        this.errorMessage.setCaretPosition(0);
        this.pack();
        this.setVisible(true);
    }

    private void init(String string, HuginGUIFrame huginGUIFrame, boolean bl, boolean bl2) {
        HuginGUIUtils.resumeEventQueue();
        this.resetClipboard();
        this.frame = huginGUIFrame;
        this.internalError = bl2;
        this.message = string != null ? string : "Null";
        if (huginGUIFrame != null && huginGUIFrame.desktop.getSelectedFrame() != null) {
            ((HuginProjectFrame)huginGUIFrame.desktop.getSelectedFrame()).errorList.add(this);
        }
        this.setTitle(HuginGUIConstants.get("MISCELLANEOUS_Error"));
        HuginGUIUtils.beep(this.message);
        if (huginGUIFrame != null && !huginGUIFrame.preferences.display_errors && !bl) {
            return;
        }
        this.createFrame();
        this.errorMessage.setText(this.message);
        this.errorMessage.setCaretPosition(0);
        this.pack();
        this.setVisible(true);
    }

    private void resetClipboard() {
        try {
            this.getToolkit().getSystemClipboard().setContents(new StringSelection(""), null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void createFrame() {
        String string = this.internalError ? HuginGUIConstants.get("MISCELLANEOUS_InternalError") : HuginGUIConstants.get("MISCELLANEOUS_Error_message");
        TitledPanel titledPanel = new TitledPanel(string);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel(new BorderLayout());
        if (this.frame != null && !this.internalError) {
            this.alwaysShow = new JCheckBox(HuginGUIConstants.get("MISCELLANEOUS_Always_show_error"));
            this.alwaysShow.setSelected(this.frame.preferences.display_errors);
            this.alwaysShow.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    HuginGUIError.this.frame.preferences.display_errors = HuginGUIError.this.alwaysShow.isSelected();
                }
            });
        }
        this.errorMessage = new PastingTextArea(5, 40);
        this.errorMessage.setEditable(false);
        this.errorMessage.setLineWrap(true);
        this.errorMessage.setWrapStyleWord(true);
        this.errorMessage.setBackground(titledPanel.getBackground());
        JScrollPane jScrollPane = new JScrollPane(this.errorMessage);
        titledPanel.add((Component)jScrollPane, "East");
        jPanel3.add((Component)titledPanel, "Center");
        if (this.frame != null) {
            if (this.internalError) {
                jPanel3.add((Component)jPanel2, "South");
            } else {
                jPanel3.add((Component)this.alwaysShow, "South");
            }
        }
        this.ok = new JButton(this.internalError ? HuginGUIConstants.get("cancel_button") : HuginGUIConstants.get("OK_button"));
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HuginGUIError.this.dispose();
            }
        });
        if (this.internalError) {
            this.report = new JButton(HuginGUIConstants.get("report_button"));
            this.report.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BugReport bugReport = HuginGUIError.this.exception != null ? new BugReport(HuginGUIError.this.exception, HuginGUIError.this.getRelatedExceptions(HuginGUIError.this.exception)) : new BugReport(HuginGUIError.this.message);
                    int n = HuginGUIError.this.frame.getWidth() / 2 - bugReport.getPreferredSize().width / 2;
                    int n2 = HuginGUIError.this.frame.getHeight() / 2 - bugReport.getPreferredSize().height / 2;
                    bugReport.setLocation(HuginGUIError.this.frame.getX() + n, HuginGUIError.this.frame.getY() + n2);
                    bugReport.pack();
                    bugReport.setVisible(true);
                    HuginGUIError.this.dispose();
                }
            });
            this.saveNetwork = new JButton(HuginGUIConstants.get("save_work_button"));
            this.saveNetwork.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        for (HuginProjectFrame huginProjectFrame : Hugin.mainFrame.getProjectFrames()) {
                            String string = huginProjectFrame.getTitle();
                            if (huginProjectFrame.saveFile(6) != 1) continue;
                            huginProjectFrame.getNetworkPanel().containsUnsavedChanges(false);
                            try {
                                String string2 = huginProjectFrame.getTitle();
                                if (string2.equals(string)) continue;
                                Hugin.mainFrame.windowRenamed(string2, string);
                            }
                            catch (Exception exception) {}
                        }
                    }
                    catch (Exception exception) {
                        new HuginGUIError("Failed saving networks from error dialog");
                    }
                }
            });
        }
        JLabel jLabel = new JLabel(new ImageIcon(ClassLoader.getSystemResource("icons/nodeicon.gif")));
        jLabel.setAlignmentX(0.5f);
        this.getContentPane().setLayout(new BorderLayout());
        if (this.internalError) {
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.add(this.report);
            jPanel2.add(this.saveNetwork);
            jPanel2.add(this.ok);
            this.getRootPane().setDefaultButton(this.report);
        } else {
            jPanel2.setLayout(new BoxLayout(jPanel2, 1));
            this.ok.setAlignmentX(0.5f);
            jPanel2.add(Box.createVerticalGlue());
            jPanel2.add(this.ok);
            jPanel2.add(Box.createVerticalGlue());
            jPanel2.add(jLabel);
            jPanel2.add(Box.createVerticalGlue());
            jPanel2.add(Box.createVerticalGlue());
            jPanel2.add(Box.createVerticalGlue());
            jPanel2.add(Box.createVerticalGlue());
            this.getContentPane().add((Component)jPanel2, "East");
            this.getRootPane().setDefaultButton(this.ok);
        }
        this.getContentPane().add((Component)jPanel3, "Center");
        int n = this.getPreferredSize().width / 2;
        int n2 = this.getPreferredSize().height / 2;
        if (this.frame != null) {
            if (this.frame.getWidth() > 0) {
                this.setLocation(this.frame.getX() + this.frame.getWidth() / 2 - n, this.frame.getY() + this.frame.getHeight() / 2 - n2);
            } else {
                this.setLocation((int)this.frame.getToolkit().getScreenSize().getWidth() / 2 - n, (int)this.frame.getToolkit().getScreenSize().getHeight() / 2 - n2);
            }
        } else {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((int)(dimension.getWidth() / 2.0 - (double)n), (int)(dimension.getHeight() / 2.0 - (double)n2));
        }
    }

    public TitledPanel getDisplayPanel() {
        String string = this.internalError ? HuginGUIConstants.get("MISCELLANEOUS_InternalError") : HuginGUIConstants.get("MISCELLANEOUS_Error_message");
        TitledPanel titledPanel = new TitledPanel(string);
        JScrollPane jScrollPane = new JScrollPane(this.errorMessage);
        titledPanel.add((Component)jScrollPane, "East");
        return titledPanel;
    }

    public String toString() {
        return this.message;
    }
}

