/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.BooleanDCNode;
import COM.hugin.HAPI.ContinuousChanceNode;
import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.DiscreteNode;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.IntervalDCNode;
import COM.hugin.HAPI.LabelledDCNode;
import COM.hugin.HAPI.Node;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HAPI.NumberedDCNode;
import COM.hugin.HAPI.Table;
import COM.hugin.HAPI.UtilityNode;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.InternalNodeTableModel;
import COM.hugin.HGUI.NodeStateModel;
import COM.hugin.HGUI.SelectionTable;
import COM.hugin.HGUI.WizardPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

public class InternalTable
extends JPanel {
    protected static final int TABLE_TYPE_NORMAL = 1;
    protected static final int TABLE_TYPE_EXPERIENCE = 2;
    protected static final int TABLE_TYPE_FADING = 3;
    protected static final int TABLE_TYPE_CONTINUOUS = 4;
    private int maxWidth;
    private int maxHeight = 120;
    private int tableType = 1;
    private int nodeType;
    private int tableHeight;
    private int tableWidth;
    JScrollBar hScroll;
    JScrollPane scrPanel;
    JPanel headerPanel;
    JPanel parentPanel;
    JPanel statePanel;
    JPanel tablePanel;
    JPanel horizontalScrollPanel;
    JPanel topPanel;
    JPanel middlePanel;
    JPanel bottomPanel;
    JPanel[] headerRow;
    public SelectionTable table;
    public JTable stateTable;
    InternalNodeTableModel NDM;
    NodeStateModel NSM;
    String[][] parents;
    String[][] dataArray;
    String[][] stateArray;
    String[] rowHeaderArray;
    String[] rowHeaderHeaderArray;
    int[][] headerStates;
    int tableLength;
    int numberOfParents;
    int numberOfStates;
    int tableOffset;
    int lengthOfTableView;
    int cellUnitSize = 50;
    int rowHeaderCellUnitSize = 75;
    int extray_value = 0;
    int x_value = 0;
    int y_value = 0;
    Node node;
    WizardPanel owner;

    public InternalTable(Node node, WizardPanel wizardPanel, int n) throws ExceptionHugin {
        this.owner = wizardPanel;
        this.tableType = n;
        this.maxWidth = 400;
        this.node = node;
        this.makeRowHeaderHeaderAndParentArray();
        this.makeRowHeaderArray();
        this.numberOfParents = this.rowHeaderHeaderArray.length - 1;
        this.numberOfStates = this.rowHeaderArray.length;
        this.tableLength = this.levelSize(this.numberOfParents - 1);
        this.lengthOfTableView = this.cellUnitSize * (this.tableLength + 2) > this.maxWidth ? (this.maxWidth - 15 - 15) / this.cellUnitSize - 2 : this.tableLength;
        this.makeHeader(0, this.lengthOfTableView);
        this.dataArray = this.getDataArray(n, 0, this.lengthOfTableView);
        this.addComponentListener(new TableResizedListener());
        this.setLayout(new BoxLayout(this, 1));
        this.setAlignmentX(0.0f);
        this.setAlignmentY(0.0f);
        this.hScroll = this.makeScrollBar();
        this.hScroll.addAdjustmentListener(new TableScrolledListener());
        this.parentPanel = new JPanel();
        this.statePanel = new JPanel();
        this.topPanel = new JPanel();
        this.middlePanel = new JPanel();
        this.bottomPanel = new JPanel();
        this.headerPanel = new JPanel();
        this.tablePanel = this.makeTablePanel();
        this.topPanel.setLayout(new BoxLayout(this.topPanel, 0));
        this.topPanel.setAlignmentX(0.0f);
        this.topPanel.setAlignmentY(0.0f);
        this.middlePanel.setLayout(new BorderLayout());
        this.middlePanel.setAlignmentX(0.0f);
        this.middlePanel.setAlignmentY(0.0f);
        this.bottomPanel.setLayout(new BorderLayout());
        this.bottomPanel.setAlignmentX(0.0f);
        this.bottomPanel.setAlignmentY(0.0f);
        this.parentPanel.setLayout(new BoxLayout(this.parentPanel, 1));
        this.parentPanel.setAlignmentX(0.0f);
        this.parentPanel.setAlignmentY(0.0f);
        this.addHeadersToParentPanel(this.parentPanel, this.headerRow);
        this.headerPanel.setLayout(new BoxLayout(this.headerPanel, 1));
        this.headerPanel.setAlignmentX(0.0f);
        this.headerPanel.setAlignmentY(0.0f);
        for (int i = 0; i < this.headerRow.length; ++i) {
            this.headerPanel.add(this.headerRow[i]);
        }
        this.scrPanel = this.makeScrollPanel();
        this.scrPanel.setBorder(null);
        this.topPanel.add(this.parentPanel);
        this.topPanel.add(this.headerPanel);
        this.middlePanel.add(this.scrPanel);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel("");
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setAlignmentX(0.0f);
        jPanel2.setAlignmentY(0.0f);
        jLabel.setBorder(BorderFactory.createEtchedBorder());
        jLabel.setPreferredSize(new Dimension(this.cellUnitSize * 2, 15));
        jLabel.setSize(new Dimension(this.cellUnitSize * 2, 15));
        jLabel.setMaximumSize(new Dimension(this.cellUnitSize * 2, 15));
        jLabel.setMinimumSize(new Dimension(this.cellUnitSize * 2, 15));
        jPanel2.add(jLabel);
        this.horizontalScrollPanel = new JPanel();
        this.horizontalScrollPanel.setLayout(new BorderLayout());
        this.horizontalScrollPanel.setAlignmentX(0.0f);
        this.horizontalScrollPanel.setAlignmentY(0.0f);
        this.horizontalScrollPanel.setSize(new Dimension(this.cellUnitSize * this.lengthOfTableView, 15));
        this.horizontalScrollPanel.setMaximumSize(new Dimension(this.cellUnitSize * this.lengthOfTableView, 15));
        this.horizontalScrollPanel.add(this.hScroll);
        this.bottomPanel.add((Component)jPanel2, "West");
        this.bottomPanel.add(this.horizontalScrollPanel);
        this.add(this.topPanel);
        this.add(this.middlePanel);
        if (this.cellUnitSize * (this.tableLength + 2) > this.maxWidth) {
            this.add(this.bottomPanel);
        }
    }

    private JScrollBar makeScrollBar() {
        JScrollBar jScrollBar = this.cellUnitSize * (this.tableLength + 2) > this.maxWidth ? new JScrollBar(0, 0, this.lengthOfTableView, 0, this.tableLength) : new JScrollBar(0, 0, 1, 0, this.lengthOfTableView);
        jScrollBar.setMaximumSize(new Dimension(this.cellUnitSize * this.lengthOfTableView, 20));
        jScrollBar.setMinimumSize(new Dimension(this.cellUnitSize * this.lengthOfTableView, 20));
        jScrollBar.setPreferredSize(new Dimension(this.cellUnitSize * this.lengthOfTableView, 20));
        jScrollBar.setSize(new Dimension(this.cellUnitSize * this.lengthOfTableView, 20));
        jScrollBar.setVisibleAmount(this.lengthOfTableView);
        return jScrollBar;
    }

    private JPanel makeTablePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.NDM = new InternalNodeTableModel(this.dataArray, this.nodeType, this.tableType);
        this.NDM.addTableModelListener(new TableChangedListener());
        this.table = new SelectionTable(this.NDM);
        this.table.addPropertyChangeListener("Tabbed", new TabListener());
        this.setColumnSize(this.table);
        this.table.setSelectionBackground(Color.white);
        this.table.setSelectionForeground(Color.black);
        this.table.setBackground(Color.white);
        this.stateArray = new String[this.rowHeaderArray.length][1];
        for (int i = 0; i < this.rowHeaderArray.length; ++i) {
            this.stateArray[i][0] = this.rowHeaderArray[i];
        }
        String[] stringArray = new String[]{"header"};
        this.NSM = new NodeStateModel(this.stateArray);
        this.stateTable = new JTable(this.NSM){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.stateTable.setBackground(new JPanel().getBackground());
        this.stateTable.setTableHeader(null);
        this.stateTable.setAutoResizeMode(0);
        this.stateTable.setEnabled(true);
        TableColumn tableColumn = this.stateTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(this.cellUnitSize * 2);
        tableColumn.setMaxWidth(this.cellUnitSize * 2);
        tableColumn.setMinWidth(this.cellUnitSize * 2);
        this.stateTable.getColumnModel().setColumnMargin(5);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.stateTable, "West");
        jPanel2.add(this.table);
        jPanel.add((Component)jPanel2, "West");
        return jPanel;
    }

    private void addHeadersToParentPanel(JPanel jPanel, JPanel[] jPanelArray) {
        for (int i = 0; i < jPanelArray.length; ++i) {
            JLabel jLabel = new JLabel("" + this.rowHeaderHeaderArray[i]);
            jLabel.setBorder(BorderFactory.createEtchedBorder());
            jLabel.setPreferredSize(new Dimension(this.cellUnitSize * 2, 20));
            jLabel.setSize(new Dimension(this.cellUnitSize * 2, 20));
            jLabel.setMaximumSize(new Dimension(this.cellUnitSize * 2, 20));
            jLabel.setMinimumSize(new Dimension(this.cellUnitSize * 2, 20));
            jPanel.add(jLabel);
        }
    }

    private JScrollPane makeScrollPanel() {
        JScrollPane jScrollPane = new JScrollPane();
        int n = this.numberOfStates * this.table.getRowHeight() + 3 + 80;
        if (this.cellUnitSize * (this.tableLength + 2) > this.maxWidth) {
            if (n > this.maxHeight) {
                if (this.numberOfStates > 6) {
                    this.y_value = 6 * this.table.getRowHeight() + 3;
                    jScrollPane.setVerticalScrollBarPolicy(22);
                    this.x_value = this.cellUnitSize * (this.lengthOfTableView + 2) + 15;
                } else {
                    this.y_value = this.numberOfStates * this.table.getRowHeight() + 3;
                    jScrollPane.setVerticalScrollBarPolicy(21);
                    this.x_value = this.cellUnitSize * (this.lengthOfTableView + 2);
                }
            } else {
                this.y_value = this.numberOfStates * this.table.getRowHeight() + 3;
                jScrollPane.setVerticalScrollBarPolicy(21);
                this.x_value = this.cellUnitSize * (this.lengthOfTableView + 2);
            }
            this.extray_value = 36;
        } else {
            if (n > this.maxHeight) {
                if (this.numberOfStates > 6) {
                    this.y_value = 6 * this.table.getRowHeight() + 3;
                    jScrollPane.setVerticalScrollBarPolicy(22);
                    this.x_value = this.cellUnitSize * (this.lengthOfTableView + 2) + 15;
                } else {
                    this.y_value = this.numberOfStates * this.table.getRowHeight() + 3;
                    this.x_value = this.cellUnitSize * (this.lengthOfTableView + 2) + 1;
                    jScrollPane.setVerticalScrollBarPolicy(21);
                }
            } else {
                this.y_value = this.numberOfStates * this.table.getRowHeight() + 3;
                this.x_value = this.cellUnitSize * (this.lengthOfTableView + 2);
                jScrollPane.setVerticalScrollBarPolicy(21);
            }
            this.extray_value = 18;
        }
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(this.table.getRowHeight());
        jScrollPane.setRowHeaderView(null);
        jScrollPane.setColumnHeaderView(null);
        jScrollPane.setViewportView(this.tablePanel);
        jScrollPane.setRowHeaderView(null);
        jScrollPane.setColumnHeaderView(null);
        return jScrollPane;
    }

    protected void setNode(Node node) {
        JScrollBar jScrollBar;
        if (this.tableType == 4 && node instanceof DiscreteChanceNode) {
            this.tableType = 1;
        } else if (this.tableType == 1 && node instanceof ContinuousChanceNode) {
            this.tableType = 4;
        }
        this.invalidate();
        boolean bl = this.node == node;
        int n = 0;
        int n2 = 0;
        if (bl) {
            if (this.hScroll != null) {
                n = this.hScroll.getValue();
                this.hScroll.setValue(0);
            }
            if ((jScrollBar = this.scrPanel.getVerticalScrollBar()) != null) {
                n2 = jScrollBar.getValue();
            }
        }
        try {
            this.node = node;
            this.makeRowHeaderHeaderAndParentArray();
            this.makeRowHeaderArray();
            this.numberOfParents = this.rowHeaderHeaderArray.length - 1;
            this.numberOfStates = this.rowHeaderArray.length;
            this.tableLength = this.levelSize(this.numberOfParents - 1);
            this.lengthOfTableView = this.cellUnitSize * (this.tableLength + 2) > this.maxWidth ? (this.maxWidth - 15 - 15) / this.cellUnitSize - 2 : this.tableLength;
            this.makeHeader(0, this.lengthOfTableView);
            this.dataArray = this.getDataArray(this.tableType, 0, this.lengthOfTableView);
            this.hScroll = this.makeScrollBar();
            this.hScroll.addAdjustmentListener(new TableScrolledListener());
            this.removeAll();
            this.parentPanel.removeAll();
            this.statePanel.removeAll();
            this.topPanel.removeAll();
            this.middlePanel.removeAll();
            this.bottomPanel.removeAll();
            this.headerPanel.removeAll();
            this.tablePanel = this.makeTablePanel();
            this.scrPanel = this.makeScrollPanel();
            this.scrPanel.setBorder(null);
            if (bl) {
                if (this.hScroll != null) {
                    this.hScroll.setValue(n);
                }
                if ((jScrollBar = this.scrPanel.getVerticalScrollBar()) != null) {
                    jScrollBar.setValue(n2);
                    jScrollBar.setValue(n2);
                }
            }
            this.addHeadersToParentPanel(this.parentPanel, this.headerRow);
            for (int i = 0; i < this.headerRow.length; ++i) {
                this.headerPanel.add(this.headerRow[i]);
            }
            this.topPanel.add(this.parentPanel);
            this.topPanel.add(this.headerPanel);
            this.middlePanel.add(this.scrPanel);
            JPanel jPanel = new JPanel();
            JPanel jPanel2 = new JPanel();
            JLabel jLabel = new JLabel("");
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.setAlignmentX(0.0f);
            jPanel2.setAlignmentY(0.0f);
            jLabel.setBorder(BorderFactory.createEtchedBorder());
            jLabel.setPreferredSize(new Dimension(this.cellUnitSize * 2, 15));
            jLabel.setSize(new Dimension(this.cellUnitSize * 2, 15));
            jLabel.setMaximumSize(new Dimension(this.cellUnitSize * 2, 15));
            jLabel.setMinimumSize(new Dimension(this.cellUnitSize * 2, 15));
            jPanel2.add(jLabel);
            this.horizontalScrollPanel.removeAll();
            this.horizontalScrollPanel.add(this.hScroll);
            this.bottomPanel.add((Component)jPanel2, "West");
            this.bottomPanel.add(this.horizontalScrollPanel);
            this.add(this.topPanel);
            this.add(this.middlePanel);
            if (this.cellUnitSize * (this.tableLength + 2) > this.maxWidth) {
                this.add(this.bottomPanel);
            }
            this.resizeComponents();
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        this.validate();
        this.repaint();
    }

    protected void setMaxSize(int n, int n2) {
        this.maxWidth = n;
        this.maxHeight = n2;
    }

    public void makeHeader(int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = 1;
        boolean bl = false;
        int n6 = n + n2;
        int n7 = n;
        this.headerRow = new JPanel[this.parents.length - 1];
        for (n3 = 0; n3 < this.parents.length - 1; ++n3) {
            this.headerRow[n3] = new JPanel();
            this.headerRow[n3].setLayout(new BoxLayout(this.headerRow[n3], 0));
        }
        for (n3 = 0; n3 < this.parents.length - 1; ++n3) {
            int n8;
            n7 = n;
            n5 = 1;
            for (n8 = this.parents.length - 2; n8 > n3; --n8) {
                n5 *= this.parents[n8].length;
            }
            while (n7 < n6) {
                if (n7 % n5 == 0) {
                    n4 = n7 + n5;
                } else if (n5 > n7) {
                    n4 = n5 - n7 + n7;
                } else if (n5 < n7) {
                    n4 = n5 - n7 % n5 + n7;
                }
                if (n4 > n6) {
                    n4 = n6;
                }
                n8 = n4 - n7;
                JLabel jLabel = new JLabel("" + this.parents[n3][this.getHeaderState(n7, n3 + 1)], 0);
                jLabel.setToolTipText("" + this.parents[n3][this.getHeaderState(n7, n3 + 1)]);
                jLabel.setForeground(Color.black);
                jLabel.setBorder(BorderFactory.createLoweredBevelBorder());
                jLabel.setPreferredSize(new Dimension(this.cellUnitSize * n8, 20));
                jLabel.setSize(new Dimension(this.cellUnitSize * n8, 20));
                jLabel.setMaximumSize(new Dimension(this.cellUnitSize * n8, 20));
                jLabel.setMinimumSize(new Dimension(this.cellUnitSize * n8, 20));
                this.headerRow[n3].add(jLabel);
                this.headerRow[n3].repaint();
                n7 = n4;
            }
        }
    }

    public int levelSize(int n) {
        int n2 = 1;
        for (int i = 0; i <= n; ++i) {
            n2 *= this.parents[i].length;
        }
        return n2;
    }

    public void setLabelUnitSize(int n) {
        this.cellUnitSize = n;
    }

    public String[][] getDataArray(int n, int n2) throws ExceptionHugin {
        int n3 = this.parents[this.parents.length - 1].length;
        int n4 = this.parents.length - 1;
        int n5 = n * n3;
        int n6 = n + n2;
        String[][] stringArray = new String[n3][n2];
        Table table = this.node.getTable();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                stringArray[i][j] = InternalNodeTableModel.formatDouble(table.getDataItem(n5 + j * n3 + i));
            }
        }
        return stringArray;
    }

    public String[][] getContinuousDataArray(int n, int n2) throws ExceptionHugin {
        String[][] stringArray2;
        int n3;
        int n4 = 2;
        if (this.node instanceof ContinuousChanceNode) {
            n3 = 0;
            NodeList nodeList = this.node.getTable().getNodes();
            for (String[][] stringArray2 : nodeList) {
                if (stringArray2 == this.node || !(stringArray2 instanceof ContinuousChanceNode)) continue;
                ++n3;
            }
            n4 += n3;
        }
        n3 = this.parents.length - 1;
        int n5 = n * n4;
        int n6 = n + n2;
        stringArray2 = new String[n4][n2];
        Table table = this.node.getTable();
        for (int i = 0; i < n2; ++i) {
            stringArray2[0][i] = InternalNodeTableModel.formatDouble(((ContinuousChanceNode)this.node).getAlpha(n + i));
            for (int j = 1; j < n4 - 1; ++j) {
                int n7 = 0;
                for (Node node : this.node.getTable().getNodes()) {
                    if (!(node instanceof ContinuousChanceNode)) continue;
                    if (j == n7) {
                        stringArray2[j][i] = InternalNodeTableModel.formatDouble(((ContinuousChanceNode)this.node).getBeta((ContinuousChanceNode)node, n + i));
                    }
                    ++n7;
                }
            }
            stringArray2[n4 - 1][i] = InternalNodeTableModel.formatDouble(((ContinuousChanceNode)this.node).getGamma(n + i));
        }
        return stringArray2;
    }

    private String[][] getFadingDataArray(int n, int n2) throws ExceptionHugin {
        int n3 = this.parents[this.parents.length - 1].length;
        int n4 = this.parents.length - 1;
        String[][] stringArray = new String[1][n2];
        Table table = ((DiscreteChanceNode)this.node).getFadingTable();
        for (int i = 0; i < n2; ++i) {
            stringArray[0][i] = InternalNodeTableModel.formatDouble(table.getDataItem(n + i));
        }
        return stringArray;
    }

    private void saveFadingDataArray(int n) throws ExceptionHugin {
        int n2 = this.parents[this.parents.length - 1].length;
        int n3 = this.parents.length - 1;
        Table table = ((DiscreteChanceNode)this.node).getFadingTable();
        for (int i = 0; i < n; ++i) {
            double d = new Double(this.dataArray[0][i]);
            table.setDataItem(this.tableOffset + i, d);
        }
    }

    private String[][] getExperienceDataArray(int n, int n2) throws ExceptionHugin {
        int n3 = this.node instanceof ContinuousChanceNode ? 1 : this.parents[this.parents.length - 1].length;
        int n4 = this.parents.length - 1;
        String[][] stringArray = new String[1][n2];
        Table table = this.node instanceof DiscreteChanceNode ? ((DiscreteChanceNode)this.node).getExperienceTable() : ((ContinuousChanceNode)this.node).getExperienceTable();
        for (int i = 0; i < n2; ++i) {
            stringArray[0][i] = InternalNodeTableModel.formatDouble(table.getDataItem(n + i));
        }
        return stringArray;
    }

    private void saveExperienceDataArray(int n) throws ExceptionHugin {
        int n2 = this.node instanceof ContinuousChanceNode ? 0 : this.parents[this.parents.length - 1].length;
        int n3 = this.parents.length - 1;
        Table table = this.node instanceof DiscreteChanceNode ? ((DiscreteChanceNode)this.node).getExperienceTable() : ((ContinuousChanceNode)this.node).getExperienceTable();
        for (int i = 0; i < n; ++i) {
            double d = new Double(this.dataArray[0][i]);
            table.setDataItem(this.tableOffset + i, d);
        }
    }

    private void saveDataArray(int n) throws ExceptionHugin {
        if (this.node instanceof ContinuousChanceNode) {
            ContinuousChanceNode continuousChanceNode = (ContinuousChanceNode)this.node;
            int n2 = 0;
            NodeList nodeList = this.node.getTable().getNodes();
            for (Node node : nodeList) {
                if (node == this.node || !(node instanceof ContinuousChanceNode)) continue;
                ++n2;
            }
            int n3 = 2 + n2;
            int n4 = this.parents.length - 1;
            int n5 = this.tableOffset * n3;
            int n6 = this.tableOffset + n;
            Table table = this.node.getTable();
            for (int i = 0; i < n; ++i) {
                double d = new Double(this.dataArray[0][i]);
                continuousChanceNode.setAlpha(d, i + this.tableOffset);
                for (int j = 1; j < n3 - 1; ++j) {
                    int n7 = 0;
                    for (Node node : this.node.getTable().getNodes()) {
                        if (!(node instanceof ContinuousChanceNode)) continue;
                        if (j == n7) {
                            d = new Double(this.dataArray[j][i]);
                            continuousChanceNode.setBeta(d, (ContinuousChanceNode)node, i + this.tableOffset);
                        }
                        ++n7;
                    }
                }
                d = new Double(this.dataArray[n3 - 1][i]);
                continuousChanceNode.setGamma(d, i + this.tableOffset);
            }
        } else {
            int n8 = this.parents[this.parents.length - 1].length;
            int n9 = this.parents.length - 1;
            int n10 = this.tableOffset * n8;
            int n11 = this.tableOffset + n;
            Table table = this.node.getTable();
            for (int i = 0; i < n8; ++i) {
                for (int j = 0; j < n; ++j) {
                    double d = new Double(this.dataArray[i][j]);
                    table.setDataItem(n10 + j * n8 + i, d);
                }
            }
        }
    }

    private String getLabel(Node node) {
        try {
            return node.getLabel().trim().length() > 0 ? node.getLabel() + "(" + node.getName() + ")" : node.getName();
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
            return "";
        }
    }

    public void makeRowHeaderHeaderAndParentArray() {
        try {
            NodeList nodeList = null;
            if (this.node instanceof DiscreteChanceNode || this.node instanceof UtilityNode || this.node instanceof ContinuousChanceNode) {
                nodeList = this.node.getTable().getNodes();
            }
            int n = nodeList != null ? nodeList.size() : 0;
            for (Object object : nodeList) {
                if (object == this.node || !(object instanceof ContinuousChanceNode)) continue;
                --n;
            }
            this.rowHeaderHeaderArray = new String[n];
            this.parents = new String[n][];
            int n2 = 0;
            for (Node node : nodeList) {
                if (node instanceof ContinuousChanceNode) continue;
                this.rowHeaderHeaderArray[n2] = this.getLabel(node);
                if (!(node instanceof DiscreteNode)) continue;
                int n3 = ((DiscreteNode)node).getNumberOfStates();
                this.parents[n2] = new String[n3];
                for (int i = 0; i < n3; ++i) {
                    this.parents[n2][i] = ((DiscreteNode)node).getStateLabel(i);
                }
                ++n2;
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin.getMessage());
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    public void getStateAtLayer(int n, int n2) {
        int n3 = this.parents.length - 1;
        int n4 = 1;
        int n5 = n;
        this.headerStates = new int[n3][n2];
        for (int i = 0; i < n2; ++i) {
            n5 = n + i;
            for (int j = 0; j < n3; ++j) {
                n4 = 1;
                if (j < n3 - 1) {
                    n4 = 1;
                    for (int k = j + 1; k < n3; ++k) {
                        n4 *= this.parents[k].length;
                    }
                    this.headerStates[j][i] = n5 / n4;
                    n5 %= n4;
                    continue;
                }
                n4 = 1;
                this.headerStates[j][i] = n5 / n4;
                n5 %= n4;
            }
        }
    }

    public int getHeaderState(int n, int n2) {
        int n3 = this.parents.length - 1;
        int n4 = 1;
        int n5 = n;
        int n6 = -1;
        for (int i = 0; i < n2; ++i) {
            n4 = 1;
            if (i < n2) {
                n4 = 1;
                for (int j = i + 1; j < n3; ++j) {
                    n4 *= this.parents[j].length;
                }
                n6 = n5 / n4;
                n5 %= n4;
                continue;
            }
            n4 = 1;
            n6 = n5 / n4;
            n5 %= n4;
        }
        return n6;
    }

    public void makeRowHeaderArray() {
        try {
            int n = 0;
            int n2 = 0;
            if (this.tableType == 1) {
                n = ((DiscreteNode)this.node).getNumberOfStates();
            } else if (this.tableType == 4) {
                if (this.node instanceof ContinuousChanceNode) {
                    NodeList nodeList = this.node.getTable().getNodes();
                    for (Node node : nodeList) {
                        if (node == this.node || !(node instanceof ContinuousChanceNode)) continue;
                        ++n2;
                    }
                }
                n = 2 + n2;
            } else {
                n = 1;
            }
            this.rowHeaderArray = new String[n];
            block4: for (int i = 0; i < n; ++i) {
                if (this.tableType == 1) {
                    if (this.node instanceof LabelledDCNode || this.node instanceof BooleanDCNode) {
                        this.rowHeaderArray[i] = ((DiscreteNode)this.node).getStateLabel(i);
                        continue;
                    }
                    if (this.node instanceof NumberedDCNode) {
                        this.rowHeaderArray[i] = HuginGUIUtils.printDouble(((NumberedDCNode)this.node).getStateValue(i));
                        continue;
                    }
                    if (!(this.node instanceof IntervalDCNode)) continue;
                    this.rowHeaderArray[i] = HuginGUIUtils.printInterval(((IntervalDCNode)this.node).getStateValue(i), ((IntervalDCNode)this.node).getStateValue(i + 1));
                    continue;
                }
                if (this.tableType == 2) {
                    this.rowHeaderArray[i] = HuginGUIConstants.get("str_experience_counts");
                    continue;
                }
                if (this.tableType == 3) {
                    this.rowHeaderArray[i] = HuginGUIConstants.get("str_fading_factors");
                    continue;
                }
                if (this.tableType != 4) continue;
                if (i == 0 && n == 2) {
                    this.rowHeaderArray[i] = HuginGUIConstants.get("str_mean");
                    continue;
                }
                if (i == 0 && n > 2) {
                    this.rowHeaderArray[i] = HuginGUIConstants.get("str_intercept");
                    continue;
                }
                if (i == n - 1) {
                    this.rowHeaderArray[i] = HuginGUIConstants.get("str_variance");
                    continue;
                }
                int n3 = i - 1;
                int n4 = 0;
                for (Node node : this.node.getTable().getNodes()) {
                    if (!(node instanceof ContinuousChanceNode) || node == this.node) continue;
                    if (n3 == n4) {
                        this.rowHeaderArray[i] = this.getLabel(node);
                        continue block4;
                    }
                    ++n4;
                }
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    private void setColumnSize(JTable jTable) {
        TableColumn tableColumn = null;
        jTable.getColumnModel().setColumnMargin(5);
        for (int i = 0; i < this.lengthOfTableView; ++i) {
            tableColumn = jTable.getColumnModel().getColumn(i);
            tableColumn.setPreferredWidth(this.cellUnitSize);
            tableColumn.setMaxWidth(this.cellUnitSize);
            tableColumn.setMinWidth(this.cellUnitSize);
        }
    }

    protected String[][] getDataArray(int n, int n2, int n3) {
        String[][] stringArray = null;
        try {
            if (n == 1) {
                stringArray = this.getDataArray(n2, n3);
            } else if (n == 3) {
                stringArray = this.getFadingDataArray(n2, n3);
            } else if (n == 2) {
                stringArray = this.getExperienceDataArray(n2, n3);
            } else if (n == 4) {
                stringArray = this.getContinuousDataArray(n2, n3);
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        return stringArray;
    }

    protected void resizeComponents() {
        int n;
        int n2;
        Dimension dimension = this.getSize();
        int n3 = (int)dimension.getWidth();
        int n4 = (int)dimension.getHeight();
        int n5 = (this.maxWidth - this.cellUnitSize * 2 - 10) / this.cellUnitSize;
        boolean bl = false;
        boolean bl2 = false;
        int n6 = this.numberOfParents * 20;
        int n7 = this.numberOfStates * this.stateTable.getRowHeight() + n6;
        this.scrPanel.setVerticalScrollBarPolicy(21);
        if (n5 < this.tableLength) {
            n7 += 15;
            bl = true;
        }
        if (n7 > this.maxHeight) {
            n5 = (this.maxWidth - this.cellUnitSize * 2 - 25) / this.cellUnitSize;
            this.scrPanel.setVerticalScrollBarPolicy(22);
            bl2 = true;
            n7 = this.maxHeight;
        }
        if (n5 > this.tableLength) {
            n5 = this.tableLength;
        }
        if ((n2 = this.tableLength - n5) >= 0 && n2 < this.tableOffset) {
            this.tableOffset = n2;
        }
        int n8 = this.cellUnitSize * n5;
        int n9 = this.cellUnitSize * 2;
        int n10 = this.numberOfStates * this.table.getRowHeight();
        if (n10 + n6 > n7) {
            n10 = n7 - n6;
        }
        if (bl && n10 > this.maxHeight - n6 - 15) {
            n10 -= 15;
        }
        if (n10 > this.table.getPreferredSize().height) {
            n10 = this.table.getPreferredSize().height;
        }
        int n11 = n8 + n9;
        if (bl2) {
            n11 += 15;
        }
        this.remove(this.bottomPanel);
        this.horizontalScrollPanel.remove(this.hScroll);
        this.bottomPanel.remove(this.horizontalScrollPanel);
        if (bl) {
            this.horizontalScrollPanel.add(this.hScroll);
            this.bottomPanel.add(this.horizontalScrollPanel);
            this.add(this.bottomPanel);
        }
        this.lengthOfTableView = n5;
        this.hScroll.setValues(this.tableOffset, this.lengthOfTableView, 0, this.tableLength);
        int n12 = n = bl ? 15 : 0;
        if (n11 < this.cellUnitSize * 3) {
            n11 = this.cellUnitSize * 3;
        }
        if (n10 < 15) {
            n10 = 15;
        }
        int n13 = bl2 ? 15 : 0;
        this.bottomPanel.setMaximumSize(new Dimension(n11 - n13, 15));
        this.bottomPanel.setPreferredSize(new Dimension(n11 - n13, 15));
        this.scrPanel.setMaximumSize(new Dimension(n11, n10));
        this.scrPanel.setPreferredSize(new Dimension(n11, n10));
    }

    private class TableScrolledListener
    implements AdjustmentListener {
        private TableScrolledListener() {
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            int n = InternalTable.this.table.getEditingRow();
            int n2 = InternalTable.this.table.getEditingColumn();
            if (n >= 0 && n2 >= 0) {
                String string = ((JTextField)InternalTable.this.table.getEditorComponent()).getText();
                InternalTable.this.table.setValueAt(string, n, n2);
            }
            InternalTable.this.table.stopEditing();
            InternalTable.this.tableOffset = adjustmentEvent.getValue();
            InternalTable.this.makeHeader(InternalTable.this.tableOffset, InternalTable.this.lengthOfTableView);
            InternalTable.this.headerPanel.removeAll();
            for (int i = 0; i < InternalTable.this.headerRow.length; ++i) {
                InternalTable.this.headerPanel.add(InternalTable.this.headerRow[i]);
            }
            InternalTable.this.dataArray = InternalTable.this.getDataArray(InternalTable.this.tableType, InternalTable.this.tableOffset, InternalTable.this.lengthOfTableView);
            InternalTable.this.NDM.updateModel(InternalTable.this.dataArray);
            InternalTable.this.setColumnSize(InternalTable.this.table);
            InternalTable.this.validate();
        }
    }

    private class TabListener
    implements PropertyChangeListener {
        private TabListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            int n = InternalTable.this.table.getSelectedRow();
            int n2 = InternalTable.this.table.getSelectedColumn() + 1;
            if (n2 >= InternalTable.this.table.getColumnCount()) {
                if (InternalTable.this.hScroll.getMaximum() > InternalTable.this.table.getColumnCount()) {
                    if (InternalTable.this.hScroll.getValue() == InternalTable.this.hScroll.getMaximum() - InternalTable.this.hScroll.getVisibleAmount()) {
                        InternalTable.this.hScroll.setValue(0);
                        n2 = 0;
                        ++n;
                    } else {
                        InternalTable.this.hScroll.setValue(InternalTable.this.hScroll.getValue() + 1);
                        --n2;
                    }
                } else {
                    n2 = 0;
                    ++n;
                }
            }
            if (n >= InternalTable.this.table.getRowCount()) {
                if (InternalTable.this.hScroll.getMaximum() > InternalTable.this.table.getColumnCount()) {
                    InternalTable.this.hScroll.setValue(0);
                    n2 = 0;
                }
                n = 0;
            }
            InternalTable.this.table.requestFocus();
            InternalTable.this.table.setRowSelectionInterval(n, n);
            InternalTable.this.table.setColumnSelectionInterval(n2, n2);
        }
    }

    private class TableResizedListener
    extends ComponentAdapter {
        private TableResizedListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            InternalTable.this.resizeComponents();
            InternalTable.this.makeHeader(InternalTable.this.tableOffset, InternalTable.this.lengthOfTableView);
            InternalTable.this.NDM.updateModel(InternalTable.this.dataArray);
            InternalTable.this.setColumnSize(InternalTable.this.table);
            InternalTable.this.validate();
            InternalTable.this.repaint();
        }
    }

    private class TableChangedListener
    implements TableModelListener {
        private TableChangedListener() {
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            try {
                if (InternalTable.this.tableType == 1 || InternalTable.this.tableType == 4) {
                    InternalTable.this.saveDataArray(InternalTable.this.lengthOfTableView);
                } else if (InternalTable.this.tableType == 3) {
                    InternalTable.this.saveFadingDataArray(InternalTable.this.lengthOfTableView);
                } else if (InternalTable.this.tableType == 2) {
                    InternalTable.this.saveExperienceDataArray(InternalTable.this.lengthOfTableView);
                }
            }
            catch (Exception exception) {
                new HuginGUIError(exception);
            }
        }
    }
}

