/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.Clique;
import COM.hugin.HGUI.CliqueLink;
import COM.hugin.HGUI.JunctionTree;
import COM.hugin.HGUI.zoom.ZoomableComponent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;

public class JunctionTreeLayout
implements LayoutManager,
ZoomableComponent {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    private int initial_vgap = 40;
    private int initial_hgap = 30;
    private int vgap = 40;
    private int hgap = 30;
    private int align = 1;
    private int[] levelWidth = null;
    private int[] levelHeight = null;
    private double scaleFactor = 1.0;
    private int rootDepth = 0;

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public void setScaleFactor(double d) {
        this.scaleFactor = d;
        this.vgap = (int)Math.rint((double)this.initial_vgap * d);
        this.hgap = (int)Math.rint((double)this.initial_hgap * d);
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n;
            int n2 = 100;
            int n3 = 100;
            if (container instanceof JunctionTree) {
                Clique clique = ((JunctionTree)container).getModel().getRoot();
                n = this.getDepth(clique);
                if (this.levelWidth == null || n != this.rootDepth) {
                    this.levelWidth = new int[n];
                    this.levelHeight = new int[n];
                    this.rootDepth = n;
                }
                for (int i = 0; i < this.levelWidth.length; ++i) {
                    this.levelHeight[i] = 0;
                    this.levelWidth[i] = 0;
                }
                n2 = this.getTreeHeight(clique, 0);
                n3 = this.getTreeWidth(clique);
            }
            int n4 = 0;
            for (n = 0; n < this.levelWidth.length; ++n) {
                if (this.levelWidth[n] <= n4) continue;
                n4 = this.levelWidth[n];
            }
            if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
                n2 += 8;
            }
            return new Dimension(n4, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            return new Dimension(100, 100);
        }
    }

    private int getTreeHeight(Clique clique, int n) {
        int n2 = clique.getPreferredSize().height;
        this.levelHeight[n] = Math.max(this.levelHeight[n], n2);
        if (clique.getChildren() == null || clique.getChildren().size() == 0) {
            return n2;
        }
        int n3 = 0;
        for (Clique clique2 : clique.getChildren()) {
            n3 = Math.max(n3, this.getTreeHeight(clique2, n + 1));
        }
        return n2 += this.vgap + n3;
    }

    private int getTreeWidth(Clique clique) {
        switch (this.align) {
            case 0: {
                return this.getLeftAlignedTreeWidth(clique, 0, 0, 0);
            }
            case 1: {
                return this.getCenterAlignedTreeWidth(clique, 0, 0, 0);
            }
            case 2: {
                return this.getRightAlignedTreeWidth(clique, 0, 0, 0);
            }
        }
        return 0;
    }

    private int getLeftAlignedTreeWidth(Clique clique, int n, int n2, int n3) {
        int n4;
        int n5 = n4 = this.levelWidth[n3] > 0 ? this.levelWidth[n3] + this.hgap : 0;
        if (n < n4) {
            n = n4;
        }
        int n6 = clique.getPreferredSize().width + n;
        this.levelWidth[n3] = Math.max(this.levelWidth[n3], n6);
        if (clique.getChildren() == null || clique.getChildren().size() == 0) {
            return n6;
        }
        n2 += this.levelHeight[n3] + this.vgap;
        for (Clique clique2 : clique.getChildren()) {
            n6 = Math.max(n6, this.getLeftAlignedTreeWidth(clique2, n, n2, n3 + 1));
            n = (int)clique2.getPreferredSize().getWidth() + this.hgap;
        }
        return n6;
    }

    private int getCenterAlignedTreeWidth(Clique clique, int n, int n2, int n3) {
        int n4;
        int n5 = n4 = this.levelWidth[n3] > 0 ? this.levelWidth[n3] + this.hgap : 0;
        if (n < n4) {
            n = n4;
        }
        if (n4 == 0) {
            n = 0;
        }
        n = n4;
        int n6 = clique.getPreferredSize().width + n;
        if (clique.getChildren() == null || clique.getChildren().size() == 0) {
            this.levelWidth[n3] = n6;
            clique.setBounds(n, n2, clique.getPreferredSize().width, clique.getPreferredSize().height);
            return n6;
        }
        int n7 = n;
        int n8 = n2;
        n2 += this.levelHeight[n3] + this.vgap;
        for (Clique clique2 : clique.getChildren()) {
            n6 = Math.max(n6, this.getCenterAlignedTreeWidth(clique2, n, n2, n3 + 1));
            int n9 = (int)((double)n + ((double)n6 - ((double)n + clique2.getPreferredSize().getWidth())) / 2.0) - n;
            n = (int)clique2.getPreferredSize().getWidth() + this.hgap + n9;
        }
        n = this.getSubTreeCenter(clique) - clique.getPreferredSize().width / 2;
        if (n < n4) {
            this.translate(clique, n4 - n, n3);
            clique.setBounds(n4, n8, clique.getPreferredSize().width, clique.getPreferredSize().height);
            this.levelWidth[n3] = n4 + clique.getPreferredSize().width;
        } else {
            clique.setBounds(n, n8, clique.getPreferredSize().width, clique.getPreferredSize().height);
            this.levelWidth[n3] = n + clique.getPreferredSize().width;
        }
        return n6;
    }

    private int getSubTreeCenter(Clique clique) {
        if (clique.getChildren() == null || clique.getChildren().size() == 0) {
            return clique.getX() + clique.getPreferredSize().width / 2;
        }
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        for (Clique clique2 : clique.getChildren()) {
            n = Math.min(n, clique2.getX());
            n2 = Math.max(n2, clique2.getX() + clique2.getPreferredSize().width);
        }
        return (n + n2) / 2;
    }

    private void translate(Clique clique, int n, int n2) {
        Rectangle rectangle = clique.getBounds();
        clique.setLocation((int)rectangle.getX() + n, (int)rectangle.getY());
        this.levelWidth[n2] = (int)rectangle.getX() + (int)rectangle.getWidth() + n + this.hgap;
        if (clique.getChildren() == null || clique.getChildren().size() == 0) {
            return;
        }
        for (Clique clique2 : clique.getChildren()) {
            this.translate(clique2, n, n2 + 1);
        }
    }

    private int getRightAlignedTreeWidth(Clique clique, int n, int n2, int n3) {
        return this.getLeftAlignedTreeWidth(clique, n, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            this.preferredLayoutSize(container);
        }
    }

    private int setLeftAlignedBounds(Clique clique, int n, int n2, int n3) {
        int n4;
        int n5 = n4 = this.levelWidth[n3] > 0 ? this.levelWidth[n3] + this.hgap : 0;
        if (n < n4) {
            n = n4;
        }
        this.levelWidth[n3] = Math.max(this.levelWidth[n3], clique.getPreferredSize().width + n);
        Dimension dimension = clique.getPreferredSize();
        clique.setBounds(n, n2, dimension.width, dimension.height);
        CliqueLink cliqueLink = clique.getLink();
        if (cliqueLink != null) {
            Rectangle rectangle = cliqueLink.parent.getBounds();
            int n6 = (int)(rectangle.getX() + rectangle.getWidth() / 2.0);
            int n7 = (int)(rectangle.getY() + rectangle.getHeight());
            cliqueLink.setBounds(n6, n7, 1 + (n + dimension.width / 2) - n6, this.vgap);
        }
        if (clique.getChildren() == null || clique.getChildren().size() == 0) {
            return n + (int)dimension.getWidth();
        }
        n2 += this.levelHeight[n3] + this.vgap;
        for (Clique clique2 : clique.getChildren()) {
            this.setLeftAlignedBounds(clique2, n, n2, n3 + 1);
            n += clique2.getPreferredSize().width + this.hgap;
        }
        return n - this.hgap;
    }

    private int getDepth(Clique clique) {
        if (clique.getChildren() == null || clique.getChildren().size() == 0) {
            return 1;
        }
        int n = 0;
        for (Clique clique2 : clique.getChildren()) {
            n = Math.max(n, this.getDepth(clique2));
        }
        return n + 1;
    }

    private void getLevelWidths(Clique clique, int n, int n2) {
        int n3 = clique.getPreferredSize().width + n;
        if (clique.getChildren() == null || clique.getChildren().size() == 0) {
            return;
        }
        for (Clique clique2 : clique.getChildren()) {
            this.getLevelWidths(clique2, n, n2 + 1);
            n = (int)clique2.getPreferredSize().getWidth() + this.hgap;
        }
    }
}

