/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.Domain;
import COM.hugin.HGUI.HStroke;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.Link;
import COM.hugin.HGUI.Node;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;

public class LinkConstraint
extends Link {
    private static final int ARROW_CONSTRAINT = 1;
    private static final int NO_ARROW_CONSTRAINT = 2;
    private static final int LINK_CONSTRAINT = 3;
    private static final int NO_LINK_CONSTRAINT = 4;
    private int type;
    private static final int CROSS_LEN = 5;
    private double crossHeight;

    protected int getType() {
        return this.type;
    }

    public LinkConstraint(int n, Node node, Node node2, double d) {
        super(node, node2, d);
        this.type = n;
        if (n == 3 || n == 4) {
            this.isDirected(false);
        }
    }

    public void paint(Graphics2D graphics2D) {
        if (this.isVisible()) {
            super.paint(graphics2D);
            if (this.type == 2 || this.type == 4) {
                this.drawCross(graphics2D);
            }
        }
    }

    public void print(Graphics graphics, Point point) {
        if (!this.isVisible() || this.x1 == this.x2 && this.y1 == this.y2) {
            return;
        }
        super.print(graphics, point);
        if (this.type == 2 || this.type == 4) {
            this.printCross(graphics, point);
        }
    }

    private void printCross(Graphics graphics, Point point) {
        int n;
        double d = (this.x1 + this.x2) / 2.0f;
        double d2 = (this.y1 + this.y2) / 2.0f;
        double d3 = this.getLength();
        double d4 = (double)(this.x1 - this.x2) / d3;
        double d5 = (double)(this.y1 - this.y2) / d3;
        double d6 = this.getScaleFactor();
        double d7 = Math.sin(1.0471975511965976) / Math.sin(0.5235987755982988);
        double d8 = -d5 * d7;
        double d9 = d4 * d7;
        double d10 = d6 * 5.0 * (d4 + d8);
        double d11 = d6 * 5.0 * (d5 + d9);
        int n2 = this.getCrossStrokeWidth();
        double d12 = this.getLength(d10, d11);
        double d13 = -d11 / d12;
        double d14 = d10 / d12;
        graphics.setColor(Color.red);
        for (n = -n2 / 2; n <= n2 / 2; ++n) {
            graphics.drawLine((int)((double)point.x + d + d10 + (double)n * d13), (int)((double)point.y + d2 + d11 + (double)n * d14), (int)((double)point.x + d - d10 + (double)n * d13), (int)((double)point.y + d2 - d11 + (double)n * d14));
        }
        d10 = d6 * 5.0 * (-d4 + d8);
        d11 = d6 * 5.0 * (-d5 + d9);
        d13 = -d11 / d12;
        d14 = d10 / d12;
        for (n = -n2 / 2; n <= n2 / 2; ++n) {
            graphics.drawLine((int)((double)point.x + d + d10 + (double)n * d13), (int)((double)point.y + d2 + d11 + (double)n * d14), (int)((double)point.x + d - d10 + (double)n * d13), (int)((double)point.y + d2 - d11 + (double)n * d14));
        }
    }

    private void drawCross(Graphics2D graphics2D) {
        double d = (this.x1 + this.x2) / 2.0f;
        double d2 = (this.y1 + this.y2) / 2.0f;
        double d3 = this.getLength();
        double d4 = (double)(this.x1 - this.x2) / d3;
        double d5 = (double)(this.y1 - this.y2) / d3;
        double d6 = this.getScaleFactor();
        double d7 = Math.sin(1.0471975511965976) / Math.sin(0.5235987755982988);
        double d8 = -d5 * d7;
        double d9 = d4 * d7;
        double d10 = d6 * 5.0 * (d4 + d8);
        double d11 = d6 * 5.0 * (d5 + d9);
        graphics2D.setPaint(Color.red);
        graphics2D.setStroke(this.getCrossStroke());
        graphics2D.drawLine((int)(d + d10), (int)(d2 + d11), (int)(d - d10), (int)(d2 - d11));
        d10 = d6 * 5.0 * (-d4 + d8);
        d11 = d6 * 5.0 * (-d5 + d9);
        graphics2D.drawLine((int)(d + d10), (int)(d2 + d11), (int)(d - d10), (int)(d2 - d11));
        this.crossHeight = 2.0 * this.getLength(d10, d11) * Math.sin(1.0471975511965976);
    }

    private double getLength() {
        return this.getLength(this.x1 - this.x2, this.y1 - this.y2);
    }

    private double getLength(double d, double d2) {
        return Math.sqrt(d * d + d2 * d2);
    }

    private Stroke getCrossStroke() {
        Stroke stroke = HStroke.HILIT_STROKE;
        int n = (int)Math.rint(this.getScaleFactor() * (double)((BasicStroke)stroke).getLineWidth());
        if (n <= 1) {
            n = 2;
        } else if (n > 9) {
            n = 9;
        }
        return HStroke.STROKES[n];
    }

    private int getCrossStrokeWidth() {
        Stroke stroke = HStroke.HILIT_STROKE;
        int n = (int)Math.rint(this.getScaleFactor() * (double)((BasicStroke)stroke).getLineWidth());
        if (n <= 1) {
            n = 2;
        } else if (n > 9) {
            n = 9;
        }
        return n;
    }

    protected Rectangle kill() {
        try {
            this.parent.getAPINode().setEdgeConstraint(this.child.getAPINode(), Domain.H_CONSTRAINT_NONE);
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        return this.getBoundingBox();
    }

    protected Rectangle getBoundingBox() {
        if (this.type == 1 || this.type == 3) {
            return super.getBoundingBox();
        }
        int n = (int)Math.rint(this.getScaleFactor() * 4.0);
        int n2 = (int)Math.min(this.x1, this.x2);
        int n3 = (int)Math.min(this.y1, this.y2);
        int n4 = (int)Math.max((double)Math.abs(this.x1 - this.x2), this.crossHeight);
        int n5 = (int)Math.max((double)Math.abs(this.y1 - this.y2), this.crossHeight);
        int n6 = (int)Math.max((double)(2 * n), this.crossHeight / 2.0);
        int n7 = 2 * n6;
        return new Rectangle(n2 - n7, n3 - n7, n4 + n7, n5 + n7);
    }

    public String getDescription() {
        switch (this.type) {
            case 1: {
                return HuginGUIConstants.get("str_directed_link_required_from_ARG0_to_ARG1", new String[]{this.parent.name, this.child.name});
            }
            case 2: {
                return HuginGUIConstants.get("str_directed_link_forbidden_from_ARG0_to_ARG1", new String[]{this.parent.name, this.child.name});
            }
            case 3: {
                return HuginGUIConstants.get("str_link_required_between_ARG0_and_ARG1", new String[]{this.parent.name, this.child.name});
            }
            case 4: {
                return HuginGUIConstants.get("str_link_forbidden_between_ARG0_and_ARG1", new String[]{this.parent.name, this.child.name});
            }
        }
        return "";
    }

    public boolean equals(Object object) {
        if (!(object instanceof LinkConstraint) || this.type != ((LinkConstraint)object).getType() || this.parent != ((LinkConstraint)object).parent) {
            return false;
        }
        return this.child == ((LinkConstraint)object).child;
    }
}

