/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.Graph;
import COM.hugin.HGUI.Item;
import COM.hugin.HGUI.Line;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleLineGraph
extends Graph {
    private final int NOSELECTION = -1;
    int topLine = -1;
    Vector<Line> lines = new Vector();

    public MultipleLineGraph(String string, int n, int n2) {
        super(string, n, n2);
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.lines.size() == 1) {
            this.topLine = 0;
        }
        if (this.topLine != -1 && this.topLine >= 0 && this.topLine < this.lines.size()) {
            Line line = this.lines.elementAt(this.topLine);
            this.paintLine(line, graphics2D, false);
            if (line.getUpperBound() != null && line.getLowerBound() != null) {
                this.paintLine(line.getUpperBound(), graphics2D, true);
                this.paintLine(line.getLowerBound(), graphics2D, true);
            }
        } else {
            int n = 0;
            n = this.lines.size() > 10 ? 10 : this.lines.size();
            for (int i = 0; i < n; ++i) {
                Line line = this.lines.get(i);
                this.paintLine(line, graphics2D, false);
            }
        }
    }

    public void paint2(Graphics graphics) {
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        for (Line line : this.lines) {
            int n;
            int n2;
            Item item;
            int n3 = (this.right - this.left) / (line.items.size() - 1);
            int n4 = this.left;
            Color color = line.color;
            graphics2D.setColor(color);
            GeneralPath generalPath = new GeneralPath();
            for (int i = 0; i < line.items.size() - 1; ++i) {
                BasicStroke basicStroke;
                item = line.items.elementAt(i);
                n2 = this.bottom - (item.x - this.min) * (this.bottom - this.top) / (this.max - this.min);
                n = this.left + (item.y + this.min) * (this.right - this.left) / (this.max - this.min);
                Item item2 = line.items.elementAt(i + 1);
                int n5 = this.bottom - (item2.x - this.min) * (this.bottom - this.top) / (this.max - this.min);
                int n6 = this.left + (item2.y + this.min) * (this.right - this.left) / (this.max - this.min);
                if (line.isSensitivityFunction()) {
                    basicStroke = new BasicStroke(2.0f, 0, 2);
                    graphics2D.setStroke(basicStroke);
                    if (i == 0) {
                        generalPath.moveTo(n, n2);
                        generalPath.lineTo(n6, n5);
                    } else {
                        generalPath.lineTo(n6, n5);
                    }
                } else {
                    basicStroke = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{8.0f, 3.0f, 2.0f, 3.0f}, 0.0f);
                    graphics2D.setStroke(basicStroke);
                    if (i == 0) {
                        generalPath.moveTo(n, n2);
                        generalPath.lineTo(n6, n5);
                    } else {
                        generalPath.lineTo(n6, n5);
                    }
                }
                graphics2D.setColor(color);
            }
            graphics2D.draw(generalPath);
            BasicStroke basicStroke = new BasicStroke(1.0f, 0, 2);
            graphics2D.setStroke(basicStroke);
            item = line.point;
            if (item == null) continue;
            graphics2D.setColor(Color.gray);
            n2 = this.bottom - (item.x - this.min) * (this.bottom - this.top) / (this.max - this.min);
            n = this.left + (item.y + this.min) * (this.right - this.left) / (this.max - this.min);
            graphics2D.fillOval(n - 2, n2 - 2, 4, 4);
            graphics2D.drawLine(n, n2, n, this.bottom);
            graphics2D.drawLine(this.left, n2, n, n2);
        }
    }

    public void paintLine(Line line, Graphics2D graphics2D, boolean bl) {
        int n;
        int n2;
        Item item;
        int n3 = (this.right - this.left) / (line.items.size() - 1);
        int n4 = this.left;
        Color color = line.color;
        graphics2D.setColor(color);
        GeneralPath generalPath = new GeneralPath();
        for (int i = 0; i < line.items.size() - 1; ++i) {
            BasicStroke basicStroke;
            item = line.items.elementAt(i);
            n2 = this.bottom - (item.x - this.min) * (this.bottom - this.top) / (this.max - this.min);
            n = this.left + (item.y + this.min) * (this.right - this.left) / (this.max - this.min);
            Item item2 = line.items.elementAt(i + 1);
            int n5 = this.bottom - (item2.x - this.min) * (this.bottom - this.top) / (this.max - this.min);
            int n6 = this.left + (item2.y + this.min) * (this.right - this.left) / (this.max - this.min);
            if (!bl) {
                basicStroke = new BasicStroke(2.0f, 0, 2);
                graphics2D.setStroke(basicStroke);
                if (i == 0) {
                    generalPath.moveTo(n, n2);
                    generalPath.lineTo(n6, n5);
                } else {
                    generalPath.lineTo(n6, n5);
                }
            } else {
                basicStroke = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{8.0f, 3.0f, 2.0f, 3.0f}, 0.0f);
                graphics2D.setStroke(basicStroke);
                if (i == 0) {
                    generalPath.moveTo(n, n2);
                    generalPath.lineTo(n6, n5);
                } else {
                    generalPath.lineTo(n6, n5);
                }
            }
            graphics2D.setColor(color);
        }
        graphics2D.draw(generalPath);
        BasicStroke basicStroke = new BasicStroke(1.0f, 0, 2);
        graphics2D.setStroke(basicStroke);
        item = line.point;
        if (item != null) {
            graphics2D.setColor(Color.gray);
            n2 = this.bottom - (item.x - this.min) * (this.bottom - this.top) / (this.max - this.min);
            n = this.left + (item.y + this.min) * (this.right - this.left) / (this.max - this.min);
            graphics2D.fillOval(n - 2, n2 - 2, 4, 4);
            graphics2D.drawLine(n, n2, n, this.bottom);
            graphics2D.drawLine(this.left, n2, n, n2);
        }
    }

    public void selectLine(int n) {
        this.topLine = n;
        this.repaint();
    }

    public boolean hasSelectedLine() {
        return this.topLine != -1;
    }

    public void unselectLine() {
        this.topLine = -1;
        this.repaint();
    }

    public int addLine(String string, Color color) {
        Line line = new Line(string, color);
        this.lines.addElement(line);
        return this.lines.size() - 1;
    }

    public void addItem(Double d, Double d2, int n) {
        Line line = this.lines.elementAt(n);
        line.addItem(d, d2);
    }

    public void addPoint(Double d, Double d2, int n) {
        Line line = this.lines.elementAt(n);
        line.addPoint(d, d2);
    }

    public void removeLines() {
        this.lines.removeAllElements();
        this.topLine = -1;
    }

    public Vector<Line> getLines() {
        return this.lines;
    }

    @Override
    public String toString() {
        String string = "";
        for (Line line : this.lines) {
            string = string + line.title + "  " + line.color + "\n";
        }
        return string;
    }

    public Line getLine(int n) {
        if (this.lines.size() > n) {
            return this.lines.elementAt(n);
        }
        return null;
    }

    public boolean hasLines() {
        return this.lines.size() > 0;
    }

    public int getNumberOfLines() {
        return this.lines.size();
    }
}

